
#include <windows.h>
#include <mmsystem.h>
#include <tchar.h>
#include "3DS.h"

#define RELEASE(obj) if(obj) { obj->Release(); obj = NULL; }
#define DELETE(obj) if(obj) { delete obj; obj = NULL; }
#define DELETE_ARRAY(obj) if(obj) { delete [] obj; obj = NULL; }



typedef float vec_t;

typedef float st_t[2];

typedef vec_t vec2_t[3];
typedef vec_t vec3_t[3];
typedef vec_t vec4_t[4];


typedef struct {
	vec3_t	verts[3];
	vec3_t	normals[3];
	st_t	texcoords[3];
} triangle_t;



extern "C" {
	extern char* GLPath;
}


//////////////////////////////////////////////////////////////////////////////
//
// C3DS
//

HRESULT C3DS::Initialize()
{
   ZeroMemory(&m_model,sizeof(m_model));
   m_scale = 1.0f;
   m_cull = true;
   return S_OK;
};

HRESULT C3DS::SetProperty(LPCSTR szItem, LPCSTR szValue)
{
   if( stricmp(szItem,"FILENAME")==0 ) {
      strcpy( m_szModelFilename, szValue );
      return S_OK;
   }
   if( stricmp(szItem,"TEXTURE")==0 ) {
      strcpy( m_szTextureFilename, szValue );
      return S_OK;
   };

   if( stricmp(szItem,"SKIN")==0 ) {//bna++
      strcpy( m_szTextureFilename, szValue );
      return S_OK;
   };

   if( stricmp(szItem,"CULL")==0 ) {
      m_cull = (_toupper(szValue[0])=='Y');
      return S_OK;
   };
   if( stricmp(szItem,"SCALE")==0 ) {
      m_scale = (float)atof(szValue);
      return S_OK;
   };
   return E_INVALIDARG;
};

HRESULT C3DS::Create(char*fn)
{
   CHAR szFilename[MAX_PATH];

   FILE* f;
   lstrcpy( szFilename, fn);
 //  strcat( szFilename, m_szModelFilename );

   //if( f.Open(szFilename)==FALSE )
//	   return E_FAIL;
   sprintf(szFilename,"%s\\%s",GLPath,fn);//try default gl folder	


   if( (f = fopen(szFilename, "rb" )) == NULL )
	   return E_FAIL;

   long i;

   m_TotalNumObjects = -1;
   m_TotalNumFaces = 0;
   m_TotalNumVerts = 0;
   m_TotalNumCoords = 0;
   m_TotalNumIndices = 0;
   m_NumMaps = 0;
   m_NumMaterials = 0;   

   material_list = new LPSTR[MAX_NUM_3DS_TEXTURES];
   for( i=0; i<MAX_NUM_3DS_TEXTURES; i++) {
      material_list[i] = new char[MAX_NAME_LENGTH];
      material_list[i][0] = '\0';
   }

   mapnames = new LPSTR[MAX_NUM_3DS_TEXTURES];
   for( i=0; i<MAX_NUM_3DS_TEXTURES; i++) {
      mapnames[i] = new char[MAX_NAME_LENGTH];
      mapnames[i][0] = '\0';
   }

   bool done = false;
   while( !done ) {
      bool bDataProcessed  = false;

      // Get next chunk
      unsigned short   command;
      //if( f.Read(&command, sizeof(command))==FALSE ) {
      if(fread(&command, 1, sizeof(command),f)==FALSE ) {
         done = true;
         break;
      }

	if (command == 0)//bna
		break;

      long data_length;
      //f.Read(&data_length, sizeof(data_length));
	  fread(&data_length, 1, sizeof(data_length),f);

      data_length -= 6;



      switch( command ) {
         
         //////////////////////////////////////////////
         // COMMANDS FOUND AT START OF 3DS FILE
         
         case MAIN3DS:
            bDataProcessed = true;   
            break;

         case M3DS_VERSION:
            Process3DSVersion(f);
            bDataProcessed = true;
            break;

         case EDIT3DS:
            bDataProcessed = true;   
            break;

         case MESH_VERSION:
            break;

         //////////////////////////////////////////////
         // MATERIAL AND TEXTURE DEFINTION COMMANDS
         // This block of commands is repeated for each material / texture

         case EDIT_MATERIAL: // start of material definition 
            bDataProcessed = true;
            break;

         case MAT_NAME01:
            AddMaterialName(f);
            bDataProcessed = true;
            break;

         case MATERIAL_AMBIENT:
            break;
         case MATERIAL_DIFFUSE:
            break;
         case MATERIAL_SPECULAR:
            break;
         case MATERIAL_SHININESS:
            break;
         case MATERIAL_SHINE_STRENGTH:
            break;
         case TRANS_PERCENT:
            break;
         case TRANS_FALLOFF_PERCENT:
            break;
         case REFLECTION_BLUR_PER:
            break;
         case RENDER_TYPE:
            break;
         case SELF_ILLUM:
            break;
         case IN_TRANC:
            break;
         case SOFTEN:
            break;
         case WIRE_THICKNESS:
            break;
         case TEXTURE_MAP:
            bDataProcessed = true;
            break;
         case INT_PERCENTAGE:
            break;

         case MAPPING_NAME:
            AddMapName(f);
            bDataProcessed = true;
            break;
         
         case MAPPING_PARAMETERS:
            break;
         case BLUR_PERCENTAGE:
            break;

         /////////////////////////////////////////////

         case MASTER_SCALE:
            ProcessMasterScale(f);
            bDataProcessed = true;
            break;      

         /////////////////////////////////////////////

         // 3D OBJECT DATA
         // This block of commands is repeated for each 3ds object
         // Note a 3ds model may contain just one, or many 3ds objects
         // Each object contains a vert, face, and texture co-ordinate list.

         case NAMED_OBJECT: // start of a 3d object chunk
            
            // Read name and store it
            m_TotalNumObjects++;
            if( m_TotalNumObjects >= MAX_NUM_3DS_OBJECTS )
				return E_FAIL;

            // Initialise object  
            m_ObjList[m_TotalNumObjects].verts = NULL;
            m_ObjList[m_TotalNumObjects].texverts = NULL;
            m_ObjList[m_TotalNumObjects].faces = NULL;
            m_ObjList[m_TotalNumObjects].numverts = 0;
            m_ObjList[m_TotalNumObjects].numtexverts = 0;
            m_ObjList[m_TotalNumObjects].numfaces = 0;
            m_ObjList[m_TotalNumObjects].texturename[0] = 0;
			

            for( i=0; i<MAX_NAME_LENGTH; i++ ) {
               char c;
               //f.Read(&c, 1); 
			   fread(&c, 1, 1,f);
               m_ObjList[m_TotalNumObjects].object_name[i] = c;
               data_length--;         
               if( c=='\0' ) break;
            }
            bDataProcessed = true;
            break;
         
         case TRIANGLE_MESH:  // start of mesh data chunks
            bDataProcessed = true;   
            break;

         case TRIANGLE_VERTEXLIST:  // vertex list
            if( ProcessVertexData(f) ) {
               bDataProcessed = true;
            }
            else {
               // Too many verts in model
               return E_FAIL;
            }
            break;

         case TRIANGLE_MAPPINGCOORS: // texture mapping co-ordinates
            ProcessMappingData(f);
            bDataProcessed = true;
            break;

         case TRI_LOCAL:
            ProcessTriLocalData(f);
            bDataProcessed = true;   
            break;

         case TRIANGLE_FACELIST:  // face list
            if( ProcessFaceData(f) == TRUE ) {
               bDataProcessed = true;
            }
            else {
               // Too many faces in model
               return FALSE;
            }
            break;
         
         case TRIANGLE_MATERIAL: // texture info for faces
            ProcessTriangleMaterialData(f);
            bDataProcessed = true;
            break;

         case TRIANGLE_SMOOTH:
            ProcessTriSmoothData(f);
            bDataProcessed = true;   
            break;

         case TRIANGLE_MAPPINGSTANDARD:
            break;   

         case TRIANGLE_VERTEXOPTIONS:
            break;
   
         case TRI_VISIBLE:
            break;

         /////////////////////////////////////////////
         // ANIMATION DATA
         // This chunk and all keyframe sub chunks are being ignored in this sample
         
         case KEYFRAME:
            break;
      
      } // end switch

      if( !bDataProcessed ) {
         // Command was unrecognised, so skip it's data

         //f.Seek(data_length, FILE_CURRENT);
		 fseek( f, data_length, SEEK_CUR);

      }

	  //long dwPosition = f.GetPosition();
	  long dwPosition = ftell( f );
	  if (dwPosition < 0)
		  break;
	  command = 0;

   } // end while
   m_TotalNumObjects++;
 
   //f.Close();
   fclose( f );



   // Transfer data from m_ObjList list into the model structure
   // and allocate memory dynamically for model

   // Initialise model
   m_model.Objects = new OBJECT3DS[m_TotalNumObjects];
   m_model.NumObjects = 0;   
   for( i=0; i<m_TotalNumObjects; i++) {
      // Initialise object  
      m_model.Objects[i].verts    = NULL;
      m_model.Objects[i].faces    = NULL;
      m_model.Objects[i].texverts = NULL;
      m_model.Objects[i].numverts    = 0;
      m_model.Objects[i].numfaces    = 0;
      m_model.Objects[i].numtexverts = 0;
      m_model.Objects[i].texturename[0] = 0;
      m_model.Objects[i].object_name[0] = 0;

      strcpy(m_model.Objects[i].object_name, m_ObjList[i].object_name);

      m_model.Objects[i].verts = new VERT3DS[m_ObjList[i].numverts];
      m_model.Objects[i].numverts = m_ObjList[i].numverts;
      for( long v = 0; v < m_ObjList[i].numverts; v++ ) {
         m_model.Objects[i].verts[v].x = m_ObjList[i].verts[v].x;
         m_model.Objects[i].verts[v].y = m_ObjList[i].verts[v].y;
         m_model.Objects[i].verts[v].z = m_ObjList[i].verts[v].z;
      }
      
      m_model.Objects[i].faces = new FACE3DS[m_ObjList[i].numfaces];
      m_model.Objects[i].numfaces = m_ObjList[i].numfaces;      
      for( long fidx = 0; fidx < m_ObjList[i].numfaces; fidx++ ) {
         // First three are indices of triangles
         m_model.Objects[i].faces[fidx].indices[0] = m_ObjList[i].faces[fidx].indices[0];
         m_model.Objects[i].faces[fidx].indices[1] = m_ObjList[i].faces[fidx].indices[1];
         m_model.Objects[i].faces[fidx].indices[2] = m_ObjList[i].faces[fidx].indices[2];

         // This one contains 3ds flags
         m_model.Objects[i].faces[fidx].indices[3] = m_ObjList[i].faces[fidx].indices[3];
         m_model.Objects[i].faces[fidx].tex = m_ObjList[i].faces[fidx].tex;
      }
      
      m_model.Objects[i].texverts = new MAPPING_COORDINATES[m_ObjList[i].numtexverts];
      m_model.Objects[i].numtexverts = m_ObjList[i].numtexverts;
      for( long t = 0; t < m_ObjList[i].numtexverts; t++ ) {
         m_model.Objects[i].texverts[t].x = m_ObjList[i].texverts[t].x;
         m_model.Objects[i].texverts[t].y = m_ObjList[i].texverts[t].y;
      }
   }
   m_model.NumObjects  = m_TotalNumObjects;
   m_model.NumTextures = m_NumMaps;

   return S_OK;
}

//-----------------------------------------------------------------------------

long C3DS::GetNumVerts(long numObj)
{
	return (m_model.Objects[numObj].numverts);
}

long C3DS::GetNumFaces(long numObj)
{
	return (m_model.Objects[numObj].numfaces);
}

long C3DS::GetNumTexverts(long numObj)
{
	return (m_model.Objects[numObj].numtexverts);
}

long C3DS::GetVertsXYZ(long numObj, long v, float *vertsx, float *vertsy, float *vertsz)
{
    *vertsx = m_model.Objects[numObj].verts[v].x;
    *vertsy = m_model.Objects[numObj].verts[v].y;
    *vertsz = m_model.Objects[numObj].verts[v].z;
	return 0;
}
//-----------------------------------------------------------------------------



HRESULT C3DS::Done()
{
   for( long i=0; i<m_model.NumObjects; i++ ) {
      DELETE_ARRAY(m_model.Objects[i].faces);
      DELETE_ARRAY(m_model.Objects[i].verts);
   }
   DELETE_ARRAY(m_model.Objects);

   DELETE_ARRAY(material_list);
   DELETE_ARRAY(mapnames);
   return S_OK;
}

HRESULT C3DS::CreateSurfaces()
{
    return S_OK;
}

HRESULT C3DS::RestoreSurfaces()
{
   HRESULT Hr;
   if( FAILED( Hr = ReleaseSurfaces() ) ) return Hr;
   if( FAILED( Hr = CreateSurfaces() ) ) return Hr;
   return S_OK;
}

HRESULT C3DS::ReleaseSurfaces()
{
   return S_OK;
}

HRESULT C3DS::Draw()
{
   //LPDIRECTDRAWSURFACE7 current_texture;
   float x, y, z;
   float tu,tv;
   
   float wx=4.0f, wy=-1.0f, wz=0.0f;

//   _Engine.m_pD3DDevice->SetRenderState(D3DRENDERSTATE_CULLMODE, m_cull ? D3DCULL_CCW : D3DCULL_NONE );

   // Render all 3ds object in the model
   for( long i=0; i<m_model.NumObjects; i++ ) {
      // Render a 3ds object
      for( long f = 0; f < m_model.Objects[i].numfaces ; f++ ) {
         // Render a triangle
         long vcnt = 0;
         for(long icnt = 0; icnt < 3 ; icnt++)   {
            long v = m_model.Objects[i].faces[f].indices[icnt];

            // Swap y and z vertex components.
            // 3DS uses a different 3d axes system than this program
            // so we need to convert.
            x = m_model.Objects[i].verts[v].x;
            z = m_model.Objects[i].verts[v].y;
            y = m_model.Objects[i].verts[v].z;

            tu = m_model.Objects[i].texverts[v].x;
            tv = m_model.Objects[i].texverts[v].y;

            // Load up Draw Primitive's vertex list
            src_v[vcnt].x  = wx + x; 
            src_v[vcnt].y  = wy + y;
            src_v[vcnt].z  = wz + z;
            src_v[vcnt].tu = tu; 
            src_v[vcnt].tv = tv; 

            vcnt++;
         }

         // Set the correct texture for this triangle
         //strcpy(current_texture_name, mapnames[m_model.Objects[i].faces[f].tex]);
         //current_texture = D3DTextr_GetSurface( current_texture_name );
         //_Engine.m_pD3DDevice->SetTexture( 0, current_texture );
/*
         if( _Engine.m_pD3DDevice->DrawPrimitive(D3DPT_TRIANGLELIST, 
                              D3DFVF_VERTEX, 
                              (LPVOID)&src_v, 
                              (DWORD)vcnt, 
                              NULL) != D3D_OK ) 
         {
            return E_FAIL;
         }
*/
      }
   }
//   _Engine.m_pD3DDevice->SetRenderState(D3DRENDERSTATE_CULLMODE, D3DCULL_CCW);

   return S_OK;
}

// ----------------------------------------------------------

void C3DS::Process3DSVersion(FILE *f)
{
   short version;
   // 3DS File Version
   fread(&version, 1, sizeof(short),f);
   fread(&version, 1, sizeof(short),f);
   //f.Read(&version, sizeof(short));
   //f.Read(&version, sizeof(short));
}

void C3DS::ProcessMasterScale(FILE *f)
{
   float master_scale;
   // Overall scale of a 3ds scene
   //f.Read(&master_scale, sizeof(master_scale));
   fread(&master_scale, 1, sizeof(master_scale),f);
}

BOOL C3DS::ProcessVertexData(FILE *f)
// Read in vertex list from file
{
   unsigned short num_vertices;
   //f.Read(&num_vertices, sizeof(num_vertices));
   fread(&num_vertices, 1, sizeof(num_vertices),f);

   
   // Test for dummy 3ds object
   if( num_vertices == 0 ) return TRUE;
   if( (m_TotalNumVerts + num_vertices) >= MAX_NUM_3DS_VERTICES ) return FALSE;
   m_ObjList[m_TotalNumObjects].numverts = (short)num_vertices;
   m_ObjList[m_TotalNumObjects].verts    = new VERT3DS[num_vertices];

   // Allocate some memory for texture mapping data now, 
   // in case no mapping data is found. 
   m_ObjList[m_TotalNumObjects].texverts = new MAPPING_COORDINATES[num_vertices];
   m_ObjList[m_TotalNumObjects].numverts = (short)num_vertices;
   for( long i=0; i<(int)num_vertices; i++ ) {
      long temp_long;
      float p, temp_float;

      //f.Read(&p, sizeof(float));
      fread(&p, 1, sizeof(float),f);


      temp_long = (int)( ((p * 10000.0f) + 0.5f));
      temp_float = (float)temp_long / 10000.0f;
      m_ObjList[m_TotalNumObjects].verts[i].x = m_scale * temp_float;   
      
      //f.Read(&p, sizeof(float));
      fread(&p, 1, sizeof(float),f);

      temp_long = (int)( ((p * 10000.0f) + 0.5f));
      temp_float = (float)temp_long / 10000.0f;
      m_ObjList[m_TotalNumObjects].verts[i].y = m_scale * temp_float;   

      //f.Read(&p, sizeof(float));
      fread(&p, 1, sizeof(float),f);

      temp_long = (int)( ((p * 10000.0f) + 0.5f));
      temp_float = (float)temp_long / 10000.0f;
      m_ObjList[m_TotalNumObjects].verts[i].z = m_scale * temp_float;

      // Set default mapping co-ordinates, in case none are defined in object
      m_ObjList[m_TotalNumObjects].texverts[i].x = 0.0f;
      m_ObjList[m_TotalNumObjects].texverts[i].y = 0.0f;
      
      m_TotalNumVerts++;
   }   

   return TRUE;
}

BOOL C3DS::ProcessFaceData(FILE *f)
// Read in Face list from file
{
   unsigned short num_faces;

   //f.Read(&num_faces, sizeof(num_faces));
   fread(&num_faces, 1, sizeof(num_faces),f);


   if( (m_TotalNumFaces + num_faces) >= MAX_NUM_3DS_FACES ) return FALSE;
   // Test for dummy 3ds object
   if( num_faces==0 ) return TRUE;
   m_ObjList[m_TotalNumObjects].numfaces = (short)num_faces;
   m_ObjList[m_TotalNumObjects].faces = new FACE3DS[(int)num_faces];
   long face_cnt = (int)num_faces;
   for( long i=0; i<face_cnt; i++ ) {
      // Set texture for face at 0 in case this 3ds object 
      // contains no map / material data
      m_ObjList[m_TotalNumObjects].faces[i].tex = 0;
      for( long j=0; j<4; j++) {
         unsigned short face_index;

         //f.Read(&face_index, sizeof(face_index));
		 fread(&face_index, 1, sizeof(face_index),f);


         // Note faces 1 to 3 are valid face indices, but the 4th one is NOT
         if(j < 3) {
            unsigned short ftemp = (unsigned short)(face_index);
            m_ObjList[m_TotalNumObjects].faces[i].indices[j] = ftemp;
         }
      }
      m_TotalNumFaces++;
   }

   return TRUE;
}


// PROCESS TEXTURE, MATERIAL, AND MAPPING DATA ROUTINES

void C3DS::AddMapName(FILE *f)
// Read in new texture name from file
{
   long i; 

   // Read in map name from file
   char map_name[MAX_NAME_LENGTH];
   for( i=0; i<MAX_NAME_LENGTH; i++) {

      //f.Read(&map_name[i], sizeof(char));
      fread(&map_name[i], 1, sizeof(char),f);


      if( map_name[i]=='\0' ) break;
   }

   // Remove file extention from string and
   // replace with .bmp.
   // Most likely the texture format list in the 
   // 3ds file will be a jpg, and we're gonna be 
   // using bmp files only. 
   for( i=0; i<MAX_NAME_LENGTH; i++ ) {
      if(map_name[i]=='.') {
         strcpy(&map_name[i], ".bmp");
         break;
      }
   }

   // Search for texture name. If it's already there, leave this function...
   for ( i=0; i<m_NumMaps; i++) {
      if( strcmpi(map_name, mapnames[i])==0 ) return;
   }
   // Add the new texture name to the list
   strcpy(mapnames[m_NumMaps], map_name);

/*
   // load the bitmap  
   if( D3DTextr_CreateTextureFromFile(map_name) != S_OK )
      //PrintMessage("Couldn't load texture : ", map_name);
   else
      //PrintMessage("C3DS::AddMapName - loaded ", map_name);
*/
   m_NumMaps++;
}

void C3DS::AddMaterialName(FILE *f)
// Read in new material name from file
{   
   bool error = true;
   char mat_name[MAX_NAME_LENGTH];
   // Read in material name
   for( long i=0; i<MAX_NAME_LENGTH; i++) {

      //f.Read(&mat_name[i], sizeof(char));
      fread(&mat_name[i], 1, sizeof(char),f);


      if(mat_name[i]=='\0') {
         error = false;
         break;
      }
   }
   if(error) {
      strcpy(material_list[m_NumMaterials], "error");
      return;
   }
   strcpy(material_list[m_NumMaterials], mat_name);
   m_NumMaterials++;
}

void C3DS::ProcessTriangleMaterialData(FILE *f)
// This function will be called once for each texture a 
// 3ds object uses. 
{
   long i; 
   long current_texture = 0;
   bool error = true;
   
   char mat_name[MAX_NAME_LENGTH];
   // Read in the materials name from file
   for( i=0; i<MAX_NAME_LENGTH; i++ ) {

      //f.Read(&mat_name[i], sizeof(char));
      fread(&mat_name[i], 1, sizeof(char),f);


      if(mat_name[i]=='\0') break;
   }

   // Get the material's number. This number will also be used 
   // as the current texture number
   for( i=0; i<m_NumMaps; i++ ) {
      if( strcmpi(mat_name, material_list[i])==0 ) {
         current_texture = i;
         if( (current_texture < 0) || (current_texture > MAX_NUM_3DS_TEXTURES) ) {
            // Current_texture is out of bounds
            current_texture = 0;
         }
         error = false;
         break;
      }
   }

   // If we couldn't find the material name use the first one on the list
   // so we can at least see the polygons rendered with some texture.
   if(error) {
      current_texture = 0;
      // Couldn't find
      strcpy(material_list[m_NumMaterials], "error");
   }

   // Read a list of faces, these faces will be given this 
   // material / texture number
   unsigned short num_faces;

   //f.Read(&num_faces, sizeof(num_faces));
   fread(&num_faces, 1, sizeof(num_faces),f);


   for ( i=0; i<num_faces; i++) {
      short findex;

      //f.Read(&findex, sizeof(findex));
	  fread(&findex, 1, sizeof(findex),f);
	

      m_ObjList[m_TotalNumObjects].faces[findex].tex = current_texture;
   }
}

void C3DS::ProcessMappingData(FILE *f)
// Read in texture mapping co-ordinates from file
{
   unsigned short num_mapping_coords;
   //f.Read(&num_mapping_coords, sizeof(num_mapping_coords));

   fread(&num_mapping_coords, 1, sizeof(num_mapping_coords),f);


   for( long  i=0; i<num_mapping_coords; i++ ) {

      //f.Read(&m_ObjList[m_TotalNumObjects].texverts[i].x, sizeof(float));
      //f.Read(&m_ObjList[m_TotalNumObjects].texverts[i].y, sizeof(float));

	  fread(&m_ObjList[m_TotalNumObjects].texverts[i].x, 1, sizeof(float),f);
	  fread(&m_ObjList[m_TotalNumObjects].texverts[i].x, 1, sizeof(float),f);


      m_TotalNumCoords++;
   }
   m_ObjList[m_TotalNumObjects].numtexverts = num_mapping_coords;
}

void C3DS::ProcessTriSmoothData(FILE *f)
{
   // Just read in this data, and ignore
   // it's not useful for this sample
   long num_faces = m_ObjList[m_TotalNumObjects].numfaces; 
   for( long i=0;  i<num_faces; i++ ) {
      BYTE a,b,c,d;
    /*  f.Read(&a, sizeof(a));
      f.Read(&b, sizeof(b));
      f.Read(&c, sizeof(c));
      f.Read(&d, sizeof(d));*/

	  fread(&a, 1, sizeof(a),f);
	  fread(&b, 1, sizeof(b),f);
	  fread(&c, 1, sizeof(c),f);
	  fread(&d, 1, sizeof(d),f);



   }
}

void C3DS::ProcessTriLocalData(FILE *f)
{
   float x,y,z;
   float local_centre_x, local_centre_y, local_centre_z;

   // We're ignoring this data as it isn't useful
   // to rendering the model in this sample. 

   fread(&x, 1, sizeof(float),f);
   fread(&y, 1, sizeof(float),f);
   fread(&z, 1, sizeof(float),f);

   fread(&x, 1, sizeof(float),f);
   fread(&y, 1, sizeof(float),f);
   fread(&z, 1, sizeof(float),f);

   fread(&x, 1, sizeof(float),f);
   fread(&y, 1, sizeof(float),f);
   fread(&z, 1, sizeof(float),f);

   fread(&local_centre_x, 1, sizeof(float),f);
   fread(&local_centre_y, 1, sizeof(float),f);
   fread(&local_centre_z, 1, sizeof(float),f);
}
