
#pragma once
#include <stdio.h>
#include <d3dtypes.h>

class C3DS 
{
protected:
   typedef enum {
      MAX_NUM_3DS_TRIANGLES    = 8000,
      MAX_NUM_3DS_VERTICES     = 32000,
      MAX_NUM_3DS_FACES        = 8000,
      MAX_NAME_LENGTH          = 256,
      MAX_NUM_3DS_TEXTURES     = 10,
      MAX_NUM_3DS_FRAMES       = 50,
      MAX_NUM_3DS_OBJECTS      = 400,
   };

   typedef enum {
      MAIN3DS                        = 0x4D4D,
      M3DS_VERSION                     = 0x0002,
      MESH_VERSION                     = 0x3D3E,

      EDIT3DS                        = 0x3D3D,  
        NAMED_OBJECT                  = 0x4000,
         TRIANGLE_MESH               = 0x4100,
           TRIANGLE_VERTEXLIST      = 0x4110,   
           TRIANGLE_VERTEXOPTIONS   = 0x4111,   
           TRIANGLE_MAPPINGCOORS      = 0x4140,
           TRIANGLE_MAPPINGSTANDARD   = 0x4170, 
           TRIANGLE_FACELIST         = 0x4120,
            TRIANGLE_SMOOTH         = 0x4150,   
            TRIANGLE_MATERIAL       = 0x4130,  
           TRI_LOCAL                  = 0x4160,   
           TRI_VISIBLE               = 0x4165,
  
       INT_PERCENTAGE                  = 0x0030,
       MASTER_SCALE                  = 0x0100,

        EDIT_MATERIAL               = 0xAFFF,
         MAT_NAME01                  = 0xA000,

           TEXTURE_MAP               = 0xA200,
            MAPPING_NAME            = 0xA300,

 
           MATERIAL_AMBIENT         = 0xA010,
            MATERIAL_DIFFUSE         = 0xA020,
            MATERIAL_SPECULAR         = 0xA030,
            MATERIAL_SHININESS      = 0xA040,
            MATERIAL_SHINE_STRENGTH   = 0xA041,

            MAPPING_PARAMETERS      = 0xA351,
            BLUR_PERCENTAGE         = 0xA353,

            TRANS_PERCENT            = 0xA050,
            TRANS_FALLOFF_PERCENT   = 0xA052,
            REFLECTION_BLUR_PER      = 0xA053,
            RENDER_TYPE               = 0xA100,

            SELF_ILLUM               = 0xA084,
            WIRE_THICKNESS            = 0xA087,
            IN_TRANC                  = 0xA08A,
            SOFTEN                  = 0xA08C,
     
      KEYFRAME                        = 0xB000,
        KEYFRAME_MESH_INFO            = 0xB002,
     KEYFRAME_START_AND_END         = 0xB008,
        KEYFRAME_HEADER               = 0xb00a,

       POS_TRACK_TAG                  = 0xb020,
       ROT_TRACK_TAG                  = 0xb021, 
       SCL_TRACK_TAG                  = 0xb022, 
         FOV_TRACK_TAG               = 0xb023,
         ROLL_TRACK_TAG               = 0xb024,   
         COL_TRACK_TAG              = 0xb025,
         MORPH_TRACK_TAG            = 0xb026,
         HOT_TRACK_TAG              = 0xb027,
         FALL_TRACK_TAG             = 0xb028,
         HIDE_TRACK_TAG             = 0xb029,
       PIVOT                           = 0xb013, 
       NODE_HDR                        = 0xb010,
       NODE_ID                        = 0xb030,
       KFCURTIME                     = 0xb009, 
   };

   typedef struct 
   {
      float x;
      float y;
      float z;
   } VERT3DS;

   typedef struct 
   {
      short indices[4];
      long tex;
   } FACE3DS;

   typedef struct 
   {
      float x;
      float y;
   } MAPPING_COORDINATES;

   typedef struct 
   {
      VERT3DS *verts;
      FACE3DS *faces;
      MAPPING_COORDINATES *texverts;
      short numverts;
      short numfaces;
      short numtexverts;
      char texturename[20];
      char object_name[20];
   } OBJECT3DS;

   typedef struct
   {      
      OBJECT3DS *Objects;
      long NumObjects;
      long NumTextures;
   } MODEL3DS;

   MODEL3DS m_model;
   long m_TotalNumObjects;
   long m_NumMaterials;
   long m_NumMaps;
   long m_TotalNumFaces;   
   long m_TotalNumVerts;
   long m_TotalNumCoords;
   long m_TotalNumIndices;

   short m_iTexture;

   CHAR m_szModelFilename[MAX_PATH];
   CHAR m_szTextureFilename[MAX_PATH];

   OBJECT3DS m_ObjList[MAX_NUM_3DS_OBJECTS]; // used for temp storage of 3ds model data
   D3DVERTEX src_v[32]; // Structures required by DrawPrimitive to store vert and texture

   float m_scale;
   LPSTR *material_list;
   LPSTR *mapnames;
   bool m_cull;




public:
//   HRESULT Initialize(CSystem *, CEngine *);
   HRESULT Initialize();
   HRESULT Create(char*fn);
   HRESULT Done();
   HRESULT SetProperty(LPCSTR, LPCSTR);
   HRESULT GetProperty(LPCSTR, LPSTR, short) { return E_NOTIMPL; };
   HRESULT GetType();
   //
   HRESULT CreateSurfaces();
   HRESULT RestoreSurfaces();
   HRESULT ReleaseSurfaces();
   HRESULT Draw();
   HRESULT PreDraw() { return S_OK; };
   HRESULT PostDraw() { return S_OK; };

	long GetNumTexverts(long numObj);
	long GetNumFaces(long numObj);
	long GetNumVerts(long numObj);

	long GetVertsXYZ(long numObj, long v, float *vertsx, float *vertsy, float *vertsz);


protected:
   BOOL ProcessVertexData(FILE  *fp);
   BOOL ProcessFaceData(FILE  *fp);
   void ProcessTriLocalData(FILE  *fp);
   void ProcessTriSmoothData(FILE  *fp);
   void ProcessMappingData(FILE  *fp);
   void ProcessTriangleMaterialData(FILE  *fp);
   void AddMaterialName(FILE  *fp);
   void AddMapName(FILE  *fp);
   void ProcessNodeHeader(FILE  *fp);
   void ProcessNodeId(FILE  *fp);
   void ProcessMasterScale(FILE  *fp);
   void Process3DSVersion(FILE  *fp);

};
