

// 3DSstruct.h
#pragma once


typedef struct _map_list
{
  char filename[256];  // Mapping filename (Texture)
  float u;             // U scale
  float v;             // V scale
  float uoff;          // U Offset
  float voff;          // V Offset
  float rot;           // Rotation angle
  _map_list *next;
}map_list;


typedef struct _mat_list
{
  char name[200];  // Material name
  DWORD ambient;   // Ambient color (RGBA)
  DWORD diffuse;   // Diffuse color (RGBA)
  DWORD specular;  // Specular color (RGBA)
  _map_list *htex, *ttex;    // Texture maps (presently only 1 is used. diffused map)
  _mat_list *next;
}	mat_list;


typedef struct _face_mat
{
  char matname[200];// Material Name
  WORD ne;       // No. of entries
  WORD *faces;   // Faces assigned to this material
  _face_mat *next;
}	face_mat;


typedef struct _mesh_object
{
  char objname[200];   // Object name
  float *vertexlist;      // Vertex list
  WORD *facelist;       // Face list
  WORD numvertices;          // No. of vertices
  WORD numfaces;          // No. of faces
  WORD numvertmapcoord;         // No. of vertices having mapping coords.
  float *mapcoords;        // Mapping coords. as U,V pairs (actual texture coordinates)
  float lmat[4][4]; // Local transformation matrix
  _mesh_object *next;  // Pointer to the next object
  face_mat *fhead, *ftail;
}	mesh_object;




