
#pragma once

class CActor : public CActorNode
{
public:
   typedef enum { MAX_NUM_BONES = 32 };
   typedef enum { MAX_BONE_NAME = 32 };
   
   typedef struct tagBone
   {
      DWORD dwID;
      DWORD dwParent;
      CHAR szName[MAX_BONE_NAME];
      D3DVECTOR vecSize;
      D3DVECTOR vecPivot;
      D3DVECTOR vecRot;
      D3DVECTOR vecMinRot;
      D3DVECTOR vecMaxRot;
      D3DVECTOR vecScale;
      D3DVECTOR vecTrans;
   } tBone;

   struct MD2HeaderStruct
   {
      DWORD dwID;
      DWORD dwVersion;

      DWORD dwSkinWidth;
      DWORD dwSkinHeight;
      DWORD dwFrameSize;

      DWORD dwNumSkins;
      DWORD dwNumXYZ;
      DWORD dwNumST;
      DWORD dwNumTris;
      DWORD dwNumGLCmds;
      DWORD dwNumFrames;

      DWORD dwOffSkins;
      DWORD dwOffST;
      DWORD dwOffTris;
      DWORD dwOffFrames;
      DWORD dwOffGLCmds;
      DWORD dwOffEnd;
   };

   struct MD2TriVertStruct
   {
      BYTE bVerts[3];
      BYTE bNormalIndex;
   };

   struct MD2AliasFrameStruct
   {
      float fScale[3];
      float fTranslate[3];
      CHAR  szFrameName[16];
   };

   struct MD2AliasFaceIndexStruct
   {
      float s;
      float t;
      long index;
   };
   
   struct MD2AliasPrimitiveStruct
   {         
      D3DPRIMITIVETYPE PrimitiveType;
      MD2AliasFaceIndexStruct *FaceIndices;
      DWORD NumFaceIndices;
   };

   short m_iTexture;

   CHAR m_szModelFilename[MAX_PATH];
   CHAR m_szSkinFilename[MAX_PATH];
   bool m_cull;
   float m_fScale;
   D3DVERTEX src_v[200];
   tBone m_Bones[MAX_NUM_BONES];

   D3DVERTEX *m_pVertices;
   DWORD m_dwNumVertices;
   MD2AliasPrimitiveStruct *m_pPrimitives;
   DWORD m_dwNumPrimitives;

public:
   CActor();
   ~CActor();

   HRESULT Initialize(CSystem *, CEngine *);
   HRESULT Create();
   HRESULT Done();
   HRESULT SetProperty(LPCSTR, LPCSTR);
   HRESULT GetProperty(LPCSTR, LPSTR, short) { return E_NOTIMPL; };
   HRESULT GetType(NODETYPE &NodeType) { NodeType = NODE_ACTOR; return S_OK; };
   //
   HRESULT CreateSurfaces();
   HRESULT RestoreSurfaces();
   HRESULT ReleaseSurfaces();
   HRESULT Draw();
   HRESULT PreDraw() { return S_OK; };
   HRESULT PostDraw() { return S_OK; };
   //
   HRESULT AddBone(DWORD dwId,
                   DWORD dwParent,
                   LPSTR szName,
                   D3DVECTOR &size,
                   D3DVECTOR &pivot,
                   D3DVECTOR &trans,
                   D3DVECTOR &scale,
                   D3DVECTOR &rot,
                   D3DVECTOR &min_rot,
                   D3DVECTOR &max_rot);
protected:
   HRESULT DrawModel();
   HRESULT DrawBones();
   HRESULT DrawBone(DWORD dwId);
   HRESULT DeformVertices();

};


