
#pragma once

class CBackground : public CSurfaceNode
{
protected:
   float m_fWidth; 
   float m_fHeight; 
   float m_fDepth;
   TCHAR m_szTextureFilename[MAX_PATH];
   short m_iTexture;

   D3DTLVERTEX m_Background[4];           // Vertices used to render the backdrop

public:
   CBackground();
   ~CBackground();

   HRESULT Initialize(CSystem *, CEngine *);
   HRESULT Create();
   HRESULT Done();
   HRESULT SetProperty(LPCSTR, LPCSTR);
   HRESULT GetProperty(LPCSTR, LPSTR, short);
   HRESULT GetType(NODETYPE &NodeType) { NodeType = NODE_SURFACE; return S_OK; };
   //
   HRESULT CreateSurfaces();
   HRESULT RestoreSurfaces();
   HRESULT ReleaseSurfaces();
   HRESULT Draw();
   HRESULT PreDraw() { return S_OK; };
   HRESULT PostDraw() { return S_OK; };
};
