
#pragma once

#define NUM_TEXTURES 64

class CEngine
{
public:
   CEngine()
   {
      m_pD3DX        = NULL;
      m_pDD          = NULL;
      m_pD3D         = NULL;
      m_pD3DDevice   = NULL;
      m_bReady = false;
      m_dwHwLevel = D3DX_DEFAULT;
      m_dwNumBackBuffers = 2;
      m_nTextures = 0;
      m_vecVelocity = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
      m_vecAngularVelocity = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
      m_colorClear = D3DXCOLOR(0.4f, 0.5f, 0.8f, 1.0f);
      m_fSpeed = 5.0f;
      m_fAngularSpeed = 1.0f;
   };

   ~CEngine()
   {
      RELEASE(m_pDD);
      RELEASE(m_pD3D);
      RELEASE(m_pD3DDevice);
   }

public:
   typedef struct tagRGBMASK
   {
      unsigned long rgbRed; // red component
      unsigned long rgbGreen; // green component
      unsigned long rgbBlue; // blue component
   } RGBMASK;

   typedef struct tagRGB16
   {
      RGBQUAD depth;
      RGBQUAD Amount;
      RGBQUAD Position;
      RGBMASK Mask;
   } RGB16;

   ID3DXContext     *m_pD3DX;
   LPDIRECTDRAW7     m_pDD;
   LPDIRECT3D7       m_pD3D;
   LPDIRECT3DDEVICE7 m_pD3DDevice;
   D3DDEVICEDESC7    m_D3DDeviceDesc;

   D3DXMATRIX m_matView;
   D3DXMATRIX m_matPosition;
   D3DXMATRIX m_matProjection;
   D3DXMATRIX m_matIdentity;
   //
   D3DXVECTOR3 m_vecVelocity;
   D3DXVECTOR3 m_vecAngularVelocity;
   float m_fSpeed;
   float m_fAngularSpeed;
   //
   D3DXCOLOR m_colorClear;
   //
   CFrameTimer m_timer;

   LPDIRECTDRAWSURFACE7 m_ppTextures[NUM_TEXTURES];
   short m_nTextures;
   RGB16 m_rgb16;

   DWORD m_dwHwLevel;
   DWORD m_dwNumBackBuffers;
   bool m_bReady;

public:
   HRESULT Init();
   HRESULT Close();
   HRESULT Draw();
   HRESULT CreateTexture(LPCSTR szFilename, short &ID);
   HRESULT CreateTexture(LPDIRECTDRAWSURFACE7 pSurface, short &ID);
protected:
   HRESULT CreateContext();
   HRESULT ReleaseContext();
   HRESULT RestoreContext();
   //
   HRESULT InitView();
   HRESULT InitStage();
   HRESULT GetRGB16();
};
