
#pragma once

class CGround : public CSurfaceNode
{
protected:
   float m_fWidth; 
   float m_fHeight; 
   float m_fTile; 
   DWORD m_dwColor;

   UINT m_uIndices;
   UINT m_uVertices;

   TCHAR m_szTextureFilename[MAX_PATH];
   short m_iTexture;

   WORD *m_pwIndices;
   LPDIRECT3DVERTEXBUFFER7 m_pvbVertices;

public:
   CGround();
   ~CGround();

   HRESULT Initialize(CSystem *, CEngine *);
   HRESULT Create();
   HRESULT Done();
   HRESULT SetProperty(LPCSTR, LPCSTR);
   HRESULT GetProperty(LPCSTR, LPSTR, short);
   HRESULT GetType(NODETYPE &NodeType) { NodeType = NODE_SURFACE; return S_OK; };
   //
   HRESULT CreateSurfaces();
   HRESULT RestoreSurfaces();
   HRESULT ReleaseSurfaces();
   HRESULT Draw();
   HRESULT PreDraw() { return S_OK; };
   HRESULT PostDraw() { return S_OK; };
};
