
#include "stdafx.h"
#include "Light.h"
#include "Utils.h"

//////////////////////////////////////////////////////////////////////////////
//
// CLight
//

HRESULT CLight::Initialize(CSystem *, CEngine *)
{
   ZeroMemory(&m_Light, sizeof(m_Light));
   m_Light.dltType = D3DLIGHT_POINT;
   m_Light.dcvDiffuse.r = 1.0f;
   m_Light.dcvDiffuse.g = 1.0f;
   m_Light.dcvDiffuse.b = 1.0f;
   m_Light.dcvAmbient.r = 1.0f;
   m_Light.dcvAmbient.g = 1.0f;
   m_Light.dcvAmbient.b = 1.0f;
   m_Light.dcvSpecular.r = 1.0f;
   m_Light.dcvSpecular.g = 1.0f;
   m_Light.dcvSpecular.b = 1.0f;
   m_Id = 0;
   return S_OK;
};

HRESULT CLight::SetProperty(LPCSTR szItem, LPCSTR szValue)
{
   if( stricmp(szItem,"ID")==0 ) {
      m_Id = atol(szValue);
      return S_OK;
   }
   if( stricmp(szItem,"TYPE")==0 ) {
      if( stricmp(szValue,"DIRECTIONAL")==0 ) m_Light.dltType = D3DLIGHT_DIRECTIONAL;
      if( stricmp(szValue,"SPOT")==0 ) m_Light.dltType = D3DLIGHT_SPOT;
      if( stricmp(szValue,"POINT")==0 ) m_Light.dltType = D3DLIGHT_POINT;
      return S_OK;
   }
   if( stricmp(szItem,"DIRECTION")==0 ) {
      D3DXVECTOR3 vecDirection;
      vecDirection = ParseVector3(szValue);
      m_Light.dvDirection.x = vecDirection.x;
      m_Light.dvDirection.y = vecDirection.y;
      m_Light.dvDirection.z = vecDirection.z;
      return S_OK;
   }
   if( stricmp(szItem,"SPECULAR")==0 ) {
      D3DXCOLOR colSpecular;
      colSpecular = ParseColor4(szValue);
      m_Light.dcvSpecular.r = colSpecular.r;
      m_Light.dcvSpecular.g = colSpecular.g;
      m_Light.dcvSpecular.b = colSpecular.b;
      m_Light.dcvSpecular.a = colSpecular.a;
      return S_OK;
   }
   if( stricmp(szItem,"DIFFUSE")==0 ) {
      D3DXCOLOR colDiffuse;
      colDiffuse = ParseColor4(szValue);
      m_Light.dcvDiffuse.r = colDiffuse.r;
      m_Light.dcvDiffuse.g = colDiffuse.g;
      m_Light.dcvDiffuse.b = colDiffuse.b;
      m_Light.dcvDiffuse.a = colDiffuse.a;
      return S_OK;
   }
   return E_INVALIDARG;
};

HRESULT CLight::Create()
{
   HRESULT Hr;
   Hr = _Engine.m_pD3DDevice->LightEnable(m_Id, TRUE);
   if( FAILED(Hr) ) return Hr;
   Hr = _Engine.m_pD3DDevice->SetLight(m_Id, &m_Light);
   if( FAILED(Hr) ) return Hr;
   return S_OK;
};
