
#pragma once


class CMD2 : public CSurfaceNode
{
protected:
   typedef enum {
      MD2_TRIANGLEFAN = 1,
      MD2_TRIANGLESTRIP = 2,
   };

   // MD2 File Header structure
   typedef struct
   {
      long ident;
      long version;

      long skinwidth;
      long skinheight;
      long framesize;   

      long num_skins;
      long num_verts;
      long num_tex_verts;   
      long num_faces;
      long num_glcmds; 
      long num_frames;

      long offset_skins;   
      long offset_tex_verts;      
      long offset_faces;   
      long offset_frames; 
      long offset_glcmds; 
      long offset_end;   
   } MD2HEADER;

   typedef struct
   {
      float x;
      float y;
      float z;
   } MD2VERT;

   typedef struct
   {
      float s;
      float t;
      long   index;
   } MD2FACEINDEX; // GLVERTS

   typedef struct
   {
      BYTE v[3]; 
      BYTE lightnormalindex;
   } MD2BYTE_VERTEX; 

   typedef struct
   {            
      char framename[16];      
      MD2VERT *Verts;
   } MD2FRAME;

   typedef struct
   {         
      long PrimitiveType;
      MD2FACEINDEX *FaceIndices;
      long NumFaceIndices;
   } MD2OBJECT;

   typedef struct
   {      
      MD2FRAME  *Frames;
      MD2OBJECT *Primitives;
      long NumPrimitives;
      long NumFrames;
      long NumVerts;
      long NumIndices;
      long CurrentFrame;
      float skx;
      float sky;
      //
      char SkinName[256];   //16      
   } MD2MODEL;

   short m_iTexture;

   CHAR m_szModelFilename[MAX_PATH];
   CHAR m_szSkinFilename[MAX_PATH];
   MD2MODEL m_model;
     float m_scale;
   bool m_cull;
   D3DVERTEX src_v[400];

public:
   CMD2();
   ~CMD2();

   HRESULT Initialize(CSystem *, CEngine *);
   HRESULT Create();
   HRESULT Done();
   HRESULT SetProperty(LPCSTR, LPCSTR);
   HRESULT GetProperty(LPCSTR, LPSTR, short) { return E_NOTIMPL; };
   HRESULT GetType(NODETYPE &NodeType) { NodeType = NODE_SURFACE; return S_OK; };
   //
   HRESULT CreateSurfaces();
   HRESULT RestoreSurfaces();
   HRESULT ReleaseSurfaces();
   HRESULT Draw();
   HRESULT PreDraw() { return S_OK; };
   HRESULT PostDraw() { return S_OK; };
};

