
#pragma once

class CSystem;
class CEngine;

#define WM_APPMSG WM_APP+333

typedef enum {
   NODE_BASIC,
   NODE_LOADER,
   NODE_LIGHT,
   NODE_MATERIAL,
   NODE_PARTICLESYSTEM,
   NODE_SPECTATOR,
   NODE_SURFACE,
   NODE_ACTOR,
} NODETYPE;

class CNode 
{
public:
   virtual HRESULT Initialize(CSystem *, CEngine *) = 0;
   virtual HRESULT Create() = 0;
   virtual HRESULT Done() = 0;
   virtual HRESULT SetProperty(LPCSTR, LPCSTR) = 0;
   virtual HRESULT GetProperty(LPCSTR, LPSTR, short) = 0;
   virtual HRESULT GetType(NODETYPE &NodeType) = 0;
};

class CSurfaceNode : public CNode
{
public:
   virtual HRESULT CreateSurfaces() = 0;
   virtual HRESULT RestoreSurfaces() = 0;
   virtual HRESULT ReleaseSurfaces() = 0;
   virtual HRESULT Draw() = 0;
   virtual HRESULT PreDraw() = 0;
   virtual HRESULT PostDraw() = 0;
};

class CActorNode : public CSurfaceNode
{
public:
   virtual HRESULT AddBone(DWORD dwId,
                           DWORD dwParent,
                           LPSTR szName,
                           D3DVECTOR &size,
                           D3DVECTOR &pivot,
                           D3DVECTOR &trans,
                           D3DVECTOR &scale,
                           D3DVECTOR &rot,
                           D3DVECTOR &min_rot,
                           D3DVECTOR &max_rot) = 0;
};

class CSpectatorNode : public CNode
{
public:
   virtual HRESULT PlayerMove(D3DXVECTOR3 &vecT, D3DXVECTOR3 &vecR) = 0;
   virtual HRESULT OnMouseMove(long x, long y) = 0;
   virtual HRESULT OnButtonUp(short button, long x, long y) = 0;
   virtual HRESULT OnButtonDown(short button, long x, long y) = 0;
   virtual HRESULT OnKeyUp(short key) = 0;
   virtual HRESULT OnKeyDown(short key) = 0;
   //
   virtual HRESULT OnCommand(UINT uMsg, WPARAM wParam, LPARAM lParam) = 0;
   virtual HRESULT OnAppMsg(UINT uMsg, WPARAM wParam, LPARAM lParam) = 0;
};


