
#include "stdafx.h"
#include "PCX.h"


#define RED(p) (p >> _Engine.m_rgb16.Position.rgbRed) // Extracts Red Component
#define GREEN(p) ((p & _Engine.m_rgb16.Mask.rgbGreen) >> rgb16.Position.rgbGreen) // Extracts Green Component
#define BLUE(p) (p & _Engine.m_rgb16.Mask.rgbBlue) // Extracts Blue Component
#define COLOR2RGB16(r, g, b) ((r << _Engine.m_rgb16.Position.rgbRed) | \
                              (g << _Engine.m_rgb16.Position.rgbGreen) | \
                              (b << _Engine.m_rgb16.Position.rgbBlue))


HRESULT CPCX::CreateSurface(LPCSTR szFilename, LPDIRECTDRAWSURFACE7 *pSurface)
{
   if( pSurface==NULL ) return E_POINTER;
   *pSurface = NULL;
   //
   m_pSurface = NULL;
   m_pBuffer = NULL;
   m_pPalette = NULL;
   if( FAILED( Load(szFilename) ) ) return E_FAIL;
   if( FAILED( Convert() ) ) return E_UNEXPECTED;
   DELETE_ARRAY(m_pPalette);
   DELETE_ARRAY(m_pBuffer);
   //
   *pSurface = m_pSurface;
   return S_OK;
};

HRESULT CPCX::Load(LPCSTR szFilename)
{
   CFile f;

   if( f.Open(szFilename)==FALSE ) return E_FAIL;

   unsigned char c;
   f.Read(&c,1);
   if( c!=10) return E_UNEXPECTED;
   f.Read(&c,1);
   if( c!=5 ) return E_UNEXPECTED;

   short dummy;
   f.Read(&dummy,2);

   short sx, sy, ex, ey;
   f.Read(&sx,2);
   f.Read(&sy,2);
   f.Read(&ex,2);
   f.Read(&ey,2);

   m_width   = ex - sx + 1;
   m_height   = ey - sy + 1;

   m_pBuffer = new unsigned char[ (m_width * m_height) ];
   ZeroMemory(m_pBuffer, sizeof(unsigned char) * (m_width * m_height));
   f.Seek(128, FILE_BEGIN);

   int w_count = 0;
   int max_count = m_width*m_height;
   while( w_count < max_count ) {
      f.Read(&c,1);
      if( c > 0xBF ) {
         unsigned char repeat = 0x3f & c;
         f.Read(&c,1);
         for(unsigned char i=0; i<repeat; i++) m_pBuffer[w_count++] = c;
      }
      else {
         m_pBuffer[w_count++] = c;
      }
   }

   m_pPalette = new unsigned char[768];
   f.Seek(-769, FILE_END);
   f.Read(&c,1);
   if( c!=12 ) return E_UNEXPECTED;
   f.Read(m_pPalette,768);

   f.Close();
   return S_OK;
}

HRESULT CPCX::Convert()
{  
   int scale_width, scale_height;
   if(m_width > 256) // Always scale up
      scale_width = 512;
   else if(m_width > 128)
      scale_width = 256;
   else if(m_width > 64)
      scale_width = 128;
   else if(m_width > 32)
      scale_width = 64;

   if(m_height > 256)
      scale_height = 512;
   else if(m_height > 128)
      scale_height = 256;
   else if(m_height > 64)
      scale_height = 128;
   else if(m_height > 32)
      scale_height = 64;

   DDSURFACEDESC2 ddsd = { 0 };
   HRESULT Hr;
   ddsd.dwSize = sizeof(ddsd);
   ddsd.dwFlags = DDSD_CAPS | DDSD_WIDTH | DDSD_HEIGHT;
   ddsd.ddsCaps.dwCaps = DDSCAPS_TEXTURE | DDSCAPS_VIDEOMEMORY;
   ddsd.dwWidth = scale_width;
   ddsd.dwHeight = scale_height;
   Hr = _Engine.m_pDD->CreateSurface(&ddsd,&m_pSurface,NULL);
   if( FAILED(Hr) ) return E_FAIL;
  
   RECT rect;
   ::SetRect(&rect, 0, 0, scale_width, scale_height);
   ZeroMemory(&ddsd,sizeof(ddsd));
   ddsd.dwSize = sizeof(ddsd);
   Hr = m_pSurface->Lock(&rect,&ddsd,DDLOCK_SURFACEMEMORYPTR | DDLOCK_WAIT,NULL);
   if( FAILED(Hr) ) return E_FAIL;

   if( ddsd.ddpfPixelFormat.dwRGBBitCount ==  16 ) {
      WORD *double_buf;
      double_buf = (WORD *)ddsd.lpSurface;
 
      float xstep, ystep, xt, yt, x1,y1;
      int x,y;
      (float)xstep = (float)m_width / (float)scale_width;
      (float)ystep = (float)m_height / (float)scale_height;
      xt = 0.0; yt = 0.0; x1 = 0.0f; y1 = 0.0f;
      x = 0; y = 0; 
      int i,j;
      for( j = 0; j < scale_height; j++ ) {
         y1 += ystep;
         yt = y1;
         y = (int)yt; if(y > m_height) y = m_height;
         for( i = 0; i < scale_width; i++ ) {    
            x1 += xstep;
            xt = x1;
            x = (int)xt; if(x > m_width) x = m_width;

            double_buf[(j*scale_width)+i] = 
               COLOR2RGB16(((long)m_pPalette[ 3 * m_pBuffer[ ( y * m_width ) + x  ] + 0 ] / 8),
                           ((long)m_pPalette[ 3 * m_pBuffer[ ( y * m_width ) + x  ] + 1 ] / 8),
                           ((long)m_pPalette[ 3 * m_pBuffer[ ( y * m_width ) + x  ] + 2 ] / 8));
         
         }
         x = 0; x1 = 0.0;
      }

      for(i = (int)( (scale_width * scale_height) - ((float)scale_width * 1.0f + 34.0f) ); 
          i < (scale_width * (scale_height - 1)); 
          i++) 
      {
         double_buf[i] = COLOR2RGB16(0,0,0);
      }
   }
   if( ddsd.ddpfPixelFormat.dwRGBBitCount ==  32 ) {
      DWORD *double_buf;
      double_buf = (DWORD *)ddsd.lpSurface;
 
      float xstep, ystep, xt, yt, x1,y1;
      int x,y;
      (float)xstep = (float)m_width / (float)scale_width;
      (float)ystep = (float)m_height / (float)scale_height;
      xt = 0.0; yt = 0.0; x1 = 0.0f; y1 = 0.0f;
      x = 0; y = 0; 
      int i,j;
      for( j = 0; j < scale_height; j++ ) {
         y1 += ystep;
         yt = y1;
         y = (int)yt; if(y > m_height) y = m_height;
         for( i = 0; i < scale_width; i++ ) {    
            x1 += xstep;
            xt = x1;
            x = (int)xt; if(x > m_width) x = m_width;

            double_buf[(j*scale_width)+i] = 
               COLOR2RGB16(((long)m_pPalette[ 3 * m_pBuffer[ ( y * m_width ) + x ] + 0 ] ),
                           ((long)m_pPalette[ 3 * m_pBuffer[ ( y * m_width ) + x ] + 1 ] ),
                           ((long)m_pPalette[ 3 * m_pBuffer[ ( y * m_width ) + x ] + 2 ] ));
         
         }
         x = 0; x1 = 0.0;
      }

      for(i = (int)( (scale_width * scale_height) - ((float)scale_width * 1.0f + 34.0f) ); 
          i < (scale_width * (scale_height - 1)); 
          i++) 
      {
         double_buf[i] = COLOR2RGB16(0,0,0);
      }
   }

   m_pSurface->Unlock(&rect); 
   return S_OK;
}

