#ifndef DHFPSTIMER_H
#define DHFPSTIMER_H

//
// Version: 1.2 - February 24, 2003
//
// Change Log:
// - Changed get_fps to GetFPS and made it public - April 4, 2002
// - Added GetCurrentFPS - February 24, 2003
// - Switched to timeGetTime from GetTickCount - February 24, 2003
//
//To Do:
// - Make an IFlipped call for people who don't want to use my Flip/Present
// - Track FPS over a smaller period (say 1 minute) for a more 'current' FPS rating
// - GetFPSString, which is a preformatted string for lazy people

#include <stdio.h>
#include <mmsystem.h>

class dhFPSTimer{
protected:

   DWORD m_frames_one_second;
   DWORD m_frames;
   DWORD m_min_one_second;
   DWORD m_max_one_second;
   DWORD m_current_fps;
   DWORD m_start_time;
   DWORD m_one_second_start_time;

   char m_app_name[80];

   IDirect3DDevice8 *m_d3d_device;

public:
   inline void StartTimer(void);
   inline void LogTimer(void);
   inline void LogTimer(const char *p_file_name);
   inline void CheckTimer(float *p_fps,DWORD *p_min_1_sec,DWORD *p_max_1_sec);
   inline float GetFPS(void);
   inline float GetCurrentFPS(void);

   inline HRESULT Flip(void);
   inline HRESULT Present(void);

   inline void SetDevice(IDirect3DDevice8 *p_d3d_device);

   inline dhFPSTimer(const char *p_app_name);
};

//********************************************************************
// Function:dhFPSTimer::SetDevice
// Whazzit:Associates a D3D8 Device with the timer object.  This is
//         needed for Flip/Present to work.
//********************************************************************
inline void dhFPSTimer::SetDevice(IDirect3DDevice8 *p_d3d_device){

   m_d3d_device=p_d3d_device;

}
//********************************************************************
// Function:dhFPSTimer::dhFPSTimer
// Whazzit:Constructor.  The log file requires the app name, so pass
//         it in here.
//********************************************************************
inline dhFPSTimer::dhFPSTimer(const char *p_app_name){

   strcpy(m_app_name,p_app_name);

}
//********************************************************************
// Function:dhFPSTimer::StartTimer
// Whazzit:Initializes all variables & records current time.  You can
//         safely call this function multiple times, it will just
//         reset the timer.
//********************************************************************
inline void dhFPSTimer::StartTimer(void){

   m_frames_one_second=0;
   m_frames=0;
   m_min_one_second=0x7fffffff;
   m_max_one_second=0;

   m_start_time=timeGetTime();
   m_one_second_start_time=m_start_time;

}
//********************************************************************
// Function:dhFPSTimer::LogTimer
// Whazzit:Calls LogTimer with the default file name.
//********************************************************************
inline void dhFPSTimer::LogTimer(void){

   LogTimer("FPS.txt");

}
#include <dhengine.h>
extern dhEngine g_engine;
//********************************************************************
// Function:dhFPSTimer::LogTimer
// Whazzit:Writes a GameGauge 2.0 FPS log.
//********************************************************************
inline void dhFPSTimer::LogTimer(const char *p_file_name){
float fps;
FILE *fps_file;
//ofstream fps_file(p_file_name);

   fps=GetFPS();

   fps_file=fopen(p_file_name,"w");
   if(fps_file){

      fprintf(fps_file,"%.2f %s\n",fps,m_app_name);
      fprintf(fps_file,"%d min\n",m_min_one_second);
      fprintf(fps_file,"%d max\n",m_max_one_second);

//      fps_file.precision(2);
//      fps_file.setf(ios::showpoint|ios::fixed);
//      fps_file << fps << " " << m_app_name << endl;
//      fps_file << m_min_one_second << " min" <<endl;
//      fps_file << m_max_one_second << " max" <<endl;
//      fps_file.close();
      
      fclose(fps_file);
   }
}
//********************************************************************
// Function:dhFPSTimer::CheckTimer
// Whazzit:Fills parameters with FPS timings.  This is useful if you'd
//         like to display the FPS on the screen rather than (or in
//         addition to) the log file.
//********************************************************************
inline void dhFPSTimer::CheckTimer(float *p_fps,DWORD *p_min_1_sec,DWORD *p_max_1_sec){

   *p_fps=GetFPS();
   *p_min_1_sec=m_min_one_second;
   *p_max_1_sec=m_max_one_second;

}
//********************************************************************
// Function:dhFPSTimer::GetFPS
// Whazzit:Returns average FPS.
//********************************************************************
inline float dhFPSTimer::GetFPS(void){
DWORD end_time=0,total_time=0;
float fps;

   end_time=timeGetTime();
   total_time=end_time-m_start_time;
   fps=((float)m_frames/(float)total_time)*1000.0f;

   return fps;
}
//********************************************************************
// Function:dhFPSTimer::GetCurrentFPS
// Whazzit:Returns FPS for the current second.  Since framerates can
//         vary significantly from second to second, this value wil
//         tend to jump around
//********************************************************************
inline float dhFPSTimer::GetCurrentFPS(void){

   return (float)m_current_fps;
}

//********************************************************************
// Function:dhFPSTimer::Present
// Whazzit:Alias for the Flip call.  Use whichever one you like.
//********************************************************************
inline HRESULT dhFPSTimer::Present(void){

   return Flip();
}
//********************************************************************
// Function:dhFPSTimer::Flip
// Whazzit:Present the backbuffer and increment the frame counters.
//********************************************************************
inline HRESULT dhFPSTimer::Flip(void){
HRESULT hr;


   hr=m_d3d_device->Present( NULL, NULL, NULL, NULL );

   m_frames_one_second++;
   m_frames++;


   if((timeGetTime() - m_one_second_start_time) > 1000){
      if(m_frames_one_second < m_min_one_second)
         m_min_one_second=m_frames_one_second;
      if(m_frames_one_second > m_max_one_second)
         m_max_one_second=m_frames_one_second;

      m_current_fps=m_frames_one_second;
      m_frames_one_second=0;

      m_one_second_start_time = timeGetTime();
   }

   return hr;
};



#endif //#ifndef DHFPSTIMER_H
