 
/******************************************************************************
 GFX_Utilities.c 

 Copyright  2007, 2008  Birger N. Andreasen 
 Please send any bugreports, comments and other issues to:
 E-Mail = bna@post10.tele.dk
 Homepage with other ROTT stuff = http://www.riseofthetriad.dk/

 ******************************************************************************/

#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <direct.h>


#if PLATFORM_DOS
#include <malloc.h>
#include <conio.h>
#include <io.h>
#endif

#include "rt_def.h"
#include "rt_util.h"
#include "_w_wad.h"
#include "w_wad.h"
#include "z_zone.h"
#include "isr.h"
#include "develop.h"

#include "rt_crc.h"
#include "rt_main.h"
#include "rt_cfg.h"
#include "lumpy.h"
#include "_rt_main.h"
//#include "viewport.h"

#include "..\\PCXstuff\tile.h"
#include "..\\PCXstuff\writegif.c"
#include "..\\PCXstuff\writebmp.c"

boolean  bExtractGFX;
boolean  bUseExternalGFX;
char     GFX_Path[256];
char     GFX_PathWalls[256];
char     GFX_PathFloor_Ceil[256];
char     GFX_PathShape[256];
char     GFX_PathGuns[256];
char     GFX_PathDoors[256];
char     GFX_PathSides[256];
char     GFX_PathElevators[256];
char     GFX_PathMasked[256];
char     GFX_PathExits[256];
char     GFX_PathABVWSTRT[256];
char     GFX_PathABVMSTRT[256];
char     GFX_PathHMSKSTRT[256];
char     GFX_PathMish[256];
char     GFX_Anim[256];


int GFX_animstart=0,    GFX_animstop=0;
int GFX_wallstart=0,    GFX_wallstop=0;
int GFX_floorstart=0,   GFX_floorstop=0;
int GFX_shapestart=0,   GFX_shapestop=0;
int GFX_gunsstart=0,    GFX_gunsstop=0;
int GFX_doorstart=0,    GFX_doorstop=0;
int GFX_sidestart=0,    GFX_sidestop=0;
int GFX_elevatorstart=0,GFX_elevatorstop=0;
int GFX_exitstart=0,    GFX_exitstop=0;
int GFX_maskedstart=0,  GFX_maskedstop=0;

int GFX_maskedBotLimit=0,  GFX_maskedTopLimit=0;
int GFX_maskedExclude=0;

int GFX_abovewallstart=0,GFX_abovewallstop=0;
int GFX_abovemaskwallstart=0,GFX_abovemaskwallstop=0;
int GFX_himaskstart=0,  GFX_himaskstop=0;
int GFX_titlestart=0,   GFX_titlestop=0;
int GFX_ap_world=0,     GFX_ap_titl=0;
int GFX_trilogo = 0;

extern BOOL  bAbovemaskwall ;
extern BOOL  bAbovewall ;
extern BOOL  bDoors ;
extern BOOL  bElevators  ;
extern BOOL  bExits  ;
extern BOOL  bFloor_Ceilings  ;
extern BOOL  bGuns  ;
extern BOOL  bHswicthes  ;
extern BOOL  bMasked  ;
extern BOOL  bMish  ;
extern BOOL  bShapes  ;
extern BOOL  bSides  ;
extern BOOL  bWalls  ;

int gfxlump;

#define BGBYTE 1

extern void DrawPostPic (int lumpnum);
extern void SwitchPalette (byte * newpal, int steps);
extern void	WriteLBtext(LPSTR txt);
extern void WriteExtPCX (char * file, byte * source, int iWidth, int iHeight);
extern void W_AdjustLumpsize(int lump, int newsize);
extern void ReadPCX (char * file, byte * dest, int iWidth, int iHeight);
extern void DrawIString (unsigned short int x, unsigned short int y, const char *string, int flags);
extern void GLRefresh (void);
extern BOOL  HEAP_freemem(LPVOID lpMem);
extern byte* HEAP_getheapmem(int size);


extern PALETTEENTRY rPal[768]; 
extern HWND	hMainWnd;
extern HINSTANCE hInst;

char *ex_pal = 0;
char *ex_ap_pal = 0;


void ExtractGFX ();
void RotateSavePCXPicture (char * path, byte *src, int iWidth,int  iHeight);
BOOL CheckExternalGFX(void *mem, int lump,  lumpinfo_t *l);
BOOL ConvertRottSpriteIntoPCX (BYTE  *RottSpriteMemptr, BYTE  *RottPCXptr);
BOOL ConvertMaskedRottSpriteIntoPCX (BYTE  *RottSpriteMemptr, BYTE  *RottPCXptr);
BOOL ConvertPCXIntoRottSprite (BYTE  *RottSpriteMemptr, char*szFileName, int lump, int lumplength);
BOOL ConvertPCX (BYTE  *RottSpriteMemptr, char*szFileName, int lump, int lumplength);
BOOL FindReadExtPCXfile(int lump,char*pathname,byte*mem,int limitlow,int limithigh,int w, int h );
void GetPCXlumpname(char* p, char *pfolder, int lump);
BOOL ConvertPCXIntoMaskedRottSprite (BYTE  *RottSpriteMemptr, char*szFileName, int lump, int lumplength);
void PrepareGFX ();
BYTE* ReadExpandPCX(char*fname, PCX_HEADER *pcxHDR);
int  GetTranslevelFilename (char * szFileName);
void ExtrSaveLumpsGrp(int limitlow,int limithigh,char* dir);
BOOL ConvertPCXtoTitlePicType(BYTE* mem,int w,int h );
void WriteBmpEx(char* filename ,byte *src,int picw ,int pich ,int scale, int paltype, BOOL rotate );
void RotatePicture ( byte *src, int iWidth,int  iHeight);
HBITMAP Rotate90(HDC hDC, HBITMAP hSourceBitmap);
BOOL SaveBMP ( void* Buffer, int width, int height,long Buffersize, char* bmpfile,unsigned  char*palt );
void AddTopLevelMessage(int x, int y, char *msg);
unsigned int CalcAverageCol32(unsigned int *pic,  int width);
BOOL ShouldExtractedPicBeSoftned(glump);


int CntNbOfNotBGBYTEbytes(BYTE *src, int w, int h);
int CntNbOfBGBYTEbytes(BYTE *src, int w, int h);

BYTE full[_MAX_PATH]=".\\";

extern unsigned int bufferofs;
extern byte*colormap;
extern byte*origpal;
extern byte*shadingtable;

FILE *streammasterlist = 0;  
extern char GlutErrorMsg[256];
extern DWORD GlutErrorMsgTckCnt;


#define WRITEMASTERLIST if (streammasterlist!= NULL){sprintf(tmp2,"%d %s\n",lump,tmp);fprintf(streammasterlist,tmp2);}


#define GetAValue(rgb)      ((BYTE)(((WORD)(rgb)) >> 24))
//#define GetAValue(rgb)      ((BYTE)((rgb)>>32))
#define RGBA(r,g,b,a)          ((COLORREF)(((BYTE)(r)|((WORD)((BYTE)(g))<<8))|(((DWORD)(BYTE)(b))<<16)|(((DWORD)(BYTE)(a))<<32)))

unsigned int sum  = 0;
unsigned int sumr = 0;
unsigned int sumg = 0;
unsigned int sumb = 0;
unsigned int suma = 0;
unsigned int *pxs = 0;
unsigned char *s,*r1,*g1 ,*t1,*t2,*t3,*m1,*m2,*m3,*b1,*b2,*b3;
BOOL Has9x9pixTranspixel( unsigned int *pic, int width);




void ExtractGFX ()
{
	int length,lump;
	byte *mem;
    char tmp[256];
    char tmp2[256*2];
	patch_t *p;
	BYTE  *RottSpriteMemptr;
	BYTE  *RottPCXptr;


	if (streammasterlist == NULL){
		sprintf(tmp,"%s\\mastergfxlist.txt",GFX_Path);
		if( (streammasterlist  = fopen( tmp, "a+" )) == NULL ) {
			WriteLBtext("Opening of master gfx list failed.");
		}
	}

	WriteLBtext("Extracting GFX");

	if (GFX_wallstart == 0) 
	   PrepareGFX ();


	
	RottSpriteMemptr = HEAP_getheapmem(100000);		
	RottPCXptr = HEAP_getheapmem(100000+5000);

//	RottSpriteMemptr = GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,100000);		
//	RottPCXptr = GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,100000+5000);

	//-------------TITLES PIC---------------------------------------

	AddTopLevelMessage(2, 2,"Extracting/Checking Intro and menu graphics");

	lump = W_GetNumForName ("AP_WRLD");
	GetPCXlumpname(tmp,GFX_PathMish,lump);
	if (access (tmp, 0) != 0){ //does sfxfile exists, if so dont overwrite
		memcpy (&origpal[0], W_CacheLumpName ("ap_pal", PU_CACHE, CvtNull, 1), 768);
		shadingtable = colormap + (1 << 12);
		VL_NormalizePalette (&origpal[0]);
		SwitchPalette (&origpal[0], 35);
	 	DrawPostPic (lump);
		//WriteExtPCX (tmp,bufferofs,320 ,200 );
		gfxlump = lump;
		WriteBmpEx(tmp,(BYTE*)bufferofs,320 ,200,2,2,0); 
		WRITEMASTERLIST

		//RotateSavePCXPicture (tmp,bufferofs,320 ,200);
	}


	lump = W_GetNumForName ("AP_TITL");
	GetPCXlumpname(tmp,GFX_PathMish,lump);
	W_ReadLump (lump, RottSpriteMemptr);
	p = (patch_t*)RottSpriteMemptr;
	if (ConvertRottSpriteIntoPCX (RottSpriteMemptr, RottPCXptr)==TRUE){
		GetPCXlumpname(tmp,GFX_PathMish,lump);
		if (access (tmp, 0) != 0){ //does sfxfile exists, if so dont overwrite
			gfxlump = lump;
			WriteBmpEx (tmp,RottPCXptr,p->width ,p->height,2 ,2, 0);
			WRITEMASTERLIST
		}
	}

	memcpy (&origpal[0], W_CacheLumpName ("pal", PU_CACHE, CvtNull, 1), 768);
	shadingtable = colormap + (1 << 12);
	VL_NormalizePalette (&origpal[0]);
	SwitchPalette (&origpal[0], 35);
	//-------------TITLES PIC END------------------------------------

	//-------------TRIADE LOGO---------------------------------------
	GetPCXlumpname(tmp,GFX_PathMish,GFX_trilogo);		
	DrawPostPic (GFX_trilogo);
	if (access (tmp, 0) != 0){ //does sfxfile exists, if so dont overwrite
		gfxlump = lump;
		WriteBmpEx (tmp,(BYTE*)bufferofs,320 ,200,2 ,1,0);
		WRITEMASTERLIST
	}
	AddTopLevelMessage(2, 2,"Extracting/Checking Intro and menu graphics ...Done");

		//RotateSavePCXPicture (tmp,bufferofs,320 ,200);

/*
	lump = W_GetNumForName ("EPI12");
	W_ReadLump (lump, RottSpriteMemptr);
	p = (patch_t*)RottSpriteMemptr;
	ConvertRottSpriteIntoPCX (RottSpriteMemptr, RottPCXptr);
	GetPCXlumpname(tmp,GFX_PathMish,lump);
	if (access (tmp, 0) != 0) //does sfxfile exists, if so dont overwrite
		WriteExtPCX (tmp,RottPCXptr,p->width ,p->height );

	lump = W_GetNumForName ("EPI34");
	W_ReadLump (lump, RottSpriteMemptr);
	p = (patch_t*)RottSpriteMemptr;
	ConvertRottSpriteIntoPCX (RottSpriteMemptr, RottPCXptr);
	GetPCXlumpname(tmp,GFX_PathMish,lump);
	if (access (tmp, 0) != 0) //does sfxfile exists, if so dont overwrite
		WriteExtPCX (tmp,RottPCXptr,p->width ,p->height );

	lump = W_GetNumForName ("GROUPPIC");
	W_ReadLump (lump, RottSpriteMemptr);
	p = (patch_t*)RottSpriteMemptr;
	ConvertRottSpriteIntoPCX (RottSpriteMemptr, RottPCXptr);
	GetPCXlumpname(tmp,GFX_PathMish,lump);
	if (access (tmp, 0) != 0) //does sfxfile exists, if so dont overwrite
		WriteExtPCX (tmp,RottPCXptr,p->width ,p->height );
*/
	//544
	//515 = SKYSTOP  516 = net1 877 = regend 878 = SHAPSTRT
	
		//	memset(tmp,0,sizeof(tmp));
		//	strncpy(&tmp[0],W_GetNameForNum(515),8);

	AddTopLevelMessage(2, 10,"Extracting/Checking Mish graphics");
	for (lump=W_GetNumForName("SKYSTOP")+1;lump<W_GetNumForName("SHAPSTRT");lump++){
		W_ReadLump (lump, RottSpriteMemptr);
		p = (patch_t*)RottSpriteMemptr;
		GetPCXlumpname(tmp,GFX_PathMish,lump);
		if ((p->width <= 320)&&(p->height <= 200)){
			if ((p->width > 0)&&(p->height > 0)){
				/*ErrorDontQuit(tmp,lump);
				if (lump==868)
					lump=lump;*/
				ConvertRottSpriteIntoPCX (RottSpriteMemptr, RottPCXptr);
				if (access (tmp, 0) != 0){ //does sfxfile exists, if so dont overwrite
					gfxlump = lump;
					WriteBmpEx (tmp,RottPCXptr,p->width ,p->height,2,1,0 );
					WRITEMASTERLIST
				}
			}
		}//else 
			//lumpinfo[lump].size
//			WriteExtPCX (tmp,RottSpriteMemptr,sqrt( W_LumpLength(lump)),sqrt( W_LumpLength(lump)));

	}
	AddTopLevelMessage(2, 10,"Extracting/Checking Mish graphics ...Done");

	//781 = PLANE
	//877 = REGEND
	AddTopLevelMessage(2, 18,"Extracting/Checking Title graphics");
	for (lump = GFX_titlestart; lump <= GFX_titlestop; lump++){
		length = W_LumpLength (lump);
		W_ReadLump (lump, RottSpriteMemptr);
		p = (patch_t*)RottSpriteMemptr;
		ConvertRottSpriteIntoPCX (RottSpriteMemptr, RottPCXptr);
		GetPCXlumpname(tmp,GFX_PathMish,lump);
		if (access (tmp, 0) != 0){ //does sfxfile exists, if so dont overwrite
			gfxlump = lump;
			WriteBmpEx (tmp,RottPCXptr,p->width ,p->height,2 ,1, 0);
			WRITEMASTERLIST
		}
	}
	AddTopLevelMessage(2, 18,"Extracting/Checking Title graphics ...Done");



	AddTopLevelMessage(2, 26,"Extracting/Checking Wall graphics");
	for (lump = GFX_wallstart; lump <= GFX_wallstop; lump++){
		length = W_LumpLength (lump);
		//mem = GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,length);
		mem = HEAP_getheapmem(length);		
		W_ReadLump (lump, mem);
		GetPCXlumpname(tmp,GFX_PathWalls,lump);
		if (access (tmp, 0) != 0){ //does sfxfile exists, if so dont overwrite
			gfxlump = lump;
			WriteBmpEx (tmp,mem,64,64,4 ,1,1);
			WRITEMASTERLIST
		}
			//RotateSavePCXPicture (tmp,mem,64,64);
		//GlobalFree (mem); 
		HEAP_freemem(mem);
	}
	AddTopLevelMessage(2, 26,"Extracting/Checking Wall graphics ...Done");






	AddTopLevelMessage(2, 34,"Extracting/Checking Floor/Ceiling graphics");
	for (lump = GFX_floorstart; lump <= GFX_floorstop; lump++){
		length = W_LumpLength (lump);
		//mem = GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,length+64);
		mem = HEAP_getheapmem(length+64);		

		W_ReadLump (lump, mem);
		GetPCXlumpname(tmp,GFX_PathFloor_Ceil,lump);
		if (access (tmp, 0) != 0){ //does sfxfile exists, if so dont overwrite
			gfxlump = lump;
			WriteBmpEx (tmp,mem+8,128,128,4 ,1,1);
			WRITEMASTERLIST
		}
		//GlobalFree (mem);
		HEAP_freemem(mem);

	}
	AddTopLevelMessage(2, 34,"Extracting/Checking Floor/Ceiling graphics ...Done");

/*
	for (ix = 1; ix <= 16; ix++){
		sprintf(tmp,"FLRCL%d\0",ix);
		lump = W_GetNumForName(tmp);
		length = W_LumpLength (lump);
		mem = GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,length+100000);


		GetPCXlumpname(tmp,GFX_PathFloor_Ceil,lump);

 
		if (access (tmp, 0) != 0){ //does sfxfile exists, if so dont overwrite
		W_ReadLump (lump, mem);
			WriteBmpEx (tmp,mem+8,128,128,4 ,1,1);
			WRITEMASTERLIST
			//RotateSavePCXPicture (tmp,mem,128,128);
		}
		GlobalFree (mem);
	}
*/

	AddTopLevelMessage(2, 42,"Extracting/Checking Shapes graphics");
	for (lump = GFX_shapestart; lump <= GFX_shapestop; lump++){
		memset(RottSpriteMemptr,0xFF,100000);
		length = W_LumpLength (lump);

		W_ReadLump (lump, RottSpriteMemptr);
	    p = (patch_t*)RottSpriteMemptr;

		if (p->collumnofs [0]>p->collumnofs [1])
			ConvertMaskedRottSpriteIntoPCX (RottSpriteMemptr, RottPCXptr);
		else
			ConvertRottSpriteIntoPCX (RottSpriteMemptr, RottPCXptr);

		GetPCXlumpname(tmp,GFX_PathShape,lump);
		if (access (tmp, 0) != 0){ //does sfxfile exists, if so dont overwrite
			gfxlump = lump;
			WriteBmpEx (tmp,RottPCXptr,p->width ,p->height,4,1,0 );
			WRITEMASTERLIST
		}

	}
	AddTopLevelMessage(2, 42,"Extracting/Checking Shapes graphics ...Done");
		

	AddTopLevelMessage(2, 50,"Extracting/Checking Guns graphics");
	for (lump = GFX_gunsstart; lump <= GFX_gunsstop; lump++){
		length = W_LumpLength (lump);

		W_ReadLump (lump, RottSpriteMemptr);
		p = (patch_t*)RottSpriteMemptr;

		if (ConvertRottSpriteIntoPCX (RottSpriteMemptr, RottPCXptr)==TRUE){
			GetPCXlumpname(tmp,GFX_PathGuns,lump);
			if (access (tmp, 0) != 0){ //does sfxfile exists, if so dont overwrite
				gfxlump = lump;
				WriteBmpEx (tmp,RottPCXptr,p->width ,p->height,4,1,0 );
				WRITEMASTERLIST
			}
		}
	}
	AddTopLevelMessage(2, 50,"Extracting/Checking Guns graphics ...Done");


	AddTopLevelMessage(2, 58,"Extracting/Checking Door graphics");
	for (lump = GFX_doorstart; lump <= GFX_doorstop; lump++){
		length = W_LumpLength (lump);

		W_ReadLump (lump, RottSpriteMemptr);
		p = (patch_t*)RottSpriteMemptr;

		if (ConvertRottSpriteIntoPCX (RottSpriteMemptr, RottPCXptr)==TRUE){
			GetPCXlumpname(tmp,GFX_PathDoors,lump);
			if (access (tmp, 0) != 0){ //does sfxfile exists, if so dont overwrite
				gfxlump = lump;
				WriteBmpEx (tmp,RottPCXptr,p->width ,p->height,4 ,1,0);
				WRITEMASTERLIST
			}
		}else{
			length = W_LumpLength (lump);
			//mem = GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,length);
			mem = HEAP_getheapmem(length);		

			W_ReadLump (lump, mem);

			GetPCXlumpname(tmp,GFX_PathDoors,lump);
			if (access (tmp, 0) != 0){ //does sfxfile exists, if so dont overwrite
				//RotateSavePCXPicture (tmp,mem,64,64);
				gfxlump = lump;
				WriteBmpEx (tmp,mem,64,64,4 ,1,1);
				WRITEMASTERLIST
			}
			//GlobalFree (mem);
			HEAP_freemem(mem);

		}

	}
	AddTopLevelMessage(2, 58,"Extracting/Checking Door graphics ...Done");

	AddTopLevelMessage(2, 66,"Extracting/Checking Sides graphics");
	for (lump = GFX_sidestart; lump <= GFX_sidestop; lump++){
		length = W_LumpLength (lump);
		//mem = GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,length);
		mem = HEAP_getheapmem(length);		

		W_ReadLump (lump, mem);
		GetPCXlumpname(tmp,GFX_PathSides,lump);
		if (access (tmp, 0) != 0){ //does sfxfile exists, if so dont overwrite
			//RotateSavePCXPicture (tmp,mem,64,64);
			gfxlump = lump;
			WriteBmpEx (tmp,mem,64,64,4 ,1,1);
			WRITEMASTERLIST
		}
		//GlobalFree (mem);
		HEAP_freemem(mem);

	}
	AddTopLevelMessage(2, 66,"Extracting/Checking Sides graphics ...Done");

	AddTopLevelMessage(2, 74,"Extracting/Checking Elevator graphics");
	for (lump = GFX_elevatorstart; lump <= GFX_elevatorstop; lump++){
		length = W_LumpLength (lump);
		//mem = GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,length);
		mem = HEAP_getheapmem(length);		

		W_ReadLump (lump, mem);
		GetPCXlumpname(tmp,GFX_PathElevators,lump);
		if (access (tmp, 0) != 0){ //does sfxfile exists, if so dont overwrite
			//RotateSavePCXPicture (tmp,mem,64,64);
			gfxlump = lump;
			WriteBmpEx (tmp,mem,64,64,4 ,1,1);
			WRITEMASTERLIST
		}

		//GlobalFree (mem);
		HEAP_freemem(mem);

	}
	AddTopLevelMessage(2, 74,"Extracting/Checking Elevator graphics ...Done");

	AddTopLevelMessage(2, 82,"Extracting/Checking Masked graphics");
	for (lump = GFX_maskedstart; lump <= GFX_maskedstop; lump++){
		transpatch_t *tp;
		length = W_LumpLength (lump);

		W_ReadLump (lump, RottSpriteMemptr);
		tp = (transpatch_t*)RottSpriteMemptr;
		ConvertMaskedRottSpriteIntoPCX (RottSpriteMemptr, RottPCXptr);
		GetPCXlumpname(tmp,GFX_PathMasked,lump);
		if (access (tmp, 0) != 0) {//does sfxfile exists, if so dont overwrite
		//	char lumpname[64];
		//	memset(lumpname,0,sizeof(lumpname));
		//	strncpy(&lumpname[0],W_GetNameForNum(lump),8);
		//	sprintf(tmp,"%s%s#%d.BMP",GFX_PathMasked,lumpname,tp->translevel );
			gfxlump = lump;
			WriteBmpEx (tmp,RottPCXptr,64,64,4,1,0);//p->width ,p->height );
			WRITEMASTERLIST
		}
	}
	AddTopLevelMessage(2, 82,"Extracting/Checking Masked graphics ...Done");

	AddTopLevelMessage(2, 90,"Extracting/Checking Exits graphics");
	ExtrSaveLumpsGrp(GFX_exitstart,GFX_exitstop,GFX_PathExits);
	AddTopLevelMessage(2, 90,"Extracting/Checking Exits graphics ...Done");


	AddTopLevelMessage(2, 98,"Extracting/Checking Abovewall graphics");
	ExtrSaveLumpsGrp(GFX_abovewallstart,GFX_abovewallstop,GFX_PathABVWSTRT);
	AddTopLevelMessage(2, 98,"Extracting/Checking Abovewall graphics ...Done");


	AddTopLevelMessage(2, 106,"Extracting/Checking Abovemaskwall graphics");
	ExtrSaveLumpsGrp(GFX_abovemaskwallstart,GFX_abovemaskwallstop,GFX_PathABVMSTRT);
	AddTopLevelMessage(2, 106,"Extracting/Checking Abovemaskwall graphics ...Done");


	AddTopLevelMessage(2, 114,"Extracting/Checking Himask graphics");
	//ExtrSaveLumpsGrp(GFX_himaskstart,GFX_himaskstop,GFX_PathHMSKSTRT);
	for (lump = GFX_himaskstart; lump <= GFX_himaskstop; lump++){
		transpatch_t *tp;
		length = W_LumpLength (lump);

		W_ReadLump (lump, RottSpriteMemptr);
		tp = (transpatch_t*)RottSpriteMemptr;
		ConvertMaskedRottSpriteIntoPCX (RottSpriteMemptr, RottPCXptr);
		GetPCXlumpname(tmp,GFX_PathHMSKSTRT,lump);
		if (access (tmp, 0) != 0) {//does sfxfile exists, if so dont overwrite
			char lumpname[64];
			memset(lumpname,0,sizeof(lumpname));
			strncpy(&lumpname[0],W_GetNameForNum(lump),8);
			//sprintf(tmp,"%s%s#%d.BMP",GFX_PathHMSKSTRT,lumpname,tp->translevel );
			sprintf(tmp,"%s%s.BMP",GFX_PathHMSKSTRT,lumpname );
			gfxlump = lump;
			WriteBmpEx (tmp,RottPCXptr,64,64,4,1,0);//p->width ,p->height );
			WRITEMASTERLIST
		}
	} 
	AddTopLevelMessage(2, 114,"Extracting/Checking Himask graphics ...Done");


///ver 1.74
	AddTopLevelMessage(2, 122,"Extracting/Checking Animated walls graphics");
	for (lump = GFX_animstart; lump <= GFX_animstop; lump++){
		length = W_LumpLength (lump);
		mem = HEAP_getheapmem(length);		
		W_ReadLump (lump, mem);
		GetPCXlumpname(tmp,GFX_Anim,lump);
		if (access (tmp, 0) != 0){ //does sfxfile exists, if so dont overwrite
			gfxlump = lump;
			WriteBmpEx (tmp,mem,64,64,4 ,1,1);
			WRITEMASTERLIST
		}

		HEAP_freemem(mem);
	}
	AddTopLevelMessage(2, 122,"Extracting/Checking Animated Wall graphics ...Done");

///ver 1.74 end


  
	AddTopLevelMessage(2, 130,"Done");

	//GlobalFree (RottSpriteMemptr);
	//GlobalFree (RottPCXptr);
	HEAP_freemem (RottSpriteMemptr);
	HEAP_freemem (RottPCXptr);
	

	VL_ClearBuffer (bufferofs, 255);

	if (streammasterlist != NULL)
		fclose(streammasterlist );
}



BOOL CheckExternalGFX(void *mem, int lump,  lumpinfo_t *l)
{
	char gfxpath[256];
	int lumplength = l->size;
	int tag = 0;

	if (bUseExternalGFX == FALSE)
		return FALSE;

	if (GFX_wallstart == 0) 
	   PrepareGFX ();


	GetPCXlumpname(gfxpath,GFX_PathWalls,lump);
	if (FindReadExtPCXfile(lump,gfxpath,mem,GFX_wallstart,GFX_wallstop,64,64))
		return TRUE;

	///ver 1.74
	GetPCXlumpname(gfxpath,GFX_Anim,lump);
	if (FindReadExtPCXfile(lump,gfxpath,mem,GFX_animstart,GFX_animstop,64,64))
		return TRUE;


	if (l->size == 64008){	//64008 = 320 * 200 + headr (8), must be a lpic_t
		lpic_t *pic;
		pic = (lpic_t*)mem;
		GetPCXlumpname(gfxpath,GFX_PathMish,lump);
		if (access (gfxpath, 0) == 0){ //does sfxfile exists
			ReadPCX(gfxpath,&pic->data,320,200 );
			ConvertPCXtoTitlePicType(&pic->data, 320,200 );
			return TRUE;
		}
	}

	if (lump == GFX_ap_titl){
		GetPCXlumpname(gfxpath,GFX_PathMish,lump);
		if (access (gfxpath, 0) == 0){ //does sfxfile exists
			ConvertPCXIntoRottSprite (mem, gfxpath, lump, l->size);
			return TRUE;
		}
	}


	if ((lump >= W_GetNumForName("SKYSTOP")+1)&&(lump <= W_GetNumForName("SHAPSTRT"))){
		GetPCXlumpname(gfxpath,GFX_PathMish,lump);
		if (access (gfxpath, 0) == 0){ //does sfxfile exists
			ConvertPCXIntoRottSprite (mem, gfxpath, lump, lumplength);
			return TRUE;
		} 
	}

	if ((lump >= GFX_floorstart)&&(lump <= GFX_floorstop)){
		GetPCXlumpname(gfxpath,GFX_PathFloor_Ceil,lump);
		if (FindReadExtPCXfile(lump,gfxpath,mem,GFX_floorstart,GFX_floorstop,128,128))
			return TRUE;
	}


	if ((lump >= GFX_shapestart)&&(lump <= GFX_shapestop)){
		GetPCXlumpname(gfxpath,GFX_PathShape,lump);
		if (access (gfxpath, 0) == 0){ //does sfxfile exists
			ConvertPCXIntoRottSprite (mem, gfxpath, lump, lumplength);
			return TRUE;
		} 
	}


	if ((lump >= GFX_gunsstart)&&(lump <= GFX_gunsstop)){
		GetPCXlumpname(gfxpath,GFX_PathGuns,lump);
		if (access (gfxpath, 0) == 0){ //does sfxfile exists
			//Z_Free(lumpcache[lump]);
			//Z_Malloc (W_LumpLength (lump)+1000, tag, &lumpcache[lump]);
			//W_ReadLump (lump, lumpcache[lump]);

			ConvertPCXIntoRottSprite (mem, gfxpath, lump, lumplength);
			return TRUE;
		} 
	}


	if ((lump >= GFX_doorstart)&&(lump <= GFX_doorstop)){
		GetPCXlumpname(gfxpath,GFX_PathDoors,lump);
		if (access (gfxpath, 0) == 0){ //does sfxfile exist
			if (lumplength == 4096){
				FindReadExtPCXfile(lump,gfxpath,mem,GFX_doorstart,GFX_doorstop,64,64);
			}else{
				ConvertPCXIntoRottSprite ((char*)mem, gfxpath, lump, lumplength);
			}
			return TRUE;
		}
	} 

	GetPCXlumpname(gfxpath,GFX_PathSides,lump);
	if (FindReadExtPCXfile(lump,gfxpath,mem,GFX_sidestart,GFX_sidestop,64,64))
		return TRUE;


	GetPCXlumpname(gfxpath,GFX_PathElevators,lump);
	if (FindReadExtPCXfile(lump,gfxpath,mem,GFX_elevatorstart,GFX_elevatorstop,64,64))
		return TRUE;



	GetPCXlumpname(gfxpath,GFX_PathMasked,lump);
	if ((lump >= GFX_maskedstart)&&(lump <= GFX_maskedstop)){
		GetTranslevelFilename (gfxpath);
		if (access (gfxpath, 0) == 0){ //does sfxfile exist
				//Z_Free(lumpcache[lump]);
				//Z_Malloc (6000, tag, &lumpcache[lump]);
				ConvertPCXIntoMaskedRottSprite (mem, gfxpath, lump, lumplength);
			    return TRUE;			
		}
	}



	GetPCXlumpname(gfxpath,GFX_PathExits,lump);
	if ((lump >= GFX_exitstart)&&(lump <= GFX_exitstop)){
		if (access (gfxpath, 0) == 0){ //does sfxfile exists
			ConvertPCXIntoRottSprite (mem, gfxpath, lump, lumplength);
			return TRUE;
		} 
	}

	//above doors and ect.
	GetPCXlumpname(gfxpath,GFX_PathABVWSTRT,lump);
	if ((lump >= GFX_abovewallstart)&&(lump <= GFX_abovewallstop)){
		if (access (gfxpath, 0) == 0){ //does sfxfile exists
			if (lumplength == 4096){
				FindReadExtPCXfile(lump,gfxpath,mem,GFX_abovewallstart,GFX_abovewallstop,64,64);
			}else{
				ConvertPCXIntoRottSprite ((char*)mem, gfxpath, lump, lumplength);
			}
			return TRUE;
		} 
	}

	GetPCXlumpname(gfxpath,GFX_PathABVMSTRT,lump);
	if ((lump >= GFX_abovemaskwallstart)&&(lump <= GFX_abovemaskwallstop)){
		if (access (gfxpath, 0) == 0){ //does sfxfile exists
			ConvertPCXIntoRottSprite (mem, gfxpath, lump, lumplength);
			return TRUE;
		} 
	}
		
	GetPCXlumpname(gfxpath,GFX_PathHMSKSTRT,lump);
	if ((lump >= GFX_himaskstart)&&(lump <= GFX_himaskstop)){
		GetTranslevelFilename (gfxpath);
		if (access (gfxpath, 0) == 0){ //does sfxfile exists
			ConvertPCXIntoMaskedRottSprite (mem, gfxpath, lump, lumplength);
			return TRUE;
		} 
	}


return FALSE;

}


void GetPCXlumpname(char* p, char *pfolder, int lump)
{
	char lumpname[64];
	strcpy(p,pfolder);
	memset(lumpname,0,sizeof(lumpname));
	strncpy(&lumpname[0],W_GetNameForNum(lump),8);
	strcat(p,lumpname);
	strcat(p,".BMP");	

}


BOOL FindReadExtPCXfile(int lump,char*pathname,byte*mem,int limitlow,int limithigh,int w, int h )
{
	//read in external floor/ceiling graphics
	if ((lump >= limitlow)&&(lump <= limithigh)){
		if (access (pathname, 0) == 0) {//does sfxfile exists
			//yes read it in
			byte *tmp1=mem,*tmp=0;int x,y;
			//tmp =  GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,(w*h)+1000);
			tmp = HEAP_getheapmem((w*h)+1000);		
				

			ReadPCX(pathname,tmp,w,h );
			//rotate pic
			for (x = 0; x < w ; x++){
				for (y=0;y<h;y++){
					if (*(tmp+(y*h)+x) != BGBYTE)
					   *(tmp1) = *(tmp+(y*h)+x) ;
						tmp1++;
				}
			}
			//GlobalFree(tmp);//release mem;
			HEAP_freemem(tmp);
			return TRUE;
		}
	}

	return FALSE;
}





void ExtrSaveLumpsGrp(int limitlow,int limithigh,char* dir)
{
	int length,lump;
	patch_t* p;
	char tmp[264];
	char tmp2[264*2];
	BYTE* mem;
	//BYTE* RottSpriteMemptr = GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,100000);		
	//BYTE* RottPCXptr = GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,100000+5000);

	BYTE* RottSpriteMemptr = HEAP_getheapmem(100000);		
	BYTE* RottPCXptr = HEAP_getheapmem(100000+5000);



	for (lump = limitlow; lump <= limithigh; lump++){
		length = W_LumpLength (lump);

		W_ReadLump (lump, RottSpriteMemptr);
		p = (patch_t*)RottSpriteMemptr;

		if (ConvertRottSpriteIntoPCX (RottSpriteMemptr, RottPCXptr)==TRUE){
			GetPCXlumpname(tmp,dir,lump);
			if (access (tmp, 0) != 0){ //does sfxfile exists, if so dont overwrite
				//WriteExtPCX (tmp,RottPCXptr,p->width ,p->height );
				gfxlump = lump;
				WriteBmpEx (tmp,RottPCXptr,p->width ,p->height,4 ,1,0);
				WRITEMASTERLIST
			}

		}else{
			length = W_LumpLength (lump);
			//mem = GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,length);
			mem = HEAP_getheapmem(length);
			W_ReadLump (lump, mem);
			GetPCXlumpname(tmp,dir,lump);
			if (access (tmp, 0) != 0){ //does sfxfile exists, if so dont overwrite
				//RotateSavePCXPicture (tmp,mem,64,64);
				gfxlump = lump;
				WriteBmpEx (tmp,mem,64,64,4 ,1,1);
				WRITEMASTERLIST
			}
			//GlobalFree (mem);
			HEAP_freemem(mem);

		}

	}
	//GlobalFree (RottPCXptr);
	//GlobalFree (RottSpriteMemptr);

	HEAP_freemem (RottPCXptr);
	HEAP_freemem (RottSpriteMemptr);
		

}










void RotateSavePCXPicture (char * path, byte *src, int iWidth,int  iHeight)
{
	byte *mem;
	int w,h;
	
	//mem = GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,(iWidth*iHeight)+4000);
	mem = HEAP_getheapmem((iWidth*iHeight)+4000);

	for (h=0;h<iWidth;h++){
		for (w=0;w<iHeight;w++){
			*(mem+(iWidth*w)+h) = *(src++);
		}
	}

	WriteExtPCX (path,mem,iWidth,iHeight);

	//GlobalFree (mem);//release mem
	HEAP_freemem(mem);
}

void RotatePicture ( byte *src, int iWidth,int  iHeight)
{
	byte *mem,*tmpsrc, *m;
	int w,h;
	
	tmpsrc = src;
	//mem = GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,(iWidth*iHeight)+4000);
	mem = HEAP_getheapmem((iWidth*iHeight)+4000);
	m = mem;
	for (w=0;w<iWidth;w++){
		tmpsrc = src + w;
		for (h=0;h<iHeight;h++){
			*(m++) = *(tmpsrc+(h*iWidth));
		}
	}
	memcpy(src,mem,iWidth*iHeight);
	//GlobalFree (mem);//release mem
	HEAP_freemem(mem);
}

BOOL ConvertRottSpriteIntoPCX (BYTE  *RottSpriteMemptr, BYTE  *RottPCXptr)
{

    BYTE *ptr,*old,*src,*wrksrc;
    unsigned int count=0,x,y,EmthyPixCnt,NbOfPix;
	patch_t *p;

	//on entry RottPCXptr must point to a me area of correct pcx size
	//RottSpriteMemptr contains ptr to sprite

	p = (patch_t*)RottSpriteMemptr;
	src = RottSpriteMemptr;

	if ((p->width <= 1)||(p->height <= 1))
		return FALSE;
	if ((p->width > 320)||(p->height >= 256))
		return FALSE;

	//set the background color in pcx
	memset (RottPCXptr,BGBYTE,(p->width*p->height)+512);
	ptr = RottPCXptr;
	if ((p->width*p->height) >= 120000){
		// ("Error in Sprite header size");
		return FALSE;
	}

	for (x = 0; x < (unsigned)(p->width); x++){
		wrksrc = src+(p->collumnofs[x]);//wrksrc points to data in src
		old = ptr;//ptr = where to store our new pcx pic data
		while (*(wrksrc++) != 0xFF){
			EmthyPixCnt = *(wrksrc-1);//get nb of pixel to skip in collum
			NbOfPix     = *(wrksrc++);//get nb of pixels to draw
			ptr = old+(EmthyPixCnt*p->width);//caculate start point of target
			for (y = 0; y < NbOfPix; y++){//copy pixels to target mem 
				(*ptr)=*(wrksrc++);
				if (*ptr == BGBYTE)//if there is a color like BGBYTE
					*ptr = 16;//change it to 16 (allmost white)
				ptr += p->width;
			}
		}
		ptr=old+1;//increase to next col
	}
	return TRUE;
}



BOOL ConvertMaskedRottSpriteIntoPCX (BYTE  *RottSpriteMemptr, BYTE  *RottPCXptr)
{

#define ALPHA_SHIFT 24

    transpatch_t *ppat = (transpatch_t *) RottSpriteMemptr;
    int i, j, ofs, rlen;
    BYTE *idpos = RottPCXptr;
    BYTE *spos;
    BYTE *dpos;
    int tmask = (63 - ppat->translevel) << (ALPHA_SHIFT+2);
    unsigned short *ccolofs = (unsigned short*)ppat->collumnofs;

    memset (RottPCXptr, BGBYTE, ppat->width * ppat->height * 4);

    for (i = 0; i < ppat->width; i++, ccolofs++) {
		spos = (((BYTE *) ppat) + (*ccolofs));
		while (1) {
			if ((ofs = *(spos++)) == 0xFF) {
				break;
			} else {
				rlen = *(spos++);
				dpos = (idpos + (i + (ppat->width * ofs)));
				if (*spos == 254) {
					for (j = 0; j < rlen; j++, dpos += ppat->width )
						*dpos = 0;
					spos++;
				} else {
					for (j = 0; j < rlen; j++, spos++, dpos += ppat->width ){
						*dpos = *spos;
						if (*dpos == BGBYTE)//if there is a color like BGBYTE
							*dpos = 16;//change it to 16 (allmost white)
					}
				}
			}
		}
	}
	return TRUE;
}








BOOL ConvertPCXIntoRottSprite (BYTE  *RottSpriteMemptr, char*szFileName, int lump, int lumplength)
{
   PCX_HEADER pcxHDR;
   patch_t *p,*org; 
   int newspritelen;
    BYTE *tempbuffer,*ptr,*patchmem,*ptm,*old, *oldptr;
    unsigned int ynb,x,y,xcnt=0,cnt=0,picsize;//,picsize = 4096;
    unsigned int tabelptr,totalHeightCount, oldynb;


	memset(&pcxHDR,0,sizeof(PCX_HEADER));
	tempbuffer = ReadExpandPCX(szFileName, &pcxHDR);
	if (tempbuffer <= 0)
		return FALSE;
	//picture is now in mem

	//find the orginal offset values
	//patchmem =  GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,picsize+2256);
	//if (patchmem <= 0)
	//	return FALSE;
	//W_ReadLump (lump, patchmem);
/*	patchmem = RottSpriteMemptr;
	p = (patch_t*)patchmem;
	leftoffset = p->leftoffset;
	if ((leftoffset > 256)||(leftoffset < -256))
		leftoffset = 0;
	topoffset = p->topoffset;
	if ((topoffset > 256)||(topoffset < -256))
		topoffset = 0;
*/

	//GlobalFree (patchmem);//release mem

	//create a patch_t to put data into
	picsize = (pcxHDR.xmax+1)*(pcxHDR.ymax+1);
	//patchmem =  (BYTE *)GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,picsize+6000);
	patchmem = HEAP_getheapmem(picsize+6000);
	if (patchmem <= 0)
		return FALSE;

	//patchmem = RottSpriteMemptr;
	p = (patch_t*)patchmem;
	org = (patch_t*)RottSpriteMemptr;
	ptr = tempbuffer;


	p->origsize = org->origsize;
	p->height = pcxHDR.ymax+1;
	p->width  = pcxHDR.xmax+1;
	p->leftoffset  = org->leftoffset;
	p->topoffset  = org->topoffset;
	p->collumnofs[0] = (sizeof(short)*5)+(2*p->width );//=2*sizeof char)
/*
	patchmem = RottSpriteMemptr;
	p = (patch_t*)patchmem;
	ptr = tempbuffer;
*/
	tabelptr = p->collumnofs[0];
	for (x=0;x<(unsigned short)p->width;x++){
		p->collumnofs[x] = tabelptr;//=2*sizeof char)
		oldptr = ptr;
		//now count height of collum yofs,ynb
		totalHeightCount=0;oldynb=0;
		ptm = patchmem + p->collumnofs[x];
		for (y=0;y<=(unsigned short)p->height;y++){//(not visible)
			cnt=0;
			//count nb not visible (1's)of pixels down to first pixels
			while (((*ptr) == BGBYTE)&&(cnt<(unsigned short)p->height)){cnt++;ptr+=p->width;totalHeightCount++;}
			//not 1 reached, count nb of them
			if (totalHeightCount >= (unsigned short)p->height){
				*(ptm) = 0xFF;
				break;}
			ynb = 0;
			old = ptm+2;
			oldynb = totalHeightCount;
			while (((*ptr) != BGBYTE)&&(totalHeightCount<(unsigned short)p->height)){
				(*old++) = (*ptr);
				ynb++;totalHeightCount++;
				ptr += p->width;
			}
			//write these 2 nbs (points to from tabel, who points to len and start)
			(*ptm++) = oldynb;
			(*ptm++) = ynb;

			//calculate next table pointer
			tabelptr += ynb+2; //char cnt + ynb + 0xFF = 3 bytes
			ptm= old;
			//those 2 nbs found, begin copying data to target
		}	tabelptr += 1; //char cnt + ynb + 0xFF = 3 bytes
		ptr = oldptr + 1;

	}

	//calc new sprite size
	newspritelen = (ptm - patchmem) + 1;
	if (newspritelen <= lumplength)
		newspritelen = lumplength;
	//adjust mem to our new size
	if (newspritelen > lumplength){ 
		Z_Realloc (&RottSpriteMemptr, newspritelen);
		W_AdjustLumpsize(lump, newspritelen);
		lumpcache[lump] = RottSpriteMemptr;
	}
	//copy new sprite to target mem
	//memset(RottSpriteMemptr,0xFF,newspritelen);
	memcpy(RottSpriteMemptr,patchmem,newspritelen);

//	ZmemSize = Z_GetSize (RottSpriteMemptr);
//	memcpy(RottSpriteMemptr,patchmem,ZmemSize);
	//GlobalFree (patchmem);//release mem
	//GlobalFree (tempbuffer);//release mem
	HEAP_freemem (patchmem);//release mem
	HEAP_freemem (tempbuffer);//release mem

	return TRUE;

}



BOOL ConvertPCXIntoMaskedRottSprite (BYTE  *RottSpriteMemptr, char*szFileName, int lump, int lumplength)
{
   PCX_HEADER pcxHDR;
   transpatch_t *tp;
    int newspritelen;
	int leftoffset,topoffset,translevel;	
    BYTE *tempbuffer,*ptr,*patchmem,*ptm,*old, *oldptr;
    unsigned int ynb,x,y,xcnt=0,cnt=0;//,picsize = 4096;
    unsigned int tabelptr,totalHeightCount, oldynb;
	char externtranslevel = -1;

	//does there exists a name with # in it?
	externtranslevel = GetTranslevelFilename (szFileName);


/*

	if (ptr = strchr(szFileName,'#') != 0){
		char tmp[264];


		externtranslevel = atol(ptr+1);	
		*ptr = 0;
		lstrcat(szFileName,".PCX");
	}
*/

	memset(&pcxHDR,0,sizeof(PCX_HEADER));
	tempbuffer = ReadExpandPCX(szFileName, &pcxHDR);
	//picture is now in mem

	//find the orginal offset values
	//patchmem =  GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,6000);
	//W_ReadLump (lump, patchmem);
	patchmem = RottSpriteMemptr;
	tp = (transpatch_t*)patchmem;
	leftoffset = tp->leftoffset;
	topoffset = tp->topoffset;
	translevel = tp->translevel;
	//GlobalFree (patchmem);//release mem

	//create a patch_t to put data into
	//patchmem =  (BYTE *)GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,6000);
	patchmem = HEAP_getheapmem(6000);

	//patchmem = RottSpriteMemptr;

	tp = (transpatch_t*)patchmem;
	ptr = tempbuffer;


	tp->origsize = 128;
	tp->height = pcxHDR.ymax+1;
	tp->width  = pcxHDR.xmax+1;
	tp->leftoffset  = leftoffset;
	tp->topoffset  = topoffset;
	if (externtranslevel >= 0)
		tp->translevel = externtranslevel;
	else
		tp->translevel = translevel;
	tp->collumnofs[0] = (sizeof(short)*6)+(2*tp->width );//=2*sizeof char)



	tabelptr = tp->collumnofs[0];
	for (x=0;x<(unsigned short)tp->width;x++){
		tp->collumnofs[x] = tabelptr;//=2*sizeof char)
		oldptr = ptr;
		//now count height of collum yofs,ynb
		totalHeightCount=0;oldynb=0;
		ptm = patchmem + tp->collumnofs[x];
		for (y=0;y<=(unsigned short)tp->height;y++){//(not visible)
			cnt=0;
			//count nb not visible (1's)of pixels down to first pixels
			while (((*ptr) == BGBYTE)&&(cnt<(unsigned short)tp->height)){cnt++;ptr+=(unsigned short)tp->width;totalHeightCount++;}
			//not 1 reached, count nb of them
			if (totalHeightCount >= (unsigned short)tp->height){
				*(ptm) = 0xFF;
				break;}
			ynb = 0;
			old = ptm+2;
			oldynb = totalHeightCount;
			while (((*ptr) != BGBYTE)&&(totalHeightCount<(unsigned short)tp->height)){
				(*old++) = (*ptr);
				ynb++;totalHeightCount++;
				ptr += tp->width;
			}
			//write these 2 nbs (points to from tabel, who points to len and start)
			(*ptm++) = oldynb;
			(*ptm++) = ynb;

			//calculate next table pointer
			tabelptr += ynb+2; //char cnt + ynb + 0xFF = 3 bytes
			ptm= old;
			//those 2 nbs found, begin copying data to target
		}	tabelptr += 1; //char cnt + ynb + 0xFF = 3 bytes
		ptr = oldptr + 1;

	}

	//calc new sprite size
	newspritelen = (ptm - patchmem) + 1;
	if (newspritelen <= lumplength)
		newspritelen = lumplength;
	//adjust mem


	if (newspritelen > lumplength){
   // void *newptr;
   // newptr = SafeMalloc (5000);
		Z_Realloc (&RottSpriteMemptr, newspritelen);
		W_AdjustLumpsize(lump, newspritelen);
		lumpcache[lump] = RottSpriteMemptr;
	}
	
//	ZmemSize = Z_GetSize (RottSpriteMemptr);
	memcpy(RottSpriteMemptr,patchmem,newspritelen);
	//GlobalFree (patchmem);//release mem
	//GlobalFree (tempbuffer);//release mem
	HEAP_freemem (patchmem);//release mem
	HEAP_freemem (tempbuffer);//release mem

	return 1;




/*
	memset(table,-1,sizeof(table));

	for (x = 0; x < 64; x++){
		BYTE tby;
		tby = 0;
		t = 0;
		yofs = 0;
		if (x==16)
			t=0;
		for (y = 0;y < 64; ){//(not visible)
			src = tempbuffer + x + (y*64);
			table[x][tby++] = y; 
			if (*src == BGBYTE){
				cnt = CntNbOfBGBYTEbytes(src,64,64-y);
				table[x][tby++] = cnt;
				table[x][tby++] = 0xFE;				
			
			}else{
				cnt = CntNbOfNotBGBYTEbytes(src,64,64-y);
				table[x][tby++] = cnt;
				for (i = y; i < cnt+y; i++){
					table[x][tby++] = *src;
					src += 64;
				}
				i=i;
				//t++;
				//table[x][tby++] = *src;
			}
			y += cnt; 
		}
		table[x][tby++] = 0xFF;
		table[x][tby++] = 0xFF;
		table[x][68] = tby - 1;
	}


	//picture is now in mem

	//find the orginal offset values
	patchmem =  RottSpriteMemptr;//GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,picsize+2256);
	memset(patchmem,0,6000);
	W_ReadLump (lump, patchmem);
	tp = (transpatch_t*)patchmem;

	memcpy (test,RottSpriteMemptr,5000);

	tp->height = pcxHDR->ymax+1;
	tp->width  = pcxHDR->xmax+1;


	//set all the pointers


	s = (unsigned short*)tp->collumnofs;
	t = (sizeof(short)*6)+(2*tp->width );//=2*sizeof char)
//	memset(s,0,(64*64)-t);

	//first the tabels ofs pointers
	*s++ = t; 
	for (x = 0; x < 64; x++){
		t += table[x][68] + 2 ;
		*s++ = t; 
	}


	for (x = 0; x < 64; x++){
		ptr = patchmem + tp->collumnofs[x];
		//*ptr++ = 0;
		for (y = 0;y < table[x][68]+2; y++){
			*ptr++ = table[x][y];
		}
	}

	memcpy (test1,RottSpriteMemptr,5000);
*/
	return 1;		





	//}

/*	GlobalFree (patchmem);//release mem

	//create a patch_t to put data into
	patchmem =  (BYTE *)GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,picsize+2256);

	p = (patch_t*)patchmem;
	ptr = tempbuffer;


	p->origsize = 128;
	p->height = pcxHDR->ymax+1;
	p->width  = pcxHDR->xmax+1;
	p->leftoffset  = leftoffset;
	p->topoffset  = topoffset;
	p->collumnofs[0] = (sizeof(short)*5)+(2*p->width );//=2*sizeof char)



	tabelptr = p->collumnofs[0];
	for (x=0;x<p->width;x++){
		p->collumnofs[x] = tabelptr;//=2*sizeof char)
		oldptr = ptr;
		//now count height of collum yofs,ynb
		totalHeightCount=0;oldynb=0;
		ptm = patchmem + p->collumnofs[x];
		for (y=0;y<=p->height;y++){//(not visible)
			cnt=0;
			//count nb not visible (1's)of pixels down to first pixels
			while (((*ptr) == BGBYTE)&&(cnt<p->height)){cnt++;ptr+=p->width;totalHeightCount++;}
			//not 1 reached, count nb of them
			if (totalHeightCount >= p->height){
				*(ptm) = 0xFF;
				break;}
			ynb = 0;
			old = ptm+2;
			oldynb = totalHeightCount;
			while (((*ptr) != BGBYTE)&&(totalHeightCount<p->height)){
				(*old++) = (*ptr);
				ynb++;totalHeightCount++;
				ptr += p->width;
			}
			//write these 2 nbs (points to from tabel, who points to len and start)
			(*ptm++) = oldynb;
			(*ptm++) = ynb;

			//calculate next table pointer
			tabelptr += ynb+2; //char cnt + ynb + 0xFF = 3 bytes
			ptm= old;
			//those 2 nbs found, begin copying data to target
		}	tabelptr += 1; //char cnt + ynb + 0xFF = 3 bytes
		ptr = oldptr + 1;

	}

	ZmemSize = Z_GetSize (RottSpriteMemptr);
	memcpy(RottSpriteMemptr,patchmem,ZmemSize);
	GlobalFree (patchmem);//release mem
	GlobalFree (tempbuffer);//release mem
*/
	return 1;


}


int CntNbOfBGBYTEbytes(BYTE *src, int w, int h)
{
	int cnt = 0;
	//count nb not visible (1's BGBYTEs)of pixels down to first pixels
	while ((*src == BGBYTE)&&(cnt<h)){
		cnt++;
		src += w;
	}
	//not 1 reached, exit now
	return cnt;
}

int CntNbOfNotBGBYTEbytes(BYTE *src, int w, int h)
{
	int cnt = 0;
	//count nb of pixels down to first (1's BGBYTEs) pixels
	while ((*src != BGBYTE)&&(cnt<h)){
		cnt++;
		src += w;
	}
	//1 reached, exit
	return cnt;
}


void PrepareGFX ()
{




	GFX_animstart = W_GetNumForName("ANIMSTRT") + 1;
	GFX_animstop  = W_GetNumForName("EXITSTRT") - 1;

	GFX_wallstart = W_GetNumForName("WALLSTRT") + 1;
	GFX_wallstop  = W_GetNumForName("WALLSTOP") - 1;

	GFX_floorstart = W_GetNumForName("UPDNSTRT")+1;
	GFX_floorstop  = W_GetNumForName("UPDNSTOP")-1;

    GFX_shapestart = W_GetNumForName ("SHAPSTRT")+1;
    GFX_shapestop = W_GetNumForName ("SHAPSTOP")-1;

    GFX_gunsstart = W_GetNumForName ("GUNSTART")+1;
    GFX_gunsstop = W_GetNumForName ("PAL")-1;
    //GFX_gunsstop =  GFX_gunsstart + 96;
	

    GFX_doorstart = W_GetNumForName("DOORSTRT")+1;
    GFX_doorstop =  W_GetNumForName ("DOORSTOP")-1;

    GFX_sidestart = W_GetNumForName ("SIDESTRT")+1;
    GFX_sidestop =  W_GetNumForName ("SIDESTOP")-1;

    GFX_elevatorstart = W_GetNumForName ("ELEVSTRT")+1;
    GFX_elevatorstop =  W_GetNumForName ("ELEVSTOP")-1;

    GFX_maskedstart = W_GetNumForName ("MASKSTRT")+1;
    GFX_maskedstop =  W_GetNumForName ("MASKSTOP")-1;
	GFX_maskedBotLimit = GFX_maskedstart;
	GFX_maskedTopLimit = W_GetNumForName ("MASKED3A");
	GFX_maskedExclude = W_GetNumForName ("RAILING");

    GFX_exitstart = W_GetNumForName ("EXITSTRT")+1;
    GFX_exitstop =  W_GetNumForName ("EXITSTOP")-1;

    GFX_himaskstart = W_GetNumForName ("HMSKSTRT")+1;
    GFX_himaskstop =  GFX_gunsstart-2;

    GFX_abovemaskwallstart = W_GetNumForName ("ABVMSTRT")+1;
    GFX_abovemaskwallstop =  GFX_himaskstart-2;

    GFX_abovewallstart = W_GetNumForName ("ABVWSTRT")+1;
    GFX_abovewallstop =  GFX_abovemaskwallstart-2;

    GFX_titlestart = W_GetNumForName ("ADSTOP")+1;
    GFX_titlestop = W_GetNumForName ("SHARTITL")-1;

	GFX_ap_world = W_GetNumForName ("AP_WRLD");
    GFX_ap_titl = W_GetNumForName ("AP_TITL");
    GFX_trilogo = W_GetNumForName ("trilogo");

}



BYTE* ReadExpandPCX(char*fname, PCX_HEADER *pcxHDR)
{
	FILE	*instream;  
    BYTE *tempbuffer,*ptr;
    unsigned int xcnt=0,cnt=0,i,picsize;//,picsize = 4096;
    unsigned char runlen,c;


    unsigned int scanlinecnt;

	if( (instream  = fopen( fname, "r+b" )) == NULL ) {
		//AddTxtToListbox ("Opening of PCX file failed!");
		return FALSE;
	}	

	//we dont have any much use for the header since we use
	//the orginal rott pal execpt w and h
	cnt = fread( pcxHDR, sizeof( char ), sizeof(PCX_HEADER), instream );
	if (cnt < sizeof(PCX_HEADER))
		return 0;

	//if (pcxHDR->manufacturer != 10){
		//AddTxtToListbox ("Source is not a PCX picture!");
		//SendMessage(hWndList1,LB_ADDSTRING,0,(LPARAM)"Source is not a PCX picture!");
	//	fclose(instream);
	//	return FALSE;
	//}
	fseek(instream,128,SEEK_SET);
	//make us a large buffer for the PCX pixel info
	picsize = (pcxHDR->xmax+1) * (pcxHDR->ymax+1);
	//tempbuffer =  (BYTE *)GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,picsize+1256);
	tempbuffer = HEAP_getheapmem(picsize+1256);
	ptr = tempbuffer;

	scanlinecnt=0;
    for(i = 0; i <= (picsize);) {
		c = getc( instream );
		//account for psp5 rle stop at each line 
		//if (pcxHDR->vres == pcxHDR->hres){
			if (scanlinecnt == pcxHDR->xmax+1){
				if (c == 0){
					c = getc( instream );
				}
				scanlinecnt=0;
			}
		//}
		if( ( c & 0xC0) == 0xC0 ){ 
			runlen = 0x3f & c;    //calc len of alike bytes
			c = getc( instream ); //read byte to fill into expanded area
			//d = getc( instream ); //read byte to fill into expanded area
			while(runlen--){      //fill out mem with that byte
				ptr[i++] = c;
				scanlinecnt++;
			}
		}else{
			ptr[i++] = c;
			scanlinecnt++;
		}
	}

    fclose (instream);

	//picture is now in mem

	return tempbuffer;

}



int GetTranslevelFilename (char * szFileName)
{
	//does there exists a name with # in it?
	WIN32_FIND_DATA FindFileData;
	HANDLE hFind;
	int externtranslevel;
	char path_buffer[_MAX_PATH];
	char drive[_MAX_DRIVE];
	char dir[_MAX_DIR];
	char fname[_MAX_FNAME];
	char ext[_MAX_EXT];
	char *ptr;


	ptr = strchr(szFileName,'#');
	if (ptr != 0){
		externtranslevel = atol(ptr+1);	
		if (externtranslevel < 0)
			externtranslevel = 0;
		if (externtranslevel > 127)
			externtranslevel = 127;
		return externtranslevel;
	}


	_splitpath( szFileName, drive, dir, fname, ext );

	//create new search filename
	sprintf(path_buffer,"%s%s%s#*%s",drive, dir, fname, ext);

	hFind = FindFirstFile(path_buffer, &FindFileData);
	FindClose(hFind);
	if (hFind != INVALID_HANDLE_VALUE) {
		ptr = strchr(FindFileData.cFileName,'#');
		if (ptr != 0){
			externtranslevel = atol(ptr+1);	
			if (externtranslevel < 0)
				externtranslevel = 0;
			if (externtranslevel > 127)
				externtranslevel = 127;
			//create new filename
			sprintf(szFileName,"%s%s%s",drive, dir, FindFileData.cFileName);
			return externtranslevel;
		}
	}
	
	return -1;

}



BOOL ConvertPCXtoTitlePicType(BYTE* mem,int w,int h )
{
	//BYTE *pcxmem = (BYTE *)GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,w*h); 
	BYTE *pcxmem = (BYTE *)HEAP_getheapmem(w*h); 

	int x,y,ix = 0;

	for (x = 0;x < w; x++){
		for (y = 0;y < h; y++){
			*(pcxmem+ix++) = *(mem + (y*w)+x);   
		}
	}
	memcpy (mem,pcxmem,w*h);
	//GlobalFree(pcxmem);
	HEAP_freemem(pcxmem);
	return 0;
}


void WriteBmpEx(char* filename ,byte *src,int picw ,int pich ,int scale, int paltype, BOOL rotate )
{
	byte *mem;
	int x,wp,hp,h;
	unsigned char *palt;
	HBITMAP hBmp,hnew;	
	BITMAP  bm;
	unsigned char *tgt;
	int widthalign,c;
	HDC hdc;
    BITMAPINFO *BitInfo;
	BYTE *pBmInfo;
	int j=0;
	char buf[256];
	BYTE *pData;

	//first check if we have a png picture
	lstrcpy(buf,filename);
	h = lstrlen(buf);
	if (h>4) {
		*(buf+h-3) = 'P';		*(buf+h-2) = 'N';		*(buf+h-1) = 'G';
		if (access (buf, 0) == 0) //does sfxfile exists, if so dont overwrite
			return;
	} 

	//if pal tables are not loaded, do so
	if (ex_pal == 0)
		ex_pal = (char *) W_CacheLumpName ("pal", PU_CACHE, CvtNull, 1);
	if (ex_ap_pal == 0)
		ex_ap_pal = (char *) W_CacheLumpName ("ap_pal", PU_CACHE, CvtNull, 1);

	if (paltype <= 1)
		palt = ex_pal;
	else
		palt = ex_ap_pal;


	if (rotate == TRUE){
		RotatePicture ( src, picw,pich);
		x = picw;
		picw = pich;
		pich = x;
	}

	//

//WriteExtPCX (filename,src,picw, pich);
	if (scale == 1){
		SaveBMP ( (void*) src,picw, pich,picw*pich,filename,palt);
		return;
	}else{
		WriteBmp (filename, src,picw, pich, palt, 255);
	}
//return;
	hdc = GetDC(NULL);

	
	hBmp = (HBITMAP)LoadImage(NULL,filename,IMAGE_BITMAP,0,0,LR_CREATEDIBSECTION|LR_LOADFROMFILE );

	DeleteFile (filename);

	hnew = CopyImage(
				hBmp,  // handle to the image
				IMAGE_BITMAP,     // type of image to copy
				picw*scale,  // desired width of new image
				pich*scale,  // desired height of new image
				LR_CREATEDIBSECTION    // copy options
				);

	GetObject(hnew, sizeof(BITMAP), (LPSTR) &bm);


    //pBmInfo = (BYTE *) GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT, sizeof(BITMAPINFO)+2024);
    pBmInfo = (BYTE *) HEAP_getheapmem( sizeof(BITMAPINFO)+2024);
	
	
	
	BitInfo = (BITMAPINFO*)pBmInfo;
    //ZeroMemory(&BitInfo, sizeof(BITMAPINFO));
    BitInfo->bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
    BitInfo->bmiHeader.biBitCount = 0;

	if(!GetDIBits(hdc, hnew, 0, 0, NULL, BitInfo, DIB_RGB_COLORS)){
		//GlobalFree(pBmInfo);
		HEAP_freemem(pBmInfo);
		DeleteObject(hnew);
		DeleteObject(hBmp);
        return;
	}

    //pData = (BYTE *) GlobalAlloc(GMEM_FIXED, BitInfo->bmiHeader.biSizeImage + 5);
    pData = (BYTE *) HEAP_getheapmem( BitInfo->bmiHeader.biSizeImage + 5);
	
	
	memset(pData,1,BitInfo->bmiHeader.biSizeImage + 5);
    if(!GetDIBits(hdc, hnew, 0, bm.bmHeight, 
						pData, BitInfo, DIB_RGB_COLORS)){
		//GlobalFree(pData);
		//GlobalFree(pBmInfo);
		HEAP_freemem(pData);
		HEAP_freemem(pBmInfo);
		DeleteObject(hnew);
		DeleteObject(hBmp);
        return;
	}
	//mem = (BYTE*)GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,BitInfo->bmiHeader.biSizeImage + 5+100000);
	mem = (BYTE*)HEAP_getheapmem(BitInfo->bmiHeader.biSizeImage + 5+100000);
	


	src = pData;
	tgt = mem;


    // remove all the DWORD-aligned bytes
	// and flip picture
	wp = BitInfo->bmiHeader.biWidth;
	hp = BitInfo->bmiHeader.biHeight;
    // remove all the DWORD-aligned bytes
	widthalign = 0;
	c = (wp / 4);
	if ((wp - (c * 4))>0) 
		widthalign = (4-(wp - (c * 4))) ;
	// flip picture
/*	for (h = hp-1; h >= 0; h-- ){
		memcpy(tgt ,(src+(h*wp)+(h*widthalign)),wp);
		tgt += wp;
	}*/
	//BlurBuf(src, wp,hp);

	SaveBMP ((void*)src,wp+widthalign,hp,wp*hp,filename,palt);
	//WriteBmp (filename, mem,BitInfo->bmiHeader.biWidth, BitInfo->bmiHeader.biHeight, palt, 255);

	ReleaseDC(NULL,hdc);
	//GlobalFree(mem);
	//GlobalFree(pData);
	//GlobalFree(pBmInfo);
	HEAP_freemem(mem);
	HEAP_freemem(pData);
	HEAP_freemem(pBmInfo);
	DeleteObject(hnew);
	DeleteObject(hBmp);
	
	return;
 }


BOOL SaveBMP ( void* Buffer, int width, int height,long Buffersize, char* bmpfile, unsigned char*palt )
{

	BITMAPFILEHEADER bmfh;
	BITMAPINFOHEADER info;
	unsigned long    bwritten;
	HANDLE file;
	UINT i,*t,cnt = 0;
	unsigned char *b,c;
	unsigned int a,w,h;

	memset ( &bmfh, 0, sizeof ( BITMAPFILEHEADER ) );
	memset ( &info, 0, sizeof ( BITMAPINFOHEADER ) );

	//First we fill the file header with data: 
	bmfh.bfType 	 = 0x4d42; // 0x4d42 = 'BM'
	bmfh.bfReserved1 = 0;
	bmfh.bfReserved2 = 0;
	bmfh.bfSize 	 = sizeof(BITMAPFILEHEADER) + 
		sizeof(BITMAPINFOHEADER) + Buffersize;
	bmfh.bfOffBits   = 0x36;  // (54) size of headers

	//and fill the info header 
	info.biSize 	     = sizeof ( BITMAPINFOHEADER );
	info.biWidth	     = width;
	info.biHeight 	     = height;
	info.biPlanes        = 1;
	info.biBitCount      = 32;		
	info.biCompression   = BI_RGB;	
	info.biSizeImage     = 0;		
	info.biXPelsPerMeter = 0x0ec4;    
	info.biYPelsPerMeter = 0x0ec4;     
	info.biClrUsed       = 0;		 
	info.biClrImportant  = 0;   

	//Some explanations: we want to save as a 24 bit RGB image, so we have to set biCompression to BI_RGB, biBitCount to 24 and biPlanes to 1.
	//In 24 bit images we can set the biSizeImage value to 0 since it is ignored.
	//The PelsPerMeter values are of no real importance, but windows Paint and PSP both use 0x0ec4 so it can't be wrong.
	//Since we have no palette we set the biClrUsed to 0, and biClrImportant being zero means that all colors are important.

	//Now we can open a file to save to ( again i'm using windows functions but it doesnt matter what file I/O functions you use of course) 
	file = CreateFile ( bmpfile , GENERIC_WRITE, FILE_SHARE_READ,
		 NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL );
	if ( file == NULL )
	{
		CloseHandle ( file );
		return false;  
	}

	//Now we write the file header: 
	if ( WriteFile ( file, &bmfh, sizeof ( BITMAPFILEHEADER ), 
		&bwritten, NULL ) == false )
	{	
		CloseHandle ( file );
		return false;
	}

	//and the info header 
	if ( WriteFile ( file, &info, sizeof ( BITMAPINFOHEADER ), 
		&bwritten, NULL ) == false )
	{	
		CloseHandle ( file );
		return false;
	}


	//convert 8 bit colrs to 32 bit
	//t = GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,(width * height)*4);
	t = (UINT*)HEAP_getheapmem((width * height)*4);

	 
	b = Buffer;
	for (i=0;i<(UINT)(width * height);i++){
		c = *(b+i);
	//	a  = _rotl( *(palt+(c*3)+0), 16 );//red
	//	a1 = _rotl( *(palt+(c*3)+1), 8 );//green
	//	a2 = *(palt+(c*3)+2);//blue
	//	a += a1 + a2;
		a = RGB(*(palt+(c*3)+2),*(palt+(c*3)+1),*(palt+(c*3)+0));
		if (a == 0x00FCFCFC)//make allmost white transparant
			a = 0x00FF00FF;  
		if ((c == 1)&&(a == 0x007C3C44))//make intros transparant
			a = 0x00FF00FF;  
		*(t+i) = a;
	}


	if (ShouldExtractedPicBeSoftned(gfxlump) == TRUE){
		for (h = 1; h < (UINT)(height-1); h++ ){
			for (w = 1; w < (UINT)(width-1); w++ ){
				unsigned int p1; 
				if ((*(t+(h*width)+w-1) != 0x00FF00FF)&&(*(t+(h*width)+w) != 0x00FF00FF)&&(*(t+(h*width)+w+1) != 0x00FF00FF)){
					if ((*(t+((h-1)*width)+w-1) != 0x00FF00FF)&&(*(t+((h-1)*width)+w) != 0x00FF00FF)&&(*(t+((h-1)*width)+w+1) != 0x00FF00FF)){
						if ((*(t+((h+1)*width)+w-1) != 0x00FF00FF)&&(*(t+((h+1)*width)+w) != 0x00FF00FF)&&(*(t+((h+1)*width)+w+1) != 0x00FF00FF)){
							p1 = CalcAverageCol32((t+(h*width)+w),  width);
							*(t+(h*width)+w) = p1;
						}
					}
				}
			}
		}
	}

	//and finally the image data 
	if ( WriteFile ( file, t, (width * height)*4,&bwritten, NULL ) == false )
	{	
		CloseHandle ( file );
		//GlobalFree(t);
		HEAP_freemem(t);
		return false;
	}

	//and finish the function 
	CloseHandle ( file );
	//GlobalFree(t);
	HEAP_freemem(t);
	return true;
}






#include "rt_msg.h"
/* rt_msg.h contains msg defs
#define MSG_PERMANENT     0x80
#define MSG_NODELETE      0x40
#define MSG_PRIORITY( x ) ( ( x ) & 0x3f )

#define PERMANENT_MSG( x ) ( ( x ) & MSG_PERMANENT )
#define DELETABLE_MSG( x ) ( ( x ) & MSG_NODELETE )

#define MSG_MODEM          ( 1 | MSG_PERMANENT )
#define MSG_SYSTEM         ( 2 )
#define MSG_REMOTERIDICULE ( 3 )
#define MSG_REMOTE         ( 4 | MSG_NODELETE )
#define MSG_GAME           ( 5 | MSG_NODELETE )
#define MSG_DOOR           ( 6 )
#define MSG_CHEAT          ( 7 )
#define MSG_NAMEMENU       ( 8 | MSG_PERMANENT | MSG_NODELETE )
#define MSG_QUIT           ( 9 )
#define MSG_MACRO          ( 10 )
#define MSG_BONUS1         ( 11 )
#define MSG_BONUS          ( 12 )
#define MSG_MSGSYSTEM      ( 13 )
*/
#include "MYPRINT.H"
/* MYPRINT.H contains color defs
enum COLORS {
    BLACK, BLUE, GREEN, CYAN, RED, MAGENTA, BROWN, LIGHTGRAY, DARKGRAY,
    LIGHTBLUE, LIGHTGREEN, LIGHTCYAN, LIGHTRED, LIGHTMAGENTA, YELLOW, WHITE
};
*/

extern unsigned char *screenbuffer;
extern int fontcolor;
extern cfont_t *IFont;

void AddTopLevelMessage(int x, int y, char *msg)
{
	UINT tmpbufferofs = bufferofs;
	bufferofs = (UINT)screenbuffer ;
	IFont = (cfont_t *) W_CacheLumpName ("itnyfont", PU_CACHE, Cvt_cfont_t, 1);
	fontcolor = egacolor[GREEN];
	DrawIString (x, y,msg, MSG_PERMANENT);
	GLRefresh ();
	bufferofs = tmpbufferofs;
}   




unsigned int CalcAverageCol32(unsigned int *pic, int width)
{
	//left side 3 pix
	t1 = (unsigned char*)(pic - width -1);
	t2 = (unsigned char*)(pic - 1);
	t3 = (unsigned char*)(pic + width -1);
	//middle pix 3 pix
	m1 = (unsigned char*)(pic - width);
	m2 = (unsigned char*)(pic);
	m3 = (unsigned char*)(pic + width);
	//right side 3 pix
	b1 = (unsigned char*)(pic - width + 1);
	b2 = (unsigned char*)(pic + 1);
	b3 = (unsigned char*)(pic + width + 1);	

	sumr = (*t1++ + *t2++ + *t3++ + *m1++ + *m2++ + *m3++ + *b1++ +  *b2++ + *b3++)/9;
	sumg = (*t1++ + *t2++ + *t3++ + *m1++ + *m2++ + *m3++ + *b1++ +  *b2++ + *b3++)/9;
	sumb = (*t1++ + *t2++ + *t3++ + *m1++ + *m2++ + *m3++ + *b1++ +  *b2++ + *b3++)/9;
	suma = (*t1 + *t2 + *t3 + *m1 + *m2 + *m3 + *b1 +  *b2 + *b3)/9;
	s = (unsigned char*)&sum;

	*s++ = sumr;
	*s++ = sumg;
	*s++ = sumb;
	*s++ = suma;
	return (unsigned int)sum;
}

BOOL Has9x9pixTranspixel( unsigned int *pic, int width)
{
	//left side 3 pix
	pxs = (pic - width -1);
	if (*pxs == 0x00FF00FF)
		return 1;

	pxs = (pic - 1);
	if (*pxs == 0x00FF00FF)
		return 1;

	pxs = (pic + width -1);
	if (*pxs == 0x00FF00FF)
		return 1;

	//middle pix 3 pix
	pxs = (pic - width);
	if (*pxs == 0x00FF00FF)
		return 1;

	pxs = (pic);
	if (*pxs == 0x00FF00FF)
		return 1;

	pxs = (pic + width);
	if (*pxs == 0x00FF00FF)
		return 1;

	//right side 3 pix
	pxs = (pic - width + 1);
	if (*pxs == 0x00FF00FF)
		return 1;

	pxs = (pic + 1);
	if (*pxs == 0x00FF00FF)
		return 1;

	pxs = (pic + width + 1);	
	if (*pxs == 0x00FF00FF)
		return 1;

	return 0;
}




BOOL ShouldExtractedPicBeSoftned(int glump)
{
		
	if ((glump>=GFX_wallstart)&&(glump<=GFX_wallstop)){
		if (bWalls == 0)return 0;
		return 1;
	}else if ((glump>=GFX_animstart)&&(glump<=GFX_animstop)){
		if (bWalls == 0)
			return 0;
		return 1;
	}else if ((glump>=GFX_floorstart)&&(glump<=GFX_floorstop)){
		if (bFloor_Ceilings == 0)
			return 0;
		return 1;
	}else if ((glump>=GFX_shapestart)&&(glump<=GFX_shapestop)){
		if (bShapes == 0)
			return 0;
		return 1;
	}else if ((glump>=GFX_gunsstart)&&(glump<=GFX_gunsstop)){
		if (bGuns == 0)
			return 0;
		return 1;
	}else if ((glump>=GFX_doorstart)&&(glump<=GFX_doorstop)){
		if (bDoors == 0)
			return 0;
		return 1;
	}else if ((glump>=GFX_sidestart)&&(glump<=GFX_sidestop)){
		if (bSides == 0)
			return 0;
		return 1;
	}else if ((glump>=GFX_elevatorstart)&&(glump<=GFX_elevatorstop)){
		if (bElevators == 0)
			return 0;
		return 1;
	}else if ((glump>=GFX_maskedstart)&&(glump<=GFX_maskedstop)){
		if (bMasked == 0)
			return 0;
	}else if ((glump>=GFX_exitstart)&&(glump<=GFX_exitstop)){
		if (bExits == 0)
			return 0;
		return 1;
	}else if ((glump>=GFX_himaskstart)&&(glump<=GFX_himaskstop)){
		if (bHswicthes == 0)
			return 0;
		return 1;
	}else if ((glump>=GFX_abovemaskwallstart)&&(glump<=GFX_abovemaskwallstop)){
		if (bAbovemaskwall == 0)
			return 0;
		return 1;
	}else if ((glump>=GFX_abovewallstart)&&(glump<=GFX_abovewallstop)){
		if (bAbovewall == 0)
			return 0;
		return 1;
	}

	return bMish;
}






#define GAMMAENTRIES (64*8)
//#include "..\\PCXstuff\tile.h"
void loadconvpal();
extern int gammaindex;
extern byte gammatable[GAMMAENTRIES];
unsigned char makecol(byte r, byte g, byte b);
void Convert24bitBmpTo8bit(byte*src, byte*tgt,int w, int h, int bytesperline, int flip);
rgb_t colrs[256];
int ispalloaded = 0;


void Convert24bitBmpTo8bit(byte *src, byte *tgt, int w, int h, int bytesperline, int flip)
{
	byte c,r,g,b;
	byte *srcdata, *tgtdata,*tempbuffer, *oldtgt = tgt;
	int i,iw,h1;
	int linecount = bytesperline / w;//24 or 32 bit
	//tempbuffer = (unsigned char*)GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,w*h);
	tempbuffer = (unsigned char*)HEAP_getheapmem(w*h);

	
	srcdata = (unsigned char*)tgt;
	tgtdata = tempbuffer;

	if (ispalloaded == 0)
		loadconvpal();

	for (i=0; i< h; i++){
		for (iw=0; iw< w; iw++){
			r = (*src++);
			g = (*src++);
			b = (*src++);
			src++;//bypass the 4 byte in a uint.
			c = makecol( r, g, b);//find a appr. rott 8 bit color
			*tgt++ = c;
		}
	}

	if (flip == 1){
		// flip picture
		for (h1 = h-1; h1 > 0; h1-- ){
			memcpy(tgtdata ,(srcdata+(h1*w)),w);
			tgtdata += w;
		}
		memcpy(oldtgt,tempbuffer,w*h);
	}
	//GlobalFree(tempbuffer);
	HEAP_freemem(tempbuffer);

}



unsigned char makecol(byte r, byte g, byte b)
{
	int i,range;
	int r1=r,b1=b,g1=g;
	//this func finds the closest apprx in rott pal table
	for (range = 0; range < 256; range++){
		for (i=0;i<256;i++){
			if (((int)colrs[i].red >= (r1-range))&&((int)colrs[i].red <= (r1+range))){
				if (((int)colrs[i].green >= g1-range)&&((int)colrs[i].green <= g1+range)){
					if (((int)colrs[i].blue >= b1-range)&&((int)colrs[i].blue <= b1+range)){
						return (unsigned char )i;
					}
				}
			}

/*			if (((colrs[i].red >= r1-range)&&(colrs[i].red <= r1+range))&&
				((colrs[i].green >= g1-range)&&(colrs[i].green <= g1+range))&&
				((colrs[i].blue >= b1-range)&&(colrs[i].blue <= b1+range)))
				return (unsigned char )i;*/
		}
	} 

	return 0;
}



void loadconvpal()
{
	int i,j=0;
	for (i = 0; i < 256; ++i, j += 3){  
 		colrs[i].red = (unsigned char)origpal[j];//colrs[i].red;
		colrs[i].green = (unsigned char)origpal[j+1];//colrs[i].green;
		colrs[i].blue = (unsigned char)origpal[j+2];//colrs[i].blue;
		colrs[i].red = gammatable[(gammaindex<<6)+(colrs[i].red)] << 2;
		colrs[i].green = gammatable[(gammaindex<<6)+(colrs[i].green)] << 2;
		colrs[i].blue = gammatable[(gammaindex<<6)+(colrs[i].blue)] << 2;
	}
    ispalloaded = 1;    
}

void InterpolateBuffer32(UINT*t, int iw, int ih);
UINT * InterpolateStrechBuffer32(UINT *t, int iw, int ih, int neww, int newh);


void InterpolateBuffer32(UINT*t, int iw, int ih)
{
	int w,h;
	int width = iw;
	int height = ih;
	char type = 0;
	UINT p1; 

	for (w = 0; w < (iw*ih);w++){
		if (*(t+w)==0x00FF00FF){
			type = 1;
			break;
		}
	}
 
	if (type == 1){
 		for (h = 1; h < height-1; h++ ){
			for (w = 1; w < width-1; w++ ){
				if (Has9x9pixTranspixel((t+(h*width)+w),width) == 0){
					p1 = CalcAverageCol32(t+(h*width)+w,  width);
					*(t+(h*width)+w) = p1;// + 0xFF000000;
				}

				/*
				if ((*(t+(h*width)+w-1) != 0x00FF00FF)&&(*(t+(h*width)+w) != 0x00FF00FF)&&(*(t+(h*width)+w+1) != 0x00FF00FF)){
					if ((*(t+((h-1)*width)+w-1) != 0x00FF00FF)&&(*(t+((h-1)*width)+w) != 0x00FF00FF)&&(*(t+((h-1)*width)+w+1) != 0x00FF00FF)){
						if ((*(t+((h+1)*width)+w-1) != 0x00FF00FF)&&(*(t+((h+1)*width)+w) != 0x00FF00FF)&&(*(t+((h+1)*width)+w+1) != 0x00FF00FF)){
							p1 = CalcAverageCol32((t+(h*width)+w), w, h, width, height);
							*(t+(h*width)+w) = p1;// + 0xFF000000;
						}
					}
				}*/
			} 
		} 
	}else{
 		for (h = 1; h < height-1; h++ ){
			for (w = 1; w < width-1; w++ ){
				p1 = CalcAverageCol32(t+(h*width)+w, width);
				*(t+(h*width)+w) = p1;// + 0xFF000000;
			}
		}
	}


}



     
UINT * InterpolateStrechBuffer32(UINT *t, int iw, int ih, int neww, int newh)
{
	HBITMAP hBmp,hTmp,hStr;	       
	BITMAP  bm;
	UINT    i,j,x,y,*tw,*p,*t1,*k;//, *tc, w, h, clr;
//	DWORD sz;
//	unsigned char* a,r,g,b,*c,*uc; 
	i = neww/iw;
	j = newh/ih;

	//this routine was made in the hope of speeding things up a bit bna++ 156
	if ((i == 4)&&(j == 4)){
		int neww0 = (neww*0);
		int neww1 = (neww*1);
		int neww2 = (neww*2);
		int neww3 = (neww*3);

		//first create mem for our 32 bit pic
		//tw = (UINT*)GlobalAlloc( GMEM_FIXED|GMEM_ZEROINIT, (neww) * (newh) * 4 );
		tw = (UINT*)HEAP_getheapmem((neww) * (newh) * 4 );
		

		
		p = tw;
		t1 = t;
		for ( y = 0; y <= (UINT)ih; y++){
			for ( x = 0; x < (UINT)iw; x++){	
				/*tq = x*4;tr = *t1;
				memset( (p+tq), tr, 4 );
				memset( (p+(neww*1)+tq), tr, 4 );
				memset( (p+(neww*2)+tq), tr, 4 );
				memset( (UINT*)(p+(neww*3)+tq), (UINT)tr, 4 );
				*/
	
				k = p + (x*4);
				for ( i = 0; i < 4; i++){
					*(k+i) = *t1;
					*(k+neww1+i) = *t1;
					*(k+neww2+i) = *t1;
					*(k+neww3+i) = *t1;
					/*for ( j = 0; j < 4; j++){
						*(p+(neww*j)+i+(x*4)) = *t1;
					}*/
				}
				t1 += 1;
			}
			t1 = t + (iw*y);
			p = tw + (neww*4*y);
		}
		InterpolateBuffer32(tw,neww,newh);
		return (UINT*)tw; 
	}
  
	//we still keep the old reoutines one as backup
	//tw = (UINT*)GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,neww * newh * 4);
	tw = (UINT*)HEAP_getheapmem(neww * newh * 4);


	//load a 32 bit pic r,g,b and alpha IDB_BITMAP_32BIT=214
	hBmp = (HBITMAP)LoadImage (hInst, MAKEINTRESOURCE(214), IMAGE_BITMAP,0,0,LR_CREATEDIBSECTION); 
	//create a bmp picture         
	hTmp = CopyImage( 
				hBmp,  // handle to the image
				IMAGE_BITMAP,      // type of image to copy
				iw,  // desired width of new image
				ih,  // desired height of new image
				LR_CREATEDIBSECTION    // copy options
			 	);   
 	GetObject(hTmp, sizeof(BITMAP), (LPSTR) &bm);
	//copy our data into this dummy handle tw;
	memcpy(bm.bmBits,t,iw*ih*4);
	//create a streched bmp picture         
	hStr = CopyImage(   
				hTmp,  // handle to the image
				IMAGE_BITMAP,// type of image to copy
				neww,  // desired width of new image
				newh,  // desired height of new image
				LR_CREATEDIBSECTION    // copy options
			 	);  
	//copy this new strched pic into some mem
 	GetObject(hStr, sizeof(BITMAP), (LPSTR) &bm);

	memcpy(tw,bm.bmBits,neww*newh*4);

	InterpolateBuffer32(tw,neww,newh);
	return (UINT*)tw; 


}
 

BYTE* Draw32_LoadExtBitmap(char* fname, int cx, int cy)
{
	BITMAP  bm;
	HBITMAP hBmp = (HBITMAP)LoadImage(NULL, fname, IMAGE_BITMAP, cx, cy, LR_CREATEDIBSECTION | LR_LOADFROMFILE);
	GetObject(hBmp, sizeof(BITMAP), (LPSTR)&bm);
	BYTE* b, * bmpmem = (BYTE*)GlobalAlloc(GMEM_FIXED | GMEM_ZEROINIT, bm.bmWidth * bm.bmHeight * 4);
	b = bmpmem;
	/*	for (int i=0;i<bm.bmHeight;i++){
			for (int j=0;j<bm.bmWidth;j+=3){
				*b++ = *((BYTE*)bm.bmBits + ((i * bm.bmWidthBytes)+(j*3)+ 0));
				*b++ = *((BYTE*)bm.bmBits + ((i * bm.bmWidthBytes)+(j*3)+ 1));
				*b++ = *((BYTE*)bm.bmBits + ((i * bm.bmWidthBytes)+(j*3)+ 2));
				*b++ = 0xFF;
			}
		}*/
	memcpy(bmpmem, bm.bmBits, bm.bmWidthBytes * bm.bmHeight);
	DeleteObject(hBmp);
	return bmpmem;
}


/*
UINT * Convert64_8bitPicTo256_32bitPic(UINT *t, int iw, int ih, int neww, int newh)
{
	byte    *tw;

	//first create mem for our 256 32 bit pic
	tw = (byte*)GlobalAlloc( GMEM_FIXED|GMEM_ZEROINIT, neww * newh * 4);
	memcpy(tw,t,iw*ih*4);
	InterpolateBuffer32(tw,neww,newh);
	return (UINT*)tw; 

}


/*
// bna section start-------------------------------------------
void StrechMemPicture ()
{

		//strech mem //	   SetTextMode (  );
   		byte *source,*target,*tmp,*tmp2;
		int x,y,x1,y1;
		int cnt,NbOfLines;
		float Yratio,Xratio,old;
		double divi;

		//strech pixels in X direction
#if (USEDIRECTDRAW == 1)
		source = ( byte * )PICbuf; 
#else
		source = ( byte * )( sdl_surface->pixels);//store screen in tmp pic mem
#endif
		sdl_surfacePTR = source;
		memcpy( tmpPICbuf, source, (200*iGLOBAL_SCREENWIDTH) );

		source = tmpPICbuf;
#if (USEDIRECTDRAW == 1)
		target = ( byte * )(PICbuf);//screen buffer
#else
		target = ( byte * )( sdl_surface->pixels);//screen buffer
#endif

	    Xratio = iGLOBAL_SCREENWIDTH * 10/ 320;
		Xratio = (Xratio/10);
		cnt = (int)Xratio; 
		divi = 2;
		if (iGLOBAL_SCREENWIDTH == 1024){divi=3;}
		Xratio = (Xratio - cnt)/divi; //=2
		old = 0;

		for (y=0;y<200;y++){
			tmp = source;
			tmp2 = target;
			//write pixel x and x-1 in line 1
			for (x=0;x<320;x++){
				for (x1=0;x1<cnt;x1++){
					//copy one pixel ----------------------
					*(target++) = *(source) ;
					old += Xratio;
					//-----------------------------------
					if (old > 1) {
						//copy extra pixel
						*(target++) = *(source) ;				
						old -= 1;
					}
				}
				source++;
			}
			source = tmp + iGLOBAL_SCREENWIDTH;
			target = tmp2 + iGLOBAL_SCREENWIDTH;
		}

		//strech lines in Y direction

#if (USEDIRECTDRAW == 1)
		source = ( byte * )(PICbuf);//store screen in tmp pic mem
#else
		source = ( byte * )( sdl_surface->pixels);//store screen in tmp pic mem
#endif
		memcpy( tmpPICbuf, source, (200*iGLOBAL_SCREENWIDTH) );

		source = tmpPICbuf;
#if (USEDIRECTDRAW == 1)
		target = ( byte * )(PICbuf);//screen buffer
#else
		target = ( byte * )( sdl_surface->pixels);//screen buffer
#endif
		Yratio = iGLOBAL_SCREENHEIGHT * 10/ 200;//we shall strech 200 lines to 480/600
		Yratio = (Yratio/10);
		cnt = (int)Yratio; //2
		divi = 2;
		if (iGLOBAL_SCREENWIDTH == 1024){divi=2.85;}
		Yratio = (Yratio - cnt)/divi; //.2
		NbOfLines=0;//make sure we dont exeed iGLOBAL_SCREENHEIGHT or we get a crash
		old = 0;

		for (y=0;y<200;y++){
			for (y1=0;y1<cnt;y1++){
				//copy one line ----------------------
				memcpy(target, source,iGLOBAL_SCREENWIDTH);
				if (NbOfLines++ >= iGLOBAL_SCREENHEIGHT-1){goto stopx;}
				target += (iGLOBAL_SCREENWIDTH);
				old += Yratio;
				//-----------------------------------
				if (old > 1) {
					//copy extra line
					memcpy(target, source,iGLOBAL_SCREENWIDTH);				
					if (NbOfLines++ >= iGLOBAL_SCREENHEIGHT-1){goto stopx;}
					target += (iGLOBAL_SCREENWIDTH);
					old -= 1;
				}
			}
			source += iGLOBAL_SCREENWIDTH;
		}
stopx:;

}
*/