
/******************************************************************************
 				GenSettingsWnd.cpp 
 Copyright  2009  Birger N. Andreasen 
 Please send any bugreports, comments and other issues to:
 E-Mail = bna@post10.tele.dk
 Homepage with other ROTT stuff = http://www.riseofthetriad.dk/
/******************************************************************************/



#include <windows.h>

#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <fcntl.h>
#include <time.h>
#include "resource.h" 
#include "develop.h"
#include <windowsx.h>
#include <string> 
#include <wtypes.h>
#include <objbase.h>
#include <unknwn.h>


extern "C"{
	#include "rt_def.h"
	#include "sprites.h"
	#include "states.h"
	#include "rt_actor.h"
}


extern "C" {
	extern char g_packsystem;
	unsigned char cUseSavegameErrCorr = 1;
	unsigned char cUseSavegameGLpic = 1;
	unsigned char cUseSavegameOldpic = 0;
	unsigned char cUseSavegameSoften = 0;
	extern void ErrorDontQuit (char *error, int i,...);
	statetype *MinType, *MaxType;
	statetype* GetMinMaxStatetypeForObj(int objtype, statetype *OrgType);
	LRESULT CALLBACK GenSettingsWndProc(HWND hWnd, UINT msg,WPARAM wParam, LPARAM lParam);
	extern int  GetStrFromRegdb (LPSTR Keyval, LPSTR strval, LPSTR defaultval) ;
	extern BOOL SetStrInRegdb  (LPSTR Keyval, LPSTR strval, LPSTR defaultval)  ;
	extern unsigned int iDEMOBUFFSIZE;
	extern int GetIndexForState (statetype * state);
	extern HBRUSH AdjustStaticBackgroundColors (HWND hwnd, HDC hdc);
}	

	extern COLORREF crGREEN_PROGRESS;
	extern HBRUSH   GREEN_PROGRESS;



LRESULT CALLBACK GenSettingsWndProc(HWND hWnd, UINT msg,WPARAM wParam, LPARAM lParam)
{

    switch(msg) {
		case WM_INITDIALOG:
			{
			char tmp[64];
			lstrcpy(tmp,"50");
			GetStrFromRegdb ((LPSTR)"DemoMem",(LPSTR)tmp,(LPSTR)"50");
			iDEMOBUFFSIZE = atol(tmp);
			if (iDEMOBUFFSIZE < 50){
				iDEMOBUFFSIZE = 50;
				sprintf(tmp,"%d",iDEMOBUFFSIZE);
			}

			//--------------------------------------
			crGREEN_PROGRESS = RGB(45,135,29);
			GREEN_PROGRESS   = CreateSolidBrush(crGREEN_PROGRESS);

			SetWindowText(GetDlgItem(hWnd,IDC_EDIT_DEMOMEM),tmp);
			iDEMOBUFFSIZE *= 1000;
			SendDlgItemMessage(hWnd,IDC_CHECK_MEM,BM_SETCHECK,1,0);

			sprintf(tmp,"%d",(UINT)((iDEMOBUFFSIZE/12.1)/60));
			SetWindowText(GetDlgItem(hWnd,IDC_EDIT_DEMOTIME),tmp);

			lstrcpy(tmp,"1");
			GetStrFromRegdb ((LPSTR)"UseSavegameErrCorr",(LPSTR)tmp,(LPSTR)"1");
			cUseSavegameErrCorr = (unsigned char)atol(tmp);
			if (cUseSavegameErrCorr == 1)
				SendDlgItemMessage(hWnd,IDC_CHECK_SAVGAMERRC,BM_SETCHECK,1,0);

			lstrcpy(tmp,"1");
			GetStrFromRegdb ((LPSTR)"DemoPackSys",(LPSTR)tmp,(LPSTR)"1");
			g_packsystem = (unsigned char)atol(tmp);
			if (g_packsystem == 1)
				SendDlgItemMessage(hWnd,IDC_RADIO1,BM_SETCHECK,1,0);
			if (g_packsystem == 2)
				SendDlgItemMessage(hWnd,IDC_RADIO2,BM_SETCHECK,1,0);

			lstrcpy(tmp,"1");
			GetStrFromRegdb ((LPSTR)"UseSavegameGLpic",(LPSTR)tmp,(LPSTR)"1");
			cUseSavegameGLpic = (unsigned char)atol(tmp);
			if (cUseSavegameGLpic == 1)
				SendDlgItemMessage(hWnd,IDC_CHECK_SAVGAMUSEGLPIC,BM_SETCHECK,1,0);

			lstrcpy(tmp,"0");
			GetStrFromRegdb ((LPSTR)"UseSavegameOldpic",(LPSTR)tmp,(LPSTR)"0");
			cUseSavegameOldpic = (unsigned char)atol(tmp);
			if (cUseSavegameOldpic == 1)
				SendDlgItemMessage(hWnd,IDC_CHECK_USEOLDPIC,BM_SETCHECK,1,0);

			lstrcpy(tmp,"0");
			GetStrFromRegdb ((LPSTR)"UseSavegameSoften",(LPSTR)tmp,(LPSTR)"0");
			cUseSavegameSoften = (unsigned char)atol(tmp);
			if (cUseSavegameSoften == 1)
				SendDlgItemMessage(hWnd,IDC_CHECK_SAVGAMSOFTEN,BM_SETCHECK,1,0);

			HFONT font = (HFONT)GetStockObject(ANSI_FIXED_FONT);
			SendMessage((HWND)GetDlgItem(hWnd,IDCANCEL),WM_SETFONT, (UINT)font, 0L);
			SendMessage((HWND)GetDlgItem(hWnd,IDOK),WM_SETFONT, (UINT)font, 0L);
			SendMessage((HWND)GetDlgItem(hWnd,1003),WM_SETFONT, (UINT)font, 0L);

			//--------------------------------------
			crGREEN_PROGRESS = RGB(45,135,29);
			GREEN_PROGRESS   = CreateSolidBrush(crGREEN_PROGRESS);
			break;
			}
/*
		case WM_CTLCOLORSTATIC:
			for (int ix = IDC_STATIC_GEN1;ix <= IDC_STATIC_GEN2; ix++){
				if ((HWND)lParam == GetDlgItem(hWnd,ix)) 
					SetTextColor((HDC)wParam,crGREEN_PROGRESS);
			}
			return (LRESULT)(HBRUSH)AdjustStaticBackgroundColors ((HWND)lParam,(HDC)wParam);
		*/
		case WM_COMMAND:
			switch (LOWORD(wParam)) 
			{ 
				case IDAPPLY:
					{
					char tmp[264];						
					GetWindowText(GetDlgItem(hWnd,IDC_EDIT_DEMOMEM),tmp,255);
					iDEMOBUFFSIZE = atol(tmp);
					if (iDEMOBUFFSIZE < 50){
						iDEMOBUFFSIZE = 50;
						sprintf(tmp,"%d",iDEMOBUFFSIZE);
						SetWindowText(GetDlgItem(hWnd,IDC_EDIT_DEMOMEM),tmp);
					}
					SetStrInRegdb ((LPSTR)"DemoMem",(LPSTR)tmp,(LPSTR)"50");
					iDEMOBUFFSIZE *= 1000;	
					sprintf(tmp,"%d",(UINT)((iDEMOBUFFSIZE/12.1)/60));
					SetWindowText(GetDlgItem(hWnd,IDC_EDIT_DEMOTIME),tmp);


					if(IsDlgButtonChecked(hWnd,IDC_CHECK_SAVGAMERRC) == BST_CHECKED){
						SetStrInRegdb ("UseSavegameErrCorr","1","0");
						cUseSavegameErrCorr = 1;
					}else{
						SetStrInRegdb ("UseSavegameErrCorr","0","0");
						cUseSavegameErrCorr = 0;
					}
					if(IsDlgButtonChecked(hWnd,IDC_CHECK_SAVGAMSOFTEN) == BST_CHECKED){
						SetStrInRegdb ("UseSavegameSoften","1","0");
						cUseSavegameSoften = 1;
					}else{
						SetStrInRegdb ("UseSavegameSoften","0","0");
						cUseSavegameSoften = 0;
					}

					if(IsDlgButtonChecked(hWnd,IDC_CHECK_SAVGAMUSEGLPIC) == BST_CHECKED){
						SetStrInRegdb ("UseSavegameGLpic","1","0");
						cUseSavegameGLpic = 1;
						cUseSavegameOldpic = 0;
					}else{
						SetStrInRegdb ("UseSavegameGLpic","0","0");
						cUseSavegameGLpic = 0;
						cUseSavegameOldpic = 1;
					}

					if(IsDlgButtonChecked(hWnd,IDC_CHECK_USEOLDPIC) == BST_CHECKED){
						SetStrInRegdb ("UseSavegameOldpic","1","0");
						cUseSavegameOldpic = 1;
						cUseSavegameGLpic = 0;
					}else{
						SetStrInRegdb ("UseSavegameOldpic","0","0");
						cUseSavegameOldpic = 0;
						cUseSavegameGLpic = 1;
					}

					if(IsDlgButtonChecked(hWnd,IDC_RADIO1) == BST_CHECKED){
						SetStrInRegdb ("DemoPackSys","1","1");
						g_packsystem = 1;
					}
					if(IsDlgButtonChecked(hWnd,IDC_RADIO2) == BST_CHECKED){
						SetStrInRegdb ("DemoPackSys","2","1");
						g_packsystem = 2;
					}

					}
					break;
				case IDCANCEL:
					EndDialog(hWnd, TRUE);          // Exit the dialog
					break;
				case IDC_CHECK_SAVGAMERRC://
					{
					if(IsDlgButtonChecked(hWnd,IDC_CHECK_SAVGAMERRC) == BST_CHECKED){
						SetStrInRegdb ("UseSavegameErrCorr","1","0");
						cUseSavegameErrCorr = 1;
					}else{
						SetStrInRegdb ("UseSavegameErrCorr","0","0");
						cUseSavegameErrCorr = 0;
					}

					}
					break;
				case IDC_CHECK_SAVGAMSOFTEN://
					{
					if(IsDlgButtonChecked(hWnd,IDC_CHECK_SAVGAMSOFTEN) == BST_CHECKED){
						SetStrInRegdb ("UseSavegameSoften","1","0");
						cUseSavegameSoften = 1;
					}else{
						SetStrInRegdb ("UseSavegameSoften","0","0");
						cUseSavegameSoften = 0;
					}
					}
					break;


				case IDC_CHECK_USEOLDPIC://
					{
					if(IsDlgButtonChecked(hWnd,IDC_CHECK_USEOLDPIC) == BST_CHECKED){
						SetStrInRegdb ("UseSavegameOldpic","1","0");
						cUseSavegameOldpic = 1;
						cUseSavegameGLpic = 0;
					}else{
						SetStrInRegdb ("UseSavegameOldpic","0","0");
						cUseSavegameOldpic = 0;
						cUseSavegameGLpic = 1;
					}
					}
					break;

				case IDC_CHECK_SAVGAMUSEGLPIC://
					{
					if(IsDlgButtonChecked(hWnd,IDC_CHECK_SAVGAMUSEGLPIC) == BST_CHECKED){
						SetStrInRegdb ("UseSavegameGLpic","1","0");
						cUseSavegameGLpic = 1;
						cUseSavegameOldpic = 0;
					}else{
						SetStrInRegdb ("UseSavegameGLpic","0","0");
						cUseSavegameGLpic = 0;
						cUseSavegameOldpic = 1;
							
					}
					}
					break;


				case IDOK:
					{
						char tmp[264];
						GetWindowText(GetDlgItem(hWnd,IDC_EDIT_DEMOMEM),tmp,255);
						iDEMOBUFFSIZE = atol(tmp);
						if (iDEMOBUFFSIZE < 50){
							iDEMOBUFFSIZE = 50;
							sprintf(tmp,"%d",iDEMOBUFFSIZE);
						}
						SetStrInRegdb ((LPSTR)"DemoMem",(LPSTR)tmp,(LPSTR)"50");
						iDEMOBUFFSIZE *= 1000;

						if(IsDlgButtonChecked(hWnd,IDC_CHECK_SAVGAMERRC) == BST_CHECKED){
							SetStrInRegdb ("UseSavegameErrCorr","1","0");
							cUseSavegameErrCorr = 1;
						}else{
							SetStrInRegdb ("UseSavegameErrCorr","0","0");
							cUseSavegameErrCorr = 0;
						}
						if(IsDlgButtonChecked(hWnd,IDC_CHECK_SAVGAMSOFTEN) == BST_CHECKED){
							SetStrInRegdb ("UseSavegameSoften","1","0");
							cUseSavegameSoften = 1;
						}else{
							SetStrInRegdb ("UseSavegameSoften","0","0");
							cUseSavegameSoften = 0;
						}

						if(IsDlgButtonChecked(hWnd,IDC_CHECK_SAVGAMUSEGLPIC) == BST_CHECKED){
							SetStrInRegdb ("UseSavegameGLpic","1","0");
							cUseSavegameGLpic = 1;
							cUseSavegameOldpic = 0;
						}else{
							SetStrInRegdb ("UseSavegameGLpic","0","0");
							cUseSavegameGLpic = 0;
							cUseSavegameOldpic = 1;
						}

						if(IsDlgButtonChecked(hWnd,IDC_CHECK_USEOLDPIC) == BST_CHECKED){
							SetStrInRegdb ("UseSavegameOldpic","1","0");
							cUseSavegameOldpic = 1;
							cUseSavegameGLpic = 0;
						}else{
							SetStrInRegdb ("UseSavegameOldpic","0","0");
							cUseSavegameOldpic = 0;
							cUseSavegameGLpic = 1;
						}
						if(IsDlgButtonChecked(hWnd,IDC_RADIO1) == BST_CHECKED){
							SetStrInRegdb ("DemoPackSys","1","1");
							g_packsystem = 1;
						}
						if(IsDlgButtonChecked(hWnd,IDC_RADIO2) == BST_CHECKED){
							SetStrInRegdb ("DemoPackSys","2","1");
							g_packsystem = 2;
						}
						EndDialog(hWnd, TRUE);          // Exit the dialog
						break;
					}
					break;
			}
			break;
    }
    return FALSE;
}



//fixing savegame versions error hereunder

statetype* GetMinMaxStatetypeForObj(int objtype, statetype *OrgType)
{		
	int DefIndex, MinIndex, MaxIndex;
//ErrorDontQuit("",objtype);	
	switch (objtype) {

		case inertobj:

			break;
		case playerobj:
			MinType = &s_player;
			MaxType = &s_player;
			return &s_player;//returning default
		case lowguardobj:
			MinType = &s_lowgrdstand;
			MaxType = &s_sneakyrise1;
			return &s_lowgrdstand;
		case highguardobj:
			MinType = &s_highgrdstand;
			MaxType = &s_highgrdcrushed1;
			return &s_highgrdstand;
#if (SHAREWARE == 0)
		case overpatrolobj:
			MinType = &s_opstand;
			MaxType = &s_opcrushed1;
			return &s_opstand;
#endif
		case strikeguardobj:
			MinType = &s_strikestand;
			MaxType = &s_strikecrushed1;
			return &s_strikestand;
		case blitzguardobj:
			MinType = &s_blitzstand;
			MaxType = &s_blitzstruggledead;
			return &s_blitzstand;
		case triadenforcerobj:
			MinType = &s_enforcerstand;
			MaxType = &s_enforcercrushed1;
			return &s_enforcerstand;
#if (SHAREWARE == 0)
		case deathmonkobj:
			MinType = &s_dmonkstand;
			MaxType = &s_dmonkcrushed1;
			return &s_dmonkstand;

		case dfiremonkobj:
			MinType = &s_firemonkstand;
			MaxType = &s_firemonkcrushed1;
			return &s_dmonkstand;
#endif
		case roboguardobj:
			MinType = &s_robogrdstand;
			MaxType = &s_robowait;
			return &s_robogrdstand;
#if (SHAREWARE == 0)
		case b_darianobj:
			MinType = &s_darianstand;
			MaxType = &s_dariandie1;
			return &s_darianstand;

		case b_heinrichobj:
			MinType = &s_heinrichstand;
			MaxType = &s_heinexp1;
			return &s_heinrichstand;
		case b_robobossobj:
			MinType = &s_NMEhead1;
			MaxType = &s_NMEspinfire;
			return &s_NMEhead1;

		case b_darkmonkobj:
			MinType = &s_darkmonkstand;
			MaxType = &s_dmgreenthing1;
			return &s_darkmonkstand;
		case b_darksnakeobj:

			break;

		case patrolgunobj:
			MinType = &s_gunfire2;
			MaxType = &s_4waygun;
			return &s_gunstand;

		case wallopobj:
			MinType = &s_wallstand;
			MaxType = &s_wallwait;
			return &s_wallpath;
#endif
		//specials
		case pillarobj:
			MinType = &s_pushcolumn1;
			MaxType = &s_pushcolumn3;
			return &s_pushcolumn1;
#if (SHAREWARE == 0)
		case firejetobj:
			MinIndex = GetIndexForState (&s_firejetdown23);
			MaxIndex = GetIndexForState (&s_firejetdown1);
			DefIndex = GetIndexForState (OrgType);
			if ((DefIndex >= MinIndex)&&(DefIndex <= MaxIndex)){
				//it is a downjet?
				MinType = &s_firejetdown23;
				MaxType = &s_firejetdown1;
				return &s_firejetdown3;
			}
			//no match, check for upjet
			MinIndex = GetIndexForState (&s_firejetup23);
			MaxIndex = GetIndexForState (&s_firejetup1);
			DefIndex = GetIndexForState (OrgType);
			if ((DefIndex >= MinIndex)&&(DefIndex <= MaxIndex)){
				//it is a upjet?
				MinType = &s_firejetup23;
				MaxType = &s_firejetup1;
				return &s_firejetup3;
			}
			break;

		case bladeobj:	//ok		
			MinIndex = GetIndexForState (&s_upblade16);
			MaxIndex = GetIndexForState (&s_upblade1);
			DefIndex = GetIndexForState (OrgType);
			if ((DefIndex >= MinIndex)&&(DefIndex <= MaxIndex)){
				//it is a downcolumn?
				MinType = &s_upblade16;
				MaxType = &s_upblade1;
				return &s_upblade1;
			}
			//no match, check for downblade
			MinIndex = GetIndexForState (&s_downblade16);
			MaxIndex = GetIndexForState (&s_downblade1);
			DefIndex = GetIndexForState (OrgType);
			if ((DefIndex >= MinIndex)&&(DefIndex <= MaxIndex)){
				//it is a s_downblade16?
				MinType = &s_downblade16;
				MaxType = &s_downblade1;
				return &s_downblade1;
			}
			//no match, check for spinup
			MinIndex = GetIndexForState (&s_spinupblade16);
			MaxIndex = GetIndexForState (&s_spinupblade1);
			DefIndex = GetIndexForState (OrgType);
			if ((DefIndex >= MinIndex)&&(DefIndex <= MaxIndex)){
				//it is a spinup?
				MinType = &s_spinupblade16;
				MaxType = &s_spinupblade1;
				return &s_spinupblade1;
			}
			break;

		case crushcolobj://ok
			MinIndex = GetIndexForState (&s_columndownup6);
			MaxIndex = GetIndexForState (&s_columndowndown1);
			DefIndex = GetIndexForState (OrgType);
			if ((DefIndex >= MinIndex)&&(DefIndex <= MaxIndex)){
				//it is a downcolumn?
				MinType = &s_columndownup6;
				MaxType = &s_columndowndown1;
				return &s_columndowndown1;
			}
			//no match, check for upcolumn
			MinIndex = GetIndexForState (&s_columnupdown6);
			MaxIndex = GetIndexForState (&s_columnupup1);
			DefIndex = GetIndexForState (OrgType);
			if ((DefIndex >= MinIndex)&&(DefIndex <= MaxIndex)){
				//it is a upjet?
				MinType = &s_columnupdown6;
				MaxType = &s_columnupup1;
				return &s_columnupup1;
			}
			break;


		case boulderobj://ok
			MinType = &s_bouldersink9;
			MaxType = &s_boulderspawn;
			return &s_boulderdrop1;

		case spearobj:
			MinIndex = GetIndexForState (&s_speardown16);
			MaxIndex = GetIndexForState (&s_speardown1);
			DefIndex = GetIndexForState (OrgType);
			if ((DefIndex >= MinIndex)&&(DefIndex <= MaxIndex)){
				//it is a downspear?
				MinType = &s_speardown16;
				MaxType = &s_speardown1;
				return &s_speardown14;
			}
			//no match, check for upjet
			MinIndex = GetIndexForState (&s_spearup16);
			MaxIndex = GetIndexForState (&s_spearup1);
			DefIndex = GetIndexForState (OrgType);
			if ((DefIndex >= MinIndex)&&(DefIndex <= MaxIndex)){
				//it is a upspear?
				MinType = &s_spearup16;
				MaxType = &s_spearup1;
				return &s_spearup14;
			}
			break;
#endif
		case gasgrateobj:
			MinType = &s_gas1;
			MaxType = &s_gas2;
			return &s_gas1;
#if (SHAREWARE == 0) 
		case springobj://ok
			MinType = &s_spring9;
			MaxType = &s_spring1;
			return &s_spring1;
			// Missile weapon types

		case shurikenobj:
			MinType = &s_shurikenhit3;
			MaxType = &s_shurikenhit1;
			return &s_shurikenhit1;
#endif
		case wallfireobj://ok
			MinType = &s_wallfireball;
			MaxType = &s_wallfireball;
			return &s_wallfireball;
		case netobj:

			break;
#if (SHAREWARE == 0)
		case h_mineobj:
			MinType = &s_mine4;
			MaxType = &s_mine1;
			return &s_mine1;

		case grenadeobj:

			break;
		case fireballobj:
			MinType = &s_NMEminiball4;
			MaxType = &s_NMEminiball1;
			return &s_NMEminiball1;
		case dmfballobj:
			MinType = &s_monkfire4;
			MaxType = &s_monkfire1;
			return &s_monkfire1;
		case bigshurikenobj:
			MinType = &s_oshuriken4;
			MaxType = &s_oshuriken1;
			return &s_oshuriken1;

		case missileobj:
			MinType = &s_missile1;
			MaxType = &s_missile1;
			return &s_missile1;

		case NMEsaucerobj:
			MinType = &s_NMEsaucer4;
			MaxType = &s_NMEsaucer1;
			return &s_NMEsaucer1;

		case dm_weaponobj:
			MinType = &s_darkmonkbball9;
			MaxType = &s_darkmonkbball1;
			return &s_darkmonkbball1;

		case dm_heatseekobj:
			MinType = &s_handball2;
			MaxType = &s_handball1;
			return &s_handball1;

		case dm_spitobj:
			MinType = &s_spit4;
			MaxType = &s_spit1;
			return &s_spit1;
#endif
		case p_bazookaobj:
			MinType = &s_explosion20;
			MaxType = &s_explosion1;
			return &s_explosion1;
		case p_firebombobj://ok
			MinType = &s_p_bazooka1;
			MaxType = &s_p_bazooka1;
			return &s_p_bazooka1;
		case p_heatseekobj://ok
			MinType = &s_p_bazooka1;
			MaxType = &s_p_bazooka1;
			return &s_p_bazooka1;
		case p_drunkmissileobj:
			MinType = &s_p_bazooka1;
			MaxType = &s_p_bazooka1;
			return &s_p_bazooka1;
		case p_firewallobj://ok
			MinType = &s_p_grenade;
			MaxType = &s_p_grenade;
			return &s_p_grenade;
		case p_splitmissileobj:
			MinType = &s_p_bazooka1;
			MaxType = &s_p_bazooka1;
			return &s_p_bazooka1;
#if (SHAREWARE == 0)
		case p_kesobj:
			MinType = &s_kessphere8;
			MaxType = &s_kessphere1;
			return &s_kessphere6;

		case p_godballobj://ok
			MinType = &s_godfire4;
			MaxType = &s_godfire1;
			return &s_godfire3;

		case collectorobj:
			MinType = &s_collectorwander8;
			MaxType = &s_collectorwander1;
			return &s_collectorwander1;
#endif
		case diskobj:
			if (OrgType == &s_elevdisk){
				MinType = &s_elevdisk;
				MaxType = &s_elevdisk;
				return &s_elevdisk;
			}
			if (OrgType == &s_pathdisk){
				MinType = &s_pathdisk;
				MaxType = &s_pathdisk;
				return &s_pathdisk;
			}
			if (OrgType == &s_diskmaster){
				MinType = &s_diskmaster;
				MaxType = &s_diskmaster;
				return &s_diskmaster;
			}
			return &s_elevdisk;
		case rainobj:

			break;

	}

#if (SHAREWARE == 0)
	return &s_serialdogattack;//=none
#else
	return 0;//=none
#endif
}

