 
/******************************************************************************
 GrafEffects.c 

 Copyright  2006, Birger N. Andreasen 
 Please send any bugreports, comments and other issues to:
 E-Mail = bna@post10.tele.dk
 Homepage with other ROTT stuff = http://www.riseofthetriad.dk/

 ************************* *****************************************************/

#include <windows.h>
#include "WinRott.h"
#include <stdio.h>
#include <stdlib.h>
#include "resource.h"  
#include "develop.h"
#include <windowsx.h>
#include "DPwinrott.h"
#include "..\DirectDraw\DirectDraw.h"
#include "..\DirectInput\DMInput.h"
#include <direct.h>
#include <ddraw.h>
#include "develop.h"
typedef struct
{
   short          origsize;         // the orig size of "grabbed" gfx
   short          width;            // bounding box size
   short          height;
   short          leftoffset;       // pixels to the left of origin
   short          topoffset;        // pixels above the origin
   unsigned short collumnofs[MAX_WIDTH_RES];  // only [width] used, the [0] is &collumnofs[width]
} patch_t;

extern byte* HEAP_getheapmem(int size);
extern BOOL  HEAP_freemem(LPVOID lpMem);


#define false FALSE

//#define sw  128
//#define sh  128
int sw = 128;
int sh = 128;

int BlurPicBuf( byte * source, int iWidth, int iHeight,int glump);;
int GetPixelClass(int pixel);
void test(char *pic, int w, int h);
void DeSquare(char *pic, int w, int h);
BOOL IsSquare(char *pic, int xp, int yp);
unsigned char CalcAverageCol(char *pic, int xp, int yp);
void BlurBuf(char *pic, int w, int h);
int    getpixel(char*picdata, int w, int h);
void   putpixel(char*picdata, int w, int h, int col);
unsigned char  makecol(int r, int g, int b);
unsigned char CalcAverageCol(char *pic, int xp, int yp);
BOOL ConvertPCXIntoRottSprite (BYTE  *RottSpriteMemptr, char*szFileName, int lump, int lumplength);
 


extern boolean bBlurGraphics;
PALETTEENTRY rPal[768]; 

extern boolean  bAbovemaskwall ;
extern boolean  bAbovewall ;
extern boolean  bDoors ;
extern boolean  bElevators  ;
extern boolean  bExits  ;
extern boolean  bFloor_Ceilings  ;
extern boolean  bGuns  ;
extern boolean  bHswicthes  ;
extern boolean  bMasked  ;
extern boolean  bMish  ;
extern boolean  bShapes  ;
extern boolean  bSides  ;
extern boolean  bWalls  ;

extern int GFX_animstart ,    GFX_animstop ;
extern int GFX_wallstart ,    GFX_wallstop ;
extern int GFX_floorstart ,   GFX_floorstop ;
extern int GFX_shapestart ,   GFX_shapestop ;
extern int GFX_gunsstart ,    GFX_gunsstop ;
extern int GFX_doorstart ,    GFX_doorstop ;
extern int GFX_sidestart ,    GFX_sidestop ;
extern int GFX_elevatorstart ,GFX_elevatorstop ;
extern int GFX_exitstart ,    GFX_exitstop ;
extern int GFX_maskedstart ,  GFX_maskedstop ;
extern int GFX_abovewallstart ,GFX_abovewallstop ;
extern int GFX_abovemaskwallstart ,GFX_abovemaskwallstop ;
extern int GFX_himaskstart ,  GFX_himaskstop ;
extern int GFX_titlestart ,   GFX_titlestop ;
extern int GFX_ap_world ,     GFX_ap_titl ;
extern int GFX_trilogo ;

int BlurPicBuf( byte * source, int iWidth, int iHeight, int glump)
{

	//blur the picture
	int weight = 0;

	//if (bBlurGraphics == FALSE)
	//	return 0;
		
	if ((glump>GFX_wallstart)&&(glump<GFX_wallstop)){
		if (bWalls == 0)
			return 0;
	}else if ((glump>GFX_animstart)&&(glump<GFX_animstop)){
		if (bWalls == 0)
			return 0;
	}else if ((glump>GFX_floorstart)&&(glump<GFX_floorstop)){
		if (bFloor_Ceilings == 0)
			return 0;
	}else if ((glump>GFX_shapestart)&&(glump<GFX_shapestop)){
		if (bShapes == 0)
			return 0;
	}else if ((glump>GFX_gunsstart)&&(glump<GFX_gunsstop)){
		if (bGuns == 0)
			return 0;
	}else if ((glump>GFX_doorstart)&&(glump<GFX_doorstop)){
		if (bDoors == 0)
			return 0;
	}else if ((glump>GFX_sidestart)&&(glump<GFX_sidestop)){
		if (bSides == 0)
			return 0;
	}else if ((glump>GFX_elevatorstart)&&(glump<GFX_elevatorstop)){
		if (bElevators == 0)
			return 0;
	}else if ((glump>GFX_maskedstart)&&(glump<GFX_maskedstop)){
		if (bMasked == 0)
			return 0;
	}else if ((glump>GFX_exitstart)&&(glump<GFX_exitstop)){
		if (bExits == 0)
			return 0;
	}else if ((glump>GFX_himaskstart)&&(glump<=GFX_himaskstop)){
		if (bHswicthes == 0)
			return 0;
	}else if ((glump>GFX_abovemaskwallstart)&&(glump<GFX_abovemaskwallstop)){
		if (bAbovemaskwall == 0)
			return 0;
	}else if ((glump>GFX_abovewallstart)&&(glump<GFX_abovewallstop)){
		if (bAbovewall == 0)
			return 0;
	}




	sw = iWidth;
	sh = iHeight;
	//DeSquare(source, iWidth,iHeight);
	BlurBuf(source, iWidth,iHeight);



	return 0;
}


int getpixel(char*picdata, int w, int h)
{
	unsigned char c;
	c = *(picdata + (h*sw)+w);
	return (c);
}

void putpixel(char*picdata, int w, int h, int col)
{
	*(picdata + ((h*sw)+w)) = (unsigned char )col;
}
/*
unsigned char makecol(int r, int g, int b)
{
	int i,range;
	//this func finds the closest apprx in rott pal table
	for (range = 0; range < 256; range++){
		for (i=0;i<256;i++){
			if (((rPal[i].peRed >= r-range)&&(rPal[i].peRed <= r+range))&&
				((rPal[i].peGreen >= g-range)&&(rPal[i].peGreen <= g+range))&&
				((rPal[i].peBlue >= b-range)&&(rPal[i].peBlue <= b+range)))
				return (unsigned char )i;
		}
	}

	return -1;
}
*/

#define BGBYTE 1
void BlurBuf(char *pic, int w, int h)
{
	int x,y;
	unsigned char col;
	//char *org, *picny, *mem = GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,(w*h)+1024);
	//org = GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,(w*h)+1024);

	char *org, *picny, *mem = (char*)HEAP_getheapmem((w*h)+1024);
	org = HEAP_getheapmem((w*h)+1024);


	memcpy (mem,pic,w*h);
	memcpy (org,pic,w*h);

	picny = mem;

	for(x = 1; x < w-1 ; x++){
		for(y = 1; y < h-1 ; y++){
			col = getpixel(pic,x,y);
			if (col == BGBYTE)
				putpixel(pic,x,y,0);
		}
	}

	for(x = 1; x < w - 1; x++){
		for(y = 1; y < h - 1; y++){
			col = CalcAverageCol(pic,x,y);
			if (col >= 0)
				putpixel(picny,x,y,col);
		}
	}

	//make sure we dont spoil the transparent pictures
	for(x = 0; x < w ; x++){
		for(y = 0; y < h ; y++){
			col = getpixel(org,x,y);
			if (col == BGBYTE)
				putpixel(picny,x,y,BGBYTE);
		}
	}
	memcpy (pic,picny,(w*h));
	//GlobalFree(picny);
	//GlobalFree(org);
	HEAP_freemem(picny);
	HEAP_freemem(org);
		
}


unsigned char CalcAverageCol(char *pic, int xp, int yp)
{
	unsigned char color;
	char i,j;
	int	sumr = 0;
	int	sumg = 0;
	int	sumb = 0;
	//here we make our averagecolor out of a 3x3 matrix
	for (i=-1;i<=1;i++){
		for (j=-1;j<=1;j++){
			color = getpixel(pic,xp+i,yp+j);
			sumr += rPal[color].peRed;
			sumg += rPal[color].peGreen;
			sumb += rPal[color].peBlue;
		}
	}
	sumr /= 9;
	sumg /= 9;
	sumb /= 9;

	return (unsigned char)makecol(sumr,sumg,sumb);

}




void DeSquare(char *pic, int w, int h)
{
	int x,y;
	char c;

	// x x x x
	// x x x x
	// x x x x
	// x x x x

	// x x x x
	// x a a x
	// x a a x
	// x x x x

	for(x = 1; x < w - 1; x++){
		for(y = 1; y < h - 4; y++){
			if (IsSquare(pic,x,y)==TRUE){
				c = getpixel(pic,x+1,y+1);
				c++;
				putpixel(pic,x+1,y+1,c);
				putpixel(pic,x+2,y+1,c);
				putpixel(pic,x+1,y+2,c);
				putpixel(pic,x+2,y+2,c);

			}
		}
	}


}


BOOL IsSquare(char *pic, int xp, int yp)
{
	//a rott square is a matrix on 4 x 4
	int i,j;
	char c, color;

	color = getpixel(pic,xp,yp);

	for (i = 0; i < 4; i++){
		for (j = 0; j < 4; j++){
			c = getpixel(pic,xp+i,yp+j);
			if (c != color)
				return FALSE;
		}
	}
	return TRUE;
}	




/*                 TEST JUNK


/* Blur an image
   @param radius  The radius, in pixels, to compute the blur over
   @param use_base_image if true use the base image.  
   If false use the modified image
   @return   true if ok, false if there is a problem, 
   such as the requested image not being available */
/*
boolean blur(int radius,boolean use_base_image) 
{
	int i;
	int npixels;

	//handle problems such as the modified 
	//image not being available
	if(!use_base_image && !mod_pixels_loaded_flag) 
	{
		return false;
	} else {
		//the convolution is a square with sides 
		//radius + center pixel + radius long
		npixels = (2*radius + 1)*(2*radius + 1);
		//construct the weights applied to each 
		//neighboring pixel in the blur 
		//convolution
		pixel_weights = new double[npixels];
		for(i=0;i<npixels;i++) {
			pixel_weights[i] = 1;
		}
		//apply the blur convolution to the data
		apply_convolution (radius,use_base_image);
		return true;
	}
}



	/** This is a generic convolution routine. 
	It takes the pixels around each pixel, 
	multiplies them by a weight held in the 
	pixel_weight array, adds the result up, 
	and divides the total by the number of pixels being processed. This is done 
	separately for the red, green, and 
	blue channels.
	@param radius  The radius, in 
	pixels of the area to be processed
	@param use_base_image  If true 
	use the base image, 
	if false use the modified image */
/*
void apply_convolution(int radius,boolean use_base_image)
{
	//loop variables x,y go over the image. 
	//i,j go over the convolution matrix
	int x,y,i,j;
	//index of a pixel in the convolution 
	//array.
	int ir,jr;
	//these hold the running sums generated 
	//by the convolution weights times the 
	//pixel values
	double sum_r, sum_g, sum_b;
	//integer versions of the sums
	int isum_r, isum_g,isum_b;  
	//sum of the weights in the convolution 
	//matrix    
	double scale;
	//holds the value of the pixel being 
	//examined
	int temp_pixel;
	//values for the various color channels 
	//for a pixel
	int alpha, red, green, blue;
	//This sets the alpha channel so that our 
	//reconstructed pixels are visible
	alpha = 255 << 24;
	//if the pixels aren't loaded then load 
	//them.  Should check to see if the image 
	//isn't loaded as well.  Note that we 
	//don't have to check if the modified 
	//pixels are loaded because when the  
	//modified picture is made its pixels 
	//are loaded as we'll see below.
	if(!pixels_loaded_flag) {
		get_pixels();
	}
	//because the radius is around a central 
	//point, a radius of 3 pixels defines a 
	//box which is 3(left side) + 1(middle 
	//pixel) + 3(right side) = 7 wide by 3 + 
	//3 + 1 = 7 high 
	scale = 1.0/(4*(radius + 0.5)*(radius + 0.5));
	//fill the working copy with the original 
	//image so that pixels that aren't 
	//processed because they're on the edge 
	//of the image have their original 
	//values.
	if(use_base_image) 
	{
		System.arraycopy(pixels,0,working_pixels,0,(x_max*y_max));
	} else {
		System.arraycopy(modified_pixels,0,working_pixels,0,(x_max*y_max));
	}
}


int getr32(int col)
{
	unsigned char c;
	c = DD_Get_R_Palette(col);
	return(c);
}
int getg32(int col)
{
	unsigned char c;
	c = DD_Get_G_Palette(col);
	return(c);
}
int getb32(int col)
{
	unsigned char c;
	c = DD_Get_B_Palette(col);
	return(c);
}

unsigned char cxz = 0;
unsigned char makecol(int r, int g, int b)
{
	int i,range;
	char c;
	//this func finds the closest apprx in rott pal table
	for (range = 0; range < 256; range++){
		for (i=0;i<256;i++){
			if (((rPal[i].peRed >= r-range)&&(rPal[i].peRed <= r+range))&&
				((rPal[i].peGreen >= g-range)&&(rPal[i].peGreen <= g+range))&&
				((rPal[i].peBlue >= b-range)&&(rPal[i].peBlue <= b+range)))
				return (unsigned char )i;
		}
	}

	return -1;

}


#define gauss_width 7

void test(char *pic, int w, int h)
{

	int b,color,g,i,k,r,j,sumb,sumg,sumr,temp,temp1,temp2;
	int gauss_fact[gauss_width]={1,6,15,20,15,6,1};
	//int gauss_fact[gauss_width]=  {1,1,1,1,1,1,1};
	int gauss_sum=64;
	char c;
	 
	sumr=0;
	sumg=0;
	sumb=0;
	 
	for(i=1;i<w-1;i++){
		for(j=1;j<h-1;j++){
			sumr=0;
			sumg=0;
			sumb=0;
			for(k=0;k<gauss_width;k++){
				color=getpixel(pic,i-((gauss_width-1)>>1)+k,j);
				r=getr32(color);
				g=getg32(color);
				b=getb32(color);
				sumr+=r*gauss_fact[k];
				sumg+=g*gauss_fact[k];
				sumb+=b*gauss_fact[k];
			}
			c = makecol(sumr/gauss_sum,sumg/gauss_sum,sumb/gauss_sum);
			if (c > 0)
				putpixel(pic,i,j,c);

		} 
	}
	 
	for(i=1;i<w-1;i++){
		for(j=1;j<h-1;j++){
			sumr=0;
			sumg=0;
			sumb=0;
			for(k=0;k<gauss_width;k++){
				color=getpixel(pic,i,j-((gauss_width-1)>>1)+k);
				r=getr32(color);
				g=getg32(color);
				b=getb32(color);

				sumr += r*gauss_fact[k];
				sumg += g*gauss_fact[k];
				sumb += b*gauss_fact[k];
			}
			sumr/=gauss_sum;
			sumg/=gauss_sum;
			sumb/=gauss_sum;
			c = makecol(sumr,sumg,sumb);
			if (c > 0)
				putpixel(pic,i,j,c);
		} 
	} 

}





int b,color,g,i,k,r,j,sumb,sumg,sumr,temp,temp1,temp2;

int gauss_fact[gauss_width]={1,6,15,20,15,6,1};
int gauss_sum=64;


 
sumr=0;
sumg=0;
sumb=0;
    

 
for(i=1;i<temp->w-1;i++){
  for(j=1;j<temp->h-1;j++){
    sumr=0;
    sumg=0;
    sumb=0;
    for(k=0;k<gauss_width;k++){
      color=getpixel(temp,i-((gauss_width-1)>>1)+k,j);
      r=getr32(color);
      g=getg32(color);
      b=getb32(color);
      sumr+=r*gauss_fact[k];
      sumg+=g*gauss_fact[k];
      sumb+=b*gauss_fact[k];

    }
    putpixel(temp1,i,j,makecol(sumr/gauss_sum,sumg/gauss_sum,
      sumb/gauss_sum));
  } 
}
 
for(i=1;i<temp->w-1;i++){
  for(j=1;j<temp->h-1;j++){
    sumr=0;
    sumg=0;
    sumb=0;
    for(k=0;k<gauss_width;k++){
      color=getpixel(temp1,i,j-((gauss_width-1)>>1)+k);
      r=getr32(color);
      g=getg32(color);
      b=getb32(color);

      sumr+=r*gauss_fact[k];
      sumg+=g*gauss_fact[k];
      sumb+=b*gauss_fact[k];
    }
    sumr/=gauss_sum;
    sumg/=gauss_sum;
    sumb/=gauss_sum;

    putpixel(temp2,i,j,makecol(sumr,sumg,sumb));
  } 
} 

}
*/


