
/******************************************************************************
 				InfoWnd.cpp 
 Copyright  2009  Birger N. Andreasen 
 Please send any bugreports, comments and other issues to:
 E-Mail = bna@post10.tele.dk
 Homepage with other ROTT stuff = http://www.riseofthetriad.dk/
/******************************************************************************/

 
#pragma warning (disable : 4996)//disable The POSIX name for this item is deprecated

#include <windows.h> 
#include <windowsx.h>  
#include <commctrl.h> 
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <malloc.h> 
#include "resource.h"


COLORREF crLIGHTBLUE1;
HBRUSH   LIGHTBLUE1;
COLORREF crWHITE;
HBRUSH   WHITE;
COLORREF crDARKBLUE;
HBRUSH   DARKBLUE;

extern "C" {
	ATOM InfoRegisterClass(HINSTANCE hInstance);
	BOOL InitInfoWndInstance(HINSTANCE hInstance, int nCmdShow);
	LRESULT CALLBACK InfoWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
	BOOL LB_MsgDrawItem (LPARAM lParam, HWND hparent);
	BOOL LB_MsgMeasureItem (HWND hWnd, LPARAM lParam);	
	BOOL AddToInfoWindow(LPSTR InfoTxt, int color) ;

	extern HWND	hMainWnd;
	extern HINSTANCE	hInst;
	extern HWND hWndInfo;

	extern BOOL CenterWindow(HWND hwndChild, HWND hwndParent,UINT Yoffset);
	extern int iShowInfoWnd;
}

HWND hWndInfo;
HWND hWndInfoListBox;
HFONT hfontLBDlg;



/********************************************************************/
/*																	*/
/* Function name : InfoRegisterClass			 		            */
/* Description   :													*/
/*																	*/
/********************************************************************/
ATOM InfoRegisterClass(HINSTANCE hInstance)
{
	WNDCLASSEX wcex;

	wcex.cbSize = sizeof(WNDCLASSEX); 

	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= (WNDPROC)InfoWndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hIcon			= NULL;//LoadIcon(hInstance, (LPCTSTR)IDI_ZZZ);
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wcex.lpszMenuName	= NULL;//(LPCSTR)IDC_ZZZ;
	wcex.lpszClassName	= "clsInfoWindow";
	wcex.hIconSm		= NULL;//LoadIcon(wcex.hInstance, (LPCTSTR)IDI_SMALL);

	// Register the window class and return FALSE if unsuccesful.
    if (!RegisterClassEx(&wcex))
    {
        //Assume we are running on NT where RegisterClassEx() is
        //not implemented, so let's try calling RegisterClass().
        if (!RegisterClass((LPWNDCLASS)&wcex.style))
        	return FALSE;
    }
	return TRUE;
}



/********************************************************************/
/*																	*/
/* Function name : InitInfoWndInstance			 		            */
/* Description   :													*/
/*																	*/
/********************************************************************/
BOOL InitInfoWndInstance(HINSTANCE hInstance, int nCmdShow)
{
	RECT rc;

	if (iShowInfoWnd == FALSE)
		return 0;
	
	if (InfoRegisterClass(hInstance)==FALSE){
		return 0;
	}		
	
	hWndInfo = CreateWindow("clsInfoWindow", "WinrottGL Info window",WS_SIZEBOX| WS_POPUPWINDOW|WS_CAPTION,
      0, 0, 200, 220, hMainWnd, NULL, hInstance, NULL);
	//hWndInfo = 0;
	GetClientRect(hMainWnd, &rc);
	SetWindowPos(hWndInfo,HWND_TOPMOST,0 ,0,420 ,220,SWP_SHOWWINDOW );
	
	crWHITE = RGB(255,255,255);
	WHITE   = CreateSolidBrush(crWHITE);
	//--------------------------------------
	crLIGHTBLUE1 = RGB(193,210,238);
	LIGHTBLUE1   = CreateSolidBrush(crLIGHTBLUE1);
	//--------------------------------------
	crDARKBLUE = RGB(49,106,197);
	DARKBLUE   = CreateSolidBrush(crDARKBLUE);

    hWndInfoListBox = CreateWindowEx(0L,"LISTBOX","", LBS_HASSTRINGS| LBS_NOTIFY|  LBS_OWNERDRAWVARIABLE  |LBS_NOINTEGRALHEIGHT|WS_CHILD | WS_BORDER|WS_VISIBLE| WS_HSCROLL | WS_VSCROLL  ,
                            0, 0, 200, 200,
                            hWndInfo,
                            (HMENU)IDD_INFOWINDOW, 
                            hInstance , 
                            NULL);

	//make a normal font type 
	hfontLBDlg = CreateFont(14, 0, 0, 0, FW_NORMAL, 0, 0, 0, 0, 0, 0, 0,  DEFAULT_PITCH  , "MS Sans Serif");
	SendMessage(hWndInfoListBox,WM_SETFONT, (UINT)hfontLBDlg, 0L);

   GetClientRect(hWndInfo, &rc);
   CenterWindow(hWndInfo,GetDesktopWindow(),0);
   SetWindowPos(hWndInfoListBox,NULL,0, 0, rc.right ,rc.bottom,SWP_SHOWWINDOW);
   if (!hWndInfo)
   {
      return FALSE;
   }
   ShowWindow(hWndInfo, nCmdShow);
   UpdateWindow(hWndInfo);
   return TRUE;
}




/********************************************************************/
/*																	*/
/* Function name : InfoWndProc			 							*/
/* Description   :													*/
/*																	*/
/********************************************************************/
LRESULT CALLBACK InfoWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;
	PAINTSTRUCT ps;
	HDC hdc;
	RECT rc;

	switch (message) 
	{
		case WM_COMMAND:
			wmId    = LOWORD(wParam); 
			wmEvent = HIWORD(wParam); 
			// Parse the menu selections:
			switch (wmId)
			{
				case IDM_EXIT:
				   DestroyWindow(hWnd);
				   break;
				default:
				   return DefWindowProc(hWnd, message, wParam, lParam);
			}
			break;
		case WM_PAINT:
			hdc = BeginPaint(hWnd, &ps);
			// TODO: Add any drawing code here...
			//RECT rt;
			//GetClientRect(hWnd, &rt);
			//DrawText(hdc, szHello, strlen(szHello), &rt, DT_CENTER);
			EndPaint(hWnd, &ps);
			break;
		case WM_CLOSE:
			DestroyWindow(hWnd);;
			return 1;
        case WM_MEASUREITEM: 
			{
				LPMEASUREITEMSTRUCT lpmis;     // pointer for item measurement
				lpmis = (LPMEASUREITEMSTRUCT)lParam;  // for convenience      
				if (lpmis->CtlType == ODT_LISTBOX) {
					if (lpmis->CtlID == IDD_INFOWINDOW) {
						LB_MsgMeasureItem (hWnd,lParam);
					}
				}
			}
			return TRUE;//say we handle the drawing
        case WM_DRAWITEM: 
			{
				LPDRAWITEMSTRUCT lpdis;     // pointer for item drawing
				if (lParam == 0)
					break;
				lpdis = (LPDRAWITEMSTRUCT)lParam;  // for convenience       
				if (lpdis->CtlType == ODT_LISTBOX) {
					if (lpdis->CtlID == IDD_INFOWINDOW) {
						LB_MsgDrawItem (lParam,hWnd);//draw server resp listview
					}
				}
			}
			return TRUE;//say we handle the drawing
		case WM_SIZE:
			GetClientRect(hWnd, &rc);
			SetWindowPos(hWndInfoListBox,NULL,0, 0, rc.right ,rc.bottom,SWP_SHOWWINDOW);
			break;

		default:
			return DefWindowProc(hWnd, message, wParam, lParam);
   }
   return 0;
}


/********************************************************************/
/*																	*/
/* Function name : LB_MsgMeasureItem								*/
/* Description   : Measurering for our  response LB					*/
/*																	*/
/********************************************************************/	
BOOL LB_MsgMeasureItem (HWND hWnd, LPARAM lParam)
{  
    LPMEASUREITEMSTRUCT lpmis;     // pointer for item measurement
    HDC                 hDC;       // dialog's device context
    TEXTMETRIC          tm;        // for system font height  

	lpmis = (LPMEASUREITEMSTRUCT)lParam;  /* for convenience      */  
	/* get and use height of system font for drawing */ 
    hDC = GetDC(hWnd);                 /* get device context     */ 
    GetTextMetrics(hDC, &tm);          /* get text information   */ 
    lpmis->itemHeight = tm.tmHeight-1; /* required to set height */ 
    ReleaseDC(hWnd, hDC);              /* release device context */ 
	return TRUE;
}

/********************************************************************/
/*																	*/
/* Function name : LB_MsgDrawItem									*/
/* Description   : draws text and color in our response LB			*/
/*																	*/
/********************************************************************/
BOOL LB_MsgDrawItem (LPARAM lParam, HWND hparent)
{

    LPDRAWITEMSTRUCT    lpdis;     // pointer for drawing struct
    TCHAR                 szBuf[280]; // buffer for list box string
	UINT i,txtlen;

	/* Get convenient pointer to the DRAWITEMSTRUCT */ 
	lpdis = (LPDRAWITEMSTRUCT)lParam;

    /* Get text of string referred to by itemID */ 
    SendMessage(lpdis->hwndItem, LB_GETTEXT, lpdis->itemID,(LONG)(LPSTR)szBuf);
	//get the text color in end of line
 	txtlen = lstrlen(szBuf)-1;
	if (szBuf[txtlen] == '1')
		SetTextColor(lpdis->hDC,RGB(0,140,0)) ;//make textcolr green 
	else if (szBuf[txtlen] == '2')   
		SetTextColor(lpdis->hDC,RGB(0,0, 255)) ;//make textcolr blue 
	else if (szBuf[txtlen] == '3')   
		SetTextColor(lpdis->hDC,RGB(128,128,128)) ;//make textcolr gray 
	else if (szBuf[txtlen] == '4')   
		SetTextColor(lpdis->hDC,RGB(128,0,0)) ;//make textcolr gray 
	else  
		SetTextColor(lpdis->hDC, RGB(0,0,0));//make textcolr black 

	szBuf[txtlen] = 0;//cut of color value

	//remove char smaller than 10 bna++156
	for (i = 0; i <= txtlen;i++){
		if (szBuf[i] <= 10)
			szBuf[i] = 32;
	}

    if ((lpdis->itemState & ODS_SELECTED) ) {
        //Make the color of text of the selected tab to be BLUE.
		SetBkColor(lpdis->hDC,crLIGHTBLUE1); 
		FillRect(lpdis->hDC, &lpdis->rcItem,  (HBRUSH) (LIGHTBLUE1));

        SetTextColor(lpdis->hDC, RGB(0,0,0));//make textcolr white 
        DrawText(lpdis->hDC,szBuf,lstrlen(szBuf),&lpdis->rcItem ,DT_LEFT|DT_SINGLELINE|DT_VCENTER );
		FrameRect(lpdis->hDC, &lpdis->rcItem,  (HBRUSH) (DARKBLUE));	
		//DrawFocusRect(lpdis->hDC, (LPRECT) &lpdis->rcItem);
		return TRUE;
	}
	//TextOut (lpdis->hDC, lpdis->rcItem.left, lpdis->rcItem.top , szBuf, lstrlen (szBuf)) ;
	SetBkColor(lpdis->hDC,crWHITE); 
	FillRect(lpdis->hDC, &lpdis->rcItem,  (HBRUSH) (WHITE));
	DrawText(lpdis->hDC,szBuf,lstrlen(szBuf),&lpdis->rcItem ,DT_LEFT|DT_SINGLELINE|DT_VCENTER );


	return TRUE;

}



/********************************************************************/
/*																	*/
/* Function name : AddToInfoWindow									*/
/* Description   :													*/
/*																	*/
/********************************************************************/	
BOOL AddToInfoWindow(LPSTR InfoTxt, int color) 
{
	char buf[2048];
	char buf1[2048];
	int nb,txtlen;
	TCHAR *token;
	TCHAR seps[3];
    SYSTEMTIME sysTime;

	txtlen = lstrlen(InfoTxt);
	if (txtlen <= 0) return 0;
	if (txtlen > 2048) txtlen = 2048;
	memset(buf,0,sizeof(buf));
	memcpy (buf,InfoTxt,txtlen);

	nb = SendMessage(hWndInfoListBox,LB_GETCOUNT,(WPARAM)0,(LPARAM) 0);
	if (nb>1000) {
		// if there is more then 1000 lines,delete line 0
		SendMessage(hWndInfoListBox,LB_DELETESTRING,(WPARAM)0,(LPARAM) 0);
	}
	GetLocalTime(&sysTime);
	seps[0] = 13;
	seps[1] = 10;
	seps[2] = 0;
	token = strtok( buf,seps);

	while( token != NULL )
	{   
		wsprintf(buf1,"[%02d-%02d-%02d - %02d:%02d:%02d] %s %d", sysTime.wDay, sysTime.wMonth, sysTime.wYear,sysTime.wHour, sysTime.wMinute, sysTime.wSecond,token ,color);
		SendMessage(hWndInfoListBox,LB_ADDSTRING , 0, (LPARAM)buf1);
		SendMessage(hWndInfoListBox,LB_SETCURSEL,(WPARAM)nb, (LPARAM) 0);
		token = strtok( NULL,seps);
	}

 //   UpdateWindow(hWndInfoListBox);        // Sends WM_PAINT message
   // UpdateWindow(hWndInfo);        // Sends WM_PAINT message

	return 0;
}
