

/******************************************************************************
				OldSkies.c 

 Copyright  2009, Birger N. Andreasen 
 Please send any bugreports, comments and other issues to:
 E-Mail = bna@post10.tele.dk
 Homepage with other ROTT stuff = http://www.riseofthetriad.dk/
 ******************************************************************************/

 

#include <sys/stat.h>
#include "version.h" 
#include <string.h>
#include <stdlib.h>
#include <fcntl.h>
#include "rt_def.h"
#include "rt_stat.h" 
#include "rt_util.h"
#include "rt_cfg.h"
#include "rt_def.h"
#include "watcom.h"
#include "rt_floor.h"
#include "rt_fc_a.h"
#include "_rt_floo.h"
#include "rt_draw.h"
#include "rt_util.h"
#include "engine.h"
#include "rt_main.h"
#include "w_wad.h"
#include "z_zone.h"
#include "rt_view.h"
#include "rt_ted.h"
#include "rt_cfg.h"
#include "rt_actor.h"
#include <string.h>
#include "isr.h"
#include "modexlib.h"
#include "rt_playr.h"
#include "rt_sound.h"
#include "rt_rand.h"
#include "memcheck.h"
#include "rt_scale.h"
#include "engine.h"
#include "_engine.h"
#include "rt_door.h"
#include "..\\PCXstuff\tile.h"
#include "resource.h"

extern HINSTANCE hInst;
static byte *skysegs[MAXSKYSEGS];
static byte *skydata[MAXSKYDATA];
extern rgb_t colrs[256];
extern int ispalloaded;
extern BOOL bIntPolOldSkys;
extern char cExternalSkyPath[256];

extern void loadconvpal();
extern void RotatePicture ( byte *src, int iWidth,int  iHeight);
extern void InterpolateBuffer32(UINT*t, int iw, int ih);
extern byte* HEAP_getheapmem(int size);
extern BOOL  HEAP_freemem(LPVOID lpMem);
              
UINT *CreateOldSky(int w, int h);
       
unsigned char tests[1000];    

  
/*
UINT *SunPic = 0;
UINT *SunPicOrgpicsquare = 0;//here we store the org square we cut out to place sun
HBITMAP hBmpsun;	      
BITMAP  bmsun;
*/


UINT *CreateOldSky(int w, int h)
{
	HBITMAP hBmp,hTmp,hnew;	      
	BITMAP  bm;
	UINT    *two_skys32; 
	unsigned int clr;
	unsigned char *uc,*two_skys,*tgt,*src,*skybuf;
	byte r,g,b,scale;     
	word s;
    int skytop;
    int skybottom;
	int h1,w1,newsizex,newsizey;//,iWidth,iHeight;
	UINT* cnt = 0;  
	if (ispalloaded == 0)
		loadconvpal(); 
   
	//for temp storing old sky's   
	//skybuf = GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,256 * 200);
	skybuf = HEAP_getheapmem(256 * 200);

	//for combine the 2 old skys
	//two_skys = GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,256 * 200 * 4);
	two_skys = HEAP_getheapmem(256 * 200 * 4);


                    
	if (MAPSPOT (1, 0, 0) >= 234) {              
		sky = (MAPSPOT (1, 0, 0) - 233);
		if ((sky < 1) || (sky > 6))
			sky = 1;             
		s = W_GetNumForName ("SKYSTART");  
		//default sky
		skytop = s + 3;       
		skybottom = s + 4;         
		switch (sky) {       
			case 1:                        
				skytop = s + 1;
				skybottom = s + 2; 
				break;            
			case 2:               
				skytop = s + 3;  
				skybottom = s + 4;
				break;     
			case 3:                                             
				skytop = s + 5;
				skybottom = s + 6;
				break;
			case 4:
				skytop = s + 7;
				skybottom = s + 8;
				break;
			case 5:      
				skytop = s + 9;
				skybottom = s + 10;
				break;
			case 6:
				skytop = s + 11;   
				skybottom = s + 12;
				break;        
         
		} 
		if (sky != 0) {
			//combine the 2 old skys to 1 pic
			skydata[0] = W_CacheLumpNum (skytop, PU_STATIC, CvtNull, 1);
			memcpy(skybuf,skydata[0],200*256);
			RotatePicture (skybuf,200, 256);
			// and flip picture
			src = (unsigned char*)skybuf;
			tgt = two_skys; 
			for (h1 = 200-1; h1 >= 0; h1-- ){
				memcpy(tgt ,(src+(h1*256)+(h1*0)),256);
				tgt += 256;
			}
 
			skydata[1] = W_CacheLumpNum (skybottom, PU_STATIC, CvtNull, 1);
			memcpy(skybuf,skydata[1],200*256);
			RotatePicture (skybuf,200, 256);
			// and flip picture
			src = (unsigned char*)skybuf;
			tgt = two_skys + (256 * 200); 
			for (h1 = 200-1; h1 >= 0; h1-- ){
				memcpy(tgt ,(src+(h1*256)+(h1*0)),256);
				tgt += 256;
			}   
		}                
	} 

	//212 = IDB_BITMAP_SKY = DEFAULT SKY (256 x 400 pixel)
	//I couldnt get CreateBitmap to create a proper handle so
	// this little hack should do it

	//Create a small dummy handle 
	hBmp = (HBITMAP)LoadImage (hInst, MAKEINTRESOURCE(194), IMAGE_BITMAP,0,0,LR_CREATEDIBSECTION); 
	// strech the image we need 
	// eg at 320 we make a 1x256=256 and strech that to 320
	// eg at 640 we make a 2x256=512 and strech that to 640
	// eg at 800 we make a 3x256=768 and strech that to 800
	// eg at 1024 we make a 4x256=1024 and strech that to 1024
	// eg at 1152 we make a 4x256=1024 and strech that to 1152
	// eg at 1280 we make a 5x256=1280 and strech that to 1280
	if (sky == 1)//sky = 1 = stars , dont look good streched
		scale = w/256;//256
	else
		scale = w/512;//256
 	if (scale <= 0)
		scale = 1;
	newsizex = 256*scale;
	newsizey = 200*2;

	//strech the picture         
	hTmp = CopyImage(
				hBmp,  // handle to the image
				IMAGE_BITMAP,     // type of image to copy
				newsizex,  // desired width of new image
				newsizey,  // desired height of new image
				LR_CREATEDIBSECTION    // copy options
			 	);   
 	GetObject(hTmp, sizeof(BITMAP), (LPSTR) &bm);
	//copy our data into this dummy handle
	uc = (unsigned char*)bm.bmBits;
	src = (unsigned char*)two_skys;
	for (h1 = 0;h1 < newsizey; h1++){
		for (w1 = 0;w1 < scale; w1++){
			memcpy((byte*)uc ,src,256);
			uc += 256;
		}
		src += 256;
	}


	//memcpy((byte*)bm.bmBits ,two_skys,bm.bmWidth*bm.bmHeight);
	//strech the picture         
	hnew = CopyImage(
				hTmp,  // handle to the image
				IMAGE_BITMAP,     // type of image to copy
				w,  // desired width of new image
				h,  // desired height of new image
				LR_CREATEDIBSECTION    // copy options
			 	);          
               
	GetObject(hnew, sizeof(BITMAP), (LPSTR) &bm);
     
    if ((fog == 0) && (lightning == true))
		shadingtable = colormap + ((basemaxshade - 6 - lightninglevel) << 8);
    else
		shadingtable = colormap + (1 << 12);

	uc = (unsigned char*)bm.bmBits;
	for (w1 = 0;w1 < bm.bmWidth*bm.bmHeight;w1++){
		*uc = shadingtable[*uc];
		uc++;      
	}   

	if (cExternalSkyPath[0] != 0){
		//use external sky
		hBmp = (HBITMAP)LoadImage(NULL,cExternalSkyPath,IMAGE_BITMAP,w,h, LR_CREATEDIBSECTION | LR_LOADFROMFILE );
		if (hBmp == 0)
			goto UseOldSky;
		GetObject(hBmp, sizeof(BITMAP), (LPSTR) &bm);
		//two_skys32 = (UINT*)GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,bm.bmWidth *bm.bmHeight * 4 * 6);//bna++154 (*6)		
		two_skys32 = (UINT*)HEAP_getheapmem(bm.bmWidth *bm.bmHeight * 4 * 6);//bna++154 (*6)		
		
		//copy our pic into our mem
		src = (unsigned char*)bm.bmBits;
		tgt = (unsigned char*)two_skys32;
		for (w1 = 0;w1 < bm.bmWidth*bm.bmHeight;w1++){
			r = *(src++);
			g = *(src++);
			b = *(src++);
			clr = RGB(r,g,b); 
			clr |= 0xFF000000;
			*(two_skys32 + w1) = clr;  
		}  
	}else{                                        
UseOldSky:
		//convert to 32bits    
		//two_skys32 = (UINT*)GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,bm.bmWidth * bm.bmHeight * 4 * 6);//bna++154 (*6)
		two_skys32 = (UINT*)HEAP_getheapmem(bm.bmWidth * bm.bmHeight * 4 * 6);//bna++154 (*6)
		

		
		uc = (unsigned char*)bm.bmBits;
		for (w1 = 0;w1 < bm.bmWidth*bm.bmHeight;w1++){
			r = colrs[*(uc)].blue;
			g = colrs[*(uc)].green;
			b = colrs[*(uc++)].red; 
			clr = RGB(r,g,b); 
			clr |= 0xFF000000;
			*(two_skys32 + w1) = clr;  
		}   
		//should the sky be interpolated
		if (bIntPolOldSkys == 1){
			InterpolateBuffer32(two_skys32,bm.bmWidth,bm.bmHeight);
		}
	}

	//create sun obj and pic
	//UINT *SunPic = 0;
	//UINT *SunPicOrgpicsquare = 0;//here we store the org square we cut out to place sun
//	hBmpsun = (HBITMAP)LoadImage (hInst, MAKEINTRESOURCE(IDB_BITMAP4), IMAGE_BITMAP,0,0,LR_CREATEDIBSECTION); 
//	GetObject(hBmpsun, sizeof(BITMAP), (LPSTR) &bmsun);

 
	// free objects
	DeleteObject(hBmp);
	DeleteObject(hTmp);
	DeleteObject(hnew);
	//GlobalFree(two_skys);
	//GlobalFree(skybuf);
	HEAP_freemem(two_skys);
	HEAP_freemem(skybuf);

	return (UINT*)two_skys32;
}

