

/******************************************************************************
				RandomMap.c 

 Copyright  2008, 2022 by Birger N. Andreasen
 Please send any bugreports, comments and other issues to:
 E-Mail = bna@bbsyd.dk
 Homepage with other ROTT stuff = http://www.riseofthetriad.dk/

 ******************************************************************************/


//----------------------------------------------------------------------
// Windows Includes...
//----------------------------------------------------------------------

#include <windows.h>
#include "WinRott.h"
#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <fcntl.h>
#include <time.h>
//#include <dsound.h> 
//#include "dxerr.h"
//#include "dxerr.c"
#include "resource.h"  // Required for Win32 Resources
#include "develop.h"
#include <windowsx.h>
#include <shlobj.h>
#include <shlwapi.h>
#include "rt_def.h"
#include "rt_sound.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>

#ifdef DOS
#include <io.h>
#include <conio.h>
#include <dos.h>
#else
#include <errno.h>
#if USE_SDL
#include "SDL.h"
#ifdef USE_OPENGL
#include "glfuncs.h"
#endif

#endif

#endif

#include "states.h"
#include "watcom.h"
#include "rt_ted.h"
#include "_rt_ted.h"
#include "w_wad.h"
#include "z_zone.h"
#include "rt_util.h"
#include "lumpy.h"
#include "rt_vid.h"
#include "rt_actor.h"
#include "rt_stat.h"

#include "rt_draw.h"
#include "rt_com.h"
#include "rt_main.h"
#include "rt_door.h"
#include "rt_playr.h"
#include "rt_view.h"
#include "rt_str.h"
#include "isr.h"
#include "rt_floor.h"
#include "rt_game.h"
#include "rt_rand.h"
#include "rt_cfg.h"
#include "develop.h"
#include "modexlib.h"
#include "engine.h"
#include "rt_debug.h"
#include "rt_scale.h"
#include "rt_net.h"




void LoadResMap(int mapnum);
int  GetRndEntryRoom( int x, int y);
int  GetRndExitRoom( int x, int y);
int  GetRndNormalRoom( int x, int y);
void Reset16x16tilecell( int x, int y);
void CreateAdoor(int x,int y, int dir);

extern long LoadResourceToFixedMem (LPSTR Type ,int sndnb, void **bufferptr);
extern void CA_RLEWexpand (word * source, word * dest, long length, unsigned rlewtag);
extern byte* HEAP_getheapmem(int size);
extern BOOL  HEAP_freemem(LPVOID lpMem);

int RTRmapinfo[49][4] = {
    {0,   0, 16, 16},//x,y,cx,cy
    {16,  0, 16, 16},
    {32,  0, 16, 16},
    {48,  0, 16, 16},
    {64,  0, 16, 16},
    {80,  0, 16, 16},
    {96,  0, 16, 16},
    {112, 0, 16, 16},

    {0,  16, 16, 16},//x,y,cx,cy
    {16, 16, 16, 16},
    {32, 16, 16, 16},
    {48, 16, 16, 16},
    {64, 16, 16, 16},
    {80, 16, 16, 16},
    {96, 16, 16, 16},
    {112,16, 16, 16},

    {0,  32, 16, 16},//x,y,cx,cy
    {16, 32, 16, 16},
    {32, 32, 16, 16},
    {48, 32, 16, 16},
    {64, 32, 16, 16},
    {80, 32, 16, 16},
    {96, 32, 16, 16},
    {112,32, 16, 16},

    {0,  48, 16, 16},//x,y,cx,cy
    {16, 48, 16, 16},
    {32, 48, 16, 16},
    {48, 48, 16, 16},
    {64, 48, 16, 16},
    {80, 48, 16, 16},
    {96, 48, 16, 16},
    {112,48, 16, 16},

    {0,  64, 16, 32},//x,y,cx,cy
    {16, 64, 16, 32},
    {32, 64, 16, 32},
    {48, 64, 16, 32},
    {64, 64, 16, 32},
    {80, 64, 16, 32},
    {96, 64, 16, 32},
    {112,64, 16, 32},

    {0,  96, 32, 16},//x,y,cx,cy
    {32, 96, 32, 16},
    {64, 96, 32, 16},
    {96, 96, 32, 16},

    {0, 112, 32, 16},//x,y,cx,cy
    {32,112, 32, 16},
    {64,112, 32, 16},
    {96,112, 32, 16},

    {0, 0, 0 ,0}};


	word *Connections [3];
	word *EntryRooms  [3];
	word *ExitRooms   [3];
	word *Actors      [3];

	word *ROTTrandom1 [3];
	word *ROTTrandom2 [3];
	word *ROTTrandom3 [3];
	word *ROTTrandom4 [3];



extern BOOL bCreateRandMap;
extern HGLOBAL hgtmpmem;


BOOL CreateRandomMap (char *tmpmapname)
{

	int r,ix,iy,xpos,ypos,lastdir;

	//top 4 rows is 16x16
	//next 2 is 16x32
	//low 32x16

	// x x x x x x x x

	// x x x x x x x x

	// x x x x x x x x

	// x x x x x x x x

	// x x x x x x x x
	// x x x x x x x x

	// xx xx xx xx

	// xx xx xx xx

	//memcpy(OrgPlane,mapplanes,sizeof(mapplanes));

	if (Connections[0] == 0){
		LoadResMap(0);//load connections map
		memcpy(Connections,mapplanes,sizeof(Connections));

		LoadResMap(1);//load EntryRooms map
		memcpy(EntryRooms,mapplanes,sizeof(EntryRooms));		

		LoadResMap(2);//load ExitRooms map
		memcpy(ExitRooms,mapplanes,sizeof(ExitRooms));

		LoadResMap(3);//load Actors map
		memcpy(Actors,mapplanes,sizeof(Actors));

		LoadResMap(4);//load ROTTrandom1 map
		memcpy(ROTTrandom1,mapplanes,sizeof(ROTTrandom1));

		LoadResMap(5);//load ROTTrandom2 map
		memcpy(ROTTrandom2,mapplanes,sizeof(ROTTrandom2));		

		LoadResMap(6);//load ROTTrandom3 map
		memcpy(ROTTrandom3,mapplanes,sizeof(ROTTrandom3));

		LoadResMap(7);//load ROTTrandom4 map
		memcpy(ROTTrandom4,mapplanes,sizeof(ROTTrandom4));


	}

	for (iy = 0; iy < 128; iy++){
		for (ix = 0; ix < 128; ix++){
			*(mapplanes[0] + ix + (iy*128)) = 0;
			*(mapplanes[1] + ix + (iy*128)) = 0;
			*(mapplanes[2] + ix + (iy*128)) = 0;
		}
	}	

	*(mapplanes[0] + 0) = 0xB4;
	*(mapplanes[0] + 1) = 0xC6;
	*(mapplanes[0] + 2) = 0xDF;
	*(mapplanes[0] + 3) = 0xFC;

	*(mapplanes[1] + 0) = 0x5C;
	*(mapplanes[1] + 1) = 0x61;
	*(mapplanes[1] + 2) = 0x68;
	*(mapplanes[1] + 3) = 0x8B;

	*(mapplanes[2] + 0) = 0x00;
	*(mapplanes[2] + 1) = 0x00;
	*(mapplanes[2] + 2) = 0x00;
	*(mapplanes[2] + 3) = 0x00;

	xpos = 1;//where to start
	ypos = 1;

	r = GetRndEntryRoom( xpos, ypos);

	do {
		//find dir 
		int dir = GameRandomNumber("SpawnRandomDir",0) % 3;

		if (dir == 0){//go to the right
			if (xpos + RTRmapinfo[r][2] < 112){//have we room enough ?
				xpos += RTRmapinfo[r][2]-1;//15;	
				r = GetRndNormalRoom(xpos,ypos);
				CreateAdoor(xpos,ypos,0);
				lastdir = 0;
			}
		}else if ((dir == 1)){
			if (ypos + RTRmapinfo[r][3] < 126){//have we room enough ?
				ypos += RTRmapinfo[r][3]-1;//15;	
				r = GetRndNormalRoom(xpos,ypos);
				CreateAdoor(xpos,ypos,2);
				lastdir = 1;
			}

/*			ypos += RTRmapinfo[r][3];//15;	
			GetRndNormalRoom(xpos,ypos);
			CreateAdoor(xpos,ypos,2);
			lastdir = 1;
		}else if ((dir == 2)&&(xpos > 32)&&(*(mapplanes[0] + xpos - 1 + (ypos*128)) != 0)){
			if (lastdir == 1){
				xpos -= 15;	
				GetRndNormalRoom(xpos,ypos,dir);
				CreateAdoor(xpos-1,ypos,1);

			}
			lastdir = 2;*/
		}else{

		}
	}while ((ypos < 128-64));
			

	ypos += RTRmapinfo[r][3]-1;
	GetRndExitRoom( xpos, ypos);
	CreateAdoor(xpos,ypos,2);

	return 1;

}




void LoadResMap(int mapnum)
{
    RTLMAP RTLMap;
//    int filehandle;
    long pos;
    long compressed;
    long expanded;
    int plane;
	unsigned int MapSpecials;
    unsigned char *buffer;
    unsigned char *loadbuffer = 0;
	int memptr;
	int mapressize;
	

    mapressize = LoadResourceToFixedMem ("ROT1", IDR_ROT1, &loadbuffer);

	memptr = RTL_HEADER_OFFSET + mapnum * sizeof (RTLMap);
	memcpy(&RTLMap,(loadbuffer+memptr),sizeof (RTLMap));


    SwapIntelLong ((long *)&RTLMap.used);
    SwapIntelLong ((long *)&RTLMap.CRC);
    SwapIntelLong ((long *)&RTLMap.RLEWtag);
    SwapIntelLong ((long *)&RTLMap.MapSpecials);
    SwapIntelLongArray ((long *)&RTLMap.planestart, NUMPLANES);
    SwapIntelLongArray ((long *)&RTLMap.planelength, NUMPLANES);


    mapwidth = 128;
    mapheight = 128;

    // Get special map flags
    MapSpecials = RTLMap.MapSpecials;

    // load the planes in
    expanded = mapwidth * mapheight * 2;

	for (plane = 0; plane <= 2; plane++) {
		pos = RTLMap.planestart[plane];
		compressed = RTLMap.planelength[plane];
		buffer = SafeMalloc (compressed);

		memcpy(buffer,(loadbuffer+pos),compressed);

		mapplanes[plane] = Z_Malloc (expanded, PU_LEVEL, &mapplanes[plane]);

		// unRLEW, skipping expanded length

/*	#if ( SHAREWARE == 1 )
		CA_RLEWexpand ((word *) buffer, (word *) mapplanes[plane],
				expanded >> 1, SHAREWARE_TAG);
	#else*/
		CA_RLEWexpand ((word *) buffer, (word *) mapplanes[plane],
				expanded >> 1, RTLMap.RLEWtag);
//	#endif

		SafeFree (buffer);
    }
    // get map name
    lstrcpy (RTLMap.Name, "ROTT Random map");
    strcpy (LevelName, RTLMap.Name);

	//GlobalFree (hgtmpmem);//release mem;
	HEAP_freemem (hgtmpmem);//release mem;

}




int GetRndEntryRoom( int x, int y)
{
	//x,y is top left point to make entryroom (16x16 tiles)
	int r,ix,iy,p,xx,yy;	
	//get a random entryroom 
	if (x < 95)
		r = GameRandomNumber("SpawnRandomNormroom",0) % 46;
	else
		r = GameRandomNumber("SpawnRandomNormroom",0) % 31;

	//copy entryroom to mapplane
	for (p = 0;p < 3 ; p++){
		yy = y;
		for (iy = RTRmapinfo[r][1];iy < RTRmapinfo[r][1] + RTRmapinfo[r][3]; iy++){
			xx = x;
			for (ix =  RTRmapinfo[r][0]; ix <  RTRmapinfo[r][0] + RTRmapinfo[r][2]; ix++){
				word b = *(EntryRooms[p] + ix + (iy*128));
				if (b != 72)
					*(mapplanes[p] + xx++ + (yy*128)) = b;
				else
					*(mapplanes[p] + xx++ + (yy*128)) = 1;
			}
			yy++;
		}
	}

	return r;
}



int GetRndExitRoom( int x, int y)
{
	//x,y is top left point to make ExitRoom (16x16 tiles)
	int ix,iy,p,xx,yy;	
	//get a random entryroom 
	int r = GameRandomNumber("SpawnRandomEntryroom",0) % 32;
	//copy entryroom to mapplane
	for (p = 0;p < 3 ; p++){
		yy = y;
		for (iy = RTRmapinfo[r][1];iy < RTRmapinfo[r][1] + RTRmapinfo[r][3]; iy++){
			xx = x;
			for (ix =  RTRmapinfo[r][0]; ix <  RTRmapinfo[r][0] + RTRmapinfo[r][2]; ix++){
				word b = *(ExitRooms[p] + ix + (iy*128));
				if (b != 72)
					*(mapplanes[p] + xx++ + (yy*128)) = b;
				else
					*(mapplanes[p] + xx++ + (yy*128)) = 1;
			}
			yy++;
		}
	}

	return r;
}



int GetRndNormalRoom( int x, int y)
{
	//x,y is top left point to make normalroom (16x16 tiles)
	int r,ix,iy,p,xx,yy,rnor;	
	//get a random entryroom 
	if ((x < 92)&&(y < 92))
		r = GameRandomNumber("SpawnRandomNormroom",0) % 46;
	else
		r = GameRandomNumber("SpawnRandomNormroom",0) % 31;

	//get which rnd normal
	rnor = GameRandomNumber("SpawnRandomNormroom",0) % 3;
	//copy entryroom to mapplane
	for (p = 0;p < 3 ; p++){
		yy = y;
		for (iy = RTRmapinfo[r][1];iy < RTRmapinfo[r][1] + RTRmapinfo[r][3]; iy++){
			xx = x;
			for (ix =  RTRmapinfo[r][0]; ix <  RTRmapinfo[r][0] + RTRmapinfo[r][2]; ix++){
				word b;
				if (rnor == 0)
					b = *(ROTTrandom1[p] + ix + (iy*128));
				else if (rnor == 1)
					b = *(ROTTrandom2[p] + ix + (iy*128));
				else if (rnor == 2)
					b = *(ROTTrandom3[p] + ix + (iy*128));
				else 
					b = *(ROTTrandom4[p] + ix + (iy*128));				
				
				if (b != 72)
					*(mapplanes[p] + xx++ + (yy*128)) = b;
				else
					*(mapplanes[p] + xx++ + (yy*128)) = 1;
			}
			yy++;
		}
	}
	return r;
}





void Reset16x16tilecell( int x, int y)
{
	//x,y is top left point to make normalroom (16x16 tiles)
	//we reset the outer perimeter to close all doors
	int ix,iy;	

	for (iy = y; iy < y + 16; iy++){
		for (ix = x; ix < x + 16; ix++){
			*(mapplanes[0] + ix + (iy*128)) = 1;
		}
	}	
}

void CreateAdoor(int x,int y, int dir)
{
	//dir = 0 = left 
	//dir = 1 = right 
	//dir = 2 = up 
	//dir = 3 = down 
//	int ix,iy,cx,cy;
		
	//create the door needed
	if (dir == 0){
		*(mapplanes[0] + x + ((y+6)*128)) = 33;
		*(mapplanes[0] + x + ((y+7)*128)) = 34;
		*(mapplanes[0] + x + ((y+8)*128)) = 34;
		*(mapplanes[0] + x + ((y+9)*128)) = 35;
	}else if (dir == 1){
		*(mapplanes[0] + x + 16 + ((y+6)*128)) = 33;
		*(mapplanes[0] + x + 16 + ((y+7)*128)) = 34;
		*(mapplanes[0] + x + 16 + ((y+8)*128)) = 34;
		*(mapplanes[0] + x + 16 + ((y+9)*128)) = 35;
	}else if (dir == 2){
		*(mapplanes[0] + x + 6 + (y*128)) = 33;
		*(mapplanes[0] + x + 7 + (y*128)) = 34;
		*(mapplanes[0] + x + 8 + (y*128)) = 34;
		*(mapplanes[0] + x + 9 + (y*128)) = 35;
	}else if (dir == 3){
		*(mapplanes[0] + x + 6 + ((y+16)*128)) = 33;
		*(mapplanes[0] + x + 7 + ((y+16)*128)) = 34;
		*(mapplanes[0] + x + 8 + ((y+16)*128)) = 34;
		*(mapplanes[0] + x + 9 + ((y+16)*128)) = 35;
	}


}
