
/******************************************************************************
 				GenSettingsWnd.cpp 
 Copyright  2010  Birger N. Andreasen 
 Please send any bugreports, comments and other issues to:
 E-Mail = bna@post10.tele.dk
 Homepage with other ROTT stuff = http://www.riseofthetriad.dk/
/******************************************************************************/



#include <windows.h>

#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <fcntl.h>
#include <time.h>
#include "resource.h" 
#include "develop.h"
#include <windowsx.h>
#include <string> 
#include <wtypes.h>
#include <objbase.h>
#include <unknwn.h>


extern "C"{
	#include "rt_def.h"
	#include "sprites.h"
	#include "states.h"
	#include "rt_actor.h"
	#include "rt_util.h"
	#include "scriplib.h"
	#include "keyb.h"
	#include "isr.h"
}


extern "C" {
	extern void ErrorDontQuit (char *error, int i,...);
	extern byte* HEAP_getheapmem(int size);
	extern BOOL  HEAP_freemem(LPVOID lpMem);
	LRESULT CALLBACK RottSettingsWndProc(HWND hWnd, UINT msg,WPARAM wParam, LPARAM lParam);
	extern int  GetStrFromRegdb (LPSTR Keyval, LPSTR strval, LPSTR defaultval) ;
	extern BOOL SetStrInRegdb  (LPSTR Keyval, LPSTR strval, LPSTR defaultval)  ;
	extern HBRUSH AdjustStaticBackgroundColors (HWND hwnd, HDC hdc);

	extern HWND CreateToolTip(int toolID, HWND hDlg, PTSTR pszText);

	extern void ReadConfig (void);
	extern char ApogeePath[256];
	extern char token[MAXTOKEN];
	extern char name[MAXTOKEN * 2];
	extern char scriptfilename[30];
	extern char *scriptbuffer, *script_p, *scriptend_p;
	extern int scriptline;
	extern boolean endofscript;
	extern boolean tokenready;		// only true if UnGetToken was just called

	extern boolean usemouselook ;
	extern boolean useactorsinnet   ;
	extern boolean bCreateRandMap  ;
	extern int iG_aimCross;
	extern int inverse_mouse	;
	extern boolean usebots     ;
	extern boolean usejump      ;
	extern boolean useRespawn     ;
	extern boolean useSuperhard  ;
	extern boolean useExtMonk    ;
	extern boolean UseBaseMarker  ;
	extern boolean useWind        ;
	extern boolean useRain       ;
	extern boolean useRndActors   ;




	extern boolean ankhcoingivpoint;
	extern int iDeadbodyIsTarget;
	extern int iNbRndActors		;
	extern int iRndActorTypes[20];
	extern double MouseXsen;
	extern double MouseYsen;
	extern boolean bAutoAim;
	extern boolean bAutoHorz;
	extern double g_wscale;
	extern boolean mouseenabled ;
	extern boolean joystickenabled ;
	extern boolean joypadenabled ;
	extern int joystickport ;
	extern int mouseadjustment ;
	extern int threshold ;
	extern int iPulsPushwalls ;
	extern int NumVoices ;
	extern int NumChannels ;
	extern int NumBits ;
	extern int MidiAddress ;
	extern boolean cybermanenabled ;
	extern boolean assassinenabled ;
	extern boolean spaceballenabled ;
	extern boolean AutoDetailOn ;
	extern int DoubleClickSpeed;
	extern boolean BobbinOn ;
	extern int Menuflipspeed ;
	extern int DetailLevel ;
	extern int fandc ;
	extern int blanktime ;
	extern boolean ConfigLoaded ;
	extern boolean stereoreversed ;
	extern boolean MessagesEnabled;

	extern boolean ConfigLoaded;
	extern int DefaultDifficulty ;
	extern int DefaultPlayerCharacter ;
	extern int DefaultPlayerColor ;
	extern byte passwordstring[20];
	extern int fulllight ;
	extern int viewsize ;
	extern int gammaindex;
	extern boolean ExtensiveGibsOn;
	extern boolean iKeepWeaponWhenKilled;
	extern int buttonscan[NUMBUTTONS];

	extern boolean ParseConfigFile (void);
	extern void SetConfigDefaultValues (void);
	extern void WriteConfig (void);
	extern void ReadConfig (void);
	extern void Z_Init (int size, int min);

}	

	extern COLORREF crGREEN_PROGRESS;
	extern HBRUSH   GREEN_PROGRESS;
	long LoadFileExt (char *filename, void **bufferptr);
	void LoadScriptFileExt (char *filename);
	void FillKeysCombo (HWND hWnd, int id, int selid);
	
	HINSTANCE	ghInst;
#include <CommCtrl.h>
LRESULT CALLBACK RottSettingsWndProc(HWND hWnd, UINT msg,WPARAM wParam, LPARAM lParam)
{

    switch(msg) {
		case WM_INITDIALOG:
			{
			int bt;
			float s;
			char i,tmp[64];
			char filename[264];
			static char *ConfigName = "config.rot";


			lstrcpy(tmp,"50");
			GetStrFromRegdb ((LPSTR)"DemoMem",(LPSTR)tmp,(LPSTR)"50");
/*			iDEMOBUFFSIZE = atol(tmp);
			if (iDEMOBUFFSIZE < 50){
				iDEMOBUFFSIZE = 50;
				sprintf(tmp,"%d",iDEMOBUFFSIZE);
			}
*/
			//ReadConfig ();
			GetPathFromEnvironment (filename, ApogeePath, ConfigName);
			SetConfigDefaultValues ();
			

			ReadConfig ();


			if (access (filename, F_OK) == 0) {
				LoadScriptFileExt (filename);

				if (ParseConfigFile () == false) {
					int aws = unlink (filename);	// Delete CONFIG.ROT
				}
				//GlobalFree((byte*)scriptbuffer);
				HEAP_freemem((byte*)scriptbuffer);
	
			}

			if (iKeepWeaponWhenKilled == TRUE)
				SendDlgItemMessage(hWnd,IDC_CHECK27,BM_SETCHECK,1,0);

			if (iDeadbodyIsTarget == TRUE)
				SendDlgItemMessage(hWnd,IDC_CHECK26,BM_SETCHECK,1,0);
			if (iPulsPushwalls == TRUE)
				SendDlgItemMessage(hWnd,IDC_CHECK25,BM_SETCHECK,1,0);

			if (mouseenabled == TRUE)
				SendDlgItemMessage(hWnd,IDC_CHECK1,BM_SETCHECK,1,0);
			if (inverse_mouse == TRUE)
				SendDlgItemMessage(hWnd,IDC_CHECK2,BM_SETCHECK,1,0);			
			if (usemouselook == TRUE)
				SendDlgItemMessage(hWnd,IDC_CHECK3,BM_SETCHECK,1,0);
			if (useRespawn == TRUE)
				SendDlgItemMessage(hWnd,IDC_CHECK4,BM_SETCHECK,1,0);
			if (useSuperhard == TRUE)
				SendDlgItemMessage(hWnd,IDC_CHECK5,BM_SETCHECK,1,0);
			if (useExtMonk == TRUE)
				SendDlgItemMessage(hWnd,IDC_CHECK6,BM_SETCHECK,1,0);

			if (UseBaseMarker == TRUE)
				SendDlgItemMessage(hWnd,IDC_CHECK7,BM_SETCHECK,1,0);

			if (useWind == TRUE)
				SendDlgItemMessage(hWnd,IDC_CHECK8,BM_SETCHECK,1,0);

			if (useRain == TRUE)
				SendDlgItemMessage(hWnd,IDC_CHECK9,BM_SETCHECK,1,0);
			if (bCreateRandMap == TRUE)
				SendDlgItemMessage(hWnd,IDC_CHECK10,BM_SETCHECK,1,0);
			if (useRndActors == TRUE)
				SendDlgItemMessage(hWnd,IDC_CHECK11,BM_SETCHECK,1,0);
			if (usebots == TRUE)
				SendDlgItemMessage(hWnd,IDC_CHECK12,BM_SETCHECK,1,0);


			if (bAutoAim == TRUE)
				SendDlgItemMessage(hWnd,IDC_CHECK13,BM_SETCHECK,1,0);
			if (bAutoHorz == TRUE)
				SendDlgItemMessage(hWnd,IDC_CHECK14,BM_SETCHECK,1,0);
			if (iG_aimCross == TRUE)
				SendDlgItemMessage(hWnd,IDC_CHECK15,BM_SETCHECK,1,0);
			if (joystickenabled == TRUE)
				SendDlgItemMessage(hWnd,IDC_CHECK16,BM_SETCHECK,1,0);
			if (joypadenabled == TRUE)
				SendDlgItemMessage(hWnd,IDC_CHECK17,BM_SETCHECK,1,0);
			if (AutoDetailOn == TRUE)
				SendDlgItemMessage(hWnd,IDC_CHECK18,BM_SETCHECK,1,0);
			if (ankhcoingivpoint == TRUE)
				SendDlgItemMessage(hWnd, IDC_CHECK30, BM_SETCHECK, 1, 0);

			if (fulllight == TRUE)
				SendDlgItemMessage(hWnd,IDC_CHECK19,BM_SETCHECK,1,0);
			if (BobbinOn == TRUE)
				SendDlgItemMessage(hWnd,IDC_CHECK21,BM_SETCHECK,1,0);
			if (fandc == TRUE)
				SendDlgItemMessage(hWnd,IDC_CHECK22,BM_SETCHECK,1,0);
			if (MessagesEnabled == TRUE)
				SendDlgItemMessage(hWnd,IDC_CHECK23,BM_SETCHECK,1,0);

			if (ExtensiveGibsOn == TRUE)
				SendDlgItemMessage(hWnd,IDC_CHECK24,BM_SETCHECK,1,0);


			for (i=0;i<8;i++){
				sprintf (tmp,"%d",i); 
				SendDlgItemMessage(hWnd, IDC_COMBO1, CB_ADDSTRING, (WPARAM) 0, (LPARAM) tmp);
				if ( i == gammaindex)
					SendDlgItemMessage(hWnd, IDC_COMBO1, CB_SETCURSEL, (WPARAM)i, (LPARAM) 0);
			} 

			bt = blanktime / (VBLCOUNTER * 60);
			for (i=0;i<30;i++){
				sprintf (tmp,"%d",i); 
				SendDlgItemMessage(hWnd, IDC_COMBO2, CB_ADDSTRING, (WPARAM) 0, (LPARAM) tmp);
				if ( i == bt)
					SendDlgItemMessage(hWnd, IDC_COMBO2, CB_SETCURSEL, (WPARAM)i, (LPARAM) 0);
			} 
		
			s = (float)(g_wscale - 0.7000000000000000000);
			s = (s*100); 
			for (i=0;i<30;i++){
				sprintf (tmp,"%d",i); 
				SendDlgItemMessage(hWnd, IDC_COMBO3, CB_ADDSTRING, (WPARAM) 0, (LPARAM) tmp);
				if ( i == (byte)s)
					SendDlgItemMessage(hWnd, IDC_COMBO3, CB_SETCURSEL, (WPARAM)i, (LPARAM) 0);
			} 

			for (i=0;i<11;i++){
				sprintf (tmp,"%d",i); 
				SendDlgItemMessage(hWnd, IDC_COMBO5, CB_ADDSTRING, (WPARAM) 0, (LPARAM) tmp);
				if ( i == viewsize)
					SendDlgItemMessage(hWnd, IDC_COMBO5, CB_SETCURSEL, (WPARAM)i, (LPARAM) 0);
			} 




			// Create a tooltip on IDC_COMBO5.
			HWND hwndTT = CreateWindowEx(WS_EX_TOPMOST, TOOLTIPS_CLASS, NULL,
				WS_POPUP | TTS_NOPREFIX | TTS_ALWAYSTIP,
				CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
				hWnd, NULL, GetModuleHandle(NULL), NULL);

			SetWindowPos(hwndTT, HWND_TOPMOST, 0, 0, 0, 0,
				SWP_NOMOVE | SWP_NOSIZE | SWP_NOACTIVATE);

			// Set up "tool" information. In this case, the "tool" is the entire parent window.
			TOOLINFO ti = { 0 };
			ti.cbSize = sizeof(TOOLINFO);
			ti.uFlags = TTF_SUBCLASS;
			ti.hwnd = hWnd;
			ti.hinst = GetModuleHandle(NULL);
			ti.lpszText = TEXT("Size of weapon is how big the player's weapon appear on screen.");
			GetClientRect(hWnd, &ti.rect);
			ti.rect.left = 280;
			ti.rect.right = 5350;
			ti.rect.top = 200;
			ti.rect.bottom  = 265;								
			// Associate the tooltip with the "tool" window.
			SendMessage(hwndTT, TTM_ADDTOOL, 0, (LPARAM)(LPTOOLINFO)&ti);

			for (i=0;i<12;i++){
				sprintf (tmp,"%d",i); 
				SendDlgItemMessage(hWnd, IDC_COMBO6, CB_ADDSTRING, (WPARAM) 0, (LPARAM) tmp);
				if ( i == mouseadjustment)
					SendDlgItemMessage(hWnd, IDC_COMBO6, CB_SETCURSEL, (WPARAM)i, (LPARAM) 0);
			} 

			s = (float)(MouseXsen*10);
			bt = 0;
			for (i=-30;i<31;i++){
				sprintf (tmp,"%d",i); 
				SendDlgItemMessage(hWnd, IDC_COMBO7, CB_ADDSTRING, (WPARAM) 0, (LPARAM) tmp);
				if ( i == s)
					SendDlgItemMessage(hWnd, IDC_COMBO7, CB_SETCURSEL, (WPARAM)bt, (LPARAM) 0);
				bt++;
			} 
			s = (float)(MouseYsen*10);
			bt = 0;
			for (i=-30;i<31;i++){
				sprintf (tmp,"%d",i); 
				SendDlgItemMessage(hWnd, IDC_COMBO8, CB_ADDSTRING, (WPARAM) 0, (LPARAM) tmp);
				if ( i == s)
					SendDlgItemMessage(hWnd, IDC_COMBO8, CB_SETCURSEL, (WPARAM)bt, (LPARAM) 0);
				bt++;
			}
			for (i=0;i<16;i++){
				sprintf (tmp,"%d",i); 
				SendDlgItemMessage(hWnd, IDC_COMBO9, CB_ADDSTRING, (WPARAM) 0, (LPARAM) tmp);
				if ( i == threshold)
					SendDlgItemMessage(hWnd, IDC_COMBO9, CB_SETCURSEL, (WPARAM)i, (LPARAM) 0);
			} 



			for (i=5;i<101;i++){
				sprintf (tmp,"%d",i); 
				SendDlgItemMessage(hWnd, IDC_COMBO11, CB_ADDSTRING, (WPARAM) 0, (LPARAM) tmp);
				if ( i == Menuflipspeed)
					SendDlgItemMessage(hWnd, IDC_COMBO11, CB_SETCURSEL, (WPARAM)i-5, (LPARAM) 0);
			} 

			for (i=0;i<3;i++){
				sprintf (tmp,"%d",i); 
				SendDlgItemMessage(hWnd, IDC_COMBO12, CB_ADDSTRING, (WPARAM) 0, (LPARAM) tmp);
				if ( i == DetailLevel)
					SendDlgItemMessage(hWnd, IDC_COMBO12, CB_SETCURSEL, (WPARAM)i, (LPARAM) 0);
			} 

			for (i=5;i<51;i++){
				sprintf (tmp,"%d",i); 
				SendDlgItemMessage(hWnd, IDC_COMBO10, CB_ADDSTRING, (WPARAM) 0, (LPARAM) tmp);
				if ( i == DoubleClickSpeed)
					SendDlgItemMessage(hWnd, IDC_COMBO10, CB_SETCURSEL, (WPARAM)i-5, (LPARAM) 0);
			} 

			
			FillKeysCombo (hWnd,IDC_COMBO13, buttonscan[0]);
			FillKeysCombo (hWnd,IDC_COMBO14, buttonscan[1]);
			FillKeysCombo (hWnd,IDC_COMBO15, buttonscan[2]);
			FillKeysCombo (hWnd,IDC_COMBO16, buttonscan[3]);
			FillKeysCombo (hWnd,IDC_COMBO17, buttonscan[4]);
			FillKeysCombo (hWnd,IDC_COMBO18, buttonscan[5]);
			FillKeysCombo (hWnd,IDC_COMBO19, buttonscan[6]);

			FillKeysCombo (hWnd,IDC_COMBO20, buttonscan[7]);
			FillKeysCombo (hWnd,IDC_COMBO21, buttonscan[8]);
			FillKeysCombo (hWnd,IDC_COMBO22, buttonscan[9]);
			FillKeysCombo (hWnd,IDC_COMBO23, buttonscan[10]);
			FillKeysCombo (hWnd,IDC_COMBO24, buttonscan[11]);
			FillKeysCombo (hWnd,IDC_COMBO25, buttonscan[12]);
			FillKeysCombo (hWnd,IDC_COMBO26, buttonscan[13]);

			FillKeysCombo (hWnd,IDC_COMBO27, buttonscan[14]);
			FillKeysCombo (hWnd,IDC_COMBO28, buttonscan[15]);
			FillKeysCombo (hWnd,IDC_COMBO29, buttonscan[16]);
			FillKeysCombo (hWnd,IDC_COMBO30, buttonscan[17]);
			FillKeysCombo (hWnd,IDC_COMBO31, buttonscan[18]);
			FillKeysCombo (hWnd,IDC_COMBO32, buttonscan[19]);
			FillKeysCombo (hWnd,IDC_COMBO33, buttonscan[20]);

			FillKeysCombo (hWnd,IDC_COMBO34, buttonscan[21]);
			FillKeysCombo (hWnd,IDC_COMBO35, buttonscan[22]);
			FillKeysCombo (hWnd,IDC_COMBO36, buttonscan[23]);
			FillKeysCombo (hWnd,IDC_COMBO37, buttonscan[24]);
			FillKeysCombo (hWnd,IDC_COMBO38, buttonscan[25]);
			FillKeysCombo (hWnd,IDC_COMBO39, buttonscan[26]);
			//--------------------------------------
			crGREEN_PROGRESS = RGB(45,135,29);
			GREEN_PROGRESS   = CreateSolidBrush(crGREEN_PROGRESS);

			HFONT font = (HFONT)GetStockObject(ANSI_FIXED_FONT);
			SendMessage((HWND)GetDlgItem(hWnd,IDCANCEL),WM_SETFONT, (UINT)font, 0L);
			SendMessage((HWND)GetDlgItem(hWnd,IDOK),WM_SETFONT, (UINT)font, 0L);
			SendMessage((HWND)GetDlgItem(hWnd,IDAPPLY),WM_SETFONT, (UINT)font, 0L);

			//--------------------------------------
			crGREEN_PROGRESS = RGB(45,135,29);
			GREEN_PROGRESS   = CreateSolidBrush(crGREEN_PROGRESS);

	
			break;
			}
/*
		case WM_CTLCOLORSTATIC:
			for (int ix = IDC_STATIC_GEN1;ix <= IDC_STATIC_GEN4; ix++){
				if ((HWND)lParam == GetDlgItem(hWnd,ix)) 
					SetTextColor((HDC)wParam,crGREEN_PROGRESS);
			}
			return (LRESULT)(HBRUSH)AdjustStaticBackgroundColors ((HWND)lParam,(HDC)wParam);
*/		
		case WM_COMMAND:
			switch (LOWORD(wParam)) 
			{ 
				case IDOK:
				case IDAPPLY:
					{
					char tmp[264];	
					int cursel, selres, t;
					//float dbs;


					if (IsDlgButtonChecked(hWnd,IDC_CHECK27)==1){
						SetStrInRegdb ("KeepWeaponWhenKilled","1","0"); 
						iKeepWeaponWhenKilled = 1;
					}else{
						SetStrInRegdb ("KeepWeaponWhenKilled","0","0"); 
						iKeepWeaponWhenKilled = 0;
					}

					if (IsDlgButtonChecked(hWnd,IDC_CHECK26)==1){
						SetStrInRegdb ("DeadbodyIsTarget","1","0"); 
						iDeadbodyIsTarget = 1;
					}else{
						SetStrInRegdb ("DeadbodyIsTarget","0","0"); 
						iDeadbodyIsTarget = 0;
					}


					if (IsDlgButtonChecked(hWnd,IDC_CHECK25)==1){
						SetStrInRegdb ("PulsPushwalls","1","0"); 
						iPulsPushwalls = 1;
					}else{
						SetStrInRegdb ("PulsPushwalls","0","0"); 
						iPulsPushwalls = 0;
					}

					mouseenabled = 0;
					if(IsDlgButtonChecked(hWnd,IDC_CHECK1) == BST_CHECKED)
						mouseenabled = 1;
					inverse_mouse = 0;
					if(IsDlgButtonChecked(hWnd,IDC_CHECK2) == BST_CHECKED)
						inverse_mouse = 1;
					usemouselook = 0;
					if(IsDlgButtonChecked(hWnd,IDC_CHECK3) == BST_CHECKED)
						usemouselook = 1;

					useRespawn = 0;
					if(IsDlgButtonChecked(hWnd,IDC_CHECK4) == BST_CHECKED)
						useRespawn = 1;	

					useSuperhard = 0;
					if(IsDlgButtonChecked(hWnd,IDC_CHECK5) == BST_CHECKED)
						useSuperhard = 1;	

					useExtMonk = 0;
					if(IsDlgButtonChecked(hWnd,IDC_CHECK6) == BST_CHECKED)
						useExtMonk = 1;	

					UseBaseMarker = 0;
					if(IsDlgButtonChecked(hWnd,IDC_CHECK7) == BST_CHECKED)
						UseBaseMarker = 1;	

					useWind = 0;
					if(IsDlgButtonChecked(hWnd,IDC_CHECK8) == BST_CHECKED)
						useWind = 1;	

					useRain = 0;
					if(IsDlgButtonChecked(hWnd,IDC_CHECK9) == BST_CHECKED)
						useRain = 1;	

					bCreateRandMap = 0;
					if(IsDlgButtonChecked(hWnd,IDC_CHECK10) == BST_CHECKED)
						bCreateRandMap = 1;	

					useRndActors = 0;
					if(IsDlgButtonChecked(hWnd,IDC_CHECK11) == BST_CHECKED)
						useRndActors = 1;	

					usebots = 0;
					if(IsDlgButtonChecked(hWnd,IDC_CHECK12) == BST_CHECKED)
						usebots = 1;

					bAutoAim = 0;
					if(IsDlgButtonChecked(hWnd,IDC_CHECK13) == BST_CHECKED)
						bAutoAim = 1;

					bAutoHorz = 0;
					if(IsDlgButtonChecked(hWnd,IDC_CHECK14) == BST_CHECKED)
						bAutoHorz = 1;

					iG_aimCross = 0;
					if(IsDlgButtonChecked(hWnd,IDC_CHECK15) == BST_CHECKED)
						iG_aimCross = 1;

					joystickenabled = 0;
					if(IsDlgButtonChecked(hWnd,IDC_CHECK16) == BST_CHECKED)
						joystickenabled = 1;

					joypadenabled = 0;
					if(IsDlgButtonChecked(hWnd,IDC_CHECK17) == BST_CHECKED)
						joypadenabled = 1;

					ankhcoingivpoint = 0;
					if (IsDlgButtonChecked(hWnd, IDC_CHECK30) == BST_CHECKED)
						ankhcoingivpoint = 1;

					AutoDetailOn = 0;
					if(IsDlgButtonChecked(hWnd,IDC_CHECK18) == BST_CHECKED)
						AutoDetailOn = 1;

					fulllight = 0;
					if(IsDlgButtonChecked(hWnd,IDC_CHECK19) == BST_CHECKED)
						fulllight = 1;

					BobbinOn = 0;
					if(IsDlgButtonChecked(hWnd,IDC_CHECK21) == BST_CHECKED)
						BobbinOn = 1;

					fandc = 0;
					if(IsDlgButtonChecked(hWnd,IDC_CHECK22) == BST_CHECKED)
						fandc = 1;
					fandc = 0;

					MessagesEnabled = 0;
					if(IsDlgButtonChecked(hWnd,IDC_CHECK23) == BST_CHECKED)
						MessagesEnabled = 1;

					ExtensiveGibsOn  = 0;
					if(IsDlgButtonChecked(hWnd,IDC_CHECK24) == BST_CHECKED)
						ExtensiveGibsOn = 1;

					GetWindowText(GetDlgItem(hWnd,IDC_COMBO1),tmp,255);
					gammaindex = atol (tmp);

					GetWindowText(GetDlgItem(hWnd,IDC_COMBO2),tmp,255);
					blanktime = atol (tmp);  
					blanktime = blanktime * 60 * VBLCOUNTER;

					GetWindowText(GetDlgItem(hWnd,IDC_COMBO3),tmp,255);
					g_wscale = atol (tmp);

				//	dbs = (g_wscale/100); 
				//	g_wscale = dbs + 0.7000000000000000000;

					g_wscale = ((double)g_wscale/100)+0.7000000000000000000;


					GetWindowText(GetDlgItem(hWnd,IDC_COMBO5),tmp,255);
					viewsize = atol (tmp);  

					GetWindowText(GetDlgItem(hWnd,IDC_COMBO6),tmp,255);
					mouseadjustment = atol (tmp); 

					GetWindowText(GetDlgItem(hWnd,IDC_COMBO7),tmp,255);
					MouseXsen = atol (tmp); 
					MouseXsen /= 10;

					GetWindowText(GetDlgItem(hWnd,IDC_COMBO8),tmp,255);
					MouseYsen = atol (tmp); 
					MouseYsen /= 10;

					GetWindowText(GetDlgItem(hWnd,IDC_COMBO9),tmp,255);
					threshold = atol (tmp); 

					GetWindowText(GetDlgItem(hWnd,IDC_COMBO11),tmp,255);
					Menuflipspeed = atol (tmp); 

					GetWindowText(GetDlgItem(hWnd,IDC_COMBO12),tmp,255);
					DetailLevel = atol (tmp); 

					GetWindowText(GetDlgItem(hWnd,IDC_COMBO10),tmp,255);
					DoubleClickSpeed = atol (tmp); 

					t = 0;
					for (selres = IDC_COMBO13; selres <= IDC_COMBO39;selres++){
						cursel = SendMessage(GetDlgItem(hWnd,selres),CB_GETCURSEL,(WPARAM) 0,(LPARAM) 0);
						buttonscan[t++] = SendMessage(GetDlgItem(hWnd,selres), CB_GETITEMDATA, cursel, (DWORD)0 );
					}
					ConfigLoaded = 1;
					WriteConfig ();
					ConfigLoaded = 0;
					if (LOWORD(wParam)==IDOK)
						EndDialog(hWnd, TRUE);          // Exit the dialog

					}
					break;
				case IDCANCEL:
					EndDialog(hWnd, TRUE);          // Exit the dialog
					break;
				case IDC_CHECK_SAVGAMERRC://
					{
					if(IsDlgButtonChecked(hWnd,IDC_CHECK_SAVGAMERRC) == BST_CHECKED){
						SetStrInRegdb ("UseSavegameErrCorr","1","0");
						//cUseSavegameErrCorr = 1;
					}else{
						SetStrInRegdb ("UseSavegameErrCorr","0","0");
						//cUseSavegameErrCorr = 0;
					}

					}
					break;
				case IDC_CHECK_SAVGAMSOFTEN://
					{
					if(IsDlgButtonChecked(hWnd,IDC_CHECK_SAVGAMSOFTEN) == BST_CHECKED){
						SetStrInRegdb ("UseSavegameSoften","1","0");
						//cUseSavegameSoften = 1;
					}else{
						SetStrInRegdb ("UseSavegameSoften","0","0");
						//cUseSavegameSoften = 0;
					}
					}
					break;


				case IDC_CHECK_USEOLDPIC://
					{
					if(IsDlgButtonChecked(hWnd,IDC_CHECK_USEOLDPIC) == BST_CHECKED){
						SetStrInRegdb ("UseSavegameOldpic","1","0");
						SetStrInRegdb("UseSavegameGLpic", "0", "0");
					}else{
						SetStrInRegdb ("UseSavegameOldpic","0","0");
						SetStrInRegdb("UseSavegameGLpic", "1", "0");
					}
					}
					break;

				case IDC_CHECK_SAVGAMUSEGLPIC://
					{
					if(IsDlgButtonChecked(hWnd,IDC_CHECK_SAVGAMUSEGLPIC) == BST_CHECKED){
						SetStrInRegdb ("UseSavegameGLpic","1","0");
						SetStrInRegdb("UseSavegameOldpic", "0", "0");
					}else{
						SetStrInRegdb ("UseSavegameGLpic","0","0");
						SetStrInRegdb("UseSavegameOldpic", "1", "0");
					}
					}
					break;
			}
			break;
    }
    return FALSE;
}



void LoadScriptFileExt (char *filename)
{
    long size;

    size = LoadFileExt (filename, (void **)&scriptbuffer);

    strcpy (&scriptfilename[0], filename);
    script_p = scriptbuffer;
    scriptend_p = script_p + size;
    scriptline = 1;
    endofscript = false;
    tokenready = false;
}


long LoadFileExt (char *filename, void **bufferptr)
{
    int handle;
    long length;

    handle = SafeOpenRead (filename);
    length = filelength (handle);
    //*bufferptr = SafeMalloc (length);
	//*bufferptr = GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,length);
	*bufferptr = HEAP_getheapmem(length);

    SafeRead (handle, *bufferptr, length);
    close (handle);
    return length;
}


void FillKeysCombo (HWND hWnd, int id, int selid)
{

	int x,i = 0;
	DWORD j;

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) i, (LPARAM) "Comma");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, (WPARAM)i++, (LPARAM) 0x33 ); 

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) i, (LPARAM) "Period");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, (WPARAM)i++, (LPARAM) 0x34 );  

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) i, (LPARAM) "Enter");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x1c ); 

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) i, (LPARAM) "Escape");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x01 ); 

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "Space");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x39 ); 

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "BackSpace");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x0e ); 

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "Tab");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x0f ); 

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "Alt");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x38 ); 

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "Control");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x1d ); 

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "CapsLock");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x3a ); 

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "LShift");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x2a ); 

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "RShift");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x36 ); 

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "UpArrow");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x48 );

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "DownArrow");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x50 );

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "LeftArrow");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x4b );

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "RightArrow");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x4d );

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "Insert");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x52 );

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "Delete");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x53 );

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "Home");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x47 );

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "End");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x4f );

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "PgUp");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x49 );

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "PgDn");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x51 );

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "F1");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x3b );
	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "F2");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x3c );
	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "F3");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x3d );
	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "F4");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x3e );
	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "F5");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x3f );
	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "F6");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x40 );
	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "F7");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x41 );
	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "F8");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x42 );
	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "F9");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x43 );
	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "F10");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x44 );
	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "F11");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x57 );
	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "F12");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x58 );

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "PrintScreen");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x37 );

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "OpenBracket");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x1a );
	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "CloseBracket");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x1b );

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "1");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x02 );
	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "2");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x03 );
	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "3");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x04 );
	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "4");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x05 );
	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "5");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x06 );
	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "6");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x07 );
	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "7");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x08 );
	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "8");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x09 );
	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "9");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x0a );
	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "0");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x0b );

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "Minus");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x0c );
	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "Equals");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x0d );
	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "Plus");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x0d );

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "A");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x1e );

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "B");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x30 );

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "C");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x2e );

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "D");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x20 );

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "E");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x12 );

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "F");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x21 );

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "G");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x22 );

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "H");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x23 );

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "I");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x17 );

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "J");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x24 );

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "K");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x25 );

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "L");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x26 );

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "M");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x32 );

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "N");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x31 );

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "O");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x18 );

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "P");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x19 );

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "Q");
    SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x10 );

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "R");
	SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x13 );

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "S");
	SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x1f );

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "T");
	SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x14 );

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "U");
	SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x16 );

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "V");
	SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x2f );

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "W");
	SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x11 );

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "X");
	SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x2d );

	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "Y");
	SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x15 );


	SendDlgItemMessage(hWnd, id, CB_ADDSTRING, (WPARAM) 0, (LPARAM) "Z");
	SendMessage(  GetDlgItem(hWnd,id), CB_SETITEMDATA, i++, (DWORD) 0x2c );

	i--;
	for (x=0;x<=i;x++){
		j = SendMessage(GetDlgItem(hWnd,id),CB_GETITEMDATA,(WPARAM) x,(LPARAM)0);
		if (j == selid){
			SendDlgItemMessage(hWnd, id, CB_SETCURSEL, (WPARAM) x, (LPARAM) 0);
			break;
		}
	}


}



