
/******************************************************************************
 				SfxSettingsWnd.c 
 Copyright  2008  Birger N. Andreasen 
 Please send any bugreports, comments and other issues to:
 E-Mail = bna@post10.tele.dk
 Homepage with other ROTT stuff = http://www.riseofthetriad.dk/
/******************************************************************************/



#include <windows.h>
#include "WinRott.h"
#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <fcntl.h>
#include <time.h>
#include "resource.h" 
#include "develop.h"
#include <windowsx.h>
#include <string> 
#include <wtypes.h>
#include <objbase.h>
#include <unknwn.h>

// required DirectMusic includes
#include <dmksctrl.h>
#include <dmusici.h>
#include <dmusicc.h>
#include <dmusicf.h>
#include <shlobj.h>


extern "C" {
	extern BOOL  HEAP_freemem(LPVOID lpMem);
	extern void ShutdownDirectMusic (void);
	extern BOOL InitDirectMusic (void);
	LRESULT CALLBACK SfxSettingsWndProc(HWND hWnd, UINT msg,WPARAM wParam, LPARAM lParam);
	LRESULT CALLBACK SSoundDrvWndProc(HWND hWnd, UINT msg,WPARAM wParam, LPARAM lParam);
	extern HINSTANCE	hInst;
    extern HWND hMainWnd;
	extern int	musfix;
	extern int	iUseOrgThunder;
	void ErrorBoxD(LPSTR lpszErrorStr, HRESULT hr);
	BOOL EnumPortsPrv(char *DriverName, DWORD Flags);
	extern void ErrorDontQuit (char *error, int i,...);
	extern void ExitWinRott();
	extern int  GetStrFromRegdb (LPSTR Keyval, LPSTR strval, LPSTR defaultval) ;
	extern BOOL SetStrInRegdb  (LPSTR Keyval, LPSTR strval, LPSTR defaultval)  ;
	extern BOOL InitDirectSound();
	extern char Mp3Path[256];
	extern void SetTextMode (void);
	extern int  GfxGetSetDialogItem(HWND hWnd, int id, char *str, char *defval);
	extern int  DS_NoSound;
	extern int  DS_NoMusic;
	extern int  iUseSurroundEffect;
	extern int  iUseDB50XGfix,iUseSimpleSound;


	extern BOOL  bUseExtSFX;
	extern void ShutdownDirectMusic (void);
	extern HBRUSH AdjustStaticBackgroundColors (HWND hwnd, HDC hdc);
	extern void MU_PlaySong (int num);
	extern void MU_Startup (boolean bombonerror);
	extern long LoadResourceToFixedMem (LPSTR Type ,int sndnb, void **bufferptr);
	extern int MUSIC_PlaySongROTT (unsigned char *song, int size, int loopflag);
	extern bool SetMasterVol (long lvol);
	extern void StopMidiMusic (void);


	extern int iUseMp3Music;
	extern int iUseWaterSnd;
	extern long MUvolume;



}	

float g_fReverbMix = -10;
float g_fReverbTime = 1000;
float g_fHighFreqRTRatio = (float)0.001;

float g_fReverbMixOrg = 0;
float g_fReverbTimeOrg = 0;
float g_fHighFreqRTRatioOrg = 0;

byte *midiloadbuffer = 0;
int	  midisize = 0;

extern void ErrorBoxD(LPSTR lpszErrorStr, HRESULT hr);
BOOL SelectFolderName(HWND hDlg);

extern IDirectMusicPerformance *Prfm ;	
extern IDirectMusicSegment		*Seg;		
extern IDirectMusicLoader		*Ldr;	

extern long MidiLength		;
extern long glVol			;
extern MUSIC_TIME pmtNow	;

extern IDirectMusic* gpDirectMusic ;
extern IDirectMusicPort* pPort		;
extern IDirectMusicPort* xPort		;

extern HWND sndLB;
extern char g_snddrivername[128];


void SfxMsg_InitDialog (HWND hWnd);
int SfxGetSetDialogItem(HWND hWnd, int id, char *str, char *defval);


extern COLORREF crBACKG; 
extern HBRUSH   BACKG;  
COLORREF crGREEN_PROGRESS;
HBRUSH   GREEN_PROGRESS;


LRESULT CALLBACK SfxSettingsWndProc(HWND hWnd, UINT msg,WPARAM wParam, LPARAM lParam)
{

    switch(msg) {
		case WM_INITDIALOG:
			{
			IDirectMusicPort* pPort1 = NULL;
			DMUS_PORTPARAMS dmos;
			DMUS_PORTCAPS dmpc;
			GUID guidSynthGUID;
			HRESULT hr = S_OK;
			char tmp[148];
			int i,nb;
//			HBITMAP hButtonPic;
			HGDIOBJ font; 
			//161 = IDB_BITMAP7
			//--------------------------------------
			crGREEN_PROGRESS = RGB(45,135,29);
			GREEN_PROGRESS   = CreateSolidBrush(crGREEN_PROGRESS);

			InitDirectSound();
			InitDirectMusic();


			GetStrFromRegdb ((LPSTR)"Mp3Path",(LPSTR)&Mp3Path,(LPSTR)"");
			SetWindowText(GetDlgItem(hWnd,1008),Mp3Path);

			GfxGetSetDialogItem(hWnd,ID_SETTINGS_USEMP3MUSIC,"UseMp3Music","0");
			GfxGetSetDialogItem(hWnd,ID_SETTINGS_USESIMPLESND,"UseSimpleSnd","0");

			GfxGetSetDialogItem(hWnd,ID_SETTINGS_NOMUSIC,"DS_NoMusic","1");
			GfxGetSetDialogItem(hWnd,ID_SETTINGS_NOSOUND,"DS_NoSound","1");
			GfxGetSetDialogItem(hWnd,ID_SETTINGS_USESURROUNDEFFECTS,"UseSurroundEffect","0");
			GfxGetSetDialogItem(hWnd,ID_SETTINGS_USESFX,"UseExtSounds","1");
			GfxGetSetDialogItem(hWnd,IDC_CHECK1,"SoundFix","1");

			GfxGetSetDialogItem(hWnd,ID_SETTINGS_ORGTHUNDERONOFF,"UseOrgThunder","1");
			GfxGetSetDialogItem(hWnd,ID_SETTINGS_WATERSNDONOFF,"UseWaterSnd","0");

			GfxGetSetDialogItem(hWnd,ID_SETTINGS_USE_DB50XG_FIX,"UseDB50XGfix","0");


			GetStrFromRegdb ((LPSTR)"g_fReverbMix",(LPSTR)&tmp,(LPSTR)"");
			g_fReverbMix = (float)atof(tmp);
			SetWindowText(GetDlgItem(hWnd,IDC_EDIT_REVERBMIX),tmp);

			GetStrFromRegdb ((LPSTR)"g_fReverbTime",(LPSTR)&tmp,(LPSTR)"");
			g_fReverbTime = (float)atof(tmp);
			SetWindowText(GetDlgItem(hWnd,IDC_EDIT_REVERBTIME),tmp);

			GetStrFromRegdb ((LPSTR)"g_fHighFreqRTRatio",(LPSTR)&tmp,(LPSTR)"");
			g_fHighFreqRTRatio = (float)atof(tmp);
			SetWindowText(GetDlgItem(hWnd,IDC_EDIT_REVERBRATIO),tmp);

			 


			crBACKG = RGB(236,233,216); 
			BACKG   = CreateSolidBrush(crBACKG);

			font = GetStockObject(ANSI_FIXED_FONT);
			SendMessage((HWND)GetDlgItem(hWnd,IDCANCEL),WM_SETFONT, (UINT)font, 0L);
			SendMessage((HWND)GetDlgItem(hWnd,IDOK),WM_SETFONT, (UINT)font, 0L);
			SendMessage((HWND)GetDlgItem(hWnd,1003),WM_SETFONT, (UINT)font, 0L);

			ShutdownDirectMusic ();
			sndLB = GetDlgItem(hWnd,1002);//IDC_LIST1=1002

			//get ealier selected driver
			GetStrFromRegdb ("Sounddriver",g_snddrivername,"Microsoft Synthesizer");
			if (g_snddrivername[0] == 0)
				lstrcpy(g_snddrivername,"Microsoft Synthesizer");

			GetStrFromRegdb ("SoundFix",tmp,"0");
			musfix = atol(tmp);
			if (musfix == 1)
				SendDlgItemMessage(hWnd,1004,BM_SETCHECK,1,0);
			else
				SendDlgItemMessage(hWnd,1004,BM_SETCHECK,0,0);

			for (DWORD index = 0; index<100; index++)//check max 100 ports
			{
				ZeroMemory(&dmpc, sizeof(dmpc));
				dmpc.dwSize = sizeof(DMUS_PORTCAPS);
				hr = gpDirectMusic->EnumPort(index, &dmpc);
				if(hr == S_OK)
				{
					if ( (dmpc.dwClass == DMUS_PC_OUTPUTCLASS) && 
						(dmpc.dwFlags & DMUS_PC_SOFTWARESYNTH|DMUS_PC_EXTERNAL|DMUS_PC_DLS|DMUS_PC_DIRECTSOUND ) )
					{
						CopyMemory(&guidSynthGUID, &dmpc.guidPort,
								sizeof(GUID));
		 
						ZeroMemory(&dmos, sizeof(dmos));
						dmos.dwSize = sizeof(DMUS_PORTPARAMS);
						dmos.dwChannelGroups = 1; 
						dmos.dwValidParams = DMUS_PORTPARAMS_CHANNELGROUPS;
		 
						hr = gpDirectMusic->CreatePort(guidSynthGUID, 
								&dmos, &pPort1, NULL);
						ZeroMemory(&dmpc, sizeof(dmpc));

						dmpc.dwSize = sizeof(DMUS_PORTCAPS);
						 
						hr=pPort1->GetCaps(&dmpc);
						for (i=0;i<128;i++){
							tmp[i]=(char)dmpc.wszDescription[i];
						}
						SendMessage(sndLB,LB_ADDSTRING , 0,(LPARAM)tmp);
						//release it and find next port
						pPort1->Release();
					}

				}
			}

			nb = SendMessage(sndLB,LB_GETCOUNT,(WPARAM)0,(LPARAM) 0);
			for (i=0;i<=nb;i++){
				SendMessage(sndLB, LB_GETTEXT,i,(LONG)(LPSTR)tmp);
				if (lstrcmpi(g_snddrivername,tmp)==0){
					SendMessage(sndLB,LB_SETCURSEL,(WPARAM)i, (LPARAM) 0);
					SetWindowText(GetDlgItem(hWnd,1005),g_snddrivername);//IDC_EDIT_SNDDRV

					break;
				}
			}
			pPort1 = NULL;
			g_fReverbMixOrg = g_fReverbMix;
			g_fReverbTimeOrg = g_fReverbTime;
			g_fHighFreqRTRatioOrg = g_fHighFreqRTRatio;

			InitDirectMusic ();
			SetMasterVol (240);//bna++
			break;
			}

/*
		case WM_CTLCOLORSTATIC:
			if ((HWND)lParam == GetDlgItem(hWnd,IDC_STATIC_S1)) 
				SetTextColor((HDC)wParam,crGREEN_PROGRESS);
			if ((HWND)lParam == GetDlgItem(hWnd,IDC_STATIC_SF1)) 
				SetTextColor((HDC)wParam,crGREEN_PROGRESS);
			if ((HWND)lParam == GetDlgItem(hWnd,IDC_STATIC_SF2)) 
				SetTextColor((HDC)wParam,crGREEN_PROGRESS);
			if ((HWND)lParam == GetDlgItem(hWnd,IDC_STATIC_S3)) 
				SetTextColor((HDC)wParam,crGREEN_PROGRESS);
			return (LRESULT)(HBRUSH)AdjustStaticBackgroundColors ((HWND)lParam,(HDC)wParam);
		*/
		case WM_COMMAND:
			switch (LOWORD(wParam)) 
			{ 
				case 1002://idc_list1
					{
					char tmp[148];
					int x = SendMessage(GetDlgItem(hWnd, 1002),LB_GETCURSEL,0,(LPARAM)0);
					SendMessage(sndLB, LB_GETTEXT,x,(LONG)(LPSTR)tmp);
					SetWindowText(GetDlgItem(hWnd,1005),tmp);//IDC_EDIT_SNDDRV	
					break;
					}
					break;

				case 1007:
					SelectFolderName(hWnd);
					break;
				case 1004://IDC_CHECK1
					{
					if(IsDlgButtonChecked(hWnd,1004) == BST_CHECKED){
						SetStrInRegdb ("SoundFix","1","0");
						musfix = 1;
					}else{
						SetStrInRegdb ("SoundFix","0","0");
						musfix = 0;
					}
				break;
					}
					break;

				case IDCANCEL:
					g_fReverbMix = g_fReverbMixOrg;
					g_fReverbTime = g_fReverbTimeOrg;
					g_fHighFreqRTRatio = g_fHighFreqRTRatioOrg;
					StopMidiMusic ();
					ShutdownDirectMusic ();
					if (midiloadbuffer != 0){
						//GlobalFree (midiloadbuffer);//release mem;
						HEAP_freemem (midiloadbuffer);//release mem;
						midiloadbuffer = 0;
						midisize = 0;
					}
					EndDialog(hWnd, TRUE);          // Exit the dialog
					break;


				case IDTESTSND1://IDTESTSND1:
				case IDTESTSND2://IDTESTSND2:
				case IDTESTSND3://IDTESTSND3:
					{
					char tmp[128];
							
					MU_Startup (0);
							
					if (midisize == 0)
						 midisize = LoadResourceToFixedMem ("MID", IDR_MID2,(void**) &midiloadbuffer);
					StopMidiMusic ();

					ShutdownDirectMusic ();
					InitDirectMusic ();
					GetWindowText(GetDlgItem(hWnd,IDC_EDIT_REVERBMIX),tmp,255);
					g_fReverbMix = (float)atof(tmp);

					GetWindowText(GetDlgItem(hWnd,IDC_EDIT_REVERBTIME),tmp,255);
					g_fReverbTime = (float)atof(tmp);

					GetWindowText(GetDlgItem(hWnd,IDC_EDIT_REVERBRATIO),tmp,255);
					g_fHighFreqRTRatio = (float)atof(tmp);
					SetMasterVol (240);//bna++
					MUSIC_PlaySongROTT (midiloadbuffer, midisize, 1);

					}
					break;

				case 1054://IDAPPLYSF:
				case IDOK:
				case 1003://IDC_SELECT
					{
						char tmp[148];
						int ix;
						ix = SendMessage(sndLB,LB_GETCURSEL,(WPARAM)0, (LPARAM) 0);    
						SendMessage(sndLB, LB_GETTEXT,ix,(LONG)(LPSTR)tmp);
						if (tmp[0] != 0){
							SetStrInRegdb ("Sounddriver",tmp,"");
							lstrcpy(g_snddrivername,tmp);
						}
						GetWindowText(GetDlgItem(hWnd,1008),Mp3Path,255);
						SetStrInRegdb ((LPSTR)"Mp3Path",(LPSTR)Mp3Path,(LPSTR)"");

						if (IsDlgButtonChecked(hWnd,ID_SETTINGS_SOUNDFIX)==1){
							SetStrInRegdb ("SoundFix","1","0"); 
							musfix = 1;
						}else{
							SetStrInRegdb ("SoundFix","0","0"); 
							musfix = 0;
						}

						if (IsDlgButtonChecked(hWnd,ID_SETTINGS_ORGTHUNDERONOFF)==1){
							SetStrInRegdb ("UseOrgThunder","1","0"); 
							iUseOrgThunder = 1;
						}else{
							SetStrInRegdb ("UseOrgThunder","0","0"); 
							iUseOrgThunder = 0;
						}

						if (IsDlgButtonChecked(hWnd,ID_SETTINGS_WATERSNDONOFF)==1){
							SetStrInRegdb ("UseWaterSnd","1","0"); 
							iUseWaterSnd = 1;
						}else{
							SetStrInRegdb ("UseWaterSnd","0","0"); 
							iUseWaterSnd = 0;
						}

						if (IsDlgButtonChecked(hWnd,ID_SETTINGS_NOMUSIC)==1){
							SetStrInRegdb ("DS_NoMusic","1","0"); 
							DS_NoMusic = 1;
						}else{
							SetStrInRegdb ("DS_NoMusic","0","0"); 
							DS_NoMusic = 0;
						}
						if (IsDlgButtonChecked(hWnd,ID_SETTINGS_NOSOUND)==1){
							SetStrInRegdb ("DS_NoSound","1","0"); 
							DS_NoSound = 1;
						}else{
							SetStrInRegdb ("DS_NoSound","0","0"); 
							DS_NoSound = 0;
						}
						if (IsDlgButtonChecked(hWnd,ID_SETTINGS_USESURROUNDEFFECTS)==1){
							SetStrInRegdb ("UseSurroundEffect","1","0"); 
							iUseSurroundEffect = 1;
						}else{
							SetStrInRegdb ("UseSurroundEffect","0","0"); 
							iUseSurroundEffect = 0;
						}

						if (IsDlgButtonChecked(hWnd,ID_SETTINGS_USE_DB50XG_FIX)==1){
							SetStrInRegdb ("UseDB50XGfix","1","0"); 
							iUseDB50XGfix = 1;
						}else{
							SetStrInRegdb ("UseDB50XGfix","0","0"); 
							iUseDB50XGfix = 0;
						}



						 
						if (IsDlgButtonChecked(hWnd,ID_SETTINGS_USESFX)==1){
							SetStrInRegdb ("UseExtSounds","1","0"); 
							bUseExtSFX = 1;
						}else{
							SetStrInRegdb ("UseExtSounds","0","0"); 
							bUseExtSFX = 0;
						}

						if (IsDlgButtonChecked(hWnd,ID_SETTINGS_USEMP3MUSIC)==1){
							SetStrInRegdb ("UseMp3Music","1","0"); 
							iUseMp3Music = 1;
						}else{
							SetStrInRegdb ("UseMp3Music","0","0"); 
							iUseMp3Music = 0;
						}

						if (IsDlgButtonChecked(hWnd,ID_SETTINGS_USESIMPLESND)==1){
							SetStrInRegdb ("UseSimpleSnd","1","0"); 
							iUseSimpleSound = 1;
						}else{
							SetStrInRegdb ("UseSimpleSnd","0","0"); 
							iUseSimpleSound = 0;
						}


						GetWindowText(GetDlgItem(hWnd,IDC_EDIT_REVERBMIX),tmp,255);
						SetStrInRegdb ((LPSTR)"g_fReverbMix",(LPSTR)tmp,(LPSTR)"");
						g_fReverbMix = (float)atof(tmp);

						GetWindowText(GetDlgItem(hWnd,IDC_EDIT_REVERBTIME),tmp,255);
						SetStrInRegdb ((LPSTR)"g_fReverbTime",(LPSTR)tmp,(LPSTR)"");
						g_fReverbTime = (float)atof(tmp);

						GetWindowText(GetDlgItem(hWnd,IDC_EDIT_REVERBRATIO),tmp,255);
						SetStrInRegdb ((LPSTR)"g_fHighFreqRTRatio",(LPSTR)tmp,(LPSTR)"");
						g_fHighFreqRTRatio = (float)atof(tmp);

	
						//InitDirectMusic ();
						if ((LOWORD(wParam))!= 1054){
							StopMidiMusic ();
							ShutdownDirectMusic ();
							if (midiloadbuffer != 0){
								//GlobalFree (midiloadbuffer);//release mem;
								HEAP_freemem (midiloadbuffer);//release mem;
								midiloadbuffer = 0;
								midisize = 0;
							}
							EndDialog(hWnd, TRUE);          // Exit the dialog
						}
						break;
					}
					break;
			}
			break;
    }
    return FALSE;
}




BOOL SelectFolderName(HWND hDlg)
{
	BROWSEINFO		bi;         
    LPITEMIDLIST	pidl; 
	char			gPATH[265]="";

	OleInitialize(NULL);

	ZeroMemory(&bi,sizeof(bi));  
	bi.hwndOwner = hDlg;
//    bi.pszDisplayName = s; 
	bi.lpszTitle = "Select folderpath to Mp3 files";  
	bi.pidlRoot = 0;
    bi.ulFlags = BIF_EDITBOX | BIF_RETURNONLYFSDIRS ;//BIF_STATUSTEXT;
    pidl = SHBrowseForFolder(&bi);            
	if (pidl) {
       if (SHGetPathFromIDList(pidl,gPATH)) {
			lstrcat (gPATH,"\\");
			SetWindowText(GetDlgItem(hDlg,1008),gPATH);
            return 1;
	   }
    }   
	

    return 0;



}


