
/******************************************************************************\
* TCP_IP_Net.c - TCP/UDP client using Winsock 
\******************************************************************************/

/*

 Copyright  2004, Birger N. Andreasen 
 Please send any bugreports, comments and other issues to:
 E-Mail = bna@post10.tele.dk
 Homepage with other ROTT stuff = http://home14.inet.tele.dk/Bna-Info

*/



#define WIN32_LEAN_AND_MEAN
#include <winsock2.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

#include "rottnet.h"

#define DEFAULT_PORT 61000//5001
#define DEFAULT_PROTO SOCK_STREAM // TCP


//Globals
extern rottcom_t   *rottcom;
extern int EmergencyExit;

//client
WSADATA wsaData;
SOCKET  conn_socket;
int socket_type;
//	socket_type = SOCK_STREAM;//TCP
//	socket_type = SOCK_DGRAM;//UDP
struct sockaddr_in Tcpserver;
struct hostent *hp;
//server 
struct sockaddr_in local, from;
SOCKET listen_socket, msgsock;
fd_set readfds, writefds, exceptfd,exceptfds;

int EmergencyExit = 0;
BOOL bUseServerSocket = 0;

int InitClientFTP_IP_socket (LPSTR SrvName);
int InitServerFTP_IP_socket (LPSTR SrvName);
int ReadUDPPacket (BOOL UseServerSocket );
int WriteUDPPacket (BOOL UseServerSocket );

//--------------------------------------------------------------------------------------
int InitClientFTP_IP_socket (LPSTR SrvName)
{


	char			*server_name= "";
	unsigned short	port = DEFAULT_PORT;
	int				ioctl_opt =1;
    int             retval;
	int				maxloop=-1;
	unsigned int	addr;
	char			buf[128];

	if (SrvName[0] != 0){
		server_name = SrvName;
	}

	//socket_type = SOCK_STREAM;//TCP
	socket_type = 	SOCK_DGRAM;//UDP

	if (WSAStartup(0x202,&wsaData) == SOCKET_ERROR) {
		sprintf(buf,"WSAStartup failed with error %d\n",WSAGetLastError());
		WriteLBtext(buf);
		WSACleanup();
    	EmergencyExit = 1;
		return -1;
	}
	
	if (port == 0){
		WriteLBtext("Invalid port");
		WSACleanup();
    	EmergencyExit = 1;
		return -1;
	}
//
	// Attempt to detect if we should call gethostbyname() or
	// gethostbyaddr()

	if (isalpha(server_name[0])) {   /* server address is a name */
		hp = gethostbyname(server_name);
	}
	else  { /* Convert nnn.nnn address to a usable one */
		addr = inet_addr(server_name);
		hp = gethostbyaddr((char *)&addr,4,AF_INET);
	}
	if (hp == NULL ) {
		sprintf(buf,"Client: Cannot resolve address [%s]: Error %d\n",
			server_name,WSAGetLastError());
		WriteLBtext(buf);
		WSACleanup();
    	EmergencyExit = 1;
		return -1;
	}

	//
	// Copy the resolved information into the sockaddr_in structure
	//
	memset(&Tcpserver,0,sizeof(Tcpserver));
	memcpy(&(Tcpserver.sin_addr),hp->h_addr,hp->h_length);
	Tcpserver.sin_family = hp->h_addrtype;
	Tcpserver.sin_port = htons(port);

	conn_socket = socket(AF_INET,socket_type,0); /* Open a socket */
	if (conn_socket <0 ) {
		sprintf(buf,"Client: Error Opening socket: Error %d\n",
			WSAGetLastError());
		WriteLBtext(buf);
		WSACleanup();
    	EmergencyExit = 1;
		return -1;
	}


	sprintf(buf,"Client connecting to: %s\n",hp->h_name);
	WriteLBtext(buf);

    do{
       retval =  connect(conn_socket,(struct sockaddr*)&Tcpserver,sizeof(Tcpserver));             
       if (GetAsyncKeyState(VK_PAUSE) != 0){
    		sprintf(buf,"connect() failed: %d\n",WSAGetLastError());
    		WriteLBtext(buf);
    		WSACleanup();
        	EmergencyExit = 1;
    		return -1;                                 
       }
       Sleep(1000);
    }while(retval == SOCKET_ERROR);
    
	//
	// Set the socket to non-blocking mode.
	//
	if (ioctlsocket(conn_socket,FIONBIO,&ioctl_opt) == SOCKET_ERROR) {
		sprintf(buf,"ioctlsocket failed %d\n",WSAGetLastError());
		WriteLBtext(buf);
		WSACleanup();
    	EmergencyExit = 1;
		return -1;
	}



	return 1;
}
//--------------------------------------------------------------------------------------
int InitServerFTP_IP_socket (LPSTR SrvName)
{


	char *interface= NULL;
	unsigned short port=DEFAULT_PORT;
	int  ioctl_opt =1;
	char buf[128];


	//socket_type = SOCK_STREAM;//TCP
	socket_type = SOCK_DGRAM;//udp

	if (WSAStartup(0x202,&wsaData) == SOCKET_ERROR) {
		sprintf(buf,"WSAStartup failed with error %d\n",WSAGetLastError());
		WriteLBtext(buf);
		WSACleanup();
    	EmergencyExit = 1;
		return -1;
	}
	
	if (port == 0){
		WriteLBtext("Invalid port");
		WSACleanup();
    	EmergencyExit = 1;
		return -1;
	}

	local.sin_family = AF_INET;
	local.sin_addr.s_addr = (!interface)?INADDR_ANY:inet_addr(interface); 

	/* 
	 * Port MUST be in Network Byte Order
	 */
	local.sin_port = htons(port);

	listen_socket = socket(AF_INET, socket_type,0); // TCP socket
	
	if (listen_socket == INVALID_SOCKET){
		sprintf(buf,"socket() failed with error %d\n",WSAGetLastError());
		WriteLBtext(buf);
		WSACleanup();
    	EmergencyExit = 1;
		return -1;
	}

	//
	// bind() associates a local address and port combination with the
	// socket just created. This is most useful when the application is a 
	// server that has a well-known port that clients know about in advance.
	//
	if (bind(listen_socket,(struct sockaddr*)&local,sizeof(local) ) 
		== SOCKET_ERROR) {
		sprintf(stderr,"bind() failed with error %d\n",WSAGetLastError());
		WriteLBtext(buf);
		WSACleanup();
    	EmergencyExit = 1;
		return -1;
	}

	//
	// Set the socket to non-blocking mode.
	//
	if (ioctlsocket(listen_socket,FIONBIO,&ioctl_opt) == SOCKET_ERROR) {
		sprintf(stderr,"ioctlsocket failed %d\n",WSAGetLastError());
		WriteLBtext(buf);
		WSACleanup();
    	EmergencyExit = 1;
		return -1;
	}


	msgsock = listen_socket;
	return 1;
}
//--------------------------------------------------------------------------------------

int ReadUDPPacket (BOOL UseServerSocket )
{
	int	  fromlen,rc,ec,i;
	char dummybuf[2048];
	int  xi;

	TIMEVAL timeval ;

	timeval.tv_sec=0;
	timeval.tv_usec=0;	
	
	fromlen =sizeof(from);

	if (UseServerSocket == TRUE){
				rc = recvfrom(msgsock,&rottcom->data,sizeof (rottcom->data),0,
				(struct sockaddr *)&from,&fromlen);

   }else{
	   // Check to see if a packet is ready
	   //here from InitialSlaveSync and other
		rc = recv(conn_socket,&rottcom->data,2048,0 );

		if (rc == SOCKET_ERROR) {
			return -1;
		}else{

			rc=rc;

		}
   }

	return rc;
}
//--------------------------------------------------------------------------------------

int WriteUDPPacket (BOOL UseServerSocket )
{
   
	int	  retval,fromlen;
	TIMEVAL timeval ;

	timeval.tv_sec=0;
	timeval.tv_usec=0;

    fromlen = sizeof(from);

	if (UseServerSocket == TRUE){
	  			retval = sendto(msgsock,&rottcom->data,rottcom->datalength,0,
				(struct sockaddr *)&from,fromlen);
   }else{
   	    retval = send(conn_socket,&rottcom->data,rottcom->datalength,0 );
   		if (retval == SOCKET_ERROR) {
			return 0;
		}
   }

return 1;

}


