

/******************************************************************************
				UserActor.c 

 Copyright  2008, 2022 by Birger N. Andreasen
 Please send any bugreports, comments and other issues to:
 E-Mail = bna@bbsyd.dk
 Homepage with other ROTT stuff = http://www.riseofthetriad.dk/

 ******************************************************************************/

 

#include <sys/stat.h>
#include "version.h"
#include <string.h>
#include <stdlib.h>
#include <fcntl.h>
#include "rt_def.h"
#include "rt_stat.h"
#include "rt_util.h"
#include "rt_cfg.h"

void UA_ReadConfig (void);
boolean UA_ParseUserActorFile (void);
void MoveUserstarthitpoints(void);
int ReadBoolIniLine(char* szinLine, char* szinTxt);
int ReadIntIniLine(char* szinLine, char* szinTxt);
char* ReadStringIniLine(char* szinLine, char* szinTxt, char* RetStr);

void EnableExtraOptions(byte level);
void DisableExtraOptions(byte level);

/*
; stat_twopistol     = 25  
; stat_mp40          = 26  
; stat_bazooka       = 27  
; stat_firebomb      = 28  
; stat_heatseeker    = 29  
; stat_drunkmissile  = 30  
; stat_firewall      = 31  
; stat_splitmissile  = 32  
; stat_kes           = 33  

//=================== SHARED FLAGS =====================================//

#define FL_SHOOTABLE            0x01
#define FL_ACTIVE               0x02
#define FL_VISIBLE              0x08
#define FL_NOFRICTION           0x100 //
#define FL_DYING                0x1000
#define FL_ALTERNATE            0x20000
#define FL_GODSTRUCK            0x80000
#define FL_ABP                  0x400000
#define FL_BLOCK                0x800000
#define FL_HBM                  0x1000000
#define FL_RIDING               0x2000000
#define FL_SOLIDCOLOR           0x4000000
#define FL_SEEN                 0x8000000
#define FL_COLORED              0x10000000
#define FL_FULLLIGHT       0x80000000

//=================== ACTOR FLAGS =====================================//

#define FL_NEVERMARK            4
#define FL_ATTACKMODE           0x10
#define FL_FIRSTATTACK          0x20
#define FL_ISFIRE               0x20
#define FL_AMBUSH               0x40
#define FL_NONMARK              0x80
#define FL_DONE                 0x200 // used by push column
#define FL_DODGE                0x400 // "
#define FL_STUCK                0x800 //
#define FL_HASAUTO              0x2000
#define FL_FALLINGOBJECT        0x4000
#define FL_KEYACTOR             0x8000
#define FL_HEAD                 0x40000
#define FL_TARGET               0x200000
#define FL_FLIPPED              0x40000000
#define FL_CRAZY                0x40000000



*/

boolean useRespawnTMP;
boolean useSuperhardTMP;
boolean useExtMonkTMP;
boolean UseBaseMarkerTMP;
boolean useWindTMP;
boolean useRainTMP;
boolean useRndActorsTMP;
boolean ankhcoingivpointTMP;
boolean usebotsTMP;
boolean bCreateRandMapTMP;
int		iDeadbodyIsTargetTMP;
boolean useactorsinnetTMP;
boolean usejumpTMP;
int     ExtensiveGibsOnTMP;
boolean iKeepWeaponWhenKilledTMP;
boolean usemouselookTMP;


extern boolean usemouselook;
extern boolean useactorsinnet;
extern boolean bCreateRandMap;
extern int		iG_aimCross;
extern int		inverse_mouse;
extern boolean usebots;
extern boolean usejump;
extern boolean useRespawn;
extern boolean useSuperhard;
extern boolean useExtMonk;
extern boolean UseBaseMarker;
extern boolean useWind;
extern boolean useRain;
extern boolean useRndActors;

boolean ExtensiveGibsOn;
boolean iKeepWeaponWhenKilled;



extern boolean ankhcoingivpoint;
extern int iDeadbodyIsTarget;
extern int iNbRndActors;


typedef struct
{
	int				actorclass;//actortype
	unsigned        flags;
	signed short    dirchoosetime;//time to change direction
	signed short    hitpoints;//how tough is he to kill
	int             speed;     //his speed
    int				temp3;
    int				temp2;///nb of ammo

} actor_struct;

actor_struct ActorData[15];




void UA_MakeDefData()
{
	int i = 0;

	ActorData[i].actorclass		= 2;//lowgrd
	ActorData[i].flags			= 8388609;
	ActorData[i].dirchoosetime	= 0;//time to change direction
	ActorData[i].hitpoints		= 50;//how tough is he to kill
	ActorData[i].speed			= 3076;     //his speed
	ActorData[i].temp3			= 0;//stat_bazooka;
	ActorData[i].temp2			= 0;//3;///nb of ammo

	i++;
	ActorData[i].actorclass		= 3;//highguardobj
	ActorData[i].flags			= 8396865;
	ActorData[i].dirchoosetime	= 0;//time to change direction
	ActorData[i].hitpoints		= 65;//how tough is he to kill
	ActorData[i].speed			= 3072;     //his speed
	ActorData[i].temp3			= 0;//stat_bazooka;
	ActorData[i].temp2			= 0;//3;///nb of ammo

	i++;
	ActorData[i].actorclass		= 4;//overpatrolobj
	ActorData[i].flags			= 8388673;
	ActorData[i].dirchoosetime	= 0;//time to change direction
	ActorData[i].hitpoints		= 60;//how tough is he to kill
	ActorData[i].speed			= 3072;     //his speed
	ActorData[i].temp3			= 0;//stat_bazooka;
	ActorData[i].temp2			= 0;//3;///nb of ammo

	i++;
	ActorData[i].actorclass		= 5;//strikeguardobj
	ActorData[i].flags			= 8388609;
	ActorData[i].dirchoosetime	= 0;//time to change direction
	ActorData[i].hitpoints		= 60;//how tough is he to kill
	ActorData[i].speed			= 3072;     //his speed
	ActorData[i].temp3			= 0;//stat_bazooka;
	ActorData[i].temp2			= 0;//3;///nb of ammo

	i++;
	ActorData[i].actorclass		= 6;//blitzguardobj
	ActorData[i].flags			= 8388673;
	ActorData[i].dirchoosetime	= 0;//time to change direction
	ActorData[i].hitpoints		= 60;//how tough is he to kill
	ActorData[i].speed			= 3072;     //his speed
	ActorData[i].temp3			= 0;//stat_bazooka;
	ActorData[i].temp2			= 0;//3;///nb of ammo

	i++;
	ActorData[i].actorclass		= 7;//triadenforcerobj
	ActorData[i].flags			= 8396801;
	ActorData[i].dirchoosetime	= 0;//time to change direction
	ActorData[i].hitpoints		= 525;//how tough is he to kill
	ActorData[i].speed			= 3072;     //his speed
	ActorData[i].temp3			= 0;//stat_bazooka;
	ActorData[i].temp2			= 0;//3;///nb of ammo

	i++;
	ActorData[i].actorclass		= 8;//deathmonkobj
	ActorData[i].flags			= 8388673;
	ActorData[i].dirchoosetime	= 0;//time to change direction
	ActorData[i].hitpoints		= 275;//how tough is he to kill
	ActorData[i].speed			= 3072;     //his speed
	ActorData[i].temp3			= 0;//stat_bazooka;
	ActorData[i].temp2			= 70;//3;///nb of ammo

	i++;
	ActorData[i].actorclass		= 9;//dfiremonkobj
	ActorData[i].flags			= 8388673;
	ActorData[i].dirchoosetime	= 0;//time to change direction
	ActorData[i].hitpoints		= 300;//how tough is he to kill
	ActorData[i].speed			= 3072;     //his speed
	ActorData[i].temp3			= 0;//stat_bazooka;
	ActorData[i].temp2			= 70;//3;///nb of ammo

	i++;
	ActorData[i].actorclass		= 10;//roboguardobj
	ActorData[i].flags			= 8388609;
	ActorData[i].dirchoosetime	= 0;//time to change direction
	ActorData[i].hitpoints		= 150;//how tough is he to kill
	ActorData[i].speed			= 3072;     //his speed
	ActorData[i].temp3			= 0;//stat_bazooka;
	ActorData[i].temp2			= 0;//3;///nb of ammo

	i++;
	ActorData[i].actorclass		= 11;//b_darianobj
	ActorData[i].flags			= 8388609;
	ActorData[i].dirchoosetime	= 0;//time to change direction
	ActorData[i].hitpoints		= 2400;//how tough is he to kill
	ActorData[i].speed			= 3072;     //his speed
	ActorData[i].temp3			= 0;//stat_bazooka;
	ActorData[i].temp2			= 0;//3;///nb of ammo

	i++;
	ActorData[i].actorclass		= 12;//b_heinrichobj
	ActorData[i].flags			= 8388609;
	ActorData[i].dirchoosetime	= 0;//time to change direction
	ActorData[i].hitpoints		= 3600;//how tough is he to kill
	ActorData[i].speed			= 3072;     //his speed
	ActorData[i].temp3			= 0;//stat_bazooka;
	ActorData[i].temp2			= 0;//3;///nb of ammo

	i++;//not to be changed
	ActorData[i].actorclass		= 13;//b_robobossobj
	ActorData[i].flags			= 8388609;
	ActorData[i].dirchoosetime	= 0;//time to change direction
	ActorData[i].hitpoints		= 5000;//how tough is he to kill
	ActorData[i].speed			= 3072;     //his speed
	ActorData[i].temp3			= 0;//stat_bazooka;
	ActorData[i].temp2			= 0;//3;///nb of ammo

	i++;//
	ActorData[i].actorclass		= 14;//b_darkmonkobj
	ActorData[i].flags			= 8388609;
	ActorData[i].dirchoosetime	= 0;//time to change direction
	ActorData[i].hitpoints		= 4500;//how tough is he to kill
	ActorData[i].speed			= 3072;     //his speed
	ActorData[i].temp3			= 0;//stat_bazooka;
	ActorData[i].temp2			= 0;//3;///nb of ammo

	i++;//
	ActorData[i].actorclass		= 15;//b_darksnakeobj
	ActorData[i].flags			= 8388609;
	ActorData[i].dirchoosetime	= 0;//time to change direction
	ActorData[i].hitpoints		= 4500;//how tough is he to kill
	ActorData[i].speed			= 3072*4;     //his speed
	ActorData[i].temp3			= 0;//stat_bazooka;
	ActorData[i].temp2			= 0;//3;///nb of ammo


}


void UA_Write_Useractor_Rotfile ()
{
   int file,i;
 
   file = open( "UserActor.rot",O_RDWR|O_TEXT|O_CREAT|O_TRUNC,S_IREAD|S_IWRITE);

   if (file == -1)
      Error ("Error opening %s: %s","UserActor.rot",strerror(errno));

   // Write out header
   SafeWriteString (file, ";\n;Rise of the Triad UserActor File\n;\n\n");

   // Write out Version
   WriteParameter(file,"Version          ",ROTTVERSION);

   SafeWriteString (file, "\n\n ;Allowed weapons\n"  
      "; stat_twopistol     = 25  \n"\
      "; stat_mp40          = 26  \n"\
      "; stat_bazooka       = 27  \n"\
      "; stat_firebomb      = 28  \n"\
      "; stat_heatseeker    = 29  \n"\
      "; stat_drunkmissile  = 30  \n"\
      "; stat_firewall      = 31  \n"\
      "; stat_splitmissile  = 32  \n"\
      "; stat_kes           = 33  \n"\

	  "\n\n ;Allowed FLAGS\n"
      "; //=================== SHARED FLAGS =====================================//  \n"\

      "; #define FL_SHOOTABLE            0x01  \n"\
      "; #define FL_ACTIVE               0x02  \n"\
      "; #define FL_VISIBLE              0x08  \n"\
      "; #define FL_NOFRICTION           0x100   \n"\
      "; #define FL_DYING                0x1000  \n"\
      "; #define FL_ALTERNATE            0x20000  \n"\
      "; #define FL_GODSTRUCK            0x80000  \n"\
      "; #define FL_ABP                  0x400000  \n"\
      "; #define FL_BLOCK                0x800000  if a actor do not block, he's not shootable\n"\
      "; #define FL_HBM                  0x1000000  \n"\
      "; #define FL_RIDING               0x2000000  \n"\
      "; #define FL_SOLIDCOLOR           0x4000000  \n"\
      "; #define FL_SEEN                 0x8000000  \n"\
      "; #define FL_COLORED              0x10000000  \n"\
      "; #define FL_FULLLIGHT            0x80000000  \n"\
	  "\n"\
      "; //=================== ACTOR FLAGS =====================================//  \n"\
	  "\n"\
      "; #define FL_NEVERMARK            0x4  \n"\
      "; #define FL_ATTACKMODE           0x10  \n"\
      "; #define FL_FIRSTATTACK          0x20  \n"\
      "; #define FL_ISFIRE               0x20  \n"\
      "; #define FL_AMBUSH               0x40  \n"\
      "; #define FL_NONMARK              0x80  \n"\
      "; #define FL_DONE                 0x200 used by push column  \n"\
      "; #define FL_DODGE                0x400    \n"\
      "; #define FL_STUCK                0x800   \n"\
      "; #define FL_HASAUTO              0x2000  \n"\
      "; #define FL_FALLINGOBJECT        0x4000  \n"\
      "; #define FL_KEYACTOR             0x8000  \n"\
      "; #define FL_HEAD                 0x40000  \n"\
      "; #define FL_TARGET               0x200000  \n"\
      "; #define FL_FLIPPED              0x40000000  \n"\
      "; #define FL_CRAZY                0x40000000  \n\n"
	  "; \n"\
	  "; example: \n"\
	  "; flags                FL_SHOOTABLE FL_BLOCK (0x800000+0x01=0x800001->dec 8388609)\n"\
	  "; \n"\
	  "; Not all flags is useful to all actors\n"\
	  "; \n"\
      "; //=================== ACTOR CLASSES ===================================//  \n"\
	  "\n"\
      "; 2 = lowguardobj  \n"\
      "; 3 = highguardobj  \n"\
      "; 4 = overpatrolobj  \n"\
      "; 5 = strikeguardobj  \n"\
      "; 6 = blitzguardobj  \n"\
      "; 7 = triadenforcerobj  \n"\
      "; 8 = deathmonkobj  \n"\
      "; 9 = dfiremonkobj  \n"\
      "; 10 = roboguardobj  \n"\
      "; 11 = b_darianobj  \n"\
      "; 12 = b_heinrichobj  \n"\
      "; 13 = b_robobossobj  \n"\
      "; 14 = b_darkmonkobj  \n"\
      "; 15 = b_darksnakeobj  \n");

   SafeWriteString(file,"\n; ActorClasses");
   SafeWriteString(file,"\n");

   for (i=0;i<14;i++){
		SafeWriteString(file,"\n;------------------------");
		if (i==0){SafeWriteString(file," lowguardobj -----");}	
		if (i==1){SafeWriteString(file," highguardobj ----");}
		if (i==2){SafeWriteString(file," overpatrolobj ---");}	
		if (i==3){SafeWriteString(file," strikeguardobj --");}
		if (i==4){SafeWriteString(file," blitzguardobj ---");}	
		if (i==5){SafeWriteString(file," triadenforcerobj ");}
		if (i==6){SafeWriteString(file," deathmonkobj ----");}	
		if (i==7){SafeWriteString(file," dfiremonkobj ----");}
		if (i==8){SafeWriteString(file," roboguardobj ----");}	
		if (i==9){SafeWriteString(file," b_darianobj -----");}
		if (i==10){SafeWriteString(file," b_heinrichobj --");}	
		if (i==11){SafeWriteString(file," b_robobossobj --");}
		if (i==12){SafeWriteString(file," b_darkmonkobj --");}	
		if (i==13){SafeWriteString(file," b_darksnakeobj -");}
		SafeWriteString(file,"----------------------------\n");

		SafeWriteString(file,"\n; actorclass number\n");
		WriteParameter(file,"actorclass         ",ActorData[i].actorclass);

		SafeWriteString(file,"\n; actor flags\n");
		WriteParameter(file,"flags              ",ActorData[i].flags);

		SafeWriteString(file,"\n; actor dirchoosetime\n");
		WriteParameter(file,"dirchoosetime      ",ActorData[i].dirchoosetime);

		SafeWriteString(file,"\n; actor hitpoints\n");
		WriteParameter(file,"hitpoints          ",ActorData[i].hitpoints);

		SafeWriteString(file,"\n; actor speed\n");
		WriteParameter(file,"speed              ",ActorData[i].speed);

		SafeWriteString(file,"\n; actor temp3, used for various purposes");
		SafeWriteString(file,"\n; such as weapontype\n");
		WriteParameter(file,"temp3              ",ActorData[i].temp3);

		SafeWriteString(file,"\n; actor temp2, used for various purposes");
		SafeWriteString(file,"\n; such as ammo count\n");
		WriteParameter(file,"temp2              ",ActorData[i].temp2);

	}
   SafeWriteString(file,"\n\n\n");

   close (file);


}
//----------------------------------------------------------------------
void UA_ReadConfig (void)
{

   UA_MakeDefData();
   if (access("UserActor.rot",F_OK)==0)
   {
      if (UA_ParseUserActorFile() == false)
      {
         int aws = unlink ("UserActor.rot");          // Delete UserActor.rot
		 UA_Write_Useractor_Rotfile ();	
      }
   }else{
		  UA_Write_Useractor_Rotfile();
		  if (UA_ParseUserActorFile() == false)
		  {
			 int aws = unlink ("UserActor.rot");          // Delete UserActor.rot
			 UA_Write_Useractor_Rotfile();
		  }
   }

   MoveUserstarthitpoints();

}
//----------------------------------------------------------------------
boolean UA_ParseUserActorFile (void)
{
	FILE	*instream;
	char	line[1024]; 
	char	linebuf[10240];
	char	*ptr;
	int		i=0;


	if( (instream  = fopen( "UserActor.rot", "rt" )) == NULL ) {
		return false;//no UserActor.rot file
	}
		
	do { //read header in
			fgets( line, 1023, instream );
			if (ReadIntIniLine(line, "ActorClasses") != -1002){
				i = ReadIntIniLine(line, "ActorClasses");
			}
			if (feof(instream)){
				fclose(instream);
				return false;
			}
	}while (strstr (line, ";----")==0);

	while (!feof(instream)) {
		strcpy(linebuf,"");
		do {//read all data for 1 actor in buffer
			fgets( line, 1023, instream );
			if (line[0] != ';'){
				strcat(linebuf,line);
			}
		}while ((strstr(line,";----")==0)&&(!feof(instream)));

		if (ReadIntIniLine(linebuf, "actorclass") != -1002){
			ActorData[i].actorclass = ReadIntIniLine(linebuf, "actorclass");
		}	
		if (ReadIntIniLine(linebuf, "flags") != -1002){
			ptr = strstr(linebuf,"FL_");
			if (ptr == 0){
				//it must be a int or hex
				ActorData[i].flags = ReadIntIniLine(linebuf, "flags");
			}else{
				int val = 0;
				ptr = strstr(linebuf,"FL_SHOOTABLE");
				if (ptr != 0) {val |= FL_SHOOTABLE;}
				ptr = strstr(linebuf,"FL_ACTIVE");
				if (ptr != 0) {val |= FL_ACTIVE;}
				ptr = strstr(linebuf,"FL_VISIBLE");
				if (ptr != 0) {val |= FL_VISIBLE;}
				ptr = strstr(linebuf,"FL_NOFRICTION");
				if (ptr != 0) {val |= FL_NOFRICTION;}
				ptr = strstr(linebuf,"FL_DYING");
				if (ptr != 0) {val |= FL_DYING;}
				ptr = strstr(linebuf,"FL_ALTERNATE");
				if (ptr != 0) {val |= FL_ALTERNATE;}
				ptr = strstr(linebuf,"FL_GODSTRUCK");
				if (ptr != 0) {val |= FL_GODSTRUCK;}
				ptr = strstr(linebuf,"FL_ABP");
				if (ptr != 0) {val |= FL_ABP;}
				ptr = strstr(linebuf,"FL_BLOCK");
				if (ptr != 0) {val |= FL_BLOCK;}
				ptr = strstr(linebuf,"FL_HBM");
				if (ptr != 0) {val |= FL_HBM;}
				ptr = strstr(linebuf,"FL_RIDING");
				if (ptr != 0) {val |= FL_RIDING;}
				ptr = strstr(linebuf,"FL_SOLIDCOLOR");
				if (ptr != 0) {val |= FL_SOLIDCOLOR;}
 				ptr = strstr(linebuf,"FL_SEEN");
				if (ptr != 0) {val |= FL_SEEN;}
				ptr = strstr(linebuf,"FL_COLORED");
				if (ptr != 0) {val |= FL_COLORED;}
				ptr = strstr(linebuf,"FL_FULLLIGHT");
				if (ptr != 0) {val |= FL_FULLLIGHT;}


				ptr = strstr(linebuf,"FL_NEVERMARK");
				if (ptr != 0) {val |= FL_NEVERMARK;}
 				ptr = strstr(linebuf,"FL_ATTACKMODE");
				if (ptr != 0) {val |= FL_ATTACKMODE;}
				ptr = strstr(linebuf,"FL_FIRSTATTACK");
				if (ptr != 0) {val |= FL_FIRSTATTACK;}
				ptr = strstr(linebuf,"FL_ISFIRE");
				if (ptr != 0) {val |= FL_ISFIRE;}
				ptr = strstr(linebuf,"FL_AMBUSH");
				if (ptr != 0) {val |= FL_AMBUSH;}
 				ptr = strstr(linebuf,"FL_NONMARK");
				if (ptr != 0) {val |= FL_NONMARK;}
				ptr = strstr(linebuf,"FL_DONE");
				if (ptr != 0) {val |= FL_DONE;}
				ptr = strstr(linebuf,"FL_DODGE");
				if (ptr != 0) {val |= FL_DODGE;}
				ptr = strstr(linebuf,"FL_STUCK");
				if (ptr != 0) {val |= FL_STUCK;}
 				ptr = strstr(linebuf,"FL_HASAUTO");
				if (ptr != 0) {val |= FL_HASAUTO;}
				ptr = strstr(linebuf,"FL_FALLINGOBJECT");
				if (ptr != 0) {val |= FL_FALLINGOBJECT;}
				ptr = strstr(linebuf,"FL_KEYACTOR");
				if (ptr != 0) {val |= FL_KEYACTOR;}
				ptr = strstr(linebuf,"FL_HEAD");
				if (ptr != 0) {val |= FL_HEAD;}
 				ptr = strstr(linebuf,"FL_TARGET");
				if (ptr != 0) {val |= FL_TARGET;}
				ptr = strstr(linebuf,"FL_FLIPPED");
				if (ptr != 0) {val |= FL_FLIPPED;}
				ptr = strstr(linebuf,"FL_CRAZY");
				if (ptr != 0) {val |= FL_CRAZY;}

				ActorData[i].flags = val;
			}
		}
		if (ReadIntIniLine(linebuf, "dirchoosetime") != -1002){
			ActorData[i].dirchoosetime = ReadIntIniLine(linebuf, "dirchoosetime");
		}

		if (ReadIntIniLine(linebuf, "hitpoints") != -1002){
			ActorData[i].hitpoints = ReadIntIniLine(linebuf, "hitpoints");
		}
		if (ReadIntIniLine(linebuf, "speed") != -1002){
			ActorData[i].speed = ReadIntIniLine(linebuf, "speed");
		}
		if (ReadIntIniLine(linebuf, "temp3") != -1002){
			ActorData[i].temp3 = ReadIntIniLine(linebuf, "temp3");
		}
		if (ReadIntIniLine(linebuf, "temp2") != -1002){
			ActorData[i].temp2 = ReadIntIniLine(linebuf, "temp2");
		}
		i++;
	}

	fclose(instream);

	return true;
}






//----------------------------------------------------------------------
//read bool value in line
int ReadBoolIniLine(char* szinLine, char* szinTxt)
{
	char *lptr;

	//return 2 if txt not found
	//return 1 if txt found and true
	//return 0 if txt found and false
	lptr = strstr (szinLine, szinTxt);
	if (lptr != 0) {
		lptr = strstr (lptr, "TRUE");//find start of data
		if (lptr != 0) {
			return 1;
		}
		return 0;
	}
	else {
		return 2;
	}
 
}
//----------------------------------------------------------------------
//read int value in line
int ReadIntIniLine(char* szinLine, char* szinTxt)
{
	char *lptr;int val;char *stopstring;

	//return -1002 if txt not found
	//return else value 
	lptr = strstr (szinLine,szinTxt);
	if (lptr != 0) {
    		lptr++;
			while ((lptr[0] != 32)&&(lptr[0] != 9)&&(lptr[0] != '-')) {lptr++;}//skip spaces
			//this is a dec,hex or octal value
			val = strtoul(lptr, &stopstring, 0 );
			return val;
			//return  (atoi (lptr));
	}
	return -1002;
}
//----------------------------------------------------------------------
//read String value in line
char* ReadStringIniLine(char* szinLine, char* szinTxt, char* RetStr)
{
	char *lptr;
//	char RetStr[1024] = "";
	int i;

	strcpy(RetStr,"");

	//return  if txt not found
	//return else string 
	lptr = strstr (szinLine, szinTxt);
	if (lptr != 0) {
			lptr+=4;
			while (lptr[0] <= 32) {lptr++;}//skip spaces
			i = 0;
			while ((lptr[0] != 0) && (lptr[0] != 10) && (lptr[0] != 13 )) {
				if (lptr[0] != '\"'){
					RetStr[i] = lptr[0];
					i++;
				}
				lptr++;
			}
			RetStr[i] = 0;
	}
	return RetStr;
}



void EnableExtraOptions(byte level)
{
	UseBaseMarker = UseBaseMarkerTMP;
	useWind = useWindTMP;
	useRain = useRainTMP;
	ankhcoingivpoint = ankhcoingivpointTMP;
	useactorsinnet = useactorsinnetTMP;
	usejump = usejumpTMP;
	ExtensiveGibsOn = ExtensiveGibsOnTMP;
	iKeepWeaponWhenKilled = iKeepWeaponWhenKilledTMP;
	useRndActors = useRndActorsTMP;
	useRespawn = useRespawnTMP;
	useSuperhard = useSuperhardTMP;
	useExtMonk = useExtMonkTMP;
	iDeadbodyIsTarget = iDeadbodyIsTargetTMP;
	usebotsTMP = usebots;
	bCreateRandMap = bCreateRandMapTMP;
	usemouselook = usemouselookTMP;

	if (level == 1)
		usebots = usebotsTMP;
}


void DisableExtraOptions(byte level)
{
	//make sure these isnt used in demo game ect. bna++ 1.78

	UseBaseMarkerTMP = UseBaseMarker;
	useWindTMP = useWind;
	useRainTMP = useRain;
	ankhcoingivpointTMP = ankhcoingivpoint;
	useactorsinnetTMP = useactorsinnet;
	usejumpTMP = usejump;
	ExtensiveGibsOnTMP = ExtensiveGibsOn;
	iKeepWeaponWhenKilledTMP = iKeepWeaponWhenKilled;
	useRndActorsTMP = useRndActors;
	useRespawnTMP = useRespawn;
	useSuperhardTMP = useSuperhard;
	useExtMonkTMP = useExtMonk;
	iDeadbodyIsTargetTMP = iDeadbodyIsTarget;
	usebotsTMP = usebots;
	bCreateRandMapTMP = bCreateRandMap;
	usemouselookTMP = usemouselook;


	usemouselook = 0;
	useWind = 0;
	useRain = 0;
	useactorsinnet = 0;
	usejump = 0;
	ExtensiveGibsOn = 0;
	UseBaseMarker = 0;
	ankhcoingivpoint = 0;
	useRndActors = 0;
	useRespawn = 0;
	useSuperhard = 0;
	useExtMonk = 0;
	iDeadbodyIsTarget = 0;
	bCreateRandMap = 0;
	iKeepWeaponWhenKilled = 0;

	if (level == 1)
		usebots = 0;

}











