 
/******************************************************************************
 winmenu.c 

 Copyright  2008, 2022 by Birger N. Andreasen 
 Please send any bugreports, comments and other issues to:
 E-Mail = bna@bbsyd.dk
 Homepage with other ROTT stuff = http://www.riseofthetriad.dk/

 ******************************************************************************/





#include <windowsx.h>
#include <windows.h>
#include <commctrl.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <io.h>
#include <stdio.h>

#include "rt_def.h"
#include "rt_ted.h"
#include "..\H_files\resource.h"


//we create our own colors, windows sometimes gets the colors wrong
#include "ExternColordefs.h"

//extern SWASETTINGS swasettings;

// constants used for drawing
#define CX_ICON			16
#define CY_ICON			16
#define CXGAP			1	// num pixels between button and text
#define CXTEXTMARGIN	2	// num pixels after hilite to start text
#define CXBUTTONMARGIN	2	// num pixels wider button is than bitmap
#define CYBUTTONMARGIN	2	// ditto for height 


void MN_AdjustMenu(HWND hwnd, HMENU hMenu) ;
BOOL MN_MsgMeasureItem (LPARAM lParam);
BOOL MN_MsgDrawItem (LPARAM lParam, HWND hparent);
BOOL MN_CreateMenuImagelist();


int MsgWM_DRAWITEM(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
int MsgWM_MEASUREITEM(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);

//gets data from the toolbar section
int GetButtonNbForResourceNb(int res);
extern HMENU LVpopupmenu;
extern HMENU TVpopupmenu;
extern HINSTANCE	hInst;
extern HWND hMainWnd;
//global imagelist for use in the menu
HIMAGELIST menu_himl = 0;
HIMAGELIST hImageList = 0;
extern HMENU hPopMenu;

HFONT hfontMenu;


int txtcnt;//used to count which item we are currently measuring
BOOL bIsOnMenu;

void MN_AdjustMenu(HWND hwnd, HMENU hMenu) 
{ 
    HMENU hmenuMain;    // handle to main menu          
    HMENU hSubMenu;
	UINT  iState;
	MENUINFO lpcmi;  // menu information
	int i,ii,menuId,nItem,nSubItem;
	TCHAR achTemp[128]="xxx";

	hfontMenu = CreateFont(14, 0, 0, 0, FW_NORMAL, 0, 0, 0, 0, 0, 0, 0,  DEFAULT_PITCH  , "MS Sans Serif");
	txtcnt = 0;
	//go ower all the menuitems and make them ownerdrawn
    hmenuMain = GetMenu(hwnd); /*
			menuId = GetMenuItemID(hmenuMain, 0);//get the ID and store it
			iState = GetMenuState(hmenuMain,0,MF_BYPOSITION);
			ModifyMenu(
					hmenuMain,           // handle to menu
					0,				// menu item to modify
					MF_OWNERDRAW|MF_BYPOSITION,		// options
					menuId,				// identifier
					(LPSTR)MF_OWNERDRAW // menu item content
					);
				 DrawMenuBar(
   hmenuMain  // handle to window
);
 GetMenuItemRect(
  hwnd,       // handle to window
  hmenuMain,     // handle to menu
  0,      // menu item position
  &rc  // bounding rectangle
);



			menuId = GetMenuItemID(hmenuMain, 1);//get the ID and store it
			iState = GetMenuState(hmenuMain,1,MF_BYPOSITION);
			ModifyMenu(hmenuMain,1,MF_OWNERDRAW|MF_BYPOSITION,menuId,(LPSTR)MF_OWNERDRAW );
			menuId = GetMenuItemID(hmenuMain, 2);//get the ID and store it
			iState = GetMenuState(hmenuMain,2,MF_BYPOSITION);
			ModifyMenu(
					hmenuMain,           // handle to menu
					2,				// menu item to modify
					MF_OWNERDRAW|MF_BYPOSITION,		// options
					menuId,				// identifier
					(LPSTR)MF_OWNERDRAW // menu item content
					);
 

*/



	nItem = GetMenuItemCount(hmenuMain);


	for (i = 0; i < nItem; i++) {	// loop over each main items in menu
		//first make the main popup menu ownerdrawn
		menuId = GetMenuItemID(hmenuMain, nItem);//get the ID and store it
		ModifyMenu(hmenuMain,i,MF_OWNERDRAW|MF_BYPOSITION,menuId,(LPSTR)MF_OWNERDRAW );
		//goto all the submenus

		hSubMenu = GetSubMenu(hmenuMain, i);//get the handle of submenus
		nSubItem = GetMenuItemCount(hSubMenu);//get the number of subitems
		for (ii = 0; ii < nSubItem; ii++) {	// loop over each main items in menu
			menuId = GetMenuItemID(hSubMenu, ii);//get the ID and store it
			iState = GetMenuState(hSubMenu,ii,MF_BYPOSITION);
			ModifyMenu(
					hSubMenu,           // handle to menu
					ii,				// menu item to modify
					MF_OWNERDRAW|MF_BYPOSITION|iState,		// options
					menuId,				// identifier
					(LPSTR)MF_OWNERDRAW // menu item content
					);
		}
	}
	//sets the backcolor in mainmenu
	ZeroMemory(&lpcmi,sizeof(lpcmi));
	GetMenuInfo(hmenuMain,&lpcmi);
	lpcmi.cbSize = sizeof(MENUINFO);
	lpcmi.fMask = MIM_BACKGROUND;
	lpcmi.hbrBack = (HBRUSH)MENUBACKG;
	SetMenuInfo(hmenuMain,&lpcmi);

	//create menu imagelist
	//MN_CreateMenuImagelist();
    return; 
}


BOOL MN_MsgMeasureItem (LPARAM lParam)
{    
	TCHAR achTemp[128]="xxx";
	TCHAR achTemp1[128]="xxx";
	LPMEASUREITEMSTRUCT lpmis; 
	HMENU hmenu;
	//HFONT pOldFont;
	HDC hdc;
	RECT rcText;
	int cx;
	int ButtonWidth;

	hmenu = GetMenu(hMainWnd);
    lpmis = (LPMEASUREITEMSTRUCT) lParam; 



	
/*
	if (lpmis->itemID == -1){
		//lpmis->itemID = txtcnt;
		hmenu = GetMenu(hMainWnd); 
		GetMenuString(hmenu,txtcnt,achTemp,sizeof(achTemp),MF_BYPOSITION);
		
		if (txtcnt == 0){lpmis->itemWidth = 25;}
		if (txtcnt == 1){lpmis->itemWidth = 22;}
		if (txtcnt == 2){lpmis->itemWidth = 52;}
		if (txtcnt == 3){lpmis->itemWidth = 40;}
		if (txtcnt == 4){lpmis->itemWidth = 54;}
		if (txtcnt == 5){lpmis->itemWidth = 32;}
		if (txtcnt++ > 6){//nb of menuitems
			txtcnt = 0;
		}
		//return TRUE;
	}
*/

	if (lpmis->itemID == 0) {
		// separator: use half system height and zero width
		lpmis->itemHeight = (GetSystemMetrics(SM_CYMENU)>>2);
	} else {
		// compute size of text: use DrawText with DT_CALCRECT
	    hdc = GetDC(NULL);	// screen DC, no drawn on it
		memset(&rcText,0,sizeof(RECT));
		//rcText.bottom = 0;
		//rcText.left = 0;
		//rcText.right = 0;
		//rcText.top = 0;
		//make a normal font type first
	   // pOldFont = CreateFont(16, 0, 0, 0, FW_NORMAL, 0, 0, 0, 0, 0, 0, 0,  DEFAULT_PITCH  , "");
		//pOldFont = SelectObject(hdc,pOldFont);
		SelectObject(hdc,hfontMenu);
		
	/*	hmenu = GetMenu(hMainWnd); 
	
		//special case for lv right popup menu
		if ((lpmis->itemID == IDM_MNU_VALG_ALLE)||(lpmis->itemID == IDM_MNU_FRAVALG_ALLE)){
			hmenu = LVpopupmenu;
		}
		//special case for lv right popup menu
		if ((lpmis->itemID == ID_TVRIGHT_AKTIVER)||(lpmis->itemID == ID_TVRIGHT_DEAKTIVER)||(lpmis->itemID == ID_TVRIGHT_START_JOB_NOW)){
			hmenu = TVpopupmenu;
		}
*/
	if (lpmis->itemID == -1){

		//This is a topmenu text
		GetMenuString(hmenu,txtcnt++,achTemp,sizeof(achTemp),MF_BYPOSITION);
		ButtonWidth = 14;
	}else{
		//deteckt if this is a popup menu
		GetMenuString(hmenu,lpmis->itemID,achTemp,sizeof(achTemp),MF_BYCOMMAND);
		if (achTemp[0]==0)
			hmenu = hPopMenu;

		//this must be a submenu
		GetMenuString(hmenu,lpmis->itemID,achTemp,sizeof(achTemp),MF_BYCOMMAND);
		ButtonWidth = 18 + CX_ICON;
	}
	//	SelectObject(hdc,pOldFont);
		// compute size of text: use DrawText with DT_CALCRECT
		DrawText(hdc,achTemp,lstrlen(achTemp), &rcText, DT_LEFT|DT_SINGLELINE|DT_VCENTER |DT_CALCRECT);


		// height of item is just height of a standard menu item
		lpmis->itemHeight = max(GetSystemMetrics(SM_CYMENU), (rcText.bottom-rcText.top));
		lpmis->itemHeight += 2;

		// width is width of text plus other things
		cx = rcText.right - rcText.left ;	// text width 
		cx += CXTEXTMARGIN;		// L/R margin for readability
		cx += CXGAP;			// space between button and menu text
		cx += ButtonWidth;//		// button width (L=button; R=empty margin)

		// whatever value I return in lpms->itemWidth, Windows will add the
		// width of a menu checkmark
		cx -= GetSystemMetrics(SM_CXMENUCHECK)-1;
		lpmis->itemWidth = cx;		// done deal
	//	DeleteObject(pOldFont);
		DeleteDC(hdc);

	}


	//adjust for right popup menu
    switch (lpmis->itemID)
    {
	//	case IDM_HANDLING_DOWNLOAD:
	//	case IDM_HANDLING_UPLOAD:
	//	case ID_LVLOCAL_SENDTILUDBOX:
	//		 lpmis->itemWidth += 175;
	//		 break;
/*		case MNU_GENDAN:
		case MNU_SF_GENDAN:
		case MNU_SYNKRONISER:
		case MNU_DELETE:
		case MNU_DELALL:
		case MNU_RENAME_DIR:
		case MNU_NEW_DIR:
		case MNU_SELECT_ALL:
		case 1002:
		case MNU_PROPERTIES:
			lpmis->itemWidth += 105;*/
	}


	//lpmis->itemWidth += 6;
	return TRUE; 
}


BOOL MN_MsgDrawItem (LPARAM lParam, HWND hparent)
{
	TCHAR achTemp[128]="yyy";
	TCHAR achTemp1[128]="yyy";
    LPDRAWITEMSTRUCT lpdis; 
    COLORREF clrBackground;//,clrForeground; COLORREF crColor
    TEXTMETRIC tm; 
    HDC hdc; 
    int x,y,iIcon=0; 
	HMENU hmenuMain;
	RECT rc,rcx;
	HICON hIcon; 
	POINT ptScreen;
	//char buf[128];
	int r=3;
     HPEN hNewPen;
	 HBRUSH hOldBrush;
	 HPEN hOldPen;

	lpdis = (LPDRAWITEMSTRUCT) lParam; 
	//its not a menu item, return LIGHTGRAY
	if  (!(lpdis->CtlType & ODT_MENU))
		return FALSE;




	//get the main menu handle
    hmenuMain = GetMenu(hMainWnd);

	//deteckt if this is a popup menu
	GetMenuString(hmenuMain,lpdis->itemID,achTemp1,sizeof(achTemp1),MF_BYCOMMAND);
	//lstrcpy(achTemp1, "KLkl");
	if (achTemp1[0]==0)
		hmenuMain = hPopMenu;


	hNewPen = CreatePen(PS_SOLID, 1, crDARKBLUE);
	hOldBrush = (HBRUSH)SelectObject (lpdis->hDC,(HBRUSH) LIGHTBLUE1);
	if (hNewPen)
		hOldPen = (HPEN)SelectObject(lpdis->hDC, hNewPen);


/*SetWindowText(hparent,"z");
sprintf(buf,"%d %d",testw ,testw   );
SendMessage(hWndStatus, SB_SETTEXT, 0, (LPARAM)buf);	}
*/
	bIsOnMenu = FALSE;
	SelectObject(lpdis->hDC,hfontMenu);
	if (lpdis->itemID == -1){// empty item, must be a popup topmenu
		bIsOnMenu = TRUE; 
		//move the menu a little to the right
		lpdis->rcItem.left += 1;
		lpdis->rcItem.right  += 1;
		//here we handle all the topmenu drawing
		ptScreen.x = lpdis->rcItem.left + 1;
		ptScreen.y = lpdis->rcItem.top  + 1;
		// Get the client area of the parent window.
		//to adjust in case window gets minimized
		GetWindowRect(hparent, &rcx);
		ptScreen.x += rcx.left;
		ptScreen.y += rcx.top;

		//find the item which is about to be drawn
		x = MenuItemFromPoint(hparent,(HMENU)lpdis->hwndItem,ptScreen);
		//get the state of this item
		y = GetMenuState((HMENU)lpdis->hwndItem,x,MF_BYPOSITION);
		//is it hotligted (selected)
		if(lpdis->itemState & ODS_HOTLIGHT)   {//320 257
			//is item highligted?
			clrBackground = SetBkColor(lpdis->hDC,crLIGHTBLUE1); 
			FillRect(lpdis->hDC, &lpdis->rcItem,  (HBRUSH) (LIGHTBLUE1));
			rc = lpdis->rcItem;
			rc.top  += 1;
		//	FrameRect(lpdis->hDC, &rc,  (HBRUSH) (DARKBLUE));

 		RoundRect(lpdis->hDC,rc.left,rc.top,rc.right,rc.bottom,4,4 );




		}else{//no so fill standard colors
			FillRect(lpdis->hDC, &lpdis->rcItem,  (HBRUSH) (MENUBACKG));
			clrBackground = SetBkColor(lpdis->hDC,crMENUBACKG); 
			if(lpdis->itemState & ODS_SELECTED)   {
				//did we go to submenu
				clrBackground = SetBkColor(lpdis->hDC,crLIGHTBLUE1); 
				rc = lpdis->rcItem; 
				rc.top  += 1;
				//rc.bottom += 1;
				FillRect(lpdis->hDC, &lpdis->rcItem,  (HBRUSH) (LIGHTBLUE1));
			//	FrameRect(lpdis->hDC, &rc,  (HBRUSH)GetStockObject(2));

 	RoundRect(lpdis->hDC,rc.left,rc.top,rc.right,rc.bottom,4,4 );

			}
		}
		//get the main popups strings and draw the text
		GetMenuString((HMENU)lpdis->hwndItem,x,achTemp,sizeof(achTemp),MF_BYPOSITION);
		lpdis->rcItem.left += 7;//move text 7 pix to the left

		DrawText(lpdis->hDC,achTemp,lstrlen(achTemp),&lpdis->rcItem ,DT_LEFT|DT_SINGLELINE|DT_VCENTER );
		//topmenu handled return
		return TRUE;
	}

	//make all the submenu items
	//get the text according the item
	GetMenuString(hmenuMain,lpdis->itemID,achTemp,sizeof(achTemp),MF_BYCOMMAND);
	//find the button number for resource ID
	iIcon = GetButtonNbForResourceNb(lpdis->itemID);
if (lpdis->itemState & ODS_CHECKED)
	iIcon = 18;

/*
	//special case for lv right popup menu
    switch (lpdis->itemID)
    {
		case IDM_HANDLING_DOWNLOAD://IDM_HANDLING_DOWNLOAD
			 lstrcpy(achTemp,"&Hent filer fra backup server");
			 break;
		case IDM_HANDLING_UPLOAD://IDM_HANDLING_DOWNLOAD
			 lstrcpy(achTemp,"&Send filer til backup server");
			 break;
		case IDM_SYNKRONISER:
			 lstrcpy(achTemp,"S&ynkroniser Job med lokal PC sti");
			 break;
		case MNU_DELALL:
//		case ID_LVLOCAL_SENDTILUDBOX://IDM_HANDLING_DOWNLOAD
//			 lstrcpy(achTemp,"&Send filer til backup server");
//			 break;
		case MNU_NEW_DIR:
		case IDM_POPUP_HANDLING_DOWNLOAD://IDM_HANDLING_DOWNLOAD
		case MNU_GENDAN:
		case MNU_SF_GENDAN:
		case MNU_DELETE:
		case MNU_RENAME_DIR:
		case MNU_SELECT_ALL:
	//	case 1002:
		case MNU_PROPERTIES:
			GetMenuString(LVpopupmenu,lpdis->itemID,achTemp,sizeof(achTemp),MF_BYCOMMAND);
	}
/*
	if (lpdis->itemID == IDM_REFRESH){
		GetMenuString(LVpopupmenu,lpdis->itemID,achTemp,sizeof(achTemp),MF_BYCOMMAND);
		//iIcon = 39;
	}
	if (lpdis->itemID == IDM_MNU_FRAVALG_ALLE){
		GetMenuString(LVpopupmenu,lpdis->itemID,achTemp,sizeof(achTemp),MF_BYCOMMAND);
		iIcon = 38;
	}

	if (lpdis->itemID == ID_TVRIGHT_AKTIVER){
		GetMenuString(TVpopupmenu,lpdis->itemID,achTemp,sizeof(achTemp),MF_BYCOMMAND);
		iIcon = 47;
	}
	if (lpdis->itemID == ID_TVRIGHT_DEAKTIVER){
		GetMenuString(TVpopupmenu,lpdis->itemID,achTemp,sizeof(achTemp),MF_BYCOMMAND);
		iIcon = 46;
	}
	if (lpdis->itemID == ID_TVRIGHT_START_JOB_NOW){
		GetMenuString(TVpopupmenu,lpdis->itemID,achTemp,sizeof(achTemp),MF_BYCOMMAND);
		iIcon = 37;
	}
	if (lpdis->itemID == ID_TVRIGHT_OMD){
		GetMenuString(TVpopupmenu,lpdis->itemID,achTemp,sizeof(achTemp),MF_BYCOMMAND);
		iIcon = 28;
	}
	*/
	
	//extract that icon from the imagelist created from toolbar
	//hIcon = ImageList_ExtractIcon(NULL,menu_himl,iIcon);	
	hIcon = ImageList_GetIcon(menu_himl,iIcon,ILD_TRANSPARENT);	

	if(lpdis->itemState & ODS_DISABLED){
		clrBackground = crSUBMENUBACKG;//GetSysColor( COLOR_WINDOW);
	}else{
		clrBackground = SetBkColor(lpdis->hDC,(lpdis->itemState & ODS_SELECTED ? 
                crLIGHTBLUE1 : crSUBMENUBACKG));
	}

	//clear the background
	FloodFill(lpdis->hDC,lpdis->rcItem.left-1,lpdis->rcItem.top-1 ,clrBackground);
    // Calculate the vertical and horizontal position. 
    GetTextMetrics(lpdis->hDC, &tm); 
    y = (lpdis->rcItem.bottom + lpdis->rcItem.top - tm.tmHeight) / 2; 
    x = (LOWORD(GetDialogBaseUnits()) / 4)- 2; 
 
	//copy our rect and move text and seperator 22 pixels to the right
	rc = lpdis->rcItem;

	rc.left += 22;
	if (lpdis->itemID == 0) {
		// draw separator
			FillRect(lpdis->hDC, &lpdis->rcItem,  (HBRUSH) (MENUBACKG));
			FillRect(lpdis->hDC, &rc,  (HBRUSH) (SUBMENUBACKG));
		rc.top += (rc.bottom - rc.top )>>1;			// vertical center
		rc.left += 4;
		DrawEdge(lpdis->hDC,&rc, EDGE_ETCHED, BF_TOP);// draw separator line
		return TRUE;
	}

	//if no sep then clear the whole area with background color
	FillRect(lpdis->hDC, &lpdis->rcItem,  (HBRUSH) (MENUBACKG));

	//make the small gray square in start of menu
	//rcx = lpdis->rcItem;
	//rcx.left -= 4;
	//rcx.top -= 4;
	//rcx.right = rcx.left + 20;
	//FillRect(lpdis->hDC, &rcx,  (HBRUSH) (COLOR_WINDOW+11 ));

	if ((lpdis->itemState & ODS_SELECTED)&&(!(lpdis->itemState & ODS_DISABLED)))  { //if selected
		//SetTextColor(lpdis->hDC, RGB(255,255,255));//make textcolr white 
		//FillRect(lpdis->hDC, &lpdis->rcItem,  (HBRUSH) (COLOR_HIGHLIGHTTEXT));
	//	FillRect(lpdis->hDC, &lpdis->rcItem,  (HBRUSH) (LIGHTBLUE1));
	//	FrameRect(lpdis->hDC, &lpdis->rcItem,  (HBRUSH)GetStockObject((2)));

 	RoundRect(lpdis->hDC,lpdis->rcItem.left,lpdis->rcItem.top,lpdis->rcItem.right,lpdis->rcItem.bottom,4,4 );


	}else{//else textcolor black
		FillRect(lpdis->hDC, &rc,  (HBRUSH) (SUBMENUBACKG));
	}

	rc.left += 5;//move text 5 pixels to the right

	//draw the text 
	if (lpdis->itemState & ODS_DISABLED) {
		//the text must be grayed
		DrawState(lpdis->hDC,           // handle to device context
					(HBRUSH)NULL,       // handle to brush
					NULL,				// callback function
					(LPARAM)&achTemp,   // image information
					(WPARAM)NULL,       // more image information
					rc.left ,           // horizontal location
					rc.top+3 ,			// vertical location
					rc.right-rc.left ,  // image width
					rc.bottom-rc.top ,  // image height
					DST_PREFIXTEXT|DSS_DISABLED);// image type and state
	}else{
		//draw normal text
		
		DrawText(lpdis->hDC,achTemp,lstrlen(achTemp),&rc,DT_LEFT|DT_SINGLELINE|DT_VCENTER );
	}
	// Restore the previous colors. 
    //SetTextColor(lpdis->hDC, clrForeground); 
   // SetBkColor(lpdis->hDC, clrBackground); 
 
    // Now we draw the icon. 
    hdc = CreateCompatibleDC(lpdis->hDC); 
    if (hdc == NULL) 
        return FALSE; 
 
    SelectObject(hdc, hIcon); 

	if (lpdis->itemState & ODS_DISABLED) {
			DrawState(lpdis->hDC,           // handle to device context
					(HBRUSH)NULL,           // handle to brush
					NULL,					// callback function
					(LPARAM)hIcon,           // image information
					(WPARAM)NULL,                   // more image information
					x+2,                    // horizontal location
					lpdis->rcItem.top+2,    // vertical location
					CX_ICON,                     // image width
					CY_ICON,                     // image height
					DST_ICON|DSS_DISABLED   // image type and state
					);
	}else{
		//raise icon 1 pixel if highlighted
		if(lpdis->itemState & ODS_SELECTED)   
			r=2;
		DrawIconEx(lpdis->hDC,          // handle to device context
				x+r,                // x-coord of upper left corner
				lpdis->rcItem.top+r+1,// y-coord of upper left corner
				hIcon,              // handle to icon
				CX_ICON,                 // icon width
				CY_ICON,                 // icon height
				(UINT)NULL,         // frame index, animated icons
				NULL,// handle to background brush
				DI_NORMAL          // icon-drawing flags
				);
	}
	rc = lpdis->rcItem;
	rc.right = rc.left + 18;
	//done with the dc, delete it
    DeleteDC(hdc); 
 
/*
    // If the item has the focus, draw focus rectangle. 
	if ((lpdis->itemState & ODS_SELECTED)&&(!lpdis->itemState & ODS_DISABLED)) {
		rc = lpdis->rcItem;
		rc.right  = rc.left + 20;
         // DrawFocusRect(lpdis->hDC, &lpdis->rcItem); 
		DrawEdge(lpdis->hDC,&rc,EDGE_ETCHED,BF_FLAT);
	}
 */

	DestroyIcon(hIcon);
    
	return TRUE; 

}

/*
BOOL MN_CreateMenuImagelist()
{   
	HBITMAP hbmImage;
	COLORREF crMask;

	//add all icons from toolbar
	crMask = RGB(192,  // red component of color
				 192,  // green component of color
				 192); // blue component of color

	menu_himl = ImageList_Create (CX_ICON, CY_ICON,ILC_MASK|ILC_COLOR16 , 1, 0);
	hbmImage = LoadBitmap(hInst, MAKEINTRESOURCE(IDB_TOOLBAR));
	ImageList_AddMasked( menu_himl,  hbmImage,   crMask   );
	//ImageList_Add( menu_himl,  hbmImage,   NULL   );
	DeleteObject(hbmImage);

	return TRUE;
}
*/

/********************************************************************/
/*																	*/
/* Function name :													*/
/* Description   :													*/
/*																	*/
/********************************************************************/
int GetButtonNbForResourceNb(int res)
{
 
	//special cases
	switch (res)     
	{   
		case IDM_RUNROTT:
			return 28;
		case IDM_PARAMETER_EDIT:
			return 12;
		case IDM_ABOUT:
			return 50;
		case ID_HELP_ROTTHELP:
			return 17;
		case IDM_FULLSCREEN:
			return 19;
		case IDM_EXIT:
			return 21;
		case ID_SETTINGS_GRAPHICSSETTINGSWINDOW:
			return 11;
		case ID_SETTINGS_SOUNDSETTINGSWINDOW:
			return 10;
		case ID_SETTINGS_GENERALSETTINGS:
			return 9;
		case ID_SETTINGS_ROTTMENUSETTINGS:
			return 8;
		case IDM_GRABMOUSE:
			return 19;
		case ID_SETTINGS_STOREPARAMETERS:
			return 19;
		case ID_SETTINGS_RUNERRORCORRECTIONONMAPS:
			return 19;
		case ID_SETTINGS_SCANSUBDIRSFORRTC:
			return 19;
		case ID_SETTINGS_SHOWINFOWINDOWDURINGSTART:
			return 19;
		case IDM_ORGROTTHELP:
			return 30;
			
	}
	return -1;
}


int MsgWM_DRAWITEM(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	{
		LPDRAWITEMSTRUCT lpdis;     // pointer for item drawing

		if (lParam == 0)
			return 0;
		lpdis = (LPDRAWITEMSTRUCT)lParam;  // for convenience       
		if (lpdis->CtlType == ODT_LISTBOX) {
			//if (lpdis->CtlID == ID_LISTVIEW_SERVERRESP) {
				//SR_MsgDrawItem (lParam,hWnd);//draw server resp listview
			//}
		}
		else if (lpdis->CtlType == ODT_MENU) {
			MN_MsgDrawItem(lParam, hWnd);//draw menu	
		}
		else if (lpdis->CtlType == ODT_BUTTON) {
			//TB_MsgDrawItem (lParam,hWnd);//draw buttons	

		}
	}
	return TRUE;//say we handle the drawing
}

int MsgWM_MEASUREITEM(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	{
		LPMEASUREITEMSTRUCT lpmis;     // pointer for item measurement
		lpmis = (LPMEASUREITEMSTRUCT)lParam;  // for convenience      
		if (lpmis->CtlType == ODT_LISTBOX) {
			//if (lpmis->CtlID == ID_LISTVIEW_SERVERRESP) {
			//	SR_MsgMeasureItem (hWnd,lParam);
			//}
		}
		else if (lpmis->CtlType == ODT_MENU) {
			MN_MsgMeasureItem(lParam);
		}
	}
	return 0;
}


BOOL CreateMenuImagelist()
{
	HBITMAP hbmImage;
	COLORREF crMask;

	//add all icons from toolbar
	crMask = RGB(255,  // red component of color
		0,  // green component of color
		255); // blue component of color

	menu_himl = ImageList_Create(CX_ICON, CY_ICON, ILC_MASK | ILC_COLOR16, 1, 0);
	hbmImage = LoadBitmap(hInst, MAKEINTRESOURCE(IDB_BITMAP8));
	ImageList_AddMasked(menu_himl, hbmImage, crMask);
	//ImageList_Add( menu_himl,  hbmImage,   NULL   );
	DeleteObject(hbmImage);

	return TRUE;
}