
/******************************************************************************
 winrott.c

 Copyright  2004, 2008, 2022 by Birger N. Andreasen
 Please send any bugreports, comments and other issues to:
 E-Mail = bna@bbsyd.dk
 Homepage with other ROTT stuff = http://www.riseofthetriad.dk/

 ******************************************************************************/
 


//----------------------------------------------------------------------
// Windows Includes...
//----------------------------------------------------------------------

#include <windows.h>
#include "WinRott.h"
#include <stdio.h> 
#include <stdlib.h>
#include <io.h>
#include <fcntl.h>
#include <time.h>
//#include <dsound.h> 
//#include "dxerr.h"
//#include "dxerr.c"
#include "resource.h"  // Required for Win32 Resources
#include "develop.h"
#include <windowsx.h>

#include "DPwinrott.h"
#include "..\DirectInput\DMInput.h"
#include "..\DirectDraw\DirectDraw.h"
//#include <dinput.h>
#include <WinUser.h>
#include <shlwapi.h> 

#pragma warning (disable : 4996)//disable The POSIX name for this item is deprecated


#define MAIN_ROTTKEY_STRING    (TEXT("Software\\WinRottGL\\Settings"))
#define VALUE_STRING_SETTINGS    (TEXT("Settings"))

//----------------------------------------------------------------------
// Midi defines 
//----------------------------------------------------------------------

typedef enum { 
		midi_nofile, 
		midi_stop, 
		midi_play, 
		midi_pause 
} midi_state; 

typedef struct {
    DWORD    MidiPosition;
    DWORD    MidiDevice; 
    DWORD    MidiStatus;
    MCIERROR MidiError;
    char     szMidiFile[MAX_PATH];
}MIDI_Data_t;

BOOL  MidiPlay(HWND hWnd, MIDI_Data_t *mdd);
BOOL  MidiReplay(HWND hWnd, MIDI_Data_t *mdd);
BOOL  MidiPause(HWND hWnd, MIDI_Data_t *mdd);
BOOL  MidiResume(HWND hWnd, MIDI_Data_t *mdd);
void  MidiStop(MIDI_Data_t *mdd);
int IsROTTMidiPlaying();
BOOL MidiPlayMEM(HWND hWnd, MIDI_Data_t *mdd);


MIDI_Data_t MidiData;
MIDI_Data_t StoreMidiData;
MIDI_Data_t G_MidiData;
//----------------------------------------------------------------------
// Windows #defines
//----------------------------------------------------------------------


//----------------------------------------------------------------------
// Windows prototypes
//----------------------------------------------------------------------
extern int mainrott (int argc, char *argv[]);
extern BOOL            InitInput(void);
extern int compat;
extern int gltexmode;	
extern int glsharpentex;
extern int iUseSimpleSound;

extern 	BOOL AddToInfoWindow(LPSTR InfoTxt, int color) ;
extern 	BOOL InitInfoWndInstance(HINSTANCE hInstance, int nCmdShow);
extern byte* HEAP_getheapmem(int size);
extern BOOL  HEAP_freemem(LPVOID lpMem);
extern int MsgWM_DRAWITEM(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
extern int MsgWM_MEASUREITEM(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
extern void MN_AdjustMenu(HWND hwnd, HMENU hMenu);
extern BOOL CreateMenuImagelist();
extern void CL_CreateGlobalColors();
extern LRESULT CALLBACK HelpboxProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);

//int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, PSTR szCmdLine, int iCmdShow);
void    GetWindowsVersion(void);
//extern void WriteDebug (char *error, int i,...);
void	WriteLBtext(LPSTR txt);
void	ReadDelay(long delay);
int		PlayROTTMidiFile(char *songname, boolean loop,unsigned char *song, int size);
//int		StopMidiMusic();
LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK About(HWND , UINT , WPARAM , LPARAM );
void	SetRottScreenRes (int Width, int Height);
BOOL	PlayResource(LPSTR lpName) ;
void    ConvertRottParameters(LPSTR WinParameters);
void    CreateAllChildWindows (HWND hwnd);
LRESULT CALLBACK RottHelpProc(HWND, UINT, WPARAM, LPARAM);
void    WriteWinRottHelp (HWND hDlg);
void	FindROTTdemofiles();
int     MIDI_StoreSongPosition();
void    MIDI_RestoreSongPosition(int storedposition);
void    DisEnableRottButtons(BOOL bDisEnable);
byte* LoadTagExt (byte ** src, char *tag, int sizeofmem);

BOOL FindValidPathFilename  (char *filename);
void    CheckForRestartMIDI();
int GetSetMenuItem( int id, char *str, char *defval);


extern LPDPLAYINFO G_lpDPInfo;
extern HRESULT DPSend_data( );
extern int DPRecv_data();
extern void ErrorDontQuit (char *error, int i,...);
extern void  SetTextMode ( void );
extern HRESULT CUDialog(HINSTANCE hInstance, LPDPLAYINFO lpDPInfo);
extern 	LRESULT CALLBACK SSoundDrvWndProc(HWND hWnd, UINT msg,WPARAM wParam, LPARAM lParam);
extern 	LRESULT CALLBACK SMP3WndProc(HWND hWnd, UINT msg,WPARAM wParam, LPARAM lParam);
extern BOOL InitDirectSound();
extern BOOL InitDirectMusic(); 
extern int GetStrFromRegdb (LPSTR Keyval, LPSTR strval, LPSTR defaultval) ;
extern BOOL SetStrInRegdb  (LPSTR Keyval, LPSTR strval, LPSTR defaultval)  ;
extern int GetTicCount();
extern void*SafeMalloc(long size);
extern int GameRNG (char *string, int val);
extern LRESULT CALLBACK GfxSettingsWndProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);
extern LRESULT CALLBACK SfxSettingsWndProc(HWND hWnd, UINT msg,WPARAM wParam, LPARAM lParam);
extern LRESULT CALLBACK GenSettingsWndProc(HWND hWnd, UINT msg,WPARAM wParam, LPARAM lParam);
extern LRESULT CALLBACK RottSettingsWndProc(HWND hWnd, UINT msg,WPARAM wParam, LPARAM lParam);
void    disableRottButtons();
void    enableRottButtons();
extern void Z_Init(int size, int min);
extern long LoadResourceToFixedMem(LPSTR Type, int sndnb, void** bufferptr);
 
 
extern int InitClientFTP_IP_socket (LPSTR SrvName, int portnb );
extern int InitServerFTP_IP_socket (LPSTR SrvName, int portnb );

// globals


//DWORD WINAPI	ReceiveThread(LPVOID lpThreadParameter);
HRESULT	SetupConnection(HINSTANCE hInstance, LPDPLAYINFO lpDPInfo);
HRESULT ShutdownConnection(LPDPLAYINFO lpDPInfo);
void ErrorBox(LPSTR lpszErrorStr, HRESULT hr);
int SetupDPConn();
void ExitWinRott();


extern int HEAP_startheap();
extern HRESULT ConnectUsingLobby(LPDPLAYINFO lpDPInfo);
extern HRESULT	ConnectUsingDialog(HINSTANCE hInstance, LPDPLAYINFO lpDPInfo);

void    MoveScreenUpLeft(unsigned char *b);
void    MoveScreenUpRight(unsigned char *b);
void    MoveScreenDownLeft(unsigned char *b);
void    MoveScreenDownRight(unsigned char *b);

byte        *tmpPICbuf;//used to strech and schrink mem pictures
byte        *PICbuf;//main buf

BOOL  bBlurGraphics = FALSE;


BOOL  bAbovemaskwall = 0;
BOOL  bAbovewall = 0;
BOOL  bDoors = 0;
BOOL  bElevators = 0;
BOOL  bExits = 0;
BOOL  bFloor_Ceilings = 0;
BOOL  bGuns = 0;
BOOL  bHswicthes = 0;
BOOL  bMasked = 0;
BOOL  bMish = 0;
BOOL  bShapes = 0;
BOOL  bSides = 0;
BOOL  bWalls = 0;

BOOL  bAbovemaskwall2 = 1;
BOOL  bAbovewall2 = 1;
BOOL  bDoors2 = 0;
BOOL  bElevators2 = 0;
BOOL  bExits2 = 1;
BOOL  bFloor_Ceilings2 = 1;
BOOL  bGuns2 = 0;
BOOL  bHswicthes2 = 1;
BOOL  bMasked2 = 0;
BOOL  bMish2 = 0;
BOOL  bShapes2 = 0;
BOOL  bSides2 = 1;
BOOL  bWalls2 = 1;


extern char ApogeePath[256];
extern int	MusicMode;
int  iGLOBAL_SCREENWIDTH;// bna default value 800
int  iGLOBAL_SCREENHEIGHT;//bna default value 600
extern int  iGLOBAL_SCREENBWIDE ;
extern int  iG_SCREENWIDTH;// default screen width in bytes
extern int  viewheight;
extern int  viewwidth;
extern unsigned bufferofs;
extern unsigned displayofs;
//extern double dYZANGLELIMIT;
double dTopYZANGLELIMIT;
//extern int  NetErrorFlag;
 int musfix;
 int iUseOrgThunder = 1;
 int iUseWaterSnd = 0;
 int iPulsPushwalls = 0;
 boolean iDeadbodyIsTarget = 1;
 boolean iKeepWeaponWhenKilled = 0;



HINSTANCE	hInst;
HWND		hMainWnd;
HWND		hwndButtonExit;
HWND		hwndButtonRunRott;
HWND		hwndStatic;
//HWND		hwndRes320;
//HWND		hwndRes640;
//HWND		hwndRes800;
//HWND		hwndRes1024;
HWND		hwndResNet;
HWND		hwndStatic1;
HWND		hwndParaEdit;

HWND		hwndBG;

HWND		hwndCB1;
HWND		hwndCB2;
HWND		hwndCB3;

HACCEL		ghAccel;
HWND		hWndList;
DWORD		dwCurrWidth, dwCurrHeight;
char		szAppName[] = "WinRottGL";
char		szDbgName[] = "WinRottGL.dbg";
char		szParameter[256];

int			argc;
char		*argv[40] ;
//int			L=0;
char		aDemoNames[10][40];
int 		iDemoNames;
int 		iCurrentDemoNames;

int			iG_aimCross = 0;
int			iG_X_center;
int			iG_Y_center;




int         NbOfROTTMidiFilePlayed;
//extern  int iG_lastsongnumber;
//extern  int Oldsongnumber;
//int         bLoopSongFlag = 0;
//ULONG		MaxSoundPages;
char SelRTCfile[MAX_PATH]="";
char SelRTLfile[MAX_PATH]="";
int RunFullscreen=TRUE;
int iGrabMouse=TRUE;
int iShowInfoWnd=TRUE;

int iMapErrCorr=1;
int iUseMp3Music = 0;
int iUseSurroundEffect = 1;
int iUseDB50XGfix = 0; 

char Mp3Path[256]="";

int LastScreenRes = 3;
BOOL bStoreParameters=0;
BOOL bScanSubdirs=0;
BOOL bUseExtPrecache=0;

long MidiSongLen = 0;
extern long lMAXMEMORYSIZE = 90000000;
//char Remote2PComputerName[MAX_PATH];
//int  bUseDirectUDP = 1;//0 no udp ; 1= client(join) ;2= server
/* defined in winrott.c
#define MAX_WIDTH_RES 1024
#define MAX_HEIGHT_RES 768
*/
int  MidiTimeMScount=0;
int  BNA_RandVal=0;
int  DS_NoSound=1;
int  DS_NoMusic=1;
int  DS_Surroundeffect=0;
BOOL  bAdaptiveTiming = TRUE;
int  iFloorScale = 2;
BOOL  bUseExtWallSFX = 0;
BOOL  bUseExtSFX = 0;
int  WinRottGlVersion = GLVERSION;//version 1.44
BOOL  bUseOldSkys = 1;
BOOL  bIntPolOldSkys = 1;



extern 	byte *RainSnd1buf;
unsigned int dwAvailPhysRamOnMachine = 0;

 	byte * WALLptr[76];//max 75 walls
 	byte * WALLhiresptr[76];//max 75 hires walls

WINUSERAPI BOOL WINAPI LockSetForegroundWindow(UINT uLockCode);

#define LSFW_LOCK       1
#define LSFW_UNLOCK     2

#define AUTHORS WriteLBtext("Programmed by Birger N. Andreasen & Jared Stafford");


extern double g_explo_alpha;//bna++148
extern double g_organ_alpha;//bna++148
extern double g_firej_alpha;//bna++148
extern double g_lifei_alpha;//bna++148
extern double g_bullet_alpha;//bna++148

extern unsigned char cUseSavegameErrCorr;
extern unsigned char cUseSavegameGLpic;
extern unsigned char cUseSavegameOldpic;
extern unsigned char cUseSavegameSoften;
extern char g_packsystem;

#define false FALSE
#include <string.h>
#include <stdio.h>


#define access _access_s


HMENU hPopMenu = 0;
HMENU hMenu = 0;


//----------------------------------------------------------------------
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, PSTR szCmdLine, int iCmdShow)
{
    MSG         msg;
    WNDCLASSEX  wc;
    HWND        hwnd;
    FILE        *stream;
    HACCEL      hAccel;
	char		tmp[255]="23,24,25,26,27";
	int			iResult = 0;
//	BOOL		res;


    hInst = hInstance;
	NbOfROTTMidiFilePlayed = 0;

	GetCurrentDirectory(sizeof(ApogeePath),ApogeePath);// curent directory name

//	res = LockSetForegroundWindow(LSFW_LOCK);//jb disable or enable calls
	Z_Init (50000, 1000000);

	//check version nb 1.44 current
	GetStrFromRegdb ((LPSTR)"WinRottGlVersion",(LPSTR)&tmp,(LPSTR)"0");
		if (atol(tmp) < GLVERSION){  
			int res = MessageBox(NULL, "An older or no version of WinRottGL was found on this computer!!.        \n\nShould all settings in RegDB and all '.rot. files be deleted?.            \nNew one's will be created if the answer is 'Yes'.\n", "WinRottGL", MB_YESNO|MB_ICONQUESTION);
			if (res	== IDYES){
				long hSearch=0;
				//struct _finddata_t FileData;
				SHDeleteKey(HKEY_CURRENT_USER,MAIN_ROTTKEY_STRING);
				GetStrFromRegdb ((LPSTR)"TexMode",(LPSTR)&tmp,"2");	
				sprintf_s(tmp, sizeof(tmp), "%d",GLVERSION);
				SetStrInRegdb ("WinRottGlVersion",tmp,"0");			
				SetStrInRegdb ("TexMode","2","0");
				SetStrInRegdb ("Res","2","2"); 
				SetStrInRegdb ("Compat","2","0");
				SetStrInRegdb ("glsharpentex","1","0");

				SetStrInRegdb ("g_fReverbMix","-10","-10"); 
				SetStrInRegdb ("g_fReverbTime","1000","1000");
				SetStrInRegdb ("g_fHighFreqRTRatio","0.001","0.001");

				
				//_findclose((intptr_t)hSearch);
				// Start searching for .rot files in the current directory.
				DeleteFile("UserActor.rot");
				DeleteFile("bots.rot");
				DeleteFile("sound.rot");
				DeleteFile("scores.rot");
				DeleteFile("config.rot");
				DeleteFile("battle.rot");
				/*
				hSearch = _findfirst("*.rot", &FileData); 
				if ((intptr_t)hSearch != -1) {
					DeleteFile(FileData.name);
					while (!_findnext((intptr_t)hSearch, &FileData)) { 
						DeleteFile(FileData.name);
					} 
				}
				if (hSearch != -1)
					_findclose(hSearch);
					*/
			}
		}


#if (USERAINCODE==1)
	//InitRain();
#endif
//	iResult = LoadWavResource (IDR_VOC12, &RainSnd1buf);
//InitDirectSound();
//DS_PlayVocSound(RainSnd1buf,iResult,0,0,0);
	lstrcpy (szParameter,szCmdLine);//store for later use

	SetRottScreenRes (800, 600);//default values
	//SetRottScreenRes (1024, 768);//default values

	iG_X_center = iGLOBAL_SCREENWIDTH / 2;
	iG_Y_center = iGLOBAL_SCREENHEIGHT / 2 ;

    fopen_s(&stream,szDbgName, "w");
    fclose(stream);

    // current video setup data
    dwCurrWidth = GetSystemMetrics(SM_CXSCREEN);
    dwCurrHeight = GetSystemMetrics(SM_CYSCREEN);

  // Fill in window class structure with parameters that describe the main window.
    wc.cbSize        = sizeof(WNDCLASSEX);
    wc.style         = CS_HREDRAW | CS_VREDRAW; // Class style(s).
    wc.lpfnWndProc   = (WNDPROC)WndProc;        // Window Procedure
    wc.cbClsExtra    = 0;                       // No per-class extra data.
    wc.cbWndExtra    = 0;                       // No per-window extra data.
    wc.hInstance     = hInstance;               // Owner of this class
    wc.hIcon         = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_ICON1)); // Icon name from .RC
    wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = (HBRUSH)(COLOR_3DFACE + 1); // Default color
    wc.lpszMenuName  = (LPCSTR)IDC_WINROTTMENU;
    wc.lpszClassName = szAppName;               // Name to register as
	wc.hIconSm       = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_ICON1));

    // Register the window class and return FALSE if unsuccesful.
    if (!RegisterClassEx(&wc))
    {
        //Assume we are running on NT where RegisterClassEx() is
        //not implemented, so let's try calling RegisterClass().
        if (!RegisterClass((LPWNDCLASS)&wc.style))
        	return FALSE;
    }


   
    // Create a main window for this application instance.
    hwnd = CreateWindow(szAppName,           // See RegisterClass() call
                        "WinRottGL",  // Text for window title bar
                        WS_OVERLAPPED|WS_CAPTION|WS_SYSMENU, // Window styleWS_OVERLAPPEDWINDOW
                        CW_USEDEFAULT, CW_USEDEFAULT,	 // x, y
                        685, 540,	 // cx, cy
                        NULL,                // Overlapped has no parent
                        NULL,                // Use the window class menu
                        hInstance,           // This instance owns this window
                        NULL                 // Don't need data in WM_CREATE
    );
    hMainWnd = hwnd;


#if (SHAREWARE == 0)
		SetWindowText(hMainWnd,GLVERSION_F);
#else
		SetWindowText(hMainWnd,GLVERSION_S);
#endif
	
	SetWindowText(hwndParaEdit,szCmdLine);	
 
	CreateAllChildWindows (hwnd);

	CL_CreateGlobalColors();
	CreateMenuImagelist();

	MN_AdjustMenu(hwnd, hMenu);

   ShowWindow(hwnd, iCmdShow);// Show the window
    UpdateWindow(hwnd);        // Sends WM_PAINT message





	SetFocus(hwndButtonRunRott);

	if (HEAP_startheap() == 0){
		WriteLBtext("Error, HEAP_startheap failed, aborting game");
		EnableWindow(hwndButtonRunRott,FALSE);
		goto Errexit;
	}


//	if (hWndList == NULL)
//		return NULL;

//	PlayResource("soundName");

    // Make the window visible & update its client area


//----GET OS VERSION
	// This is used to determine what OS we're on (Windows9X or Windows NT)
    GetWindowsVersion();

/* if you want to use SDL mouse then 
set USESDLMOUSE to 1 in "DMInput.h"
if you want to use DirectInput mouse set it to 0
*/
#ifdef USESDLMOUSE 
	// use sdl mouse do nothing
#else
	// start direct mouse input
	//if (InitMouseInput()==FALSE){
		//ErrorBox("DirectInput mouse failed", 0);
	//}
	//ReacquireMouse();
#endif
 

//----CHECK wad	VERSION and if all 3 rott files exists
#if (SHAREWARE)
	lstrcpy(tmp,"Starting ");
	lstrcat(tmp,GLVERSION_S);
	WriteLBtext(tmp);

	AUTHORS
	//if (access ("huntbgin.wad", 0) != 0) {
	lstrcpy(tmp,"huntbgin.wad");
	if (FindValidPathFilename(tmp)==FALSE){
		WriteLBtext("Error, Could not find HUNTBGIN.WAD, aborting game");
		WriteLBtext("Please reinstall ROTT Shareware ");
		EnableWindow(hwndButtonRunRott,FALSE);
		goto Errexit;
	}else{
		WriteLBtext("Found HUNTBGIN.WAD");
		//if (access ("huntbgin.rtl", 0) != 0) {
		lstrcpy(tmp,"huntbgin.rtl");
		if (FindValidPathFilename(tmp)==FALSE){
			WriteLBtext("Error, Could not find HUNTBGIN.RTL, aborting game");
			WriteLBtext("Please reinstall ROTT Shareware ");
			EnableWindow(hwndButtonRunRott,FALSE);
			goto Errexit;
		}else{
			WriteLBtext("Found HUNTBGIN.RTL");
			//if (access ("huntbgin.rtc", 0) != 0) {
			lstrcpy(tmp,"huntbgin.rtc");
			if (FindValidPathFilename(tmp)==FALSE){
				WriteLBtext("Error, Could not find HUNTBGIN.RTC, aborting game");
				WriteLBtext("Please reinstall ROTT Shareware ");
				EnableWindow(hwndButtonRunRott,FALSE);
				goto Errexit;
			}else{
				WriteLBtext("Found HUNTBGIN.RTC");
			}
		}
	}
#else
	lstrcpy(tmp,"Starting ");
	lstrcat(tmp,GLVERSION_F); 
	WriteLBtext(tmp);
	AUTHORS
	//if (access ("darkwar.wad", 0) != 0) {
	lstrcpy(tmp,"darkwar.wad");
	if (FindValidPathFilename(tmp)==FALSE){
		WriteLBtext("Error, Could not find DARKWAR.WAD, aborting game");
		WriteLBtext("Please reinstall ROTT fullgame");
		EnableWindow(hwndButtonRunRott,FALSE);
		goto Errexit;
	}else{
		WriteLBtext("Found DARKWAR.WAD");
		//if (access ("darkwar.rtl", 0) != 0) {
		lstrcpy(tmp,"darkwar.rtl");
		if (FindValidPathFilename(tmp)==FALSE){
			WriteLBtext("Error, Could not find DARKWAR.RTL, aborting game");
			WriteLBtext("Please reinstall ROTT fullgame");
			EnableWindow(hwndButtonRunRott,FALSE);
			goto Errexit;
		}else{
			WriteLBtext("Found DARKWAR.RTL");
			//if (access ("darkwar.rtc", 0) != 0) {
			lstrcpy(tmp,"darkwar.rtc");
			if (FindValidPathFilename(tmp)==FALSE){
				WriteLBtext("Error, Could not find DARKWAR.RTC, aborting game");
				WriteLBtext("Please reinstall ROTT fullgame");
				EnableWindow(hwndButtonRunRott,FALSE);
				goto Errexit;
			}else{
				WriteLBtext("Found DARKWAR.RTC");
			}
		}
	}
#endif

	extern LPBYTE hgtmpmem;
	unsigned char* loadbuffer = 0;
	DWORD bwritten;

	strcpy_s(tmp, sizeof(tmp), ApogeePath);
	strcat_s(tmp, sizeof(tmp), "\\GL");
	CreateDirectory(tmp, NULL);

	sprintf_s(tmp,sizeof(tmp),"%s\\GL\\colors.ifo",ApogeePath);
	if (access (tmp, 0) != 0){
			//---Try to create a new color.ifo---------------------------------------------
			int size = LoadResourceToFixedMem("TXT", IDR_COLOR_IFO, (void**)&loadbuffer);
			HANDLE file = CreateFile(tmp, GENERIC_WRITE, FILE_SHARE_READ,
				NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
			if (file != NULL)
				WriteFile(file, loadbuffer, size, &bwritten, NULL);
			CloseHandle(file);
			loadbuffer = (unsigned char *)HEAP_freemem(hgtmpmem);//release mem;
			if (access(tmp, 0) != 0) {
				//------------------------------------------------
				WriteLBtext("Error, could not find ..\\GL\\COLORS.IFO, aborting game");
				EnableWindow(hwndButtonRunRott, FALSE);
				goto Errexit;
			}else {
				WriteLBtext("COLORS.IFO not found, created a new ..\\GL\\COLORS.IFO.");
			}
	}else{
		sprintf_s(tmp, sizeof(tmp), "Found %s\\GL\\colors.ifo",ApogeePath);
	    WriteLBtext(tmp);
	}

	sprintf_s(tmp, sizeof(tmp), "%s\\GL\\model.ifo",ApogeePath);
	if (access (tmp, 0) != 0){
		//---Try to create a new color.ifo---------------------------------------------
		int size = LoadResourceToFixedMem("TXT", IDR_MODEL_IFO, (void**)&loadbuffer);
		HANDLE file = CreateFile(tmp, GENERIC_WRITE, FILE_SHARE_READ,
			NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
		if (file != NULL)
			WriteFile(file, loadbuffer, size, &bwritten, NULL);
		CloseHandle(file);
		loadbuffer = (unsigned char*)HEAP_freemem(hgtmpmem);//release mem;
		if (access(tmp, 0) != 0) {
			//------------------------------------------------
			WriteLBtext("Error, could not find ..\\GL\\MODELS.IFO, aborting game");
			EnableWindow(hwndButtonRunRott, FALSE);
			goto Errexit;
		}
		else {
			WriteLBtext("MODELS.IFO not found, created a new ..\\GL\\MODELS.IFO.");
		}
	}else{
		sprintf_s(tmp, sizeof(tmp), "Found %s\\GL\\model.ifo",ApogeePath);
	    WriteLBtext(tmp);
	}

	sprintf_s(tmp, sizeof(tmp), "%s\\GL\\trans.ifo",ApogeePath);
	if (access (tmp, 0) != 0){
		//---Try to create a new color.ifo---------------------------------------------
		int size = LoadResourceToFixedMem("TXT", IDR_TRANS_IFO, (void**)&loadbuffer);
		HANDLE file = CreateFile(tmp, GENERIC_WRITE, FILE_SHARE_READ,
			NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
		if (file != NULL)
			WriteFile(file, loadbuffer, size, &bwritten, NULL);
		CloseHandle(file);
		loadbuffer = (unsigned char*)HEAP_freemem(hgtmpmem);//release mem;
		if (access(tmp, 0) != 0) {
			//------------------------------------------------
			WriteLBtext("Error, could not find ..\\GL\\TRANS.IFO, aborting game");
			EnableWindow(hwndButtonRunRott, FALSE);
			goto Errexit;
		}
		else {
			WriteLBtext("TRANS.IFO not found, created a new ..\\GL\\TRANS.IFO.");
		}
	}else{
		sprintf_s(tmp, sizeof(tmp), "Found %s\\GL\\trans.ifo",ApogeePath);
	    WriteLBtext(tmp);
	}

	 
	sprintf_s(tmp, sizeof(tmp), "%s\\GL\\crosshair.ifo", ApogeePath);
	if (access(tmp, 0) != 0) {
		//---Try to create a new color.ifo---------------------------------------------
		int size = LoadResourceToFixedMem("TXT", IDR_CROSSHAIR_IFO, (void**)&loadbuffer);
		HANDLE file = CreateFile(tmp, GENERIC_WRITE, FILE_SHARE_READ,
			NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
		if (file != NULL)
			WriteFile(file, loadbuffer, size, &bwritten, NULL);
		CloseHandle(file);
		loadbuffer = (unsigned char*)HEAP_freemem(hgtmpmem);//release mem;
		if (access(tmp, 0) != 0) {
			//------------------------------------------------
			WriteLBtext("Error, could not find ..\\GL\\CROSSHAIR.IFO, aborting game");
			EnableWindow(hwndButtonRunRott, FALSE);
			goto Errexit;
		} 
		else {
			WriteLBtext("CROSSHAIR.IFO not found, created a new ..\\GL\\CROSSHAIR.IFO.");
		}
	}
	else {
		sprintf_s(tmp, sizeof(tmp), "Found %s\\GL\\crosshair.ifo", ApogeePath);
		WriteLBtext(tmp);
	}



	if (szCmdLine[0] != 0){//only print if theres any parameters 
		lstrcpy (tmp,"Program command line parameters = ");
		lstrcat (tmp,szCmdLine);	 
		WriteLBtext(tmp);
	}

/*
#if (USEDIRECTSOUND == 1)
//	WriteLBtext("DirectSound conversion by Birger N. Andreasen");
	WriteLBtext("Starting DirectSound");
	if (InitDirectSound()==FALSE){
		WriteLBtext("DirectSound Setup Failed");
		DS_NoSound = 0;
	}
#endif	
	
#if (USEDIRECTMUSIC == 1)	
	WriteLBtext("Starting DirectMusic");
	if (InitDirectMusic()==FALSE){
		WriteLBtext("DirectMusic Setup Failed");
		DS_NoMusic = 0;
	}
		//	PlayROTTMidiFile("tmpsong.mid",0);//bna++
#endif

//	WriteLBtext("DirectSound conversion by Birger N. Andreasen");
	WriteLBtext("Starting DirectSound");
	if (InitDirectSound()==FALSE){
		WriteLBtext("DirectSound Setup Failed");
		DS_NoSound = 0;
	}
	WriteLBtext("Starting DirectMusic");
	if (InitDirectMusic()==FALSE){
		WriteLBtext("DirectMusic Setup Failed");
		DS_NoMusic = 0;
	}*/

#if (USEDIRECTDRAW == 1)
//	WriteLBtext("Starting DirectDraw");
#else
//	WriteLBtext("Starting SDL_Graphics");
#endif
//	WriteLBtext("Calling ShutdownDirectSound");
//    ShutdownDirectSound();

	//WriteLBtext("");

//Init3Dsound();


	FindROTTdemofiles();

	WriteLBtext("");

	WriteLBtext("Push 'Run WinRottGL ' button to start game "); 
	WriteLBtext("");
Errexit:;
    ShowCursor(TRUE);
    hAccel = LoadAccelerators(hInstance, (LPCTSTR)IDR_ACCELERATOR1);

	///////////// start without popup ? ////////////////////////
	if (szCmdLine[0] != 0){//only print if theres any parameters 
		char tmps[255];
		lstrcpy (tmps,szCmdLine);	 
		CharLower(tmps);
		WriteLBtext(tmps);
		lstrcat (szParameter," ");	
		if (strstr(tmps,"runnow")!=0){
			SendMessage(hMainWnd,WM_COMMAND,IDM_RUNROTT,0); 
		}
	}



	// Main message loop:
	while (GetMessage(&msg, NULL, 0, 0)) 
	{
		if (!TranslateAccelerator(msg.hwnd, hAccel, &msg)) 
		{ 
			
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

    SendMessage(hMainWnd, WM_CLOSE, 0, 0);
	return msg.wParam;
}





//----------------------------------------------------------------------
void disableRottButtons()
{
	EnableWindow(hwndButtonRunRott,FALSE);
	EnableWindow(hwndButtonExit,FALSE);
}
//----------------------------------------------------------------------
void enableRottButtons()
{
	EnableWindow(hwndButtonRunRott,TRUE);
	EnableWindow(hwndButtonExit,TRUE);
}

//----------------------------------------------------------------------
void DisEnableRottButtons(BOOL bDisEnable)
{

	EnableWindow(hwndButtonRunRott,bDisEnable);
	EnableWindow(hwndButtonExit,bDisEnable);
	EnableWindow(hWndList,bDisEnable);
	EnableWindow(GetDlgItem(hMainWnd,IDM_CB1),bDisEnable);
	EnableWindow(GetDlgItem(hMainWnd,IDM_CB2),bDisEnable);
	EnableWindow(GetDlgItem(hMainWnd,IDM_CB3),bDisEnable);
	EnableWindow(GetDlgItem(hMainWnd,IDM_PARAMETER_EDIT),bDisEnable);	
	EnableWindow(GetDlgItem(hMainWnd,IDM_CHECKNETPLAY),bDisEnable);
	
}
//----------------------------------------------------------------------
void ConvertRottParameters(LPSTR WinParameters)
{
	char *ptr;
	char tmp[MAX_PATH];
	char tmp2[MAX_PATH];
	int  linelen,i;

	//are there any parametres in textfield
	GetWindowText(hwndParaEdit,tmp,MAX_PATH);

	ptr = tmp;
	if (bStoreParameters == TRUE){
		//remove leading spaces
		ptr--;
		do {
			ptr++;
		}while(ptr[0]==' ');
		SetStrInRegdb ("Parameters",ptr,"");
	}
	lstrcpy(tmp2,tmp);

	if (SelRTCfile[0] != 0){
		lstrcat (WinParameters,"FILERTC ");
		lstrcpy(tmp,"");
		ptr = strstr(SelRTCfile,"*");
		if (ptr != 0){
			lstrcpy(tmp,ptr+1);
			*(ptr-1) = 0;
		}
		lstrcat (tmp,SelRTCfile);
		SelRTCfile[0] = 0;
		i = GetShortPathName(tmp,SelRTCfile,sizeof(SelRTCfile));
		lstrcat (WinParameters,SelRTCfile);
		lstrcat (WinParameters," ");
	}
	if (SelRTLfile[0] != 0){
		lstrcat (WinParameters,"FILERTL ");
		lstrcpy(tmp,"");
		ptr = strstr(SelRTLfile,"*");
		if (ptr != 0){
			lstrcpy(tmp,ptr+1);
			*(ptr-1) = 0;
		}
		lstrcat (tmp,SelRTLfile);
		GetShortPathName(tmp,SelRTLfile,sizeof(SelRTLfile));
		lstrcat (WinParameters,SelRTLfile);
		lstrcat (WinParameters," ");
	}

	//are there any parametres in textfield
	lstrcat (WinParameters,tmp2);lstrcat (WinParameters," ");

	if (WinParameters[0] != 0) {
			lstrcpy (tmp,"Rott command line parameters = ");
			lstrcat (tmp,WinParameters);	 
			WriteLBtext(tmp);
	}
	// convert windows parameters to C standard 
	if (IsDlgButtonChecked(hMainWnd,IDM_CHECKNETPLAY)==1){
		lstrcpy (tmp,WinParameters);
		CharLower(tmp);
	//	if (_stricmp(WinParameters
		if (strstr(tmp,"net")==0){
			lstrcat (WinParameters," net");
		}
		if (strstr(tmp,"now")==0){
			lstrcat (WinParameters," now");
		}
	}

	ptr = WinParameters;//szParameter;
	argc = 1;//	argv[0],"WinRott.exe");
	linelen = lstrlen(WinParameters);
	for (i=0;i<=linelen;i++){
		if (*(ptr+i) != ' ') {
			argv[argc++] = (ptr+i);
			//move to next arg
			do {
				i++;
			}while ((*(ptr+i) != ' ')&&(*(ptr+i) != 0));
			*(ptr+i) = 0;
		}
	}
	argv[argc] = 0;
	//*****************************************

}
//----------------------------------------------------------------------
void ReadDelay(long delay)
{
	//a delay so user has time to read text on screen
	unsigned long Tick = GetTickCount() + delay;
	do {
	}while(GetTickCount()<Tick);
}
//----------------------------------------------------------------------
void WriteLBtext(LPSTR txt)
{
	int slen;
	char buf[512];

	ErrorDontQuit(txt,0);

	if (txt[0]=='*'){
		slen = SendMessage(hWndList, LB_GETCOUNT , 0, 0);
		SendMessage(hWndList, LB_DELETESTRING , slen-1, 0);
	}
	//remove garbage at txt_end
	lstrcpy(buf,txt);
	slen = lstrlen(buf);
	if (*(buf+slen-1)<=20){
		*(buf+slen-1)=0;
	}
	if (hWndList == NULL){return;}
	SendMessage(hWndList,LB_ADDSTRING , 0, (LPARAM)buf);

	AddToInfoWindow(buf, 2) ;

	ReadDelay(5);


	slen = SendMessage(hWndList,LB_GETCOUNT , 0, 0);
	SendMessage(hWndList,LB_SETCURSEL , slen-1, 0);



}


	static HMENU hmenu;         // handle to main menu
//----------------------------------------------------------------------
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;int is;

//	char tmp[12];

		switch(message)
		{
			/*
		case WM_APP:
			// Handle DirectShow events
			HandleMP3Events();
			break;
*/
		case WM_MEASUREITEM:
			if (MsgWM_MEASUREITEM(hWnd, message, wParam, lParam) == 0)
				break;
			return TRUE;//say we handle the drawing

		case WM_DRAWITEM:
			if (MsgWM_DRAWITEM(hWnd, message, wParam, lParam) == 0)
				break;
			return TRUE;//say we handle the drawing
		case WM_CREATE:
			{
			TCHAR  tmp[MAX_PATH];
			hmenu = GetMenu(hWnd);

			//CheckMenuItem(hmenu,IDM_FULLSCREEN,MF_CHECKED);

			
			GetStrFromRegdb ("Surroundeffect",tmp,"0");
			DS_Surroundeffect = atol(tmp);
//			GetStrFromRegdb ("StoreParameters",tmp,"0");

			if (GetStrFromRegdb ((LPSTR)"StoreParameters",(LPSTR)&tmp,(LPSTR)"0") != -1){
				bStoreParameters = atoi(tmp);
			}else{
				bStoreParameters = 0;
			}

			lstrcpy(tmp,"1");//default
			if (GetStrFromRegdb ((LPSTR)"FullScreen",(LPSTR)&tmp,(LPSTR)"1") != -1){
				RunFullscreen = atoi(tmp);
				if (RunFullscreen == TRUE){
					CheckMenuItem(hmenu,IDM_FULLSCREEN,MF_CHECKED);
				}else{
					CheckMenuItem(hmenu,IDM_FULLSCREEN,MF_UNCHECKED );
				}
			} 

			RunFullscreen = GetSetMenuItem(IDM_FULLSCREEN,"FullScreen","1");
			DS_NoMusic = GetSetMenuItem(ID_SETTINGS_NOMUSIC,"DS_NoMusic","1");
			iGrabMouse = GetSetMenuItem(IDM_GRABMOUSE,"GrabMouse","1");

			iShowInfoWnd = GetSetMenuItem(ID_SETTINGS_SHOWINFOWINDOWDURINGSTART,"ShowInfoWnd","1");

			DS_NoSound = GetSetMenuItem(ID_SETTINGS_NOSOUND,"DS_NoSound","1");


			iUseMp3Music = GetSetMenuItem(ID_SETTINGS_USEMP3MUSIC,"UseMp3Music","0");
			iUseSimpleSound = GetSetMenuItem(ID_SETTINGS_USESIMPLESND,"UseSimpleSnd","0");

			iUseSurroundEffect = GetSetMenuItem(ID_SETTINGS_USESURROUNDEFFECTS,"UseSurroundEffect","1");

			iUseDB50XGfix = GetSetMenuItem(ID_SETTINGS_USE_DB50XG_FIX,"UseDB50XGfix","0");


			iMapErrCorr = GetSetMenuItem(ID_SETTINGS_RUNERRORCORRECTIONONMAPS,"MapErrCorr","1");
 
			GetStrFromRegdb ((LPSTR)"Mp3Path",(LPSTR)&Mp3Path,(LPSTR)"");

			bUseExtWallSFX = GetSetMenuItem(ID_SETTINGS_USEEXTERNALWALLSFX,"UseExtWallSFX","0");
			bUseExtSFX = GetSetMenuItem(ID_SETTINGS_USESFX,"UseExtSounds","0");
			bUseExtPrecache = GetSetMenuItem(ID_SETTINGS_USEEXTENDEDPRECACHE,"UseExtPrecache","0");

			glsharpentex = GetSetMenuItem(ID_SHARPEN_GFX,"glsharpentex","1");

			bUseOldSkys = GetSetMenuItem(ID_OLD_SKYS,"UseOldSkys","1");
			bIntPolOldSkys = GetSetMenuItem(ID_OLD_INTPOL_SKYS,"IntPolOldSkys","1");
			
			bAbovemaskwall = GetSetMenuItem(ID_SOFTENGFX_ABOVEMASKWALL,"Abovemaskwall","1");
			bAbovewall = GetSetMenuItem(ID_SOFTENGFX_ABOVEWALL,"Abovewall","1");
			bDoors = GetSetMenuItem(ID_SOFTENGFX_DOORS,"Doors","1");
			bElevators = GetSetMenuItem(ID_SOFTENGFX_ELEVATORS,"Elevators","1");
			bExits = GetSetMenuItem(ID_SOFTENGFX_EXITS,"Exits","1");
			bFloor_Ceilings = GetSetMenuItem(ID_SOFTENGFX_FLOOR,"Floor_Ceilings","1");
			bGuns = GetSetMenuItem(ID_SOFTENGFX_GUNS,"Guns","1");
			bHswicthes = GetSetMenuItem(ID_SOFTENGFX_HSWICTHES,"Hswicthes","1");
			bMasked = GetSetMenuItem(ID_SOFTENGFX_MASKED,"Masked","1");
			bMish = GetSetMenuItem(ID_SOFTENGFX_MISH,"Mish","0");
			bShapes = GetSetMenuItem(ID_SOFTENGFX_SHAPES,"Shapes","1");
			bSides = GetSetMenuItem(ID_SOFTENGFX_SIDES,"Sides","1");
			bWalls = GetSetMenuItem(ID_SOFTENGFX_WALLS,"Walls","1");

			bAbovemaskwall2 = GetSetMenuItem(ID_SOFTENGFX_ABOVEMASKWALL2, "Abovemaskwall2", "1");
			bAbovewall2 = GetSetMenuItem(ID_SOFTENGFX_ABOVEWALL2, "Abovewall2", "1");
			bDoors2 = GetSetMenuItem(ID_SOFTENGFX_DOORS2, "Doors2", "0");
			bElevators2 = GetSetMenuItem(ID_SOFTENGFX_ELEVATORS2, "Elevators2", "1");
			bExits2 = GetSetMenuItem(ID_SOFTENGFX_EXITS2, "Exits2", "1");
			bFloor_Ceilings2 = GetSetMenuItem(ID_SOFTENGFX_FLOOR2, "Floor_Ceilings2", "1");
			bGuns2 = GetSetMenuItem(ID_SOFTENGFX_GUNS2, "Guns2", "0");
			bHswicthes2 = GetSetMenuItem(ID_SOFTENGFX_HSWICTHES2, "Hswicthes2", "1");
			bMasked2 = GetSetMenuItem(ID_SOFTENGFX_MASKED2, "Masked2", "1");
			bMish2 = GetSetMenuItem(ID_SOFTENGFX_MISH2, "Mish2", "0");
			bShapes2 = GetSetMenuItem(ID_SOFTENGFX_SHAPES2, "Shapes2", "0");
			bSides2 = GetSetMenuItem(ID_SOFTENGFX_SIDES2, "Sides2", "1");
			bWalls2 = GetSetMenuItem(ID_SOFTENGFX_WALLS2, "Walls2", "1");

			GetStrFromRegdb ("SoundFix",tmp,"1");
			musfix = atol(tmp);


			GetStrFromRegdb ("UseOrgThunder",tmp,"1");
			iUseOrgThunder = atol(tmp);

			GetStrFromRegdb ("PulsPushwalls",tmp,"0");
			iPulsPushwalls = atol(tmp);

			GetStrFromRegdb ("DeadbodyIsTarget",tmp,"1");
			iDeadbodyIsTarget = atoi(tmp);

			GetStrFromRegdb ("KeepWeaponWhenKilled",tmp,"0");
			iKeepWeaponWhenKilled = atoi(tmp);


			GetStrFromRegdb ("UseWaterSnd",tmp,"0");
			iUseWaterSnd = atol(tmp);


			bScanSubdirs = GetSetMenuItem(ID_SETTINGS_SCANSUBDIRSFORRTC,"ScanSubdirs","0");


			cUseSavegameErrCorr = GetSetMenuItem(IDC_CHECK_SAVGAMERRC,"UseSavegameErrCorr","0");
			cUseSavegameGLpic = GetSetMenuItem(IDC_CHECK_SAVGAMUSEGLPIC,"UseSavegameGLpic","0");
			cUseSavegameOldpic = GetSetMenuItem(IDC_CHECK_USEOLDPIC,"UseSavegameOldpic","0");
			cUseSavegameSoften = GetSetMenuItem(IDC_CHECK_SAVGAMSOFTEN,"UseSavegameSoften","0");

			g_packsystem = GetSetMenuItem(IDC_RADIO2,"DemoPackSys","1");


			lstrcpy(tmp,"0");//default
			if (GetStrFromRegdb ((LPSTR)"Compat",(LPSTR)&tmp,(LPSTR)"0") != -1){
				compat = atoi(tmp);
				if (compat & 1)
                    CheckMenuItem(hmenu,ID_NO_CATWALK,MF_CHECKED);
				if (compat & 2){
                    CheckMenuItem(hmenu,ID_NO_MODELS,MF_CHECKED);    
				}
				if (compat & 4)
                    CheckMenuItem(hmenu,ID_OLD_LOOKMODE,MF_CHECKED);
 				if (compat & 8)
                    CheckMenuItem(hmenu,ID_NO_FATBLOCK,MF_CHECKED);
				if (compat & 16)
                    CheckMenuItem(hmenu,ID_NO_FLOORDEPTH,MF_CHECKED);                                                           
			}
			
			
			lstrcpy(tmp,"-1");//default
			if (GetStrFromRegdb ((LPSTR)"TexMode",(LPSTR)&tmp,(LPSTR)"-1") != -1){
				gltexmode = atoi(tmp);
				if (gltexmode == -1)
                    CheckMenuItem(hmenu,ID_GL_DEFAULT,MF_CHECKED);
				if (gltexmode == 0)
                    CheckMenuItem(hmenu,ID_GL_NEAREST,MF_CHECKED);
				if (gltexmode == 1)
                    CheckMenuItem(hmenu,ID_GL_LINEAR,MF_CHECKED);                    
 				if (gltexmode == 2)
                    CheckMenuItem(hmenu,ID_GL_NEAREST_MIPMAP_NEAREST,MF_CHECKED);
				if (gltexmode == 3)
                    CheckMenuItem(hmenu,ID_GL_NEAREST_MIPMAP_LINEAR,MF_CHECKED);                                       
				if (gltexmode == 4)
                    CheckMenuItem(hmenu,ID_GL_LINEAR_MIPMAP_NEAREST,MF_CHECKED);
				if (gltexmode == 5)
                    CheckMenuItem(hmenu,ID_GL_LINEAR_MIPMAP_LINEAR,MF_CHECKED);                                                                                                   
			}	

			if (bUseExtWallSFX == TRUE)//dont use sharpen when using extern gfx
				glsharpentex = 0;
		
			if (glsharpentex == 1)//sharpen look best in ID_GL_NEAREST_MIPMAP_NEAREST
				gltexmode = 2;

				  
/*
			lstrcpy(tmp,"2");//default
			if (GetStrFromRegdb ((LPSTR)"FloorScale",(LPSTR)&tmp,(LPSTR)"0") != -1){
				iFloorScale = atoi(tmp);
				if (iFloorScale ==1){
					CheckMenuItem(hmenu,ID_SCALEFLOOR_SCALE1,MF_CHECKED);
				}else if (iFloorScale == 2){
					CheckMenuItem(hmenu,ID_SCALEFLOOR_SCALE2,MF_CHECKED);
				}else if (iFloorScale == 3){
					CheckMenuItem(hmenu,ID_SCALEFLOOR_SCALE3,MF_CHECKED);
				}
			}
*/
			if (bStoreParameters == TRUE){
				CheckMenuItem(hmenu,ID_SETTINGS_STOREPARAMETERS,MF_CHECKED );
			}else{
				CheckMenuItem(hmenu,ID_SETTINGS_STOREPARAMETERS,MF_UNCHECKED);
			}
/*
			if (bUseExtPrecache == TRUE){
				CheckMenuItem(hmenu,ID_SETTINGS_USEEXTENDEDPRECACHE,MF_CHECKED );
			}else{
				CheckMenuItem(hmenu,ID_SETTINGS_USEEXTENDEDPRECACHE,MF_UNCHECKED);
			}

			if (bUseExtSFX == TRUE){
				CheckMenuItem(hmenu,ID_SETTINGS_USESFX,MF_CHECKED );
			}else{
				CheckMenuItem(hmenu,ID_SETTINGS_USESFX,MF_UNCHECKED);
			}
*/

			if (bScanSubdirs == TRUE){
				CheckMenuItem(hmenu,ID_SETTINGS_SCANSUBDIRSFORRTC,MF_CHECKED );
			}else{
				CheckMenuItem(hmenu,ID_SETTINGS_SCANSUBDIRSFORRTC,MF_UNCHECKED);
			}


/*
			if (DS_NoMusic == TRUE){
				CheckMenuItem(hmenu,ID_SETTINGS_NOMUSIC,MF_CHECKED );
			}else{
				CheckMenuItem(hmenu,ID_SETTINGS_NOMUSIC,MF_UNCHECKED);
			}
			if (DS_NoSound == TRUE){
				CheckMenuItem(hmenu,ID_SETTINGS_NOSOUND,MF_CHECKED );
			}else{
				CheckMenuItem(hmenu,ID_SETTINGS_NOSOUND,MF_UNCHECKED);
			}
*//*
			if (DS_Surroundeffect == TRUE){
				CheckMenuItem(hmenu,ID_SETTINGS_USESURROUNDEFFECT,MF_CHECKED );
			}else{
				CheckMenuItem(hmenu,ID_SETTINGS_USESURROUNDEFFECT,MF_UNCHECKED);
			}
*/
			//CheckMenuItem(hmenu,IDM_FULLSCREEN,MF_CHECKED);
			//CheckMenuItem(hmenu,ID_SETTINGS_ADAPTIVEDRAWTIMING,MF_CHECKED);
			//RunFullscreen = TRUE;
			lstrcpy(tmp,"0.6");//default
			if (GetStrFromRegdb ((LPSTR)"ALPHA_EXP",(LPSTR)&tmp,(LPSTR)"0.6") != -1)
				g_explo_alpha = atof(tmp);
			lstrcpy(tmp,"0.6");//default
			if (GetStrFromRegdb ((LPSTR)"ALPHA_FJETS",(LPSTR)&tmp,(LPSTR)"0.6") != -1)
				g_firej_alpha = atof(tmp);
			lstrcpy(tmp,"0.8");//default
			if (GetStrFromRegdb ((LPSTR)"ALPHA_LIFE",(LPSTR)&tmp,(LPSTR)"0.8") != -1)
				g_lifei_alpha = atof(tmp);
			lstrcpy(tmp,"0.6");//default
			if (GetStrFromRegdb ((LPSTR)"ALPHA_ORGANS",(LPSTR)&tmp,(LPSTR)"0.6") != -1)
				g_organ_alpha = atof(tmp);
			lstrcpy(tmp,"0.8");//default
			if (GetStrFromRegdb ((LPSTR)"ALPHA_BTH",(LPSTR)&tmp,(LPSTR)"0.8") != -1)
				g_bullet_alpha = atof(tmp);
			
			//InitInfoWndInstance(hInst, SW_SHOW);
			}  
			break;
        case WM_KEYDOWN: 
			break;
		case WM_DESTROY:
			PostQuitMessage(0);
			break;
		case WM_COMMAND:
			wmId    = LOWORD(wParam); 
			wmEvent = HIWORD(wParam); 
			// Parse the menu selections:
			switch (wmId)
			{

			    case IDM_FULLSCREEN:
					if (RunFullscreen == TRUE){
						CheckMenuItem(hmenu,IDM_FULLSCREEN,MF_UNCHECKED);
						SetStrInRegdb ("FullScreen","0","0");
						RunFullscreen = FALSE;
					}else{
						CheckMenuItem(hmenu,IDM_FULLSCREEN,MF_CHECKED);
						SetStrInRegdb ("FullScreen","1","1");
						RunFullscreen = TRUE;
					}	
					break;
			    case IDM_GRABMOUSE:
					if (iGrabMouse == TRUE){
						CheckMenuItem(hmenu,IDM_GRABMOUSE,MF_UNCHECKED);
						SetStrInRegdb ("GrabMouse","0","0");
						iGrabMouse = FALSE;
					}else{
						CheckMenuItem(hmenu,IDM_GRABMOUSE,MF_CHECKED);
						SetStrInRegdb ("GrabMouse","1","1");
						iGrabMouse = TRUE;
					}	
					break;
			    case ID_SETTINGS_SHOWINFOWINDOWDURINGSTART:
					if (iShowInfoWnd == TRUE){
						CheckMenuItem(hmenu,ID_SETTINGS_SHOWINFOWINDOWDURINGSTART,MF_UNCHECKED);
						SetStrInRegdb ("ShowInfoWnd","0","0");
						iShowInfoWnd = FALSE;
					}else{
						CheckMenuItem(hmenu,ID_SETTINGS_SHOWINFOWINDOWDURINGSTART,MF_CHECKED);
						SetStrInRegdb ("ShowInfoWnd","1","1");
						iShowInfoWnd = TRUE;
					}	
					break;


			    case ID_SETTINGS_RUNERRORCORRECTIONONMAPS:
					if (iMapErrCorr == TRUE){
						CheckMenuItem(hmenu,ID_SETTINGS_RUNERRORCORRECTIONONMAPS,MF_UNCHECKED);
						SetStrInRegdb ("MapErrCorr","0","0");
						iMapErrCorr = FALSE;
					}else{
						CheckMenuItem(hmenu,ID_SETTINGS_RUNERRORCORRECTIONONMAPS,MF_CHECKED);
						SetStrInRegdb ("MapErrCorr","1","1");
						iMapErrCorr = TRUE;
					}	
					break;
			    case ID_SETTINGS_STOREPARAMETERS:
					if (bStoreParameters == TRUE){
						CheckMenuItem(hmenu,ID_SETTINGS_STOREPARAMETERS,MF_UNCHECKED);
						SetStrInRegdb ("StoreParameters","0","0");
						bStoreParameters = FALSE;
					}else{
						CheckMenuItem(hmenu,ID_SETTINGS_STOREPARAMETERS,MF_CHECKED);
						SetStrInRegdb ("StoreParameters","1","0");
						bStoreParameters = TRUE;
					}	
					break;
			    case ID_SETTINGS_SCANSUBDIRSFORRTC:
					if (bScanSubdirs == TRUE){
						CheckMenuItem(hmenu,ID_SETTINGS_SCANSUBDIRSFORRTC,MF_UNCHECKED);
						SetStrInRegdb ("ScanSubdirs","0","0");
						bScanSubdirs = FALSE;
					}else{
						CheckMenuItem(hmenu,ID_SETTINGS_SCANSUBDIRSFORRTC,MF_CHECKED);
						SetStrInRegdb ("ScanSubdirs","1","0");
						bScanSubdirs = TRUE;
					}	
					break;



			    case IDM_PARAMETER_EDIT:
		
	//			   GetWindowText(hwndParaEdit ,buf,255);
				   //SendMessage((HWND) hwndParaEdit,EM_GETSEL,(WPARAM) wP,(LPARAM) lP);
	//			   L = lstrlen (buf);
				   break;
				case IDM_CB1:
					{ 
						if (HIWORD(wParam) == CBN_SELENDOK) {
							TCHAR  tmp[MAX_PATH];	
							is = SendMessage(hwndCB1,CB_GETCURSEL,0,0);
							if (is == 0) {SetRottScreenRes (320, 200);}
							if (is == 1) {SetRottScreenRes (640, 480);}
							if (is == 2) {SetRottScreenRes (800, 600);}
							if (is == 3) {SetRottScreenRes (1024, 768);}
							if (is == 4) {SetRottScreenRes (1152, 864);}
							if (is == 5) {SetRottScreenRes (1280, 1024);}		
							if (is == 6) { SetRottScreenRes(1680, 1050); }
							if (is == 7) {SetRottScreenRes (1920, 1080);}	//<---ADAM***

							sprintf_s(tmp, sizeof(tmp), "%d",is);
							SetStrInRegdb ("Res",tmp,"2"); 
						}
					} 
					break;
				case IDM_CB2:
					{ 
						if (HIWORD(wParam) == CBN_SELENDOK) {
							is = SendMessage(hwndCB2,CB_GETCURSEL,0,0);
							if (is != 0){
								SendMessage(hwndCB2, CB_GETLBTEXT, 
									is, (LPARAM) (LPCSTR) SelRTCfile); 
							}
						}
					} 
					break;
				case IDM_CB3:
					{ 
						if (HIWORD(wParam) == CBN_SELENDOK) {
							is = SendMessage(hwndCB3,CB_GETCURSEL,0,0);
							if (is != 0){
								SendMessage(hwndCB3, CB_GETLBTEXT, 
									is, (LPARAM) (LPCSTR) SelRTLfile); 
							}
						}
					} 
					break;
				case IDM_CHECKNETPLAY:
					if (IsDlgButtonChecked(hWnd,IDM_CHECKNETPLAY)==0){
						SendDlgItemMessage(hWnd,IDM_CHECKNETPLAY,BM_SETCHECK,1,0);
					}else{
						SendDlgItemMessage(hWnd,IDM_CHECKNETPLAY,BM_SETCHECK,0,0);
					}
				   break;
				case ID_HELP_ROTTHELP:
				   DialogBox(hInst, (LPCTSTR)IDD_ROTTDIALOG1, hWnd, (DLGPROC)RottHelpProc);
				   break;
				case IDM_ORGROTTHELP:
					DialogBox(hInst, (LPCTSTR)IDD_ORG_ROTTHELP, hWnd, (DLGPROC)HelpboxProc);
					break;
				case IDM_ABOUT:
				   DisEnableRottButtons(FALSE);
				   DialogBox(hInst, (LPCTSTR)IDD_ABOUTBOX, hWnd, (DLGPROC)About);
				   DisEnableRottButtons(TRUE);
				   break;
				case IDM_RUNROTT:
				   InitInfoWndInstance(hInst, SW_SHOW);
				   ConvertRottParameters(szParameter);
	//			   ShowCursor(FALSE);
	//			   SetCapture(hMainWnd);
	/*
				   SetFocus(hMainWnd);
				   if (iGLOBAL_SCREENWIDTH==320){
					   bUseExtWallSFX = FALSE; 
				   }
				   PICbuf =  GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,iGLOBAL_SCREENHEIGHT*iGLOBAL_SCREENWIDTH);
				   tmpPICbuf =  GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,iGLOBAL_SCREENHEIGHT*iGLOBAL_SCREENWIDTH);
				   //InitMouseForGame();	
				   */
				   DisEnableRottButtons(FALSE); 
				   EnableWindow(hWndList,TRUE); 
#if (USEDIRECTSOUND == 1)
				//	WriteLBtext("DirectSound conversion by Birger N. Andreasen");

					if (DS_NoSound==1){
					WriteLBtext("Starting DirectSound");
					if (InitDirectSound()==FALSE){
						WriteLBtext("DirectSound Setup Failed");
						DS_NoSound = 0;
					}}
#endif	
	
#if (USEDIRECTMUSIC == 1)	
					if (DS_NoMusic==1){
					WriteLBtext("Starting DirectMusic");
					if (InitDirectMusic()==FALSE){
						WriteLBtext("DirectMusic Setup Failed");
						DS_NoMusic = 0;
					}}
						//	PlayROTTMidiFile("tmpsong.mid",0);//bna++
#endif
					if (bBlurGraphics == 1)
						WriteLBtext("GFX is set to be softned, please be patient");
				   mainrott(argc,argv); // jump to ROTT main loop
				   break;
/*
				case ID_SETTINGS_SELECTSOUNDMUSICDRIVER:
#if (USEDIRECTMUSIC == 1)
				   EnableWindow(hwndButtonRunRott,FALSE);
				   EnableWindow(hwndButtonExit,FALSE);
				   DialogBox(hInst,MAKEINTRESOURCE( IDD_DIALOG_SDRIVER), hWnd, (DLGPROC)SSoundDrvWndProc);
				   EnableWindow(hwndButtonRunRott,TRUE);
				   EnableWindow(hwndButtonExit,TRUE);
#endif
				   break;
*/

				case ID_SETTINGS_GRAPHICSSETTINGSWINDOW:
				   EnableWindow(hwndButtonRunRott,FALSE);
				   EnableWindow(hwndButtonExit,FALSE);
				   DialogBox(hInst,MAKEINTRESOURCE( IDD_DIALOG_GFX), hWnd, (DLGPROC)GfxSettingsWndProc);
				   EnableWindow(hwndButtonRunRott,TRUE);
				   EnableWindow(hwndButtonExit,TRUE);
				   break;

				case ID_SETTINGS_SOUNDSETTINGSWINDOW:
				   EnableWindow(hwndButtonRunRott,FALSE);
				   EnableWindow(hwndButtonExit,FALSE);
				   DialogBox(hInst,MAKEINTRESOURCE( IDD_DIALOG_SFX), hWnd, (DLGPROC)SfxSettingsWndProc);
				   EnableWindow(hwndButtonRunRott,TRUE);
				   EnableWindow(hwndButtonExit,TRUE);
				   break;

				case ID_SETTINGS_GENERALSETTINGS:
				   EnableWindow(hwndButtonRunRott,FALSE);
				   EnableWindow(hwndButtonExit,FALSE);
				   DialogBox(hInst,MAKEINTRESOURCE( IDD_DIALOG_GEN), hWnd, (DLGPROC)GenSettingsWndProc);
				   EnableWindow(hwndButtonRunRott,TRUE);
				   EnableWindow(hwndButtonExit,TRUE);
				   break;
				case ID_SETTINGS_ROTTMENUSETTINGS:
				   EnableWindow(hwndButtonRunRott,FALSE);
				   EnableWindow(hwndButtonExit,FALSE);
				   DialogBox(hInst,MAKEINTRESOURCE( IDD_DIALOG_ROTT), hWnd, (DLGPROC)RottSettingsWndProc);
				   EnableWindow(hwndButtonRunRott,TRUE);
				   EnableWindow(hwndButtonExit,TRUE);
				   break;

				   
				case IDM_EXIT:
				   DestroyWindow(hWnd);
				   break;
				default:
				   return DefWindowProc(hWnd, message, wParam, lParam);
			}
			break;
	} 
    
	return DefWindowProc(hWnd, message, wParam, lParam);
}
//----------------------------------------------------------------------
// Mesage handler for about box.
LRESULT CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_INITDIALOG:

				return TRUE;

		case WM_COMMAND:
			if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL) 
			{
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}
			break;
	}
    return FALSE;
}

//----------------------------------------------------------------------
// Mesage handler for RottHelpProc box.
LRESULT CALLBACK RottHelpProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_INITDIALOG:
			    WriteWinRottHelp (hDlg);
				DisEnableRottButtons(FALSE);
				return TRUE;

		case WM_COMMAND:
			if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL) 
			{
				DisEnableRottButtons(TRUE);
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}
			break;
	}
    return FALSE;
}



//----------------------------------------------------------------------
void FindROTTdemofiles()
{
	WIN32_FIND_DATA	FileData; 
	HANDLE			hSearch; 
//	DWORD			dwAttrs; 
	BOOL			fFinished = FALSE; 
	FILE			*dmofile;
	char			buffer[25];
	int				demoversionnb = 0;

	iDemoNames = -1; //global counter
	iCurrentDemoNames = -1;// global cnt used later to store last played demo

	// Start searching for .DMO files in the current directory. 
	hSearch = FindFirstFile("*.dmo", &FileData); 
	if (hSearch == INVALID_HANDLE_VALUE) 
	{ 
		WriteLBtext("No rott demo files found."); 
		return;
	} 

	// Copy each .DMO filename to the array 
	while (!fFinished) 
	{ 
		if (lstrlen(FileData.cFileName) < 40) { //filename must not exxed 40 chars
			   
			//check if correct demo type or game will crash
			fopen_s(&dmofile, FileData.cFileName, "r");
			if (dmofile != 0, "r")
			{
				fgets(buffer, sizeof(buffer), dmofile);
				fclose(dmofile);
				buffer[8]=0;
				demoversionnb = atol(buffer+5);
				buffer[5]=0;
			}
			#if (SHAREWARE == 1)
				if ((lstrcmp(buffer,"DMOSW")==0)&&(demoversionnb >= GLVERSION)) { //not a shareware demo version
					if (iDemoNames < 10) { // store max 10 names
						iDemoNames++;
						lstrcpy(aDemoNames[iDemoNames], FileData.cFileName); 
					}
				}
			#else
				if ((lstrcmp(buffer,"DMOFL")==0)&&(demoversionnb >= GLVERSION)) { //not a reg demo version
					if (iDemoNames < 10) { // store max 10 names
						iDemoNames++;
						lstrcpy(aDemoNames[iDemoNames], FileData.cFileName); 
					}
				}
			#endif
		}

		if (!FindNextFile(hSearch, &FileData)) 
		{
			if (GetLastError() == ERROR_NO_MORE_FILES) 
			{ 
				fFinished = TRUE; 
			} 
			else 
			{ 
				WriteLBtext("Couldn't find next demo file."); 
			} 
		}
	} 
 
	// Close the search handle. 
 	if (!FindClose(hSearch)) 
	{ 
		WriteLBtext("Couldn't close search handle."); 
	} 

	if (iDemoNames >= 0) {
		iCurrentDemoNames = 0;
	}



}


int FindRTLFilenames(HWND cb, char *cRTX)
{
	char tmp[256];
//	HANDLE			hSearch; 
	BOOL			fFinished = FALSE; 
	FILE			*dmofile;
	char			buffer[25]="";
	char			*ptr;
	int				NbFilesFound=0;
	HWND			hWndDirLB;
	BOOL			Recurse = bScanSubdirs;
	TCHAR			Path[MAX_PATH];
	TCHAR			RootPath[MAX_PATH];
	TCHAR			RootDir[MAX_PATH];
	TCHAR			Directory[MAX_PATH];
	TCHAR			wbuf[MAX_PATH];
	WIN32_FIND_DATA FindData;
	HANDLE			ffh; 
	BOOL			retVal = TRUE;

	lstrcpy(RootDir,ApogeePath);
	lstrcat(RootDir,"\\");

	// create a ListBox to store dir string 
    hWndDirLB = CreateWindowEx(0L,"LISTBOX", "", WS_CHILD ,-6000,-6000, 70, 20,hMainWnd,(HMENU)NULL,hInst,NULL);
	//add dummy message
	SendMessage(hWndDirLB, LB_ADDSTRING , 0, (LPARAM)"");
	while (SendMessage(hWndDirLB,LB_GETCOUNT,(WPARAM)0,(LPARAM) 0) > 0)
	{
		SendMessage(hWndDirLB,LB_GETTEXT,(WPARAM)0,(LPARAM) Directory);
		SendMessage(hWndDirLB,LB_DELETESTRING,(WPARAM)0,(LPARAM) Directory);

		lstrcpy (Path, Directory);
		lstrcat (Path, TEXT("*.*"));
		lstrcpy (RootPath, RootDir);
		lstrcat (RootPath, Path);
		ffh = FindFirstFile(RootPath, &FindData);
		if (ffh != INVALID_HANDLE_VALUE) {
			do {
				if (FindData.cFileName[0] != TEXT('.')) {
						if ((FindData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) == FILE_ATTRIBUTE_DIRECTORY)						
						{
							if (Recurse == TRUE) { 							
								lstrcpy (Path, Directory);
								lstrcat (Path, FindData.cFileName);
								lstrcat (Path, TEXT("\\"));
								SendMessage(hWndDirLB, LB_ADDSTRING , 0, (LPARAM)Path);
							}
						}else{
							if (lstrlen(FindData.cFileName) < 40) { //filename must not exxed 40 chars
								//dont include standard files
								ptr = FindData.cFileName+(lstrlen(FindData.cFileName)-4);
								//if ( (lstrcmpi(ptr,".RTL")==0) ||(lstrcmpi(ptr,".RTC")==0)) {
#if (SHAREWARE == 0)
								if ((lstrcmpi(FindData.cFileName,"Darkwar.rtc")!=0)&&
									(lstrcmpi(FindData.cFileName,"Darkwar.rtl")!= 0)) {
#else
								if ((lstrcmpi(FindData.cFileName,"Huntbgin.rtc")!=0)&&
									(lstrcmpi(FindData.cFileName,"Huntbgin.rtl")!= 0)) {
#endif
									//check if correct type or game will crash
									lstrcpy (tmp, RootPath );
									tmp[lstrlen(tmp)-3]=0;
									lstrcat (tmp, FindData.cFileName);

									fopen_s(&dmofile, tmp, "r");

									if(dmofile!=0){
										fgets(buffer, 4, dmofile);
										fclose(dmofile);
										if (lstrcmpi(cRTX,"RTL")==0) {
											buffer[3]=0;
										}else{
											buffer[2]=0;
										}
										if (lstrcmpi(buffer,cRTX)==0) { 
											NbFilesFound++;
											if (NbFilesFound == 1){
												if (lstrcmpi(cRTX,"RTL")==0) { 
													SendMessage(cb, CB_ADDSTRING, 0, (LPARAM)"<select RTL level>");
												}else{
													SendMessage(cb, CB_ADDSTRING, 0, (LPARAM)"<select RTC level>");
												}
												SendMessage(cb, CB_SETITEMDATA, 0, (LPARAM) 0 );
												SendMessage(cb, CB_SETCURSEL, 0, (LPARAM) 0 );
											}
											lstrcpy (tmp, RootPath );
											tmp[lstrlen(tmp)-3]=0;
											sprintf_s(wbuf, sizeof(wbuf), "%s *%s",FindData.cFileName,tmp);
											SendMessage(cb, CB_ADDSTRING, 0, (LPARAM) wbuf );
											SendMessage(cb, CB_SETITEMDATA, 0, (LPARAM) 0 );
											SendMessage(cb, CB_SETCURSEL, 0, (LPARAM) 0 );
										}
									}
								//	}
								}
							}
						}
				}
			} while (FindNextFile(ffh, &FindData));
			FindClose(ffh);
		}
	}
	retVal = FALSE;

//ErrOut:;
	DestroyWindow(hWndDirLB);
	if (NbFilesFound == 0){
		if (lstrcmpi(cRTX,"RTL")==0) { 
			SendMessage(cb, CB_ADDSTRING, 0, (LPARAM) "No valid RTL files found." );
		}else{
			SendMessage(cb, CB_ADDSTRING, 0, (LPARAM) "No valid RTC files found." );
		}
		SendMessage(cb, CB_SETITEMDATA, 0, (LPARAM) 0 );
		SendMessage(cb, CB_SETCURSEL, 0, (LPARAM) 0 );
	}
	return 0;
}


//----------------------------------------------------------------------
extern int     viewsize;
/*
void MoveScreenUpLeft(unsigned char *b)
{
	int startX,startY,startoffset;
    unsigned char  *Ycnt,*i;

	for (i=b+4324;i<b+10000;i++)
*i = 45;//*(i+4);
	//memcpy(b,b+324,10000);
return;
   SetTextMode (  );
 //   b=(byte *)bufferofs;
	b += (((200-viewheight)/2)*320)+((320-viewwidth)/2);
	if (viewsize == 8) {b += 8*320;}
	startX = 3; //take 3 pixels to the right
	startY = 3; //take 3 lines down
	startoffset = (startY*320)+startX;

	for (Ycnt=b;Ycnt<b+((viewheight-startY)*320);Ycnt+=320){
		memcpy(Ycnt,Ycnt+startoffset, viewwidth-startX);
	}
}
//----------------------------------------------------------------------
void MoveScreenDownLeft(unsigned char *b)
{
	int startX,startY,startoffset;
    unsigned char  *Ycnt;
//   SetTextMode (  );
//    b=(byte *)bufferofs;
	b += (((200-viewheight)/2)*320)+((320-viewwidth)/2);
	if (viewsize == 8) {b += 8*320;}
	startX = 3; //take 3 pixels to the right
	startY = 3; //take 3 lines down
	startoffset = (startY*320);//+startX;

	//Ycnt starts in botton of screen and copys lines upwards
	for (Ycnt=b+((viewheight-startY-1)*320);Ycnt>b;Ycnt-=320){
		memcpy(Ycnt+startoffset,Ycnt+startX,viewwidth-startX);
	}
}
//----------------------------------------------------------------------
void MoveScreenUpRight(unsigned char *b)
{
	int startX,startY,startoffset;
    unsigned char  *Ycnt;
//   SetTextMode (  );
 //   b=(byte *)bufferofs;

	b += (((200-viewheight)/2)*320)+((320-viewwidth)/2);
	if (viewsize == 8) {b += 8*320;}
	startX = 3; //take 3 pixels to the right
	startY = 3; //take 3 lines down
	startoffset = (startY*320);//+startX;

	for (Ycnt=b;Ycnt<b+((viewheight-startY)*320);Ycnt+=320){
		memcpy(Ycnt+startX,Ycnt+startoffset, viewwidth-startX);
	}
}
//----------------------------------------------------------------------
void MoveScreenDownRight(unsigned char *b)
{
	int startX,startY,startoffset;
    unsigned char  *Ycnt;
//   SetTextMode (  );
  //  b=(byte *)bufferofs;

	b += (((200-viewheight)/2)*320)+((320-viewwidth)/2);
	if (viewsize == 8) {b += 8*320;}
	startX = 3; //take 3 pixels to the right
	startY = 3; //take 3 lines down
	startoffset = (startY*320)+startX;

	//Ycnt starts in botton of screen and copys lines upwards
	for (Ycnt=b+((viewheight-startY-1)*320);Ycnt>b;Ycnt-=320){
		memcpy(Ycnt+startoffset,Ycnt,viewwidth-startX);
	}
}

/*
//----------------------------------------------------------------------
void WriteDebug(char *Message)
{
    FILE *stream;

    stream = fopen(szDbgName, "a+");
    fprintf(stream, "%s", Message);
    fclose(stream);
}*/ 
//----------------------------------------------------------------------
void GetWindowsVersion()
{
//	MEMORYSTATUS lpBuffer;
    OSVERSIONINFO OSVersionInfo;
    FILE *stream;
	char buf[512];

	fopen_s(&stream, szDbgName, "a+");


    OSVersionInfo.dwOSVersionInfoSize = sizeof(OSVersionInfo);
    GetVersionEx(&OSVersionInfo);

    switch(OSVersionInfo.dwPlatformId)
	{
	case VER_PLATFORM_WIN32s:
		sprintf_s(buf, sizeof(buf),"Platform is Windows %d.%02d\n",
			OSVersionInfo.dwMajorVersion,
			OSVersionInfo.dwMinorVersion);
		WriteLBtext(buf);
		fprintf(stream, "Platform is Windows %d.%02d\n",
			OSVersionInfo.dwMajorVersion,
			OSVersionInfo.dwMinorVersion); 
		break;
	case VER_PLATFORM_WIN32_WINDOWS:
		fprintf(stream, "Platform is Windows 9X ");
		sprintf_s(buf, sizeof(buf), "Platform is Windows 9X ,Version %d.%02d.%d\n", OSVersionInfo.dwMajorVersion,
			OSVersionInfo.dwMinorVersion,
			OSVersionInfo.dwBuildNumber & 0xFFFF);
		WriteLBtext(buf);
		fprintf(stream, "Version %d.%02d.%d\n", OSVersionInfo.dwMajorVersion,
			OSVersionInfo.dwMinorVersion,
			OSVersionInfo.dwBuildNumber & 0xFFFF);
		break;
	case VER_PLATFORM_WIN32_NT:
		sprintf_s(buf, sizeof(buf), "Platform is Windows NT ,Version %d.%02d ", OSVersionInfo.dwMajorVersion, OSVersionInfo.dwMinorVersion);
		WriteLBtext(buf);		
		sprintf_s(buf, sizeof(buf), "Build %d\n", OSVersionInfo.dwBuildNumber & 0xFFFF);
		WriteLBtext(buf);
		 
		fprintf(stream, "Platform is Windows NT ");
		fprintf(stream, "Version %d.%02d ", OSVersionInfo.dwMajorVersion, OSVersionInfo.dwMinorVersion);
		fprintf(stream, "Build %d\n", OSVersionInfo.dwBuildNumber & 0xFFFF);
		break;
	}
//    if(strlen(OSVersionInfo.szCSDVersion) > 0)
//		fprintf(stream, "Windows Info: %s\n", OSVersionInfo.szCSDVersion);
    fclose(stream);

	
//DWORD		dwAvailPhysRamOnMachine;
  //  GlobalMemoryStatus(&lpBuffer);// memory status structure
//	dwAvailPhysRamOnMachine = (lpBuffer.dwAvailPhys)/2;
	//MaxSoundPages = (lpBuffer.dwAvailPhys)/10000; //in bytes
	//if (MaxSoundPages < 1000){MaxSoundPages = 1000;}


}

/*
void *WinAllocMem (int size)
{
	void *ptr;
	ptr =  GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,size);
	return ptr;
}
void WinFreeMem (void * ptr)
{
	GlobalUnlock(ptr);//release mem
}
*/
long oldtckcnt=0;

long GetAvailMem ()
{
	MEMORYSTATUS lpBuffer;
	if (oldtckcnt > GetTicCount()){
		return 0;
	}
    GlobalMemoryStatus(&lpBuffer);// memory status structure
	ErrorDontQuit("AvailMem=",lpBuffer.dwAvailPhys);
	oldtckcnt = GetTicCount()+100;
	return 1;
}


//----------------------------------------------------------------------
#define FINEANGLES                        2048
#define MAXMEMORYSIZE   20000000//olso defined in z_zone.h
void SetRottScreenRes (int Width, int Height) 
{

	iGLOBAL_SCREENWIDTH = Width;
	iGLOBAL_SCREENHEIGHT = Height;
	return;

	/*
	MEMORYSTATUS lpBuffer;
	GlobalMemoryStatus(&lpBuffer);// memory status structure
	dwAvailPhysRamOnMachine = (lpBuffer.dwAvailPhys)/2;
	if (dwAvailPhysRamOnMachine > MAXMEMORYSIZE){
		lMAXMEMORYSIZE = dwAvailPhysRamOnMachine;
	}else{
		lMAXMEMORYSIZE = MAXMEMORYSIZE;
	}

	iGLOBAL_SCREENWIDTH = Width;
	iGLOBAL_SCREENHEIGHT = Height;


    iGLOBAL_SCREENBWIDE = iGLOBAL_SCREENWIDTH*(96/320);
	iG_SCREENWIDTH = iGLOBAL_SCREENWIDTH*(96/320);;// default screen width in bytes

	if (iGLOBAL_SCREENWIDTH == 320) {
		iGLOBAL_FOCALWIDTH = 160;
		dGLOBAL_FPFOCALWIDTH = 160.0; 
		iGLOBAL_HEALTH_X = 20;
		iGLOBAL_HEALTH_Y = 185;
		iGLOBAL_AMMO_X = 300;
		iGLOBAL_AMMO_Y = 184;

		dTopYZANGLELIMIT = (44*FINEANGLES/360);;
	}
	if (iGLOBAL_SCREENWIDTH == 640) {
		iGLOBAL_FOCALWIDTH = 180;
		dGLOBAL_FPFOCALWIDTH = 180.0 ;
		iGLOBAL_HEALTH_X = 40;//20*2;
		iGLOBAL_HEALTH_Y = 466;//(185*2)+16;
		iGLOBAL_AMMO_X = 600;//300*2;
		iGLOBAL_AMMO_Y = 466;//(184*2)+16;
		//lMAXMEMORYSIZE = MAXMEMORYSIZE*2;
		dTopYZANGLELIMIT = (42*FINEANGLES/360);;
	}
	if (iGLOBAL_SCREENWIDTH == 800) {
		iGLOBAL_FOCALWIDTH = 200;
		dGLOBAL_FPFOCALWIDTH = 200.0 ;
		iGLOBAL_HEALTH_X = 40;//20*2;
		iGLOBAL_HEALTH_Y = 585;//(185/200)*600;
		iGLOBAL_AMMO_X = 750;//(300/320)*800;
		iGLOBAL_AMMO_Y = 585;//(184/200)*600;
		//lMAXMEMORYSIZE = MAXMEMORYSIZE*3;	
		dTopYZANGLELIMIT = (90*FINEANGLES/360);;
	}
	if (iGLOBAL_SCREENWIDTH == 1024) {
		iGLOBAL_FOCALWIDTH = 220;
		dGLOBAL_FPFOCALWIDTH = 220.0 ;
		iGLOBAL_HEALTH_X = 40;//20*2;
		iGLOBAL_HEALTH_Y = 753;//(185/200)*600;
		iGLOBAL_AMMO_X = 750;//(300/320)*800;    
		iGLOBAL_AMMO_Y = 752;//(184/200)*600;
		//lMAXMEMORYSIZE = MAXMEMORYSIZE*4;	
		dTopYZANGLELIMIT = (90*FINEANGLES/360);;
	}
	//dYZANGLELIMIT = (12*FINEANGLES/360);
	//#define YZANGLELIMIT  (12*FINEANGLES/360)//bna--(30*FINEANGLES/360)

	//#define TopYZANGLELIMIT  (44*FINEANGLES/360)//bna added
*/
	GetCurrentDirectory(sizeof(ApogeePath),ApogeePath);// curent directory name

}


#include <wingdi.h>

//----------------------------------------------------------------------
void CreateAllChildWindows (HWND hwnd)
{
	int			yoff = 70;
	TCHAR    tmp[MAX_PATH];
	TCHAR    buf[MAX_PATH]; 
	HGDIOBJ		font;
	HBITMAP  hbmpBG = LoadBitmap((HINSTANCE)GetWindowLong(hwnd, GWL_HINSTANCE), MAKEINTRESOURCE(IDB_BITMAP2)); 
	HBITMAP  hbmpBG1 = LoadBitmap((HINSTANCE)GetWindowLong(hwnd, GWL_HINSTANCE), MAKEINTRESOURCE(IDB_BITMAP3)); 

	HDC res = CreateCompatibleDC(NULL);

	HGDIOBJ old2 = (HBITMAP)SelectObject(res, hbmpBG);

	SetBkMode(res, TRANSPARENT);
	SetTextColor(res, 0x0000FFFF);//yellow color
	HFONT hFont = CreateFont(17, 0, 0, 0, FW_MEDIUM, 0, 0, 0, 0, 0, 0, 2, 0, "Courier New");
	HFONT hTmp = (HFONT)SelectObject(res, hFont);
	//write yellow text on top af triad logo background
	TextOut(res, 12, 324,  "Resolution",11);
	TextOut(res, 207, 324, "Alternate Battle Levels:", 25);
	TextOut(res, 442, 324, "Alternate Game Levels:", 23);
	TextOut(res, 12, 374,  "Parameters:", 12);
	TextOut(res, 439, 392, "Multiplayer game:", 18);

	// get our bmp back
	hbmpBG = (HBITMAP)SelectObject(res, old2);

	// clean up dcs
	DeleteDC(res);

	hwndBG = CreateWindow("STATIC","" ,SS_BITMAP|WS_VISIBLE | WS_CHILD ,
		0,0,     // starting x position and starting y position     
		180,20,    // button width     
		hwnd,       // parent window     
		NULL,   // No menu (identifier)
		(HINSTANCE) GetWindowLong(hwnd, GWL_HINSTANCE), 
		NULL);      // pointer not needed 
	SendMessage( hwndBG, STM_SETIMAGE, IMAGE_BITMAP, (LPARAM) hbmpBG );


	hwndBG = CreateWindow("STATIC","" ,SS_BITMAP|WS_VISIBLE | WS_CHILD ,
		10,430,     // starting x position and starting y position     
		180,20,    // button width     
		hwnd,       // parent window     
		NULL,   // No menu (identifier)
		(HINSTANCE) GetWindowLong(hwnd, GWL_HINSTANCE), 
		NULL);      // pointer not needed 
	SendMessage( hwndBG, STM_SETIMAGE, IMAGE_BITMAP, (LPARAM) hbmpBG1 );


	hwndBG = CreateWindow("STATIC","" ,SS_BITMAP|WS_VISIBLE | WS_CHILD ,
		0,0,     // starting x position and starting y position     
		180,20,    // button width     
		hwnd,       // parent window     
		NULL,   // No menu (identifier)
		(HINSTANCE) GetWindowLong(hwnd, GWL_HINSTANCE), 
		NULL);      // pointer not needed 

	hwndCB1 = CreateWindow("COMBOBOX","",WS_VISIBLE |WS_VSCROLL| WS_CHILD|CBS_DROPDOWNLIST  ,
		10, yoff+270,     // starting x position and starting y position     
		178,160,    // button width     
		hwnd,       // parent window     
		(HMENU)IDM_CB1,   // No menu (identifier)
		(HINSTANCE) GetWindowLong(hwnd, GWL_HINSTANCE), 
		NULL);      // pointer not needed 
		// set first item in the connections combo box
	SendMessage(hwndCB1, CB_ADDSTRING, 0, (LPARAM) "320 x 200" );
	SendMessage(hwndCB1, CB_ADDSTRING, 0, (LPARAM) "640 x 480" );
	SendMessage(hwndCB1, CB_ADDSTRING, 0, (LPARAM) "800 x 600" );
	SendMessage(hwndCB1, CB_ADDSTRING, 0, (LPARAM) "1024 x 768" );
	SendMessage(hwndCB1, CB_ADDSTRING, 0, (LPARAM) "1152 x 864" );	
	SendMessage(hwndCB1, CB_ADDSTRING, 0, (LPARAM) "1280 x 1024" );	
	SendMessage(hwndCB1, CB_ADDSTRING, 0, (LPARAM) "1680 x 1050 (16:10)");
	//16801050
    SendMessage(hwndCB1, CB_ADDSTRING, 0, (LPARAM) "1920 x 1080 WideScreen)" );     //<---ADAM***
	if (GetStrFromRegdb ("Res",(LPSTR)&tmp,"2") != -1){
		LastScreenRes = atoi(tmp);
	}else{
		LastScreenRes = 2;
	}
	if (LastScreenRes == 0) {SetRottScreenRes (320, 200);}
	if (LastScreenRes == 1) {SetRottScreenRes (640, 480);}
	if (LastScreenRes == 2) {SetRottScreenRes (800, 600);}
	if (LastScreenRes == 3) {SetRottScreenRes (1024, 768);}
	if (LastScreenRes == 4) {SetRottScreenRes (1152, 864);}
	if (LastScreenRes == 5) {SetRottScreenRes (1280, 1024);}
	if (LastScreenRes == 6) { SetRottScreenRes(1680, 1050); }
    if (LastScreenRes == 7) {SetRottScreenRes (1920, 1080);}   //<--ADAM***

	SendMessage(hwndCB1, CB_SETITEMDATA, LastScreenRes, (LPARAM) 0 );
	SendMessage(hwndCB1, CB_SETCURSEL, LastScreenRes, (LPARAM) 0 );


	hwndCB2 = CreateWindow("COMBOBOX","",WS_VISIBLE |WS_VSCROLL| 
		WS_CHILD|CBS_DROPDOWNLIST   ,
		204, yoff+270,     // starting x position and starting y position     
		220,110,    // button width     
		hwnd,       // parent window     
		(HMENU)IDM_CB2,   // No menu (identifier)
		(HINSTANCE) GetWindowLong(hwnd, GWL_HINSTANCE), 
		NULL);      // pointer not needed 
	FindRTLFilenames(hwndCB2,"RT");
#if (SHAREWARE == 1)
		EnableWindow(hwndCB2,FALSE);
#endif
 
	hwndCB3 = CreateWindow("COMBOBOX","",WS_VISIBLE|WS_VSCROLL|
		WS_CHILD |CBS_DROPDOWNLIST|WS_BORDER  ,
		440, yoff+270,     // starting x position and starting y position     
		220,110,    // button width     
		hwnd,       // parent window     
		(HMENU)IDM_CB3,   // No menu (identifier)
		(HINSTANCE) GetWindowLong(hwnd, GWL_HINSTANCE), 
		NULL);      // pointer not needed 
	FindRTLFilenames(hwndCB3,"RTL");
#if (SHAREWARE == 1)
		EnableWindow(hwndCB3,FALSE);
#endif




	hwndParaEdit = CreateWindow("EDIT","",WS_VISIBLE | WS_CHILD |WS_BORDER|ES_AUTOHSCROLL| ES_WANTRETURN|ES_MULTILINE  ,
		10,yoff+320,     // starting x position and starting y position     
		364,20,    // button width     
		hwnd,       // parent window     
		(HMENU)IDM_PARAMETER_EDIT,   // No menu (identifier)
		(HINSTANCE) GetWindowLong(hwnd, GWL_HINSTANCE), 
		NULL);      // pointer not needed 

	if (bStoreParameters == TRUE){
		GetWindowText(hwndParaEdit ,buf,MAX_PATH);
		GetStrFromRegdb ("Parameters",tmp,"");
		if(buf[0] != 0){
			lstrcat(buf," ");
		}
		lstrcat(buf,tmp);
		SetWindowText(hwndParaEdit,buf);
	}

	hWndList = CreateWindowEx(0L, "LISTBOX","",
		  LBS_NOTIFY | WS_BORDER | WS_VSCROLL |LBS_DISABLENOSCROLL | LBS_USETABSTOPS | WS_CHILD | WS_VISIBLE,
		  10, yoff+30,
		  650, 220,
		  (HWND)hwnd,
		  NULL,
		  hInst, 
		  NULL );
	hwndButtonRunRott = CreateWindow("BUTTON","Run WinRottGL ",WS_VISIBLE | WS_CHILD ,
		400, yoff+380,     // starting x position and starting y position     
		120,25,    // button width     
		hwnd,       // parent window     
		(HMENU)IDM_RUNROTT,   // No menu (identifier)
		(HINSTANCE) GetWindowLong(hwnd, GWL_HINSTANCE), 
		NULL);      // pointer not needed 
	hwndButtonExit = CreateWindow("BUTTON","Exit",WS_VISIBLE | WS_CHILD ,
	    520+22,yoff+380,     // starting x position and starting y position     
		120,25,    // button width      
		hwnd,       // parent window     
		(HMENU)IDM_EXIT,   // No menu (identifier)
		(HINSTANCE) GetWindowLong(hwnd, GWL_HINSTANCE), 
		NULL);      // pointer not needed 
    //-------------------------------------------------------------------------
	/*
	hwndStatic = CreateWindow("STATIC","Resolution:",WS_VISIBLE | WS_CHILD ,
		10,yoff+310,     // starting x position and starting y position     
		180,20,    // button width     
		hwnd,       // parent window     
		NULL,   // No menu (identifier)
		(HINSTANCE) GetWindowLong(hwnd, GWL_HINSTANCE), 
		NULL);      // pointer not needed 
*/
	
	hwndResNet = CreateWindow("BUTTON","",WS_VISIBLE | WS_CHILD |BS_CHECKBOX ,
		420,yoff+324,     // starting x position and starting y position     
		14,14,    // button width     
		hwnd,       // parent window     
		(HMENU)IDM_CHECKNETPLAY,   // No menu (identifier)
		(HINSTANCE) GetWindowLong(hwnd, GWL_HINSTANCE), 
		NULL);      // pointer not needed 

    //-------------------------------------------------------------------------
	/*
	hwndStatic1 = CreateWindow("STATIC","Rott Parameters:",WS_VISIBLE | WS_CHILD ,
		10,yoff+342,     // starting x position and starting y position     
		180,20,    // button width     
		hwnd,       // parent window     
		NULL,   // No menu (identifier)
		(HINSTANCE) GetWindowLong(hwnd, GWL_HINSTANCE), 
		NULL);      // pointer not needed 
*/




	font = GetStockObject(ANSI_FIXED_FONT);
	SendMessage(hWndList,WM_SETFONT, (UINT)font, 0L);
	SendMessage(hwndButtonRunRott,WM_SETFONT, (UINT)font, 0L);
	SendMessage(hwndButtonExit,WM_SETFONT, (UINT)font, 0L);
	SendMessage(hwndStatic,WM_SETFONT, (UINT)font, 0L);
/*
	SendMessage(hwndRes320,WM_SETFONT, (UINT)font, 0L);
	SendMessage(hwndRes640,WM_SETFONT, (UINT)font, 0L);
	SendMessage(hwndRes800,WM_SETFONT, (UINT)font, 0L);
	SendMessage(hwndRes1024,WM_SETFONT, (UINT)font, 0L);
*/
	SendMessage(hwndStatic1,WM_SETFONT, (UINT)font, 0L);
	SendMessage(hwndParaEdit,WM_SETFONT, (UINT)font, 0L);

	SendMessage(hwndResNet,WM_SETFONT, (UINT)font, 0L);

	SendMessage(hwndCB1,WM_SETFONT, (UINT)font, 0L);
	SendMessage(hwndCB2,WM_SETFONT, (UINT)font, 0L);
	SendMessage(hwndCB3,WM_SETFONT, (UINT)font, 0L);

	GetStrFromRegdb ("SoundFix",tmp,"0");
	musfix = atol(tmp);



}
//----------------------------------------------------------------------
void WriteWinRottHelp (HWND hDlg)
{
//funny how I could not get "\n" to work

char  HelpTmp[] =

      "      Rise of the Triad  (c) 1995 Apogee Software## ##\
COMMAND LINE PARAMETERS:##\
      ##\
         SANTAHAT    - Sets christmas mode.##\
         SOMBRERO    - Sets cinco de mayo mode.##\
         AMFLAG      - Sets 4th of july mode.##         WITCHHAT    - Sets halloween mode.##         ESTERHAT    - Sets easter mode.##\
         FILERTL     - Used to load Userlevels (RTL files)##\
                     - next parameter is RTL filename##\
         FILERTC     - Used to load Battlelevels (RTC files)##\
                     - next parameter is RTC filename##\
         FILE        - Used to load Extern WAD files##\
                     - next parameter is WAD filename##\
         NET         - Multiplayer NET 'IP' (klient).##\
         SERVER      - Multiplayer NET SERVER (server).##\
         SPACEBALL   - Enable check for Spaceball.##\
         NOJOYS      - Disable check for joystick.##\
         NOMOUSE     - Disable check for mouse.##\
         CYBERMAN    - Enable check for Cyberman.##\
         ASSASSIN    - Enable check for Wingman Assassin.##\
         VER         - Version number.##\
         MAPSTATS    - Dump Map statistics to ERROR.##\
         TILESTATS   - Dump Tile statistics to ERROR.##\
         MONO        - Enable mono-monitor support.##\
         SCREENSHOTS - Clean screen capture for shots.##\
         PAUSE       - Pauses startup screen information.##\
         SOUNDSETUP  - Setup sound for ROTT##\
         ENABLEVR    - Enable VR helmet input devices##\
         NOECHO      - Turn off sound reverb##\
         DEMOEXIT    - Exit program when demo is terminated##\
         WARP        - Warp to specific ROTT level##\
                       next paramater is level to start on##\
         TIMELIMIT   - Play ROTT in time limit mode##\
                       next paramater is time in seconds##\
         MAXTIMELIMIT- Maximimum time to count down from##\
                       next paramater is time in seconds##\
         DOPEFISH    - ?##"
		 " ##"
		 "CONTROLS##"
		 "         Arrows           - Move##"
		 "         Ctrl             - Fire##"
		 "         Comma/Alt+left   - Sidestep Left##"
		 "         Period/Alt+right - Sidestep Right##"
		 "         Shift            - Run/Turn faster##"
		 "         Space            - Use/Open##"
		 "         1-4              - Choose Weapon##"
		 "         5-6              - Scale Weapon Up/Down##"
		 "         Enter            - Swap Weapon##"
		 "         Backspace        - Turn 180##"
		 "         Delete           - Drop Weapon##"
		 "         +/-              - Change Viewsize##"
		 "         PgUp/PgDn        - Look Up/Down##"
		 "         Home/End         - Aim Up/Down##"
		 "         [ ]              - Sound Volumen##"
		 "         ( )              - Music Volumen##"
		 "         Tab              - Enter Automapper##"
		 " ##"
		 "AUTO-MAPPER##"
		 "         Arrows           - Scroll around##"
		 "         PgUp             - Zoom Out##"
		 "         PgDn             - Zoom In##"
		 "         Tab              - Exit Auto-Mapper##"
		 " ##"
		 "HOTKEYS##"
		 "         F1               - Help##"
		 "         F2               - Save Game##"
		 "         F3               - Restore Game##"
		 "         F4               - Controls/Sound/Music##"
		 "         F5               - Change Detail Level##"
		 "         F6               - Quick Save##"
		 "         F7               - Messages On/Off##"
		 "         F8               - End Game##"
		 "         F9               - Quick Load##"
		 "         F10              - Quit##"
		 "         F11              - Gamma Correction##"
		 " ##"
		 "COMM-BAT##"
		 "         F1 - F10         - RemoteRidicule(tm) sounds##"
		 "         F12              - Live RemoteRidicule/Load RTL map##"
		 "         T                - Type message to all##"
		 "         Z                - Type directed message##"
		 "         Tab              - Toggle KillCount display##"
		 " ##"
		 "SCREENSHOOT##"
		 "         Alt+G            - Screenshoot in GIF format##"
		 "         Alt+C            - Screenshoot in BMP format##"
		 "         Alt+V            - Screenshoot in PCX format##"
		 "DEMO##"
		 "         Alt+R            - Starts demo recording##"
		 "         Alt+E            - Ends a demo recording##"
		 "         Alt+D            - Plays a demo recording##"		 
		 "OTHER##"
		 "         Alt+K            - Toggle EKG mode##"
		 "         Alt+A            - Toggle Auto aim##" 	
		 "         Alt+H            - Toggle HUD mode##"
		 "         Alt+Q+L          - Restart Level##" ;	

	int i;
	HGDIOBJ font = GetStockObject(ANSI_FIXED_FONT);
	SendMessage(GetDlgItem(hDlg,IDC_EDIT1),WM_SETFONT, (UINT)font, 0L);
	SendMessage(GetDlgItem(hDlg,IDOK),WM_SETFONT, (UINT)font, 0L);
	for (i=0;i<sizeof(HelpTmp);i++) {//change newline mannuely
		if (HelpTmp[i] == '#') {
			HelpTmp[i++] = 13;
			HelpTmp[i++] = 10;
		}
	}

    SendMessage(GetDlgItem(hDlg,IDC_EDIT1), WM_SETTEXT, 0, (LPARAM) HelpTmp); 
}

/*

// some of next sections code is stolen from windoom by Bruce A. Lewis.
HWND hWndsound;
// Local define needed only for error message capture and display
#define     MCIMSGLEN  128
char        MidiMsg[MCIMSGLEN+1];
//#include <mmsystem.h>
//----------------------------------------------------------------------
BOOL MidiPlay(HWND hWnd, MIDI_Data_t *mdd)
{
    MCI_OPEN_PARMS     open;
    MCI_PLAY_PARMS     play;
    MCIERROR           MCI_Error;
    UINT               uDeviceId;
	return;
    hWndsound = hWnd;

	if (access(mdd->szMidiFile, 4) != 0)
	{
        mdd->MidiStatus = midi_nofile;
        return(FALSE);
	}

    open.dwCallback       = (DWORD)hWnd;
    open.lpstrDeviceType  = "sequencer";
    open.lpstrElementName = mdd->szMidiFile;

    MCI_Error = mciSendCommand(0, MCI_OPEN, MCI_OPEN_TYPE | MCI_OPEN_ELEMENT, (DWORD)&open);

//

    if (MCI_Error)
	{
        mciGetErrorString(MCI_Error, MidiMsg, MCIMSGLEN);
        MessageBox(hWnd, MidiMsg, NULL, MB_ICONSTOP | MB_OK);
        mdd->MidiError = MCI_Error;
        return(FALSE);
	}

    // play back midi file
    //......................
	uDeviceId = open.wDeviceID;
    play.dwCallback = (DWORD)hWnd;

	G_MidiData.MidiDevice = uDeviceId;	
	G_MidiData.MidiError  = mdd->MidiError ;
	G_MidiData.MidiPosition  = mdd->MidiPosition ;
	G_MidiData.MidiStatus  = mdd->MidiStatus ;
	strcpy(G_MidiData.szMidiFile,mdd->szMidiFile) ;

//SetTextMode (  );

                
    MCI_Error = mciSendCommand(uDeviceId, MCI_PLAY, MCI_NOTIFY, (DWORD)&play);
    if (MCI_Error)
	{
        mciGetErrorString(MCI_Error, MidiMsg, MCIMSGLEN);
        MessageBox(hWnd, MidiMsg, NULL, MB_ICONSTOP | MB_OK);
        mciSendCommand(uDeviceId, MCI_CLOSE, 0, (DWORD)NULL);
        mdd->MidiError = MCI_Error;
        return(FALSE);
	}
    mdd->MidiDevice = uDeviceId;
    mdd->MidiStatus = midi_play;

	

    return(TRUE);
}  //midiplay


//----------------------------------------------------------------------
int MIDI_StoreSongPosition()
{
    MCI_STATUS_PARMS   status;
    MCIERROR           MCI_Error;
	MCI_SET_PARMS      set;
	return;
    MidiData.MidiError = 0;
    set.dwTimeFormat   = MCI_FORMAT_MILLISECONDS;
    mciSendCommand(MidiData.MidiDevice, MCI_SET, MCI_SET_TIME_FORMAT, (DWORD)(LPVOID)&set);

    status.dwCallback  = (DWORD)hMainWnd;
    status.dwItem = MCI_STATUS_POSITION  ;
	status.dwTrack = 0;

    MCI_Error = mciSendCommand(MidiData.MidiDevice, MCI_STATUS, MCI_STATUS_ITEM, (DWORD)&status);
	return status.dwReturn; 
}
//----------------------------------------------------------------------
int MIDI_GetSongLenMS()
{
    MCI_STATUS_PARMS   status;
    MCIERROR           MCI_Error;
	MCI_SET_PARMS      set;
	return;
    MidiData.MidiError = 0;
    set.dwTimeFormat   = MCI_FORMAT_MILLISECONDS;
    mciSendCommand(MidiData.MidiDevice, MCI_SET, MCI_SET_TIME_FORMAT, (DWORD)(LPVOID)&set);

    status.dwCallback  = (DWORD)hMainWnd;
    status.dwItem = MCI_STATUS_LENGTH   ;
	status.dwTrack = 0;

    MCI_Error = mciSendCommand(MidiData.MidiDevice, MCI_STATUS, MCI_STATUS_ITEM, (DWORD)&status);
	return status.dwReturn; 
}
//----------------------------------------------------------------------
void MIDI_RestoreSongPosition(int storedposition)
{	return;
	MidiData.MidiPosition = storedposition;
	MidiResume(hMainWnd, &MidiData);
}
//----------------------------------------------------------------------
BOOL MidiPlayMEM(HWND hWnd, MIDI_Data_t *mdd)
{	return;
	MidiReplay(hWnd,  mdd);
	return 0;
}
//----------------------------------------------------------------------
BOOL MidiReplay(HWND hWnd, MIDI_Data_t *mdd)
   {
    MCI_PLAY_PARMS     play;
    MCIERROR           MCI_Error;
	return;
    play.dwCallback = (DWORD)hWnd;
    play.dwFrom = 0;

//	mdd->MidiDevice = G_MidiData.MidiDevice ;
//	mdd->MidiError  = G_MidiData.MidiError ;
//	mdd->MidiPosition = G_MidiData.MidiPosition ;
//	mdd->MidiStatus  = G_MidiData.MidiStatus  ;
//	lstrcpy(mdd->szMidiFile  ,G_MidiData.szMidiFile ) ;
                           
    MCI_Error = mciSendCommand(mdd->MidiDevice, MCI_PLAY, MCI_NOTIFY | MCI_FROM, (DWORD)&play);
    if (MCI_Error)
       { SetTextMode (  );
        mciGetErrorString(MCI_Error, MidiMsg, MCIMSGLEN);
        MessageBox(hWnd, MidiMsg, NULL, MB_ICONSTOP | MB_OK);
        return(FALSE);
       }
    return(TRUE);
   }
//----------------------------------------------------------------------
BOOL MidiPause(HWND hWnd, MIDI_Data_t *mdd)
   {
    MCI_SET_PARMS      set;
    MCI_STATUS_PARMS   status;
    MCIERROR           MCI_Error;
	return;
    mdd->MidiError = 0;
    set.dwTimeFormat   = MCI_FORMAT_MILLISECONDS;
    mciSendCommand(mdd->MidiDevice, MCI_SET, MCI_SET_TIME_FORMAT, (DWORD)(LPVOID)&set);

    status.dwCallback  = (DWORD)hWnd;
    status.dwItem = MCI_STATUS_POSITION;

    MCI_Error = mciSendCommand(mdd->MidiDevice, MCI_STATUS, MCI_STATUS_ITEM, (DWORD)&status);
    if (MCI_Error)
       {
        mciGetErrorString(MCI_Error, MidiMsg, MCIMSGLEN);
        strcat(MidiMsg, "\nMidiPause");
        MessageBox(hWnd, MidiMsg, NULL, MB_ICONSTOP | MB_OK);
        mdd->MidiError = MCI_Error;
        return(FALSE);
       }
    mdd->MidiPosition = status.dwReturn;
    mciSendCommand(mdd->MidiDevice, MCI_STOP, 0, (DWORD)NULL);
    mdd->MidiStatus = midi_pause;
    return(TRUE);
   }
//----------------------------------------------------------------------
BOOL MidiResume(HWND hWnd, MIDI_Data_t *mdd)
   {
    MCI_SET_PARMS      set;
    MCI_PLAY_PARMS     play;
    MCIERROR           MCI_Error;
	return;
    mdd->MidiError = 0;
    set.dwTimeFormat   = MCI_FORMAT_MILLISECONDS;
    mciSendCommand(mdd->MidiDevice, MCI_SET, MCI_SET_TIME_FORMAT, (DWORD)(LPVOID) &set);

    play.dwCallback = (DWORD)hWnd;
    play.dwTo = 0;
    play.dwFrom = mdd->MidiPosition;
    MCI_Error = mciSendCommand(mdd->MidiDevice, MCI_PLAY, MCI_NOTIFY | MCI_FROM, (DWORD)(LPVOID)&play);
    if (MCI_Error)
       {
        mciGetErrorString(MCI_Error, MidiMsg, MCIMSGLEN);
        strcat(MidiMsg, "\nMidiResume");
        MessageBox(hWnd, MidiMsg, NULL, MB_ICONSTOP | MB_OK);
        mdd->MidiError = MCI_Error;
        return(FALSE);
       }
    mdd->MidiStatus = midi_play;
    return(TRUE);
   }
//----------------------------------------------------------------------
void MidiStop(MIDI_Data_t *mdd)
   {	return;
    mciSendCommand(mdd->MidiDevice, MCI_STOP, 0, (DWORD)NULL);
    mciSendCommand(mdd->MidiDevice, MCI_CLOSE, 0, (DWORD)NULL);
    mdd->MidiStatus = midi_stop;
   }

//----------------------------------------------------------------------
int IsROTTMidiPlaying()
{	return;
	if ( MidiData.MidiStatus == midi_play) {
		return TRUE;
	}else{
		return FALSE;
	}
}
//----------------------------------------------------------------------
extern int MidiTimeMScount;
int PlayROTTMidiFile(char *song, boolean loop)
{ 

		// get DirectMusic up and running
		InitDirectMusic ();
		// load our demo MIDI
		LoadMIDIfile("rottsong.mid");
		// now play it
		StartMidiMusic (TRUE);
		return;


	NbOfROTTMidiFilePlayed++;
	strcpy(MidiData.szMidiFile, song)	;
	//strcpy(G_MidiData.szMidiFile, song);	
    MidiPlay(hMainWnd, &MidiData);

	MidiSongLen = MIDI_GetSongLenMS();
	MidiTimeMScount = 0;
	return 0;
}
void PlayMemSong()
{	//PlayROTTMidiFile("rottsong.mid",0);
	return;
	MIDI_RestoreSongPosition(0);
	//MidiPlayMEM(hMainWnd, &MidiData);
}

void CheckForRestartMIDI()
{	return;
	if (MidiTimeMScount==0){
		MidiTimeMScount=GetTickCount()+MidiSongLen-((MidiSongLen/100)*12);
	}
	if (GetTickCount()>MidiTimeMScount){
		MIDI_RestoreSongPosition(0);
		MidiTimeMScount=GetTickCount()+MidiSongLen-((MidiSongLen/100)*12);
	}

}
//----------------------------------------------------------------------
void PlayMidiMusic()
   {	return;
    if ((MidiData.MidiStatus != midi_play) && (MidiData.MidiStatus != midi_pause))
       {
        MidiPlay(hMainWnd, &MidiData);
       }
   }

BOOL IsMusicPlaying ()
{	return;
	if (MidiData.MidiStatus == midi_play){
		return TRUE;
	}
	return FALSE;


}


//----------------------------------------------------------------------
void PauseResumeMusic()
   {	return;
    switch(MidiData.MidiStatus)
       {
        case midi_play:
             MidiPause(hMainWnd, &MidiData);
             break;
        case midi_pause:
             MidiResume(hMainWnd, &MidiData);
             break;
       }
  
   }
   /*
//----------------------------------------------------------------------
int StopMidiMusic()
{	return;
    if(MidiData.MidiStatus != midi_stop)
	{
		
        MidiStop(&MidiData);
		//MidiStop(&G_MidiData);
	}
	return 0;
}
//----------------------------------------------------------------------


long GetSetVolumeMidi (long newvol, int SetGetFLAG) // 0 = get  1 = set
{	
	// return = actuell midi value by get 
	int SoundScale = 255;


    MMRESULT rc;              // Return code.
    HMIXER hMixer;            // Mixer handle used in mixer API calls.
    MIXERCONTROL mxc;         // Holds the mixer control data.
    MIXERLINE mxl;            // Holds the mixer line data.
    MIXERLINECONTROLS mxlc;   // Obtains the mixer control.
	MIXERCONTROLDETAILS mxcd;             // Gets the control values.
    MIXERCONTROLDETAILS_SIGNED volStruct; // Gets the control values.
	long volume;                          // Holds the final volume value.


	SetMasterVol (1*newvol);
	return;

	// Open the mixer. This opens the mixer with a deviceID of 0. If you
    // have a single sound card/mixer, then this will open it. If you have
    // multiple sound cards/mixers, the deviceIDs will be 0, 1, 2, and
    // so on.    
	rc = mixerOpen(&hMixer, 0,0,0,0);
    if (MMSYSERR_NOERROR == rc) {        
		// Couldn't open the mixer. 
		//return 0;
	}

    // Initialize MIXERLINE structure.    
	ZeroMemory(&mxl,sizeof(mxl));
    mxl.cbStruct = sizeof(mxl);

    // Specify the line you want to get. You are getting the input line
    // here. If you want to get the output line, you need to use
    // MIXERLINE_COMPONENTTYPE_SRC_MIDIOUT.= 4100 = midi value
    mxl.dwComponentType = 4100;//MIXERLINE_COMPONENTTYPE_DST_WAVEIN;

    rc = mixerGetLineInfo((HMIXEROBJ)hMixer, &mxl,MIXER_GETLINEINFOF_COMPONENTTYPE);
    if (MMSYSERR_NOERROR == rc) {        
		// Couldn't get the mixer line. 
		//return 0;
	}

	// Get the control.    
	ZeroMemory(&mxlc, sizeof(mxlc));
    mxlc.cbStruct = sizeof(mxlc);    
	mxlc.dwLineID = mxl.dwLineID;
    mxlc.dwControlType = MIXERCONTROL_CONTROLTYPE_VOLUME;
    mxlc.cControls = 1;    
	mxlc.cbmxctrl = sizeof(mxc);   
	mxlc.pamxctrl = &mxc;
    ZeroMemory(&mxc, sizeof(mxc));    
	mxc.cbStruct = sizeof(mxc);
    rc = mixerGetLineControls((HMIXEROBJ)hMixer,&mxlc,MIXER_GETLINECONTROLSF_ONEBYTYPE);
    if (MMSYSERR_NOERROR == rc) {   
		// Couldn't get the control.
		//mixerClose(hMixer);
		//return 0;
	}
    // After successfully getting the dwControlType control, the volume range
    // will be specified by mxc.Bounds.lMinimum to mxc.Bounds.lMaximum.


	if (SetGetFLAG == 0) {  // caller wants a actuel sound value
		// Initialize the MIXERCONTROLDETAILS structure
		ZeroMemory(&mxcd, sizeof(mxcd));    
		mxcd.cbStruct = sizeof(mxcd);
		mxcd.cbDetails = sizeof(volStruct);    
		mxcd.dwControlID = mxc.dwControlID;
		mxcd.paDetails = &volStruct;   
		mxcd.cChannels = 1;
		// Get the current value of the dwControlType control. 
		rc = mixerGetControlDetails((HMIXEROBJ)hMixer, &mxcd,
                                 MIXER_GETCONTROLDETAILSF_VALUE);
		if (MMSYSERR_NOERROR == rc) {        
			// Couldn't get the current volume.
			//mixerClose(hMixer);
			//return 0;

	    }    
		volume = volStruct.lValue;    // Get the absolute value of the volume.
		if (volume < 0)        
			volume = -volume;
		mixerClose(hMixer);
		return (volume/SoundScale);
	}
	if (SetGetFLAG == 1) {  // caller wants to set sound value
	    // Initialize the MIXERCONTROLDETAILS structure
		ZeroMemory(&mxcd, sizeof(mxcd));    
		mxcd.cbStruct = sizeof(mxcd);
		mxcd.cbDetails = sizeof(volStruct);    
		mxcd.dwControlID = mxc.dwControlID;
		mxcd.paDetails = &volStruct;   
		mxcd.cChannels = 1;
		volStruct.lValue = (newvol*SoundScale);
		rc = mixerSetControlDetails((HMIXEROBJ)hMixer, &mxcd,
                                 MIXER_GETCONTROLDETAILSF_VALUE);

	}	
	
	mixerClose(hMixer);
	return 0;
	
}

//----------------------------------------------------------------------
/* unused bna++
// Plays a specified MIDI file by using MCI_OPEN and MCI_PLAY. Returns 
// as soon as playback begins. The window procedure function for the 
// specified window will be notified when playback is complete. 
// Returns 0L on success; otherwise, it returns an MCI error code.

DWORD playMIDIFile(HWND hWndNotify, LPSTR lpszMIDIFileName)
{
    UINT wDeviceID;
    DWORD dwReturn;
    MCI_OPEN_PARMS mciOpenParms;
    MCI_PLAY_PARMS mciPlayParms;
    MCI_STATUS_PARMS mciStatusParms;
    MCI_SEQ_SET_PARMS mciSeqSetParms;

    // Open the device by specifying the device and filename.
    // MCI will attempt to choose the MIDI mapper as the output port.
    mciOpenParms.lpstrDeviceType = "sequencer";
    mciOpenParms.lpstrElementName = lpszMIDIFileName;
    if (dwReturn = mciSendCommand(NULL, MCI_OPEN,
        MCI_OPEN_TYPE | MCI_OPEN_ELEMENT,
        (DWORD)(LPVOID) &mciOpenParms))
    {
        // Failed to open device. Don't close it; just return error.
        return (dwReturn);
    }

    // The device opened successfully; get the device ID.
    wDeviceID = mciOpenParms.wDeviceID;

    // Check if the output port is the MIDI mapper.
    mciStatusParms.dwItem = MCI_SEQ_STATUS_PORT;
    if (dwReturn = mciSendCommand(wDeviceID, MCI_STATUS, 
        MCI_STATUS_ITEM, (DWORD)(LPVOID) &mciStatusParms))
    {
        mciSendCommand(wDeviceID, MCI_CLOSE, 0, NULL);
        return (dwReturn);
    }

    // The output port is not the MIDI mapper. 
    // Ask if the user wants to continue.
    if (LOWORD(mciStatusParms.dwReturn) != MIDI_MAPPER)
    {
        if (MessageBox(hMainWnd,
            "The MIDI mapper is not available. Continue?",
            "", MB_YESNO) == IDNO)
        {
            // User does not want to continue. Not an error;
            // just close the device and return.
            mciSendCommand(wDeviceID, MCI_CLOSE, 0, NULL);
            return (0L);
        }
    }

    // Begin playback. The window procedure function for the parent 
    // window will be notified with an MM_MCINOTIFY message when 
    // playback is complete. At this time, the window procedure closes 
    // the device.
    mciPlayParms.dwCallback = (DWORD) hWndNotify;
    if (dwReturn = mciSendCommand(wDeviceID, MCI_PLAY, MCI_NOTIFY, 
        (DWORD)(LPVOID) &mciPlayParms))
    {
        mciSendCommand(wDeviceID, MCI_CLOSE, 0, NULL);
        return (dwReturn);
    }

    return (0L);
}
*/ 
//----------------------------------------------------------------------
/* unused bna
// Plays a specified waveform-audio file using MCI_OPEN and MCI_PLAY. 
// Returns when playback begins. Returns 0L on success, otherwise 
// returns an MCI error code.
DWORD playWAVEFile(HWND hWndNotify, LPSTR lpszWAVEFileName)
{   
	UINT wDeviceID;
    DWORD dwReturn;    
	MCI_OPEN_PARMS mciOpenParms;
    MCI_PLAY_PARMS mciPlayParms;
    // Open the device by specifying the device and filename.
    // MCI will choose a device capable of playing the specified file.
    mciOpenParms.lpstrDeviceType = "waveaudio";
    mciOpenParms.lpstrElementName = lpszWAVEFileName;
    if (dwReturn = mciSendCommand(0, MCI_OPEN,
       MCI_OPEN_TYPE | MCI_OPEN_ELEMENT,        
	   (DWORD)(LPVOID) &mciOpenParms))
    {        
		// Failed to open device. Don't close it; just return error.
        return (dwReturn);    
	}
    // The device opened successfully; get the device ID.
    wDeviceID = mciOpenParms.wDeviceID;
    // Begin playback. The window procedure function for the parent 
    // window will be notified with an MM_MCINOTIFY message when 
    // playback is complete. At this time, the window procedure closes 
    // the device.    mciPlayParms.dwCallback = (DWORD) hWndNotify;
    if (dwReturn = mciSendCommand(wDeviceID, MCI_PLAY, MCI_NOTIFY, 
        (DWORD)(LPVOID) &mciPlayParms))    {
        mciSendCommand(wDeviceID, MCI_CLOSE, 0, NULL);        
		return (dwReturn);
    }    
	return (0L);
}
*/
//----------------------------------------------------------------------
extern HRESULT	ConnectUsingLobby(LPDPLAYINFO lpDPInfo);

HRESULT SetupConnection(HINSTANCE hInstance, LPDPLAYINFO lpDPInfo)
{
	HRESULT		hr;
/*
	if (lpDPInfo != 0){
		ZeroMemory(lpDPInfo, sizeof(DPLAYINFO));
	}

	// create event used by DirectPlay to signal a message has arrived
	lpDPInfo->hPlayerEvent = CreateEvent(NULL,		// no security
										 FALSE,		// auto reset
										 FALSE,		// initial event reset
										 NULL);		// no name
	if (lpDPInfo->hPlayerEvent == NULL)
	{
		hr = DPERR_NOMEMORY;
		goto FAILURE;
	}

	// create event used to signal that the receive thread should exit
	ghKillReceiveEvent = CreateEvent(NULL,		// no security
									 FALSE,		// auto reset
									 FALSE,		// initial event reset
									 NULL);		// no name
	if (ghKillReceiveEvent == NULL)
	{
		hr = DPERR_NOMEMORY;
		goto FAILURE;
	}

	// create thread to receive player messages
	ghReceiveThread = CreateThread(NULL,			// default security
								   0,				// default stack size
								   ReceiveThread,	// pointer to thread routine
								   lpDPInfo,		// argument for thread
								   0,				// start it right away
								   &gidReceiveThread);
	if (ghReceiveThread == NULL)
	{
		hr = DPERR_NOMEMORY;
		goto FAILURE;
	}
*/
	// try to connect using the lobby
	//hr = CUL(lpDPInfo);
	//if FAILED(hr)
	//{
		// if the error returned is DPERR_NOTLOBBIED, that means we
		// were not launched by a lobby and we should ask the user for
		// connection settings. If any other error is returned it means
		// we were launched by a lobby but there was an error making the
		// connection.

		//if (hr != DPERR_NOTLOBBIED)
		//	ErrorBox("Could not connect using lobby because of error 0x%08X", hr);

		// if there is no lobby connection, ask the user for settings
		//hr = ConnectUsingDialog(hInstance, lpDPInfo);
		hr = CUDialog(hInstance, lpDPInfo);
		if FAILED(hr)
			goto FAILURE;
	//}

	G_lpDPInfo = lpDPInfo;
	return (DP_OK);	

FAILURE:
	ShutdownConnection(lpDPInfo);

	return (hr);
}
/*
DWORD WINAPI ReceiveThread(LPVOID lpThreadParameter)
{
    LPDPLAYINFO	lpDPInfo = (LPDPLAYINFO) lpThreadParameter;
	HANDLE		eventHandles[2];

	eventHandles[0] = lpDPInfo->hPlayerEvent;
	eventHandles[1] = ghKillReceiveEvent;

	// loop waiting for player events. If the kill event is signaled
	// the thread will exit
	while (WaitForMultipleObjects(2, eventHandles, FALSE, INFINITE) == WAIT_OBJECT_0)
	{
		// receive any messages in the queue
		PACKET_WAITING_FLAG = 1;;
	}

	ExitThread(0);

	return (0);
}
*/
//----------------------------------------------------------------------
void ErrorBox(LPSTR lpszErrorStr, HRESULT hr)
{
	char	szStr[512];

	wsprintf(szStr, lpszErrorStr, hr);

	SetTextMode ();
	MessageBox(NULL, szStr, "Error", MB_OK);
	ExitWinRott();
	exit(0);
}
//----------------------------------------------------------------------





int SetupDPConn()
{	
	HGLOBAL bm;
	HRESULT		hr;
    static LPDPLAYINFO	lpDPInfo = 0;
	// Initialize COM library
	hr = CoInitialize(NULL);
	// setup the connection

	bm = GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,sizeof (LPDPLAYINFO)*10);//bna++ 1.76
	//bm = HEAP_getheapmem(sizeof (LPDPLAYINFO));


	lpDPInfo = bm;

	hr = SetupConnection(hInst, lpDPInfo);
	/*
	if (bUseDirectUDP == 1){//client
		InitClientFTP_IP_socket (Remote2PComputerName,61000);
	}else if (bUseDirectUDP == 2){//server
		InitServerFTP_IP_socket ("",61000);
	}*/
	return 0;
}

 extern byte *surround;
//----------------------------------------------------------------------
void ExitWinRott()
{
	int i;

	if (surround != 0){
		ErrorDontQuit ("Unloaded sourround memory",0);
		//GlobalFree (surround);//release mem;
		HEAP_freemem (surround);//release mem;

	}
	//ErrorDontQuit ("Shutdown DirectDraw()",0);
	SetTextMode ();
//return;
	//ErrorDontQuit ("Shutdown DirectSound()",0);
	//ShutdownDirectSound();

	//ErrorDontQuit ("Shutdown DirectMusic()",0);
	//ShutdownDirectMusic ();

	//ErrorDontQuit ("Shutdown DirectPlay()",0);
//	ShutdownConnection(G_lpDPInfo);

#ifdef USESDLMOUSE 
	// use sdl mouse do nothing
#else
	//ErrorDontQuit ("Shutdown DirectInput",0);
	//CleanupInput();//clean up DirectInput mouse
#endif
	ErrorDontQuit ("GlobalUnlock(tmpPICbuf)",0);
	//GlobalFree(tmpPICbuf);
	HEAP_freemem(tmpPICbuf);

	//GlobalUnlock(tmpPICbuf);//release mem
 
	ErrorDontQuit ("GlobalUnlock(PICbuf)",0);
	//GlobalFree(PICbuf);
	HEAP_freemem(PICbuf);
	//GlobalUnlock(PICbuf);//release mem

	if (bUseExtWallSFX == TRUE){
		for (i=0;i<=75;i++){//release all hires wall mem
			if (WALLhiresptr[i] != 0){
				//GlobalFree(WALLhiresptr[i]);
				HEAP_freemem(WALLhiresptr[i]);
				//GlobalUnlock(WALLhiresptr[i]);
			}
		}
		ErrorDontQuit ("GlobalUnlock(HiResMem)",0);
	}

	ErrorDontQuit ("Enable Alt+Tab keys",0);
	UnregisterHotKey(hMainWnd, 0);
	UnregisterHotKey(hMainWnd, 1);
	UnregisterHotKey(hMainWnd, 2);
	UnregisterHotKey(hMainWnd, 3);

	LockSetForegroundWindow(LSFW_UNLOCK); // disable or enable calls
	ErrorDontQuit ("Winrott exits clean",0);


	ReleaseCapture();
	ExitProcess(0);

	exit(0);

}
/*
void DestroyDP()
{	
	ShutdownConnection(G_lpDPInfo);
}
*/
BOOL FindValidPathFilename  (char *filename)
{
	HWND  hWndDirLB;
	BOOL Recurse = TRUE;
	TCHAR Path[MAX_PATH];
	TCHAR RootPath[MAX_PATH];
	TCHAR RootDir[MAX_PATH];
	TCHAR Directory[MAX_PATH];
	WIN32_FIND_DATA FindData;
	HANDLE ffh;
	BOOL  retVal = TRUE;
//SetTextMode();
	lstrcpy(RootDir,ApogeePath);
	lstrcat(RootDir,"\\");

	// create a ListBox to store dir string 
    hWndDirLB = CreateWindowEx(0L,"LISTBOX", "", WS_CHILD ,-6000,-6000, 700, 200,hMainWnd,(HMENU)NULL,hInst,NULL);
	//add dummy message
	SendMessage(hWndDirLB, LB_ADDSTRING , 0, (LPARAM)"");
	while (SendMessage(hWndDirLB,LB_GETCOUNT,(WPARAM)0,(LPARAM) 0) > 0)
	{
		SendMessage(hWndDirLB,LB_GETTEXT,(WPARAM)0,(LPARAM) Directory);
		SendMessage(hWndDirLB,LB_DELETESTRING,(WPARAM)0,(LPARAM) Directory);

		lstrcpy (Path, Directory);
		lstrcat (Path, TEXT("*.*"));
		lstrcpy (RootPath, RootDir);
		lstrcat (RootPath, Path);
		ffh = FindFirstFile(RootPath, &FindData);
		if (ffh != INVALID_HANDLE_VALUE) {
			do {
				if (FindData.cFileName[0] != TEXT('.')) {
						if ((FindData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) == FILE_ATTRIBUTE_DIRECTORY)						
						{
							if (Recurse == TRUE) { 							
								lstrcpy (Path, Directory);
								lstrcat (Path, FindData.cFileName);
								lstrcat (Path, TEXT("\\"));
								SendMessage(hWndDirLB, LB_ADDSTRING , 0, (LPARAM)Path);
							}
						}else{
							if (lstrcmpi(FindData.cFileName,filename)==0){
								RootPath[lstrlen(RootPath)-3]=0;
								lstrcat (RootPath, filename);
								lstrcpy (filename, RootPath );
								retVal = TRUE;
								goto EscExit;
							}
						}
				}
			} while (FindNextFile(ffh, &FindData));
			FindClose(ffh);
		}
	}
	retVal = FALSE;

EscExit:

	DestroyWindow(hWndDirLB);

	return retVal;
}







	//GetStrFromRegdb ("Res",tmp,"2");
int GetStrFromRegdb (LPSTR Keyval, LPSTR strval, LPSTR defaultval) 
{
	HKEY   hKey;
	LONG   lResult;
	DWORD  dwRes=0;
	DWORD  dwSize    = sizeof(DWORD);
	DWORD  dwType    = REG_SZ;
    TCHAR  str[MAX_PATH];
    DWORD  type = REG_SZ, size = MAX_PATH;


	// outbox path osv from reg db
	// ------------------------------------------------------------------------------	

	//open the key
	lResult = RegOpenKeyEx( HKEY_CURRENT_USER,
							MAIN_ROTTKEY_STRING,
							0,
							KEY_ALL_ACCESS,
							&hKey);

	if(lResult != ERROR_SUCCESS){
		lResult = RegCreateKeyEx(HKEY_CURRENT_USER, MAIN_ROTTKEY_STRING, 0, 
                 0, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, 
                 0, &hKey, 0);
		if(lResult != ERROR_SUCCESS){
			return -1;
		}
		RegCloseKey(hKey);
		lstrcpy(strval,defaultval);
		SetStrInRegdb (Keyval, strval, defaultval);//3=800x600 

		return 1;
	}                                   
	            

    // Search for the desired registry value, and close the registry
    lResult = RegQueryValueEx(hKey, Keyval, NULL, &type, 
                             (BYTE*)str, &size);
	if(lResult != ERROR_SUCCESS){
		RegCloseKey(hKey);
		SetStrInRegdb (Keyval, defaultval, defaultval);//3=800x600 
		lstrcpy(strval,defaultval);
		return 1;
	}

	lstrcpy(strval,str);
	RegCloseKey(hKey);


	return 1;//atoi(str);

}
//---------------------------------------------------------------------------------

BOOL SetStrInRegdb  (LPSTR Keyval, LPSTR strval, LPSTR defaultval)  
{
	HKEY  hKey;
	LONG  lResult;
	DWORD dwRes   = 0;//res; 
	DWORD dwSize  = sizeof(DWORD);
	DWORD dwType  = REG_SZ;
	UCHAR szBuf[MAX_PATH];

	lstrcpy (szBuf,strval);
//	sprintf(szBuf,"%d",res);
	//open the key
	lResult = RegOpenKeyEx( HKEY_CURRENT_USER,
							MAIN_ROTTKEY_STRING,
							0,
							KEY_ALL_ACCESS,
							&hKey);

	if(lResult != ERROR_SUCCESS)
	   return FALSE;

	lResult = RegSetValueEx( hKey,
							   Keyval,
							   (DWORD)NULL,
							   REG_SZ,
							   (LPBYTE) &szBuf,
							   sizeof(szBuf));
	if(lResult != ERROR_SUCCESS){
		RegCloseKey(hKey);
		return FALSE;
	}

	RegCloseKey(hKey);
	return TRUE;
}


//long testval=4100;
long GetSetVolumeMidi (long newvol, int SetGetFLAG) // 0 = get  1 = set
{	/*
	// return = actuell midi value by get 
	int SoundScale = 255;
	    struct { 
        DWORD     dwType; 
        DWORD     dwDeviceID; 
        WORD      wMid; 
        WORD      wPid; 
        MMVERSION vDriverVersion; 
        CHAR      szPname[MAXPNAMELEN]; 
    } Target; 

    MMRESULT rc;              // Return code.
    HMIXER hMixer;            // Mixer handle used in mixer API calls.
    MIXERCONTROL mxc;         // Holds the mixer control data.
    MIXERLINE mxl;            // Holds the mixer line data.
    MIXERLINECONTROLS mxlc;   // Obtains the mixer control.
	MIXERCONTROLDETAILS mxcd;             // Gets the control values.
    MIXERCONTROLDETAILS_SIGNED volStruct; // Gets the control values.
	long volume;                          // Holds the final volume value.

	// Open the mixer. This opens the mixer with a deviceID of 0. If you
    // have a single sound card/mixer, then this will open it. If you have
    // multiple sound cards/mixers, the deviceIDs will be 0, 1, 2, and
    // so on.    

	ErrorDontQuit("kj=",testval);
	rc = mixerOpen(&hMixer, 0,0,0,0);
    if (MMSYSERR_NOERROR == rc) {        
		// Couldn't open the mixer. 
		//return 0;
	}

    // Initialize MIXERLINE structure.    
	ZeroMemory(&mxl,sizeof(mxl));
    mxl.cbStruct = sizeof(mxl);

    // Specify the line you want to get. You are getting the input line
    // here. If you want to get the output line, you need to use
    // MIXERLINE_COMPONENTTYPE_SRC_MIDIOUT.= 4100 = midi value
    mxl.dwComponentType = 4100;//MIXERLINE_COMPONENTTYPE_DST_WAVEIN;
//mxl.dwComponentType = MIXERLINE_COMPONENTTYPE_SRC_SYNTHESIZER;
//mxl.dwComponentType = MIXERLINE_COMPONENTTYPE_DST_WAVEIN;
//mxl.dwComponentType = testval++;
//mxl.dwComponentType = MIXERLINE_COMPONENTTYPE_SRC_SYNTHESIZER|MIXERLINE_COMPONENTTYPE_SRC_WAVEOUT  ;
//mxl.Target.dwType = MIXERLINE_TARGETTYPE_MIDIOUT ;
    rc = mixerGetLineInfo((HMIXEROBJ)hMixer, &mxl,MIXER_GETLINEINFOF_COMPONENTTYPE);
    if (MMSYSERR_NOERROR == rc) {        
		// Couldn't get the mixer line. 
		//return 0;
	}

	// Get the control.    
	ZeroMemory(&mxlc, sizeof(mxlc));
    mxlc.cbStruct = sizeof(mxlc);    
	mxlc.dwLineID = mxl.dwLineID;
    mxlc.dwControlType = MIXERCONTROL_CONTROLTYPE_VOLUME;
    mxlc.cControls = 1;    
	mxlc.cbmxctrl = sizeof(mxc);   
	mxlc.pamxctrl = &mxc;
    ZeroMemory(&mxc, sizeof(mxc));    
	mxc.cbStruct = sizeof(mxc);
    rc = mixerGetLineControls((HMIXEROBJ)hMixer,&mxlc,MIXER_GETLINECONTROLSF_ONEBYTYPE);
    if (MMSYSERR_NOERROR == rc) {   
		// Couldn't get the control.
		//mixerClose(hMixer);
		//return 0;
	}
    // After successfully getting the dwControlType control, the volume range
    // will be specified by mxc.Bounds.lMinimum to mxc.Bounds.lMaximum.


	if (SetGetFLAG == 0) {  // caller wants a actuel sound value
		// Initialize the MIXERCONTROLDETAILS structure
		ZeroMemory(&mxcd, sizeof(mxcd));    
		mxcd.cbStruct = sizeof(mxcd);
		mxcd.cbDetails = sizeof(volStruct);    
		mxcd.dwControlID = mxc.dwControlID;
		mxcd.paDetails = &volStruct;   
		mxcd.cChannels = 1;
		// Get the current value of the dwControlType control. 
		rc = mixerGetControlDetails((HMIXEROBJ)hMixer, &mxcd,
                                 MIXER_GETCONTROLDETAILSF_VALUE);
		if (MMSYSERR_NOERROR == rc) {        
			// Couldn't get the current volume.
			//mixerClose(hMixer);
			//return 0;

	    }    
		volume = volStruct.lValue;    // Get the absolute value of the volume.
		if (volume < 0)        
			volume = -volume;
		mixerClose(hMixer);
		return (volume/SoundScale);
	}
	if (SetGetFLAG == 1) {  // caller wants to set sound value
	    // Initialize the MIXERCONTROLDETAILS structure
		ZeroMemory(&mxcd, sizeof(mxcd));    
		mxcd.cbStruct = sizeof(mxcd);
		mxcd.hwndOwner = hMainWnd;
		mxcd.cMultipleItems = 0;
		mxcd.cbDetails = sizeof(volStruct);    
		mxcd.dwControlID = mxc.dwControlID;
		mxcd.paDetails = &volStruct;   
		mxcd.cChannels = 1;
		//mxcd.dwComponentType =MIXERLINE_COMPONENTTYPE_SRC_SYNTHESIZER;
		volStruct.lValue = 5000;//(newvol*SoundScale);
		rc = mixerSetControlDetails((HMIXEROBJ)hMixer, &mxcd,
                                 MIXER_GETCONTROLDETAILSF_VALUE);

	}	;

	
	mixerClose(hMixer);

	*/
	return 1;
}


//---------------------------------------------------------------------------------
long LoadVocResource (int sndnb, void **bufferptr)
{
	long	length;
	HRSRC hFound;

    hFound = FindResource(hInst,MAKEINTRESOURCE(sndnb), "VOC1");
	if (hFound == 0){return 0;}
	length = SizeofResource(hInst,hFound);
	*bufferptr = SafeMalloc (length);
	*bufferptr = (char *)LoadResource( hInst, hFound );
	return length;

}
//---------------------------------------------------------------------------------
//	SzRainSnd1buf = LoadResourceToFixedMem ("VOC1", IDR_VOC12, &RainSnd1buf)
LPBYTE hgtmpmem;     

long LoadResourceToFixedMem (LPSTR Type ,int sndnb, void **bufferptr)
{
//	int i;
	long	length = 0;
//	HRSRC hFound;
	//HGLOBAL hgmem;
//BOOL bRet;
   HRSRC  hRsrc;
   HGLOBAL hGlobal;
   HBITMAP hBitmapFinal = NULL;
	byte *ptr;

   if (hRsrc = FindResource(hInst,MAKEINTRESOURCE(sndnb), Type))
   {
	  length = SizeofResource(hInst,hRsrc);
      hGlobal = LoadResource(hInst, hRsrc);
      //*bufferptr = (byte*)LockResource(hGlobal);
      *bufferptr = LockResource(hGlobal);

	  //hgtmpmem = GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,length);
	  hgtmpmem = HEAP_getheapmem(length);
	
	  ptr = *bufferptr;


	  //for (i = 0; i < length; i++)
		//  *(hgtmpmem + i) = (byte*)*(ptr++); 
	  memcpy((byte*)hgtmpmem,(byte*)ptr,length);
	  *bufferptr = hgtmpmem;

	  UnlockResource(hGlobal);
	  FreeResource(hGlobal);

   }
   /*	  hGlobal = GlobalFree(hgtmpmem);
    hFound = FindResource(hInst,MAKEINTRESOURCE(sndnb), Type);
	if (hFound == 0){return 0;}
	length = SizeofResource(hInst,hFound);
	hgtmpmem = GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,length);
	*bufferptr = hgtmpmem;
	*bufferptr = (char *)LoadResource( hInst, hFound );*/
	return length;

}
/*
boolean FindExternalWalls (char *str)
{
long	LoadFile (char *filename, void **bufferptr)

}
*/
byte GetMemBlock (int size)
{
	//return(byte)(GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,size));
	return(byte)(HEAP_getheapmem(size));
}


void FreeMemBlock (byte* mem)
{
	//GlobalFree ((HGLOBAL)mem);//release mem;
	HEAP_freemem ((HGLOBAL)mem);//release mem;
	//GlobalUnlock((HGLOBAL)mem);//release mem;
}

#define GameRandomNumber(string,val)   GameRNG(string, val)
int GetRandVal ()
{
	unsigned int x=0;
	while (x>127){
	   x = GameRandomNumber("rain",0);
	}
	while (x>127){
	   x = GameRandomNumber("rain",x);
	}
	return x;
}

void STM ()
{
	SetTextMode();
}


int GetSetMenuItem( int id, char *str, char *defval)
{
	char tmp[512]="";
	int retval;

	lstrcpy(tmp,defval);//default
	if (GetStrFromRegdb ((LPSTR)str,(LPSTR)&tmp,defval) != -1){
		retval = atoi(tmp);
		if (retval == TRUE){
			CheckMenuItem(hmenu,id,MF_CHECKED );
		}else{
			CheckMenuItem(hmenu,id,MF_UNCHECKED);
		}
	}else return 0;

	return retval;
}


/*
int GetWinKeys();
int GetWinKeys()
{
	short a,b,c,d;
	a = GetAsyncKeyState(0x25);
	b = GetAsyncKeyState(0x26);
	c = GetAsyncKeyState(0x27);
	d = GetAsyncKeyState(0x28);

	if ((a==0)&&(b==0)&&( c==0)&&(d==0))  
		return 0;

	return 1;
}
/*
VK_LEFT 25 LEFT ARROW key  
VK_UP 26 UP ARROW key  
VK_RIGHT 27 RIGHT ARROW key  
VK_DOWN 
*//*
void SetWindowTextExt(char *txt, int a, int b, int c);
void SetWindowTextExt(char *txt, int a, int b, int c)
{
	   char tmp[128];
		sprintf(tmp,"%s - %d  %d  %d",txt,a,b,c);
		SetWindowText(hMainWnd,tmp);
}
*/


//******************************************************************************
//
// LoadTagExt
// bna added function
//******************************************************************************

byte* LoadTagExt (byte ** src, char *tag, int sizeofmem)
{
	int sizeoftag = lstrlen(tag);
	byte *pdest = (byte*)src;	
	char tmpmem[64];
	unsigned char ch;

	do{ 
		ch = *tag;
		pdest = memchr( pdest, ch, sizeofmem);
		if (pdest == 0){
			return 0;
		}
		//we have the first char, check the others
		memset(tmpmem,0,sizeof(tmpmem));
		memcpy(tmpmem,pdest,sizeoftag);
		if (lstrcmp( tag,tmpmem)==0){
			//match found
			return(pdest + sizeoftag);
		}
		pdest++;

	}while (pdest < (byte*)(src+sizeofmem));

	return 0;


}




BOOL CenterWindow(HWND hwndChild, HWND hwndParent,UINT Yoffset)
{
    RECT    rcChild, rcParent;
    int     cxChild, cyChild, cxParent, cyParent;
    int     cxScreen, cyScreen, xNew, yNew;
    HDC     hdc;

    // Get the Height and Width of the child window
    GetWindowRect(hwndChild, &rcChild);
    cxChild = rcChild.right - rcChild.left;
    cyChild = rcChild.bottom - rcChild.top;

    // Get the Height and Width of the parent window
    GetWindowRect(hwndParent, &rcParent);
    cxParent = rcParent.right - rcParent.left;
    cyParent = rcParent.bottom - rcParent.top;

    // Get the display limits
    hdc = GetDC(hwndChild);
    cxScreen = GetDeviceCaps(hdc, HORZRES);
    cyScreen = GetDeviceCaps(hdc, VERTRES);
    ReleaseDC(hwndChild, hdc);

    // Calculate new X position, then adjust for screen
    xNew = rcParent.left + ((cxParent - cxChild) / 2);
    if (xNew < 0)
    {
        xNew = 0;
    }
    else if ((xNew + cxChild) > cxScreen)
    {
        xNew = cxScreen - cxChild;
    }

    // Calculate new Y position, then adjust for screen
    yNew = rcParent.top  + ((cyParent - cyChild) / 2);
    if (yNew < 0)
    {
        yNew = 0;
    }
    else if ((yNew + cyChild) > cyScreen)
    {
        yNew = cyScreen - cyChild;
    }

	yNew += Yoffset;

    // Set it, and return
    return SetWindowPos(hwndChild,
                        NULL,
                        xNew, yNew,
                        0, 0,
                        SWP_NOSIZE | SWP_NOZORDER);
}




// Description:
//   Creates a tooltip for an item in a dialog box. 
// Parameters:
//   idTool - identifier of an dialog box item.
//   nDlg - window handle of the dialog box.
//   pszText - string to use as the tooltip text.
// Returns:
//   The handle to the tooltip.
//


#include <CommCtrl.h>

HWND CreateToolTip(int toolID, HWND hDlg, PTSTR pszText)
{
	if (!toolID || !hDlg || !pszText)
	{
		return FALSE;
	} 
	// Get the window of the tool.
	HWND hwndTool = GetDlgItem(hDlg, toolID);

	// Create the tooltip. hInst is the global instance handle.
	HWND hwndTip = CreateWindowEx(0, TOOLTIPS_CLASS, 0,
		WS_POPUP | TTS_ALWAYSTIP | TTS_BALLOON,
		CW_USEDEFAULT, CW_USEDEFAULT,
		CW_USEDEFAULT, CW_USEDEFAULT,
		hDlg, 0,
		hInst, 0);

	if (!hwndTool || !hwndTip)
	{
		return (HWND)NULL;
	}

	// Associate the tooltip with the tool.
	TOOLINFO toolInfo = { 0 };
	toolInfo.cbSize = sizeof(toolInfo);
	toolInfo.hwnd = hDlg;
	toolInfo.uFlags = TTF_IDISHWND | TTF_SUBCLASS;
	toolInfo.uId = (UINT_PTR)hwndTool;
	toolInfo.lpszText = pszText;
	SendMessage(hwndTip, TTM_ADDTOOL, 0, (LPARAM)&toolInfo);

	return hwndTip;
}
