/*
Copyright (C) 1994-1995 Apogee Software, Ltd.
 
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#include "rt_def.h"
#include "watcom.h"
#include "engine.h"
#include "_engine.h"
#include "rt_draw.h"
#include "rt_door.h"
#include "rt_stat.h"
#include "rt_ted.h"
#include "rt_util.h"
#include "rt_view.h"
#include <stdlib.h>
#include <math.h>
#include "watcher.h"
//MED
#include "memcheck.h"


/*
=============================================================================

Global Variables                                                                                                                                 GLOBAL VARIABLES

=============================================================================
*/


// We have to keep these around because they're used
// by the menus (at least for now)
wallcast_t posts[321];
int lasttilex;
int lasttiley;


#ifdef USE_OPENGL

#include "glfuncs.h"

static double hitpointx, hitpointy;

unsigned char seenwall[128][128][4];

wallent_t viswalls[4096];

int numviswalls;
#endif
/*
=============================================================================

Local Variables                                                                                                                                 GLOBAL VARIABLES

=============================================================================
*/

static int xtilestep, ytilestep;
static int c_vx, c_vy;

#ifdef USE_OPENGL
#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif

#define EPSILON 0.0000001

double distance2 (double x1, double y1, double x2, double y2)
{
    double dx = x2 - x1;
    double dy = y2 - y1;

    return dx * dx + dy * dy;
}


#define GETTILE(x,y,stat)							\
if (lastonecnt>0) {								\
    lastonecnt--;								\
    if (!lastonecnt) {noadd=1; status=stat; break;}				\
}										\
spotvis[x][y]=1;								\
mapseen[x][y]=1;								\
if ((tile=tilemap[x][y])!=0) {							\
    if (tile&0x8000) {								\
	if (!(tile&0x4000) && (doorobjlist[tile&0x3ff]->action==dr_closed)) {	\
	    lastonecnt=2;							\
	}									\
    } else {									\
	status=stat;								\
    }										\
}

static double dtantable[2048];
static int tantableinit=0;

/*
__inline double ttan(double in) {
    return dtantable[(int)(in*(2048/M_PI))&2047];
}
*/
int Cast (double angle)
{
    int tile;
//    char wals;

    double tan1, tan2;

    double y1, x2;
    int x1, y2, x1i, y2i;
    int y1i, x2i;

    int xdir, ydir;
    double xinc, yinc;

    int status, noadd, lastonecnt;

    char xdet, detr;

    char cont;

//    int j;

//    int cy1;

    while (angle < 0)
	angle += M_PI * 2; 
    while (angle >= M_PI * 2)
	angle -= M_PI * 2;

    tan1 = tan (0.5 * M_PI - angle);
    tan2 = 1.0/tan1;
    //printf("tan1=%f, tan2=%f\n",tan1,tan2);
    x1 = viewx >> 16;
    y1 = (viewx & 65535) / 65536.0;
    yinc = tan2;
    xdir = 1;
    if ((angle >= M_PI * 0.5) && (angle < M_PI * 1.5)) {
	xdir = -1;
	yinc = -yinc;
	x1 += 1;		/* Note: if xdir==-1, use x1-1 for wall checks. */
	y1 = 1.0 - y1;
    }
    if (tan2 < 0) {
	tan2 = -tan2;
    } 

    y1 *= tan2;

    if (!(angle >= M_PI))
	y1 = -y1;
    y1 += viewy * (1.0 / 65536.0);

    y2 = viewy >> 16;
    x2 = (viewy & 65535) / 65536.0;
    xinc = tan1;
    ydir = 1;
    if (angle >= M_PI) {
	ydir = -1;
	xinc = -xinc;
	y2 += 1;		/* Note: if ydir==-1, use y2-1 for wall checks. */
	x2 = 1.0 - x2;
    }
    if (tan1 < 0) {
	tan1 = -tan1;
    }

    x2 *= tan1;

    if (!((angle >= M_PI * 0.5) && (angle < M_PI * 1.5)))
	x2 = -x2;
    x2 += viewx * (1.0 / 65536.0);
 
    x1 += xdir;
    y1 += yinc;
    x2 += xinc;
    y2 += ydir;

    x1i = x1 - (xdir < 0);
    x2i = (int)x2;
    y1i = (int)y1;
    y2i = y2 - (ydir < 0);

    cont = 1;
    while (cont) {
	lastonecnt = -1;
	noadd = 0;
	status = 0;
	cont = 0;

	if (fabs (tan2) < EPSILON) {
	    y1i = (int)y1;
	    x1i = x1 - (xdir < 0);
	    if ((y1i >= 0) && (y1i < 128))
		while ((status != 1) && (x1i >= 0) && (x1i < 128)) {
		    GETTILE (x1i, y1i, 1);

		    if (status != 1) {
			x1i += xdir;
		    }
		}
	    x1 = x1i + (xdir < 0);
	    if (status != 1)
		return -1;
	} else if (fabs (tan1) < EPSILON) {
	    x2i = (int)x2;
	    y2i = y2 - (ydir < 0);
	    if ((x2i >= 0) && (x2i < 128))
		while ((status != 256) && (y2i >= 0) && (y2i < 128)) {
		    GETTILE (x2i, y2i, 256);
		    if (status != 256) {
			y2i += ydir;
		    }
		}
	    y2 = y2i + (ydir < 0);
	    if (status != 256)
		return -1;
	} else {
	    xdet = (tan2 < tan1);
	    y1i = (int)y1;
	    x2i = (int)x2;

	    while ((status != 1) && (status != 256)) {
		x1i = x1 - (xdir < 0);
		y2i = y2 - (ydir < 0);
		if (xdet)
		    detr = ((x1 - x2) < 0) ^ (xdir < 0);
		else
		    detr = ((y1 - y2) < 0) ^ (ydir < 0);
		if (detr) {
		    if ((x1i < 0) || (x1i >= 128) || (y1i < 0)
			|| (y1i >= 128))
			break;
		    GETTILE (x1i, y1i, 1);
		    if (status != 1) {
			x1 += xdir;
			y1 += yinc;
			y1i = (int)y1;
		    }
		} else {
		    if ((x2i < 0) || (x2i >= 128) || (y2i < 0)
			|| (y2i >= 128))
			break;
		    GETTILE (x2i, y2i, 256);
		    if (status != 256) {
			y2 += ydir;
			x2 += xinc;
			x2i = (int)x2;
		    }
		}
	    }
	    if ((status != 1) && (status != 256))
		return -1;
	}

	if ((status & 0xff) == 1) {
	    wallent_t *cur = &viswalls[numviswalls];
	    cur->x = x1 - (xdir < 0);
	    cur->y = y1i;
	    cur->wall = (xdir < 0);
	    if (!noadd && !seenwall[cur->x][cur->y][cur->wall]) {
		seenwall[cur->x][cur->y][cur->wall] = 1;
		numviswalls++;
	    }
	    hitpointx = x1;
	    hitpointy = y1;
	    x1 += xdir;
	    y1 += yinc;
	} else if ((status & 0xff00) == 256) {
	    wallent_t *cur = &viswalls[numviswalls];
	    cur->x = x2i;
	    cur->y = y2 - (ydir < 0);
	    cur->wall = 2 + (ydir < 0);
	    if (!noadd && !seenwall[cur->x][cur->y][cur->wall]) {
		seenwall[cur->x][cur->y][cur->wall] = 1;
		numviswalls++;
	    }
	    hitpointx = x2;
	    hitpointy = y2;
	    x2 += xinc;
	    y2 += ydir;
	} else
	    return -1;


	cont = 0;


    }
    return 1;
}

int recurseray (double angle, double la, double ra,
		 double leftx, double lefty, double rightx, double righty)
{
    int rayscast=0;
    if (ra - la < EPSILON)
	return 0;
    if (Cast (angle) < 0) {
	fprintf (stderr, "Warning: ray to nothing.\n");
	return 1;
    }
    rayscast++;
    if (distance2 (hitpointx, hitpointy, leftx, lefty) > (1.0 - EPSILON))
	rayscast+=recurseray ((la + angle) / 2.0, la, angle,
		    leftx, lefty, hitpointx, hitpointy);
    if (distance2 (hitpointx, hitpointy, rightx, righty) > (1.0 - EPSILON))
	rayscast+=recurseray ((ra + angle) / 2.0, angle, ra,
		    hitpointx, hitpointy, rightx, righty);
    return rayscast;
}
#define NVIEWANGLES 4

static double view_angles[]= { 0.25*M_PI, 0.30*M_PI, 0.35*M_PI, 0.4*M_PI };
static double view_angle_diff[]= { 0, 64, 256 };

int sortbytex(void* a, void* b) {
    return tilemap[((wallent_t*)a)->x][((wallent_t*)a)->y]-tilemap[((wallent_t*)b)->x][((wallent_t*)b)->y];
}     


extern void qsort(void*,size_t,size_t,int(*)( void*, void*));//bna
//extern void qsort(void*,size_t,size_t,int(*)(const void*,const void*)); //bna++146

void Refresh ()
{
    timer t;
	double nviewang;
	int j;  
	int rayscast;
    double hpx1, hpy1;
    double view_diff=0.0;
    int micros;
    double fps;
    static int dbline;


    BeginTimer(&t);
    /*int nla=lookangle;
    int i=0;
    if (nla >= 1024) nla -= 2048;
    nla=abs(nla);
    while (i<(NVIEWANGLES-1) && lookangle>view_angle_diff[i]) i++;
    view_diff=view_angles[i];*/
    view_diff=0.45*M_PI;

    if (!tantableinit) {
		tantableinit = 1;

		for (j=0;j<2048;j++) {
			dtantable[j]=tan(j*(M_PI/2048));
		}
    }

//    nviewang = -(viewangle / 1024.0 * M_PI);
	//bna hack change
	//if we have a player->angle(viewangle) == 512 then we get not
	//walls drawn in gldrawwalls.
	//why I dont now but this hack should fix it until
	//I can find the real error
//	if (player->angle == 512)
//		player->angle = 511;
	//if viewangle == 512 there would be trouble with cast
	//so 1024 is changed to 1024.01 to avoid this problem
    nviewang = -(viewangle / 1024.01 * M_PI);

    numviswalls = 0;
    memset (seenwall, 0, sizeof (seenwall));
    if (Cast (nviewang + view_diff) < 0)
		fprintf (stderr, "Warning: ray to nothing.\n");
    hpx1 = hitpointx;
    hpy1 = hitpointy;
     rayscast=0;

    if (Cast (nviewang - view_diff) < 0)
		fprintf (stderr, "Warning: ray to nothing.\n");

    rayscast++;
    //if (distance2 (hitpointx, hitpointy, hpx1, hpy1) > (1.0 - EPSILON))
    rayscast += recurseray (nviewang, nviewang - view_diff,
			  nviewang + view_diff, hitpointx, hitpointy, hpx1, hpy1);
     micros=EndTimer(&t);
     fps=1000000.0/micros;
   
    qsort(( void *)viswalls,(size_t)numviswalls,sizeof(wallent_t),(void*)sortbytex);


	dbline=0;
    //DebugAt(&dbline,"Refresh rayscast=%d [%d us, %f fps]",rayscast, micros,fps);
}

#else


void InitialCast (void);
void Cast (int curx);

void Interpolate (int x1, int x2)
{
    int i;
    int dtexture;
    int frac;
    int dheight;
    int hfrac;
    int dx;

    dx = x2 - x1;
    dtexture = (((posts[x2].texture - posts[x1].texture) << 12) + 0x800) / dx;
    dheight =
	(((posts[x2].wallheight - posts[x1].wallheight) << 8) + 0x80) / dx;
    frac = dtexture + (posts[x1].texture << 12);
    hfrac = dheight + (posts[x1].wallheight << 8);
    for (i = x1 + 1; i <= x2 - 1; i++, frac += dtexture, hfrac += dheight) {
	posts[i].lump = posts[x1].lump;
	posts[i].posttype = posts[x1].posttype;
	posts[i].offset = posts[x1].offset;
	posts[i].alttile = posts[x1].alttile;
	posts[i].texture = (frac >> 12);
	posts[i].wallheight = hfrac >> 8;
    }
}

void Refresh (void)
{
    int x;

// Cast Initial comb filter

    InitialCast ();

    for (x = 0; x <= viewwidth - 4; x += 4) {
	if NOTSAMETILE
	    (x, x + 4) {
	    Cast (x + 2);
	    if NOTSAMETILE
		(x, x + 2) {
		Cast (x + 1);
	    } else
		Interpolate (x, x + 2);
	    if NOTSAMETILE
		(x + 2, x + 4) {
		Cast (x + 3);
	    } else
		Interpolate (x + 2, x + 4);
	} else
	    Interpolate (x, x + 4);
    }
}


void HitWall (int curx, int vertical, int xtile, int ytile)
{
    int num;

    posts[curx].offset = (xtile << 7) + ytile;
    posts[curx].lump = tilemap[xtile][ytile];
    posts[curx].alttile = 0;
    posts[curx].posttype = 0;

    if (vertical < 0) {
	xintercept = xtile << 16;
	if (xtilestep < 0)
	    xintercept += 0xffff;
	yintercept = FixedScale (xintercept - viewx, c_vy, c_vx) + viewy;
	if (posts[curx].lump & 0x4000) {
	    if (tilemap[xtile - (xtilestep >> 7)][ytile] & 0x8000) {
		num = tilemap[xtile - (xtilestep >> 7)][ytile];
		if (num & 0x4000) {
		    if (maskobjlist[num & 0x3ff]->sidepic)
			posts[curx].lump = maskobjlist[num & 0x3ff]->sidepic;
		    else
			posts[curx].lump &= 0x3ff;
		} else
		    posts[curx].lump = doorobjlist[num & 0x3ff]->sidepic;
	    } else {
		if (posts[curx].lump & 0x1000)
		    posts[curx].lump =
			animwalls[posts[curx].lump & 0x3ff].texture;
		else
		    posts[curx].lump &= 0x3ff;
	    }
	} else if (posts[curx].lump & 0x2000) {
	    if (IsWindow (xtile, ytile))
		posts[curx].alttile = -1;
	    else
		posts[curx].alttile = (MAPSPOT (xtile, ytile, 2)) + 1;
	    posts[curx].lump &= 0x3ff;
	} else if (posts[curx].lump & 0x1000)
	    posts[curx].lump = animwalls[posts[curx].lump & 0x3ff].texture;
	else if (posts[curx].lump & 0x800) {
	    posts[curx].lump &= 0x3ff;
	    posts[curx].posttype = 2;
	}
	posts[curx].texture = yintercept - (ytile << 16);
//      posts[curx].texture&=0xffff;
	if (posts[curx].texture < 0)
	    posts[curx].texture = 0;
	if (posts[curx].texture > 65535)
	    posts[curx].texture = 65535;
	if (xtilestep < 0)
	    posts[curx].texture ^= 0xffff;
	posts[curx].posttype += 1;
//      posts[curx].texture=(posts[curx].texture+firstcoloffset)&65535;
    } else {
	yintercept = ytile << 16;
	if (ytilestep < 0)
	    yintercept += 0xffff;
	xintercept = FixedScale (yintercept - viewy, c_vx, c_vy) + viewx;
	if (posts[curx].lump & 0x4000) {	// check for adjacent doors
	    if (tilemap[xtile][ytile - ytilestep] & 0x8000) {
		num = tilemap[xtile][ytile - ytilestep];
		if (num & 0x4000) {
		    if (maskobjlist[num & 0x3ff]->sidepic)
			posts[curx].lump = maskobjlist[num & 0x3ff]->sidepic;
		    else
			posts[curx].lump &= 0x3ff;
		} else
		    posts[curx].lump = doorobjlist[num & 0x3ff]->sidepic;
	    } else {
		if (posts[curx].lump & 0x1000)
		    posts[curx].lump =
			animwalls[posts[curx].lump & 0x3ff].texture;
		else
		    posts[curx].lump &= 0x3ff;
	    }
	} else if (posts[curx].lump & 0x2000) {
	    if (IsWindow (xtile, ytile))
		posts[curx].alttile = -1;
	    else
		posts[curx].alttile = (MAPSPOT (xtile, ytile, 2)) + 1;
	    posts[curx].lump &= 0x3ff;
	} else if (posts[curx].lump & 0x1000)
	    posts[curx].lump = animwalls[posts[curx].lump & 0x3ff].texture;
	else if (posts[curx].lump & 0x800) {
	    posts[curx].lump &= 0x3ff;
	    posts[curx].posttype = 2;
	}
	posts[curx].texture = xintercept - (xtile << 16);
//      posts[curx].texture&=0xffff;
	if (posts[curx].texture < 0)
	    posts[curx].texture = 0;
	if (posts[curx].texture > 65535)
	    posts[curx].texture = 65535;
	if (ytilestep > 0)
	    posts[curx].texture ^= 0xffff;
//      posts[curx].posttype+=0;
//      posts[curx].texture=(posts[curx].texture+firstcoloffset)&65535;
    }
    posts[curx].wallheight = CalcHeight ();
}

void InitialCast (void)
{
    int snx, sny;
    int incr[2];
    int thedir[2];
    int cnt;
    int grid[2];
    int index;
    int curx;

    c_vx = c_startx;
    c_vy = c_starty;
    for (curx = 0; curx <= viewwidth; curx += 4) {
	snx = viewx & 0xffff;
	sny = viewy & 0xffff;

	if (c_vx > 0) {
	    thedir[0] = 1;
	    xtilestep = 0x80;
	    snx ^= 0xffff;
	    incr[1] = -c_vx;
	} else {
	    thedir[0] = -1;
	    xtilestep = -0x80;
	    incr[1] = c_vx;
	}
	if (c_vy > 0) {
	    thedir[1] = 1;
	    ytilestep = 1;
	    sny ^= 0xffff;
	    incr[0] = c_vy;
	} else {
	    thedir[1] = -1;
	    ytilestep = -1;
	    incr[0] = -c_vy;
	}
	cnt = FixedMul (snx, incr[0]) + FixedMul (sny, incr[1]);
	grid[0] = viewx >> 16;
	grid[1] = viewy >> 16;
	do {
	    int tile;

	    index = (cnt >= 0);
	    cnt += incr[index];
	    spotvis[grid[0]][grid[1]] = 1;
	    grid[index] += thedir[index];

	    if ((tile = tilemap[grid[0]][grid[1]]) != 0) {
		if (tile & 0x8000) {
		    if ((!(tile & 0x4000))
			&& (doorobjlist[tile & 0x3ff]->action == dr_closed)) {
			spotvis[grid[0]][grid[1]] = 1;
			if (doorobjlist[tile & 0x3ff]->flags & DF_MULTI)
			    MakeWideDoorVisible (tile & 0x3ff);
			do {
			    index = (cnt >= 0);
			    cnt += incr[index];
			    grid[index] += thedir[index];
			    if ((tilemap[grid[0]][grid[1]] != 0) &&
				(!(tilemap[grid[0]][grid[1]] & 0x8000)))
				break;
			}
			while (1);
			break;
		    } else
			continue;
		} else {
		    mapseen[grid[0]][grid[1]] = 1;
		    break;
		}
	    }
	}
	while (1);
	HitWall (curx, cnt - incr[index], grid[0], grid[1]);
	c_vx += viewsin << 2;
	c_vy += viewcos << 2;
    }
}


void Cast (int curx)
{
    int snx, sny;
    int incr[2];
    int thedir[2];
    int cnt;
    int grid[2];
    int index;

    c_vx = c_startx + (curx * viewsin);
    c_vy = c_starty + (curx * viewcos);
    snx = viewx & 0xffff;
    sny = viewy & 0xffff;

    if (c_vx > 0) {
	thedir[0] = 1;
	xtilestep = 0x80;
	snx ^= 0xffff;
	incr[1] = -c_vx;
    } else {
	thedir[0] = -1;
	xtilestep = -0x80;
	incr[1] = c_vx;
    }
    if (c_vy > 0) {
	thedir[1] = 1;
	ytilestep = 1;
	sny ^= 0xffff;
	incr[0] = c_vy;
    } else {
	thedir[1] = -1;
	ytilestep = -1;
	incr[0] = -c_vy;
    }
    cnt = FixedMul (snx, incr[0]) + FixedMul (sny, incr[1]);
    grid[0] = viewx >> 16;
    grid[1] = viewy >> 16;
    do {
	int tile;

	index = (cnt >= 0);
	cnt += incr[index];
	spotvis[grid[0]][grid[1]] = 1;
	grid[index] += thedir[index];

	if ((tile = tilemap[grid[0]][grid[1]]) != 0) {
	    if (tile & 0x8000) {
		if ((!(tile & 0x4000))
		    && (doorobjlist[tile & 0x3ff]->action == dr_closed)) {
		    spotvis[grid[0]][grid[1]] = 1;
		    if (doorobjlist[tile & 0x3ff]->flags & DF_MULTI)
			MakeWideDoorVisible (tile & 0x3ff);
		    do {
			index = (cnt >= 0);
			cnt += incr[index];
			grid[index] += thedir[index];
			if ((tilemap[grid[0]][grid[1]] != 0) &&
			    (!(tilemap[grid[0]][grid[1]] & 0x8000)))
			    break;
		    }
		    while (1);
		    break;
		} else
		    continue;
	    } else {
		mapseen[grid[0]][grid[1]] = 1;
		break;
	    }
	}
    }
    while (1);
    HitWall (curx, cnt - incr[index], grid[0], grid[1]);
}

#endif
