/*
Copyright (C) 2003-2004 Jared Stafford
Copyright (C) 1994-1995 Apogee Software, Ltd.
Copyright (C) 2001-2003 Jan Lönnberg
Copyright (C) 2006      Birger N. Andreasen

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

/*
  Some of the OpenGL code is from LAB3D-SDL by Jan Lönnberg.
 */
 
#ifndef GL_CLAMP_TO_EDGE
  #define GL_CLAMP_TO_EDGE 0x812F
#endif
 

 
#ifdef USE_OPENGL

//#define _GNU_SOURCE 1 // necessary for fmemopen

#include <errno.h>
#include "rt_def.h" // for defn. of types
#include "glfuncs.h"
#include "engine.h"
#include "rt_view.h" // for color maps, defn. of fulllight
#include "rt_floor.h" // for defn. of sky
#include "rt_door.h" // for masked walls
#include "rt_scale.h" // for transparentlevel
#include "rt_playr.h" // for defn. of actor types, MISCVARS
#include "rt_stat.h" // for static actors
#include "rt_menu.h" // for defn. of inmenu
#include "w_wad.h"
#include "isr.h"		// for definition of VBLCOUNTER
#include "rt_util.h" // for defn. of Error
#include "rt_main.h" // for defn. of pheight
#include "z_zone.h" // for defn. of PU_CACHE and Z_Free
#include "lumpy.h"
#include "rt_msg.h"
#include "watcher.h"
#include "SDL.h"
#include "SDL_image.h"
#include <math.h>

#include "develop.h"

//#define PNG_SAVE
#ifdef PNG_SAVE
#include <png.h>
#endif 

#if (USERAINCODE == 1)
#include "rain.h"
RAIN rain;
extern BOOL useRain;
BOOL bIsRainInit;
#endif


Uint8 *GL_W_CacheLumpNum (int lump, int tag, converter_t converter, int numrec);

extern void GLDrawCrosshair (void);
extern BOOL CH_LoadCrosshair();
extern void CH_DrawCrosshair(unsigned char* s);

char szAppPath[512];

extern BOOL IsCrosshairLoaded;
extern boolean ingame;
extern boolean inmenu;
extern boolean demorecord, demoplayback;
extern int iG_aimCross;
extern boolean inautomap;

double ShakeVal = 0;





#define LM_NONE 0
#define LM_ARRAY 1
#define LM_GL 2

#define YCORRECTFACT (240.0/200.0)

//#define LIGHTMETHOD LM_ARRAY

#define EPSILON 0.0000001

//#if (LIGHTMETHOD==LM_ARRAY)
#define LIGHTRAD 32
#define LIGHTOFS ((LIGHTRAD/2)-1)
double lightamt[256][256];
double stdlight[1024];
//double stdlights[16][1024];
double ambientlight;
double InterpolateLight (double x, double y);
//#endif
#define NORMALFOGSTART 1024
#define NORMALFOGEND (1024*64)

#define NOFOGSTART (NORMALFOGSTART*4.0)
#define NOFOGEND (NORMALFOGEND*4.0)

#define GASFOGSTART (NORMALFOGSTART/24.0)
#define GASFOGEND (NORMALFOGEND/8.0)

#if SDL_BYTE_ORDER==SDL_LITTLE_ENDIAN
    #define RED_SHIFT 0
    #define GREEN_SHIFT 8
    #define BLUE_SHIFT 16
    #define ALPHA_SHIFT 24
    #define REDCMP(X) ((X)&255)
    #define GREENCMP(X) (((X)>>8)&255)
    #define BLUECMP(X) (((X)>>16)&255)
    #define ALPHACMP(X) (((X)>>24)&255)
#else
    #define RED_SHIFT 24
    #define GREEN_SHIFT 16
    #define BLUE_SHIFT 8
    #define ALPHA_SHIFT 0
    #define REDCMP(X) (((X)>>24)&255)
    #define GREENCMP(X) (((X)>>16)&255)
    #define BLUECMP(X) (((X)>>8)&255)
    #define ALPHACMP(X) ((X)&255)
#endif

typedef struct {
    int flags;
    int x, y;
    int rtx, rty;
    double rot;
    double scale;
    void (*draw)(void* data);
    void (*free)(void* data);
    void* data;
} gl2DObject;


static gl2DObject twodobjects[128];
static int n2dobjects=0;

typedef struct {
    double x, y, z;
} m_vertex;

typedef struct {
    double r, g, b;
} m_color;

typedef struct {
    double x, y;
} m_texcoord;

enum { ST_QUAD=0, ST_QUADSTRIP, ST_TRI, ST_TRISTRIP, ST_TRIFAN, ST_POLY, ST_LAST };

static GLuint shape_types[ST_LAST] = { GL_QUADS, GL_QUAD_STRIP, GL_TRIANGLES,
				       GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN,
				       GL_POLYGON };

#define NUMQUAL 4

static double qualdist[NUMQUAL] = { 65536.0*16, 65536.0*8,  65536.0*4, 0.0  };


#if 0
typedef struct {
    GLuint tex;
    unsigned char flags;
    unsigned char type;
    unsigned short nverts;
    m_vertex normal;
    m_vertex* verts;
    m_color* colors;
    m_texcoord* texcoords;
} m_shape;

typedef struct {
    short int nshapes;
    m_shape* shapes;
} shape_list;

typedef struct {
    const char* name;
    unsigned char flags;
    shape_list shapes[NUMQUAL];
} model;
#endif

typedef struct {
    const char* name;
    GLuint tex;
} skintex;

typedef struct {
    GLuint tex;
    unsigned char flags;
    unsigned char type;
    unsigned int vertindex;
    unsigned short nverts;
} shape;


typedef struct {
    short int nshapes;
    short int nverts;
    m_vertex* vertlist;
    m_texcoord* texcoords;
    shape* shapes;
} shape_list;

typedef struct {
    const char* name;
    unsigned char flags;
    double px,py,pz;
    shape_list shapes[NUMQUAL];
} model;


typedef struct {
    GLuint tex;
    double tcxl[256];
    double tcxh[256];
    double tcyl[16];
    double tcyh[16];
} glfont_t;

static GLuint lasttex=0;

inline void BindTex(GLuint tex) {
    if (tex!=lasttex) {
	lasttex=tex;
	glBindTexture(GL_TEXTURE_2D,tex);
    }
}

// Model flags
#define MOD_ROTATE 1
#define MOD_VERTROTATE 2

// Shape flags
#define SHAPE_TWOSIDE 1
#define SHAPE_FLOORSTENCIL 2


static skintex* skins;
static int nskins=0;
static model** models;
static int nmodels=0;


static double fognear, fogfar;

static double vwx, vwy, vwz;

#define ONETEX

#ifdef ONETEX
GLuint screenbuffertexture;
#else
GLuint screenbuffertextures[48];	/* 48 small textures. */
#endif
int screenbufferwidth = 0;
int screenbufferheight = 0;
int screenfullwidth = 0;
int screenfullheight = 0;
static GLint fullfilter = GL_LINEAR_MIPMAP_LINEAR;
static int partialfilter = GL_LINEAR;
static int screenwidth = 0;
static int screenheight = 0;
int lookangle;
int glscreenw;
int glscreenh;
unsigned char *screenbuffer;
#ifdef NO_INDEXED_COLOR
unsigned char *screenbuffer32=NULL;
unsigned char ipalr[256],ipalg[256],ipalb[256];
#endif
unsigned char savegamescreen[16000];

extern unsigned short  SHAKETICS;
extern boolean    GamePaused;

static double screenratio;
//unsigned char* 
#ifdef KEEP_SKYS
static int skytex[6][6];
#else
static int skytex[6];
static int lastsky=-1;
#endif

static int minfilters[]={GL_NEAREST, GL_LINEAR, 
			 GL_NEAREST_MIPMAP_NEAREST, GL_NEAREST_MIPMAP_LINEAR, 
			 GL_LINEAR_MIPMAP_NEAREST, GL_LINEAR_MIPMAP_LINEAR };

static int magfilters[]={GL_NEAREST, GL_LINEAR, 
			 GL_NEAREST, GL_NEAREST, 
			 GL_LINEAR, GL_LINEAR };


int compat=0;

#define NO_CATWALK (compat&1)
#define NO_MODELS (compat&2)
#define OLD_LOOKMODE (compat&4)
#define NO_FATBLOCK (compat&8)
#define NO_FLOORDEPTH (compat&16)

static int catwalk[17];

static int catbits[4][3] = {
    { 1, 3, 0 },
    { 1, 4, 2 },
    { 6, 3, 5 },
    { 6, 4, 7 }};

static int floortex;
static int ceilingtex;

static int brightness, lightrate;

static Uint32 shroomlast;

typedef struct {
    double hue;
    double r,g,b;
} shroomrec;

static shroomrec shrooms[32];

static double fadered, fadeblue, fadegreen, fadealpha=0.0;

static int DoingRotate = 0;
static int DrawScreen = 1;
static int UploadScreen = 1;
int gltexmode = -1;

static int OverlayStretch= 0;

static double OverlayZoom=1.0;

char* GLPath;

#define skh 1024
#define skl -1024

#define sklbd { skl, skl, skl }
#define sklbu { skl, skl, skh }
#define sklfd { skl, skh, skl }
#define sklfu  { skl, skh, skh }
#define skrbd  { skh, skl, skl }
#define skrbu  { skh, skl, skh }
#define skrfd  { skh, skh, skl }
#define skrfu  { skh, skh, skh }

static int hswitch6=0;

#define IS_TOP_CATWALK(x,y) 					\
({ 								\
    int _is=0; 							\
    int _tile=tilemap[x][y]; 					\
    if (_tile&0x8000 && (_tile&0x4000)) 			\
	if (maskobjlist[_tile&0x3ff]->toptexture == hswitch6) 	\
	    _is=1; 						\
    _is; 							\
})


#define MAKEBUF(name,size,fmt, ...) char name[size]; snprintf(name,size,fmt, ## __VA_ARGS__)

static GLuint skywind[6][4][3] = {
    {sklfu, skrfu, skrfd, sklfd},
    {skrfu, skrbu, skrbd, skrfd},
    {skrbu, sklbu, sklbd, skrbd},
    {sklbu, sklfu, sklfd, sklbd},
    {sklbu, skrbu, skrfu, sklfu},
    {sklfd, skrfd, skrbd, sklbd}
};

static GLdouble skytexwind[4][2] = {
    {0.0, 0.0},
    {1.0, 0.0},
    {1.0, 1.0},
    {0.0, 1.0}};

typedef struct {
    unsigned char type;
    unsigned short flags;
    int tex;
    double dist;
    double x, y, z;
    double ang,vang;
    union {
	struct {
	    int btex;
	    int ttex;
	} maskwall;
	struct {
	    unsigned short cmap;
	    int id;
	} sprite;
	struct {
	    int id;
	    model* mod;
	} mod;
    };
} glvisobj;

typedef struct __attribute__((packed)) {
    int type;
    union {
    	struct {
    	    GLuint texnum[MAXPLAYERCOLORS+1];
    	    unsigned short w, h;
    	    short lofs, tofs;
    	    short osize;
    	    double tcxl, tcyl;
    	    double tcxh, tcyh;
    	} tex;
    	model* mod;
    	struct {
    	    glfont_t* fptr;
    	} font;
    };
} gl_lumpinfo_t;

enum { LT_UNKNOWN=0, LT_TEXTURE, LT_FONT, LT_MODEL };

typedef struct __attribute__((packed)) {
    short transused, trans[4];
    Uint32* pal;
    byte colorsused[MAXPLAYERCOLORS];
}texauxinfo_t;

typedef struct __attribute__((packed)) {
    unsigned short w, h;
    unsigned short rw, rh;
    short lofs, tofs;
    short osize;
    unsigned int rep;
} texbufinfo_t;


static gl_lumpinfo_t invalid; //unknown texture type
static gl_lumpinfo_t* lumpinfo;
static texauxinfo_t *texauxinfo;
static Uint32 gampal[256];

enum {
    GLV_SPRITE,
    GLV_MASKED,
    GLV_BLOCKMASK,
    GLV_MODEL,
    GLV_CATWALK,
    // the rest are used for settings only
    GLV_WALL, 
    GLV_PUSHWALL,
    GLV_SKY,
    GLV_FLOORCEIL,
    GLV_BORDER,
    GLV_2DOBJECTS,
    GLV_OVERLAY,
    GLV_FADE,
    GLV_RAIN    
};




static unsigned int visprio[] = { 0, 0, 1, 2, 3 };

// Sprite flags (type==GLV_SPRITE)
#define GLV_TRANSFADE 1
#define GLV_SHROOMFLASH 2
#define GLV_REDFLASH 4
#define GLV_FULLLIGHT 8

// Masked wall flags
#define GLV_VERTICAL 1

glvisobj visobjects[2048];
int nvisobjects = -1;
double onediv[256];

static int curdrawmode=-1;




extern void WriteDebug (char *error, int i,...);




int powerof2 (int in)
{
    int i = 0;
    in--;
    while (in) {
	in >>= 1;
	i++;
    }
    return 1 << i;
}

void SetDrawMode(int dm) {
    if (dm!=curdrawmode) {
	curdrawmode=dm;
	//printf("Switching to %d\n",dm);
	switch (dm) {
	case GLV_MODEL:
	    glDisable	(GL_POLYGON_SMOOTH);
	    glEnable    (GL_TEXTURE_2D);
	    glDisable   (GL_BLEND);
	    glEnable    (GL_ALPHA_TEST);
	    glEnable    (GL_CULL_FACE);
	    glEnable    (GL_DEPTH_TEST);

	    glDisable   (GL_STENCIL_TEST);
	    glCullFace  (GL_BACK);
	    glFrontFace (GL_CCW);
	    glDepthMask (1);
	    break;
	case GLV_SPRITE:
	    glDisable	(GL_POLYGON_SMOOTH);
	    glEnable    (GL_TEXTURE_2D);
	    glEnable    (GL_BLEND);
	    glDisable   (GL_ALPHA_TEST);
	    glDisable   (GL_CULL_FACE);
	    glEnable    (GL_DEPTH_TEST);
	    glDisable   (GL_STENCIL_TEST);
	    glDepthMask (0);
 	    break;
	case GLV_MASKED:
	    glDisable	(GL_POLYGON_SMOOTH);
	    glEnable    (GL_TEXTURE_2D);
	    glEnable    (GL_BLEND);
	    glDisable   (GL_ALPHA_TEST);
	    glDisable   (GL_CULL_FACE);
	    glEnable    (GL_DEPTH_TEST);
	    glDisable   (GL_STENCIL_TEST);
	    glDepthMask (0);
 	    break;
	case GLV_BLOCKMASK:
	    glDisable	(GL_POLYGON_SMOOTH);
	    glEnable    (GL_TEXTURE_2D);
	    glDisable   (GL_BLEND);
	    glDisable   (GL_ALPHA_TEST);
	    glEnable    (GL_CULL_FACE);
	    glEnable    (GL_DEPTH_TEST);
	    glFrontFace (GL_CW);
	    glDisable   (GL_STENCIL_TEST);
	    glDepthMask (1);
 	    break;
	case GLV_CATWALK:
	    glEnable    (GL_TEXTURE_2D);
	    glDisable	(GL_POLYGON_SMOOTH);
	    glDisable   (GL_BLEND);
	    glEnable    (GL_ALPHA_TEST);
	    glDisable   (GL_CULL_FACE);
	    glEnable    (GL_DEPTH_TEST);
	    glDisable   (GL_STENCIL_TEST);
	    glDepthMask (1);
 	    break;
	case GLV_WALL:
	    glDisable	(GL_POLYGON_SMOOTH);
	    glEnable    (GL_TEXTURE_2D);
	    glDisable   (GL_BLEND);
	    glDisable   (GL_ALPHA_TEST);
	    glDisable   (GL_CULL_FACE);
	    glEnable    (GL_DEPTH_TEST);
	    glDisable   (GL_STENCIL_TEST);
	    glDepthMask (1);
 	    break;
	case GLV_FLOORCEIL:
	    glDisable	(GL_POLYGON_SMOOTH);
	    glEnable    (GL_TEXTURE_2D);
	    glDisable   (GL_BLEND);
	    glDisable   (GL_ALPHA_TEST);
	    glDisable   (GL_CULL_FACE);
	    glEnable    (GL_DEPTH_TEST);
	    glEnable    (GL_STENCIL_TEST);
	    glDepthMask (1);
 	    break;
	case GLV_PUSHWALL:
	    glDisable	(GL_POLYGON_SMOOTH);
	    glEnable    (GL_TEXTURE_2D);
	    glDisable   (GL_BLEND);
	    glDisable   (GL_ALPHA_TEST);
	    glEnable    (GL_CULL_FACE);
	    glEnable    (GL_DEPTH_TEST);
	    glDisable   (GL_STENCIL_TEST);
	    glFrontFace (GL_CW);
	    glDepthMask (1);
 	    break;
	case GLV_SKY:
	    glDisable	(GL_POLYGON_SMOOTH);
	    glEnable    (GL_TEXTURE_2D);
	    glDisable   (GL_BLEND);
	    glDisable   (GL_ALPHA_TEST);
	    glDisable   (GL_DEPTH_TEST);
	    glDisable   (GL_FOG);
	    glDisable   (GL_STENCIL_TEST);
	    glDepthMask (0);
 	    break;
	case GLV_OVERLAY:
	    glDisable	(GL_POLYGON_SMOOTH);
	    glEnable    (GL_TEXTURE_2D);
	    glDisable   (GL_CULL_FACE);
	    glDisable   (GL_BLEND);
	    glEnable    (GL_ALPHA_TEST);
	    glDisable   (GL_DEPTH_TEST);
	    glDisable   (GL_FOG);
	    glDisable   (GL_STENCIL_TEST);
	    glDepthMask (0);
	    break;
	case GLV_BORDER:
	    glDisable	(GL_POLYGON_SMOOTH);
	    glDisable (GL_TEXTURE_2D);
	    glEnable  (GL_BLEND);
	    glDisable (GL_ALPHA_TEST);
	    glDisable (GL_FOG);
	    glDisable (GL_DEPTH_TEST);
	    glDisable   (GL_STENCIL_TEST);
	    glDepthMask (0);
     	    break;
	case GLV_2DOBJECTS:
	    glDisable	(GL_POLYGON_SMOOTH);
	    glDisable (GL_FOG);
	    glDisable (GL_ALPHA_TEST);
	    glEnable  (GL_BLEND);
	    glEnable  (GL_TEXTURE_2D);
	    glDisable (GL_DEPTH_TEST);
	    glDisable (GL_CULL_FACE);
	    glDisable   (GL_STENCIL_TEST);
	    break;
	case GLV_FADE:
	    glDisable	(GL_POLYGON_SMOOTH);
	    glDisable (GL_FOG);
	    glEnable  (GL_BLEND);
	    glDisable (GL_TEXTURE_2D);
	    glDisable (GL_ALPHA_TEST);
	    glDisable (GL_DEPTH_TEST);
	    glDisable   (GL_STENCIL_TEST);
	    break;
	case GLV_RAIN:
		glShadeModel(GL_SMOOTH);
		glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);
	    glDisable (GL_ALPHA_TEST);
	    glEnable  (GL_BLEND);
	    glDisable (GL_DEPTH_TEST);
	    glDisable (GL_CULL_FACE);
	    glDisable (GL_STENCIL_TEST);
		glDepthFunc(GL_LESS);
	    glDisable (GL_TEXTURE_2D);
	    glDepthMask (0);
	    break;	    
	}
    }
}

void print_stack (int);

void GLError(int errCode) {
    const GLubyte *errString;
    errString = gluErrorString (errCode);
    fprintf (stderr, "OpenGL Error: %s\n", errString);
    WriteDebug(errString,errCode);
    print_stack (1);
    SDL_Quit ();
    exit (1);
}
void checkGLStatus ()
{
    GLenum errCode;

    if ((errCode = glGetError ()) != GL_NO_ERROR) {
	     //GLError(errCode);//bna_removed
    }
}

void UploadPartialOverlayToTexture (int x, int y, int dx, int dy, int w,
				    int h, GLuint tex, int create)
{
    BindTex( tex);
    checkGLStatus ();

    glPixelStorei (GL_UNPACK_ROW_LENGTH, screenbufferwidth);
    glPixelStorei (GL_UNPACK_SKIP_PIXELS, x);
    glPixelStorei (GL_UNPACK_SKIP_ROWS, y);
    glPixelStorei (GL_UNPACK_ALIGNMENT, 1);
    checkGLStatus ();

    if (create) {
	glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
	glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
	glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, partialfilter);
	glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, partialfilter);
    }

#ifdef NO_INDEXED_COLOR

    
    if (create) {
	screenfullwidth=powerof2(w);
	screenfullheight=powerof2(h);
	ConvertPartialOverlay(0,0,screenbufferwidth,screenbufferheight);
	glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, screenfullwidth,
		      screenfullheight, 0, GL_RGBA, GL_UNSIGNED_BYTE, NULL);
    } /*else {*/
    glTexSubImage2D (GL_TEXTURE_2D, 0, dx, dy, w, h,
		     GL_RGBA, GL_UNSIGNED_BYTE, screenbuffer32);
    //}
    checkGLStatus ();
#else
    glPixelTransferi (GL_MAP_COLOR, GL_TRUE);

    if (create) {
	screenfullwidth=powerof2(w);
	screenfullheight=powerof2(h);
	glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, screenfullwidth,
		      screenfullheight, 0, GL_COLOR_INDEX, GL_UNSIGNED_BYTE, NULL);
    } /*else {*/
    glTexSubImage2D (GL_TEXTURE_2D, 0, dx, dy, w, h,
		     GL_COLOR_INDEX, GL_UNSIGNED_BYTE, screenbuffer);
    //}
    checkGLStatus ();
    glPixelTransferi (GL_MAP_COLOR, GL_FALSE);
#endif

    glPixelStorei (GL_UNPACK_SKIP_PIXELS, 0);
    glPixelStorei (GL_UNPACK_SKIP_ROWS, 0);
    glPixelStorei (GL_UNPACK_ROW_LENGTH, 0);
}




#ifdef NO_INDEXED_COLOR
void ConvertPartialOverlay(int sx, int sy, int w, int h) {

    if (!screenbuffer32) {
	screenbuffer32 = malloc(screenbufferwidth*screenbufferheight*4);
    }
    unsigned char *f=&screenbuffer[sx+screenbufferwidth*sy],*t=(unsigned char*)&screenbuffer32[sx+screenbufferwidth*sy];

    int x,y,i;
    int skip=screenbufferwidth-w;

    //printf("sx=%d, sy=%d, w=%d, h=%d, spos=%d skip=%d\n",sx,sy,w,h,sx+screenbufferwidth*sy,skip);
    for(y=0;y<h;y++,f+=skip,t+=(skip*4)) 
	for(x=0;x<w;x++) {
	    if ((*(f))==255) {
		*(t++)=0;		
		*(t++)=0;		
		*(t++)=0;		
		*(t++)=0;		
	    } else {
		*(t++)=ipalr[*f];
		*(t++)=ipalg[*f];
		*(t++)=ipalb[*f];
		*(t++)=255;
	    }
	    f++;
	}
    //TextureAvg32((Uint32*)to,64,64);

}
#endif
/* Upload rectangular part of overlay from memory to overlay texture... */

void UploadPartialOverlay (int x, int y, int w, int h)
{
#ifdef NO_INDEXED_COLOR
    ConvertPartialOverlay(x,y,w,h);
#endif
#ifdef ONETEX
    UploadPartialOverlayToTexture(x,y,x,y,w,(h>1)?h:2,
				  screenbuffertexture,0);
#else
    int left, right, top, bottom, i, j;
    int lr, rr, tr, br;

    left = (x - 2) / 62;
    if (left < 0)
	left = 0;
    right = (x + w - 1) / 62;
    if (right > 5)
	right = 5;
    top = (y - 2) / 62;
    if (top < 0)
	top = 0;
    bottom = (y + h - 1) / 62;
    if (bottom > 7)
	bottom = 7;

    for (i = top; i <= bottom; i++)
	for (j = left; j <= right; j++) {
	    lr = x - 62 * j;
	    rr = lr + w - 1;
	    tr = y - 62 * i;
	    br = tr + h - 1;

	    if (rr < 0)
		continue;
	    if (lr > 63)
		continue;
	    if (br < 0)
		continue;
	    if (tr > 63)
		continue;

	    if (lr < 0)
		lr = 0;
	    if (rr > 63)
		rr = 63;
	    if (tr < 0)
		tr = 0;
	    if (br > 63)
		br = 63;

	    UploadPartialOverlayToTexture (lr + 62 * j, tr + 62 * i, lr, tr,
					   rr - lr + 1, br - tr + 1,
					   screenbuffertextures[i * 6 + j],
					   0);
	}
#endif
    ShowPartialOverlay (x, y , w, h );
}

/* Upload entire overlay from memory to texture (creates textures)... */

void UploadOverlay (void)
{
    int i, j;
#ifdef ONETEX
    UploadPartialOverlayToTexture(0,0,0,0,screenbufferwidth,
				  screenbufferheight,
				  screenbuffertexture,1);
#else
    for (i = 0; i < 8; i++)
	for (j = 0; j < 6; j++)
	    UploadPartialOverlayToTexture (62 * j, 62 * i, 0, 0, 64, 64,
					   screenbuffertextures[i * 6 + j],
					   1);
#endif
}

/* Display rectangular part of overlay... */

void ShowPartialOverlay (int x, int y, int w, int h)
{

    float tx1, tx2, ty1, ty2;
    int i, j, tr, br, lr, rr, left, right, top, bottom;

    //if (mixing)
    SetDrawMode(GLV_OVERLAY);
    glTexEnvf (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);

    glMatrixMode (GL_PROJECTION);
    glLoadIdentity ();
    if (OverlayStretch) {
	gluOrtho2D (0, 320.0, 0.0, 200.0);
    } else {

	double bbsizeh=((0.75/screenratio)*320.0 - 320)/2.0;
	double bbsizev=((screenratio/0.75)*200.0 - 200)/2.0;
	double bbsize=bbsizev;

	double left, right, top, bot;

	if (bbsizeh>0) {
	    left=-bbsizeh;
	    right=320+bbsizeh;
	    top=0;
	    bot=200;
	} else {
	    left=0;
	    right=320;
	    top=-bbsizev;
	    bot=200+bbsizev;
	}
	if (OverlayZoom!=1.0) {
	    left=(left-160)*OverlayZoom+160;
	    right=(right-160)*OverlayZoom+160;
	    top=(top-100)*OverlayZoom+100;
	    bot=(bot-100)*OverlayZoom+100;
	}

	gluOrtho2D (left, right, top, bot);
    }
    glMatrixMode (GL_MODELVIEW);
    glLoadIdentity ();

#ifdef ONETEX
	tx1=((float)x)/(float)(screenfullwidth);
	tx2=((float)(x+w))/(float)screenfullwidth;
	
	ty1=((float)y)/(float)(screenfullheight);
	ty2=((float)(y+h))/(float)screenfullheight;
	
	//y-=visiblescreenyoffset;
	
	BindTex(screenbuffertexture);
	glBegin(GL_QUADS);
	glColor3f(1,1,1);
	glTexCoord2f(tx1,ty2);
	glVertex2s(x,200-y-h);
	glTexCoord2f(tx2,ty2);
	glVertex2s(x+w,200-y-h);
	glTexCoord2f(tx2,ty1);
	glVertex2s(x+w,200-y);
	glTexCoord2f(tx1,ty1);
	glVertex2s(x,200-y);
	glEnd();
#else

    left = (x - 1) / 62;
    if (left < 0)
	left = 0;
    right = (x + w - 2) / 62;
    if (right > 5)
	right = 5;
    top = (y - 1) / 62;
    if (top < 0)
	top = 0;
    bottom = (y + h - 2) / 62;
    if (bottom > 7)
	bottom = 7;

    //  printf("Drawing %d %d %d %d\n",x,y,w,h);

    for (i = top; i <= bottom; i++)
	for (j = left; j <= right; j++) {
	    lr = x - 62 * j;
	    rr = lr + w - 1;
	    tr = y - 62 * i;
	    br = tr + h - 1;

	    if (rr < (j > 0))
		continue;
	    if (lr > (63 - (j < 5)))
		continue;
	    if (br < (i > 0))
		continue;
	    if (tr > (63 - (i < 7)))
		continue;

	    if (lr < (j > 0))
		lr = (j > 0);
	    if (rr > (63 - (j < 5)))
		rr = 63 - (j < 5);
	    if (tr < (i > 0))
		tr = (i > 0);
	    if (br > (63 - (i < 7)))
		br = 63 - (i < 7);

//              fprintf(stderr,"%d %d %d %d %d %d\n",i,j,lr,tr,rr,br);

	    tx1 = ((float)lr) / 64.0;
	    tx2 = ((float)(rr + 1)) / 64.0;

	    ty1 = ((float)tr) / 64.0;
	    ty2 = ((float)(br + 1)) / 64.0;

	    BindTex( screenbuffertextures[i * 6 + j]);
	    glBegin (GL_QUADS);
	    //glColor4f (1.0, 1.0, 1.0, 1.0);
	    glTexCoord2f (tx1, ty2);
	    glVertex2s (lr + 62 * j, 200 - br - 1 - 62 * i);
	    glTexCoord2f (tx2, ty2);
	    glVertex2s (rr + 1 + 62 * j, 200 - br - 1 - 62 * i);
	    glTexCoord2f (tx2, ty1);
	    glVertex2s (rr + 1 + 62 * j, 200 - tr - 62 * i);
	    glTexCoord2f (tx1, ty1);
	    glVertex2s (lr + 62 * j, 200 - tr - 62 * i);
	    glEnd ();

	}
    glTexEnvf (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
#endif
    checkGLStatus ();
}



void GlGammaInitPalette (byte *pal);
byte glgammatable[256];


static void convertpal (Uint8 * pal, Uint32 * npal, int translevel)
{
    int i,r,g,b;
    unsigned int msk = (255 - translevel) << ALPHA_SHIFT;
	long rgb;

	GlGammaInitPalette(pal);

    for (i = 0; i < 255; i++) {
		r = glgammatable[*(pal++)];
		g = glgammatable[*(pal++)];
		b = glgammatable[*(pal++)];
/*		r = *(pal++);
		g = *(pal++);
		b = *(pal++);
		rgb = RGB(r,g,b);
		r = GetRValue(rgb);
		g = GetGValue(rgb);
		b = GetBValue(rgb);
*/
		*(npal++) = msk | (r << RED_SHIFT) | (g << GREEN_SHIFT) | (b<<BLUE_SHIFT);
    }
    *npal=0;
}



//bna added function
void GlGammaInitPalette (byte *pal)
{
    int		r,g,b;
    int		i;
	int		value;
	float	glgamma;
				  
	//gammaindex goes from 0(normal) to 7(light) 
	//goes from 0.5 (very light) to 1.0 (normal)
	switch (gammaindex) 
	{
		case 0:
			glgamma = 1.0; 
			break;
	    case 1:
			glgamma = 0.9; 
			break;
	    case 2:
			glgamma = 0.8; 
			break;
	    case 3:
			glgamma = 0.75; 
			break;
	    case 4:
			glgamma = 0.7; 
			break;
	    case 5:
			glgamma = 0.65; 
			break;
	    case 6:
			glgamma = 0.6; 
			break;
	    case 7:
			glgamma = 0.5; 
			break;
	}

	if (glgamma == 1.0)	{
		for (i=0 ; i<256 ; i++)
			glgammatable[i] = i;
	}else{
		for (i=0 ; i<256 ; i++)
		{
			value = 255 * pow ( (i+0.5)/255.5 , glgamma ) + 0.5;
			if (value < 0)
				value = 0;
			if (value > 255)
				value = 255;
			glgammatable[i] = value;
		}
	}

}




Uint32* ReadPalette(int lump) {
    if (texauxinfo[lump].pal) {
	return texauxinfo[lump].pal;
    }
    Uint8* buf=W_CacheLumpNum(lump,PU_STATIC,CvtNull,0);
    Uint32* newpal=(Uint32*) malloc(256*4);
    convertpal(buf,newpal,0);
    return (texauxinfo[lump].pal=newpal);

}
Uint32* GLGetPalette(int lump) {
    if (texauxinfo[lump].pal) {
	return texauxinfo[lump].pal;
    }
    return gampal;

}

// index 0 is no colormap

void copy2d (Uint32 * spix, int smw, int smh, Uint32 * dpix, int dmw, int dmh,
	     int sx, int sy, int dx, int dy, int cw, int ch)
{
    if (dx < 0) {
	sx -= dx;
	cw += dx;
	dx = 0;
    }
    if (dy < 0) {
	sy -= dy;
	ch += dy;
	dy = 0;
    }
    if (dx + cw > dmw) {
	cw = dmw - dx;
    }
    if (dy + ch > dmh) {
	ch = dmh - dy;
    }
    if (cw <= 0 || ch <= 0)
	return;
    Uint32 *spos = spix + (sx + smw * sy);
    Uint32 *dpos = dpix + (dx + dmw * dy);
    int sskip = smw;
    int dskip = dmw;
    int yy;
    for (yy = 0; yy < ch; yy++, spos += sskip, dpos += dskip) {
	memcpy (dpos, spos, cw << 2);
    }
}
void copy2d16 (Uint16 * spix, int smw, int smh, Uint16 * dpix, int dmw, int dmh,
	     int sx, int sy, int dx, int dy, int cw, int ch)
{
    if (dx < 0) {
	sx -= dx;
	cw += dx;
	dx = 0;
    }
    if (dy < 0) {
	sy -= dy;
	ch += dy;
	dy = 0;
    }
    if (dx + cw > dmw) {
	cw = dmw - dx;
    }
    if (dy + ch > dmh) {
	ch = dmh - dy;
    }
    if (cw <= 0 || ch <= 0)
	return;
    Uint16 *spos = spix + (sx + smw * sy);
    Uint16 *dpos = dpix + (dx + dmw * dy);
    int sskip = smw;
    int dskip = dmw;
    int yy;
    for (yy = 0; yy < ch; yy++, spos += sskip, dpos += dskip) {
	memcpy (dpos, spos, cw<<1);
    }
}

#define STOVERLAP 64

#define TRANSOVR 1





int checkalpha(Uint32* tex, int w, int cw, int ch) {
    int skip=w-cw;
    int i,j;
    for (i=0;i<ch;i++,tex += skip) {
	for (j=0;j<cw;j++,tex++) {
	    if (ALPHACMP(*tex)!=0xFF) return 1;
	}
    }
    return 0;
}
static inline int AverageColour32 (Uint32 * p, int x, int y, int w, int h)
{
    int a, c, n = 0;
    int r = 0, g = 0, b = 0;
    for (a = -1; a <= 1; a++) {
	if (x + a < 0)
	    continue;
	if (x + a >= w)
	    continue;
	for (c = -1; c <= 1; c++) {
	    if (y + c < 0)
		continue;
	    if (y + c >= h)
		continue;
	    if (ALPHACMP (p[(x + a) + w * (y + c)]) > 0) {
		Uint32 t = p[(x + a) + w * (y + c)];
		b += BLUECMP (t);
		g += GREENCMP (t);
		r += REDCMP (t);
		n++;
	    }
	}
    }
    if (n > 0)
	return ((b / n) << BLUE_SHIFT) + ((g / n) << GREEN_SHIFT) +
	    ((r / n) << RED_SHIFT);
    else
	return 0;
}

static inline void TextureAvg32 (Uint32 * pic, int w, int h)
{

    Uint32 *f = pic;

    int x, y;

    for (y = 0; y < h; y++)
	for (x = 0; x < w; x++) {
	    if (ALPHACMP (*f) == 0) {
		*f = AverageColour32 (pic, x, y, w, h);
	    }
	    f++;
	}
}

#ifndef GL_EXT_texture_filter_anisotropic
#define GL_TEXTURE_MAX_ANISOTROPY_EXT     0x84FE
#define GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT 0x84FF
#endif

static void SetAnisotropic(void) {
    static int supported=1;
    GLfloat aniso; 

    checkGLStatus();

    //#ifdef GL_EXT_texture_filter_anisotropic
    if (supported) {
	glGetFloatv(GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT, &aniso); 
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAX_ANISOTROPY_EXT, aniso);
	if (glGetError()!=GL_NO_ERROR) {
	    fprintf(stderr,"Warning: Anisotropic filtering not supported by driver, using trilinear filtering.\n");
	    supported=0;
	}
    }
    //#else
    //anisotropic=0;
    //fprintf(stderr,"Warning: Anisotropic filtering not supported at compile time, using trilinear filtering.\n");
    //#endif

}

//#define USE_GLU_MIPMAPS

#ifdef USE_GLU_MIPMAPS

void BuildMipmaps(Uint32* pix, int w, int h, int hasalpha, int maxlevel) {
    if (hasalpha) TextureAvg32(pix,w,h);
    glPixelStorei (GL_UNPACK_ROW_LENGTH, w);
    gluBuild2DMipmaps(GL_TEXTURE_2D,hasalpha?GL_RGBA:GL_RGB,w,h,GL_RGBA,GL_UNSIGNED_BYTE,pix);
}
#else

void ShrinkImageWeight (Uint32* src, Uint32* dest, int sw, int sh, int xs, int ys) {
    int dw=sw/xs;
    int dh=sh/ys;
    int sx,sy, dx,dy, xi, yi;
    double r,g,b,a;
    double rt,gt,bt,at;
    double wrt,wgt,wbt;
    double pixscl=(255.0/(xs*ys));
    double cpixscl;
    int ir,ig,ib,ia;
    for (sy=0,dy=0;dy<dh;sy+=ys,dy++) {
	for (sx=0,dx=0;dx<dw;sx+=xs,dx++) {
	    rt=0; gt=0;
	    bt=0; at=0;
	    for (yi=0;yi<ys;yi++)
		for (xi=0;xi<xs;xi++) {
		    Uint32 sp=src[sx+xi + (sy+yi)*sw];
		    a = ALPHACMP(sp)/255.0;
		    r = REDCMP(sp)/255.0;
		    g = GREENCMP(sp)/255.0;
		    b = BLUECMP(sp)/255.0;
		    rt += r; gt += g;
		    bt += b; at += a;
		    wrt += r*a;
		    wgt += g*a;
		    wbt += b*a;
		}
	    ia=(at*pixscl);
	    if (at==0.0) {
		ir=rt*pixscl;
		ig=gt*pixscl;
		ib=bt*pixscl;
	    } else {
		cpixscl=255.0/at;
		ir=rt*cpixscl;
		ig=gt*cpixscl;
		ib=bt*cpixscl;
	    }
	    *(dest++) = ir<<RED_SHIFT | ib<<BLUE_SHIFT | ig<<GREEN_SHIFT | ia<<ALPHA_SHIFT;
	}
    }
}
#ifndef min
#define min(x,y) ({ typeof(x) _x_; typeof(y) _y_; _x_=(x); _y_=(y); _x_ < _y_ ? _x_ : _y_ })
#endif

void ShrinkImage (Uint32* src, Uint32* dest, int sw, int sh, int xs, int ys) {
    int dw=sw>>xs;
    int dh=sh>>ys;
    int sx,sy, dx,dy, xi, yi;
    int rt,gt,bt,at;
    int xsk=1<<xs;
    int ysk=1<<ys;
    int scale=xs+ys;
    for (sy=0,dy=0;dy<dh;sy+=ysk,dy++) {
	for (sx=0,dx=0;dx<dw;sx+=xsk,dx++) {
	    rt=0; gt=0;
	    bt=0; at=0;
	    for (yi=0;yi<ysk;yi++)
		for (xi=0;xi<xsk;xi++) {
		    Uint32 sp=src[sx+xi + (sy+yi)*sw];
		    rt += REDCMP(sp);
		    gt += GREENCMP(sp);
		    bt += BLUECMP(sp);
		    at += ALPHACMP(sp);
		}
	    rt>>=scale;
	    gt>>=scale;
	    bt>>=scale;
	    at>>=scale;
	    *(dest++) = rt<<RED_SHIFT | bt<<BLUE_SHIFT | gt<<GREEN_SHIFT | at<<ALPHA_SHIFT;
	}
    }
}
#define TWO_BUFFERS
void BuildMipmaps(Uint32* pix, int w, int h, int hasalpha, int maxmips) {
    int format=hasalpha?GL_RGBA:GL_RGB;
    Uint32* bufs[16];
    bufs[0]=pix;

#ifdef TWO_BUFFERS
    Uint32* buf1=malloc((w>>1)*(h>>1)*4);
    Uint32* buf2=malloc((w>>1)*(h>>1)*4);
    bufs[1] = bufs[3] = bufs[5] = bufs[7] = bufs[9] = bufs[11]= buf1;
    bufs[2] = bufs[4] = bufs[6] = bufs[8] = bufs[10]= bufs[12]= buf2;
#else
    int z;
    for (z=1;z<16;z++) {
	bufs[z]=malloc((w>>1)*(h>>1)*4);
    }
#endif
    int cw=w;
    int ch=h;
    int ow, oh;
    int xs, ys;
    int level=0;

    while (1) {
	if (hasalpha) TextureAvg32(bufs[level],cw,ch);
	glPixelStorei (GL_UNPACK_ROW_LENGTH, cw);
	glTexImage2D (GL_TEXTURE_2D,level, format, cw, ch, 0, GL_RGBA,
		      GL_UNSIGNED_BYTE, bufs[level]);
	glFinish();
	if (cw<=1 && ch<=1 ) break;
	ow=cw; oh=ch;
	xs=0; ys=0;
	if (cw>1) { cw >>= 1; xs=1; }
	if (ch>1) { ch >>= 1; ys=1; }
	level++;
	if (!(maxmips!=-1 && level>=maxmips)) ShrinkImage(bufs[level-1],bufs[level],ow,oh,xs,ys);
    }
#ifdef TWO_BUFFERS
    free(buf1); free(buf2);
#else
    for (z=1;z<16;z++) {
	free(bufs[z]);
    }
#endif
}

#endif /*USE_GLU_MIPMAPS*/

void ClampTexture(Uint32* tex, int w, int h, int clampx, int clampy) 
{
    int x,y;

	//bna hack if we return here we dont get top errors 
	//in graphics, why ?
	return ;


	if (clampy<h){
		for (x=0;x<w;x++) {
			int pix = tex[x+clampy*w];
			for (y = clampy+1; y<h ;y++) {
				tex[x+y*w] = pix;
			}
		}
		if (clampx<w)
		for (y=0;y<h;y++) {
			int pix = tex[clampx+y*w];
			for (x = clampx+1;x<w;x++) {
				tex[x+y*w] = pix;
			}
		}
	}
}

void UploadTexture(GLuint tex, void* pixels, int w, int h,  int repx, int repy, int hasalpha, int mipmaps) {
    BindTex( tex);
    checkGLStatus ();

    glPixelStorei (GL_UNPACK_SKIP_PIXELS, 0);
    glPixelStorei (GL_UNPACK_SKIP_ROWS, 0);
    glPixelStorei (GL_UNPACK_ALIGNMENT, 1);
    checkGLStatus ();

    glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, repx?GL_REPEAT:GL_CLAMP_TO_EDGE);
    glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, repy?GL_REPEAT:GL_CLAMP_TO_EDGE);
    glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, partialfilter);
    glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, mipmaps?fullfilter:partialfilter);

    if (mipmaps && (fullfilter!=GL_NEAREST) && (fullfilter!=GL_LINEAR)) {

	SetAnisotropic();
	BuildMipmaps (pixels, w, h, hasalpha,mipmaps);
    } else {
	glTexImage2D (GL_TEXTURE_2D,0, hasalpha?GL_RGBA:GL_RGB, w, h, 0, GL_RGBA,
			   GL_UNSIGNED_BYTE, pixels);
    }
    checkGLStatus ();
}

byte identity[256];

Uint8* GetColorMap(int color) {
    if (color > 0) {
	return playermaps[color - 1] + (1 << 12);
    }
    return identity;
}


#define REPEAT_X 1
#define REPEAT_Y 2
#define REPEAT_BOTH 3
#define REPEAT_AUTO 4

enum {  FT_PATCH, LT_TPATCH, LT_LPIC, LT_WALL };

/*
 * ROTT stores no information about type in the
 * WAD file, so we have to guess. Luckily, it's not that 
 * hard.
 */

/*
 * Rule for patches: patch->collumnofs[0] == patch->width*2 + 10
 */

int getinfo_patch (Uint8* lump, int len, texbufinfo_t* ti)
{
    patch_t *ppat = (patch_t *) lump;
    if (len <= 10) return 0; // Too short for a patch
    int cofs=IntelShort(ppat->collumnofs[0]);
    int width=IntelShort(ppat->width);

    if (cofs != (10 + width * 2)) {
	return 0;
    }
    // Manually run the converter on it
    Cvt_patch_t(ppat,1);

    int rw,rh,w,h,lo,to;

    ti->rw = rw = ppat->width;
    ti->rh = rh = ppat->height;
    ti->w = w = powerof2 (rw);
    ti->h = h = powerof2 (rh);
    ti->lofs = lo = -ppat->leftoffset;
    ti->tofs = to = -ppat->topoffset;
    ti->osize = ppat->origsize;



    if (ti->rep == REPEAT_AUTO) {
	ti->rep = 0;
	if (lo == 0 && rw == ppat->origsize)
	    ti->rep |= REPEAT_X;
	if (to == 0 && rh == ppat->origsize)
	    ti-> rep |= REPEAT_Y;
    }
    return 1;
}



Uint32 *convert_patch (Uint8* lump, int len, Uint32* gampal, Uint8* col, texbufinfo_t* ti)
{
    patch_t *ppat = (patch_t *) lump;
    Uint32 *pic = (Uint32 *) malloc (ti->w * ti->h * 4);
    memset (pic, 0, ti->w * ti->h * 4);
    int i, j, ofs,rlen;
    Uint32 *idpos = pic;
    Uint8 *spos;
    Uint32 *dpos;
    unsigned short *ccolofs = ppat->collumnofs;
    for (i = 0; i < ti->rw; i++, ccolofs++) {
	spos = (((Uint8 *) ppat) + (*ccolofs));
	while (1) {
	    if ((ofs = *(spos++)) == 0xFF) {
		break;
	    } else {
		rlen = *(spos++);
		dpos = (idpos + (i + (ti->w * ofs)));
		for (j = 0; j < rlen; j++, spos++, dpos += ti->w)
		    *dpos = gampal[col[*spos]] |(255<<ALPHA_SHIFT);
	    }
	}
    }
    return pic;
}




int getinfo_tpatch (Uint8* lump, int len, texbufinfo_t* ti)
{
    transpatch_t *ppat = (transpatch_t *) lump;
    if (len <= 12) return 0; // Too short for a transpatch

    int cofs=IntelShort(ppat->collumnofs[0]);
    int width=IntelShort(ppat->width);

    if (cofs != (12 + width * 2)) {
	return 0;
    }
    Cvt_transpatch_t(ppat,1);
    int rw,rh,w,h,lo,to;

    ti->rw = rw = ppat->width;
    ti->rh = rh = ppat->height;
    ti->w = w = powerof2 (rw);
    ti->h = h = powerof2 (rh);
    ti->lofs = lo = -ppat->leftoffset;
    ti->tofs = to = -ppat->topoffset;
    ti->osize = ppat->origsize;


    if (ti->rep == REPEAT_AUTO) {
	ti->rep = 0;
	if (lo == 0 && rw == ppat->origsize)
	    ti->rep |= REPEAT_X;
	if (to == 0 && rh == ppat->origsize)
	    ti-> rep |= REPEAT_Y;
    }
    return 1;
}




Uint32 *convert_tpatch (Uint8* lump, int len, Uint32* gampal, Uint8* col, texbufinfo_t* ti)
{
    transpatch_t *ppat = (transpatch_t *) lump;
    Uint32 *pic = (Uint32 *) malloc (ti->w * ti->h * 4);
    memset (pic, 0, ti->w * ti->h * 4);
    int i, j, ofs, rlen;
    Uint32 *idpos = pic;
    Uint8 *spos;
    Uint32 *dpos;

    int tmask = (63 - ppat->translevel) << (ALPHA_SHIFT+2);
    unsigned short *ccolofs = ppat->collumnofs;
    for (i = 0; i < ti->rw; i++, ccolofs++) {
	spos = (((Uint8 *) ppat) + (*ccolofs));
	while (1) {
	    if ((ofs = *(spos++)) == 0xFF) {
		break;
	    } else {
		rlen = *(spos++);
		int mask = (255<<ALPHA_SHIFT);
		dpos = (idpos + (i + (ti->w * ofs)));
		if (*spos == 254) {
		    for (j = 0; j < rlen; j++, dpos += ti->w)
			*dpos = tmask;
		    spos++;
		} else {
		    for (j = 0; j < rlen; j++, spos++, dpos += ti->w)
			*dpos = gampal[col[*spos]] | mask;
		}
	    }
	}
    }
    return pic;
}


int getinfo_wall (Uint8* ppat, int len, texbufinfo_t* ti)
{
    if (len != 4096) return 0;

    ti->w=ti->h=ti->rw=ti->rh=ti->osize=64;
    ti->lofs=ti->tofs = 0;
    if (ti->rep == REPEAT_AUTO) {
	ti->rep = REPEAT_X | REPEAT_Y;
    }
    return 1;
}



Uint32 *convert_wall (Uint8* ppat, int len, Uint32* gampal, Uint8* col, texbufinfo_t* ti)
{
    int i, j;
    
    Uint32 *pic = (Uint32 *) malloc (64 * 64 * 4);
    Uint8 *spos;
    Uint32 *dpos;
    spos = ppat;
    dpos = pic;
    for (i = 0; i < 64; i++) {
	for (j = 0; j < 64; j++) {
	    *dpos++ = gampal[col[spos[i + 64 * j]]] | (255<<ALPHA_SHIFT);
	}
    }
    return pic;
}



int getinfo_lpic (Uint8* lump, int len, texbufinfo_t* ti)
{
    lpic_t *ppic = (lpic_t *) lump;

    if (len<4) return 0;
    int w = IntelShort(ppic->width);
    int h = IntelShort(ppic->height);

    int expectlen=w*h+8;
    if (len != expectlen) return 0;

    Cvt_lpic_t(ppic,1);

    int rw, rh, lo, to;

    ti->rw = rw = w;
    ti->rh = rh = h;
    ti->w = w = powerof2 (rw);
    ti->h = h = powerof2 (rh);
    ti->lofs = lo = -ppic->orgx;
    ti->tofs = to = -ppic->orgy;
    ti->osize = (w<h?h:w);
    return 1;
}



Uint32 *convert_lpic (Uint8* lump, int len, Uint32* gampal, Uint8* col, texbufinfo_t* ti)
{
    lpic_t *ppic = (lpic_t *) lump;
    Uint32 *buf = (Uint32 *) malloc (ti->w * ti->h * 4);
    memset(buf,0,ti->w * ti->h * 4);
    int i, j, ofs;
    Uint8 *spos;
    Uint32 *dpos;
    spos = ((Uint8 *) ppic) + 8;
    for (i = 0; i < ti->rh; i++) {
	for (j = 0; j < ti->rw; j++) {
	    buf[i * ti->w + j] = gampal[col[spos[i + ti->rh * j]]] | (255<<ALPHA_SHIFT);
	}
    }
    return buf;
}

typedef Uint32* (*convertfunc)(Uint8* lump, int len,
			       Uint32* pal, Uint8* colmap, texbufinfo_t* ti);

typedef int (*getinfofunc)(Uint8* lump, int len,
			       texbufinfo_t* ti);

typedef struct {
    getinfofunc getinfo;
    convertfunc convert;
} convertinfo_t;
static convertinfo_t converters[] = {
#define func(f) {getinfo_##f,convert_##f}
    func(patch),
    func(tpatch),
    func(lpic),
    func(wall),
    {NULL,NULL}
};

static convertinfo_t* GetInfo(Uint8* buf, int len, texbufinfo_t* ti) {
    convertinfo_t *cur=&converters[0];
    int ret=0;
    while (cur->getinfo) {
	ret=cur->getinfo(buf,len,ti);
	if (ret) return cur;
	cur++;
    }
    return NULL;
}

#define TRANSTEX(tn,rsx,rsy,fsx,fsy,rdx,rdy,adx,ady,cw,ch)					\
if (texauxinfo[lump].trans[tn]) {								\
    int tl=(texauxinfo[lump].trans[tn])&0x3FFF;							\
    Uint32* ctbuf=										\
	transcvt[tn]->convert(tbuf[tn],tlen[tn],GLGetPalette(tl),				\
			      GetColorMap(i),ctrans);      					\
    												\
 												\
    /*if(checkalpha(tbuf,trans.w,trans.rw,trans.rh))mhasalph=1;*/				\
    if ((texauxinfo[lump].trans[tn])&0x4000) {							\
	sx=fsx; sy=fsy;										\
    } else {											\
	sx=rsx; sy=rsy;										\
    }												\
    dx=rdx;											\
    dy=rdy;											\
    sx -= ctrans->lofs;										\
    dx -= mtrans.lofs;										\
    sy -= ctrans->tofs;										\
    dy -= mtrans.tofs;										\
    dx ++;											\
    dy ++;											\
    copy2d(ctbuf,ctrans->w,ctrans->h,nbuf,nw,nh,sx,sy,dx,dy,cw,ch);				\
												\
    if ((texauxinfo[lump].trans[tn])&0x8000)							\
	copy2d(ctbuf,ctrans->w,ctrans->h,nbuf,nw,nh,fsx,fsy,adx+1,ady+1,cw,ch);			\
												\
    free(ctbuf);										\
}
/*
gl_lumpinfo_t* GLLoadFont(int lump) {
    gl_lumpinfo_t* ret=&lumpinfo[lump];
    glfont_t* font=(glfont_t*)malloc(sizeof(glfont_t));
    if (ret->type==LT_FONT) {
	return ret;
    }
    if (ret->type!=LT_FONT) {
	return NULL;
    }
    font_t* in=W_CacheLumpNum(lump,PU_CACHE,Cvt_font_t,0);
    ret->type=LT_FONT;
    int i,j,k;
    int width=0;
    k=0;
    for (j=0;j<16;j++) {
	int totalwidth=17;//borders
	for (i=0;i<16;i++,k++) {
	    totalwidth += in->width[k];
	}
	if (width<totalwidth) width=totalwidth;
    }
    int realheight=17+(16*in->height);
    
    int w=powerof2(width);
    int h=powerof2(height);
    
    Uint32* pic=(Uint32*) malloc(w*h*4);
    Uint8* spos;
    int cy=0;
    k=0;
    for (j=0;j<16;j++) {
	int cx=0;
	for (i=0;i<16;i++,k++) {
	    int xx,yy;
	    int cw=in->width[k];
	    spos=(&in->data)+in->charofs[;
	    for (xx=0;xx<;xx++) 
	    totalwidth += ;
	}
	if (maxwidth<totalwidth) maxwidth=totalwidth;
    }
    
    Uint32* dpos=
}
*/
int 
#ifdef WIN32
__cdecl
#endif
compar_ptr(const void* a, const void* b) {
    if (*((void**)a) < *((void**)b)) return -1;
    if (*((void**)a) > *((void**)b)) return 1;
    return 0;
}




gl_lumpinfo_t* GetTexForLump (int lump, int repeat)
{
    int i;
    Uint8* buf;
    int len;
    texbufinfo_t mtrans;
    convertinfo_t* cvt;

    Uint8* tbuf[4];
    Uint8* bufs2free[5];
    int tlen[4];
    texbufinfo_t trans[4];
    convertinfo_t* transcvt[4];

    int nw=0, nh=0;
    


    gl_lumpinfo_t* ret=&lumpinfo[lump];
    if (ret->type==LT_TEXTURE) {
	return ret;
    }
    if (ret->type!=LT_UNKNOWN) {
	return &invalid;
    }
    ret->type=LT_TEXTURE;
    mtrans.rep=repeat;

    buf=GL_W_CacheLumpNum(lump,PU_STATIC,CvtNull,0); // converters will do the endian converting
 	if (buf == 0){
        *ret=invalid;               
        return ret;
    }
    len=W_LumpLength(lump);
    cvt=GetInfo(buf,len,&mtrans);
    
    if (!cvt) {
    	SoftError ("WTF is this? %d %s\n",lump,W_GetNameForNum(lump));
    	*ret=invalid;
    	return ret;
    }
    if (texauxinfo[lump].transused) {
	nw = powerof2 (mtrans.rw + 2);
	nh = powerof2 (mtrans.rh + 2);
	for (i=0;i<4;i++) {
	    if (texauxinfo[lump].trans[i]) {
		int clump=texauxinfo[lump].trans[i]&0x3FFF;
		tbuf[i] = GL_W_CacheLumpNum(clump,PU_STATIC,CvtNull,0);
		if (tbuf[i] == 0){
           *ret=invalid;               
           return ret;
        }
		tlen[i]=W_LumpLength(clump);
		transcvt[i]=GetInfo(tbuf[i],tlen[i],&trans[i]);
		if (!transcvt[i]) {
		    SoftError ("WTF is this? %d %s\n",clump,W_GetNameForNum(clump));
		    *ret=invalid;
		    return ret;
		}
	    } else {
		tbuf[i]=NULL;transcvt[i]=NULL;
		tlen[i]=0;
	    }
	}
    }

    for (i=0;i<MAXPLAYERCOLORS+1;i++) {
	if (i==0||texauxinfo[lump].colorsused[i-1]) {
	    Uint8* col=GetColorMap(i);
	    Uint32* mbuf=cvt->convert(buf,len,GLGetPalette(lump),col,&mtrans);
	    int ctex=0;
	    glGenTextures(1,&ctex);

	    if (texauxinfo[lump].transused) {
#define trw ctrans->rw
#define trh ctrans->rh
#define mrw mtrans.rw
#define mrh mtrans.rh

		Uint32 *nbuf = (Uint32 *) malloc (nw * nh * 4);
		memset (nbuf, 0, nw * nh * 4);
		copy2d (mbuf, mtrans.w, mtrans.h, nbuf, nw, nh, 0, 0, 1, 1, mrw, mrh);
		int sx, sy, dx, dy;
		int ti;
		//(trl,rsx,rsy,fsx,fsy,rdx,rdy,adx,ady,cw,ch)
		texbufinfo_t* ctrans=&trans[0];
		TRANSTEX (0, 0,       trh - 1, 0,       0,       0,   -1,  0,       0,       trw, 1); ctrans++;
		TRANSTEX (1, 0,       0,       0,       trh - 1, 0,   mrh, 0,       mrh - 1, trw, 1); ctrans++;
		TRANSTEX (2, trw - 1, 0,       0,       0,      -1,   0,   0,       0,       1, trh); ctrans++;
		TRANSTEX (3, 0,       0,       trw - 1, 0,       mrh, 0,   mrw - 1, 0,       1, trh);
		free (mbuf);
#undef trw
#undef trh
#undef mrw
#undef mrh
		ClampTexture(nbuf,nw,nh,mtrans.rw+1,mtrans.rh+1);
		UploadTexture(ctex,nbuf,nw,nh,0,0,1,20);
		free (nbuf);

	    } else {
		ClampTexture(mbuf,mtrans.w,mtrans.h,mtrans.rw-1,mtrans.rh-1);
		UploadTexture(ctex,mbuf,mtrans.w,mtrans.h,mtrans.rep&REPEAT_X,mtrans.rep&REPEAT_Y,1,20);
		free (mbuf);
	    }

	    ret->tex.texnum[i]=ctex;
	} else {
	    ret->tex.texnum[i]=ret->tex.texnum[0];
	}
    }
    int nfreebufs=0;
    //Z_Free (buf); // save memory: we don't need the 8bit texture
    bufs2free[nfreebufs++]=buf;
    ret->tex.w=mtrans.rw;
    ret->tex.h=mtrans.rh;
    ret->tex.lofs=mtrans.lofs;
    ret->tex.tofs=mtrans.tofs;
    ret->tex.osize=mtrans.osize;
    if (texauxinfo[lump].transused) {
 	ret->tex.tcxl = 1 / (double)nw;
	ret->tex.tcxh = (double)(mtrans.rw + 1) / (double)nw;
	ret->tex.tcyl = 1 / (double)nh;
	ret->tex.tcyh = (double)(mtrans.rh + 1) / (double)nh;

	mtrans.w=nw;
	mtrans.h=nh;
	mtrans.rw+=2;
	mtrans.rh+=2;
	mtrans.rep=0;
	for (i=0;i<4;i++) {
	    if (texauxinfo[lump].trans[i]) {
		bufs2free[nfreebufs++]=tbuf[i];
	    }
	}
	
    } else {
	ret->tex.tcxl = 0.0;
	ret->tex.tcyl = 0.0;
	ret->tex.tcxh = (double)mtrans.rw/(double)mtrans.w;
	ret->tex.tcyh = (double)mtrans.rh/(double)mtrans.h;
    }
    qsort(bufs2free,nfreebufs,sizeof(void*),compar_ptr);
    Uint8* last=NULL;
    for (i=0;i<nfreebufs;i++) {
	if (bufs2free[i]!=last) {
	    Z_Free(last=bufs2free[i]);
	}
    }
    
    /*
	if ((lump == 3887)||(lump == 3888)){   
       WriteDebug("tex.pal ",texauxinfo[lump].pal);
       WriteDebug("tex.colorsused ",texauxinfo[lump].colorsused);      
       WriteDebug("tex.trans ",texauxinfo[lump].trans);    
       WriteDebug("tex.transused ",texauxinfo[lump].transused);    
            
//		SetTextMode();
//		texauxinfo[lump].pal = ReadPalette( lump); 
		
		//	return ret;
	} */ 
    return ret;
}

void UploadSurfaceToTexture (GLuint tex, SDL_Surface * surf, int repeat, int mipmaps, double* tcx, double* tcy)
{
    SDL_SetAlpha(surf,0,255);
    int nw=powerof2(surf->w);
    int nh=powerof2(surf->h);
    SDL_Surface *conv =
	SDL_CreateRGBSurface (SDL_SWSURFACE, nw, nh, 32, 0x000000FF,
			      0x0000FF00, 0x00FF0000, 0xFF000000);
    SDL_BlitSurface (surf, NULL, conv, NULL);
    if (tcx) *tcx=(double)surf->w/(double)nw;
    if (tcy) *tcy=(double)surf->h/(double)nh;

    int hasalph=checkalpha((Uint32*) surf->pixels, surf->w, surf->w, surf->h);

    UploadTexture(tex,conv->pixels,conv->w,conv->h,repeat,repeat,hasalph,mipmaps);

    SDL_FreeSurface (conv);
}

int LoadImgToTexture (const char *fname, int repeat, int mipmaps)
{
    char buf[255];
    sprintf(buf,"%s/%s",GLPath,fname);
    SDL_Surface *tmp = IMG_Load (buf);
    if (!tmp) return -1;
    GLuint ret;
    glGenTextures (1, &ret);
    UploadSurfaceToTexture (ret, tmp, repeat, mipmaps, NULL, NULL);
    SDL_FreeSurface (tmp);
    return ret;
}

void PrecacheGroup (const char *name)
{
    int i;
    char buf[32];
    sprintf (buf, "%sstrt", name);
    int start = W_GetNumForName (buf) + 1;
    sprintf (buf, "%sstop", name);
    int end = W_GetNumForName (buf);
    for (i = start; i < end; i++) {
	GetTexForLump (i, REPEAT_AUTO);
    }
}



static skintex* LoadSkin(const char* fname) {
    int i;
    for (i=0;i<nskins;i++) {
	if (!strcmp(skins[i].name,fname)) {
	    return &skins[i];
	}
    }
    if (!nskins) {
	skins=(skintex*)malloc(8*sizeof(skintex));
    } else if (!(nskins&7)) {
	skins=(skintex*)realloc(skins,(nskins+8)*sizeof(skintex));
    }
    skins[nskins].name=strdup(fname);
    if ((skins[nskins].tex=LoadImgToTexture(fname,1,20))==-1) {
	Error("Could not load image file %s: %s\n",fname,strerror(errno));
    }
    
    return &skins[nskins++];
}

#if 0
#include "model.tab.c"


static void compile_model(model* mod, cmodel* ret) {
    int i,j,k;
    for (i=0;i<4;i++) {
	//ret->shapes[i]=NEW(cshape_list);
	ret->shapes[i].nshapes=mod->shapes[i].nshapes;
	ret->shapes[i].shapes=NEWARR(cshape,mod->shapes[i].nshapes);
	for (j=0;j<mod->shapes[i].nshapes;j++) {

	    ret->shapes[i].nverts=0;
	    for (j=0;j<mod->shapes[i].nshapes;j++) {
		ret->shapes[i].shapes[j].nverts=mod->shapes[i].shapes[j].nverts;
		ret->shapes[i].shapes[j].type=mod->shapes[i].shapes[j].type;
		ret->shapes[i].shapes[j].tex=mod->shapes[i].shapes[j].tex;
		ret->shapes[i].shapes[j].normal=mod->shapes[i].shapes[j].normal;
		ret->shapes[i].shapes[j].vertindex=ret->shapes[i].nverts;
		ret->shapes[i].nverts += mod->shapes[i].shapes[j].nverts;
	    }
	    ret->shapes[i].vertlist=NEWARR(m_vertex,ret->shapes[i].nverts);
	    ret->shapes[i].texcoords=NEWARR(m_texcoord,ret->shapes[i].nverts);

	    for (j=0;j<mod->shapes[i].nshapes;j++) {
		memcpy(ret->shapes[i].vertlist  + ret->shapes[i].shapes[j].vertindex,mod->shapes[i].shapes[j].verts,
		       sizeof(m_vertex)*mod->shapes[i].shapes[j].nverts);
		memcpy(ret->shapes[i].texcoords + ret->shapes[i].shapes[j].vertindex,mod->shapes[i].shapes[j].texcoords,
		       sizeof(m_texcoord)*mod->shapes[i].shapes[j].nverts);
		free(mod->shapes[i].shapes[j].verts);
		free(mod->shapes[i].shapes[j].texcoords);
	    }
	}
	free(mod->shapes[i].shapes);
    }
}


static int LoadModel(const char* fname) 
{
       
       
    int i;

    
    for (i=0;i<nmodels;i++) {
	if (!strcmp(models[i]->name,fname)) {
	    return i;
	}
    }
    if (!nmodels) {
	models=(model*)malloc(8*sizeof(model));
    } else if (!(nmodels&7)) {
	models=(model*)realloc(models,(nmodels+8)*sizeof(model));
    }

    MAKEBUF(sname,255,"%s/%s",GLPath,fname);
    FILE* f=fopen(sname,"r");
    if (!f) {
	Error("Could not load model file %s: %s\n",fname,strerror(errno));
    }
    yyparm_t parm;
    model tmp;
    parm.ret=&tmp;
    parm.getc=filegetc;
    parm.ungetc=fileungetc;
    parm.getcparm=f;

    yyparse(&parm);

    compile_model(&tmp,&models[nmodels]);
    .name=strdup(fname);
    nmodels++;
    return &models[nmodels-1];
}
#else
#define SwapIntelNone(X)
 
#define READER(name,type,converter,size) 	\
type read_##name(FILE* fil) {			\
    type t;					\
    fread(&t,size,1,fil);			\
    SwapIntel##converter(&t);			\
    return t;					\
}

READER(ushort,unsigned short,Short,2);
READER(short,short,Short,2);
READER(ulong,unsigned long,Long,4);
READER(long,long,Long,4);

READER(double,double,None,8);

static model* LoadModel(const char* fname) 

{
    int i,j;

	char md2name[256];  
    char*ptr;//md2fix

	//check if its a md2 entry
	memset(md2name,0,sizeof(md2name));//md2fix
	ptr = strstr(fname,":");//md2fix
	if (ptr != 0){//md2fix
		//yes its a md2 model
		lstrcpy(md2name,ptr+1);
		*ptr = 0;//cut of the md2 name and load dummy entry tmd
	}   
    
    
    
    for (i=0;i<nmodels;i++) {
	if (!strcmp(models[i]->name,fname)) {
	    return models[i];
	}
    }
    if (!nmodels) {
	models=(model**)malloc(8*sizeof(model*));
    } else if (!(nmodels&7)) {
	models=(model**)realloc(models,(nmodels+8)*sizeof(model*));
    }

    MAKEBUF(sname,255,"%s/%s",GLPath,fname);
    FILE* fil=fopen(sname,"rb");
    if (!fil) {
	Error("Could not load model file %s: %s\n",fname,strerror(errno));
    }
    char buf[255];
    fread(buf,4,1,fil);
    buf[4]=0;
    if (memcmp(buf,"SMDL",4)) {
	Error("File %s: invalid sig %s\n",fname,buf);
    }
    model *cur=(model*)malloc(sizeof(model));
    models[nmodels]=cur;
    cur->flags=read_ulong(fil);
    cur->px=read_double(fil);
    cur->py=read_double(fil);
    cur->pz=read_double(fil);
    
    //cur->name=strdup(fname);
 
   	cur->name = malloc( 264);//md2fix
	//_strdup(fname);
	lstrcpy(cur->name, fname);
	if (md2name[0] != 0)//md2fix
		lstrcpy(cur->name, md2name);//md2fix

    
    for (i=0;i<4;i++) {
	shape_list* csl=&cur->shapes[i];
	csl->nverts=read_ulong(fil);
	m_vertex* cvt = csl->vertlist = (m_vertex*)malloc(csl->nverts*sizeof(m_vertex));
	m_texcoord* ctc = csl->texcoords = (m_texcoord*)malloc(csl->nverts*sizeof(m_texcoord));
	for (j=0;j<csl->nverts;j++,cvt++) {
	    cvt->x=read_double(fil);
	    cvt->y=read_double(fil);
	    cvt->z=read_double(fil);
	}
	for (j=0;j<csl->nverts;j++,ctc++) {
	    ctc->x=read_double(fil);
	    ctc->y=read_double(fil);
	}
	csl->nshapes=read_ulong(fil);
	shape *csh= csl->shapes = (shape*)malloc(csl->nshapes*sizeof(shape));
	for (j=0;j<csl->nshapes;j++,csh++) {
	    csh->type=fgetc(fil);
	    int strlen=read_ushort(fil);
	    fread(buf,1,strlen,fil);
	    buf[strlen]=0;
	    csh->tex=LoadSkin(buf)->tex;
	    csh->flags=read_ushort(fil);
	    csh->vertindex=read_ulong(fil);
	    csh->nverts=read_ulong(fil);
	}
    }
    fclose(fil);
    nmodels++;
    return cur; 
}

#endif
void LoadSky (int which)
{
    char buf[32];
    int i;
    printf ("Loading sky %d\n", which);
#ifdef KEEP_SKYS
    if (skytex[which][0])
	return;
#else
    if (lastsky==which)
	return;
    for (i = 0; i < 6; i++) {
	glDeleteTextures(1,&skytex[i]);
    }
    lastsky=which;
#endif
    for (i = 0; i < 6; i++) {
	sprintf (buf, "sky%d%d.png",which + 1, i + 1);
#ifdef KEEP_SKYS
	skytex[which][i] = LoadImgToTexture (buf,0,0);
#else
	skytex[i] = LoadImgToTexture (buf,0,0);
#endif
    }
}


void GLCalcShroomHue();
static int onesave = 0;

void GLInit (void)
{
    int i;
    float fl;
	BOOL bexit;
	char *ptr;
        
    screenbufferwidth = 320;
    screenbufferheight = 200;

    WriteLBtext("Entering InitMD2");
    InitMD2 ();//md2fix
    
#ifdef ONETEX
    glGenTextures (1, &screenbuffertexture);
#else
    glGenTextures (48, screenbuffertextures);
#endif
    screenbuffer = malloc (screenbufferwidth * screenbufferheight);
    //screenratio=glscreenh/(double)glscreenw;
    int gl_numlumps=W_NumLumps();
    lumpinfo = (gl_lumpinfo_t*) malloc(gl_numlumps*sizeof(gl_lumpinfo_t));
    texauxinfo = (texauxinfo_t*) malloc(gl_numlumps*sizeof(texauxinfo_t));
     /*
    WriteDebug("gl_lumpinfo_t size = ",sizeof(gl_lumpinfo_t));
    WriteDebug("texauxinfo_t size = ",sizeof(texauxinfo_t));
    
    gl_lumpinfo_t* tst;
    WriteDebug("tst->font size = ",sizeof(tst->font));
    WriteDebug("tst->mod size = ",sizeof(tst->mod));
    WriteDebug("tst->tex size = ",sizeof(tst->tex));
    WriteDebug("tst->type size = ",sizeof(tst->type));       
   
   WriteDebug("tst->tex size = ",sizeof(tst->tex));
   
   
   WriteDebug("tst->tex.h size = ",sizeof(tst->tex.h)) ;
   WriteDebug("tst->tex.lofs size = ",sizeof(tst->tex.lofs)) ;
   WriteDebug("tst->tex.osize size = ",sizeof(tst->tex.osize)) ;
   WriteDebug("tst->tex.tcxh size = ",sizeof(tst->tex.tcxh) );
   WriteDebug("tst->tex.tcxl size = ",sizeof(tst->tex.tcxl) );
   WriteDebug("tst->tex.tcyh size = ",sizeof(tst->tex.tcyh) );
   WriteDebug("tst->tex.tcyl size = ",sizeof(tst->tex.tcyl) );
   WriteDebug("tst->tex.texnum size = ",sizeof(tst->tex.texnum)) ;
   WriteDebug("tst->tex.tofs size = ",sizeof(tst->tex.tofs) );
   WriteDebug("tst->tex.w size = ",sizeof(tst->tex.w) );
   
      WriteDebug("",0);
	WriteDebug("",0);
    texauxinfo_t* tinfo;

    WriteDebug("texauxinfo_t size = ",sizeof(texauxinfo_t));
    WriteDebug("tinfo->colorsused = ",sizeof(tinfo->colorsused) );
    WriteDebug("tinfo->pal size = ",sizeof(tinfo->pal) );
    WriteDebug("tinfo->trans size = ",sizeof(tinfo->trans) );
    WriteDebug("tinfo->transused size = ",sizeof(tinfo->transused) );
   
       WriteDebug("",0);
	WriteDebug("",0);
    texbufinfo_t* tBinfo;

    WriteDebug("texbufinfo_t size = ",sizeof(texbufinfo_t));
    WriteDebug("tBinfo->h = ",sizeof(tBinfo->h) );
    WriteDebug("tBinfo->lofs size = ",sizeof(tBinfo->lofs) );
    WriteDebug("tBinfo->osize size = ",sizeof(tBinfo->osize) );
    WriteDebug("tBinfo->rep size = ",sizeof(tBinfo->rep) );

    WriteDebug("tBinfo->rh = ",sizeof(tBinfo->rh) );
    WriteDebug("tBinfo->rw size = ",sizeof(tBinfo->rw) );
    WriteDebug("tBinfo->tofs size = ",sizeof(tBinfo->tofs) );
    WriteDebug("tBinfo->w size = ",sizeof(tBinfo->w) );
*/
    GLPath= getenv("ROTTGL_PATH") ? : "./gl";
    char* trat=getenv("ROTTGL_RATIO");
    int ratnum,ratdenom;
    if (trat && sscanf(trat,"%d:%d",&ratnum,&ratdenom)==2) {
	   screenratio=(double)ratdenom/(double)ratnum; //ratio is inverse
    } else screenratio=0.75;
    
    char* tmode=getenv("ROTTGL_TEXMODE");
    if (tmode) {
    	int mode=atoi(tmode);
    	if (mode>5 || mode<0) {
    	    fprintf (stderr, "Error: invalid mode %d\n",mode);
            WriteDebug("Error: invalid mode %d\n",mode);
    	    SDL_Quit ();
    	    exit(-1);
    	}
    	fullfilter = minfilters[mode];
    	partialfilter = magfilters[mode];
    }
    //bna added
    if ((gltexmode >= 0) && (gltexmode <= 5)){
    	fullfilter = minfilters[gltexmode];
    	partialfilter = magfilters[gltexmode];                  
    }
    
    
    
    char* tcomp=getenv("ROTTGL_COMPAT");
    if (tcomp) {
	   compat=atoi(tcomp);
    }
    Uint8 *pal = (Uint8 *) W_CacheLumpName ("pal", PU_CACHE, CvtNull, 1);
    convertpal (pal, gampal, 0);
    memset (lumpinfo, 0, sizeof (lumpinfo));
    memset (texauxinfo, 0, sizeof (texauxinfo));

    int j;
    char buf[264];
    WriteLBtext("Loading trans.ifo");
    sprintf(buf,"%s/trans.ifo",GLPath);
    FILE *fil = fopen (buf, "r");
    if (!fil) {
    	fprintf (stderr, "Error with transition file: %s\n",
    		 strerror (errno));
  	    WriteDebug("Error with transition file: %s\n",strerror (errno));
        WriteLBtext("Error with transition file: trans.ifo");	 
    	SDL_Quit ();
    	exit(-1);
    }

    while (1) {
	char texname[16], rtopname[16], rbotname[16], rleftname[16],
	    rrightname[16];
	char *topname, *botname, *leftname, *rightname;
	int num, top, bot, left, right;
	int i =
	    fscanf (fil, "%s %s %s %s %s\n", texname, rtopname, rbotname,
		    rleftname, rrightname);
	topname = rtopname;
	botname = rbotname;
	leftname = rleftname;
	rightname = rrightname;
	if (i < 5)
	    break;
	num = W_GetNumForName (texname);
	if (topname[0] == '!') {
	    topname++;
	    texauxinfo[num].trans[0] |= 0x8000;
	}
	if (botname[0] == '!') {
	    botname++;
	    texauxinfo[num].trans[1] |= 0x8000;
	}
	if (leftname[0] == '!') {
	    leftname++;
	    texauxinfo[num].trans[2] |= 0x8000;
	}
	if (rightname[0] == '!') {
	    rightname++;
	    texauxinfo[num].trans[3] |= 0x8000;
	}
	if (topname[0] == '@') {
	    topname++;
	    texauxinfo[num].trans[0] |= 0x4000;
	}
	if (botname[0] == '@') {
	    botname++;
	    texauxinfo[num].trans[1] |= 0x4000;
	}
	if (leftname[0] == '@') {
	    leftname++;
	    texauxinfo[num].trans[2] |= 0x4000;
	}
	if (rightname[0] == '@') {
	    rightname++;
	    texauxinfo[num].trans[3] |= 0x4000;
	}

	texauxinfo[num].transused = 1;
	texauxinfo[num].trans[0] |=
	    topname[0] == '~' ? 0 : W_GetNumForName (topname);
	texauxinfo[num].trans[1] |=
	    botname[0] == '~' ? 0 : W_GetNumForName (botname);
	texauxinfo[num].trans[2] |=
	    leftname[0] == '~' ? 0 : W_GetNumForName (leftname);
	texauxinfo[num].trans[3] |=
	    rightname[0] == '~' ? 0 : W_GetNumForName (rightname);

    }
    fclose (fil);

    WriteLBtext("Loading colors.ifo");
    sprintf(buf,"%s/colors.ifo",GLPath);
    fil = fopen (buf, "r");
    if (!fil) {
    	fprintf (stderr, "Error with color file: %s\n",
    		 strerror (errno));
        WriteLBtext("Error with transition file: colors.ifo");		 
  	    WriteDebug("Error with color file: %s\n",strerror (errno));		 
    	SDL_Quit ();
    	exit(-1);
    }

    while (1) {
#define mscanf(str,fmt,...) ({ int _nchar; int _ret=sscanf((str),fmt "%n",## __VA_ARGS__,&_nchar); (str) += _nchar; _ret; })
    	char line[256];
    	char texname[16];
    	char palname[16];
    	char* tstream;
    	int i,col,ofs,num;
    
    	if (!fgets(line,255,fil)) 
           break;
    	tstream=line;
    	i=mscanf (tstream,"%s %s", texname, palname);
    	if (i<2) 
           break;
    	//printf("line=%s Texname=%s\n",line,texname);
    	num = W_GetNumForName (texname);
    	if (num != -1){
        	if (strcmp(palname,"~")) {
        	    int palnum=W_GetNumForName(palname);
        	    texauxinfo[num].pal=ReadPalette(palnum);
        	}
        
        	while (1) {
        	    i=mscanf (tstream,"%d", &col);
        	    if (i<1) 
                   break;
        	    texauxinfo[num].colorsused[col]=1;
        	}
         }
	//fclose(tstream);
    }
    fclose(fil);
    for (i = 0; i < 256; i++) {
    	onediv[i] = 1.0 / (double)i;
    	identity[i] = i;
    }

    int xx = 0, yy = 0;
    /*for(i=0;i<16;i++) {
       double iscl=(1.0-sqrt(i/15.0))*8.0;
       printf("Light rate %d: %f\n",i,iscl); */
    for (xx = 0; xx < LIGHTRAD; xx++) {
	for (yy = 0; yy < LIGHTRAD; yy++) {
	    double dx = (double)(xx - LIGHTOFS) / 8.0;
	    double dy = (double)(yy - LIGHTOFS) / 8.0;
	    double dist = sqrt (dx * dx + dy * dy);
	    /*if (dist > 1.0)
	      dist = 1.0;*/
	    stdlight[xx + (yy << 5)] = exp(-dist);
	}
    }
    glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    glAlphaFunc(GL_GEQUAL,0.5);
    glTexEnvf (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
    for (i = 0; i < 32; i++) {
	    shrooms[i].hue=6.0*(i/32.0);
    }
    GLCalcShroomHue();
    int invtex=LoadImgToTexture("invalid.png",1,20);
    for (i=0;i<MAXPLAYERCOLORS+1;i++) {
	invalid.tex.texnum[i]=invtex;
    }
    invalid.tex.lofs=0;
    invalid.tex.tofs=0;
    invalid.tex.tcxl=0;
    invalid.tex.tcyl=0;
    invalid.tex.tcxh=1;
    invalid.tex.tcyh=1;
    invalid.tex.osize=64;

    //}
    /*int ttex;
       glGenTextures(1,&ttex);
       SDL_Surface* tmp=IMG_Load("precache.png");
       UploadSurfaceToTexture(ttex,tmp);
       SDL_FreeSurface(tmp);
       glEnable(GL_BLEND);
       glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
       //else {
       //  glAlphaFunc(GL_GEQUAL,0.99);
       //  glEnable(GL_ALPHA_TEST);
       // }
       glEnable(GL_TEXTURE_2D);
       glDisable(GL_DEPTH_TEST);

       glTexEnvf(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_MODULATE);
       glMatrixMode(GL_PROJECTION);
       glLoadIdentity();
       gluOrtho2D(0.0, 640.0, 0.0, 480.0);
       glMatrixMode(GL_MODELVIEW);
       glLoadIdentity();

       BindTex(ttex);
       glBegin(GL_QUADS);
       glTexCoord2f(0.0,1.0);
       glVertex3i(0,0,0);
       glTexCoord2f(1.0,1.0);
       glVertex3i(640,0,0);
       glTexCoord2f(1.0,0.0);
       glVertex3i(640,480,0);
       glTexCoord2f(0.0,0.0);
       glVertex3i(0,480,0);
       glEnd();

       SDL_GL_SwapBuffers(); */

    Uint32 begin = SDL_GetTicks ();
    memset (skytex, 0, sizeof (skytex));
    for (i = 0; i < 17; i++) {
	sprintf (buf, "cat%d.png", i);
	catwalk[i] = LoadImgToTexture (buf,0,20);
    }
      if (!NO_MODELS) {
        WriteLBtext("Loading model.ifo");            
		sprintf(buf,"%s\\model.ifo",GLPath);
		fil=fopen(buf,"r");
		if (fil) {
			while (1) {
				int i;
		//		int modn;
				char fname[256];//md2fix
				char lbuf[1024];//md2fix
				int lumpnum = 0;

				//first letter has to be between 0 and 9 else skip it
				bexit = FALSE;
				do{
					fgets(lbuf,sizeof(lbuf),fil);
					if ((*lbuf >= '0')&&(*lbuf <= '9'))
						bexit = TRUE;
				}while ((bexit == FALSE)&&(feof(fil)==0));
				bexit = FALSE;
				ptr = strstr(lbuf,"/");
				if (ptr != 0)
					*ptr = 0;//cut of // text
				
				i = sscanf(lbuf, "%d %s", &lumpnum,fname);
#if (SHAREWARE == 1)		    
                lumpnum -= 302;//shareware version is 302 lumps smaller    	    
#endif				
				if (i == 2){
					lumpinfo[lumpnum].type = LT_MODEL;
					lumpinfo[lumpnum].mod  = LoadModel(fname);
				}
				if (feof(fil) != 0)
					break;

			//	i = fscanf (fil, "%d %s\n", &lumpnum,fname);
			//	if (i < 2)
			//		break;
			//	printf("Model %s for lump %d\n",fname,lumpnum);
			//	lumpinfo[lumpnum].type = LT_MODEL;
			//	lumpinfo[lumpnum].mod  = LoadModel(fname);
			
			}
		}
	}
	
	
    WriteLBtext("Loading npa.png"); 	
    sprintf(buf,"%s/npa.png",GLPath);
    SDL_Surface* tsurf=IMG_Load(buf);
    if (!tsurf || tsurf->format->BytesPerPixel!=1) {
	   memset(savegamescreen,0,16000);
    } else {
    	unsigned char* spos=tsurf->pixels;;
    	int xx,yy;
    	for (yy=0;yy<100;yy++) {
    	    for (xx=0;xx<160;xx++) {
    		savegamescreen[xx*100+yy]=*spos++;
    	    }
    	}
    }

    //skytex[1][0]=catwalk[0][0];
    WriteLBtext("Loading hswitch6");
    hswitch6=W_GetNumForName("hswitch6");
    
    WriteLBtext("Loading walls");    
    PrecacheGroup ("wall");
    
    WriteLBtext("Loading masks");       
    PrecacheGroup ("mask");
    
    WriteLBtext("Loading doors");    
    PrecacheGroup ("door");
    
    WriteLBtext("Loading exits");    
    PrecacheGroup ("exit");
    
    WriteLBtext("Loading sides");  
    PrecacheGroup ("side");
    
    WriteLBtext("Loading elevs");     
    PrecacheGroup ("elev");
    
    IsCrosshairLoaded = TRUE;
    WriteLBtext("Loading crosshairs");   
	if (CH_LoadCrosshair() == FALSE){
		//try once more in case we have written a def crosshair.ifo
		if (CH_LoadCrosshair() == FALSE){
			IsCrosshairLoaded = FALSE;
		}
	}
    
    
    
    if (onesave == 0){
       WriteLBtext("Saving lumpinfo.dat");            
       SaveFile ("lumpinfo.dat",lumpinfo,3904*sizeof(gl_lumpinfo_t));
       WriteLBtext("Saving texauxinfo.dat");         
       SaveFile ("texauxinfo.dat",texauxinfo,3904*sizeof(texauxinfo_t));
       onesave = 1;
    }

    
    
    
    //PrecacheGroup ("shap");
    Uint32 end = SDL_GetTicks ();
    int time = end - begin;
    printf ("%d ms to do precache\n", time);
    //glDeleteTextures(1,&ttex);
    
    WriteLBtext("checkGLStatus"); 
    checkGLStatus ();
    
    WriteLBtext("UploadOverlay"); 
    UploadOverlay ();
    
 

 
    
}



static int last_fl=-1;
void GLSetupFog(int cfulllight, int usepos) {
    if (cfulllight==-1) {
	cfulllight=0;
    } else {
	if (cfulllight==last_fl)
	    return;
    }
    last_fl=cfulllight;

    static GLfloat nofogc[4] = { 0.0, 1.0, 0.0, 0.0 };
    static GLfloat bfogc[4] = { 1.0, 1.0, 1.0, 0.25 };
    static GLfloat dfogc[4] = { 0.0, 0.0, 0.0, 0.25 };
    static GLfloat gfogc[4] = { 0.0, 1.0, 0.0, 0.5 };
    GLfloat gasfog[4];
    GLfloat *ofog;
    if ((fog || !(fulllight || cfulllight)) && usepos && MISCVARS->GASON != 1) {
	glEnable (GL_FOG);
	glFogi (GL_FOG_MODE, GL_LINEAR);
	double fogfact=1.0;
	if (lightning && lightninglevel>0) {
	    fogfact=lightninglevel;
	}
	glFogf (GL_FOG_START, fognear*fogfact);
	glFogf (GL_FOG_END, fogfar*fogfact);
	glFogfv (GL_FOG_COLOR, fog?bfogc:dfogc);
    } else if (MISCVARS->GASON == 1) {
	if (!usepos)
	    return;
	double ostart, oend;
	if (fog || !fulllight) {
	    ofog = fog?bfogc:dfogc;
	    ostart = fognear;
	    oend = fogfar;
	} else {
	    ostart = NOFOGSTART;
	    oend = NOFOGEND;
	    ofog = nofogc;
	}
	double scl = (MISCVARS->gasindex / 15.0);
	int i;
	//printf("Gas fog for %d: ",MISCVARS->gasindex);
	for (i = 0; i < 4; i++) {
	    gasfog[i] = (gfogc[i] - ofog[i]) * scl + ofog[i];
	    //printf("%f ",gasfog[i]);
	}
	//printf("\n ");

	glEnable (GL_FOG);
	glFogi (GL_FOG_MODE, GL_LINEAR);
	glFogf (GL_FOG_START, ((GASFOGSTART - ostart) * scl) + ostart);
	glFogf (GL_FOG_END, ((GASFOGEND - oend) * scl) + oend);

	glFogfv (GL_FOG_COLOR, gasfog);
    } else
	glDisable (GL_FOG);
}

#define FRUSTOFFSET 0.7
static int dying=0;

int testt=0;

void GLSetupCamera (int usepos, double zoom)
{
    glMatrixMode (GL_PROJECTION);
    glLoadIdentity ();

    GLdouble xmin, xmax, ymin, ymax;
    xmax = -16.0 * zoom * (0.75/screenratio);
    xmin = -xmax;

    ymin = -16.0 * zoom * 0.75;
    ymax = -ymin;
    
    ymin += FRUSTOFFSET;
    ymax += FRUSTOFFSET;
    
    if (OLD_LOOKMODE && !dying) {
    	double ofs=(double)(centery-100)/ymax*1.5;
    	glFrustum (xmin, xmax, ymin+ofs, ymax+ofs, 16.0, 98304.0);
    	//printf("%d %0.6f %0.6f\n",centery,ymin,ymax);
    } else {
	  glFrustum (xmin, xmax, ymin, ymax, 16.0, 98304.0);
    }
    checkGLStatus ();

    glMatrixMode (GL_MODELVIEW);
    glLoadIdentity ();
    GLdouble vx, vy, vz;
    if (usepos) {
    	vwx = vx = viewx / 64.0;
    	vwy = vy = viewy / 64.0;
    	vwz = vz = ((((levelheight * 64) - pheight) * 16.0) * YCORRECTFACT);

	    //vz=1024;
    } else {
    	vx = 0;
    	vy = 0;
    	vz = 0;
    }
    double angrad;
    if (OLD_LOOKMODE && !dying) {
	angrad=0;
    } else { 
	angrad = lookangle / 1024.0 * M_PI;
    }
    double cosl = cos (angrad);
    double sinl = sin (angrad);
    double cosv = cos (-viewangle / 1024.0 * M_PI);
    double sinv = sin (-viewangle / 1024.0 * M_PI);

    double xo = cosl * cosv;
    double yo = cosl * sinv;

    double upx = 0, upy = 0, upz = 1;
    if (fabs (xo) < EPSILON && fabs (yo) < EPSILON) {
	upx = cosv;
	upy = sinv;
	upz = 0;
    }
    
    gluLookAt (vx, vy, vz, vx + xo, vy + yo, vz + sinl, upx, upy + ShakeVal, upz);
      
    checkGLStatus ();
    GLSetupFog(-1,usepos);

}
/*
static int ishsw13(maskedwallobj_t *tmwall) {
    //return 0;
#define iseither(x) (x==hsw13 || x==hsw14 || x==-1)
    int bot=tmwall->bottomtexture;
    int mid=tmwall->midtexture;
    int top=tmwall->toptexture;

    static int hsw13=0;
    static int hsw14=0;

    if (!hsw13) {
	hsw13=W_GetNumForName("hswtch13");
	hsw14=W_GetNumForName("hswtch14");
    }
    return (iseither(bot) && iseither(mid) && iseither(top));
#undef iseither
}
*/

int StatRotate (statobj_t * stat);
int CalcRotate (objtype * ob);

#define A_HAS_PRIO -1
#define B_HAS_PRIO 1
int compare_visobj (const void *a, const void *b)
{
    int prioa=visprio[((glvisobj *) a)->type];
    int priob=visprio[((glvisobj *) b)->type];
    if (prioa<priob) return B_HAS_PRIO;
    if (prioa>priob) return A_HAS_PRIO;
    
    double da = ((glvisobj *) a)->dist;
    double db = ((glvisobj *) b)->dist;
    if (da > db)
	return -1;
    if (da < db)
	return 1;
    return b - a;		// keep in the same order
}


void GLFixLightLevel ()
{
    double bright = sqrt(brightness / 7.0);
    double lrate =  lightrate / 15.0;
    double fograte = sqrt(lrate);
    double drate = lrate*lrate;
    //double drate = sqrt ( (lightrate / 15.0)) * 0.9 + 0.1;

    if (fog) {
    	fognear = NORMALFOGSTART * ((bright * 0.85) + 0.15);
    	fogfar = NORMALFOGEND * ((bright * 0.85) + 0.15);
    	ambientlight = 1.0;
    } else {
    	fognear = (NORMALFOGSTART * ((fograte * 0.85) + 0.15))*1.1;
    	fogfar = (NORMALFOGEND * ((fograte * 0.85) + 0.15))*1.1;
    	
    	ambientlight = ((bright * 0.85) + 0.15) * ((drate*0.25)+0.75);
        //stdlight=&stdlights[lightrate][0];
    }
}

void GLSetLightLevel (int fog, int darkness)
{
     
    printf ("GLSetLightLevel, darkness=%d lightrate=%d\n", darkness,lightrate);
    brightness = darkness;	// ??
    GLFixLightLevel ();
}
void GLSetLightRate (int rate)
{
    printf ("GLSetLightLevel, rate=%d\n", rate);
    lightrate = rate;
    GLFixLightLevel ();
}

void GLSetLight (double x, double y, double alpha)
{
    double fact = InterpolateLight (x, y);
    glColor4d (fact, fact, fact, alpha);
}
void GLSetLightColor (double x, double y, double red, double green,
		      double blue, double alpha)
{
    double fact = InterpolateLight (x, y);
    glColor4d (fact * red, fact * green, fact * blue, alpha);
}

#define NO_VERTEX_ARRAYS
void DrawModel(glvisobj* vis, int stencil) {
    /*	    DrawModel(cvis->mod.mod,cvis->x,cvis->y,cvis->z,cvis->dist,cvis->ang,cvis->flags&GLV_FULLLIGHT,
	    cvis->flags&GLV_SHROOMFLASH?cvis->mod.id:-1,1);*/

    //void DrawModel(model* mod, double x, double y, double z, double dist, double angle, int f_light, int flashidx, int stencil) {
    int i,j,k,zzz;
    double x=vis->x;
    double y=vis->y;
    double z=vis->z;
    int flashidx=vis->flags&GLV_SHROOMFLASH?vis->mod.id:-1;
    z *= YCORRECTFACT;
    shape* crshape;
    m_vertex* cvert;
    m_texcoord* ctc;
    m_color* ccol;
    //GLdouble* cvt, *ctc;
    // m_vertex verts[64];
    if (!stencil) {
	if (vis->flags&GLV_FULLLIGHT) {
	    if (flashidx==-1) {
		glColor3d(1,1,1);
	    } else {
		shroomrec* cshr=&shrooms[flashidx&31];
		glColor3d(cshr->r,cshr->g,cshr->b);
	    }
	} else {
	    if (flashidx==-1) {
		GLSetLight(x,y,1.0);
	    } else {
		shroomrec* cshr=&shrooms[flashidx&31];
		GLSetLightColor(x,y,cshr->r,cshr->g,cshr->b,1.0);
	    }
	}
    }

    int twoside=1;

    int ltp=-1;
    int ltx=-1;
    int qual=0;
    while (qual<NUMQUAL-1 && vis->dist<qualdist[qual]) qual++;
    
    shape_list* shl=&vis->mod.mod->shapes[qual];
    //printf("%d\n",qual);
    glMatrixMode(GL_MODELVIEW);
    glPushMatrix();
    double rotate=vis->ang;
    if (vis->mod.mod->flags&MOD_ROTATE) {
	rotate += GetTicCount()*3.0;
	//printf ("%f!\n",rotate);
    }
    glTranslated(x-vis->mod.mod->px,y-vis->mod.mod->py,z-vis->mod.mod->pz);
    if (rotate!=0) glRotated(rotate,0,0,1);
    if (vis->vang!=0) glRotated(vis->vang,0,1,0);
    glTranslated(vis->mod.mod->px,vis->mod.mod->py,vis->mod.mod->pz);
    

    if (MD2refresh ((unsigned int)vis->mod.id, vis->mod.mod->name,x,y,z)==1)
		return;
    
#ifndef NO_VERTEX_ARRAYS
    glEnableClientState(GL_VERTEX_ARRAY);
    glEnableClientState(GL_TEXTURE_COORD_ARRAY);
    glVertexPointer(3,GL_DOUBLE,sizeof(m_vertex),mod->shapes[qual].vertlist);
    glTexCoordPointer(2,GL_DOUBLE,sizeof(m_texcoord),mod->shapes[qual].texcoords);
#endif
    for(crshape=shl->shapes,i=0;i<shl->nshapes;i++,crshape++) {
	if ((crshape->flags&SHAPE_FLOORSTENCIL?1:0)!=stencil) continue;
	if (crshape->flags&(SHAPE_TWOSIDE|SHAPE_FLOORSTENCIL)) {
	    if (!twoside) glDisable(GL_CULL_FACE);
	    twoside=1;
	} else {
	    if (!twoside) glEnable(GL_CULL_FACE);
	    twoside=0;
	}
	if (!stencil && (unsigned)ltx!=crshape->tex) {
	    BindTex(crshape->tex);
	    ltx=crshape->tex;
	}

#ifndef NO_VERTEX_ARRAYS
	glDrawArrays(shape_types[crshape->type],crshape->vertindex,crshape->nverts);
#else
	cvert=&vis->mod.mod->shapes[qual].vertlist[crshape->vertindex];
	ctc=&vis->mod.mod->shapes[qual].texcoords[crshape->vertindex];
	glBegin(shape_types[crshape->type]);
	for (zzz=0;zzz<crshape->nverts;zzz++, cvert++, ctc++) {
	    glTexCoord2dv((GLdouble*)ctc);
	    glVertex3dv((GLdouble*)cvert);
	}
	glEnd();
#endif
    }
    glPopMatrix();
    glEnable(GL_CULL_FACE);


}

void DrawAWall (double x1, double y1, double x2, double y2, int *texes, double dimfact, int fulllight)
{
    int z, zz;
    double zp1,zp2;
    int lwall;
    int runlen=0;
    double facta, factb;
    zz = 0;
    if (fulllight) {
	facta=factb=1.0;
    } else {
	facta = InterpolateLight (x1, y1);
	factb = InterpolateLight (x2, y2);
	facta *= dimfact;
	factb *= dimfact;
    }
    if (x1==x2) {
	facta *= 0.75;
	factb *= 0.75;
    }
    zp1=0;
    z=0;
    while (1) {
	while ((z<levelheight)&&(texes[z]==0)) { z++; zp1 += (1024*YCORRECTFACT); }
	if (z>=levelheight) break;
	runlen=0;
	lwall=texes[z];
	zz=z;
	zp2=zp1;
	do { z++; runlen++; zp2 += (1024*YCORRECTFACT); } while ((z<levelheight)&&(texes[z]==lwall));
	BindTex( lwall);
	//printf("drawing, zp1=%f zp2=%f runlen=%d\n",zp1,zp2,runlen);
	glBegin (GL_QUADS);

	glColor3d(facta,facta,facta);
	glTexCoord2d(0.0,runlen);
	glVertex3d(x1,y1,zp1);

	glTexCoord2d(0.0,0.0);
	glVertex3d(x1,y1,zp2);

	glColor3d(factb,factb,factb);

	glTexCoord2d(1.0,0.0);
	glVertex3d(x2,y2,zp2);

	glTexCoord2d(1.0,runlen);
	glVertex3d(x2,y2,zp1);

	glEnd();
	zp1=zp2;
    }


}

double InterpolateLight (double x, double y)
{
    if (fulllight || ambientlight == 1.0)
	return 1.0;
    double rx = x * (1.0 / 512.0);
    double ry = y * (1.0 / 512.0);
    int lx = (int)rx;
    int ly = (int)ry;
    double lfx = rx - lx;
    double lfy = ry - ly;
    if (lfx == 0 && lfy == 0) {
	//printf("%f %f %f %f %f\n",rx,ry,lfx,lfy,lightamt[lx][ly]);
	return lightamt[lx][ly];
    }
    double ltxy = lightamt[lx][ly];
    double ltxY = lightamt[lx][ly + 1];
    double ltXy = lightamt[lx + 1][ly];
    double ltXY = lightamt[lx + 1][ly + 1];
    double lt1 = ((ltXy - ltxy) * lfx + ltxy);
    double lt2 = ((ltXY - ltxY) * lfx + ltxY);
    double ret = ((lt2 - lt1) * lfy + lt1);
    //printf("%f %f %f %f %f\n",rx,ry,lfx,lfy,ret);
    return ret;

}

void GLCalcLights ()
{
    if (fulllight || ambientlight == 1.0)
	return;
    double tempamb=ambientlight;
    if (lightninglevel>0) {
	tempamb=ambientlight+(lightninglevel/15)*(1-ambientlight);
    }
    statobj_t *statptr;
    objtype *obj;
    int x, y, xx, yy;
    for (xx = 0; xx < 256; xx++) {
	for (yy = 0; yy < 256; yy++) {
	    lightamt[xx][yy] = tempamb;
	}
    }
    int id;
    for (statptr = firstactivestat; statptr; statptr = statptr->nextactive) {
	if ((statptr->shapenum) == NOTHING)
	    continue;
	if (statptr->flags & FL_LIGHT && statptr->flags & FL_LIGHTON) {
	    //printf("light at %d,%d\n",statptr->x,statptr->y);
	    int lsx = (statptr->x >> 15) - LIGHTOFS;
	    int lsy = (statptr->y >> 15) - LIGHTOFS;

	    for (x = lsx, xx = 0; xx < LIGHTRAD && x < 256; x++, xx++) {
		if (x < 0)
		    continue;
		for (y = lsy, yy = 0; yy < LIGHTRAD && y < 256; y++, yy++) {
		    if (y < 0)
			continue;
		    double c = lightamt[x][y];

		    c += (stdlight[xx + (yy << 5)] * (1.0 - tempamb));
		    if (c > 1.0)
			c = 1.0;
		    lightamt[x][y] = c;
		}
	    }
	}
    }
}
void DrawParallel(int tex, double xx, double yy, double zpos, double ww, double hh, double tc0, double tc1)
{
    BindTex( tex);
    glBegin (GL_QUADS);
    glTexCoord2f (tc0, tc0);
    GLSetLight (xx, yy, 1.0);
    glVertex3f (xx, yy, zpos);

    glTexCoord2f (tc1, tc0);
    GLSetLight (xx + ww, yy, 1.0);
    glVertex3f (xx + ww, yy, zpos);

    glTexCoord2f (tc1, tc1);
    GLSetLight (xx + ww, yy + hh, 1.0);
    glVertex3f (xx + ww, yy + hh, zpos);

    glTexCoord2f (tc0, tc1);
    GLSetLight (xx, yy + hh, 1.0);
    glVertex3f (xx, yy + hh, zpos);
    glEnd ();
}

void GLCalcVisibleThings()
{
    statobj_t *statptr;
    objtype *obj;
    maskedwallobj_t *tmwall;
    doorobj_t *tdoor;
    double viewsin = sin (-viewangle / 1024.0 * M_PI);
    double viewcos = cos (-viewangle / 1024.0 * M_PI);
    glvisobj *cvis = visobjects;
    byte *visspot;
    unsigned short int *tilespot;
    nvisobjects = 0;
    int gx, gy, i, j;

    /* !CMASK */

    BEGIN(total);

    BEGIN(mwall);
    for (tmwall = FIRSTMASKEDWALL; tmwall; tmwall = tmwall->next) {
	if (spotvis[tmwall->tilex][tmwall->tiley]) {
	    mapseen[tmwall->tilex][tmwall->tiley] = 1;
	    cvis->type=GLV_MASKED;
	    if (!NO_FATBLOCK && tmwall->flags&MW_FATBLOCKING) {
		cvis->flags=0;
		cvis->type=GLV_BLOCKMASK;
		gx = (tmwall->tilex << 16);
		gy = (tmwall->tiley << 16);
		cvis->x = gx / 64.0;
		cvis->y = gy / 64.0;
		cvis->z = 0;
		cvis->dist=0;
		cvis->maskwall.btex = tmwall->bottomtexture;
		cvis->tex = tmwall->midtexture;
		cvis->maskwall.ttex = tmwall->toptexture;
	    } else if (tmwall->vertical) {
		gx = (tmwall->tilex << 16) + 0x8000;
		gy = (tmwall->tiley << 16);
		cvis->x = gx / 64.0;
		cvis->y = gy / 64.0;
		cvis->z = 0;
		cvis->flags = GLV_VERTICAL;
		cvis->maskwall.btex = tmwall->bottomtexture;
		cvis->tex = tmwall->midtexture;
		cvis->maskwall.ttex = tmwall->toptexture;
	    } else {
		gx = (tmwall->tilex << 16);
		gy = (tmwall->tiley << 16) + 0x8000;
		cvis->x = gx / 64.0;
		cvis->y = gy / 64.0;
		cvis->z = 0;
		cvis->flags = 0;
		cvis->maskwall.btex = tmwall->bottomtexture;
		cvis->tex = tmwall->midtexture;
		cvis->maskwall.ttex = tmwall->toptexture;

	    }
	    if (tmwall->flags & FL_TRANSLUCENT) {
		//cvis->flags |= GLV_TRANS;
	    }
	    int tx=tmwall->tilex;
	    int ty=tmwall->tiley;
	    int iscatwalk=!NO_CATWALK && IS_TOP_CATWALK(tx,ty);
	    if (iscatwalk) {
		cvis->maskwall.ttex=-1;
	    } else if ((tmwall->flags & MW_TOPFLIPPING) && (nonbobpheight > 64)) {
		cvis->maskwall.ttex++;
	    } else if ((tmwall->flags & MW_BOTTOMFLIPPING)
		       && (nonbobpheight > maxheight - 32)) {
		cvis->maskwall.btex++;
	    }


	    cvis->dist =
		viewcos * (((tmwall->tilex << 16) + 0x4000) - viewx) +
		viewsin * (((tmwall->tiley << 16) + 0x4000) - viewy);

	    nvisobjects++;
	    cvis++;
	    if (iscatwalk) { // we have to add another object for the catwalk
		gx = (tmwall->tilex << 16);
		gy = (tmwall->tiley << 16);
		cvis->x = gx / 64.0;
		cvis->y = gy / 64.0;
		cvis->z = ((levelheight-1)*1024+64)*YCORRECTFACT;
		cvis->z += 50;//bna added - raise the catwalk a bit 
		cvis->type = GLV_CATWALK;
		cvis->dist=0;
		cvis->tex = (
			     IS_TOP_CATWALK(tx-1, ty-1)  <<0 |
			     IS_TOP_CATWALK(tx,   ty-1)  <<1 |
			     IS_TOP_CATWALK(tx+1, ty-1)  <<2 |
			     IS_TOP_CATWALK(tx-1, ty  )  <<3|
			     IS_TOP_CATWALK(tx+1, ty  )  <<4|
			     IS_TOP_CATWALK(tx-1, ty+1)  <<5|
			     IS_TOP_CATWALK(tx,   ty+1)  <<6|
			     IS_TOP_CATWALK(tx+1, ty+1)  <<7);

		nvisobjects++;
		cvis++;
	    }
	}
    }
    NREPORT(mwall,"Masked walls");
    BEGIN(door);
    /* !CDOOR */
    doorobj_t** cdoor=doorobjlist;
    for (i = 0; i < doornum; i++,cdoor++) {
	if (!(tdoor=*cdoor))
	    continue;
	if (spotvis[tdoor->tilex][tdoor->tiley]) {
	    cvis->type=GLV_MASKED;
	    if (tdoor->vertical) {
		gx = (tdoor->tilex << 16) + 0x8000;
		gy = (tdoor->tiley << 16);
		cvis->x = gx / 64.0;
		cvis->y = gy / 64.0;
		cvis->z = 0;
		cvis->type=GLV_MASKED;
		cvis->flags = GLV_VERTICAL;
		cvis->maskwall.btex = tdoor->texture;
		cvis->tex = tdoor->alttexture;
		cvis->maskwall.ttex = tdoor->alttexture;
	    } else {
		gx = (tdoor->tilex << 16);
		gy = (tdoor->tiley << 16) + 0x8000;
		cvis->x = gx / 64.0;
		cvis->y = gy / 64.0;
		cvis->z = 0;
		cvis->type = GLV_MASKED;
		cvis->flags = 0;
		cvis->maskwall.btex = tdoor->texture;
		cvis->tex = tdoor->alttexture;
		cvis->maskwall.ttex = tdoor->alttexture;

	    }

	    cvis->dist =
		viewcos * (((tdoor->tilex << 16) + 0x4000) - viewx) +
		viewsin * (((tdoor->tiley << 16) + 0x4000) - viewy);

	    nvisobjects++;
	    cvis++;
	}
    }
    NREPORT(door,"Doors");
    BEGIN(stats);
    for (statptr = firstactivestat; statptr; statptr = statptr->nextactive) {
	if ((cvis->tex = statptr->shapenum) == NOTHING)
	    continue;
	cvis->type=GLV_SPRITE;

	cvis->sprite.id=statptr-((statobj_t*)0);

	cvis->sprite.cmap = 0;
	cvis->tex += shapestart;
	cvis->x = statptr->x / 64.0;
	cvis->y = statptr->y / 64.0;
	cvis->z = (((levelheight * 64) - statptr->z) * 16.0);
	cvis->flags = 0;
	/*if ((cvis->tex <= shapestart) ||
	   (cvis->tex >= shapestop))
	   Error("actor shapenum %d out of range (%d-%d)",cvis->tex,shapestart,shapestop); */

	visspot = statptr->visspot;
	if (!((*(visspot - 0)) ||
	      (*(visspot - 1)) ||
	      (*(visspot + 1)) ||
	      (*(visspot - 129)) ||
	      (*(visspot - 128)) ||
	      (*(visspot - 127)) ||
	      (*(visspot + 129)) ||
	      (*(visspot + 128)) || (*(visspot + 127)))) {
	    statptr->flags &= ~FL_VISIBLE;
	    continue;		// not visible
	}
	cvis->dist =
	    viewcos * (statptr->x - viewx) + viewsin * (statptr->y - viewy);
	statptr->flags |= FL_SEEN;

	statptr->flags |= FL_VISIBLE;

	if (statptr->flags & FL_FULLLIGHT)
	    cvis->flags |= GLV_FULLLIGHT;

	if (statptr->flags & FL_ROTATING)
	    cvis->tex += StatRotate (statptr);

	if (statptr->flags & FL_TRANSLUCENT) {
	    if (statptr->flags & FL_FADING)
	      cvis->flags |= GLV_TRANSFADE;
	}
	if (statptr->flags & FL_COLORED) {
	    cvis->sprite.cmap = statptr->hitpoints + 1;
	}
	if (statptr->itemnumber != (unsigned int)-1) {
	    if (lumpinfo[statptr->shapenum+shapestart].type==LT_MODEL) {
		cvis->type=GLV_MODEL;
		cvis->mod.mod=lumpinfo[statptr->shapenum+shapestart].mod;
		
		//check if its a md2 model
		if (strchr(cvis->mod.mod->name,'|') != 0)
			cvis->mod.id = statptr;
		else
			cvis->mod.id = statptr -((statobj_t*)0);		
		
		
//		cvis->mod.id=statptr-((statobj_t*)0);//bna--
		cvis->ang=0;
		cvis->vang=0;
		//printf("Statmodel %s %f %f %f\n",cvis->mod.mod->name,cvis->x,cvis->y,cvis->z);
	    } else if (statptr->flags & FL_HEIGHTFLIPPABLE) {
		if (statptr->itemnumber == stat_disk) {
		    int value;
		    value = nonbobpheight - statptr->z - 32;
		    if ((value <= 72) && (value > 24)) {
			cvis->tex++;
		    } else if ((value <= 24) && (value >= -24)) {
			cvis->tex += 2;
		    } else if ((value < -24) && (value >= -72)) {
			cvis->tex += 3;
		    } else if (value < -72) {
			cvis->tex += 4;
		    }
		} else if ((nonbobpheight - statptr->z) < -16) {
		    cvis->tex++;
		}
	    }
	}
	nvisobjects++;
	cvis++;

    }
    NREPORT(stats,"Stats");
    BEGIN(objs);
    int nobjproc=0;
    int nobjvis=0;
    /* !COBJ */

    for (obj = firstactive; obj; obj = obj->nextactive) {
	nobjproc++;
	if (obj == player)
	    continue;
	cvis->type=GLV_SPRITE;

	if ((cvis->tex = obj->shapenum) == NOTHING)
	    continue;		// no shape

	cvis->sprite.id=obj-((objtype*)0);
	cvis->tex += shapestart;
	/*if ((cvis->tex <= shapestart) ||
	   (cvis->tex >= shapestop))
	   Error("actor shapenum %d out of range (%d-%d)",cvis->tex,shapestart,shapestop); */
	visspot = &spotvis[obj->tilex][obj->tiley];
	tilespot = &tilemap[obj->tilex][obj->tiley];

	//
	// could be in any of the nine surrounding tiles
	//
	if (*visspot || (*(visspot - 1))
	    || (*(visspot + 1))
	    || (*(visspot - 129))
	    || (*(visspot - 128))
	    || (*(visspot - 127))
	    || (*(visspot + 129))
	    || (*(visspot + 128))
	    || (*(visspot + 127))) {

	    //        result = TransformObject (obj->drawx, obj->drawy,&(visptr->viewx),&(visptr->viewheight));
	    nobjvis++;
	    cvis->sprite.cmap = 0;
	    cvis->x = obj->x / 64.0;
	    cvis->y = obj->y / 64.0;
	    cvis->z = (((levelheight * 64) - obj->z) * 16.0);
	    cvis->flags = 0;
	    cvis->dist =
		viewcos * (obj->x - viewx) + viewsin * (obj->y - viewy);
	    if (obj->state->rotate)
		cvis->tex += CalcRotate (obj);

	    //visptr->shapesize=0;

	    if (player->flags & FL_SHROOMS) {
		cvis->flags |= GLV_SHROOMFLASH;
	    }
	    if (obj->flags & FL_FULLLIGHT)
		cvis->flags |= GLV_FULLLIGHT;
	    if (obj->obclass == playerobj) {
		if (obj->flags & FL_GODMODE) {
		    cvis->flags |= GLV_SHROOMFLASH;
		} else if (obj->flags & FL_COLORED) {
		    playertype *pstate;

		    M_LINKSTATE (obj, pstate);
		    cvis->sprite.cmap = pstate->uniformcolor + 1;
		}		//else
		//SetSpriteLightLevel(obj->x,obj->y,visptr,obj->dir,(obj->flags&FL_FULLLIGHT));

	    } else {
		if ((obj->obclass >= b_darianobj)
		    && (obj->obclass <= b_robobossobj)
		    && MISCVARS->redindex) {
		    cvis->flags |= GLV_REDFLASH;
		    // no-op: visptr->colormap=redmap+((MISCVARS->redindex-1)<<8);

		} else {
		    // no-op: SetSpriteLightLevel(obj->x,obj->y,visptr,obj->dir,(obj->flags&FL_FULLLIGHT));
		}
	    }
#define HF_1 24
#define HF_2 72
	    if (lumpinfo[obj->shapenum+shapestart].type==LT_MODEL) {
		cvis->type=GLV_MODEL;		
		cvis->mod.mod=lumpinfo[obj->shapenum+shapestart].mod;
		
        //check if its a md2 model bna md2fix
        if (strchr(cvis->mod.mod->name,'|') != 0)
           cvis->mod.id = obj;
        else
            cvis->mod.id = obj -((objtype*)0);		
		

		//cvis->mod.id=obj-((objtype*)0);
		if (obj->state->rotate) {
		    if (cvis->mod.mod->flags&MOD_VERTROTATE) {
			double totmom=sqrt(obj->momentumx*obj->momentumx+obj->momentumy*obj->momentumy+obj->momentumz*obj->momentumz);
			if (totmom!=0) {
			    double cs=obj->momentumz/totmom;
			    cvis->vang=-((acos(cs)*180/M_PI)-90);
			}
			cvis->ang=obj->angle*-(360.0/FINEANGLES);
		    }
		    //printf("%d\n",obj->yzangle);

		} else {
		    cvis->ang=0;
		    cvis->vang=0;
		}
	    } else if (obj->obclass == diskobj) { 
		int value;
		value = nonbobpheight - obj->z - 32;
		if ((value <= HF_2) && (value > HF_1)) {
		    cvis->tex++;
		} else if ((value <= HF_1) && (value >= -HF_1)) {
		    cvis->tex += 2;
		} else if ((value < -HF_1) && (value >= -HF_2)) {
		    cvis->tex += 3;
		} else if (value < -HF_2) {
		    cvis->tex += 4;
		}
	    } else if ((obj->obclass == pillarobj)
		       && ((nonbobpheight - obj->z) < -16)) {
		cvis->tex++;
	    }

	    obj->flags |= FL_SEEN;
	    obj->flags |= FL_VISIBLE;
	    cvis++;
	    nvisobjects++;
	} else {
	    obj->flags &= ~FL_VISIBLE;
	}
    }
    NREPORT(objs,"Objects proc=%d vis=%d ",nobjproc,nobjvis);
    BEGIN(zsort);
    qsort (visobjects, nvisobjects, sizeof (glvisobj), compare_visobj);
    NREPORT(zsort,"Sort");
    //BEGIN(door);
    REPORT(total,"Calcvis Total");
}
void GLDrawStencilThings ()
{
    int i;
    glvisobj *cvis = visobjects;
    SetDrawMode(GLV_MODEL);
    glStencilFunc(GL_NEVER,1,1);
    glStencilOp(GL_REPLACE,GL_REPLACE,GL_REPLACE);
    glDepthMask(0);
    glStencilMask(1);
    glEnable(GL_STENCIL_TEST);
    glDisable(GL_TEXTURE_2D);
    for (i = 0; i < nvisobjects; i++, cvis++) {
	if (cvis->type==GLV_MODEL) {
	    DrawModel(cvis,1);
	}
    }
    glStencilOp(GL_KEEP,GL_KEEP,GL_KEEP);
    glDepthMask(1);
}

void GLDrawFlatThings ()
{
    //printf("%d\n",nvisobjects);
    glvisobj *cvis = visobjects;
    int i,j,k,z;

    double viewsin = sin (-viewangle / 1024.0 * M_PI);
    double viewcos = cos (-viewangle / 1024.0 * M_PI);

    GLdouble x1, y1, x2, y2, z1, z2;
    double xoff, yoff;
    gl_lumpinfo_t* tex;
    int texn, lmp;
    double tcxl, tcxh;
    double tcyl, tcyh;
    int texes[16];


    /*
     *
     * DMASK
     *
     */



    for (i = 0; i < nvisobjects; i++, cvis++) {
	SetDrawMode(cvis->type);
	GLSetupFog(cvis->flags&GLV_FULLLIGHT?1:0,1);
	switch (cvis->type) {
	case GLV_CATWALK:
	    //glAlphaFunc(GL_GEQUAL,0.9);

	    for (j=0;j<4;j++) {
		int xp=cvis->x+((j&1)<<9);
		int yp=cvis->y+((j&2)<<8);
		int picofs=((cvis->tex>>catbits[j][0])&1)|((cvis->tex>>catbits[j][1])&1)<<1;
		int cpic=(j<<2)+picofs;
		if (picofs==3 && ((cvis->tex>>catbits[j][2])&1)) cpic=16;
		DrawParallel(catwalk[cpic],xp,yp,cvis->z,512,512,0,1);
	    }

	    //glAlphaFunc(GL_GEQUAL,0.5);

	    break;
	case GLV_BLOCKMASK:
	    //printf("%d\n",cvis->flags&GLV_FULLLIGHT?1:0);
	    memset(texes,0,sizeof(texes));
	    if (cvis->maskwall.btex != -1) {
		lmp = cvis->maskwall.btex;
		tex = GetTexForLump (lmp, REPEAT_AUTO);
		texes[0] = tex->tex.texnum[0];
	    }
	    if (cvis->tex != -1) {
		lmp = cvis->tex;
		tex = GetTexForLump (lmp, REPEAT_AUTO);
		for (j=1;j<levelheight-1;j++) {
		    texes[j] = tex->tex.texnum[0];
		}
	    }
	    if (cvis->maskwall.ttex != -1) {
		lmp = cvis->maskwall.ttex;
		tex = GetTexForLump (lmp, REPEAT_AUTO);
		texes[levelheight-1] = tex->tex.texnum[0];
	    }

	    x1 = cvis->x ;
	    y1 = cvis->y ;

	    glFrontFace(GL_CW);
	    DrawAWall (x1, y1, x1, y1 + 1024, texes, 1.0, 0);
	    DrawAWall (x1, y1 + 1024, x1 + 1024, y1 + 1024, texes, 1.0, 0);
	    DrawAWall (x1 + 1024, y1 + 1024, x1 + 1024, y1, texes, 1.0, 0);
	    DrawAWall (x1 + 1024, y1, x1, y1, texes, 1.0, 0);

	    if (cvis->maskwall.ttex==-1 && cvis->tex!=-1) {
		lmp = cvis->tex;
		texn = GetTexForLump (lmp, REPEAT_AUTO)->tex.texnum[0];
		DrawParallel(texn,cvis->x,cvis->y,(levelheight-1)*1024*YCORRECTFACT,1024,1024,0,1);
	    }
	    if (cvis->maskwall.btex!=-1 && cvis->tex==-1) {
		lmp = cvis->maskwall.btex;
		texn = GetTexForLump (lmp, REPEAT_AUTO)->tex.texnum[0];
		DrawParallel(texn,cvis->x,cvis->y,1024*YCORRECTFACT,1024,1024,0,1);
	    }
	    glFrontFace(GL_CCW);

	    if (cvis->maskwall.btex==-1 && cvis->tex!=-1) {
		lmp = cvis->tex;
		texn = GetTexForLump (lmp, REPEAT_AUTO)->tex.texnum[0];
		DrawParallel(texn,cvis->x,cvis->y,1024*YCORRECTFACT,1024,1024,0,1);
	    }
	    if (cvis->maskwall.ttex!=-1 && cvis->tex==-1) {
		lmp = cvis->maskwall.ttex;
		texn = GetTexForLump (lmp, REPEAT_AUTO)->tex.texnum[0];
		DrawParallel(texn,cvis->x,cvis->y,(levelheight-1)*1024*YCORRECTFACT,1024,1024,0,1);
	    }


	    //glDisable(GL_CULL_FACE);
	    //glDepthMask(0);
	    break;
	case GLV_MASKED:

	    if (cvis->maskwall.btex != -1) {
		lmp = cvis->maskwall.btex;
		tex = GetTexForLump (lmp, REPEAT_AUTO);
		x1 = cvis->x;
		y1 = cvis->y;
		z1 = 1024 - ((tex->tex.tofs) << 4);
		z2 = z1 - (tex->tex.h << 4);
		if (cvis->flags & GLV_VERTICAL) {
		    x2 = x1;
		    y1 += (tex->tex.lofs) << 4;
		    y2 = y1 + (tex->tex.w << 4);
		} else {
		    y2 = y1;
		    x1 += (tex->tex.lofs) << 4;
		    x2 = x1 + (tex->tex.w << 4);
		}
		BindTex( tex->tex.texnum[0]);
		checkGLStatus ();

		glBegin (GL_QUADS);
		//glColor3f(1.0,1.0,1.0);
		GLSetLight (x1, y1, 1.0);
		glTexCoord2f (tex->tex.tcxl, tex->tex.tcyh);
		glVertex3f (x1, y1, z2 * YCORRECTFACT);
		glTexCoord2f (tex->tex.tcxl, tex->tex.tcyl);
		glVertex3f (x1, y1, z1 * YCORRECTFACT);
		glTexCoord2f (tex->tex.tcxh, tex->tex.tcyl);
		GLSetLight (x2, y2, 1.0);
		glVertex3f (x2, y2, z1 * YCORRECTFACT);
		glTexCoord2f (tex->tex.tcxh, tex->tex.tcyh);
		glVertex3f (x2, y2, z2 * YCORRECTFACT);
		glEnd ();
		checkGLStatus ();
	    }
	    if (cvis->tex != -1 && levelheight > 1) {
		lmp = cvis->tex;
		tex = GetTexForLump (lmp, REPEAT_AUTO);
		x1 = cvis->x;
		y1 = cvis->y;
		z1 = 1024 + (tex->tex.tofs << 4);
		z2 = z1 - (tex->tex.h << 4);
		if (cvis->flags & GLV_VERTICAL) {
		    x2 = x1;
		    y1 += (tex->tex.lofs) << 4;
		    y2 = y1 + (tex->tex.w << 4);
		} else {
		    y2 = y1;
		    x1 += (tex->tex.lofs) << 4;
		    x2 = x1 + (tex->tex.w << 4);
		}
		BindTex( tex->tex.texnum[0]);
		glBegin (GL_QUADS);
		int zz = 1024;
		for (z = 1; z < levelheight - 1; z++, zz += 1024) {
		    GLSetLight (x1, y1, 1.0);
		    glTexCoord2f (tex->tex.tcxl, tex->tex.tcyh);
		    glVertex3f (x1, y1, (zz + z2) * YCORRECTFACT);
		    glTexCoord2f (tex->tex.tcxl, tex->tex.tcyl);
		    glVertex3f (x1, y1, (zz + z1) * YCORRECTFACT);
		    GLSetLight (x2, y2, 1.0);
		    glTexCoord2f (tex->tex.tcxh, tex->tex.tcyl);
		    glVertex3f (x2, y2, (zz + z1) * YCORRECTFACT);
		    glTexCoord2f (tex->tex.tcxh, tex->tex.tcyh);
		    glVertex3f (x2, y2, (zz + z2) * YCORRECTFACT);
		}
		glEnd ();
		checkGLStatus ();
	    }
	    if (cvis->maskwall.ttex != -1 && levelheight > 1) {
		lmp = cvis->maskwall.ttex;
		tex = GetTexForLump (cvis->maskwall.ttex, REPEAT_AUTO);
		x1 = cvis->x;
		y1 = cvis->y;
		z1 = 1024 + (tex->tex.tofs << 4);
		z2 = z1 - (tex->tex.h << 4);
		if (cvis->flags & GLV_VERTICAL) {
		    x2 = x1;
		    y1 += (tex->tex.lofs) << 4;
		    y2 = y1 + (tex->tex.w << 4);
		} else {
		    y2 = y1;
		    x1 += (tex->tex.lofs) << 4;
		    x2 = x1 + (tex->tex.w << 4);
		}
		BindTex( tex->tex.texnum[0]);
		glBegin (GL_QUADS);
		int zz = (levelheight - 1) * 1024;
		GLSetLight (x1, y1, 1.0);
		glTexCoord2f (tex->tex.tcxl, tex->tex.tcyh);
		glVertex3f (x1, y1, (zz + z2) * YCORRECTFACT);
		glTexCoord2f (tex->tex.tcxl, tex->tex.tcyl);
		glVertex3f (x1, y1, (zz + z1) * YCORRECTFACT);
		GLSetLight (x2, y2, 1.0);
		glTexCoord2f (tex->tex.tcxh, tex->tex.tcyl);
		glVertex3f (x2, y2, (zz + z1) * YCORRECTFACT);
		glTexCoord2f (tex->tex.tcxh, tex->tex.tcyh);
		glVertex3f (x2, y2, (zz + z2) * YCORRECTFACT);
		glEnd ();
		checkGLStatus ();
	    }
	    break;
	case GLV_MODEL:
	    DrawModel(cvis,0);
	    break;
	case GLV_SPRITE:
	    {
		/*
		 *
		 * SPRITES
		 *
		 */
		tex = GetTexForLump (cvis->tex, 0);
		/*
		  if (cvis->flags&GLV_TRANS) {
		  } else {
		  tex=GetTexForPatch(cvis->tex,0);
		  } */


		int lb =
		    (tex->tex.osize >> 1) - tex->tex.lofs -
		    tex->tex.w;
		int tb = tex->tex.tofs;
		int rb = lb + tex->tex.w;
		int bb = tb + tex->tex.h;
		double tcx = tex->tex.tcxh;
		double tcy = tex->tex.tcyh;
		/*double tcyl=onediv[tex->osize]*-tex->tex.tofs;
		  double tcyh=onediv[tex->osize]*(-tex->tex.tofs+tex->tex.h); */
		double scl = onediv[tex->tex.osize] * 1024.0;

		/*int lb=-tex->osize>>1;//(tex->osize>>1)+tex->tex.lofs-tex->tex.w;
		  int tb=0;
		  int rb=lb+(tex->osize);
		  int bb=tb+(tex->osize);
		  double scl=onediv[tex->osize]*1024.0; */
		x1 = (cvis->x) + (lb * scl) * viewsin;
		y1 = (cvis->y) + (lb * scl) * -viewcos;
		x2 = (cvis->x) + (rb * scl) * viewsin;
		y2 = (cvis->y) + (rb * scl) * -viewcos;
		z1 = (cvis->z) + (-tb * scl);
		z2 = (cvis->z) + (-bb * scl);
		double redamt=(MISCVARS->redindex - 1)/15.0;

		double alpha=(cvis->flags&GLV_TRANSFADE?(transparentlevel/64.0):1.0);
		shroomrec* cshr=&shrooms[cvis->sprite.id&31];
		if (cvis->sprite.cmap > 0 && 
		    !texauxinfo[cvis->tex].colorsused[cvis->sprite.cmap-1]) {
		    printf("%s %d\n",W_GetNameForNum(cvis->tex),cvis->sprite.cmap-1);
		}
		BindTex( tex->tex.texnum[cvis->sprite.cmap]);
		if (cvis->flags & GLV_FULLLIGHT) {
		    glBegin (GL_QUADS);
		    if (cvis->flags & GLV_SHROOMFLASH) {
			glColor4d (cshr->r, cshr->g, cshr->b, alpha);
		    } else if (cvis->flags & GLV_REDFLASH) {
			glColor4d (1.0, 1.0-redamt, 1.0-redamt,alpha);
		    } else
			glColor4f (1.0, 1.0, 1.0, alpha);
		    glTexCoord2f (tcx, 0);
		    glVertex3f (x1, y1, z1 * YCORRECTFACT);

		    glTexCoord2f (tcx, tcy);
		    glVertex3f (x1, y1, z2 * YCORRECTFACT);

		    glTexCoord2f (0, tcy);
		    glVertex3f (x2, y2, z2 * YCORRECTFACT);

		    glTexCoord2f (0, 0);
		    glVertex3f (x2, y2, z1 * YCORRECTFACT);
		    glEnd ();
		} else {
		    if (cvis->flags & GLV_SHROOMFLASH) {
			GLSetLightColor (x1, y1, cshr->r, cshr->g,
					 cshr->b, alpha);
		    } else if (cvis->flags & GLV_REDFLASH) {
			GLSetLightColor (x1, y1, 1.0, 1.0-redamt, 1.0-redamt, alpha);
		    } else
			GLSetLight (x1, y1, alpha);
		    glBegin (GL_QUADS);
		    glTexCoord2f (tcx, 0);
		    glVertex3i (x1, y1, z1 * YCORRECTFACT);
		    glTexCoord2f (tcx, tcy);
		    glVertex3i (x1, y1, z2 * YCORRECTFACT);
		    if (cvis->flags & GLV_SHROOMFLASH) {
			GLSetLightColor (x2, y2, cshr->r, cshr->g,
					 cshr->b, alpha);
		    } else if (cvis->flags & GLV_REDFLASH) {
			GLSetLightColor (x2, y2, 1.0, 1.0-redamt, 1.0-redamt, alpha);
		    } else
			GLSetLight (x2, y2, alpha);
		    glTexCoord2f (0, tcy);
		    glVertex3i (x2, y2, z2 * YCORRECTFACT);

		    glTexCoord2f (0, 0);
		    glVertex3i (x2, y2, z1 * YCORRECTFACT);
		    glEnd ();
		}
		checkGLStatus ();
		//glPopMatrix();
	    }
	}
    }
}



int GetAnimTex (int tile)
{
    if (tile & 0x1000) {
	tile = animwalls[tile & 0x3ff].texture;
    } else {
	tile &= 0x3FF;
    }
    return tile;
}

void DrawNormWall (wallent_t * wal)
{
    double x1, x2, y1, y2;

    x1 = wal->x << 10;
    y1 = wal->y << 10;
    int facx = wal->x;
    int facy = wal->y;
    double dimfact=1.0;

    switch (wal->wall) {
    case 0:			/* West */
	x2 = x1;
	y2 = y1 + 1024;
	facx--;
	break;
    case 1:			/* East */
	x1 += 1024;
	x2 = x1;
	y2 = y1;
	y1 += 1024;
	facx++;
	break;
    case 2:			/* North */
	y2 = y1;
	x2 = x1;
	x1 += 1024;
	facy--;
	break;
    case 3:			/* South */
	y1 += 1024;
	y2 = y1;
	x2 = x1 + 1024;
	facy++;
	break;
    default:
	/* Can't happen. I hope. */
	x2 = x1;
	y2 = y1;
	break;
    }
    int texes[16];
    int dofl=0;
    int tile = tilemap[wal->x][wal->y];
    int alttile = -1;
    int tmp1, tmp2 = 0;
    if (tile&0x800) {
	dimfact=((gamestate.difficulty/3.0)*0.2)+0.8;
    }
    if (tile & 0x4000) {
	tmp1 = tilemap[facx][facy];
	if (tmp1 & 0x8000) {
	    if (tmp1 & 0x4000) {
		if ((tmp2 = maskobjlist[tmp1 & 0x3ff]->sidepic)) {
		    tile = tmp2;
		} else {
		    tile &= 0x3FF;
		}
	    } else {
		tile = doorobjlist[tmp1 & 0x3ff]->sidepic;
	    }
	} else {
	    if (tile & 0x1000) {
		tile = animwalls[tile & 0x3ff].texture;
	    } else {
		tile &= 0x3FF;
	    }
	}
    } else if (tile & 0x2000) {
	alttile = (MAPSPOT (wal->x, wal->y, 2)) + 1;
	tile &= 0x3ff;
    } else {
	if (tile & 0x1000) {
	    tile = animwalls[tile & 0x3ff].texture;
	} else {
	    tile &= 0x3FF;
	}
    }

    int lump = tile & 0x3FF;

    if ((lump >= 127 && lump <= 132) ||
	(lump >= 77 && lump <= 80))
	dofl = 1;


    if (MAPSPOT (wal->x, wal->y, 2) == 13) {
	glEnable (GL_BLEND);
	glDisable (GL_TEXTURE_2D);
	glBegin (GL_QUADS);
	glColor4f (0.0, 0.0, 0.0, 0.0);
	int z, zz;
	zz = 0;
	for (z = 0; z < levelheight; z++, zz += 1024) {
	    glVertex3i (x1, y1, (zz + 0) * YCORRECTFACT);
	    glVertex3i (x1, y1, (zz + 1024) * YCORRECTFACT);
	    glVertex3i (x2, y2, (zz + 1024) * YCORRECTFACT);
	    glVertex3i (x2, y2, (zz + 0) * YCORRECTFACT);
	}
	glEnd ();
	glColor4f (1.0, 1.0, 1.0, 1.0);
	return;
    } else {
	glDisable (GL_BLEND);
	glEnable (GL_TEXTURE_2D);
    }
    int z, zz;
    z = 0;
    int tex = GetTexForLump (lump,REPEAT_X|REPEAT_Y)->tex.texnum[0];
    if (alttile >= 0) {
	texes[0] = tex;
	tex = GetTexForLump (alttile,REPEAT_X|REPEAT_Y)->tex.texnum[0];
	z++;
    }
    for (; z < levelheight; z++) {
	texes[z] = tex;
    }
    DrawAWall (x1, y1, x2, y2, texes, dimfact, dofl);
    checkGLStatus ();
}

void GLDrawWalls (void)
{
    wallent_t *cur = viswalls;
    int i;
    if (fog)
	glEnable (GL_FOG);
    SetDrawMode(GLV_WALL);
    //printf("%d\n",numviswalls);
    for (i = 0; i < numviswalls; i++, cur++) {
	DrawNormWall (cur);
    }
}
GLfloat debugcolors[6][3] = {
    {0.5, 0.5, 0.5}
    ,
    {0.5, 0.5, 1.0}
    ,
    {0.5, 1.0, 0.5}
    ,
    {0.5, 1.0, 1.0}
    ,
    {1.0, 0.5, 0.5}
    ,
    {1.0, 0.5, 1.0}
    ,
};
void GLDrawSky (void)
{
    int txn, vn;
    if (!sky)
	return;
    SetDrawMode(GLV_SKY);
    double fact = 1.0;
    if (MISCVARS->GASON) {
	fact = (MISCVARS->gasindex / 15.0);
    }

    for (txn = 0; txn < 6; txn++) {
#ifdef KEEP_SKYS
	BindTex( skytex[sky - 1][txn]);
#else
	BindTex( skytex[txn]);
#endif
	glBegin (GL_QUADS);
	glColor3f (1.0, 1.0, 1.0);
	for (vn = 0; vn < 4; vn++) {
	    glTexCoord2dv (skytexwind[vn]);
	    glVertex3iv (skywind[txn][vn]);
	}
	glEnd ();
	if (MISCVARS->GASON) {
	    glEnable (GL_BLEND);
	    glDisable (GL_TEXTURE_2D);
	    glBegin (GL_QUADS);
	    glColor4f (0.0, 1.0, 0.0, fact / 2.0);
	    for (vn = 0; vn < 4; vn++) {
		glVertex3iv (skywind[txn][vn]);
	    }
	    glEnd ();
	    glColor4f (1.0, 1.0, 1.0, 1.0);
	    glDisable (GL_BLEND);
	    glEnable (GL_TEXTURE_2D);
	}
	if (lightninglevel>0) {
	    //printf ("%d\n",lightninglevel);
	    glEnable (GL_BLEND);
	    glDisable (GL_TEXTURE_2D);
	    glBegin (GL_QUADS);
	    glColor4f (1.0, 1.0, 1.0, (lightninglevel/15.0));
	    for (vn = 0; vn < 4; vn++) {
		glVertex3iv (skywind[txn][vn]);
	    }
	    glEnd ();
	    glColor4f (1.0, 1.0, 1.0, 1.0);
	    glDisable (GL_BLEND);
	    glEnable (GL_TEXTURE_2D);
	}

    }
}

// Some of this code is from TransformPushWalls
void GLDrawPushWalls (void)
{
    double x1, x2, y1, y2;
    int texes[16];
    byte *visspot;
    int i, j, gx, gy;
    SetDrawMode(GLV_PUSHWALL);
    double dimfact=((gamestate.difficulty/3.0)*0.2)+0.8;

    for (i = 0; i < pwallnum; i++) {
	if ((pwallobjlist[i]->action == pw_pushed)
	    || (pwallobjlist[i]->action == pw_npushed))
	    continue;
	visspot =
	    &spotvis[pwallobjlist[i]->x >> 16][pwallobjlist[i]->y >> 16];
	if (*visspot || (*(visspot - 1))
	    || (*(visspot + 1))
	    || (*(visspot - 128))
	    || (*(visspot + 128))) {
	    gx = pwallobjlist[i]->x;
	    gy = pwallobjlist[i]->y;
	    mapseen[gx >> 16][gy >> 16] = 1;
	    int dofl = 0;
	    int lump=GetAnimTex (pwallobjlist[i]->texture);
	    if ((lump >= 127 && lump <= 132) ||
		(lump >= 77 && lump <= 80))
		dofl = 1;
	    
	    int tex = GetTexForLump (lump,REPEAT_X|REPEAT_Y)->tex.texnum[0];
	    for (j = 0; j < levelheight; j++)
		texes[j] = tex;
	    x1 = pwallobjlist[i]->x / 64.0 - 512.0;
	    y1 = pwallobjlist[i]->y / 64.0 - 512.0;
	    DrawAWall (x1, y1, x1, y1 + 1024, texes, dimfact, dofl);
	    DrawAWall (x1, y1 + 1024, x1 + 1024, y1 + 1024, texes, dimfact, dofl);
	    DrawAWall (x1 + 1024, y1 + 1024, x1 + 1024, y1, texes, dimfact, dofl);
	    DrawAWall (x1 + 1024, y1, x1, y1, texes, dimfact, dofl);
	}
    }
    //    glDisable(GL_CULL_FACE);
}

#define tcxl (xx&1?0.5:0.0)
#define tcxh (xx&1?1.0:0.5)
#define tcyl (yy&1?0.5:0.0)
#define tcyh (yy&1?1.0:0.5)
void GLDrawFloorCeil (void)
{
    int xx, yy, cpos;
    //return;
    SetDrawMode(GLV_FLOORCEIL);
    byte *visptr = &spotvis[0][0];
    cpos = levelheight * 1024 * YCORRECTFACT;
    BindTex( floortex);
    if (NO_FLOORDEPTH) glDepthMask(0);
    glStencilOp(GL_KEEP,GL_KEEP,GL_KEEP);
    glStencilFunc(GL_EQUAL,0,1);
    //glEnable(GL_STENCIL_TEST);
    glBegin (GL_QUADS);
    for (xx = 0; xx < 128; xx++) {
	for (yy = 0; yy < 128; yy++, visptr++) {
	    if (!*visptr || IsWindow (xx, yy))
		continue;
	    glTexCoord2f (tcxl, tcyl);
	    GLSetLight ((xx << 10), (yy << 10), 1.0);
	    glVertex3i ((xx << 10), (yy << 10), 0);

	    glTexCoord2f (tcxh, tcyl);
	    GLSetLight ((xx << 10) + 1024, (yy << 10), 1.0);
	    glVertex3i ((xx << 10) + 1024, (yy << 10), 0);

	    glTexCoord2f (tcxh, tcyh);
	    GLSetLight ((xx << 10) + 1024, (yy << 10) + 1024, 1.0);
	    glVertex3i ((xx << 10) + 1024, (yy << 10) + 1024, 0);

	    glTexCoord2f (tcxl, tcyh);
	    GLSetLight ((xx << 10), (yy << 10) + 1024, 1.0);
	    glVertex3i ((xx << 10), (yy << 10) + 1024, 0);
	}
    }
    glEnd ();
    if (!sky) {
	visptr = &spotvis[0][0];
	BindTex( ceilingtex);
	glBegin (GL_QUADS);
	for (xx = 0; xx < 128; xx++) {
	    for (yy = 0; yy < 128; yy++, visptr++) {
		if (!*visptr || IsWindow (xx, yy))
		    continue;
		glTexCoord2f (tcxl, tcyl);
		GLSetLight ((xx << 10), (yy << 10), 1.0);
		glVertex3i ((xx << 10), (yy << 10), cpos);

		glTexCoord2f (tcxh, tcyl);
		GLSetLight ((xx << 10) + 1024, (yy << 10), 1.0);
		glVertex3i ((xx << 10) + 1024, (yy << 10), cpos);

		glTexCoord2f (tcxh, tcyh);
		GLSetLight ((xx << 10) + 1024, (yy << 10) + 1024, 1.0);
		glVertex3i ((xx << 10) + 1024, (yy << 10) + 1024, cpos);

		glTexCoord2f (tcxl, tcyh);
		GLSetLight ((xx << 10), (yy << 10) + 1024, 1.0);
		glVertex3i ((xx << 10), (yy << 10) + 1024, cpos);
	    }
	}
	glEnd ();
    }
}

#undef tcxl
#undef tcyl
#undef tcxh
#undef tcyh
void GLSkyInit (void)
{
    int floornum, ceilingnum;
    sky = 0;
    if (MAPSPOT (1, 0, 0) >= 234) {
	sky = (MAPSPOT (1, 0, 0) - 233);
	if ((sky < 1) || (sky > 6))
	    Error ("Illegal Sky Tile = %ld\n", sky);
	ceilingnum = 1;
	LoadSky (sky - 1);
	// Check for lightnign icon
	lightning=false;
	int crud=(word)MAPSPOT(4,0,1);
	if (crud==377)
	    lightning=true;
    } else
	ceilingnum = MAPSPOT (1, 0, 0) - 197;

    floornum = MAPSPOT (0, 0, 0) - 179;

    char buf[10];

    sprintf (buf, "FLRCL%d", floornum);
    floornum = W_GetNumForName (buf);
    floortex = GetTexForLump (floornum,REPEAT_X|REPEAT_Y)->tex.texnum[0];

    if (!sky) {
	sprintf (buf, "FLRCL%d", ceilingnum);
	ceilingnum = W_GetNumForName (buf);
	ceilingtex = GetTexForLump (ceilingnum,REPEAT_X|REPEAT_Y)->tex.texnum[0];
    }
    printf("Sky init successful\n");
}

void GLCalcShroomHue (void)
{
    Uint32 now = SDL_GetTicks ();
    if (!shroomlast) shroomlast=now;
    Uint32 itime = now - shroomlast;
    shroomlast = now;
    double dtime = (double)itime / 40.0;
    int i;
    shroomrec* cshr=shrooms;
    for (i=0;i<32;i++,cshr++) {
	cshr->hue += dtime;
	while (cshr->hue > 6.0)
	cshr->hue -= 6.0;
	int huesec = (int)(cshr->hue);
	double d = cshr->hue - huesec;
	switch (huesec) {
	case 0:
	    cshr->r = 1.0;
	    cshr->g = d;
	    cshr->b = 0.0;
	    break;
	case 1:
	    cshr->r = 1.0 - d;
	    cshr->g = 1.0;
	    cshr->b = 0.0;
	    break;
	case 2:
	    cshr->r = 0.0;
	    cshr->g = 1.0;
	    cshr->b = d;
	    break;
	case 3:
	    cshr->r = 0.0;
	    cshr->g = 1.0 - d;
	    cshr->b = 1.0;
	    break;
	case 4:
	    cshr->r = d;
	    cshr->g = 0.0;
	    cshr->b = 1.0;
	    break;
	case 5:
	    cshr->r = 1.0;
	    cshr->g = 0.0;
	    cshr->b = 1.0 - d;
	    break;
	}
    }
}

extern int bordercolor;		// I know, I should just include the header.

#define BORDERSIZE (1.0/100.0)
#define SETBC  glColor4f(red,green,blue,1.0)
#define SETBCA glColor4f(red,green,blue,0.0)

void GLDrawBorder (void)
{
    if (bordercolor == 0)
	return;
    int col = gampal[bordercolor];
    double red = REDCMP (col) / 255.0;
    double green = GREENCMP (col) / 255.0;
    double blue = BLUECMP (col) / 255.0;
    SetDrawMode(GLV_BORDER);
    glTexEnvf (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
    glMatrixMode (GL_PROJECTION);
    glLoadIdentity ();
    gluOrtho2D (0.0, 1.0, screenratio, 0.0);
    glMatrixMode (GL_MODELVIEW);
    glLoadIdentity ();

    glBegin (GL_QUAD_STRIP);
    SETBC;
    glVertex2f (0.0, 0.0);
    SETBCA;
    glVertex2f (BORDERSIZE, BORDERSIZE);
    SETBC;
    glVertex2f (1.0, 0.0);
    SETBCA;
    glVertex2f (1.0 - BORDERSIZE, BORDERSIZE);
    SETBC;
    glVertex2f (1.0, screenratio);
    SETBCA;
    glVertex2f (1.0 - BORDERSIZE, screenratio - BORDERSIZE);
    SETBC;
    glVertex2f (0.0, screenratio);
    SETBCA;
    glVertex2f (BORDERSIZE, screenratio - BORDERSIZE);
    SETBC;
    glVertex2f (0.0, 0.0);
    SETBCA;
    glVertex2f (BORDERSIZE, BORDERSIZE);
    glEnd ();


}
void GLSetFadeFactor (int red, int green, int blue, int alpha)
{
    double lastalpha = fadealpha;
    fadered = (double)red / 255.0;
    fadegreen = (double)green / 255.0;
    fadeblue = (double)blue / 255.0;
    fadealpha = (double)alpha / 255.0;
    //if (fabs(lastalpha-fadealpha)>0.3) {
    //printf("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n");
    //}
    //printf("%f %f %f %f\n",fadered,fadegreen,fadeblue,fadealpha);
}

int GLGetFadeAlpha ()
{
    return (int)(fadealpha * 255.0);
}

static inline int lineinvis(byte* linstart) {
    int i;
    for (i=0;i<320;i++,linstart++) if (*linstart!=255) return 0;
    return 1;
}
static inline int scanvis(int dir) {
    byte *linstart=screenbuffer+(100*320);
    int y,lsk;
    lsk=dir*320;
    for (y=100;y>=0&&y<200;y += dir, linstart += lsk) {
	if (!lineinvis(linstart)) return y;
    }
    return y;
}
static inline int linezero(byte* linstart) {
    int i;
    for (i=0;i<320;i++,linstart++) if (*linstart!=0) return 0;
    return 1;
}
static inline int scanzero(int start, int dir) {
    byte *linstart=screenbuffer+(start*320);
    int y,lsk;
    lsk=dir*320;
    for (y=start;y>=0&&y<200;y += dir, linstart += lsk) {
	if (!linezero(linstart)) return y;
    }
    return y;
}
static inline int colzero(byte* linstart) {
    int i;
    for (i=0;i<200;i++,linstart+=320) if (*linstart!=0) return 0;
    return 1;
}
static inline int scanxzero(int start, int dir) {
    byte *linstart=screenbuffer+start;
    int x,lsk;
    for (x=start;x>=0&&x<320;x += dir, linstart += dir) {
	if (!colzero(linstart)) return x;
    }
    return x;
}


void GLDraw2dObjects(int overlay) {
    if (!n2dobjects) return;
    SetDrawMode(GLV_2DOBJECTS);
    glTexEnvf (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
    int lcorrect=1;


    double bbsizeh=((0.75/screenratio)*1.0 - 1.0)/2.0;
    double bbsizev=((screenratio/0.75)*0.75 - 0.75)/2.0;
    double bbsize=bbsizev;
    
    double left, right, top, bot;
    
    if (bbsizeh>0) {
	left=-bbsizeh;
	right=1.0+bbsizeh;
	top=0;
	bot=0.75;
    } else {
	left=0;
	right=1.0;
	top=-bbsizev;
	bot=0.75+bbsizev;
    }
    
    
    glMatrixMode (GL_PROJECTION);
    glLoadIdentity ();
    gluOrtho2D (left, right, bot, top);
    glMatrixMode (GL_MODELVIEW);
    glLoadIdentity ();
    double ratiocorrectfact=screenratio/0.75;
    int i;
    gl2DObject* cur=twodobjects;
    for (i=0;i<n2dobjects;i++,cur++) {
	if ((overlay?1:0) ^ (cur->flags&GLSS_OVERLAY?1:0)) continue;
	//printf("GLDrawScreenShape ovr=%d lump=%s p=%d,%d rot=%f rp=%d,%d scl=%f\n",overlay,W_GetNameForNum(cur->lump),
	//       cur->x,cur->y,cur->rot,cur->rtx,cur->rty,cur->scale);
	if (cur->flags&GLSS_USELIGHT) {
	    GLSetLight(viewx/64.0, viewy/64.0, 1.0);
	} else {
	    glColor3f(1,1,1);
	}
	if (cur->flags&GLSS_CORRECTRATIO) {
	    if (!lcorrect) {
		glMatrixMode (GL_PROJECTION);
		glLoadIdentity ();
		gluOrtho2D (left, right, bot, top);
		lcorrect=1;
	    }
	} else {
	    if (lcorrect) {
		glMatrixMode (GL_PROJECTION);
		glLoadIdentity ();
		gluOrtho2D (0.0, 1.0, 0.75, 0.0);
		lcorrect=0;
	    }
	}
	
	glMatrixMode (GL_MODELVIEW);
	glLoadIdentity ();
	glTranslated(cur->x/320.0,cur->y*(0.75/200.0),0);
 	//glTranslated(cur->rtx/320.0,cur->rty*(0.75/200.0),0);
	glScaled(cur->scale,cur->scale,1);
	glRotated(cur->rot,0,0,1);
 	glTranslated(-cur->rtx/320.0,-cur->rty*(0.75/200.0),0);
	cur->draw(cur->data);

    }

}

void GLCacheLump(int lump) {
             if (lump != 183){
       
//WriteDebug("cachelist[i].lump in",cachelist[i].lump);
    GetTexForLump(lump,REPEAT_AUTO);
}
}

void GLClearScreenShapes() {
    int i;
    gl2DObject* cur=twodobjects;
    for (i=0;i<n2dobjects;i++,cur++) {
	cur->free(cur->data);
    }
    n2dobjects=0;
}
static void GLDrawLumpObject(void* data) {
    int lump=*(int*)data;
    gl_lumpinfo_t* tex=GetTexForLump(lump,0);
    double ssx1=tex->tex.lofs/320.0;
    double ssy1=tex->tex.tofs*(0.75/200.0);
    double ssx2=ssx1+(tex->tex.w/320.0);
    double ssy2=ssy1+(tex->tex.h*(0.75/200.0));
    
    BindTex(tex->tex.texnum[0]);
    glBegin (GL_QUADS);
    
    glTexCoord2f(tex->tex.tcxl,tex->tex.tcyl);
    glVertex2d(ssx1,ssy1);
    
    glTexCoord2f(tex->tex.tcxh,tex->tex.tcyl);
    glVertex2d(ssx2,ssy1);
    
    glTexCoord2f(tex->tex.tcxh,tex->tex.tcyh);
    glVertex2d(ssx2,ssy2);
    
    glTexCoord2f(tex->tex.tcxl,tex->tex.tcyh);
    glVertex2d(ssx1,ssy2);
    glEnd();

}



int weaponlump;	
double g_wscale = 0.95;//global weaponscale

void GLAddScreenShape(int lump, int x, int y, int flags) 
{
	double scale = 1;

    gl2DObject* cur=&twodobjects[n2dobjects];

	if (weaponlump == lump){
		scale = g_wscale;//used in DrawPlayerWeapon too
	}

    cur->data=malloc(sizeof(int));
    *(int*)cur->data=lump;
    cur->x=x;
    cur->y=y;
    cur->flags=flags;
    cur->rot=0;
    cur->rtx=0;
    cur->rty=0;
    cur->scale=scale;
    cur->draw=GLDrawLumpObject;
    cur->free=free;
    n2dobjects++;
}



void GLAddScreenShapeEx(int lump, int x, int y, int rtx, int rty, double rotate, double scale, int flags) {
    gl2DObject* cur=&twodobjects[n2dobjects];
    cur->data=malloc(sizeof(int));
    *(int*)cur->data=lump;
    cur->x=x;
    cur->y=y;
    cur->flags=flags;
    cur->rot=rotate;
    cur->rtx=rtx;
    cur->rty=rty;
    cur->scale=scale;
    cur->draw=GLDrawLumpObject;
    cur->free=free;
    n2dobjects++;
}


struct glimage_s {
    GLuint tex;
    int w, h;
    double tcx,tcy;
};
typedef struct {
    glimage_t* img;
    int sw, sh;
} glimgobjpriv;

glimage_t* GLLoadImage(const char* name, int mipmaps) {
    return GLReloadImage(NULL,name,mipmaps);
    
}
glimage_t* GLReloadImage(glimage_t* ret,const char* name, int mipmaps) {
    SDL_Surface *tmp = IMG_Load (name);
    if (!tmp) {
	if (ret)
	    GLFreeImage(ret);
	return NULL;
    }
    if (!ret) {
	ret = (glimage_t*) malloc(sizeof(glimage_t));
	glGenTextures (1, &ret->tex);
    }
    UploadSurfaceToTexture (ret->tex, tmp, 0, mipmaps, &ret->tcx, &ret->tcy);
    ret->w=tmp->w;
    ret->h=tmp->h;
    SDL_FreeSurface (tmp);
    return ret;
    
}
/*glimage_t* GLSaveScreenToImage() {
    glimage_t* ret = (glimage_t*) malloc(sizeof(glimage_t));
    SDL_Surface *tmp = IMG_Load (name);
    ret->w=512;
    ret->h=384;

    glGenTextures (1, &ret->img);
    UploadSurfaceToTexture (ret->img, tmp, 0, 1);
    SDL_FreeSurface (tmp);
    return ret;
    
    }*/
void GLFreeImage(glimage_t* img) {
    glDeleteTextures(1,&img->tex);
    free(img);
}

static void GLDrawImageObject(void* data) {
    glimgobjpriv* priv=(glimgobjpriv*)data;
    double ssx1=0.0;
    double ssy1=0.0;
    double ssx2=ssx1+(priv->sw/320.0);
    double ssy2=ssy1+(priv->sh*(0.75/200.0));
    
    BindTex(priv->img->tex);
    glBegin (GL_QUADS);
    
    glTexCoord2f(0,0);
    glVertex2d(ssx1,ssy1);
    
    glTexCoord2f(priv->img->tcx,0);
    glVertex2d(ssx2,ssy1);
    
    glTexCoord2f(priv->img->tcx,priv->img->tcy);
    glVertex2d(ssx2,ssy2);
    
    glTexCoord2f(0,priv->img->tcy);
    glVertex2d(ssx1,ssy2);
    glEnd();

}

void GLAddImage(glimage_t* img, int x, int y, int w, int h, int flags) {
    gl2DObject* cur=&twodobjects[n2dobjects];
    glimgobjpriv* priv=(glimgobjpriv*)malloc(sizeof(glimgobjpriv));
    
    cur->data=priv;
    priv->img=img;
    priv->sw=w;
    priv->sh=h;
    cur->x=x;
    cur->y=y;
    cur->flags=flags;
    cur->rot=0;
    cur->rtx=0;
    cur->rty=0;
    cur->scale=1;
    cur->draw=GLDrawImageObject;
    cur->free=free;
    n2dobjects++;
}
void GLAddImageEx(glimage_t* img, int x, int y, int w, int h, int rtx, int rty, double rotate, double scale, int flags) {
    gl2DObject* cur=&twodobjects[n2dobjects];
    glimgobjpriv* priv=(glimgobjpriv*)malloc(sizeof(glimgobjpriv));
    
    cur->data=priv;
    priv->img=img;
    priv->sw=w;
    priv->sh=h;
    cur->x=x;
    cur->y=y;
    cur->flags=flags;
    cur->rot=rotate;
    cur->rtx=rtx;
    cur->rty=rty;
    cur->scale=scale;
    cur->draw=GLDrawImageObject;
    cur->free=free;
    n2dobjects++;
}


void GLRefresh (void)
{
    timer t;

    BeginTimer(&t);
    //printf("GLRefresh\n");
    if (DoingRotate) {
	//      printf("GLRefresh called while rotating\n");
	        return;
    }
    static int blah;
    //glClearColor(1.0,0.0,1.0,1.0);
    SetDrawMode(-1);
    glDepthMask(1);
    glClear (GL_DEPTH_BUFFER_BIT|(inmenu?GL_COLOR_BUFFER_BIT:0)|GL_STENCIL_BUFFER_BIT);
    int dodraw = 0;
    Uint8 *test = screenbuffer;
    int i;
    if (!inmenu && mapplanes[0])
	for (i = 0; i < (320 * 200); i++, test++) {
	    if (*test == 255) {
    		dodraw = 1;
    		break;
	    }
	}
    OverlayStretch=0;
    if (dodraw) {
    	OverlayStretch=1;
    	//printf("%d\n",nonbobpheight);
    	//glEnable (GL_TEXTURE_2D);
    	glTexEnvf (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
    	GLCalcShroomHue ();
    	GLSetupCamera (0, 1.0);
    	GLDrawSky ();
    	GLSetupCamera (1, 1.0);
    	GLCalcLights ();
    	GLDrawWalls ();
    	GLDrawPushWalls ();
    	GLDrawStencilThings ();
    	GLDrawFloorCeil ();
    	GLDrawFlatThings ();
 #if (USERAINCODE != 1)   	
       	GLDraw2dObjects(0);
 #endif
    }
    /*if ((blah++)&1) */
    int vistop=scanvis(-1)+1;
    int visbot=scanvis(1)-1;

    int ztop=scanzero(0,1);
    int zbot=199-scanzero(199,-1);
    int zleft=scanxzero(0,1);
    int zright=319-scanxzero(319,-1);

    double bbsizeh=((0.75/screenratio)*320.0 - 320)/2.0;
    double bbsizev=((screenratio/0.75)*200.0 - 200)/2.0;
    if (bbsizeh < 0) {
    	ztop += bbsizev;
    	zbot += bbsizev;
    } else {
    	zleft += bbsizeh;
    	zright += bbsizeh;
    }
    int min=ztop;
    if (zbot<min) min=zbot;
    if (ztop<min) min=ztop;
    if (zleft<min) min=zleft;
    if (zright<min) min=zright;


    if (bbsizev<0) {
	   OverlayZoom=((min-160)/-160.0);
    } else {
	   OverlayZoom=((min-100)/-100.0);
    }
    //printf("%d %d %d %d %d %f\n",min,zleft, zright,ztop,zbot, OverlayZoom);

/*
	//bna added
	if (playstate != ex_died){
    	if ((!inautomap)&&(ingame)&&(!inmenu)&&(iG_aimCross)&&(!GamePaused)&&(!fizzlein)&&(!demoplayback))
    		CH_DrawCrosshair (screenbuffer);
    }*/
   	if ((dodraw)&&(iG_aimCross)) 
  		CH_DrawCrosshair (screenbuffer);
  		
    void (*screenfunc)(int,int,int,int);
    
    if (UploadScreen) 
       screenfunc=UploadPartialOverlay;
    else 
       screenfunc=ShowPartialOverlay;
    //if (/*!dodraw ||*/ vistop>=visbot) {
	screenfunc (0, 0, 320, 200);
    //} else { 
	//if (vistop!=0) {
	//    screenfunc (0, 0, 320, vistop);
	//}
	//if (visbot!=199) {
	//    screenfunc (0, visbot+1, 320, 199-visbot);
	//}

#if (USERAINCODE == 1)
    if (useRain == 1){
        if (bIsRainInit == FALSE){
    	    GLInitRain(&rain,NUMDROPS); 
            bIsRainInit = TRUE;            
        }
        //adjust rainpos depending of relative pos to player
    	SetRainPlayerPos(&rain);
    	if (dodraw) 
    	{
    		SetDrawMode(GLV_RAIN); 
    		GLDrawRain(&rain,NUMDROPS);
    	    GLDraw2dObjects(0);//redraw hand		
    	    if (SHOW_TOP_STATUS_BAR ()) 
    			screenfunc (0, 0, 320, 20);
    		if ((SHOW_BOTTOM_STATUS_BAR ()) || (SHOW_PLAYER_STATS()))
    			screenfunc (0, 180, 320, 20);
    //		screenfunc (4, 200-20, 80, 20);//redraw the healthbar
    //		screenfunc (320-80-10, 200-20, 80, 20);//redraw the ammobar
    
    	}
    }else{
   	    if (dodraw)     
            GLDraw2dObjects(0);//redraw hand         
    }
#endif
  
	
	GLDrawBorder ();
    //}
    GLDraw2dObjects(1);
    static int tst=0;
    if (fadealpha > 0.0) {
	SetDrawMode(GLV_FADE);

	glTexEnvf (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
	//printf ("%f %f %f fadealpha=%f\n",fadered,fadegreen,fadeblue,fadealpha);
	glMatrixMode (GL_PROJECTION);
	glLoadIdentity ();
	gluOrtho2D (0.0, 1.0, screenratio, 0.0);
	glMatrixMode (GL_MODELVIEW);
	glLoadIdentity ();
	//if (tst++&1) {
#if 1
	    glBegin (GL_QUADS);
	    glColor4f (fadered, fadegreen, fadeblue, fadealpha);
	    glVertex2f (0.0, 0.0);
	    glVertex2f (1.0, 0.0);
	    glVertex2f (1.0, screenratio);
	    glVertex2f (0.0, screenratio);
	    glEnd ();
#endif
	    //}
    }
    
        
    
    if (DrawScreen)
	SDL_GL_SwapBuffers ();
    int micros=EndTimer(&t);
    double fps=1000000.0/micros;
    static int dbline=0;
    DebugAt(&dbline,"GLRefresh [%d us, %f fps]",micros,fps);
    //else printf("Screen drawn without displaying\n");
}

void TimeRefresh(int rotate) {
    char buf[264];
    int saveang=viewangle;
    Uint32 begin=SDL_GetTicks();
    int i;
    for (i=0;i<60;i++) {
	if (rotate) {
	    viewangle=(int)((2048.0/60.0)*i);
	    ThreeDRefresh();
	} else {
	    GLRefresh();
	}
    }
    Uint32 end=SDL_GetTicks();
    double secs = (end-begin)/1000.0;
    double fps = 60.0/secs;
    sprintf(buf,"%.2f secs = %.4f fps",secs,fps);
    AddMessage (buf,MSG_GAME);
    viewangle=saveang;
}


#define FALLING_TIME (VBLCOUNTER*2.0)
#define LOOKDOWN_TIME (VBLCOUNTER/2.0)


void GLDoFalling ()
{
    int i;
    int ova = viewangle;
    int ola = lookangle;

    int sla = lookangle;
    dying=1;
    while (sla > 1024)
	sla -= 2048;
    CalcTics ();
    for (i = 0; i < LOOKDOWN_TIME; i += tics) {
	double step = (double)i / (double)LOOKDOWN_TIME;
	lookangle = (int)((-512 - sla) * step + sla);
	//printf("%d %d %f\n",lookangle,ola,step);
	GLSetupCamera (0, 1.0);
	GLDrawSky ();
	SDL_GL_SwapBuffers ();
	CalcTics ();
    }
    CalcTics ();
    for (i = 0; i < FALLING_TIME; i += tics) {
	viewangle += (tics * 64);
	double step = (double)i / (double)FALLING_TIME;
	GLSetupCamera (0, 1.0 / (step * 20.0 + 1.0));
	GLDrawSky ();
	SDL_GL_SwapBuffers ();
	CalcTics ();
    }
    lookangle = ola;
    viewangle = ova;
    dying=0;
}
void DrawScreenToBuffer (Uint32 * buf, int x, int y, int w, int h)
{
    int imsave=inmenu;
    inmenu=false;
    memset (buf, 0, w * h * 4);
    Uint32 *tmpbuf = (Uint32 *) malloc (glscreenw * glscreenh * 4);
    glDrawBuffer (GL_BACK);
    DrawScreen=0;
    GLRefresh ();
    inmenu=imsave;
    DrawScreen=1;
    glReadBuffer (GL_BACK);
    glReadPixels (0, 0, glscreenw, glscreenh, GL_RGBA, GL_UNSIGNED_BYTE,
		  tmpbuf);
    int i;
    Uint32 *idpos = (buf + x + w * y);
    for (i = 0; i < (glscreenh); i++) {
	Uint32 *posa = idpos + (w * i);
	Uint32 *posb = tmpbuf + (glscreenw * (glscreenh - i - 1));
	memcpy (posa, posb, glscreenw * 4);
    }
    glDrawBuffer (GL_BACK);
    glReadBuffer (GL_BACK);
    free (tmpbuf);
}

Uint32* glsavedscreen=NULL;

void GLSaveScreen(int fixratio) {
    double tempratio=screenratio;
    if (fixratio) screenratio=0.75;
    printf("saved screen, fixratio=%d ratio=%f\n",fixratio,screenratio);
    if (glsavedscreen==NULL) {
	glsavedscreen=malloc(glscreenw*glscreenh*4);
    }
    //glClear(GL_COLOR_BUFFER_BIT);
    DrawScreenToBuffer(glsavedscreen,0,0,glscreenw,glscreenh);
    screenratio=tempratio;
}
void GLDeleteSave() {
    if (glsavedscreen!=NULL) {
	free(glsavedscreen);
	glsavedscreen=NULL;
    }
}

Uint32* ScaleImage(Uint32* in, int sw, int sh, int nw, int nh) {
    int cx,ex,cy,ey,totr,totb,totg,cnt,x2,y2,cc,xx,yy;
    double sfx=((double)sw/(double)nw);
    double sfy=((double)sh/(double)nh);
    Uint32* ret = (Uint32*)malloc(nw*nh*4);
    for (yy=0;yy<nh;yy++) {
	cy=(int)(yy*sfy);
	ey=(int)((yy+1)*sfy);
	if (cy==ey)ey++;
	for (xx=0;xx<nw;xx++) {
	    cx=(int)(xx*sfx);
	    ex=(int)((xx+1)*sfx);
	    if (cx==ex)ex++;
	    totr=0;
	    totg=0;
	    totb=0;
	    cnt=0;
	    for (y2=cy;y2<ey;y2++) {
		for (x2=cx;x2<ex;x2++) {
		    cc=in[x2+sw*y2];
		    totr += (cc>>16)&255;
		    totg += (cc>>8)&255;
		    totb += (cc)&255;
		    cnt++;
		}
	    }
		    
	    ret[xx+nw*yy]=0xFF000000|((totr/cnt)<<16)|((totg/cnt)<<8)|(totb/cnt);
	}
    }
    return ret;
}


int GLWriteSaveGameScreen(const char* name) {
    Uint32* shrunk=ScaleImage(glsavedscreen,glscreenw,glscreenh,320,240);
    SDL_Surface* tmp=SDL_CreateRGBSurfaceFrom(shrunk,320,240,32,320*4,255<<RED_SHIFT,255<<GREEN_SHIFT,255<<BLUE_SHIFT,255<<ALPHA_SHIFT);
    SDL_SaveBMP(tmp,name);
    free(shrunk);
    SDL_FreeSurface(tmp);
    return 1;
}
#ifdef PNG_SAVE
char* gl_ss_ext="png";
int GLWriteSavedScreen(const char* name) {
    //screenratio=0.75;
    png_structp png_ptr;
    png_infop info_ptr;
    png_bytep * row_pointers;
    int i,j;
    
    png_ptr = png_create_write_struct(PNG_LIBPNG_VER_STRING, NULL,NULL, NULL);
    if (!png_ptr) return 0;
    info_ptr = png_create_info_struct(png_ptr);
    if (!info_ptr) {
	png_destroy_write_struct(&png_ptr,(png_infopp)NULL);
	return 0;
    }
    
    FILE * fp=fopen(name,"wb");
    if (!fp) {
	return 0;
    }
    int npix=glscreenw*glscreenh;
    unsigned char* tmpscr,*dpos;
    Uint32* spos=glsavedscreen;
    tmpscr=dpos=(unsigned char*)malloc(npix*3);

    for (i=0;i<npix;i++) {
	int pix=*spos++;
	*dpos++=REDCMP(pix);
	*dpos++=GREENCMP(pix);
	*dpos++=BLUECMP(pix);
    }
    png_init_io(png_ptr, fp);
    png_set_compression_level(png_ptr,Z_BEST_SPEED);
    
    png_set_compression_mem_level(png_ptr, 8);
    png_set_compression_strategy(png_ptr,Z_DEFAULT_STRATEGY);
    png_set_compression_window_bits(png_ptr, 15);
    png_set_compression_method(png_ptr, 8);
    png_set_compression_buffer_size(png_ptr, 8192);
    
    png_set_IHDR(png_ptr, info_ptr, glscreenw, glscreenh,
		 8, PNG_COLOR_TYPE_RGB, PNG_INTERLACE_NONE,
		 PNG_COMPRESSION_TYPE_DEFAULT, PNG_FILTER_TYPE_DEFAULT);

    /*Allocate an array of scanline pointers*/
    row_pointers=(png_bytep*)malloc(glscreenh*sizeof(png_bytep));
    int pitch=glscreenw*3;
    for (i=0;i<glscreenh;i++) {
	row_pointers[i]=((png_bytep)tmpscr+i*pitch);
    }
    /*tell the png library what to encode.*/
    png_set_rows(png_ptr, info_ptr, row_pointers);
    
    /*Write image to file*/
    png_write_png(png_ptr, info_ptr, 0, NULL);
    
    /*close file*/
    fclose(fp);
    
    /*Destroy PNG structs*/
    png_destroy_write_struct(&png_ptr, &info_ptr);
    
    /*clean up dynamically allocated RAM.*/
    free(row_pointers);
    free(tmpscr);
    return 1;
}
#else
char* gl_ss_ext="bmp";
int GLWriteSavedScreen(const char* name) {
    /*char tmp_name[MAX_PATH];
    strcpy(tmp_name,name);
    char* dot=strrchr(tmp_name,'.');
    char* slash=strrchr(tmp_name,'/');
    if (dot && dot>slash) strcpy(dot,".bmp");
    printf("name=%s\n",tmp_name);*/
    Uint32* spos=glsavedscreen;
    SDL_Surface* tmp=SDL_CreateRGBSurfaceFrom(glsavedscreen,glscreenw,glscreenh,32,glscreenw*4,255<<RED_SHIFT,255<<GREEN_SHIFT,255<<BLUE_SHIFT,255<<ALPHA_SHIFT);
    SDL_SaveBMP(tmp,name);
    SDL_FreeSurface(tmp);
    return 1;
}
#endif
void GLSetScreenVisible (int vis)
{
    DrawScreen = vis;
}
void GLSetUpload (int upl)
{
    UploadScreen=upl;
}

static double scrtrw,scrtrh;

static GLuint screentex;
/*static GLdouble subtexleft = 0;
static GLdouble subtexright = 0;
static GLdouble subtextop = 0;
static GLdouble subtexbot = 0;

static GLdouble csubtexleft = 0;
static GLdouble csubtexright = 0;
static GLdouble csubtextop = 0;
static GLdouble csubtexbot = 0;*/

static double rtcx, rtcy;


void GLStartRotate ()
{
    int rsw=powerof2(glscreenw);
    int rsh=powerof2(glscreenh);
    Uint32 *buf = (Uint32 *) malloc (glscreenw * glscreenh * 4);
    DrawScreenToBuffer (buf, 0, 0, glscreenw, glscreenh);

    Uint32 *rtex = malloc (rsw * rsh * 4);

    copy2d (buf, glscreenw, glscreenh, rtex, rsw, rsh, 0, 0,
	    0, 0, glscreenw,glscreenh);

    glGenTextures(1,&screentex);
    UploadTexture(screentex,rtex,rsw,rsh,0,0,0,20);

    rtcx= 0.5;
    rtcy= 0.5*screenratio;


    free (buf);
    free (rtex);
    checkGLStatus ();
    DoingRotate = 1;
    scrtrw=glscreenw/(double)rsw;
    scrtrh=glscreenh/(double)rsh;
}

void GLStopRotate ()
{
    glDeleteTextures (1, &screentex);
    DoingRotate = 0;
    DrawScreen = 1;
    SetDrawMode(-1);
}

#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif

void DrawTex (GLuint tex,
	      double x1, double y1,
	      double x2, double y2,
	      double x3, double y3,
	      double x4, double y4,
	      double tcleft, double tcright, double tctop, double tcbot)
{
    BindTex( tex);
    glBegin (GL_QUADS);
    glTexCoord2f (tcleft, tctop);
    glVertex2f (x1, y1);
    glTexCoord2f (tcright, tctop);
    glVertex2f (x2, y2);
    glTexCoord2f (tcright, tcbot);
    glVertex2f (x3, y3);
    glTexCoord2f (tcleft, tcbot);
    glVertex2f (x4, y4);
    glEnd ();
}

void GLRotateScreen (int cx, int cy, int angle, int scale)
{
    glDepthMask (1);
    glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);




    double rscale = 2048.0 / scale;
    double rangle = angle / 1024.0 * M_PI;
    double rcx = (cx / 320.0);
    double rcy = (cy / 200.0) * screenratio;

    double sina = sin (rangle);
    double cosa = cos (rangle);


    glDisable	(GL_POLYGON_SMOOTH);
    glDisable    (GL_ALPHA_TEST);
    glDisable    (GL_CULL_FACE);
    glDepthMask (0);

    glDisable (GL_FOG);
    glDisable (GL_BLEND);
    glEnable (GL_TEXTURE_2D);
    glDisable (GL_DEPTH_TEST);
    //glTexEnvf (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
    glMatrixMode (GL_PROJECTION);
    glLoadIdentity ();
    gluOrtho2D (0.0, 1.0, screenratio, 0.0);
    glMatrixMode (GL_MODELVIEW);
    glLoadIdentity ();
    glColor3f(1,1,1);

    double xtl = rcx + (cosa * -rtcx + sina * -rtcy) * rscale;
    double ytl = rcy + (-sina * -rtcx + cosa * -rtcy) * rscale;


    double xtr = rcx + (cosa * rtcx + sina * -rtcy) * rscale;
    double ytr = rcy + (-sina * rtcx + cosa * -rtcy) * rscale;

    double xbl = rcx + (cosa * -rtcx + sina * rtcy) * rscale;
    double ybl = rcy + (-sina * -rtcx + cosa * rtcy) * rscale;

    double xbr = rcx + (cosa * rtcx + sina * rtcy) * rscale;
    double ybr = rcy + (-sina * rtcx + cosa * rtcy) * rscale;

    BindTex(screentex);

    glBegin(GL_QUADS);
    glTexCoord2f(0,0);
    glVertex2f(xtl,ytl);

    glTexCoord2f(scrtrw,0);
    glVertex2f(xtr,ytr);

    glTexCoord2f(scrtrw,scrtrh);
    glVertex2f(xbr,ybr);

    glTexCoord2f(0,scrtrh);
    glVertex2f(xbl,ybl);
    glEnd();

    /*

    //glEnable(GL_POLYGON_SMOOTH);

#define etl subtexleft
#define etr subtexright
#define ett subtextop
#define etb subtexbot

#define ietl csubtexleft
#define ietr csubtexright
#define iett csubtextop
#define ietb csubtexbot

#define ctl csubtexleft
#define ctr csubtexright
#define ctt csubtextop
#define ctb csubtexbot

#define ictl subtexleft
#define ictr subtexright
#define ictt subtextop
#define ictb subtexbot

#define xc rcx
#define yc rcy

#define DOTEX(ix,c1,c2,c3,c4,vlr,vtb) DrawTex(screentex[ix],x##c1,y##c1,x##c2,y##c2,x##c3,y##c3,x##c4,y##c4,vlr##tl,i##vlr##tr,vtb##tt,i##vtb##tb)


    DOTEX (0, tl, t, c, l, e, e);
    DOTEX (1, t, tr, r, c, c, e);
    DOTEX (2, l, c, b, bl, e, c);
    DOTEX (3, c, r, br, b, c, c);*/

    //glTexEnvf (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
    SDL_GL_SwapBuffers ();
    //glDisable(GL_POLYGON_SMOOTH);
}




#endif /* USE_OPENGL */







extern char szDbgName[];



void WriteDebug (char *error, int i,...)
{
   char msgbuf[300];
	
    FILE *stream = fopen(szDbgName, "a+");
	if ((i>0)||(i<0)){
		sprintf(msgbuf,"%s %d\n",error,i);
	}else{
		sprintf(msgbuf,"%s \n",error);
	}
	fprintf(stream,msgbuf);
    fclose(stream);

}





//bna added function
//sometimes the proper lumps couldnt get loaded
//so we make this to make sure we dont exit game
//and we hope the right lumps will get loaded later.

Uint8 *GL_W_CacheLumpNum (int lump, int tag, converter_t converter, int numrec)
{
    if (lump >= (int)numlumps){
        return 0;
    }else if (lump < 0)
        return 0;

    if (!lumpcache[lump]) {
    	// read the lump in
    	Z_Malloc (W_LumpLength (lump), tag, &lumpcache[lump]);
    	W_ReadLump (lump, lumpcache[lump]);
    	converter (lumpcache[lump], numrec);
    } else {
    	Z_ChangeTag (lumpcache[lump], tag);
    }
    return (Uint8*)lumpcache[lump];
}





//bna added
int LoadExtImgToTexture (const char *fname, int repeat, int mipmaps, int *w, int *h)
{
    char buf[255];
    GLuint ret;
	SDL_Surface *tmp;

	lstrcpy(buf,fname);//check first current directory for file
	if (access (buf, 0) != 0) {
		sprintf(buf,"%s\\%s",GLPath,fname);//take default gl folder
	}
    tmp = IMG_Load (buf);
	if (!tmp) {
		sprintf(buf,"Error in File or File not found in %s",fname);
		WriteDebug(buf,0);
		return -1;
	}
	*w = tmp->w;
	*h = tmp->h;

    glGenTextures (1, &ret);
    UploadSurfaceToTexture (ret, tmp, repeat, mipmaps, NULL, NULL);
    SDL_FreeSurface (tmp);

    return ret;
}




