/*
Copyright (C) 2003-2004 Jared Stafford
Copyright (C) 1994-1995 Apogee Software, Ltd.
Copyright (C) 2001-2003 Jan Lönnberg
Copyright (C) 2001-2009 Birger N. Andreasen
 
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

/*
  Some of the OpenGL code is from LAB3D-SDL by Jan Lönnberg.
 */
#define DIRECTINPUT_VERSION 0x0800

#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <cguid.h>
#include <ddraw.h>
#include <dinput.h>
#include <dmusicc.h>
#include <dmusici.h>
#include <dshow.h>
#pragma warning( disable : 4244 )  // Disable warning messages
#pragma warning( disable : 4305 )  // Disable warning messages
#pragma warning( disable : 26451 )  // Disable warning messages
#pragma warning( disable : 26812 )  // Disable warning messages
#include "resource.h"

#define BGBYTE 1
#define KEEP_SKYS 0


#ifndef GL_CLAMP_TO_EDGE
  #define GL_CLAMP_TO_EDGE 0x812F
#endif
 

#ifdef USE_OPENGL

//#define _GNU_SOURCE 1 // necessary for fmemopen



void FindDiv8Size(int iWidth,int iHeight,int *Div8W,int *Div8H);
LPSTR CheckForExtGFX(int globallump);

extern IMediaSeeking   *g_pMediaSeeking;
extern IMediaControl   *g_pMediaControl;
extern LONGLONG lG;
void GLDrawSky (void);

unsigned char g_keycol = 0;

//bna++148
int iSpecELEV3  = -1;
int iSpecELEV4  = -1;
int iSpecELEV5  = -1;
int iSpecELEV6  = -1;
int iSpecELEV7  = -1;
int iSpecELEV8  = -1;
int iSpecWALL11 = -1;
int iSpecWALL12 = -1;
int iSpechswtch13 = -1;

extern "C"{


extern HBITMAP hBmpsun;	      
extern BITMAP  bmsun;
extern 	BOOL modemgame;
extern 	BOOL networkgame;

extern byte* HEAP_getheapmem(int size);
extern BOOL  HEAP_freemem(LPVOID lpMem);

extern int iPulsPushwalls ;
extern int  ExtDrawPrecache();
extern double GetMaskedWallDir (int x, int y);
extern void GetLumpName (char *line, char *name, int bufsize);

extern 	BOOL AddToInfoWindow(LPSTR InfoTxt, int color) ;
byte *CreateOldSky(int w, int h);

char g_alpha_totalonoff = 1;//bna++156

double g_explo_alpha = 0.6;//bna++148
double g_organ_alpha = 0.6;//bna++148
double g_firej_alpha = 0.6;//bna++148
double g_lifei_alpha = 0.8;//bna++148
double g_bullet_alpha = 0.6;//bna++148

extern short modelplayerangle;
extern char DemoPlayername[64];
extern char DemoRtlFile[256];
extern BOOL demoplayback;
extern void ExitWinRott();

void GLDeleteSave();
extern void ErrorDontQuit (char *error, int i,...);
double ShakeValY = 0;
double ShakeValX = 0;

void GL_ShakeScreen();
extern void AddTopLevelMessage(int x, int y, char *msg);
char GlutErrorMsg[256] = "";
DWORD GlutErrorMsgTckCnt = 0;
float GlutErrorTxtColor = 0;
float GlutErrorTxtAlpha = 0.5;

extern 	boolean US_LineInput (int x, int y, char *buf, const char *def, boolean escok,
		      int maxchars, int maxwidth, int color);
extern 	void UpdateClientControls ( void );
extern 	void StartupClientControls ( void );

extern 	void VW_UpdateScreen (void);
void putmsg(int x, int y, char *string, int size, int color, float alpha);
extern long LoadResourceToFixedMem (LPSTR Type ,int sndnb, void **bufferptr);

void US_BufPrint (const char *string);
void PositionMenuBuf (int angle, int distance, boolean drawbackground);

int HI_ReadBmpEx (LPSTR file, byte * dest, int *iWidth, int *iHeight);
#include <errno.h>
#include "rt_def.h" // for defn. of types
#include "glfuncs.h"
#include "engine.h"
#include "rt_view.h" // for color maps, defn. of fulllight
#include "rt_floor.h" // for defn. of sky
#include "rt_door.h" // for masked walls
#include "rt_scale.h" // for transparentlevel
#include "rt_playr.h" // for defn. of actor types, MISCVARS
#include "rt_stat.h" // for static actors
#include "rt_menu.h" // for defn. of inmenu
#include "w_wad.h"
#include "isr.h"		// for definition of VBLCOUNTER
#include "rt_util.h" // for defn. of Error
#include "rt_main.h" // for defn. of pheight
#include "z_zone.h" // for defn. of PU_CACHE and Z_Free
#include "lumpy.h"
#include "rt_msg.h"
#include "watcher.h"
#include "SDL.h"
#include "SDL_image.h"
#include <math.h>
#include "viewport.h"
#include "develop.h"
#include "_w_wad.h"


 
void GLRGADchangeCol (unsigned char *sbuf);
void SetSkyPlayerPos();
GLfloat skyyrot;
GLfloat skytiltangle;
extern "C" {

	extern BOOL  bAbovemaskwall2;
	extern BOOL  bAbovewall2;
	extern BOOL  bDoors2;
	extern BOOL  bElevators2;
	extern BOOL  bExits2;
	extern BOOL  bFloor_Ceilings2;
	extern BOOL  bGuns2;
	extern BOOL  bHswicthes2;
	extern BOOL  bMasked2;
	extern BOOL  bMish2;
	extern BOOL  bShapes2;
	extern BOOL  bSides2;
	extern BOOL  bWalls2;

	extern int viewsize;
	extern BOOL isonlist (int lmp);
	extern void GL_FreeRailings();
	extern HWND hWndInfo;
	extern short skyplayerangle;
	extern short skywangle;
	extern unsigned char cUseSavegameSoften;
	Uint32 *convert_bmp8colpicto32col (Uint8* inpic, int len, int w, int h);
	Uint32* ScaleImage(Uint32* in, int sw, int sh, int nw, int nh);
	int GLWriteOldgameSaveGameScreen(const char* name);
	int GLWriteSoftnedSaveGameScreen(const char* name);
	Uint32 * HI_ReadBmp (LPCSTR file, int *iWidth, int *iHeight);
	void *gl_malloc (size_t size);
	void *gl_remalloc (void *p, size_t size);
	void gl_free (void* p);
	extern unsigned int CalcAverageCol32(unsigned int *pic,  int width);
}


void GetPNGname(char *filename, char*pngname);
void GetBMPname(char *filename, char*bmpname);
void initDirLight();
void initPosLight();
     void updateSpot();
	 void initSpot();
extern HINSTANCE	hInst;
Uint8* GetColorMap(int color) ;
extern HWND hMainWnd;
extern void WriteLBtext(LPSTR txt);
extern char     GFX_PathWalls[256];
extern char     GFX_Path[256];
extern char     GFX_PathWalls[256];
extern char     GFX_PathFloor_Ceil[256];
extern char     GFX_PathShape[256];
extern char     GFX_PathGuns[256];
extern char     GFX_PathDoors[256];
extern char     GFX_PathSides[256];
extern char     GFX_PathElevators[256];
extern char     GFX_PathMasked[256];
extern char     GFX_PathExits[256];
extern char     GFX_PathABVWSTRT[256];
extern char     GFX_PathABVMSTRT[256];
extern char     GFX_PathHMSKSTRT[256];
extern char     GFX_PathMish[256];
extern char     GFX_Anim[256];



extern int GFX_animstart ,    GFX_animstop ;
extern int GFX_wallstart ,    GFX_wallstop ;
extern int GFX_floorstart ,   GFX_floorstop ;
extern int GFX_shapestart ,   GFX_shapestop ;
extern int GFX_gunsstart ,    GFX_gunsstop ;
extern int GFX_doorstart ,    GFX_doorstop ;
extern int GFX_sidestart ,    GFX_sidestop ;
extern int GFX_elevatorstart ,GFX_elevatorstop ;
extern int GFX_exitstart ,    GFX_exitstop ;
extern int GFX_maskedstart ,  GFX_maskedstop ;
extern int GFX_maskedBotLimit,  GFX_maskedTopLimit;
extern int GFX_maskedExclude;
extern int GFX_abovewallstart ,GFX_abovewallstop ;
extern int GFX_abovemaskwallstart ,GFX_abovemaskwallstop ;
extern int GFX_himaskstart ,  GFX_himaskstop ;
extern int GFX_titlestart ,   GFX_titlestop ;
extern int GFX_ap_world ,     GFX_ap_titl ;
extern int GFX_trilogo ;


extern BOOL SaveBMP ( void* Buffer, int width, int height,long Buffersize, char* bmpfile,char nbbits );
extern unsigned char makecol(int r, int g, int b);
extern int BlurPicBuf( byte * source, int iWidth, int iHeight,int glump);
extern void GetPCXlumpname(char* p, char *pfolder, int lump);
void WriteBmpEx(char* filename ,byte *src,int picw ,int pich ,int scale, int paltype, BOOL rotate );



extern int compat;
extern int gltexmode;

extern int iG_aimCross;
extern int IsCrosshairLoaded;
extern char	szDbgName[];
extern int bordercolor;
extern double g_wscale;
extern UINT *glsavedscreen;
extern int weaponlump;
extern boolean bUseExternalGFX;

extern int CalcRotate (objtype * ob);
extern BOOL CH_LoadCrosshair();
extern int MD2refresh (int id ,char *name,double x,double y,double z,double angle);
extern int StatRotate (statobj_t * stat);
extern void CH_DrawCrosshair(unsigned char* s);
extern void InitMD2 ();
extern void InitMD3 ();
extern void print_stack (int);
extern void GLSkyInit (void);
extern int LoadModelTexture (const char *fname, int repeat, int mipmaps, int *w, int *h);

extern int LoadExtImgToTexture (const char *path_buffer, int repeat, int mipmaps, int *w, int *h);
extern void STM ();
extern void	WriteLBtext(LPSTR txt);

extern PALETTEENTRY rPal[768];  
extern BOOL MenuBufStarted;
//extern BOOL CheckExternalGFX(void *mem, int lump,  lumpinfo_t *l);

extern void *testmasked(int lump);
int globallump;
extern int GFX_wallstart;
extern void PrepareGFX ();

extern boolean bUseExtPrecache;
extern boolean  bUseExtWallSFX;
}






//#define PNG_SAVE
#ifdef PNG_SAVE
#include <png.h>
#endif 

#if (USERAINCODE == 1)
	extern "C" {
		#include "rain.h"
		extern void GLInitRain(RAIN *rain);
		extern void GLDrawRain(RAIN *rain);
		extern void SetRainPlayerPos(RAIN *rain);
		extern void GLInitRain(RAIN *rain);
		RAIN rain;
		extern BOOL useRain;
		BOOL bIsRainInit;
	}
#endif



Uint8 *GL_W_CacheLumpNum (int lump, int tag, converter_t converter, int numrec);

extern void GLDrawCrosshair (void);
extern BOOL CH_LoadCrosshair();
extern void CH_DrawCrosshair(unsigned char* s);

char szAppPath[512];

extern BOOL IsCrosshairLoaded;
extern boolean ingame;
extern boolean inmenu;
extern boolean demorecord, demoplayback;
extern int iG_aimCross;
extern boolean inautomap;

double CheckForExtraAlpha(int lump);

int iTP1SHAPENB = 0;
			



#define TRANSPARENTCOLOR32 0xFFFF00FF
#define TRANSLEVELCOLOR32  0xFF000000//translevel color

#define LM_NONE 0
#define LM_ARRAY 1
#define LM_GL 2

#define YCORRECTFACT (240.0/200.0)

//#define LIGHTMETHOD LM_ARRAY

#define EPSILON 0.0000001

//#if (LIGHTMETHOD==LM_ARRAY)
#define LIGHTRAD 32
#define LIGHTOFS ((LIGHTRAD/2)-1)
double lightamt[256][256];
double stdlight[1024];
//double stdlights[16][1024];
double ambientlight;
double InterpolateLight (double x, double y);
//#endif
#define NORMALFOGSTART 1024
#define NORMALFOGEND (1024*64)

//#define NORMALFOGSTART 1024/16
//#define NORMALFOGEND (1024*8)

#define NOFOGSTART (NORMALFOGSTART*4.0)
#define NOFOGEND (NORMALFOGEND*4.0)

#define GASFOGSTART (NORMALFOGSTART/24.0)
#define GASFOGEND (NORMALFOGEND/8.0)

#if SDL_BYTE_ORDER==SDL_LITTLE_ENDIAN
    #define RED_SHIFT 0
    #define GREEN_SHIFT 8
    #define BLUE_SHIFT 16
    #define ALPHA_SHIFT 24
    #define REDCMP(X) ((X)&255)
    #define GREENCMP(X) (((X)>>8)&255)
    #define BLUECMP(X) (((X)>>16)&255)
    #define ALPHACMP(X) (((X)>>24)&255)
#else
    #define RED_SHIFT 24
    #define GREEN_SHIFT 16
    #define BLUE_SHIFT 8
    #define ALPHA_SHIFT 0
    #define REDCMP(X) (((X)>>24)&255)
    #define GREENCMP(X) (((X)>>16)&255)
    #define BLUECMP(X) (((X)>>8)&255)
    #define ALPHACMP(X) ((X)&255)
#endif

typedef struct {
    int flags;
    int x, y;
    int rtx, rty;
    double rot;
    double scale;
    void (*draw)(void* data);
    void (*free)(void* data);
    void* data;
} gl2DObject;


static gl2DObject twodobjects[128];
static int n2dobjects=0;

typedef struct {
    double x, y, z;
} m_vertex;

typedef struct {
    double r, g, b;
} m_color;

typedef struct {
    double x, y;
} m_texcoord;

enum { ST_QUAD=0, ST_QUADSTRIP, ST_TRI, ST_TRISTRIP, ST_TRIFAN, ST_POLY, ST_LAST };

static GLuint shape_types[ST_LAST] = { GL_QUADS, GL_QUAD_STRIP, GL_TRIANGLES,
				       GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN,
				       GL_POLYGON };

#define NUMQUAL 4

static double qualdist[NUMQUAL] = { 65536.0*16, 65536.0*8,  65536.0*4, 0.0  };


#if 0
typedef struct {
    GLuint tex;
    unsigned char flags;
    unsigned char type;
    unsigned short nverts;
    m_vertex normal;
    m_vertex* verts;
    m_color* colors;
    m_texcoord* texcoords;
} m_shape;

typedef struct {
    short int nshapes;
    m_shape* shapes;
} shape_list;

typedef struct {
    const char* name;
    unsigned char flags;
    shape_list shapes[NUMQUAL];
} model;
#endif

typedef struct {
    const char* name;
    GLuint tex;
} skintex;

typedef struct {
    GLuint tex;
    unsigned char flags;
    unsigned char type;
    unsigned int vertindex;
    unsigned short nverts;
} shape;


typedef struct {
    short int nshapes;
    short int nverts;
    m_vertex* vertlist;
    m_texcoord* texcoords;
    shape* shapes;
} shape_list;

typedef struct {
    char* name;
    unsigned char flags;
    double px,py,pz;
    shape_list shapes[NUMQUAL];
} model;


typedef struct {
    GLuint tex;
    double tcxl[256];
    double tcxh[256];
    double tcyl[16];
    double tcyh[16];
} glfont_t;

static GLuint lasttex=0;

__inline void BindTex(GLuint tex) {
    if (tex!=lasttex) {
	lasttex=tex;
	glBindTexture(GL_TEXTURE_2D,tex);
    }
}

// Model flags
#define MOD_ROTATE 1
#define MOD_VERTROTATE 2

// Shape flags
#define SHAPE_TWOSIDE 1
#define SHAPE_FLOORSTENCIL 2


static skintex* skins;
static int nskins=0;
static model** models;
static int nmodels=0;


static double fognear, fogfar;

static double vwx, vwy, vwz;

#define ONETEX

#ifdef ONETEX
GLuint screenbuffertexture;
#else
GLuint screenbuffertextures[48];	/* 48 small textures. */
#endif
int screenbufferwidth = 0;
int screenbufferheight = 0;
int screenfullwidth = 0;
int screenfullheight = 0;
static GLint fullfilter = GL_LINEAR_MIPMAP_LINEAR;
static int partialfilter = GL_LINEAR;
static int screenwidth = 0;
static int screenheight = 0;
int lookangle;
int glscreenw;
int glscreenh;
unsigned char *screenbuffer;
#ifdef NO_INDEXED_COLOR
unsigned char *screenbuffer32=NULL;
unsigned char ipalr[256],ipalg[256],ipalb[256];
#endif
unsigned char savegamescreen[16000];

extern unsigned short  SHAKETICS;
extern boolean    GamePaused;

static double screenratio;
//unsigned char* 
#if (KEEP_SKYS == 1)
  int skytex[6][6];
#else
  int skytex[6];
  int lastsky=-1;
#endif

static int minfilters[]={GL_NEAREST, GL_LINEAR, 
			 GL_NEAREST_MIPMAP_NEAREST, GL_NEAREST_MIPMAP_LINEAR, 
			 GL_LINEAR_MIPMAP_NEAREST, GL_LINEAR_MIPMAP_LINEAR };

static int magfilters[]={GL_NEAREST, GL_LINEAR, 
			 GL_NEAREST, GL_NEAREST, 
			 GL_LINEAR, GL_LINEAR };


int compat=0;

#define NO_CATWALK (compat&1)
#define NO_MODELS (compat&2)
#define OLD_LOOKMODE (compat&4)
#define NO_FATBLOCK (compat&8)
#define NO_FLOORDEPTH (compat&16)

void GLDrawCacheLEDS (int cx, int cy, int angle, int scale);

static int catwalk[17];

static int catbits[4][3] = {
    { 1, 3, 0 },
    { 1, 4, 2 },
    { 6, 3, 5 },
    { 6, 4, 7 }};

static int floortex;
static int ceilingtex;

static int brightness, lightrate;

static Uint32 shroomlast;

typedef struct {
    double hue;
    double r,g,b;
} shroomrec;

static shroomrec shrooms[32];

static double fadered, fadeblue, fadegreen, fadealpha=0.0;

static int DoingRotate = 0;
static int DrawScreen = 1;
static int UploadScreen = 1;
int gltexmode = -1;
extern "C"{
	int glsharpentex = 1;//we use gfx sharpen as default.
}
static int OverlayStretch= 0;

static double OverlayZoom=1.0;

char* GLPath;

#define skh 1024
#define skl -1024

#define sklbd { (GLuint)skl,(GLuint) skl,(GLuint) skl }
#define sklbu { (GLuint)skl, (GLuint)skl,(GLuint) skh }
#define sklfd { (GLuint)skl, (GLuint)skh,(GLuint) skl }
#define sklfu  {(GLuint) skl, (GLuint)skh,(GLuint) skh }
#define skrbd  { (GLuint)skh, (GLuint)skl,(GLuint) skl }
#define skrbu  { (GLuint)skh, (GLuint)skl,(GLuint) skh }
#define skrfd  {(GLuint) skh,(GLuint) skh,(GLuint) skl }
#define skrfu  {(GLuint) skh, (GLuint)skh, (GLuint)skh }

static int hswitch6=0;

static int _is=0; 							
static int _tile;
int IS_TOP_CATWALK(int x,int y);
int IS_TOP_CATWALK(int x,int y)
{
	_is=0;
	_tile=tilemap[x][y];
	if (_tile&0x8000 && (_tile&0x4000)) {			
		if (maskobjlist[_tile&0x3ff]->toptexture == hswitch6) 	
			_is=1; 		
	}
    _is;return _is;
}
/*
#define IS_TOP_CATWALK(x,y) 					\
({ 								\
    int _is=0; 							\
    int _tile=tilemap[x][y]; 					\
    if (_tile&0x8000 && (_tile&0x4000)) 			\
	if (maskobjlist[_tile&0x3ff]->toptexture == hswitch6) 	\
	    _is=1; 						\
    _is; 							\
})
*/
#define MAKEBUF(sname,size,fmt1,fmt2) {char sname[size]; sprintf(sname,size,fmt1,fmt2);}


/*
#define MAKEBUF(name,size,fmt, ...); \ 
     char name[size]; \
		 snprintf(name,size,fmt, ## __VA_ARGS__);
*/
static GLuint skywind[6][4][3] = {  
    {sklfu, skrfu, skrfd, sklfd},
    {skrfu, skrbu, skrbd, skrfd},
    {skrbu, sklbu, sklbd, skrbd},
    {sklbu, sklfu, sklfd, sklbd},
    {sklbu, skrbu, skrfu, sklfu},
    {sklfd, skrfd, skrbd, sklbd}
};

static GLdouble skytexwind[4][2] = {
    {0.0, 0.0},
    {1.0, 0.0},
    {1.0, 1.0},
    {0.0, 1.0}};

typedef struct {
    unsigned char type;
    unsigned short flags;
    int tex;
    double dist;
    double x, y, z;
    double ang,vang;
    union {
	struct {
	    int btex;
	    int ttex;
	} maskwall;
	struct {
	    unsigned short cmap;
		int id;//bna++ 1.78
	} sprite;
	struct {
	    int id;
	    model* mod;
	} mod;
    };
} glvisobj;

//#define PACKED 4
 
//#pragma pack(PACKED)//size = 96

#pragma pack(push,4)

typedef struct {//__attribute__((packed)) {
    __int32 type;
    union {
		#pragma pack(push,8)
		struct {
			GLuint texnum[MAXPLAYERCOLORS+1];
			unsigned __int16 w, h;//short
			__int16 lofs, tofs;//short
			__int16 osize;//short 
			double tcxl, tcyl;
			double tcxh, tcyh;
		} tex;
		#pragma pack(pop) 
		model* mod;
		struct {
			glfont_t* fptr;
		} font;
    };
} gl_lumpinfo_t;
#pragma pack(pop) 

enum { LT_UNKNOWN=0, LT_TEXTURE, LT_FONT, LT_MODEL };

#pragma pack(push,1)
typedef struct {//__attribute__((packed)) {
    unsigned __int16 transused, trans[4];
    unsigned __int32 * pal;
    byte colorsused[MAXPLAYERCOLORS];
}texauxinfo_t;
#pragma pack(pop)

#pragma pack(push,2)//size = 28
typedef struct {//__attribute__((packed)) {
    unsigned __int16 w, h;
    unsigned __int16 rw, rh;
    __int16 lofs, tofs;
    __int16 osize;
    unsigned __int32 rep;
} texbufinfo_t;
#pragma pack(pop) 


static gl_lumpinfo_t invalid; //unknown texture type
static gl_lumpinfo_t* lumpinfo;
static gl_lumpinfo_t* lumpkeyinfo;

static texauxinfo_t *texauxinfo;
static Uint32 gampal[256];
static Uint32 apogeepal[256];

enum {
    GLV_SPRITE,
    GLV_MASKED,
    GLV_BLOCKMASK,
    GLV_MODEL,
    GLV_CATWALK,
    // the rest are used for settings only
    GLV_WALL, 
    GLV_PUSHWALL,
    GLV_SKY,
    GLV_FLOORCEIL,
    GLV_BORDER,
    GLV_2DOBJECTS,
    GLV_OVERLAY,
    GLV_FADE,
    GLV_RAIN    
};




static unsigned int visprio[] = { 0, 0, 1, 2, 3 };

// Sprite flags (type==GLV_SPRITE)
#define GLV_TRANSFADE 1
#define GLV_SHROOMFLASH 2
#define GLV_REDFLASH 4
#define GLV_FULLLIGHT 8

#define GLV_KEYCOLOR1 16
#define GLV_KEYCOLOR2 32
#define GLV_KEYCOLOR3 64
#define GLV_KEYCOLOR4 128

#define GLV_COLORED 256

#define GLV_PLAYEROBJ 256




// Masked wall flags
#define GLV_VERTICAL 1

glvisobj visobjects[2048];
int nvisobjects = -1;
double onediv[256];

static int curdrawmode=-1;




extern void WriteDebug (char *error, int i,...);




int powerof2 (int in)
{
    int i = 0;
    in--;
    while (in) {
	in >>= 1;
	i++;
    }
    return 1 << i;
}

void SetDrawMode(int dm) {
    if (dm!=curdrawmode) {
	curdrawmode=dm;
	//printf("Switching to %d\n",dm);
	switch (dm) {
	case GLV_MODEL:
	    glDisable	(GL_POLYGON_SMOOTH);
	    glEnable    (GL_TEXTURE_2D);
	    glDisable   (GL_BLEND);
	    glEnable    (GL_ALPHA_TEST);
	    glEnable    (GL_CULL_FACE);
	    glEnable    (GL_DEPTH_TEST);

	    glDisable   (GL_STENCIL_TEST);
	    glCullFace  (GL_BACK);
	    glFrontFace (GL_CCW);
	    glDepthMask (1);
	    break;
	case GLV_SPRITE:
	    glDisable	(GL_POLYGON_SMOOTH);
	    glEnable    (GL_TEXTURE_2D);
	    glEnable    (GL_BLEND);
	    glDisable   (GL_ALPHA_TEST);
	    glDisable   (GL_CULL_FACE);
	    glEnable    (GL_DEPTH_TEST);
	    glDisable   (GL_STENCIL_TEST);
	    glDepthMask (0);
 	    break;
	case GLV_MASKED:
	    glDisable	(GL_POLYGON_SMOOTH);
	    glEnable    (GL_TEXTURE_2D);
	    glEnable    (GL_BLEND);
	    glDisable   (GL_ALPHA_TEST);
	    glDisable   (GL_CULL_FACE);
	    glEnable    (GL_DEPTH_TEST);
	    glDisable   (GL_STENCIL_TEST);
	    glDepthMask (0);
 	    break;
	case GLV_BLOCKMASK:
	    glDisable	(GL_POLYGON_SMOOTH);
	    glEnable    (GL_TEXTURE_2D);
	    glDisable   (GL_BLEND);
	    glDisable   (GL_ALPHA_TEST);
	    glEnable    (GL_CULL_FACE);
	    glEnable    (GL_DEPTH_TEST);
	    glFrontFace (GL_CW);
	    glDisable   (GL_STENCIL_TEST);
	    glDepthMask (1);
 	    break;
	case GLV_CATWALK:
	    glEnable    (GL_TEXTURE_2D);
	    glDisable	(GL_POLYGON_SMOOTH);
	    glDisable   (GL_BLEND);
	    glEnable    (GL_ALPHA_TEST);
	    glDisable   (GL_CULL_FACE);
	    glEnable    (GL_DEPTH_TEST);
	    glDisable   (GL_STENCIL_TEST);
	    glDepthMask (1);
 	    break;
	case GLV_WALL:
	    glDisable	(GL_POLYGON_SMOOTH);
	    glEnable    (GL_TEXTURE_2D);
	    glDisable   (GL_BLEND);
	    glDisable   (GL_ALPHA_TEST);
	    glDisable   (GL_CULL_FACE);
	    glEnable    (GL_DEPTH_TEST);
	    glDisable   (GL_STENCIL_TEST);
	    glDepthMask (1);
 	    break;
	case GLV_FLOORCEIL:
	    glDisable	(GL_POLYGON_SMOOTH);
	    glEnable    (GL_TEXTURE_2D);
	    glDisable   (GL_BLEND);
	    glDisable   (GL_ALPHA_TEST);
	    glDisable   (GL_CULL_FACE);
	    glEnable    (GL_DEPTH_TEST);
	    glEnable    (GL_STENCIL_TEST);
	    glDepthMask (1);
 	    break;
	case GLV_PUSHWALL:
	    glDisable	(GL_POLYGON_SMOOTH);
	    glEnable    (GL_TEXTURE_2D);
	    glDisable   (GL_BLEND);
	    glDisable   (GL_ALPHA_TEST);
	    glEnable    (GL_CULL_FACE);
	    glEnable    (GL_DEPTH_TEST);
	    glDisable   (GL_STENCIL_TEST);
	    glFrontFace (GL_CW);
	    glDepthMask (1);
 	    break;
	case GLV_SKY:
	    glDisable	(GL_POLYGON_SMOOTH);
	    glEnable    (GL_TEXTURE_2D);
	    glDisable   (GL_BLEND);
	    glDisable   (GL_ALPHA_TEST);
	    glDisable   (GL_DEPTH_TEST);
	    glDisable   (GL_FOG);
	    glDisable   (GL_STENCIL_TEST);
	    glDepthMask (0);
 	    break;
	case GLV_OVERLAY:
	    glDisable	(GL_POLYGON_SMOOTH);
	    glEnable    (GL_TEXTURE_2D);
	    glDisable   (GL_CULL_FACE);
	    glDisable   (GL_BLEND);
	    glEnable    (GL_ALPHA_TEST);
	    glDisable   (GL_DEPTH_TEST);
	    glDisable   (GL_FOG);
	    glDisable   (GL_STENCIL_TEST);
	    glDepthMask (0);
	    break;
	case GLV_BORDER:
	    glDisable	(GL_POLYGON_SMOOTH);
	    glDisable (GL_TEXTURE_2D);
	    glEnable  (GL_BLEND);
	    glDisable (GL_ALPHA_TEST);
	    glDisable (GL_FOG);
	    glDisable (GL_DEPTH_TEST);
	    glDisable   (GL_STENCIL_TEST);
	    glDepthMask (0);
     	    break;
	case GLV_2DOBJECTS:
	    glDisable	(GL_POLYGON_SMOOTH);
	    glDisable (GL_FOG);
	    glDisable (GL_ALPHA_TEST);
	    glEnable  (GL_BLEND);
	    glEnable  (GL_TEXTURE_2D);
	    glDisable (GL_DEPTH_TEST);
	    glDisable (GL_CULL_FACE);
	    glDisable   (GL_STENCIL_TEST);
	    break;
	case GLV_FADE:
	    glDisable	(GL_POLYGON_SMOOTH);
	    glDisable (GL_FOG);
	    glEnable  (GL_BLEND);
	    glDisable (GL_TEXTURE_2D);
	    glDisable (GL_ALPHA_TEST);
	    glDisable (GL_DEPTH_TEST);
	    glDisable   (GL_STENCIL_TEST);
	    break;
	case GLV_RAIN:
		glShadeModel(GL_SMOOTH);
		glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);
	    glDisable (GL_ALPHA_TEST);
	    glEnable  (GL_BLEND);
	    glDisable (GL_DEPTH_TEST);
	    glDisable (GL_CULL_FACE);
	    glDisable (GL_STENCIL_TEST);
		glDepthFunc(GL_LESS);
	    glDisable (GL_TEXTURE_2D);
	    glDepthMask (0);
	    break;	    
	}
    }
}

void print_stack (int);

void GLError(int errCode) {
    const GLubyte *errString;
    errString = gluErrorString (errCode);
    fprintf (stderr, "OpenGL Error: %s\n", errString);
    WriteDebug((char*)errString,errCode);
    print_stack (1);
    SDL_Quit ();
    exit (1);
}
void checkGLStatus ()
{
    GLenum errCode;

    if ((errCode = glGetError ()) != GL_NO_ERROR) {
	     //GLError(errCode);//bna_removed
    }
}



void UploadPartialOverlayToTexture (int x, int y, int dx, int dy, int w,
				    int h, GLuint tex, int create)
{
    BindTex( tex);
    checkGLStatus ();

    glPixelStorei (GL_UNPACK_ROW_LENGTH, screenbufferwidth);
    glPixelStorei (GL_UNPACK_SKIP_PIXELS, x);
    glPixelStorei (GL_UNPACK_SKIP_ROWS, y);
    glPixelStorei (GL_UNPACK_ALIGNMENT, 1);
    checkGLStatus ();

    if (create) {
		glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
		glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
		glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, partialfilter);
		glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, partialfilter);
    }

#ifdef NO_INDEXED_COLOR

    
    if (create) {
		screenfullwidth=powerof2(w);
		screenfullheight=powerof2(h);
		ConvertPartialOverlay(0,0,screenbufferwidth,screenbufferheight);
		glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, screenfullwidth,
				screenfullheight, 0, GL_RGBA, GL_UNSIGNED_BYTE, NULL);
    } /*else {*/
		glTexSubImage2D (GL_TEXTURE_2D, 0, dx, dy, w, h,
				GL_RGBA, GL_UNSIGNED_BYTE, screenbuffer32);
    //}
    checkGLStatus ();
#else
    glPixelTransferi (GL_MAP_COLOR, GL_TRUE);

    if (create) {
	screenfullwidth=powerof2(w);
	screenfullheight=powerof2(h);
	glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA, screenfullwidth,
		      screenfullheight, 0, GL_COLOR_INDEX, GL_UNSIGNED_BYTE, NULL);
    } /*else {*/
    glTexSubImage2D (GL_TEXTURE_2D, 0, dx, dy, w, h,
		     GL_COLOR_INDEX, GL_UNSIGNED_BYTE, screenbuffer);
    //}
    checkGLStatus ();
    glPixelTransferi (GL_MAP_COLOR, GL_FALSE);
#endif

    glPixelStorei (GL_UNPACK_SKIP_PIXELS, 0);
    glPixelStorei (GL_UNPACK_SKIP_ROWS, 0);
    glPixelStorei (GL_UNPACK_ROW_LENGTH, 0);
}




#ifdef NO_INDEXED_COLOR
void ConvertPartialOverlay(int sx, int sy, int w, int h) {

    if (!screenbuffer32) {
	screenbuffer32 = (unsigned char*)gl_malloc(screenbufferwidth*screenbufferheight*4);
    }
    unsigned char *f=&screenbuffer[sx+screenbufferwidth*sy],*t=(unsigned char*)&screenbuffer32[sx+screenbufferwidth*sy];

    int x,y;
    int skip=screenbufferwidth-w;

    //printf("sx=%d, sy=%d, w=%d, h=%d, spos=%d skip=%d\n",sx,sy,w,h,sx+screenbufferwidth*sy,skip);
    for(y=0;y<h;y++,f+=skip,t+=(skip*4)) 
	for(x=0;x<w;x++) {
	    if ((*(f))==255) {
		*(t++)=0;		
		*(t++)=0;		
		*(t++)=0;		
		*(t++)=0;		
	    } else {
		*(t++)=ipalr[*f];
		*(t++)=ipalg[*f];
		*(t++)=ipalb[*f];
		*(t++)=255;
	    }
	    f++;
	}
    //TextureAvg32((Uint32*)to,64,64);

}
#endif


/* Upload rectangular part of overlay from memory to overlay texture... */


void UploadPartialOverlay (int x, int y, int w, int h)
{
#ifdef NO_INDEXED_COLOR
    ConvertPartialOverlay(x,y,w,h);
#endif
#ifdef ONETEX
    UploadPartialOverlayToTexture(x,y,x,y,w,(h>1)?h:2,
				  screenbuffertexture,0);
#else
    int left, right, top, bottom, i, j;
    int lr, rr, tr, br;

    left = (x - 2) / 62;
    if (left < 0)
	left = 0;
    right = (x + w - 1) / 62;
    if (right > 5)
	right = 5;
    top = (y - 2) / 62;
    if (top < 0)
	top = 0;
    bottom = (y + h - 1) / 62;
    if (bottom > 7)
	bottom = 7;

    for (i = top; i <= bottom; i++)
	for (j = left; j <= right; j++) {
	    lr = x - 62 * j;
	    rr = lr + w - 1;
	    tr = y - 62 * i;
	    br = tr + h - 1;

	    if (rr < 0)
		continue;
	    if (lr > 63)
		continue;
	    if (br < 0)
		continue;
	    if (tr > 63)
		continue;

	    if (lr < 0)
		lr = 0;
	    if (rr > 63)
		rr = 63;
	    if (tr < 0)
		tr = 0;
	    if (br > 63)
		br = 63;

	    UploadPartialOverlayToTexture (lr + 62 * j, tr + 62 * i, lr, tr,
					   rr - lr + 1, br - tr + 1,
					   screenbuffertextures[i * 6 + j],
					   0);
	}
#endif
    ShowPartialOverlay (x, y , w, h );
}

/* Upload entire overlay from memory to texture (creates textures)... */

void UploadOverlay (void)
{
 //   int i,j;
#ifdef ONETEX
    UploadPartialOverlayToTexture(0,0,0,0,screenbufferwidth,
				  screenbufferheight,
				  screenbuffertexture,1);
#else
    for (i = 0; i < 8; i++)
	for (j = 0; j < 6; j++)
	    UploadPartialOverlayToTexture (62 * j, 62 * i, 0, 0, 64, 64,
					   screenbuffertextures[i * 6 + j],
					   1);
#endif
}

/* Display rectangular part of overlay... */

void ShowPartialOverlay (int x, int y, int w, int h)
{

    float tx1, tx2, ty1, ty2;
 //   int i, j, tr, br, lr, rr, left, right, top, bottom;

    //if (mixing)
    SetDrawMode(GLV_OVERLAY);
    glTexEnvf (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);

    glMatrixMode (GL_PROJECTION);
    glLoadIdentity ();
    if (OverlayStretch) {
	gluOrtho2D (0, 320.0, 0.0, 200.0);
    } else {

	double bbsizeh=((0.75/screenratio)*320.0 - 320)/2.0;
	double bbsizev=((screenratio/0.75)*200.0 - 200)/2.0;
	double bbsize=bbsizev;

	double left, right, top, bot;

	if (bbsizeh>0) {
	    left=-bbsizeh;
	    right=320+bbsizeh;
	    top=0;
	    bot=200;
	} else {
	    left=0;
	    right=320;
	    top=-bbsizev;
	    bot=200+bbsizev;
	}
	if (OverlayZoom!=1.0) {
	    left=(left-160)*OverlayZoom+160;
	    right=(right-160)*OverlayZoom+160;
	    top=(top-100)*OverlayZoom+100;
	    bot=(bot-100)*OverlayZoom+100;
	}

	gluOrtho2D (left, right, top, bot);
    }
    glMatrixMode (GL_MODELVIEW);
    glLoadIdentity ();

#ifdef ONETEX
	tx1=((float)x)/(float)(screenfullwidth);
	tx2=((float)(x+w))/(float)screenfullwidth;
	
	ty1=((float)y)/(float)(screenfullheight);
	ty2=((float)(y+h))/(float)screenfullheight;
	
	//y-=visiblescreenyoffset;
	
	BindTex(screenbuffertexture);
	glBegin(GL_QUADS);
	glColor3f(1,1,1);
	glTexCoord2f(tx1,ty2);
	glVertex2s(x,200-y-h);
	glTexCoord2f(tx2,ty2);
	glVertex2s(x+w,200-y-h);
	glTexCoord2f(tx2,ty1);
	glVertex2s(x+w,200-y);
	glTexCoord2f(tx1,ty1);
	glVertex2s(x,200-y);
	glEnd();
#else

    left = (x - 1) / 62;
    if (left < 0)
	left = 0;
    right = (x + w - 2) / 62;
    if (right > 5)
	right = 5;
    top = (y - 1) / 62;
    if (top < 0)
	top = 0;
    bottom = (y + h - 2) / 62;
    if (bottom > 7)
	bottom = 7;

    //  printf("Drawing %d %d %d %d\n",x,y,w,h);

    for (i = top; i <= bottom; i++)
	for (j = left; j <= right; j++) {
	    lr = x - 62 * j;
	    rr = lr + w - 1;
	    tr = y - 62 * i;
	    br = tr + h - 1;

	    if (rr < (j > 0))
		continue;
	    if (lr > (63 - (j < 5)))
		continue;
	    if (br < (i > 0))
		continue;
	    if (tr > (63 - (i < 7)))
		continue;

	    if (lr < (j > 0))
		lr = (j > 0);
	    if (rr > (63 - (j < 5)))
		rr = 63 - (j < 5);
	    if (tr < (i > 0))
		tr = (i > 0);
	    if (br > (63 - (i < 7)))
		br = 63 - (i < 7);

//              fprintf(stderr,"%d %d %d %d %d %d\n",i,j,lr,tr,rr,br);

	    tx1 = ((float)lr) / 64.0;
	    tx2 = ((float)(rr + 1)) / 64.0;

	    ty1 = ((float)tr) / 64.0;
	    ty2 = ((float)(br + 1)) / 64.0;

	    BindTex( screenbuffertextures[i * 6 + j]);
	    glBegin (GL_QUADS);
	    //glColor4f (1.0, 1.0, 1.0, 1.0);
	    glTexCoord2f (tx1, ty2);
	    glVertex2s (lr + 62 * j, 200 - br - 1 - 62 * i);
	    glTexCoord2f (tx2, ty2);
	    glVertex2s (rr + 1 + 62 * j, 200 - br - 1 - 62 * i);
	    glTexCoord2f (tx2, ty1);
	    glVertex2s (rr + 1 + 62 * j, 200 - tr - 62 * i);
	    glTexCoord2f (tx1, ty1);
	    glVertex2s (lr + 62 * j, 200 - tr - 62 * i);
	    glEnd ();

	}
    glTexEnvf (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
#endif
    checkGLStatus ();
}



void GlGammaInitPalette (byte *pal);
byte glgammatable[256];


static void convertpal (Uint8 * pal, Uint32 * npal, int translevel)
{
    int i,r,g,b;
    unsigned int msk = (255 - translevel) << ALPHA_SHIFT;
//	long rgb;

	GlGammaInitPalette(pal);

    for (i = 0; i < 255; i++) {

		r = glgammatable[*(pal++)];
		rPal[i].peRed = r; 

		g = glgammatable[*(pal++)];
		rPal[i].peGreen = g; 

		b = glgammatable[*(pal++)];
		rPal[i].peBlue = b; 

		rPal[i].peFlags = 0; 

/*		r = *(pal++);
		g = *(pal++);
		b = *(pal++);
		rgb = RGB(r,g,b);
		r = GetRValue(rgb);
		g = GetGValue(rgb);
		b = GetBValue(rgb);
*/
		*(npal++) = msk | (r << RED_SHIFT) | (g << GREEN_SHIFT) | (b<<BLUE_SHIFT);
    }
    *npal=0;
}



//bna added function
void GlGammaInitPalette (byte *pal)
{
//    int		r,g,b;
    int		i;
	int		value;
	float	glgamma = (float)1.0;
				  
	//gammaindex goes from 0(normal) to 7(light) 
	//goes from 0.5 (very light) to 1.0 (normal)
	switch (gammaindex) 
	{
		case 0:
			glgamma = (float)1.0; 
			break;
	    case 1:
			glgamma = (float)0.9; 
			break;
	    case 2:
			glgamma = (float)0.8; 
			break;
	    case 3:
			glgamma = (float)0.75; 
			break;
	    case 4:
			glgamma = (float)0.7; 
			break;
	    case 5:
			glgamma = (float)0.65; 
			break;
	    case 6:
			glgamma = (float)0.6; 
			break;
	    case 7:
			glgamma = (float)0.5; 
			break;
	}

	if (glgamma == 1.0)	{
		for (i=0 ; i<256 ; i++)
			glgammatable[i] = i;
	}else{
		for (i=0 ; i<256 ; i++)
		{
			//value = 255 * pow ( (i+0.5)/255.5 , glgamma ) + 0.5;			
			value = 255 * powl ( (i+0.5)/255.5 , glgamma ) + 0.5;//bna++148
			if (value < 0)
				value = 0;
			if (value > 255)
				value = 255;
			glgammatable[i] = value;
		}
	}

}




Uint32* ReadPalette(int lump) {
    if (texauxinfo[lump].pal) {
	return texauxinfo[lump].pal;
    }
    Uint8* buf=(Uint8*)W_CacheLumpNum(lump,PU_STATIC,CvtNull,0);
    Uint32* newpal=(Uint32*) gl_malloc(256*4);
    convertpal(buf,newpal,0);
    return (texauxinfo[lump].pal=newpal);

}


Uint32* GLGetPalette(int lump)
{
	char lumpname[64];

    if (texauxinfo[lump].pal) {
		return texauxinfo[lump].pal;
    }


	//bna hack, since we forced gl to use def pal
	//we force it back on apogeetitle 
	lstrcpy(lumpname,W_GetNameForNum (lump));//bna++146
	if ((strstr(lumpname,"AP_WRLD")!=0)||(strstr(lumpname,"AP_TITL")!=0))
		return apogeepal;
	//bna hack end


    return gampal;

}

// index 0 is no colormap

void copy2d (Uint32 * spix, int smw, int smh, Uint32 * dpix, int dmw, int dmh,
	     int sx, int sy, int dx, int dy, int cw, int ch)
{
    if (dx < 0) {
	sx -= dx;
	cw += dx;
	dx = 0;
    }
    if (dy < 0) {
	sy -= dy;
	ch += dy;
	dy = 0;
    }
    if (dx + cw > dmw) {
	cw = dmw - dx;
    }
    if (dy + ch > dmh) {
	ch = dmh - dy;
    }
    if (cw <= 0 || ch <= 0)
	return;
    Uint32 *spos = spix + (sx + smw * sy);
    Uint32 *dpos = dpix + (dx + dmw * dy);
    int sskip = smw;
    int dskip = dmw;
    int yy;
    for (yy = 0; yy < ch; yy++, spos += sskip, dpos += dskip) {
	memcpy (dpos, spos, cw << 2);
    }
}
void copy2d16 (Uint16 * spix, int smw, int smh, Uint16 * dpix, int dmw, int dmh,
	     int sx, int sy, int dx, int dy, int cw, int ch)
{
    if (dx < 0) {
	sx -= dx;
	cw += dx;
	dx = 0;
    }
    if (dy < 0) {
	sy -= dy;
	ch += dy;
	dy = 0;
    }
    if (dx + cw > dmw) {
	cw = dmw - dx;
    }
    if (dy + ch > dmh) {
	ch = dmh - dy;
    }
    if (cw <= 0 || ch <= 0)
	return;
    Uint16 *spos = spix + (sx + smw * sy);
    Uint16 *dpos = dpix + (dx + dmw * dy);
    int sskip = smw;
    int dskip = dmw;
    int yy;
    for (yy = 0; yy < ch; yy++, spos += sskip, dpos += dskip) {
	memcpy (dpos, spos, cw<<1);
    }
}

#define STOVERLAP 64

#define TRANSOVR 1





int checkalpha(Uint32* tex, int w, int cw, int ch) {
    int skip=w-cw;
    int i,j;
    for (i=0;i<ch;i++,tex += skip) {
	for (j=0;j<cw;j++,tex++) {
	    if (ALPHACMP(*tex)!=0xFF) return 1;
	}
    }
    return 0;
}
static __inline int AverageColour32 (Uint32 * p, int x, int y, int w, int h)
{
    int a, c, n = 0;
    int r = 0, g = 0, b = 0;
    for (a = -1; a <= 1; a++) {
	if (x + a < 0)
	    continue;
	if (x + a >= w)
	    continue;
	for (c = -1; c <= 1; c++) {
	    if (y + c < 0)
		continue;
	    if (y + c >= h)
		continue;
	    if (ALPHACMP (p[(x + a) + w * (y + c)]) > 0) {
		Uint32 t = p[(x + a) + w * (y + c)];
		b += BLUECMP (t);
		g += GREENCMP (t);
		r += REDCMP (t);
		n++;
	    }
	}
    }
    if (n > 0)
	return ((b / n) << BLUE_SHIFT) + ((g / n) << GREEN_SHIFT) +
	    ((r / n) << RED_SHIFT);
    else
	return 0;
}

static __inline void TextureAvg32 (Uint32 * pic, int w, int h)
{

    Uint32 *f = pic;

    int x, y;

    for (y = 0; y < h; y++)
	for (x = 0; x < w; x++) {
	    if (ALPHACMP (*f) == 0) {
		*f = AverageColour32 (pic, x, y, w, h);
	    }
	    f++;
	}
}

#ifndef GL_EXT_texture_filter_anisotropic
#define GL_TEXTURE_MAX_ANISOTROPY_EXT     0x84FE
#define GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT 0x84FF
#endif

static void SetAnisotropic(void) {
    static int supported=1;
    GLfloat aniso; 

    checkGLStatus();

    //#ifdef GL_EXT_texture_filter_anisotropic
    if (supported) {
	glGetFloatv(GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT, &aniso); 
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAX_ANISOTROPY_EXT, aniso);
	if (glGetError()!=GL_NO_ERROR) {
	    fprintf(stderr,"Warning: Anisotropic filtering not supported by driver, using trilinear filtering.\n");
	    supported=0;
	}
    }
    //#else
    //anisotropic=0;
    //fprintf(stderr,"Warning: Anisotropic filtering not supported at compile time, using trilinear filtering.\n");
    //#endif

}

//#define USE_GLU_MIPMAPS

#ifdef USE_GLU_MIPMAPS

void BuildMipmaps(Uint32* pix, int w, int h, int hasalpha, int maxlevel) {

    if (hasalpha) 
		TextureAvg32(pix,w,h);

    glPixelStorei (GL_UNPACK_ROW_LENGTH, w);
    gluBuild2DMipmaps(GL_TEXTURE_2D,hasalpha?GL_RGBA:GL_RGB,w,h,GL_RGBA,GL_UNSIGNED_BYTE,pix);
}


#else

void ShrinkImageWeight (Uint32* src, Uint32* dest, int sw, int sh, int xs, int ys) {
    int dw=sw/xs;
    int dh=sh/ys;
    int sx,sy, dx,dy, xi, yi;
    double r,g,b,a;
    double rt,gt,bt,at;
    double wrt,wgt,wbt;
    double pixscl=(255.0/(xs*ys));
    double cpixscl;
    int ir,ig,ib,ia;

	wrt = 0;
	wgt = 0;
	wbt = 0;

    for (sy=0,dy=0;dy<dh;sy+=ys,dy++) {
	for (sx=0,dx=0;dx<dw;sx+=xs,dx++) {
	    rt=0; gt=0;
	    bt=0; at=0;
	    for (yi=0;yi<ys;yi++)
		for (xi=0;xi<xs;xi++) {
		    Uint32 sp=src[sx+xi + (sy+yi)*sw];
		    a = ALPHACMP(sp)/255.0;
		    r = REDCMP(sp)/255.0;
		    g = GREENCMP(sp)/255.0;
		    b = BLUECMP(sp)/255.0;
		    rt += r; gt += g;
		    bt += b; at += a;
		    wrt += r*a;
		    wgt += g*a;
		    wbt += b*a;
		}
	    ia=(at*pixscl);
		if (at==0.0) {
			ir=rt*pixscl;
			ig=gt*pixscl;
			ib=bt*pixscl;
	    } else {
			cpixscl=255.0/at;
			ir=rt*cpixscl;
			ig=gt*cpixscl;
			ib=bt*cpixscl;
	    }
	    *(dest++) = ir<<RED_SHIFT | ib<<BLUE_SHIFT | ig<<GREEN_SHIFT | ia<<ALPHA_SHIFT;
	}
    }
}
#ifndef min
#define min(x,y) ({ typeof(x) _x_; typeof(y) _y_; _x_=(x); _y_=(y); _x_ < _y_ ? _x_ : _y_ })
#endif

void ShrinkImage (Uint32* src, Uint32* dest, int sw, int sh, int xs, int ys) {
    int dw=sw>>xs;
    int dh=sh>>ys;
    int sx,sy, dx,dy, xi, yi;
    int rt,gt,bt,at;
    int xsk=1<<xs;
    int ysk=1<<ys;
    int scale09=xs+ys;
    for (sy=0,dy=0;dy<dh;sy+=ysk,dy++) {
	for (sx=0,dx=0;dx<dw;sx+=xsk,dx++) {
	    rt=0; gt=0;
	    bt=0; at=0;
	    for (yi=0;yi<ysk;yi++)
		for (xi=0;xi<xsk;xi++) {
		    Uint32 sp=src[sx+xi + (sy+yi)*sw];
		    rt += REDCMP(sp);
		    gt += GREENCMP(sp);
		    bt += BLUECMP(sp);
		    at += ALPHACMP(sp);
		}
	    rt>>=scale09;
	    gt>>=scale09;
	    bt>>=scale09;
	    at>>=scale09;
	    *(dest++) = rt<<RED_SHIFT | bt<<BLUE_SHIFT | gt<<GREEN_SHIFT | at<<ALPHA_SHIFT;
	}
    }
}





#define TWO_BUFFERS


//BuildMipmaps//
void BuildMipmaps(Uint32* pix, int w, int h, int hasalpha, int maxmips) {
    int format=hasalpha?GL_RGBA:GL_RGB;
    Uint32* bufs[16];
    bufs[0]=pix;


#ifdef TWO_BUFFERS
    Uint32* buf1=(Uint32*)gl_malloc((w>>1)*(h>>1)*4);
    Uint32* buf2=(Uint32*)gl_malloc((w>>1)*(h>>1)*4);
    bufs[1] = bufs[3] = bufs[5] = bufs[7] = bufs[9] = bufs[11]= buf1;
    bufs[2] = bufs[4] = bufs[6] = bufs[8] = bufs[10]= bufs[12]= buf2;
#else
    int z;
    for (z=1;z<16;z++) {
	bufs[z]=gl_malloc((w>>1)*(h>>1)*4);
    }
#endif
    int cw=w;
    int ch=h;
    int ow, oh;
    int xs, ys;
    int level=0;
 /*
		if ((w==512)&&(h==512)){
			for (int i=1;i<(w*h);i+=1){
				if (*(pix+i)==0xFF000000)
					*(pix+i)=0;
			}
		}
*/

    while (1) {

		if (hasalpha) 
			TextureAvg32(bufs[level],cw,ch);

		glPixelStorei (GL_UNPACK_ROW_LENGTH, cw);
/*
		if ((w==512)&&(h==512)){
			for (int i=0;i<(cw*ch);i+=1)
				*(buf2+i)=0;

		}
*/


		glTexImage2D (GL_TEXTURE_2D,level, format, cw, ch, 0, GL_RGBA,
				GL_UNSIGNED_BYTE, bufs[level]);
		glFinish();
		
		if (cw<=1 && ch<=1 )
			break;

		ow=cw; oh=ch;
		xs=0; ys=0;
		if (cw>1) { 
			cw >>= 1; xs=1; 
		}
		if (ch>1) { 
			ch >>= 1; ys=1; 
		}
		level++;
		if (!(maxmips!=-1 && level>=maxmips)) {
			ShrinkImage(bufs[level-1],bufs[level],ow,oh,xs,ys);
		}
    }
#ifdef TWO_BUFFERS
    gl_free(buf1); gl_free(buf2);
#else
    for (z=1;z<16;z++) {
	gl_free(bufs[z]);
    }
#endif
}

#endif /*USE_GLU_MIPMAPS*/

void ClampTexture(Uint32* tex, int w, int h, int clampx, int clampy) 
{
    int x,y;

	//bna hack if we return here we dont get top errors 
	//in graphics, why ?
	return ;


	if (clampy<h){
		for (x=0;x<w;x++) {
			int pix = tex[x+clampy*w];
			for (y = clampy+1; y<h ;y++) {
				tex[x+y*w] = pix;
			}
		}
		if (clampx<w)
		for (y=0;y<h;y++) {
			int pix = tex[clampx+y*w];
			for (x = clampx+1;x<w;x++) {
				tex[x+y*w] = pix;
			}
		}
	}
}



int MakeTexHiResToTexture (void* pixels, int repeat, int mipmaps, int *w, int *h);

int UploadTexture(GLuint tex, void* pixels, int w, int h,  int repx, int repy, int hasalpha, int mipmaps, int xw, int xh) {
   
//	byte  *pic1;
	Uint32 *pic=0;
	LPSTR pth;
	GLuint oldtex;
	UINT t1, t2;


    int world1=W_GetNumForName ("ap_wrld");//bna++154
    int aplogo1=W_GetNumForName ("ap_titl");//bna++154

	if (glsharpentex == 1){
		if ((globallump > 0) && (globallump < numlumps)) {
			if ((world1 != globallump) && (aplogo1 != globallump)) {//bna++154			
			
				if ((globallump >= GFX_wallstart) && (globallump <= GFX_wallstop) && bWalls2 == TRUE) {
					tex = MakeTexHiResToTexture((void*)pixels, 1, 20, &w, &h);
					return tex;
				}
				if ((globallump >= GFX_sidestart) && (globallump <= GFX_sidestop) && bSides2 == TRUE) {
					tex = MakeTexHiResToTexture((void*)pixels, 1, 20, &w, &h);
					return tex;
				}
				if ((globallump >= GFX_shapestart) && (globallump <= GFX_shapestop) && bShapes2 == TRUE) {
					tex = MakeTexHiResToTexture((void*)pixels, 1, 20, &w, &h);
					return tex;
				}
				if ((globallump >= GFX_maskedstart) && (globallump <= GFX_maskedstop) && bMasked2 == TRUE) {
					tex = MakeTexHiResToTexture((void*)pixels, 1, 20, &w, &h);
					return tex;
				}
				t1 = W_GetNumForName("HSWITCH1");
				t2 = W_GetNumForName("HSWTCH14");
				if ((globallump >= (int)t1) && (globallump <= (int)t2) && bHswicthes2 == TRUE) {
					tex = MakeTexHiResToTexture((void*)pixels, 1, 20, &w, &h);
					return tex;
				}
				if ((globallump >= GFX_gunsstart) && (globallump <= GFX_gunsstop) && bGuns2 == TRUE) {
					tex = MakeTexHiResToTexture((void*)pixels, 1, 20, &w, &h);
					return tex;
				}
				t1 = W_GetNumForName("FLRCL2");
				t2 = W_GetNumForName("FLRCL16");
				if ((globallump >= (int)t1) && (globallump <= (int)t2) && bFloor_Ceilings2 == TRUE) {
					tex = MakeTexHiResToTexture((void*)pixels, 1, 20, &w, &h);
					return tex;
				}
				if ((globallump >= GFX_exitstart) && (globallump <= GFX_exitstop) && bExits2 == TRUE) {
					tex = MakeTexHiResToTexture((void*)pixels, 1, 20, &w, &h);
					return tex;
				}
				if ((globallump >= GFX_elevatorstart) && (globallump <= GFX_elevatorstop) && bElevators2 == TRUE) {
					tex = MakeTexHiResToTexture((void*)pixels, 1, 20, &w, &h);
					return tex;
				}
				if ((globallump >= GFX_doorstart) && (globallump <= GFX_doorstop) && bDoors2 == TRUE) {
					tex = MakeTexHiResToTexture((void*)pixels, 1, 20, &w, &h);
					return tex;
				}
				if ((globallump >= GFX_abovewallstart) && (globallump <= GFX_abovewallstop) && bAbovewall2 == TRUE) {
					tex = MakeTexHiResToTexture((void*)pixels, 1, 20, &w, &h);
					return tex;
				}
				if ((globallump >= GFX_abovemaskwallstart) && (globallump <= GFX_abovemaskwallstop) && bAbovemaskwall2 == TRUE) {
					tex = MakeTexHiResToTexture((void*)pixels, 1, 20, &w, &h);
					return tex;
				}

			}
		}

		


	}

if (bUseExtWallSFX == TRUE){
	pth = CheckForExtGFX(globallump);
	if (pth != 0) 
	{  
			int tmplump=globallump;
			char tmp[256],png[256];
			GetPCXlumpname(tmp,pth,globallump);	
			GetPNGname(tmp,png); 
			if ((globallump == GFX_ap_world)||(access (tmp, 0) == 0)||(access (png, 0) == 0)){ //does sfxfile exists
				int w4,h4;
				oldtex = tex;
				tex = LoadExtImgToTexture(tmp,1,20,&w4,&h4);   
				if (tex > 0){
					SetWindowText(hMainWnd,tmp);
					glBindTexture(GL_TEXTURE_2D, tex);
					//if (lumpcache[tmplump])
					//	Z_Free(lumpcache[tmplump]);//Z_Malloc
					//void glDeleteTextures( GLsizei n,  const GLuint *textures);
 					globallump = 0;//bna++
					return tex;
				}else{
					tex = oldtex;
					goto x1234;
				}
/*
				res = HI_ReadBmpEx (tmp, NULL, &iWidth, &iHeight);
				if (res > 0){
					if (res == 32){
						tex = LoadExtImgToTexture(tmp,1,20,&w,&h);  
						if (tex >= 0)
							glBindTexture(GL_TEXTURE_2D, tex);
							
						globallump = 0;//bna++
						return tex;
					}

					goto x1234;

					FindDiv8Size( iWidth, iHeight, &Div8W, &Div8H);
    				Z_Malloc (((Div8W*Div8H)*4)+1000, PU_STATIC, &pic1);
					//get the picture
					if (HI_ReadBmpEx (tmp,  (byte*)pic1, &iWidth, &iHeight)>0){
						SetWindowText(hMainWnd,tmp);
						if ((globallump != GFX_ap_world)&&(globallump != GFX_ap_titl))
							BlurPicBuf( pic1, iWidth, iHeight,globallump);
						int i, j;
						byte  b;
						Uint32 c;
			  			Uint8* col = GetColorMap(0);
						Uint32 *gpal = GLGetPalette(globallump); 
						pic = (Uint32 *) gl_malloc (Div8W * Div8H * 4);
						memset (pic,0,Div8W * Div8H * 4);
						byte *spos;
						Uint32 *dpos;
						spos = pic1;
						dpos = (Uint32*)pic;

						for (i = 0; i < iHeight ; i++) {
							for (j = 0; j < iWidth; j++) {
								b = *(spos++);
								c = gpal[col[b]] |(255<<ALPHA_SHIFT);
								if (b==BGBYTE)
									c = 0;
								*(dpos++) = c;
							}
							dpos += (Div8W - iWidth);
						}		
						Z_Free(pic1);

						pixels = pic;
						w = (Div8W);//(iWidth /1);
						h = (Div8H);//(iHeight/1);
					}
				}
				
			*/}				
	}	
}
x1234:;
	BindTex( tex);
    checkGLStatus ();

    glPixelStorei (GL_UNPACK_SKIP_PIXELS, 0);
    glPixelStorei (GL_UNPACK_SKIP_ROWS, 0);
    glPixelStorei (GL_UNPACK_ALIGNMENT, 1);
    checkGLStatus ();

    glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, repx?GL_REPEAT:GL_CLAMP_TO_EDGE);
    glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, repy?GL_REPEAT:GL_CLAMP_TO_EDGE);
    glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, partialfilter);
    glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, mipmaps?fullfilter:partialfilter);

    if (mipmaps && (fullfilter!=GL_NEAREST) && (fullfilter!=GL_LINEAR)) {
		SetAnisotropic();
		BuildMipmaps ((Uint32*)pixels, w, h, hasalpha,mipmaps);
    } else {
		glTexImage2D (GL_TEXTURE_2D,0, hasalpha?GL_RGBA:GL_RGB, w, h, 0, GL_RGBA,
			   GL_UNSIGNED_BYTE, pixels);
    }
    checkGLStatus ();

	if (pic != 0)
		gl_free(pic);
		
	globallump = 0;//bna++

	return tex;
}




byte identity[256];

Uint8* GetColorMap(int color) {
    if (color > 0) {
	return playermaps[color - 1] + (1 << 12);
    }
    return identity;
}


#define REPEAT_X 1
#define REPEAT_Y 2
#define REPEAT_BOTH 3
#define REPEAT_AUTO 4

enum {  FT_PATCH, LT_TPATCH, LT_LPIC, LT_WALL };

/*
 * ROTT stores no information about type in the
 * WAD file, so we have to guess. Luckily, it's not that 
 * hard.
 */

/*
 * Rule for patches: patch->collumnofs[0] == patch->width*2 + 10
 */

int getinfo_patch (Uint8* lump, int len, texbufinfo_t* ti)
{
    patch_t *ppat = (patch_t *) lump;
    if (len <= 10) return 0; // Too short for a patch
    int cofs=IntelShort(ppat->collumnofs[0]);
    int width=IntelShort(ppat->width);

    if (cofs != (10 + width * 2)) {
		return 0;
    }
    // Manually run the converter on it
    Cvt_patch_t(ppat,1);

    int rw,rh,w,h,lo,to;

    ti->rw = rw = ppat->width;
    ti->rh = rh = ppat->height;
    ti->w = w = powerof2 (rw);
    ti->h = h = powerof2 (rh);
    ti->lofs = lo = -ppat->leftoffset;
    ti->tofs = to = -ppat->topoffset;
    ti->osize = ppat->origsize;



    if (ti->rep == REPEAT_AUTO) {
	ti->rep = 0;
	if (lo == 0 && rw == ppat->origsize)
	    ti->rep |= REPEAT_X;
	if (to == 0 && rh == ppat->origsize)
	    ti-> rep |= REPEAT_Y;
    }
    return 1;
}



Uint32 *convert_patch (Uint8* lump, int len, Uint32* gampal3, Uint8* col, texbufinfo_t* ti)
{
    patch_t *ppat = (patch_t *) lump;

	int memsize = (ti->w * ti->h * 4);
    Uint32 *pic = (Uint32 *) gl_malloc (memsize);
    memset (pic, 0, ti->w * ti->h * 4);
    int i, j, ofs,rlen;
    Uint32 *idpos = pic;
    Uint8 *spos;
    Uint32 *dpos;

    unsigned short *ccolofs = ppat->collumnofs;
/*
	if ((globallump>=1937)&&(globallump<=1951)){//1879){
		int h;
		//lump=1877;
		pic = HI_ReadBmp ("c:\\ABRAZ1.BMP",  &iWidth,  &iHeight);
			ti->rh = iHeight;
			ti->rw = iWidth;
			ti->h = 81;
			ti->w = 196;
		ti->tofs = 31;
			s = pic;
		for (h = 0; h< (iHeight*iWidth)+(41*60); h++ ){
			if (*s != 0)
				*s = gampal3[col[*s]] |(255<<ALPHA_SHIFT);
			s++;
		}
		return pic;
	}
*/





    for (i = 0; i < ti->rw; i++, ccolofs++) {
		spos = (((Uint8 *) ppat) + (*ccolofs));
		while (1) {
			if ((ofs = *(spos++)) == 0xFF) {
				break;
			} else {
				rlen = *(spos++);
				dpos = (idpos + (i + (ti->w * ofs)));
				for (j = 0; j < rlen; j++, spos++, dpos += ti->w){
					if ((dpos >= pic)&&(dpos <= (pic+memsize))){//bna++ make sure we dont exxed mem area
						*dpos = gampal3[col[*spos]] |(255<<ALPHA_SHIFT);
					}
				}
			}
		}
	}
    return pic;
}




int getinfo_tpatch (Uint8* lump, int len, texbufinfo_t* ti)
{
    transpatch_t *ppat = (transpatch_t *) lump;
    if (len <= 12) return 0; // Too short for a transpatch

    int cofs=IntelShort(ppat->collumnofs[0]);
    int width=IntelShort(ppat->width);

    if (cofs != (12 + width * 2)) {
	return 0;
    }
    Cvt_transpatch_t(ppat,1);
    int rw,rh,w,h,lo,to;

    ti->rw = rw = ppat->width;
    ti->rh = rh = ppat->height;
    ti->w = w = powerof2 (rw);
    ti->h = h = powerof2 (rh);
    ti->lofs = lo = -ppat->leftoffset;
    ti->tofs = to = -ppat->topoffset;
    ti->osize = ppat->origsize;


    if (ti->rep == REPEAT_AUTO) {
	ti->rep = 0;
	if (lo == 0 && rw == ppat->origsize)
	    ti->rep |= REPEAT_X;
	if (to == 0 && rh == ppat->origsize)
	    ti-> rep |= REPEAT_Y;
    }
    return 1;
}




Uint32 *convert_tpatch (Uint8* lump, int len, Uint32* gampal4, Uint8* col, texbufinfo_t* ti)
{
	int tmask;
	Uint32 *pic;
    transpatch_t *ppat = (transpatch_t *) lump;
	BYTE *mem = 0;
	int memsize = (ti->w * ti->h * 4);
	int mask = (255<<ALPHA_SHIFT);
	pic = (Uint32 *) gl_malloc (memsize);
	//pic = (Uint32 *) gl_malloc (64*64*4);
    tmask = (63 - ppat->translevel) << (ALPHA_SHIFT+2);
	if (globallump == 442)
		pic=pic;
/*
	if ((globallump >= GFX_maskedstart)&&(globallump <= GFX_maskedstop)){
		mem = (BYTE*)testmasked(globallump);
		if (mem == 0)
			mem = mem;//pic = (Uint32 *) gl_malloc (ti->w * ti->h * 4);
		else{
			int ix;
			//pic = (Uint32 *) gl_malloc (64*64);
			for (ix = 0; ix < (64*64);ix++){
				if (*(mem+ix) == 1)
					*(pic+ix) = tmask;
				else
					*(pic+ix) = gampal4[col[*(mem+ix)]] | mask;
			}
			GlobalFree(mem);
			return pic;
		}

	}else{
		//pic = (Uint32 *) gl_malloc (ti->w * ti->h * 4);
	}
*/

    memset (pic, 0, ti->w * ti->h * 4);
    int i, j, ofs, rlen;
    Uint32 *idpos = pic;
    Uint8 *spos;
    Uint32 *dpos;


	//does there exists a name with # in it?
//	char *W_GetNameForNum (int i)
//	int externtranslevel = GetTranslevelFilename (szFileName);


    unsigned short *ccolofs = (unsigned short*)ppat->collumnofs;
    for (i = 0; i < ti->rw; i++, ccolofs++) {
	spos = (((Uint8 *) ppat) + (*ccolofs));
	while (1) {
	    if ((ofs = *(spos++)) == 0xFF) {
			break;
	    } else {
			rlen = *(spos++);
			mask = (255<<ALPHA_SHIFT);
			dpos = (idpos + (i + (ti->w * ofs)));
			if (*spos == 254) {
				for (j = 0; j < rlen; j++, dpos += ti->w)
				*dpos = tmask;
				spos++;
			} else {
				for (j = 0; j < rlen; j++, spos++, dpos += ti->w){
					if (*spos == 0){//bna
						if ((dpos >= pic)&&(dpos <= (pic+memsize))){//bna++ make sure we dont exxed mem area
							*dpos = tmask;//bna 
						}
					}else{
						if ((dpos >= pic)&&(dpos <= (pic+memsize))){//bna++ make sure we dont exxed mem area
							*dpos = gampal4[col[*spos]] | mask;
						}
					}
				}
			}
	    }
	}
    }

    return pic;
}



int getinfo_wall (Uint8* ppat, int len, texbufinfo_t* ti)
{
    if (len != 4096) return 0;

    ti->w=ti->h=ti->rw=ti->rh=ti->osize=64;
    ti->lofs=ti->tofs = 0;
    if (ti->rep == REPEAT_AUTO) {
	ti->rep = REPEAT_X | REPEAT_Y;
    }
    return 1;
}



Uint32 *convert_wall (Uint8* ppat, int len, Uint32* gampal5, Uint8* col, texbufinfo_t* ti)
{
    int i, j;
    
    Uint32 *pic = (Uint32 *) gl_malloc (64 * 64 * 4);
    Uint8 *spos;
    Uint32 *dpos;
    spos = ppat;
    dpos = pic;
    for (i = 0; i < 64; i++) {
	for (j = 0; j < 64; j++) {
	    *dpos++ = gampal5[col[spos[i + 64 * j]]] | (255<<ALPHA_SHIFT);
	}
    }
    return pic;
}



int getinfo_lpic (Uint8* lump, int len, texbufinfo_t* ti)
{
    lpic_t *ppic = (lpic_t *) lump;

    if (len<4) return 0;
    int w = IntelShort(ppic->width);
    int h = IntelShort(ppic->height);

    int expectlen=w*h+8;
    if (len != expectlen) return 0;

    Cvt_lpic_t(ppic,1);

    int rw, rh, lo, to;

    ti->rw = rw = w;
    ti->rh = rh = h;
    ti->w = w = powerof2 (rw);
    ti->h = h = powerof2 (rh);
    ti->lofs = lo = -ppic->orgx;
    ti->tofs = to = -ppic->orgy;
    ti->osize = (w<h?h:w);
    return 1;
}



Uint32 *convert_lpic (Uint8* lump, int len, Uint32* gampal6, Uint8* col, texbufinfo_t* ti)
{
    lpic_t *ppic = (lpic_t *) lump;
    Uint32 *buf = (Uint32 *) gl_malloc (ti->w * ti->h * 4);
    memset(buf,0,ti->w * ti->h * 4);
    int i, j;
    Uint8 *spos;
//    Uint32 *dpos;
    spos = ((Uint8 *) ppic) + 8;
    for (i = 0; i < ti->rh; i++) {
	for (j = 0; j < ti->rw; j++) {
	    buf[i * ti->w + j] = gampal6[col[spos[i + ti->rh * j]]] | (255<<ALPHA_SHIFT);
	}
    }
    return buf;
}

//bna++146 start
Uint32 *convert_bmp8colpicto32col (Uint8* inpic, int len, int w, int h)
{
	Uint8* col = GetColorMap(0);
    Uint32 *buf = (Uint32 *) gl_malloc (w * h * 4);

    int i, j;
    Uint8 *spos;

    memset(buf,0,w * h * 4);

    spos = (Uint8 *) inpic;
    for (i = 0; i < h; i++) {
		for (j = 0; j < w; j++) {
			buf[i * w + j] = gampal[col[spos[i + h * j]]] | (255<<ALPHA_SHIFT);
		}
    }
    return buf;
}
//bna++146 end


typedef Uint32* (*convertfunc)(Uint8* lump, int len,
			       Uint32* pal, Uint8* colmap, texbufinfo_t* ti);

typedef int (*getinfofunc)(Uint8* lump, int len,
			       texbufinfo_t* ti);

typedef struct {
    getinfofunc getinfo;
    convertfunc convert;
} convertinfo_t;
static convertinfo_t converters[] = {
#define func(f) {getinfo_##f,convert_##f}
    func(patch),
    func(tpatch),
    func(lpic),
    func(wall),
    {NULL,NULL}
};

static convertinfo_t* GetInfo(Uint8* buf, int len, texbufinfo_t* ti) {
    convertinfo_t *cur=&converters[0];
    int ret=0;
    while (cur->getinfo) {
	ret=cur->getinfo(buf,len,ti);
	if (ret) return cur;
	cur++;
    }
    return NULL;
}

#define TRANSTEX(tn,rsx,rsy,fsx,fsy,rdx,rdy,adx,ady,cw,ch)					\
if (texauxinfo[lump].trans[tn]) {								\
    int tl=(texauxinfo[lump].trans[tn])&0x3FFF;							\
    Uint32* ctbuf=										\
	transcvt[tn]->convert(tbuf[tn],tlen[tn],GLGetPalette(tl),				\
			      GetColorMap(i),ctrans);      					\
    												\
 												\
    /*if(checkalpha(tbuf,trans.w,trans.rw,trans.rh))mhasalph=1;*/				\
    if ((texauxinfo[lump].trans[tn])&0x4000) {							\
	sx=fsx; sy=fsy;										\
    } else {											\
	sx=rsx; sy=rsy;										\
    }												\
    dx=rdx;											\
    dy=rdy;											\
    sx -= ctrans->lofs;										\
    dx -= mtrans.lofs;										\
    sy -= ctrans->tofs;										\
    dy -= mtrans.tofs;										\
    dx ++;											\
    dy ++;											\
    copy2d(ctbuf,ctrans->w,ctrans->h,nbuf,nw,nh,sx,sy,dx,dy,cw,ch);				\
												\
    if ((texauxinfo[lump].trans[tn])&0x8000)							\
	copy2d(ctbuf,ctrans->w,ctrans->h,nbuf,nw,nh,fsx,fsy,adx+1,ady+1,cw,ch);			\
												\
    gl_free(ctbuf);										\
}
/*
gl_lumpinfo_t* GLLoadFont(int lump) {
    gl_lumpinfo_t* ret=&lumpinfo[lump];
    glfont_t* font=(glfont_t*)gl_malloc(sizeof(glfont_t));
    if (ret->type==LT_FONT) {
	return ret;
    }
    if (ret->type!=LT_FONT) {
	return NULL;
    }
    font_t* in=W_CacheLumpNum(lump,PU_CACHE,Cvt_font_t,0);
    ret->type=LT_FONT;
    int i,j,k;
    int width=0;
    k=0;
    for (j=0;j<16;j++) {
	int totalwidth=17;//borders
	for (i=0;i<16;i++,k++) {
	    totalwidth += in->width[k];
	}
	if (width<totalwidth) width=totalwidth;
    }
    int realheight=17+(16*in->height);
    
    int w=powerof2(width);
    int h=powerof2(height);
    
    Uint32* pic=(Uint32*) gl_malloc(w*h*4);
    Uint8* spos;
    int cy=0;
    k=0;
    for (j=0;j<16;j++) {
	int cx=0;
	for (i=0;i<16;i++,k++) {
	    int xx,yy;
	    int cw=in->width[k];
	    spos=(&in->data)+in->charofs[;
	    for (xx=0;xx<;xx++) 
	    totalwidth += ;
	}
	if (maxwidth<totalwidth) maxwidth=totalwidth;
    }
    
    Uint32* dpos=
}
*/
int 
#ifdef WIN32
__cdecl
#endif
compar_ptr(const void* a, const void* b) {
    if (*((void**)a) < *((void**)b)) return -1;
    if (*((void**)a) > *((void**)b)) return 1;
    return 0;
}
  
extern "C" {
	gl_lumpinfo_t* GetTexForLump (int lump, int repeat , int cvisflags);
	extern UINT * InterpolateStrechBuffer32(UINT *t, int iw, int ih, int neww, int newh);

	char IsGCached[5000][1];//bna added
	gl_lumpinfo_t *IsTexCached[429][MAXPLAYERCOLORS];// lump 2402 -  lump 1973 = 429  bna added 

	int g_start_of_playertexture = 0;//player textures start at CASSHO11 = 1973
	int g_stop_of_playertexture = 0; //player textures end at IPFWDEAD = 2402 
}


gl_lumpinfo_t* keyret;

gl_lumpinfo_t* GetTexForLump (int lump, int repeat, int cvisflags)
{
    int i,  keynb;
    Uint8* buf;
    int len;
    texbufinfo_t mtrans;
    convertinfo_t* cvt;
	char tmp[64];
    Uint8* tbuf[4];
    Uint8* bufs2free[5];
    int tlen[4];
    texbufinfo_t trans[4];
    convertinfo_t* transcvt[4];
	char *namex ,infobuf[128];

	tbuf[0] = 0;

    int nw=0, nh=0;
	keynb = 0;
	int keycol = 0; 

    gl_lumpinfo_t* ret = &lumpinfo[lump];


	//bna++146 keycolorfix
	//we store 16 pictures of each of the 4 keycolors
	if (cvisflags >= GLV_KEYCOLOR1){
		lstrcpy(tmp,W_GetNameForNum (lump));	
		keynb = atol(tmp+4) ;
		IsGCached[lump][0] = 0;
		//do we have this cached in this color
		if (cvisflags & GLV_KEYCOLOR1) {//stat_pedgoldkey
			keynb += 0;
			if ((keynb >= 1)&&(keynb <=16)){
				keyret = &lumpkeyinfo[keynb];
				if (keyret->type != LT_UNKNOWN){
					return keyret;
				}
			}
			keycol = 11;//pc_orange;
		}else if (cvisflags & GLV_KEYCOLOR3) {//stat_pedsilverkey
			keynb += 16;
			if ((keynb >= 1+16)&&(keynb <=16+16)){
				keyret = &lumpkeyinfo[keynb];
				if (keyret->type != LT_UNKNOWN){
					return keyret;
				}
			}
			keycol = 3;//pc_gray;
		}else if (cvisflags & GLV_KEYCOLOR2) {//stat_pedironkey
			keynb += 32;
			if ((keynb >= 1+32)&&(keynb <=16+32)){
				keyret = &lumpkeyinfo[keynb];
				if (keyret->type != LT_UNKNOWN){
					return keyret;
				}
			}
			keycol = 6;//pc_olive;
		}else if (cvisflags & GLV_KEYCOLOR4) {//stat_pedcrystalkey
			keynb += 48;
			if ((keynb >= 1+48)&&(keynb <=16+48)){
				keyret = &lumpkeyinfo[keynb];
				if (keyret->type != LT_UNKNOWN){
					return keyret;
				}
			}
			keycol = 5;//pc_red;
		}
	}
	//bna++146 keycolorfix end

	if (ret->type == LT_TEXTURE) {
		return ret;
    }
	if (ret->type == LT_MODEL) {
		return ret;
    }
	if (ret->type == LT_FONT) {
		return ret;
    }


	//GLDrawCacheLEDS (0, 0, 0, 0);

	if (hWndInfo != 0){
		namex = W_GetNameForNum (lump);
		if (glsharpentex == 1)
			sprintf (infobuf,"Caching/Sharpen graphics: %s",namex);
		else
			sprintf (infobuf,"Caching graphics: %s",namex);
		AddToInfoWindow(infobuf, 1) ;
	}


	memset(&texauxinfo[lump],0,sizeof(texauxinfo[lump]));
//	memset(&lumpinfo[lump],0,sizeof(lumpinfo[lump]));

	//bna hack, we force gl to use default pal since
	//we cant compile properly in msvc7 in structures
	if (IsGCached[lump][0] == 1)
		return ret;

/*
	{
   char msgbuf[300];
   if (isonlist (lump)==0){
    FILE *stream = fopen(szDbgName, "a+");
	sprintf(msgbuf,"%d,",lump);
	fprintf(stream,msgbuf);
    fclose(stream);
   }}
*/


	IsGCached[lump][0] = 1;
	//bna hack end
//SetTextMode ();//bnaset	xxx
/*
	if (insetupgame == false){
		char str[64];
		strncpy (&str[0], W_GetNameForNum (lump), 8);
		WriteDebug(str,lump);
	}
*/

    ret->type=LT_TEXTURE;
    mtrans.rep=repeat;
/*
{
char kljsd[260];//bna154
strncpy (&kljsd[0], W_GetNameForNum (lump), 8);
WriteLBtext(kljsd);
}*/


    buf = GL_W_CacheLumpNum(lump,PU_STATIC,CvtNull,0); // converters will do the endian converting
 	if (buf == 0){
        *ret = invalid;               
        return ret;
    }


	//28-2-2012 Bna hack to ensure the floors are corect size
	//it fails on rare occasins 
	char flcrtstname[9];
	strncpy (&flcrtstname[0], W_GetNameForNum (lump), 8);
	flcrtstname[5] = 0;
	if (strcmp(flcrtstname,"FLRCL")==0){
		*(buf + 0) = 128;
		*(buf + 1) = 0;
		*(buf + 2) = 128;
		*(buf + 3) = 0;
		*(buf + 4) = 0;
		*(buf + 5) = 0;
		*(buf + 6) = 0;
		*(buf + 7) = 0;
	}
	
	len=W_LumpLength(lump);
	cvt=GetInfo(buf,len,&mtrans);

    if (!cvt) {
    	SoftError ("WTF is this? %d %s\n",lump,W_GetNameForNum(lump));
    	*ret=invalid;
    	return ret;
    }
	if (texauxinfo[lump].transused) {
		nw = powerof2 (mtrans.rw + 2);
		nh = powerof2 (mtrans.rh + 2);
		for (i=0;i<4;i++) {
			if (texauxinfo[lump].trans[i]) {
				int clump=texauxinfo[lump].trans[i]&0x3FFF;
				tbuf[i]=GL_W_CacheLumpNum(clump,PU_STATIC,CvtNull,0);
				if (tbuf[i] == 0){
					*ret=invalid;               
					return ret;
				}
				tlen[i]=W_LumpLength(clump);
				transcvt[i]=GetInfo(tbuf[i],tlen[i],&trans[i]);
				if (!transcvt[i]) {
					SoftError ("WTF is this? %d %s\n",clump,W_GetNameForNum(clump));
					*ret=invalid;
					return ret;
				}
			} else {
				tbuf[i]=NULL;transcvt[i]=NULL;
				tlen[i]=0;
			}
		}
    }

    for (i=0;i<MAXPLAYERCOLORS+1;i++) {
		if (i==0||texauxinfo[lump].colorsused[i-1]) {
			Uint8* col=GetColorMap(i);
			if (keycol > 0){//bna++146
				col=GetColorMap(keycol);//bna++146
			}
			if (g_keycol > 0) {//bna++178
				col = GetColorMap(g_keycol);//bna++178
			}			
// GLV_COLORED
			/*
			if (lump >= 1973 && lump <= 2058) {//bna++178 ddddd
				col = GetColorMap(pc_red+1);//bna++178  CASS1 to CASS8 
			}
			if (lump >= 2059 && lump <= 2144) {//bna++178 ddddd
				col = GetColorMap(pc_green+1);//bna++178  CASS1 
			}
			if (lump >= 2145 && lump <= 2230) {//bna++178 ddddd
				col = GetColorMap(pc_orange+1);//bna++178  CASS1 
			}
			if (lump >= 2231 && lump <= 2316) {//bna++178 ddddd
				col = GetColorMap(pc_black+1);//bna++178  WENSHO11 
			}
			if (lump >= 2317 && lump <= 2402) {//bna++178 ddddd
				col = GetColorMap(pc_gray+1);//bna++178  LNISHO11 
			}
/*
	pc_gray,
	pc_brown,
	pc_black,
	pc_tan,
	pc_red,
	pc_olive,
	pc_blue,
	pc_white,
	pc_green,
	pc_purple,
	pc_orange
*/
			globallump = lump;//bna++
			Uint32* mbuf = cvt->convert(buf,len,GLGetPalette(lump),col,&mtrans);

			int ctex=0;
			glGenTextures(1,(GLuint*)&ctex);

			if (texauxinfo[lump].transused) {
	#define trw ctrans->rw
	#define trh ctrans->rh
	#define mrw mtrans.rw
	#define mrh mtrans.rh

			Uint32 *nbuf = (Uint32 *) gl_malloc (nw * nh * 4);
			memset (nbuf, 0, nw * nh * 4);
			copy2d (mbuf, mtrans.w, mtrans.h, nbuf, nw, nh, 0, 0, 1, 1, mrw, mrh);
			int sx, sy, dx, dy;
	//		int ti;
			//(trl,rsx,rsy,fsx,fsy,rdx,rdy,adx,ady,cw,ch)
			texbufinfo_t* ctrans=&trans[0];
			TRANSTEX (0, 0,       trh - 1, 0,       0,       0,   -1,  0,       0,       trw, 1); ctrans++;
			TRANSTEX (1, 0,       0,       0,       trh - 1, 0,   mrh, 0,       mrh - 1, trw, 1); ctrans++;
			TRANSTEX (2, trw - 1, 0,       0,       0,      -1,   0,   0,       0,       1, trh); ctrans++;
			TRANSTEX (3, 0,       0,       trw - 1, 0,       mrh, 0,   mrw - 1, 0,       1, trh);
			gl_free (mbuf);
	#undef trw
	#undef trh
	#undef mrw
	#undef mrh

			ClampTexture(nbuf,nw,nh,mtrans.rw+1,mtrans.rh+1);
			UploadTexture(ctex,nbuf,nw,nh,0,0,1,20,mtrans.rw,mtrans.rh);
			gl_free (nbuf);

			} else { 
	/*
				if (globallump == 1959 ){
					int w,h;
					ctex = LoadExtImgToTexture("c:\\WinRott_2.24_GL\\GFX\\Floor_Ceil\\FLRCL6.BMP",1,20,&w,&h);  
					glBindTexture(GL_TEXTURE_2D, ctex);
					gl_free (mbuf);
					
				}else*/{
	  
/*
 			Uint32* Strechedbuf = InterpolateStrechBuffer32(mbuf,mtrans.w,mtrans.h,mtrans.w*4,mtrans.h*4);
			gl_free (mbuf);
			mbuf = Strechedbuf;
			//mtrans.w *= 4;
			//mtrans.h *= 4;

			if ( mtrans.w != 64)
			mbuf = Strechedbuf;

			mtrans.w *= 4;
			mtrans.h *= 4;    
			//mtrans.size *= 4;
 			mtrans.rw *= 4;
			mtrans.rh *= 4;   

 			mtrans.lofs *= 4;
			mtrans.tofs *= 4;  

			mtrans.osize *= 4;  
			*/
					ClampTexture(mbuf,mtrans.w,mtrans.h,mtrans.rw-1,mtrans.rh-1);
					ctex = UploadTexture(ctex,mbuf,mtrans.w,mtrans.h,mtrans.rep&REPEAT_X,mtrans.rep&REPEAT_Y,1,20,mtrans.rw,mtrans.rh);
					gl_free (mbuf);
				}
			}

			ret->tex.texnum[i]=ctex;
		} else {
			ret->tex.texnum[i]=ret->tex.texnum[0];
		}
    }
    int nfreebufs=0;
    //Z_Free (buf); // save memory: we don't need the 8bit texture
    bufs2free[nfreebufs++]=buf;
    ret->tex.w=mtrans.rw;
    ret->tex.h=mtrans.rh;
    ret->tex.lofs=mtrans.lofs;
    ret->tex.tofs=mtrans.tofs;
    ret->tex.osize=mtrans.osize;
    if (texauxinfo[lump].transused) {
 	ret->tex.tcxl = 1 / (double)nw;
	ret->tex.tcxh = (double)(mtrans.rw + 1) / (double)nw;
	ret->tex.tcyl = 1 / (double)nh;
	ret->tex.tcyh = (double)(mtrans.rh + 1) / (double)nh;

	mtrans.w=nw;
	mtrans.h=nh;
	mtrans.rw+=2;
	mtrans.rh+=2;
	mtrans.rep=0;
	for (i=0;i<4;i++) {
	    if (texauxinfo[lump].trans[i]) {
		bufs2free[nfreebufs++]=tbuf[i];
	    }
	}
	
    } else {
	ret->tex.tcxl = 0.0;
	ret->tex.tcyl = 0.0;
	ret->tex.tcxh = (double)mtrans.rw/(double)mtrans.w;
	ret->tex.tcyh = (double)mtrans.rh/(double)mtrans.h;
    }
    qsort(bufs2free,nfreebufs,sizeof(void*),compar_ptr);
    Uint8* last=NULL;
    for (i=0;i<nfreebufs;i++) {
	if (bufs2free[i]!=last) {
	    Z_Free(last=bufs2free[i]);
	} 
    }
    
    /*
	if ((lump == 3887)||(lump == 3888)){   
       WriteDebug("tex.pal ",texauxinfo[lump].pal);
       WriteDebug("tex.colorsused ",texauxinfo[lump].colorsused);      
       WriteDebug("tex.trans ",texauxinfo[lump].trans);    
       WriteDebug("tex.transused ",texauxinfo[lump].transused);    
            
//		SetTextMode();
//		texauxinfo[lump].pal = ReadPalette( lump); 
		
		//	return ret;
	} */ 


	if (keynb > 0){
		ret->type = 5;
		memcpy(&lumpkeyinfo[keynb],ret,sizeof(gl_lumpinfo_t));
	}

    return ret;
}

void UploadSurfaceToTexture (GLuint tex, SDL_Surface * surf, int repeat, int mipmaps, double* tcx, double* tcy)
{
    SDL_SetAlpha(surf,0,255);
    int nw=powerof2(surf->w);
    int nh=powerof2(surf->h);
    SDL_Surface *conv =
	SDL_CreateRGBSurface (SDL_SWSURFACE, nw, nh, 32, 0x000000FF,
			      0x0000FF00, 0x00FF0000, 0xFF000000);
    SDL_BlitSurface (surf, NULL, conv, NULL);
    if (tcx) *tcx=(double)surf->w/(double)nw;
    if (tcy) *tcy=(double)surf->h/(double)nh;

    int hasalph=checkalpha((Uint32*) surf->pixels, surf->w, surf->w, surf->h);

    UploadTexture(tex,conv->pixels,conv->w,conv->h,repeat,repeat,hasalph,mipmaps,nw,nh);

    SDL_FreeSurface (conv);
}

int LoadImgToTexture (const char *fname, int repeat, int mipmaps)
{
    char buf[255];
    sprintf(buf,"%s/%s",GLPath,fname);
    SDL_Surface *tmp = IMG_Load (buf);

	//if tmp is 0 try load a bmp pic instead
	if (!tmp) {
		int l = lstrlen(buf);
		buf[l-3] = 0;
		lstrcat (buf, "bmp");
		tmp = IMG_Load (buf);
	}
    if (!tmp) 
		return -1;
    GLuint ret;
    glGenTextures (1, &ret);
    UploadSurfaceToTexture (ret, tmp, repeat, mipmaps, NULL, NULL);
    SDL_FreeSurface (tmp);
    return ret;
}

void PrecacheGroup (const char *name)
{
    int i;
    char buf[32];

    sprintf (buf, "%sstrt", name);
    int start = W_GetNumForName (buf) + 1;
    sprintf (buf, "%sstop", name);
    int end = W_GetNumForName (buf);
    for (i = start; i < end; i++) {
		GetTexForLump (i, REPEAT_AUTO ,0);
    }
}



static skintex* LoadSkin(const char* fname) {
    int i;
    for (i=0;i<nskins;i++) {
		if (skins[i].name > 0){
		if (!strcmp(skins[i].name,fname)) {
			return &skins[i];
		}
		}
    }
    if (!nskins) {
	skins=(skintex*)gl_malloc(8*sizeof(skintex));
    } else if (!(nskins&7)) {
	//skins=(skintex*)realloc(skins,(nskins+8)*sizeof(skintex));
	skins=(skintex*)gl_remalloc(skins,(nskins+8)*sizeof(skintex));

	
    }
    skins[nskins].name=strdup(fname);
    if ((skins[nskins].tex=LoadImgToTexture(fname,1,20))==-1) {
	Error("Could not load image file %s: %s\n",fname,strerror(errno));
    }
    
    return &skins[nskins++];
}

#if 0
#include "model.tab.c"
#include <array>


static void compile_model(model* mod, cmodel* ret) {
    int i,j,k;
    for (i=0;i<4;i++) {
	//ret->shapes[i]=NEW(cshape_list);
	ret->shapes[i].nshapes=mod->shapes[i].nshapes;
	ret->shapes[i].shapes=NEWARR(cshape,mod->shapes[i].nshapes);
	for (j=0;j<mod->shapes[i].nshapes;j++) {

	    ret->shapes[i].nverts=0;
	    for (j=0;j<mod->shapes[i].nshapes;j++) {
		ret->shapes[i].shapes[j].nverts=mod->shapes[i].shapes[j].nverts;
		ret->shapes[i].shapes[j].type=mod->shapes[i].shapes[j].type;
		ret->shapes[i].shapes[j].tex=mod->shapes[i].shapes[j].tex;
		ret->shapes[i].shapes[j].normal=mod->shapes[i].shapes[j].normal;
		ret->shapes[i].shapes[j].vertindex=ret->shapes[i].nverts;
		ret->shapes[i].nverts += mod->shapes[i].shapes[j].nverts;
	    }
	    ret->shapes[i].vertlist=NEWARR(m_vertex,ret->shapes[i].nverts);
	    ret->shapes[i].texcoords=NEWARR(m_texcoord,ret->shapes[i].nverts);

	    for (j=0;j<mod->shapes[i].nshapes;j++) {
		memcpy(ret->shapes[i].vertlist  + ret->shapes[i].shapes[j].vertindex,mod->shapes[i].shapes[j].verts,
		       sizeof(m_vertex)*mod->shapes[i].shapes[j].nverts);
		memcpy(ret->shapes[i].texcoords + ret->shapes[i].shapes[j].vertindex,mod->shapes[i].shapes[j].texcoords,
		       sizeof(m_texcoord)*mod->shapes[i].shapes[j].nverts);
		gl_free(mod->shapes[i].shapes[j].verts);
		gl_free(mod->shapes[i].shapes[j].texcoords);
	    }
	}
	gl_free(mod->shapes[i].shapes);
    }
}


static int LoadModel(const char* fname) 
{
       
       
    int i;

    
    for (i=0;i<nmodels;i++) {
	if (!strcmp(models[i]->name,fname)) {
	    return i;
	}
    }
    if (!nmodels) {
	models=(model*)gl_malloc(8*sizeof(model));
    } else if (!(nmodels&7)) {
	//models=(model*)realloc(models,(nmodels+8)*sizeof(model));
	models=(model*)gl_remalloc(models,(nmodels+8)*sizeof(model));

	
    }

	//   MAKEBUF(sname,64,"%s/%s",GLPath,fname);
	char sname[256]; 
	sprintf(sname,"%s\\%s",GLPath,fname);

    FILE* f=fopen(sname,"r");
    if (!f) {
		Error("Could not load model file %s: %s\n",fname,strerror(errno));
		return 0;//bna++148
    }
    yyparm_t parm;
    model tmp;
    parm.ret=&tmp;
    parm.getc=filegetc;
    parm.ungetc=fileungetc;
    parm.getcparm=f;

    yyparse(&parm);

    compile_model(&tmp,&models[nmodels]);
    .name=strdup(fname);
    nmodels++;
    return &models[nmodels-1];
}
#else
#define SwapIntelNone(X)
 
#define READER(name,type,converter,size) 	\
type read_##name(FILE* fil) {			\
    type t;					\
    fread(&t,size,1,fil);			\
    SwapIntel##converter(&t);			\
    return t;					\
}

READER(ushort, short,Short,2);
READER(short,short,Short,2);
READER(ulong, long,Long,4);
READER(long,long,Long,4);

READER(double,double,None,8);

static model* LoadModel(const char* fname) 
{
    int i,j;

	char md2name[256];  
	char fnametmp[256];  
    char*ptr;//md2fix

	lstrcpy(fnametmp,fname);

	
	//check if its a md2 entry
	memset(md2name,0,sizeof(md2name));//md2fix
	ptr = strstr(fnametmp,":");//md2fix
	if (ptr != 0){//md2fix
		//yes its a md2 model
		lstrcpy(md2name,ptr+1);
		*ptr = 0;//cut of the md2 name and load dummy entry tmd
	} 
    
    
	for (i=0;i<nmodels;i++) {
		if(models[i]>0){
		if (!strcmp(models[i]->name,fnametmp)) {
			return models[i];
		}
		}
    }
    if (!nmodels) {
		models=(model**)gl_malloc(8*sizeof(model*));

    } else if (!(nmodels&7)) {
		//models=(model**)gl_remalloc((nmodels+8)*sizeof(model*));
		//models=(model**)realloc(models,(nmodels+8)*sizeof(model*));
		models=(model**)gl_remalloc((model**)models,(nmodels+8)*sizeof(model*) );

    }

	//  MAKEBUF(sname,64,"%s/%s",GLPath,fname);
	char sname[256]; char vname[256];
	sprintf(sname,"%s\\%s",GLPath,fnametmp);


    FILE* fil = fopen(sname,"rb");
    if (!fil) {
		//Error("Could not load model file %s: %s\n", fnametmp, strerror(errno));
		sprintf(vname, "Could not load MODEL file %s:.\n\rCheck 'No models' in graphics settings to run without models.                        ", sname);
		//Error("Could not load MODEL file from 'GL' folder %s: %s\n", fnametmp, strerror(errno));
		MessageBox(NULL, vname, "ERROR", MB_OK | MB_ICONERROR);
		ExitWinRott();
		return 0;//bna++148
    }
    char buf[64];
    fread(buf,4,1,fil);
    buf[4]=0;
    if (memcmp(buf,"SMDL",4)) {
		Error("File %s: invalid sig %s\n",fnametmp,buf);
		return 0;//bna++148
    }
    model *cur=(model*)gl_malloc(sizeof(model));
    models[nmodels]=cur;
    cur->flags=read_ulong(fil);
    cur->px=read_double(fil);
    cur->py=read_double(fil);
    cur->pz=read_double(fil);
    
    //cur->name=strdup(fname);
 
   	cur->name = (char*)gl_malloc( 264);//md2fix
	//_strdup(fname);
	lstrcpy(cur->name, fnametmp);
	if (md2name[0] != 0)//md2fix
		lstrcpy(cur->name, md2name);//md2fix

    
    for (i=0;i<4;i++) {
	shape_list* csl=&cur->shapes[i];
	csl->nverts=read_ulong(fil);
	m_vertex* cvt = csl->vertlist = (m_vertex*)gl_malloc(csl->nverts*sizeof(m_vertex));
	m_texcoord* ctc = csl->texcoords = (m_texcoord*)gl_malloc(csl->nverts*sizeof(m_texcoord));
	for (j=0;j<csl->nverts;j++,cvt++) {
	    cvt->x=read_double(fil);
	    cvt->y=read_double(fil);
	    cvt->z=read_double(fil);
	}
	for (j=0;j<csl->nverts;j++,ctc++) {
	    ctc->x=read_double(fil);
	    ctc->y=read_double(fil);
	}
	csl->nshapes=read_ulong(fil);
	shape *csh= csl->shapes = (shape*)gl_malloc(csl->nshapes*sizeof(shape));
	for (j=0;j<csl->nshapes;j++,csh++) {
	    csh->type=fgetc(fil);
	    int strlen=read_ushort(fil);
	    fread(buf,1,strlen,fil);
	    buf[strlen]=0;
	    csh->tex=LoadSkin(buf)->tex;
	    csh->flags=read_ushort(fil);
	    csh->vertindex=read_ulong(fil);
	    csh->nverts=read_ulong(fil);
	}
    }
    fclose(fil);
    nmodels++;
    return cur; 
}









#endif
void LoadSky (int which)
{
    char buf[32];
    int i;
    printf ("Loading sky %d\n", which);
#if (KEEP_SKYS == 1)
    if (skytex[which][0])
	return;
#else
    if (lastsky==which)
	return;
    for (i = 0; i < 6; i++) {
		glDeleteTextures(1,(const GLuint*)&skytex[i]);
    }
    lastsky=which;
#endif
    for (i = 0; i < 6; i++) {
	sprintf (buf, "sky%d%d.png",which + 1, i + 1);
#if (KEEP_SKYS == 1)
	skytex[which][i] = LoadImgToTexture (buf,0,0);
#else
	skytex[i] = LoadImgToTexture (buf,0,0);
	if (skytex[i] < 0) {
		byte* skybuffer;//bna++ 1.76
		int size = LoadResourceToFixedMem("PNG", 260 + 1, (void**)&skybuffer);
		SDL_RWops* rw = SDL_RWFromMem(skybuffer, size);
		SDL_Surface* temp = IMG_Load_RW(rw, 1);
		GLuint ret;
		glGenTextures(1, &ret);
		UploadSurfaceToTexture(ret, temp, 0, 0, NULL, NULL);
		SDL_FreeSurface(temp);
		skytex[i] = ret;
	}



#endif
    }
}


void GLCalcShroomHue();
static int onesave = 0;

void GLInit (void)
{
	char line[256];
	char texname[16];
	char palname[16];
	char* tstream;
	int i,pcol,num,xx;

    
//    float fl;
	BOOL bexit;
	char *ptr;


    screenbufferwidth = 320;
    screenbufferheight = 200;

	g_start_of_playertexture = W_GetNumForName("CASSHO11");//user for multiplayer
	g_stop_of_playertexture = W_GetNumForName("IPFWDEAD"); 


	iTP1SHAPENB = W_GetNumForName ("TP1");
	//InitMD3();


    WriteLBtext("Entering InitMD2");
    InitMD2 ();//md2fix
    WriteLBtext("Exit InitMD2");
  for (xx=0; xx< sizeof(IsGCached); xx++){
	IsGCached[xx][0] = 0;
  }
    
#ifdef ONETEX
    glGenTextures (1, &screenbuffertexture);
#else
    glGenTextures (48, screenbuffertextures);
#endif
    WriteLBtext("gl_malloc");
    screenbuffer = (unsigned char*)gl_malloc (screenbufferwidth * screenbufferheight*4);
    //screenratio=glscreenh/(double)glscreenw;

    int gl_numlumps = W_NumLumps();
    WriteLBtext("gl_numlumps");
	//bna++146
	//create a keypicture in all 4 colors and 16 pictures
    lumpkeyinfo = (gl_lumpinfo_t*) gl_malloc((5*16*10)*sizeof(gl_lumpinfo_t));
	//bna++146
    WriteLBtext("gl_lumpinfo_t");
    lumpinfo = (gl_lumpinfo_t*) gl_malloc(gl_numlumps*sizeof(gl_lumpinfo_t));

    WriteLBtext("texauxinfo_t");
    texauxinfo = (texauxinfo_t*) gl_malloc(gl_numlumps*sizeof(texauxinfo_t));

    WriteLBtext("gl_malloc lumpinfo");

  	memset(lumpinfo,0,sizeof(lumpinfo));
	memset(texauxinfo,0,sizeof(texauxinfo_t));
  	memset(lumpkeyinfo,0,(5*16)*sizeof(gl_lumpinfo_t));
    WriteLBtext("GetModuleFileName");
	//get application path
	GetModuleFileName( NULL, szAppPath, sizeof(szAppPath) );
	//cut of filename from path
	*( strrchr( szAppPath, '\\' )) = '\0'; 
	lstrcat(szAppPath,"\\gl");
	GLPath = szAppPath;

	//for test and debug purposes, else comment it out
	//lstrcpy(GLPath,"C:\\WinRott_GL\\WinRott_GL\\gl");

    char* trat=getenv("ROTTGL_RATIO");
    int ratnum,ratdenom;
    if (trat && sscanf(trat,"%d:%d",&ratnum,&ratdenom)==2) {
	   screenratio=(double)ratdenom/(double)ratnum; //ratio is inverse
    } else screenratio=0.75;
    WriteLBtext("ROTTGL_TEXMODE");
    char* tmode=getenv("ROTTGL_TEXMODE");
    if (tmode) {
    	int mode=atoi(tmode);
    	if (mode>5 || mode<0) {
    	    fprintf (stderr, "Error: invalid mode %d\n",mode);
            WriteDebug("Error: invalid mode %d\n",mode);
    	    SDL_Quit ();
    	    exit(-1);
    	}
    	fullfilter = minfilters[mode];
    	partialfilter = magfilters[mode];
    }
    //bna added
    if ((gltexmode >= 0) && (gltexmode <= 5)){
    	fullfilter = minfilters[gltexmode];
    	partialfilter = magfilters[gltexmode];                  
    }
    
    
    WriteLBtext("ROTTGL_COMPAT");
    char* tcomp=getenv("ROTTGL_COMPAT");
    if (tcomp) {
	   compat=atoi(tcomp);
    }

	Uint8 *pal;
	pal = (Uint8 *) W_CacheLumpName ("ap_pal", PU_CACHE, CvtNull, 1);
	convertpal (pal, apogeepal, 0);

	pal = (Uint8 *) W_CacheLumpName ("pal", PU_CACHE, CvtNull, 1);
	convertpal (pal, gampal, 0);


    memset (lumpinfo, 0, sizeof (lumpinfo));
    memset (texauxinfo, 0, sizeof (texauxinfo));
//    int j;
    char buf[264];
    sprintf(buf,"%s\\trans.ifo",GLPath);
    WriteLBtext("Loading trans.ifo");
    FILE *fil = fopen (buf, "r");
    if (!fil) {
    	sprintf (line, "Error with transition file: %s     \n  (%s)",
    		 strerror (errno),buf);
  	    WriteDebug(line,0);	 
    	SDL_Quit ();
		MessageBox(NULL,line,"WinRottGl",MB_ICONSTOP | MB_OK);
    	exit(-1);
    }

	while (1) {
		char texname1[16], rtopname[16], rbotname[16], rleftname[16],
			rrightname[16];
		char *topname, *botname, *leftname, *rightname;
		int num1;//, top, bot, left, right;
		int i1 =
			fscanf (fil, "%s %s %s %s %s\n", texname1, rtopname, rbotname,
				rleftname, rrightname);
		topname = rtopname;
		botname = rbotname;
		leftname = rleftname;
		rightname = rrightname;
		if (i1 < 5)
			break;
		num1 = W_GetNumForName (texname1);
		if (topname[0] == '!') {
			topname++;
			texauxinfo[num1].trans[0] |= 0x8000;
		}
		if (botname[0] == '!') {
			botname++;
			texauxinfo[num1].trans[1] |= 0x8000;
		}
		if (leftname[0] == '!') {
			leftname++;
			texauxinfo[num1].trans[2] |= 0x8000;
		}
		if (rightname[0] == '!') {
			rightname++;
			texauxinfo[num1].trans[3] |= 0x8000;
		}
		if (topname[0] == '@') {
			topname++;
			texauxinfo[num1].trans[0] |= 0x4000;
		}
		if (botname[0] == '@') {
			botname++;
			texauxinfo[num1].trans[1] |= 0x4000;
		}
		if (leftname[0] == '@') {
			leftname++;
			texauxinfo[num1].trans[2] |= 0x4000;
		}
		if (rightname[0] == '@') {
			rightname++;
			texauxinfo[num1].trans[3] |= 0x4000;
		}

		texauxinfo[num1].transused = 1;
		texauxinfo[num1].trans[0] |=
			topname[0] == '~' ? 0 : W_GetNumForName (topname);
		texauxinfo[num1].trans[1] |=
			botname[0] == '~' ? 0 : W_GetNumForName (botname);
		texauxinfo[num1].trans[2] |=
			leftname[0] == '~' ? 0 : W_GetNumForName (leftname);
		texauxinfo[num1].trans[3] |=
			rightname[0] == '~' ? 0 : W_GetNumForName (rightname);

	}
    fclose (fil);

    sprintf(buf,"%s\\colors.ifo",GLPath);
    WriteLBtext("Loading colors.ifo");
    fil = fopen (buf, "r");
    if (!fil) {
    	fprintf (stderr, "Error with color file: %s\n",
    		 strerror (errno));
  	    WriteDebug("Error with color file: %s\n",(int)strerror (errno));		 
    	SDL_Quit ();
    	exit(-1);
    }

  	while (1) {
		//#define mscanf(str,fmt,...) ({ 
		//	int _nchar; 
		//	int _ret=sscanf((str),
		//		"%s %s",
		//		texname, palname,
		//		&_nchar); 
		//	(str) += _nchar; 
		//	_ret; })
		
		//SetTextMode ();//bnaset	
		if (!fgets(line,255,fil)) 
			break;
		tstream=line;
		//i=mscanf (tstream,"%s %s", texname, palname);
		i = sscanf (tstream,"%s %s", texname, palname);
		tstream += lstrlen(texname) + lstrlen(palname) + 1;
		if (*tstream == ' ')
			tstream++;
		if (i < 2) 
			break;
		//printf("line=%s Texname=%s\n",line,texname);
		num = W_GetNumForName (texname);
		if (num != -1){
			if (strcmp(palname,"~")) {
				int palnum = W_GetNumForName(palname);
				texauxinfo[num].pal = ReadPalette(palnum);
			}
			while (1) {
				char tmx[24];
				if (*tstream == ' ')
					tstream++;
				i = sscanf (tstream,"%d", &pcol );
				//i=mscanf (tstream,"%d", &col);
				if (i < 1) 
					break;
				sprintf(tmx,"%d",pcol);
				tstream += lstrlen(tmx);
				texauxinfo[num].colorsused[pcol]=1;
			}
		}
		//fclose(tstream);
    }
    fclose(fil);
    for (i = 0; i < 256; i++) {
    	onediv[i] = 1.0 / (double)i;
    	identity[i] = i;
    }

    int yy = 0;
    /*for(i=0;i<16;i++) {
       double iscl=(1.0-sqrt(i/15.0))*8.0;
       printf("Light rate %d: %f\n",i,iscl); */
    for (xx = 0; xx < LIGHTRAD; xx++) {
		for (yy = 0; yy < LIGHTRAD; yy++) {
			double dx = (double)(xx - LIGHTOFS) / 8.0;
			double dy = (double)(yy - LIGHTOFS) / 8.0;
			double dist = sqrt (dx * dx + dy * dy);
			/*if (dist > 1.0)
			dist = 1.0;*/
			stdlight[xx + (yy << 5)] = exp(-dist);
		}
    }
    glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    glAlphaFunc(GL_GEQUAL,0.5);
    glTexEnvf (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
    for (i = 0; i < 32; i++) {
	    shrooms[i].hue=6.0*(i/32.0);
    }
    GLCalcShroomHue();
    int invtex=LoadImgToTexture("invalid.png",1,20);
    for (i=0;i<MAXPLAYERCOLORS+1;i++) {
	invalid.tex.texnum[i]=invtex;
    }
    invalid.tex.lofs=0;
    invalid.tex.tofs=0;
    invalid.tex.tcxl=0;
    invalid.tex.tcyl=0;
    invalid.tex.tcxh=1;
    invalid.tex.tcyh=1;
    invalid.tex.osize=64;

    //}
    /*int ttex;
       glGenTextures(1,&ttex);
       SDL_Surface* tmp=IMG_Load("precache.png");
       UploadSurfaceToTexture(ttex,tmp);
       SDL_FreeSurface(tmp);
       glEnable(GL_BLEND);
       glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
       //else {
       //  glAlphaFunc(GL_GEQUAL,0.99);
       //  glEnable(GL_ALPHA_TEST);
       // }
       glEnable(GL_TEXTURE_2D);
       glDisable(GL_DEPTH_TEST);

       glTexEnvf(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_MODULATE);
       glMatrixMode(GL_PROJECTION);
       glLoadIdentity();
       gluOrtho2D(0.0, 640.0, 0.0, 480.0);
       glMatrixMode(GL_MODELVIEW);
       glLoadIdentity();

       BindTex(ttex);
       glBegin(GL_QUADS);
       glTexCoord2f(0.0,1.0);
       glVertex3i(0,0,0);
       glTexCoord2f(1.0,1.0);
       glVertex3i(640,0,0);
       glTexCoord2f(1.0,0.0);
       glVertex3i(640,480,0);
       glTexCoord2f(0.0,0.0);
       glVertex3i(0,480,0);
       glEnd();

       SDL_GL_SwapBuffers(); */

    Uint32 begin = SDL_GetTicks ();
    memset (skytex, 0, sizeof (skytex));
    for (i = 0; i < 17; i++) {
		sprintf (buf, "cat%d.png", i);
		catwalk[i] = LoadImgToTexture (buf,0,20);
    }

	if (modemgame == true || networkgame == true) {//bna++ 1.78
		compat = 0xFFFFFFFF;//dont use models in multiplayer
	}
	 
      if (!NO_MODELS) {
        WriteLBtext("Loading model.ifo");  
		sprintf(buf,"%s\\model.ifo",GLPath);
		fil=fopen(buf,"r");
		if (fil) {
			while (1) {
				int i2;
		//		int modn;
				char fname[256];//md2fix
				char lbuf[1024];//md2fix
				int lumpnum = 0;
				char tvbuf[64];


				//first letter has to be between 0 and 9 else skip it
				bexit = FALSE;
				do{
newline:;
					lumpnum = 0;
					fgets(lbuf,sizeof(lbuf),fil);
					//do we have a lumpnb or name
					if ((*(lbuf)=='/')&&(*(lbuf+1)=='/')){
						*lbuf = 0;
						goto newline;
					}
					i2 = atol(lbuf);
					if (i2 <= 0){
						GetLumpName (lbuf,tvbuf, 64);
						lumpnum = W_GetNumForName (tvbuf);
						bexit = TRUE;
					}
					if ((*lbuf >= '0')&&(*lbuf <= '9'))
						bexit = TRUE;
				}while ((bexit == FALSE)&&(feof(fil)==0));

				memset(fname,0,sizeof(fname));
				bexit = FALSE;
				ptr = strstr(lbuf,"/");
				if (ptr != 0)
					*ptr = 0;//cut of // text

				if (lumpnum <= 0){
					i2 = sscanf(lbuf, "%d %s", &lumpnum,fname);
#if (SHAREWARE == 1)		    
					lumpnum -= 302;//shareware version is 302 lumps smaller    	    
#endif				

					}
				else{	
					i2 = lstrlen(lbuf);
					char *ptr = strstr(lbuf," ");
					if (ptr != 0){
						memcpy(fname,ptr+1, i2 - (ptr-lbuf));
						i2 = 1;
					}else
						i2 = 0;
					//i2 = sscanf(lbuf+lstrlen(tvbuf)+1, "%s",fname);
					//scanf cuts of spaces in filenames
				}

				if (i2 >= 1)//data recived
				{
					lumpinfo[lumpnum].type = LT_MODEL;
					lumpinfo[lumpnum].mod  = LoadModel(fname);

				}
				if (feof(fil) != 0)
					break;

			//	i2 = fscanf (fil, "%d %s\n", &lumpnum,fname);
			//	if (i2 < 2)
			//		break;
			//	printf("Model %s for lump %d\n",fname,lumpnum);
			//	lumpinfo[lumpnum].type = LT_MODEL;
			//	lumpinfo[lumpnum].mod  = LoadModel(fname);
			
			}
		}
	}
//	  NOMODELEXIT:
    WriteLBtext("Loading npa.png");
	sprintf(buf,"%s/npa.png",GLPath);
    SDL_Surface* tsurf=IMG_Load(buf);
    if (!tsurf || tsurf->format->BytesPerPixel!=1) {
	   memset(savegamescreen,0,16000);
    } else {
    	unsigned char* spos=(unsigned char*)tsurf->pixels;;
    	int xx2,yy2;
    	for (yy2=0;yy2<100;yy2++) {
    	    for (xx2=0;xx2<160;xx2++) {
    		savegamescreen[xx2*100+yy2]=*spos++;
    	    }
    	}
    }


/*
    //skytex[1][0]=catwalk[0][0];
    WriteLBtext("Loading hswitch6");
    hswitch6=W_GetNumForName("hswitch6");
    
    WriteLBtext("Loading walls");    
    PrecacheGroup ("wall");
    
    WriteLBtext("Loading masks");       
    PrecacheGroup ("mask");
    
    WriteLBtext("Loading doors");    
    PrecacheGroup ("door");
    
    WriteLBtext("Loading exits");    
    PrecacheGroup ("exit");
    
    WriteLBtext("Loading sides");  
    PrecacheGroup ("side");
    
    WriteLBtext("Loading elevs");     
    PrecacheGroup ("elev");

	int start = W_GetNumForName ("FJUP0");
	int end = W_GetNumForName ("FJUP22");
	for (i = start; i <= end ; i++) {
		GetTexForLump (i, REPEAT_AUTO ,0);
	}
	start = W_GetNumForName ("PLATFRM1");
	end = W_GetNumForName ("PLATFRM4");
	for (i = start; i <= end ; i++) {
		GetTexForLump (i, REPEAT_AUTO ,0);
	}
	start = W_GetNumForName ("COOLGLO1");
	end = W_GetNumForName ("COOLGLO8");
	for (i = start; i <= end ; i++) {
		GetTexForLump (i, REPEAT_AUTO ,0);
	}
	i = W_GetNumForName ("PPOR1");
	GetTexForLump (i, REPEAT_AUTO ,0);
	i = W_GetNumForName ("SPRING1");
	GetTexForLump (i, REPEAT_AUTO ,0);

    WriteLBtext("Loading actors 1");   
		start = W_GetNumForName ("LWGSHOO1");
		end = W_GetNumForName ("LWGPAIN1");
		for (i = start; i < end ; i++) {
			GetTexForLump (i, REPEAT_AUTO ,0);
		}

    WriteLBtext("Loading actors 2");   
		start = W_GetNumForName ("LWGPAIN1");
		end = W_GetNumForName ("LIPEAD11");
		for (i = start; i < end ; i++) {
			GetTexForLump (i, REPEAT_AUTO ,0);
		}

    WriteLBtext("Loading actors 3"); 
		start = W_GetNumForName ("HG2SHOO1");
		end = W_GetNumForName ("HG2WDEAD");
		for (i = start; i < end ; i++) {
			GetTexForLump (i, REPEAT_AUTO ,0);
		}
    WriteLBtext("Loading guts"); 
		start = W_GetNumForName ("GUTS1");
		end = W_GetNumForName ("GEYE3");
		for (i = start; i < end ; i++) {
			GetTexForLump (i, REPEAT_AUTO ,0);
		}





	if (bUseExtPrecache == TRUE){
		GetTexForLump (W_GetNumForName ("TRITITL"), REPEAT_AUTO ,0);
		GetTexForLump (GFX_trilogo, REPEAT_AUTO ,0);

		WriteLBtext("Loading most used shapes");  
		start = W_GetNumForName ("WALL1");
		end = W_GetNumForName ("OBBOLO4");

		for (i = start; i <= end ; i++) {
			GetTexForLump (i, REPEAT_AUTO ,0);
		}
/*

		 start = W_GetNumForName ("PUSHCOL1");
		 end = W_GetNumForName ("ONEUP8");
		for (i = start; i <= end ; i++) {
			GetTexForLump (i, REPEAT_AUTO ,0);
		}

		 start = W_GetNumForName ("EXIT");
		 end = W_GetNumForName ("SIDE17");
		for (i = start; i <= end ; i++) {
			GetTexForLump (i, REPEAT_AUTO ,0);
		}

/*LIPEAD11
		start = W_GetNumForName ("LWGSHOO1");
		end = W_GetNumForName ("SKEL48");
		for (i = start; i < end ; i++) {
			GetTexForLump (i, REPEAT_AUTO ,0);
		}
	 
		start = W_GetNumForName ("HSWITCH1");
		end = W_GetNumForName ("HSWTCH14");
		for (i = start; i <= end ; i++) {
			GetTexForLump (i, REPEAT_AUTO ,0);
		}

		start = W_GetNumForName ("BLOODS1");
		end = W_GetNumForName ("GUNSMKE8");
		for (i = start; i <= end ; i++) {
			GetTexForLump (i, REPEAT_AUTO ,0);
		}
		

		i = W_GetNumForName ("ABOVEM4");
		GetTexForLump (i, REPEAT_AUTO ,0);
		i = W_GetNumForName ("ABOVEM4A");
		GetTexForLump (i, REPEAT_AUTO ,0);
		i = W_GetNumForName ("ABOVEM5");
		GetTexForLump (i, REPEAT_AUTO ,0);
		i = W_GetNumForName ("ABOVEM5A");
		GetTexForLump (i, REPEAT_AUTO ,0);
		i = W_GetNumForName ("ABOVEM5B");
		GetTexForLump (i, REPEAT_AUTO ,0);
		i = W_GetNumForName ("ABOVEM5C");
		GetTexForLump (i, REPEAT_AUTO ,0);
		i = W_GetNumForName ("ABOVEM9");
		GetTexForLump (i, REPEAT_AUTO ,0);

		i = W_GetNumForName ("ABOVEW3");
		GetTexForLump (i, REPEAT_AUTO ,0);
		i = W_GetNumForName ("ABOVEW16");
		GetTexForLump (i, REPEAT_AUTO ,0);
		i = W_GetNumForName ("ABOVEW17");
		GetTexForLump (i, REPEAT_AUTO ,0);
/*
		start = W_GetNumForName ("EXPLOS1");
		end = W_GetNumForName ("EXP20");
		for (i = start; i <= end ; i++) {
			GetTexForLump (i, REPEAT_AUTO ,0);
		}

		start = W_GetNumForName ("LIFE_A1");
		end = W_GetNumForName ("LIFE_D8");
		for (i = start; i <= end ; i++) {
			GetTexForLump (i, REPEAT_AUTO ,0);
		}

		start = W_GetNumForName ("KNIFE1");
		end = W_GetNumForName ("DOGPAW4");
		for (i = start; i <= end ; i++) {
			GetTexForLump (i, REPEAT_AUTO ,0);
		}

		start = W_GetNumForName ("GUNSMKE1");
		end = W_GetNumForName ("CREXP5");
		for (i = start; i <= end ; i++) {
			GetTexForLump (i, REPEAT_AUTO ,0);
		}

		start = W_GetNumForName ("GIBS1");
		end = W_GetNumForName ("POSTPIT");
		for (i = start; i <= end ; i++) {
			GetTexForLump (i, REPEAT_AUTO ,0);
		}

		start = W_GetNumForName ("FJUP0");
		end = W_GetNumForName ("FJUP22");
		for (i = start; i <= end ; i++) {
			GetTexForLump (i, REPEAT_AUTO ,0);
		}

		start = W_GetNumForName ("SPRING1");
		end = W_GetNumForName ("GEYE3");
		for (i = start; i <= end ; i++) {
			GetTexForLump (i, REPEAT_AUTO ,0);
		}


}*/
// ExtDrawPrecache();

    IsCrosshairLoaded = TRUE;
    WriteLBtext("Loading crosshairs");   
	if (CH_LoadCrosshair() == FALSE){
		//try once more in case we have written a def crosshair.ifo
		if (CH_LoadCrosshair() == FALSE){
			IsCrosshairLoaded = FALSE;
		}
	}
    
    
#if (SHAREWARE==0)
    //numlumps = 3892 
    if (onesave == 0){
       SaveFile ("lumpinfo_FL.dat",lumpinfo,3904*sizeof(gl_lumpinfo_t));
       SaveFile ("texauxinfo_FL.dat",texauxinfo,3904*sizeof(texauxinfo_t));
       onesave = 1;
    }
#else
    //numlumps = 2091
    if (onesave == 0){
       SaveFile ("lumpinfo_SW.dat",lumpinfo,2103*sizeof(gl_lumpinfo_t));
       SaveFile ("texauxinfo_SW.dat",texauxinfo,2103*sizeof(texauxinfo_t));
       onesave = 1;
    }
#endif
    
    
    
    //PrecacheGroup ("shap");
    Uint32 endt = SDL_GetTicks ();
    int time = endt - begin;
    printf ("%d ms to do precache\n", time);
    //glDeleteTextures(1,&ttex);
    WriteLBtext("checkGLStatus"); 
    checkGLStatus ();
    
    WriteLBtext("UploadOverlay"); 
    UploadOverlay ();
    
	GLDrawSky  ();


	iSpecELEV3 = W_GetNumForName("ELEV3");
	iSpecELEV4 = W_GetNumForName("ELEV4");
	iSpecELEV5 = W_GetNumForName("ELEV5");
	iSpecELEV6 = W_GetNumForName("ELEV6");
	iSpecELEV7 = W_GetNumForName("ELEV7");
	iSpecELEV8 = W_GetNumForName("ELEV8");
	iSpecWALL11 = W_GetNumForName("WALL11");
	iSpecWALL12 = W_GetNumForName("WALL12");
	iSpechswtch13 = W_GetNumForName("hswtch13");

}



static int last_fl=-1;

void GLSetupFog(int cfulllight, int usepos) 
{
    if (cfulllight==-1) {
		cfulllight=0;
	} else {
		if (cfulllight==last_fl)
			return;
    }
    last_fl=cfulllight;

    static GLfloat nofogc[4] = { 0.0, 1.0, 0.0, 0.0 };
    static GLfloat bfogc[4] = { 1.0, 1.0, 1.0, 0.25 };
    static GLfloat dfogc[4] = { 0.0, 0.0, 0.0, 0.25 };
    static GLfloat gfogc[4] = { 0.0, 1.0, 0.0, 0.5 };
    GLfloat gasfog[4];
    GLfloat *ofog;
	if ((fog || !(fulllight || cfulllight)) && usepos && MISCVARS->GASON != 1) {

		glEnable (GL_FOG);
		glFogi (GL_FOG_MODE, GL_LINEAR);
		double fogfact=1.0;
		if (lightning && lightninglevel>0) {
			fogfact=lightninglevel;
		}  
		if (fog){//bna++148
			glFogf (GL_FOG_START,-8000);//bna++148
			glFogf (GL_FOG_END, 28000);//bna++148
		}else{
			glFogf (GL_FOG_START, fognear*fogfact);
			glFogf (GL_FOG_END, fogfar*fogfact);
		}
		glFogfv (GL_FOG_COLOR, fog?bfogc:dfogc);
	} else if (MISCVARS->GASON == 1) {
		if (!usepos)
			return;
		double ostart, oend;
		if (fog || !fulllight) {
			ofog = fog?bfogc:dfogc;
			ostart = fognear;
			oend = fogfar;
		} else {
			ostart = NOFOGSTART;
			oend = NOFOGEND;
			ofog = nofogc;
		}
		double scl = (MISCVARS->gasindex / 15.0);
		int i;
		//printf("Gas fog for %d: ",MISCVARS->gasindex);
		for (i = 0; i < 4; i++) {
			gasfog[i] = (gfogc[i] - ofog[i]) * scl + ofog[i];
			//printf("%f ",gasfog[i]);
		}
		//printf("\n ");

		glEnable (GL_FOG);
		glFogi (GL_FOG_MODE, GL_LINEAR);
		glFogf (GL_FOG_START, ((GASFOGSTART - ostart) * scl) + ostart);
		glFogf (GL_FOG_END, ((GASFOGEND - oend) * scl) + oend);

		glFogfv (GL_FOG_COLOR, gasfog);
    } else
		glDisable (GL_FOG);
}

#define FRUSTOFFSET 0.7
static int dying=0;

int testt=0;

void GLSetupCamera (int usepos, double zoom)
{
    glMatrixMode (GL_PROJECTION);
    glLoadIdentity ();

    GLdouble xmin, xmax, ymin, ymax;
    xmax = -16.0 * zoom * (0.75/screenratio);
    xmin = -xmax;

    ymin = -16.0 * zoom * 0.75;
    ymax = -ymin;
    
    ymin += FRUSTOFFSET;
    ymax += FRUSTOFFSET;
    
    if (OLD_LOOKMODE && !dying) {
    	double ofs=(double)(centery-100)/ymax*1.5;
    	glFrustum (xmin, xmax, ymin+ofs, ymax+ofs, 16.0, 98304.0);
    	//printf("%d %0.6f %0.6f\n",centery,ymin,ymax);
    } else {
	  glFrustum (xmin, xmax, ymin, ymax, 16.0, 98304.0);
    }
    checkGLStatus ();

    glMatrixMode (GL_MODELVIEW);
    glLoadIdentity ();
    GLdouble vx, vy, vz;
    if (usepos) {
    	vwx = vx = viewx / 64.0;
    	vwy = vy = viewy / 64.0;
    	vwz = vz = ((((levelheight * 64) - pheight) * 16.0) * YCORRECTFACT);

	    //vz=1024;
    } else {
    	vx = 0;
    	vy = 0;
    	vz = 0;
    }
    double angrad;
    if (OLD_LOOKMODE && !dying) {
	angrad=0;
    } else { 
	angrad = lookangle / 1024.0 * M_PI;
    }
    double cosl = cos (angrad);
    double sinl = sin (angrad);
    double cosv = cos (-viewangle / 1024.0 * M_PI);
    double sinv = sin (-viewangle / 1024.0 * M_PI);

    double xo = cosl * cosv;
    double yo = cosl * sinv;

    double upx = 0, upy = 0, upz = 1;
    if (fabs (xo) < EPSILON && fabs (yo) < EPSILON) {
	upx = cosv;
	upy = sinv;
	upz = 0;
    }
    
    gluLookAt (vx + ShakeValX, vy + ShakeValY, vz+ ShakeValY, vx + xo + ShakeValX, vy + yo + ShakeValY, vz + sinl+ ShakeValY, upx + ShakeValX, upy + ShakeValY, upz+ ShakeValY);
      
    checkGLStatus ();
    GLSetupFog(-1,usepos);

}


 
static int ishsw13(maskedwallobj_t *tmwall) {
    //return 0;
#define iseither(x) (x==hsw13 || x==hsw14 || x==-1)
    int bot=tmwall->bottomtexture;
    int mid=tmwall->midtexture;
    int top=tmwall->toptexture;

    static int hsw13=0;
    static int hsw14=0;

    if (!hsw13) {
		hsw13=W_GetNumForName("hswtch13");
		hsw14=W_GetNumForName("hswtch14");
    }
    return (iseither(bot) && iseither(mid) && iseither(top));
#undef iseither
}


int StatRotate (statobj_t * stat);
int CalcRotate (objtype * ob);

#define A_HAS_PRIO -1
#define B_HAS_PRIO 1
int compare_visobj (const void *a, const void *b)
{
    double da ;
    double db ;

    int prioa=visprio[((glvisobj *) a)->type];
    int priob=visprio[((glvisobj *) b)->type];
    if (prioa<priob) return B_HAS_PRIO;
    if (prioa>priob) return A_HAS_PRIO;
    
     da = ((glvisobj *) a)->dist;
     db = ((glvisobj *) b)->dist;
    if (da > db)
		return -1;
    if (da < db)
		return 1;

    return ((int)b - (int)a);		// keep in the same order
}


void GLFixLightLevel ()
{
    double bright = sqrt(brightness / 7.0);
    double lrate =  lightrate / 15.0;
    double fograte = sqrt(lrate);
    double drate = lrate*lrate;
    //double drate = sqrt ( (lightrate / 15.0)) * 0.9 + 0.1;

    if (fog) {
    	fognear = NORMALFOGSTART * ((bright * 0.85) + 0.15);
    	fogfar = NORMALFOGEND * ((bright * 0.85) + 0.15);
    	ambientlight = 1.0;
    } else {
    	fognear = (NORMALFOGSTART * ((fograte * 0.85) + 0.15))*1.1;
    	fogfar = (NORMALFOGEND * ((fograte * 0.85) + 0.15))*1.1;
    	
    	ambientlight = ((bright * 0.85) + 0.15) * ((drate*0.25)+0.75);
        //stdlight=&stdlights[lightrate][0];
    }
}

void GLSetLightLevel (int fog1, int darkness)
{
     
    printf ("GLSetLightLevel, darkness=%d lightrate=%d\n", darkness,lightrate);
    brightness = darkness;	// ??
    GLFixLightLevel ();
}
void GLSetLightRate (int rate)
{
    printf ("GLSetLightLevel, rate=%d\n", rate);
    lightrate = rate;
    GLFixLightLevel ();
}

void GLSetLight (double x, double y, double alpha)
{
    double fact = InterpolateLight (x, y);
    glColor4d (fact, fact, fact, alpha);
}
void GLSetLightColor (double x, double y, double red, double green,
		      double blue, double alpha)
{

    double fact = InterpolateLight (x, y);
    glColor4d (fact * red, fact * green, fact * blue, alpha);
}








#define NO_VERTEX_ARRAYS
void DrawModel(glvisobj* vis, int stencil) {
    /*	    DrawModel(cvis->mod.mod,cvis->x,cvis->y,cvis->z,cvis->dist,cvis->ang,cvis->flags&GLV_FULLLIGHT,
	    cvis->flags&GLV_SHROOMFLASH?cvis->mod.id:-1,1);*/

    //void DrawModel(model* mod, double x, double y, double z, double dist, double angle, int f_light, int flashidx, int stencil) {
    int i,zzz;
    double x=vis->x;
    double y=vis->y;
    double z=vis->z;
    int flashidx=vis->flags&GLV_SHROOMFLASH?vis->mod.id:-1;
    z *= YCORRECTFACT;
    shape* crshape;
    m_vertex* cvert;
    m_texcoord* ctc;
//    m_color* ccol;
    //GLdouble* cvt, *ctc;
    // m_vertex verts[64];
    if (!stencil) {
	if (vis->flags&GLV_FULLLIGHT) {
	    if (flashidx==-1) {
		glColor3d(1,1,1);
	    } else {
		shroomrec* cshr=&shrooms[flashidx&31];
		glColor3d(cshr->r,cshr->g,cshr->b);
	    }
	} else {
	    if (flashidx==-1) {
		GLSetLight(x,y,1.0);
	    } else {
		shroomrec* cshr=&shrooms[flashidx&31];
		GLSetLightColor(x,y,cshr->r,cshr->g,cshr->b,1.0);
	    }
	}
    }

    int twoside=1;

    int ltp=-1;
    int ltx=-1;
    int qual=0;
    while (qual<NUMQUAL-1 && vis->dist<qualdist[qual]) qual++;
    
    shape_list* shl=&vis->mod.mod->shapes[qual];
    //printf("%d\n",qual);
    glMatrixMode(GL_MODELVIEW);
    glPushMatrix();

    double rotate=vis->ang;

    if (vis->mod.mod->flags&MOD_ROTATE) {
		rotate += GetTicCount()*3.0;
		//printf ("%f!\n",rotate);
    }
    glTranslated(x-vis->mod.mod->px,y-vis->mod.mod->py,z-vis->mod.mod->pz);
    if (rotate!=0) 
		glRotated(rotate,0,0,1);
    if (vis->vang!=0) 
		glRotated(vis->vang,0,1,0);

    glTranslated(vis->mod.mod->px,vis->mod.mod->py,vis->mod.mod->pz);

//double RAngle = 0;bna++152
//RAngle = GetMaskedWallDir ( x,  y);bna++152
//vis->ang=RAngle;bna++152

    if (MD2refresh ((unsigned int)vis->mod.id, vis->mod.mod->name,x,y,z,0)==1)
		return;
    
#ifndef NO_VERTEX_ARRAYS
    glEnableClientState(GL_VERTEX_ARRAY);
    glEnableClientState(GL_TEXTURE_COORD_ARRAY);
    glVertexPointer(3,GL_DOUBLE,sizeof(m_vertex),mod->shapes[qual].vertlist);
    glTexCoordPointer(2,GL_DOUBLE,sizeof(m_texcoord),mod->shapes[qual].texcoords);
#endif
    for(crshape=shl->shapes,i=0;i<shl->nshapes;i++,crshape++) {
	if ((crshape->flags&SHAPE_FLOORSTENCIL?1:0)!=stencil) continue;
	if (crshape->flags&(SHAPE_TWOSIDE|SHAPE_FLOORSTENCIL)) {
	    if (!twoside) glDisable(GL_CULL_FACE);
	    twoside=1;
	} else {
	    if (!twoside) glEnable(GL_CULL_FACE);
	    twoside=0;
	}
	if (!stencil && (unsigned)ltx!=crshape->tex) {
	    BindTex(crshape->tex);
	    ltx=crshape->tex;
	}

#ifndef NO_VERTEX_ARRAYS
	glDrawArrays(shape_types[crshape->type],crshape->vertindex,crshape->nverts);
#else
	cvert=&vis->mod.mod->shapes[qual].vertlist[crshape->vertindex];
	ctc=&vis->mod.mod->shapes[qual].texcoords[crshape->vertindex];
	glBegin(shape_types[crshape->type]);
	for (zzz=0;zzz<crshape->nverts;zzz++, cvert++, ctc++) {
	    glTexCoord2dv((GLdouble*)ctc);
	    glVertex3dv((GLdouble*)cvert);
	}
	glEnd();
#endif
    }
    glPopMatrix();
    glEnable(GL_CULL_FACE);


}

void DrawAWall (double x1, double y1, double x2, double y2, int *texes, double dimfact, int fulllight1)
{
    int z, zz;
    double zp1,zp2;
    int lwall;
    int runlen=0;
    double facta, factb;
    zz = 0;

    if (fulllight1) {
		facta=factb=1.0;
    } else {
		facta = InterpolateLight (x1, y1);
		factb = InterpolateLight (x2, y2);
		facta *= dimfact;
		factb *= dimfact;
    }

    if (x1==x2) {
		facta *= 0.75;
		factb *= 0.75;
    }

    zp1=0;
    z=0;
	while (1) {
		while ((z<levelheight)&&(texes[z]==0)) { 
			z++; 
			zp1 += (1024*YCORRECTFACT); 
		}
		if (z>=levelheight) 
			break;
		runlen=0;
		lwall=texes[z];
		zz=z;
		zp2=zp1;
		do { 
			z++; 
			runlen++; 
			zp2 += (1024*YCORRECTFACT); 
		} while ((z<levelheight)&&(texes[z]==lwall));

		BindTex( lwall);
		//printf("drawing, zp1=%f zp2=%f runlen=%d\n",zp1,zp2,runlen);
		glBegin (GL_QUADS);

		glColor3d(facta,facta,facta);
		glTexCoord2d(0.0,runlen);
		glVertex3d(x1,y1,zp1);

		glTexCoord2d(0.0,0.0);
		glVertex3d(x1,y1,zp2);

		glColor3d(factb,factb,factb);

		glTexCoord2d(1.0,0.0);
		glVertex3d(x2,y2,zp2);

		glTexCoord2d(1.0,runlen);
		glVertex3d(x2,y2,zp1);

		glEnd();
		zp1=zp2;
    }


}

double InterpolateLight (double x, double y)
{
    if (fulllight || ambientlight == 1.0)
	return 1.0;
    double rx = x * (1.0 / 512.0);
    double ry = y * (1.0 / 512.0);
    int lx = (int)rx;
    int ly = (int)ry;
    double lfx = rx - lx;
    double lfy = ry - ly;
    if (lfx == 0 && lfy == 0) {
	//printf("%f %f %f %f %f\n",rx,ry,lfx,lfy,lightamt[lx][ly]);
	return lightamt[lx][ly];
    }
    double ltxy = lightamt[lx][ly];
    double ltxY = lightamt[lx][ly + 1];
    double ltXy = lightamt[lx + 1][ly];
    double ltXY = lightamt[lx + 1][ly + 1];
    double lt1 = ((ltXy - ltxy) * lfx + ltxy);
    double lt2 = ((ltXY - ltxY) * lfx + ltxY);
    double ret = ((lt2 - lt1) * lfy + lt1);
    //printf("%f %f %f %f %f\n",rx,ry,lfx,lfy,ret);
    return ret;

}

void GLCalcLights ()
{
    if (fulllight || ambientlight == 1.0)
		return;
    double tempamb=ambientlight;

    if (lightninglevel > 0) {
		tempamb=ambientlight+(lightninglevel/15)*(1-ambientlight);
    }
    statobj_t *statptr;
//    objtype *obj;
    int x, y, xx, yy;
    for (xx = 0; xx < 256; xx++) {
	for (yy = 0; yy < 256; yy++) {
	    lightamt[xx][yy] = tempamb;
	}
    }
//    int id;
    for (statptr = firstactivestat; statptr; statptr = statptr->nextactive) {
	if ((statptr->shapenum) == NOTHING)
	    continue;
	if (statptr->flags & FL_LIGHT && statptr->flags & FL_LIGHTON) {
	    //printf("light at %d,%d\n",statptr->x,statptr->y);
	    int lsx = (statptr->x >> 15) - LIGHTOFS;
	    int lsy = (statptr->y >> 15) - LIGHTOFS;

	    for (x = lsx, xx = 0; xx < LIGHTRAD && x < 256; x++, xx++) {
		if (x < 0)
		    continue;
		for (y = lsy, yy = 0; yy < LIGHTRAD && y < 256; y++, yy++) {
		    if (y < 0)
			continue;
		    double c = lightamt[x][y];

		    c += (stdlight[xx + (yy << 5)] * (1.0 - tempamb));
		    if (c > 1.0)
				c = 1.0;
		    lightamt[x][y] = c;
		}
	    }
	}
    }
}
void DrawParallel(int tex, double xx, double yy, double zpos, double ww, double hh, double tc0, double tc1)
{
    BindTex( tex);
    glBegin (GL_QUADS);
    glTexCoord2f (tc0, tc0);
    GLSetLight (xx, yy, 1.0);
    glVertex3f (xx, yy, zpos);

    glTexCoord2f (tc1, tc0);
    GLSetLight (xx + ww, yy, 1.0);
    glVertex3f (xx + ww, yy, zpos);

    glTexCoord2f (tc1, tc1);
    GLSetLight (xx + ww, yy + hh, 1.0);
    glVertex3f (xx + ww, yy + hh, zpos);

    glTexCoord2f (tc0, tc1);
    GLSetLight (xx, yy + hh, 1.0);
    glVertex3f (xx, yy + hh, zpos);
    glEnd ();
}


int railingcnt = 0;
int railinginfo [128][128];

void GLCalcVisibleThings()
{
    statobj_t *statptr;
    objtype *obj;
    maskedwallobj_t *tmwall;
    doorobj_t *tdoor;
    double viewsin1 = sin (-viewangle / 1024.0 * M_PI);
    double viewcos1 = cos (-viewangle / 1024.0 * M_PI);
    glvisobj *cvis = visobjects;
    byte *visspot;
    unsigned short int *tilespot;
    nvisobjects = 0;
    int gx, gy, i;

    /* !CMASK */
	i = 0;
    BEGIN(total);




    BEGIN(mwall);
    for (tmwall = FIRSTMASKEDWALL; tmwall; tmwall = tmwall->next) {
		//if ((tmwall->next < tmwall)&&(tmwall->next>0))//bna++
		//	goto skiptmwall;//bna++
	if (spotvis[tmwall->tilex][tmwall->tiley]) {
	    mapseen[tmwall->tilex][tmwall->tiley] = 1;
	    cvis->type = GLV_MASKED;




	    if (!NO_FATBLOCK && tmwall->flags & MW_FATBLOCKING) {
			cvis->flags=0;
			cvis->type=GLV_BLOCKMASK;
			gx = (tmwall->tilex << 16);
			gy = (tmwall->tiley << 16);
			cvis->x = gx / 64.0;
			cvis->y = gy / 64.0;
			cvis->z = 0;
			cvis->dist=0;
			cvis->maskwall.btex = tmwall->bottomtexture;
			cvis->tex = tmwall->midtexture;
			cvis->maskwall.ttex = tmwall->toptexture;
	    } else if (tmwall->vertical) {
			gx = (tmwall->tilex << 16) + 0x8000;
			gy = (tmwall->tiley << 16);
			cvis->x = gx / 64.0;
			cvis->y = gy / 64.0;
			cvis->z = 0;
			cvis->flags = GLV_VERTICAL;
			cvis->maskwall.btex = tmwall->bottomtexture;
			cvis->tex = tmwall->midtexture;
			cvis->maskwall.ttex = tmwall->toptexture;
	    } else {
			gx = (tmwall->tilex << 16);
			gy = (tmwall->tiley << 16) + 0x8000;
			cvis->x = gx / 64.0;
			cvis->y = gy / 64.0;
			cvis->z = 0;
			cvis->flags = 0;
			cvis->maskwall.btex = tmwall->bottomtexture;
			cvis->tex = tmwall-> midtexture;
			cvis->maskwall.ttex = tmwall->toptexture;

	    }
	    if (tmwall->flags & FL_TRANSLUCENT) {
			//cvis->flags |= GLV_TRANS;
	    }



	    int tx=tmwall->tilex;
	    int ty=tmwall->tiley;
	    int iscatwalk =! NO_CATWALK && IS_TOP_CATWALK(tx,ty);
	    if (iscatwalk) {
			cvis->maskwall.ttex=-1;
	    } else if ((tmwall->flags & MW_TOPFLIPPING) && (nonbobpheight > 64)) {
			cvis->maskwall.ttex++;
	    } else if ((tmwall->flags & MW_BOTTOMFLIPPING)
		       && (nonbobpheight > maxheight - 32)) {
			cvis->maskwall.btex++;
	    }


	    cvis->dist = viewcos1 * (((tmwall->tilex << 16) + 0x4000) - viewx) +
					viewsin1 * (((tmwall->tiley << 16) + 0x4000) - viewy);

	    nvisobjects++;
	    cvis++;
	    if (iscatwalk) { // we have to add another object for the catwalk
			gx = (tmwall->tilex << 16);
			gy = (tmwall->tiley << 16);
			cvis->x = gx / 64.0;
			cvis->y = gy / 64.0;
			cvis->z = ((levelheight-1)*1024+64)*YCORRECTFACT;
			cvis->z += 50;//bna added - raise the catwalk a bit 
			cvis->type = GLV_CATWALK;
			cvis->dist=0;
			cvis->tex = (
					IS_TOP_CATWALK(tx-1, ty-1)  <<0 |
					IS_TOP_CATWALK(tx,   ty-1)  <<1 |
					IS_TOP_CATWALK(tx+1, ty-1)  <<2 |
					IS_TOP_CATWALK(tx-1, ty  )  <<3 |
					IS_TOP_CATWALK(tx+1, ty  )  <<4 |
					IS_TOP_CATWALK(tx-1, ty+1)  <<5 |
					IS_TOP_CATWALK(tx,   ty+1)  <<6 |
					IS_TOP_CATWALK(tx+1, ty+1)  <<7);

			nvisobjects++;
			cvis++;
		}


		/////////////////////bna added 154/////////////////////////////////////
		{ 
			int railingnb = W_GetNumForName ("RAILING");
			if (maskobjlist[_tile&0x3ff]->bottomtexture == railingnb){
			int tx=tmwall->tilex;
			int ty=tmwall->tiley;

			if (lumpinfo[tmwall->bottomtexture].type == LT_MODEL) {
				cvis->type = GLV_MODEL;
				gx = (tmwall->tilex << 16)+ 0x8000;
				gy = (tmwall->tiley << 16)+ 0x8000;
				cvis->x = gx / 64.0;
				cvis->y = gy / 64.0;
				cvis->z = (levelheight-1);  
				cvis->dist = 0;
				//cvis->maskwall.btex = tmwall->midtexture ;
				cvis->tex = tmwall->bottomtexture;
				//cvis->maskwall.ttex = tmwall->toptexture;
				//cvis->sprite.cmap = 0;
				//cvis->sprite.id = 0;
				if (railinginfo [tx][ty] == 0){
					SpawnNewObj (tmwall->tilex , tmwall->tiley,&s_basemarker1,inertobj);
					railinginfo [tx][ty] = (int)rnew;
					rnew->tilex = tmwall->tilex;
					rnew->tiley = tmwall->tiley;
					rnew->x = ((long)tmwall->tilex << TILESHIFT) + 0x8000;
					rnew->y = ((long)tmwall->tilex << TILESHIFT) + 0x8000;
					rnew->z = (levelheight-1);
					rnew->MD2pointer =  (int)0;//lumpinfo[tmwall->bottomtexture].mod;
					rnew->areanumber = tmwall->areanumber;
					rnew->shapenum = tmwall->bottomtexture;
					rnew->angle = 0;
					//cvis->vang = 0;
					cvis->ang = 0;
					if (tmwall->vertical == 1){
						cvis->ang = 90;
						rnew->angle = 90;
					}
					cvis->mod.mod = lumpinfo[tmwall->bottomtexture].mod;
					lstrcpy(rnew->md2Name,(*(((*cvis).mod).mod)).name);
					cvis->mod.id = (int)rnew;
				}else{
					cvis->ang = 0;
					if (tmwall->vertical == 1){
						cvis->ang = 90;
					}
					cvis->mod.id = (int)railinginfo [tx][ty];
					cvis->mod.mod = lumpinfo[tmwall->bottomtexture].mod;
				}
				nvisobjects++;
				cvis++;
			}
			}			

		}
		///////////////////////////////////////////////////////////////////////






	}
    }



    NREPORT(mwall,"Masked walls");
    BEGIN(door);
    /* !CDOOR */
    doorobj_t** cdoor=doorobjlist;
    for (i = 0; i < doornum; i++,cdoor++) {
	if (!(tdoor=*cdoor))
	    continue;
	if (spotvis[tdoor->tilex][tdoor->tiley]) {
	    cvis->type=GLV_MASKED;
	    if (tdoor->vertical) {
		gx = (tdoor->tilex << 16) + 0x8000;
		gy = (tdoor->tiley << 16);
		cvis->x = gx / 64.0;
		cvis->y = gy / 64.0;
		cvis->z = 0;
		cvis->type=GLV_MASKED;
		cvis->flags = GLV_VERTICAL;
		cvis->maskwall.btex = tdoor->texture;
		cvis->tex = tdoor->alttexture;
		cvis->maskwall.ttex = tdoor->alttexture;
	    } else {
		gx = (tdoor->tilex << 16);
		gy = (tdoor->tiley << 16) + 0x8000;
		cvis->x = gx / 64.0;
		cvis->y = gy / 64.0;
		cvis->z = 0;
		cvis->type = GLV_MASKED;
		cvis->flags = 0;
		cvis->maskwall.btex = tdoor->texture;
		cvis->tex = tdoor->alttexture;
		cvis->maskwall.ttex = tdoor->alttexture;

	    }

	    cvis->dist =
		viewcos1 * (((tdoor->tilex << 16) + 0x4000) - viewx) +
		viewsin1 * (((tdoor->tiley << 16) + 0x4000) - viewy);

	    nvisobjects++;
	    cvis++;
	}
    }

    NREPORT(door,"Doors");





    BEGIN(stats);
	for (statptr = firstactivestat; statptr; statptr = statptr->nextactive) {
		if (statptr->shapenum == NOTHING)
			continue;	
		cvis->flags = 0;		
		cvis->tex = statptr->shapenum;

		//bna++162 fix start
		//pressure plates aren't blinking. They stay fully visible.
		if ((statptr->itemnumber == stat_touch1)||(statptr->itemnumber == stat_touch2)||
			(statptr->itemnumber == stat_touch3)||(statptr->itemnumber == stat_touch4))
		{
			int tmptc = GetTicCount ();
			statptr->shapenum = iTP1SHAPENB - shapestart;
			if (statptr->lastdir == 0){//counting up
				if ((tmptc - statptr->isturning) > 10){
					statptr->isturning = tmptc;
					statptr->count++;
					if (statptr->count >= 3){
						statptr->lastdir = 1;
					}
				}
			}else{
				if ((tmptc - statptr->isturning) > 10){//counting down
					statptr->isturning = tmptc;
					statptr->count--;
					if (statptr->count <= 0){
						statptr->lastdir = 0;
					}		
				}
			}
			cvis->tex = statptr->shapenum + statptr->count;
		}  
		//bna++162 fix end


		//if ((cvis->tex = statptr->shapenum) == NOTHING)
		//	continue;


		cvis->type = GLV_SPRITE;

		cvis->sprite.id = statptr-((statobj_t*)0);

		cvis->sprite.cmap = 0;
		cvis->tex += shapestart;
		cvis->x = statptr->x / 64.0;
		cvis->y = statptr->y / 64.0;
		cvis->z = (((levelheight * 64) - statptr->z) * 16.0);

		/*if ((cvis->tex <= shapestart) ||
		(cvis->tex >= shapestop))
		Error("actor shapenum %d out of range (%d-%d)",cvis->tex,shapestart,shapestop); */

		visspot = statptr->visspot;
		if (!((*(visspot - 0)) ||
			(*(visspot - 1)) ||
			(*(visspot + 1)) ||
			(*(visspot - 129)) ||
			(*(visspot - 128)) ||
			(*(visspot - 127)) ||
			(*(visspot + 129)) ||
			(*(visspot + 128)) || (*(visspot + 127)))) {
			statptr->flags &= ~FL_VISIBLE;
			continue;		// not visible
		}
		cvis->dist =
			viewcos1 * (statptr->x - viewx) + viewsin1 * (statptr->y - viewy);
		statptr->flags |= FL_SEEN;

		statptr->flags |= FL_VISIBLE;

		if (statptr->flags & FL_FULLLIGHT)
			cvis->flags |= GLV_FULLLIGHT;

		if (statptr->flags & FL_ROTATING)
			cvis->tex += StatRotate (statptr);

		if (statptr->flags & FL_TRANSLUCENT) {
			if (statptr->flags & FL_FADING)
			cvis->flags |= GLV_TRANSFADE;
		}

	 
		if (statptr->flags & FL_COLORED) {
			//bna++146 keycolorfix
			if (statptr->itemnumber == stat_pedgoldkey)
				cvis->flags |= GLV_KEYCOLOR1;
			if (statptr->itemnumber == stat_pedsilverkey)
				cvis->flags |= GLV_KEYCOLOR2;
			if (statptr->itemnumber == stat_pedironkey)
				cvis->flags |= GLV_KEYCOLOR3;
			if (statptr->itemnumber == stat_pedcrystalkey)
				cvis->flags |= GLV_KEYCOLOR4;
			//bna++146 keycolorfix end
			//cvis->sprite.cmap = statptr->hitpoints + 1;
		}

		if (statptr->itemnumber != (unsigned int)-1) {
			if (lumpinfo[statptr->shapenum+shapestart].type==LT_MODEL) {
			cvis->type = GLV_MODEL;
			cvis->mod.mod=lumpinfo[statptr->shapenum+shapestart].mod;
			
			//check if its a md2 model
			if (cvis->mod.mod == 0)//bna++148
				continue;//bna++148
			if (strchr(cvis->mod.mod->name,'|') != 0)
				cvis->mod.id = (int)statptr;
			else
				cvis->mod.id = statptr -((statobj_t*)0);		
			
			
	//		cvis->mod.id=statptr-((statobj_t*)0);//bna--
			cvis->ang=0;
			cvis->vang=0;
			//printf("Statmodel %s %f %f %f\n",cvis->mod.mod->name,cvis->x,cvis->y,cvis->z);
			} else if (statptr->flags & FL_HEIGHTFLIPPABLE) {
			if (statptr->itemnumber == stat_disk) {
				int value;
				value = nonbobpheight - statptr->z - 32;
				if ((value <= 72) && (value > 24)) {
				cvis->tex++;
				} else if ((value <= 24) && (value >= -24)) {
				cvis->tex += 2;
				} else if ((value < -24) && (value >= -72)) {
				cvis->tex += 3;
				} else if (value < -72) {
				cvis->tex += 4;
				}
			} else if ((nonbobpheight - statptr->z) < -16) {
				cvis->tex++;
			}
			}
		}
		nvisobjects++;
		cvis++;

    }
    NREPORT(stats,"Stats");







    BEGIN(objs);
    int nobjproc=0;
    int nobjvis=0;
    /* !COBJ */

	for (obj = firstactive; obj; obj = obj->nextactive) {
	nobjproc++;
	if (obj == player)
	    continue;
	cvis->type=GLV_SPRITE;

	if ((cvis->tex = obj->shapenum) == NOTHING)
	    continue;		// no shape

	cvis->tex += shapestart;
	//if ((cvis->tex <= shapestart) ||
	  // (cvis->tex >= shapestop))
	   //Error("actor shapenum %d out of range (%d-%d)",cvis->tex,shapestart,shapestop);
	visspot = &spotvis[obj->tilex][obj->tiley];
	tilespot = &tilemap[obj->tilex][obj->tiley];

	//
	// could be in any of the nine surrounding tiles
	//
	if (*visspot || (*(visspot - 1))
	    || (*(visspot + 1))
	    || (*(visspot - 129))
	    || (*(visspot - 128))
	    || (*(visspot - 127))
	    || (*(visspot + 129))
	    || (*(visspot + 128))
	    || (*(visspot + 127))) {

	    //        result = TransformObject (obj->drawx, obj->drawy,&(visptr->viewx),&(visptr->viewheight));
	    nobjvis++;
	    cvis->sprite.cmap = 0;
	    cvis->x = obj->x / 64.0;
	    cvis->y = obj->y / 64.0;
	    cvis->z = (((levelheight * 64) - obj->z) * 16.0);
		cvis->flags = 0;
	    cvis->dist = viewcos1 * (obj->x - viewx) + viewsin1 * (obj->y - viewy);
		if (obj->state != 0) {//this line bnaxxx 1.78
			if (obj->state->rotate) {
				cvis->tex += CalcRotate(obj);
			}
		}
		cvis->sprite.id = obj - ((objtype*)0);

		if (cvis->tex >= g_start_of_playertexture && cvis->tex <= g_stop_of_playertexture) {  // CASS1  bna++ 1.78 uniform color
			playertype* pstate;
			M_LINKSTATE(obj, pstate);
			cvis->sprite.cmap = pstate->uniformcolor;//store for later use
			cvis->flags = GLV_PLAYEROBJ;//only means that obj has a player text. could also be a bot
		}
	
	    //visptr->shapesize=0;
		//obj->flags |= FL_COLORED;

	    if (player->flags & FL_SHROOMS) {
			cvis->flags |= GLV_SHROOMFLASH;
	    }
	    if (obj->flags & FL_FULLLIGHT)
			cvis->flags |= GLV_FULLLIGHT;

		if (obj->obclass == playerobj) {
			if (obj->flags & FL_GODMODE) {
				cvis->flags |= GLV_SHROOMFLASH;
			} else if (obj->flags & FL_COLORED) {
				playertype *pstate;
// GLV_COLORED
				M_LINKSTATE (obj, pstate);
				cvis->sprite.cmap =  pstate->uniformcolor + 1;
			}		//else
			//SetSpriteLightLevel(obj->x,obj->y,visptr,obj->dir,(obj->flags&FL_FULLLIGHT));

		} else {
			if ((obj->obclass >= b_darianobj)
				&& (obj->obclass <= b_robobossobj)
				&& MISCVARS->redindex) {
				cvis->flags |= GLV_REDFLASH;
				// no-op: visptr->colormap=redmap+((MISCVARS->redindex-1)<<8);

			} else {

				// no-op: SetSpriteLightLevel(obj->x,obj->y,visptr,obj->dir,(obj->flags&FL_FULLLIGHT));
			}
	    }
#define HF_1 24
#define HF_2 72
	    if (lumpinfo[obj->shapenum+shapestart].type==LT_MODEL) {
		cvis->type=GLV_MODEL;		
		cvis->mod.mod=lumpinfo[obj->shapenum+shapestart].mod;
		
        //check if its a md2 model bna md2fix
		if (cvis->mod.mod == 0)//bna++148
			 continue;//bna++148
        if (strchr(cvis->mod.mod->name,'|') != 0)
           cvis->mod.id = (int)obj;
        else
            cvis->mod.id = obj -((objtype*)0);		
		

		//cvis->mod.id=obj-((objtype*)0);
		if (obj->state->rotate) {
		    if (cvis->mod.mod->flags&MOD_VERTROTATE) {
			//sqrt changed to sqrtl in 148 //bna++148
			double totmom=sqrtl(obj->momentumx*obj->momentumx+obj->momentumy*obj->momentumy+obj->momentumz*obj->momentumz);
			if (totmom!=0) {
			    double cs=obj->momentumz/totmom;
			    cvis->vang=-((acos(cs)*180/M_PI)-90);
			}
			cvis->ang=obj->angle*-(360.0/FINEANGLES);
		    }
		    //printf("%d\n",obj->yzangle);

		} else {
		    cvis->ang=0;
		    cvis->vang=0;
		}
	    } else if (obj->obclass == diskobj) { 
		int value;
		value = nonbobpheight - obj->z - 32;
		if ((value <= HF_2) && (value > HF_1)) {
		    cvis->tex++;
		} else if ((value <= HF_1) && (value >= -HF_1)) {
		    cvis->tex += 2;
		} else if ((value < -HF_1) && (value >= -HF_2)) {
		    cvis->tex += 3;
		} else if (value < -HF_2) {
		    cvis->tex += 4;
		}
	    } else if ((obj->obclass == pillarobj)
		       && ((nonbobpheight - obj->z) < -16)) {
		cvis->tex++;
	    }

	    obj->flags |= FL_SEEN;
	    obj->flags |= FL_VISIBLE;
	    cvis++;
	    nvisobjects++;
	} else {
	    obj->flags &= ~FL_VISIBLE;
	}
    }
//    NREPORT(objs,"Objects proc=%d vis=%d ",nobjproc,nobjvis);
    BEGIN(zsort);
    qsort (visobjects, nvisobjects, sizeof (glvisobj), compare_visobj);
    NREPORT(zsort,"Sort");
    //BEGIN(door);
    REPORT(total,"Calcvis Total");
}
void GLDrawStencilThings ()
{
    int i;
    glvisobj *cvis = visobjects;
    SetDrawMode(GLV_MODEL);
    glStencilFunc(GL_NEVER,1,1);
    glStencilOp(GL_REPLACE,GL_REPLACE,GL_REPLACE);
    glDepthMask(0);
    glStencilMask(1);
    glEnable(GL_STENCIL_TEST);
    glDisable(GL_TEXTURE_2D);
    for (i = 0; i < nvisobjects; i++, cvis++) {
		if (cvis->type == GLV_MODEL) {
			DrawModel(cvis,1);
		}
    }
    glStencilOp(GL_KEEP,GL_KEEP,GL_KEEP);
    glDepthMask(1);
}

int cnt = 0;

void GLDrawFlatThings ()
{
    //printf("%d\n",nvisobjects);
    glvisobj *cvis = visobjects;
    int i,j,z;

    double viewsin2 = sin (-viewangle / 1024.0 * M_PI);
    double viewcos2 = cos (-viewangle / 1024.0 * M_PI);

    GLdouble x1, y1, x2, y2, z1, z2;
//    double xoff, yoff;
    gl_lumpinfo_t* tex;
	gl_lumpinfo_t* tex2;
    int texn, lmp;
//    double tcxh;
//    double tcyl, tcyh;
    int texes[16];


    /*
     *
     * DMASK
     *
     */



	for (i = 0; i < nvisobjects; i++, cvis++) {
		SetDrawMode(cvis->type);
		GLSetupFog(cvis->flags&GLV_FULLLIGHT?1:0,1);
		switch (cvis->type) {
		case GLV_CATWALK:
			//glAlphaFunc(GL_GEQUAL,0.9);

			for (j=0;j<4;j++) {
				int xp = cvis->x + ( (j&1) << 9);
				int yp = cvis->y + ( (j&2) << 8);
				int picofs =((cvis->tex>>catbits[j][0])&1)|((cvis->tex>>catbits[j][1])&1)<<1;
				int cpic = (j<<2)+picofs;
				if (picofs==3 && ((cvis->tex>>catbits[j][2])&1)) 
					cpic=16;
				DrawParallel(catwalk[cpic],xp,yp,cvis->z,512,512,0,1); 
			}

			//glAlphaFunc(GL_GEQUAL,0.5);

			break;
		case GLV_BLOCKMASK:
			//printf("%d\n",cvis->flags&GLV_FULLLIGHT?1:0);
			memset(texes,0,sizeof(texes));
			if (cvis->maskwall.btex != -1) {
			lmp = cvis->maskwall.btex;
			tex = GetTexForLump (lmp, REPEAT_AUTO ,0);
			texes[0] = tex->tex.texnum[0];
			}
			if (cvis->tex != -1) {
			lmp = cvis->tex;
			tex = GetTexForLump (lmp, REPEAT_AUTO ,0);
			for (j=1;j<levelheight-1;j++) {
				texes[j] = tex->tex.texnum[0];
			}
			}
			if (cvis->maskwall.ttex != -1) {
			lmp = cvis->maskwall.ttex;
			tex = GetTexForLump (lmp, REPEAT_AUTO ,0);
			texes[levelheight-1] = tex->tex.texnum[0];
			}

			x1 = cvis->x ;
			y1 = cvis->y ;

			glFrontFace(GL_CW);
			DrawAWall (x1, y1, x1, y1 + 1024, texes, 1.0, 0);
			DrawAWall (x1, y1 + 1024, x1 + 1024, y1 + 1024, texes, 1.0, 0);
			DrawAWall (x1 + 1024, y1 + 1024, x1 + 1024, y1, texes, 1.0, 0);
			DrawAWall (x1 + 1024, y1, x1, y1, texes, 1.0, 0);

			if (cvis->maskwall.ttex==-1 && cvis->tex!=-1) {
			lmp = cvis->tex;
			texn = GetTexForLump (lmp, REPEAT_AUTO ,0)->tex.texnum[0];
			DrawParallel(texn,cvis->x,cvis->y,(levelheight-1)*1024*YCORRECTFACT,1024,1024,0,1);
			}
			if (cvis->maskwall.btex!=-1 && cvis->tex==-1) {
			lmp = cvis->maskwall.btex;
			texn = GetTexForLump (lmp, REPEAT_AUTO ,0)->tex.texnum[0];
			DrawParallel(texn,cvis->x,cvis->y,1024*YCORRECTFACT,1024,1024,0,1);
			}
			glFrontFace(GL_CCW);

			if (cvis->maskwall.btex==-1 && cvis->tex!=-1) {
			lmp = cvis->tex;
			texn = GetTexForLump (lmp, REPEAT_AUTO ,0)->tex.texnum[0];
			DrawParallel(texn,cvis->x,cvis->y,1024*YCORRECTFACT,1024,1024,0,1);
			}
			if (cvis->maskwall.ttex!=-1 && cvis->tex==-1) {
			lmp = cvis->maskwall.ttex;
			texn = GetTexForLump (lmp, REPEAT_AUTO ,0)->tex.texnum[0];
			DrawParallel(texn,cvis->x,cvis->y,(levelheight-1)*1024*YCORRECTFACT,1024,1024,0,1);
			}


			//glDisable(GL_CULL_FACE);
			//glDepthMask(0);
			break;
		case GLV_MASKED:

			if (cvis->maskwall.btex != -1) {
			lmp = cvis->maskwall.btex;

			tex = GetTexForLump (lmp, REPEAT_AUTO ,0);
			x1 = cvis->x;
			y1 = cvis->y;
			z1 = 1024 - ((tex->tex.tofs) << 4);
			z2 = z1 - (tex->tex.h << 4);
			if (cvis->flags & GLV_VERTICAL) {
				x2 = x1;
				y1 += (tex->tex.lofs) << 4;
				y2 = y1 + (tex->tex.w << 4);
			} else {
				y2 = y1;
				x1 += (tex->tex.lofs) << 4;
				x2 = x1 + (tex->tex.w << 4);
			}
			BindTex( tex->tex.texnum[0]);
			checkGLStatus ();

			glBegin (GL_QUADS);
			//glColor3f(1.0,1.0,1.0);
			GLSetLight (x1, y1, 1.0);
			glTexCoord2f (tex->tex.tcxl, tex->tex.tcyh);
			glVertex3f (x1, y1, z2 * YCORRECTFACT);
			glTexCoord2f (tex->tex.tcxl, tex->tex.tcyl);
			glVertex3f (x1, y1, z1 * YCORRECTFACT);
			glTexCoord2f (tex->tex.tcxh, tex->tex.tcyl);
			GLSetLight (x2, y2, 1.0);
			glVertex3f (x2, y2, z1 * YCORRECTFACT);
			glTexCoord2f (tex->tex.tcxh, tex->tex.tcyh);
			glVertex3f (x2, y2, z2 * YCORRECTFACT);
			glEnd ();
			checkGLStatus ();
			}
			if (cvis->tex != -1 && levelheight > 1) {
			lmp = cvis->tex;
			tex = GetTexForLump (lmp, REPEAT_AUTO ,0);
			x1 = cvis->x;
			y1 = cvis->y;
			z1 = 1024 + (tex->tex.tofs << 4);
			z2 = z1 - (tex->tex.h << 4);
			if (cvis->flags & GLV_VERTICAL) {
				x2 = x1;
				y1 += (tex->tex.lofs) << 4;
				y2 = y1 + (tex->tex.w << 4);
			} else {
				y2 = y1;
				x1 += (tex->tex.lofs) << 4;
				x2 = x1 + (tex->tex.w << 4);
			}
			BindTex( tex->tex.texnum[0]);
			glBegin (GL_QUADS);
			int zz = 1024;
			for (z = 1; z < levelheight - 1; z++, zz += 1024) {
				GLSetLight (x1, y1, 1.0);
				glTexCoord2f (tex->tex.tcxl, tex->tex.tcyh);
				glVertex3f (x1, y1, (zz + z2) * YCORRECTFACT);
				glTexCoord2f (tex->tex.tcxl, tex->tex.tcyl);
				glVertex3f (x1, y1, (zz + z1) * YCORRECTFACT);
				GLSetLight (x2, y2, 1.0);
				glTexCoord2f (tex->tex.tcxh, tex->tex.tcyl);
				glVertex3f (x2, y2, (zz + z1) * YCORRECTFACT);
				glTexCoord2f (tex->tex.tcxh, tex->tex.tcyh);
				glVertex3f (x2, y2, (zz + z2) * YCORRECTFACT);
			}
			glEnd ();
			checkGLStatus ();
			}
			if (cvis->maskwall.ttex != -1 && levelheight > 1) {
			lmp = cvis->maskwall.ttex;
			tex = GetTexForLump (cvis->maskwall.ttex, REPEAT_AUTO ,0);
			x1 = cvis->x;
			y1 = cvis->y;
			z1 = 1024 + (tex->tex.tofs << 4);
			z2 = z1 - (tex->tex.h << 4);
			if (cvis->flags & GLV_VERTICAL) {
				x2 = x1;
				y1 += (tex->tex.lofs) << 4;
				y2 = y1 + (tex->tex.w << 4);
			} else {
				y2 = y1;
				x1 += (tex->tex.lofs) << 4;
				x2 = x1 + (tex->tex.w << 4);
			}
			BindTex( tex->tex.texnum[0]);
			glBegin (GL_QUADS);
			int zz = (levelheight - 1) * 1024;
			GLSetLight (x1, y1, 1.0);
			glTexCoord2f (tex->tex.tcxl, tex->tex.tcyh);
			glVertex3f (x1, y1, (zz + z2) * YCORRECTFACT);
			glTexCoord2f (tex->tex.tcxl, tex->tex.tcyl);
			glVertex3f (x1, y1, (zz + z1) * YCORRECTFACT);
			GLSetLight (x2, y2, 1.0);
			glTexCoord2f (tex->tex.tcxh, tex->tex.tcyl);
			glVertex3f (x2, y2, (zz + z1) * YCORRECTFACT);
			glTexCoord2f (tex->tex.tcxh, tex->tex.tcyh);
			glVertex3f (x2, y2, (zz + z2) * YCORRECTFACT);
			glEnd ();
			checkGLStatus ();
			}
			break;
		case GLV_MODEL:
			DrawModel(cvis,0);
			break;
		case GLV_SPRITE:
			{
			/*
			*
			* SPRITES
			*
			*/ 
	

			double ExtraAlpha = 1.0; 
			if (g_alpha_totalonoff != 0){//bna ++ 156	
				ExtraAlpha = CheckForExtraAlpha(cvis->tex);//bna++148
				if (ExtraAlpha < 0)
					ExtraAlpha = 1.0;
			}

			//bna++162 fix 
			//pressure plates aren't blinking. They stay fully visible. make em transparent
			char* explname = W_GetNameForNum (cvis->tex);
			if ((strstr(explname,"TP1")!=0)||(strstr(explname,"TP2")!=0)||
				(strstr(explname,"TP3")!=0)||(strstr(explname,"TP4")!=0))
				ExtraAlpha = 0.3;


			//-------------------------------------------------------------------------------------		
			//if its a netgame with playerobj, give them the correct uniform color bna++ 1.78
			//there was a gigant mem leak which disappears when caching player tex, why ?
			//cvis->tex = lump nb;   there is max 429 pictures of 5 different player characters
			if ( (cvis->tex >= g_start_of_playertexture && cvis->tex <= g_stop_of_playertexture)
					&&(cvis->flags & GLV_PLAYEROBJ) ) //flag given ealier when we stole the player obj color info
			{
					tex2 = IsTexCached[cvis->tex - g_start_of_playertexture][cvis->sprite.cmap];
					if (tex2 == 0) { //if no tex ready, cache one
						g_keycol = cvis->sprite.cmap  ;//g_keycol will force color in GetTexForLump
						IsGCached[cvis->tex][0] = 0;//make sure we get a new color update (does that if 0)
						tex2 = GetTexForLump(cvis->tex, 0, cvis->flags);
						//store tex data in IsTexCached
						IsTexCached[cvis->tex - g_start_of_playertexture][cvis->sprite.cmap] = tex2;//bna++ 1.78 uniform color
					}
					tex = tex2;//transfer new one to tex
			} else {
				//no player tex, just cont. with normal tex
				tex = GetTexForLump(cvis->tex, 0, cvis->flags);
			}
			//------------------------------------------------------------------------------------

			int lb = (tex->tex.osize >> 1) - tex->tex.lofs - tex->tex.w;
			int tb = tex->tex.tofs;
			int rb = lb + tex->tex.w;
			int bb = tb + tex->tex.h;
			double tcx = tex->tex.tcxh;
			double tcy = tex->tex.tcyh;
			/*double tcyl=onediv[tex->osize]*-tex->tex.tofs;
			double tcyh=onediv[tex->osize]*(-tex->tex.tofs+tex->tex.h); */
			double scl = onediv[tex->tex.osize] * 1024.0;

			/*int lb=-tex->osize>>1;//(tex->osize>>1)+tex->tex.lofs-tex->tex.w;
			int tb=0;
			int rb=lb+(tex->osize);
			int bb=tb+(tex->osize);
			double scl=onediv[tex->osize]*1024.0; */
			x1 = (cvis->x) + (lb * scl) * viewsin2;
			y1 = (cvis->y) + (lb * scl) * -viewcos2;
			x2 = (cvis->x) + (rb * scl) * viewsin2;
			y2 = (cvis->y) + (rb * scl) * -viewcos2;
			z1 = (cvis->z) + (-tb * scl);
			z2 = (cvis->z) + (-bb * scl);
			double redamt=(MISCVARS->redindex - 1)/15.0;

			double alpha=(cvis->flags&GLV_TRANSFADE?(transparentlevel/64.0):1.0);
			if (ExtraAlpha != 0)//bna++148
				alpha = ExtraAlpha;//bna++148

			shroomrec* cshr=&shrooms[cvis->sprite.id&31];
			if (cvis->sprite.cmap > 0 && !texauxinfo[cvis->tex].colorsused[cvis->sprite.cmap-1]) {
				printf("%s %d\n",W_GetNameForNum(cvis->tex),cvis->sprite.cmap-1);
			}
			BindTex( tex->tex.texnum[cvis->sprite.cmap]);

				if (cvis->flags & GLV_FULLLIGHT) {
				glBegin (GL_QUADS);

				if (cvis->flags & GLV_SHROOMFLASH) {
					glColor4d (cshr->r, cshr->g, cshr->b, alpha);
				} else if (cvis->flags & GLV_REDFLASH) {
					glColor4d (1.0, 1.0-redamt, 1.0-redamt,alpha);
				} else
					glColor4f (1.0, 1.0, 1.0, alpha);
				
				glTexCoord2f (tcx, 0);
				glVertex3f (x1, y1, z1 * YCORRECTFACT);

				glTexCoord2f (tcx, tcy);
				glVertex3f (x1, y1, z2 * YCORRECTFACT);

				glTexCoord2f (0, tcy);
				glVertex3f (x2, y2, z2 * YCORRECTFACT);

				glTexCoord2f (0, 0);
				glVertex3f (x2, y2, z1 * YCORRECTFACT);
				glEnd ();
			} else {
				if (cvis->flags & GLV_SHROOMFLASH) {
					GLSetLightColor (x1, y1, cshr->r, cshr->g, cshr->b, alpha);
				} else if (cvis->flags & GLV_REDFLASH) {
					GLSetLightColor (x1, y1, 1.0, 1.0-redamt, 1.0-redamt, alpha);
				} else
				GLSetLight (x1, y1, alpha);
				glBegin (GL_QUADS);
				glTexCoord2f (tcx, 0);
				glVertex3i (x1, y1, z1 * YCORRECTFACT);
				glTexCoord2f (tcx, tcy);
				glVertex3i (x1, y1, z2 * YCORRECTFACT);
				if (cvis->flags & GLV_SHROOMFLASH) {
				GLSetLightColor (x2, y2, cshr->r, cshr->g, cshr->b, alpha);
				} else if (cvis->flags & GLV_REDFLASH) {
					GLSetLightColor (x2, y2, 1.0, 1.0-redamt, 1.0-redamt, alpha);
				} else
				GLSetLight (x2, y2, alpha);
				glTexCoord2f (0, tcy);
				glVertex3i (x2, y2, z2 * YCORRECTFACT);

				glTexCoord2f (0, 0);
				glVertex3i (x2, y2, z1 * YCORRECTFACT);
				glEnd ();
			}
			checkGLStatus ();
			//glPopMatrix();
			}
		}
    }
}



int GetAnimTex (int tile)
{
    if (tile & 0x1000) {
	tile = animwalls[tile & 0x3ff].texture;
    } else {
	tile &= 0x3FF;
    }
    return tile;
}


double g_dimfact = 1;//bna++156
char cnddir = 0;

void DrawNormWall (wallent_t * wal)
{
    double x1, x2, y1, y2;

    x1 = wal->x << 10;
    y1 = wal->y << 10;
    int facx = wal->x;
    int facy = wal->y;
    double dimfact=1.0;

//if (wal->wall == 2)
//return;

    switch (wal->wall) {
    case 0:			/* West */
		x2 = x1;
		y2 = y1 + 1024;
		facx--;
		break;
    case 1:			/* East */
		x1 += 1024;
		x2 = x1;
		y2 = y1;
		y1 += 1024;
		facx++;
		break;
    case 2:			/* North */
		y2 = y1;
		x2 = x1;
		x1 += 1024;
		facy--;
		break;
    case 3:			/* South */
		y1 += 1024;
		y2 = y1;
		x2 = x1 + 1024;
		facy++;
		break;
    default:
		/* Can't happen. I hope. */
		x2 = x1;
		y2 = y1;
		break;
    }
    int texes[16];
    int dofl=0;
    int tile = tilemap[wal->x][wal->y];
    int alttile = -1;
    int tmp1, tmp2 = 0;

    if (tile&0x800) {
		//dimfact = ((gamestate.difficulty/3.0)*0.2)+0.8;bna--156
		if (iPulsPushwalls == TRUE){
			// make secret and pwalls pulsate
			if (cnddir == 0){
				g_dimfact -= 0.002;//bna++156
				if (g_dimfact <= 0.8)//bna++156
					cnddir = 1;
			}else{
				g_dimfact += 0.002;//bna++156
				if (g_dimfact >= 1.0)//bna++156
					cnddir = 0;
			}
			dimfact = g_dimfact;//bna++156
		}else{
			dimfact=((gamestate.difficulty/3.0)*0.2)+0.8;
		} 
    }


	if (tile & 0x4000) {
		tmp1 = tilemap[facx][facy];
		if (tmp1 & 0x8000) {
			if (tmp1 & 0x4000) {
				if ((tmp2 = maskobjlist[tmp1 & 0x3ff]->sidepic)) {//mwall
					tile = tmp2;
				} else {
					tile &= 0x3FF;
				}
			} else {
				tile = doorobjlist[tmp1 & 0x3ff]->sidepic;
			}
		} else {
			if (tile & 0x1000) {
				tile = animwalls[tile & 0x3ff].texture;
			} else {
				tile &= 0x3FF;
			}
		}
    } else if (tile & 0x2000) {
		alttile = (MAPSPOT (wal->x, wal->y, 2)) + 1;
		tile &= 0x3ff;
    } else {
		if (tile & 0x1000) {
			tile = animwalls[tile & 0x3ff].texture;
		} else {
			tile &= 0x3FF;
		}
    }

    int lump = tile & 0x3FF;

    if ((lump >= 127 && lump <= 132) ||	(lump >= 77 && lump <= 80))
		dofl = 1;

	if (MAPSPOT (wal->x, wal->y, 2) == 13) {
		glEnable (GL_BLEND);
		glDisable (GL_TEXTURE_2D);
		glBegin (GL_QUADS);
		glColor4f (0.0, 0.0, 0.0, 0.0);
		int z, zz;
		zz = 0;
		for (z = 0; z < levelheight; z++, zz += 1024) {
			glVertex3i (x1, y1, (zz + 0) * YCORRECTFACT);
			glVertex3i (x1, y1, (zz + 1024) * YCORRECTFACT);
			glVertex3i (x2, y2, (zz + 1024) * YCORRECTFACT);
			glVertex3i (x2, y2, (zz + 0) * YCORRECTFACT);
		}
		glEnd ();
		glColor4f (1.0, 1.0, 1.0, 1.0);
		return;
    } else {
		glDisable (GL_BLEND);
		glEnable (GL_TEXTURE_2D);
    }
    int z;
    z = 0;
	alttile = -1;
    int tex = GetTexForLump (lump,REPEAT_X|REPEAT_Y ,0)->tex.texnum[0];
    if (alttile >= 0) {
		texes[0] = tex;
		tex = GetTexForLump (alttile,REPEAT_X|REPEAT_Y ,0)->tex.texnum[0];
		z++;
    }


    for (; z < levelheight; z++) {
		texes[z] = tex;
    }  

	{//bna++148 adjust for switches which was going the whole way up to the roof
		if (((lump >= iSpecELEV3)&&(lump <= iSpecELEV8 ))||iSpecWALL11==lump||iSpecWALL12==lump){
			for (z = 1; z < levelheight; z++) {
				texes[z] = GetTexForLump (iSpechswtch13,REPEAT_X|REPEAT_Y ,0)->tex.texnum[z];
			} 
		}
	}//bna++148 end 

    DrawAWall (x1, y1, x2, y2, texes, dimfact, dofl);
    checkGLStatus ();
}

void GLDrawWalls (void)
{
    wallent_t *cur = viswalls;
    int i;

    if (fog)
		glEnable (GL_FOG);
    SetDrawMode(GLV_WALL);
    //printf("%d\n",numviswalls);
    for (i = 0; i < numviswalls; i++, cur++) {
		DrawNormWall (cur);
    }
}


GLfloat debugcolors[6][3] = {
    {0.5, 0.5, 0.5}
    ,
    {0.5, 0.5, 1.0}
    ,
    {0.5, 1.0, 0.5}
    ,
    {0.5, 1.0, 1.0}
    ,
    {1.0, 0.5, 0.5}
    ,
    {1.0, 0.5, 1.0}
    ,
};


glimage_t* savegame_image=0;
glimage_t* imfree=0;
int oldskytex=0;

extern "C" {
Uint32 *oldskytexA = 0;
extern BOOL  bUseOldSkys;
extern BOOL  bIntPolOldSkys;

}

int  oldskyw,oldskyh;
float divisor = 1;
DWORD two_skys32size = 0;

//float movesky = 0;
//DWORD moveskyTckCnt=0;

void GLDrawSky (void)
{
    int txn, vn;
	Uint32 * startpos; 
	UINT fp;


	if (!sky)
		return;
	 
	if ((bUseOldSkys == 1)&&(!BATTLEMODE)){
		//is the old sky created?
		if (oldskytexA == 0){  
			if (glscreenw == 320){
				divisor = 0.60;//
				oldskyw = 88+glscreenw; 
			}
			if (glscreenw == 640){
				divisor = 1.2;
				oldskyw = 180+glscreenw; 
			}
			if (glscreenw == 800){
				divisor = 1.4;
				oldskyw = 156+glscreenw; 
			}
			if (glscreenw == 1024){      
				divisor = 1.75;//
				oldskyw = 172+glscreenw; 
			}
			if (glscreenw == 1152){
				divisor = 1.85;
				oldskyw = 112+glscreenw; 
			}
			if (glscreenw >= 1280){
				divisor = 2.1;
				oldskyw = 104+glscreenw; 
			}              

			if (glscreenw >= 1680) {
				divisor = 1.98;
				oldskyw = 104 + glscreenw;
			}
		

			oldskyh = glscreenh +((12+56)*2);
			oldskytexA = (Uint32 *)CreateOldSky(oldskyw, oldskyh);
		}  


		//put the sun on sky
		//HBITMAP hBmpsun;	      
		//BITMAP  bmsun;
		/*
		unsigned char *uc,*tgt,*src;
		byte r,g,b;  
		unsigned int clr;
		int h1,w1;

		//copy our pic into our mem
		src = (unsigned char*)bmsun.bmBits;
		tgt = (unsigned char*)oldskytexA;
		for (h1 = 0;h1 < bmsun.bmHeight; h1++){
			uc = src;
			for (w1 = 0;w1 < bmsun.bmWidth; w1++){
				r = *(src++);
				g = *(src++);
				b = *(src++);
				clr = RGB(r,g,b); 
				if (clr != 0x00FFFFFF){//0x00FFFFFF = white
					clr |= 0xFF000000;
					*(oldskytexA + w1 + (h1 * oldskyw)+1000) = clr;  
				}
			}
		}
		*/

	 
		skyplayerangle = player->angle;

		skytiltangle = player->yzangle;
		if (skytiltangle > 1024) 
			skytiltangle -= 2048;
		skytiltangle = (UINT)((float)skytiltangle/(float)2.3);

		//1024/320 = 3.2    0.31   *0.5    88+glscreenw;   0.597
		//1024/640 = 1.6	0.625  *0.9    180+glscreenw;  1.2
		//1024/800 = 1.28   0.78   *1.2  = 156+glscreenw;  1.4
		fp = (UINT)((float)skyplayerangle*(float)divisor);

		if ((fp / oldskyw) > 1) 
			skytiltangle += (fp / oldskyw)+0;
		
		/*bna test for moving skies
		fp += movesky;
		if (GetTickCount() > moveskyTckCnt){
			movesky += 0.01;
			moveskyTckCnt = GetTickCount() + 1;
		}*/



		startpos = oldskytexA - fp + oldskyw;
		startpos += ((int)skytiltangle*oldskyw)+((6+56)*oldskyw);

		glPixelStoref(GL_UNPACK_ALIGNMENT, 4);

		if (lightninglevel > 0) {
			glClearColor(1.0f, 1.0f, 1.0f, 0.1f);
			glClearDepth(1.0f);
			glClear(GL_COLOR_BUFFER_BIT);
			lightninglevel = 0;
		
		}else{ 
			glDrawPixels(oldskyw,oldskyh,GL_BGRA_EXT,GL_UNSIGNED_BYTE, startpos);
		}
		return;
	}

	//draw sky boxes    
	SetDrawMode(GLV_SKY);
    double fact = 1.0;
 

	if (MISCVARS->GASON) {
		fact = (MISCVARS->gasindex / 15.0);
    }

    for (txn = 0; txn < 6; txn++) {
#if (KEEP_SKYS == 1)
	BindTex( skytex[sky - 1][txn]);
#else
	BindTex( skytex[txn]);
#endif
/*
	int w,h;
	char filename[256];
	if (oldskytex == 0)
	oldskytex = LoadExtImgToTexture("SKYDK.BMP",1,20,&w,&h);  
					glBindTexture(GL_TEXTURE_2D, ctex);
					gl_free (mbuf);

	int oldskynum = W_GetNumForName ("SKYSTART")+2;
	int oldskytex = GetTexForLump (oldskynum,REPEAT_X|REPEAT_Y ,0)->tex.texnum[0];
	

	BindTex( oldskytex);
*/ 


	glBegin (GL_QUADS);
	glColor3f (1.0, 1.0, 1.0);
	for (vn = 0; vn < 4; vn++) {
	    glTexCoord2dv (skytexwind[vn]);
	    glVertex3iv ((const GLint*)skywind[txn][vn]);
	}
	glEnd ();

	if (MISCVARS->GASON) {
	    glEnable (GL_BLEND);
	    glDisable (GL_TEXTURE_2D);
	    glBegin (GL_QUADS);
	    glColor4f (0.0, 1.0, 0.0, fact / 2.0);
	    for (vn = 0; vn < 4; vn++) {
			glVertex3iv ((const GLint*)skywind[txn][vn]);
	    }
	    glEnd ();
	    glColor4f (1.0, 1.0, 1.0, 1.0);
	    glDisable (GL_BLEND);
	    glEnable (GL_TEXTURE_2D);
	}

	if (lightninglevel>0) {
	    //printf ("%d\n",lightninglevel);
	    glEnable (GL_BLEND);
	    glDisable (GL_TEXTURE_2D);
	    glBegin (GL_QUADS);
	    glColor4f (1.0, 1.0, 1.0, (lightninglevel/15.0));
	    for (vn = 0; vn < 4; vn++) {
			glVertex3iv ((const GLint*)skywind[txn][vn]);
	    }
	    glEnd ();
	    glColor4f (1.0, 1.0, 1.0, 1.0);
	    glDisable (GL_BLEND);
	    glEnable (GL_TEXTURE_2D);
	}

    }
}

// Some of this code is from TransformPushWalls

#define pw_npushed 0
#define pw_pushing 1
#define pw_pushed  2
#define pw_moving  3

void GLDrawPushWalls (void)
{
    double x1, y1;
    int texes[16];
    byte *visspot;
    int i, j, gx, gy;
    SetDrawMode(GLV_PUSHWALL);
    double dimfact=((gamestate.difficulty/3.0)*0.2)+0.8;

    for (i = 0; i < pwallnum; i++) {
	if ((pwallobjlist[i]->action == pw_pushed)||(pwallobjlist[i]->action == pw_npushed))
	    continue;

	//bna++146 start
	//errorcheck, do we exxed our limits?
	if (((pwallobjlist[i]->x / 0xFFFF) < 0) || ((pwallobjlist[i]->x / 0xFFFF)>128))
	    continue;
	if (((pwallobjlist[i]->y / 0xFFFF) < 0) || ((pwallobjlist[i]->y / 0xFFFF)>128))
	    continue;
	//bna++146 end

	visspot = &spotvis[pwallobjlist[i]->x >> 16][pwallobjlist[i]->y >> 16];
	if (*visspot || (*(visspot - 1))||(*(visspot + 1))||(*(visspot - 128))||(*(visspot + 128))) 
	{
	    gx = pwallobjlist[i]->x;
	    gy = pwallobjlist[i]->y;
	    mapseen[gx >> 16][gy >> 16] = 1;
	    int dofl = 0;
	    int lump=GetAnimTex (pwallobjlist[i]->texture);
	    if ((lump >= 127 && lump <= 132) ||
		(lump >= 77 && lump <= 80))
		dofl = 1;
	    
	    int tex = GetTexForLump (lump,REPEAT_X|REPEAT_Y ,0)->tex.texnum[0];
	    for (j = 0; j < levelheight; j++)
		texes[j] = tex;
	    x1 = pwallobjlist[i]->x / 64.0 - 512.0;
	    y1 = pwallobjlist[i]->y / 64.0 - 512.0;
	    DrawAWall (x1, y1, x1, y1 + 1024, texes, dimfact, dofl);
	    DrawAWall (x1, y1 + 1024, x1 + 1024, y1 + 1024, texes, dimfact, dofl);
	    DrawAWall (x1 + 1024, y1 + 1024, x1 + 1024, y1, texes, dimfact, dofl);
	    DrawAWall (x1 + 1024, y1, x1, y1, texes, dimfact, dofl);
	}
    }
    //    glDisable(GL_CULL_FACE);
}

#define tcxl (xx&1?0.5:0.0)
#define tcxh (xx&1?1.0:0.5)
#define tcyl (yy&1?0.5:0.0)
#define tcyh (yy&1?1.0:0.5)
void GLDrawFloorCeil (void)
{
    int xx, yy, cpos;
    //return;
    SetDrawMode(GLV_FLOORCEIL);
    byte *visptr = &spotvis[0][0];
    cpos = levelheight * 1024 * YCORRECTFACT;
    BindTex( floortex);
    if (NO_FLOORDEPTH) glDepthMask(0);
    glStencilOp(GL_KEEP,GL_KEEP,GL_KEEP);
    glStencilFunc(GL_EQUAL,0,1);
    //glEnable(GL_STENCIL_TEST);
    glBegin (GL_QUADS);
    for (xx = 0; xx < 128; xx++) {
	for (yy = 0; yy < 128; yy++, visptr++) {
	    if (!*visptr || IsWindow (xx, yy))
		continue;
	    glTexCoord2f (tcxl, tcyl);
	    GLSetLight ((xx << 10), (yy << 10), 1.0);
	    glVertex3i ((xx << 10), (yy << 10), 0);

	    glTexCoord2f (tcxh, tcyl);
	    GLSetLight ((xx << 10) + 1024, (yy << 10), 1.0);
	    glVertex3i ((xx << 10) + 1024, (yy << 10), 0);

	    glTexCoord2f (tcxh, tcyh);
	    GLSetLight ((xx << 10) + 1024, (yy << 10) + 1024, 1.0);
	    glVertex3i ((xx << 10) + 1024, (yy << 10) + 1024, 0);

	    glTexCoord2f (tcxl, tcyh);
	    GLSetLight ((xx << 10), (yy << 10) + 1024, 1.0);
	    glVertex3i ((xx << 10), (yy << 10) + 1024, 0);
	}
    }
    glEnd ();


	if (!sky) {
	visptr = &spotvis[0][0];
	BindTex( ceilingtex);
	glBegin (GL_QUADS);
	for (xx = 0; xx < 128; xx++) {
	    for (yy = 0; yy < 128; yy++, visptr++) {
		if (!*visptr || IsWindow (xx, yy))
		    continue;
		glTexCoord2f (tcxl, tcyl);
		GLSetLight ((xx << 10), (yy << 10), 1.0);
		glVertex3i ((xx << 10), (yy << 10), cpos);

		glTexCoord2f (tcxh, tcyl);
		GLSetLight ((xx << 10) + 1024, (yy << 10), 1.0);
		glVertex3i ((xx << 10) + 1024, (yy << 10), cpos);

		glTexCoord2f (tcxh, tcyh);
		GLSetLight ((xx << 10) + 1024, (yy << 10) + 1024, 1.0);
		glVertex3i ((xx << 10) + 1024, (yy << 10) + 1024, cpos);

		glTexCoord2f (tcxl, tcyh);
		GLSetLight ((xx << 10), (yy << 10) + 1024, 1.0);
		glVertex3i ((xx << 10), (yy << 10) + 1024, cpos);
	    }
	}
	glEnd ();
    }
}

#undef tcxl
#undef tcyl
#undef tcxh
#undef tcyh
void GLSkyInit (void)
{
    int floornum, ceilingnum;
    sky = 0;
    if (MAPSPOT (1, 0, 0) >= 234) {
	sky = (MAPSPOT (1, 0, 0) - 233);
	if ((sky < 1) || (sky > 6))
	    Error ("Illegal Sky Tile = %ld\n", sky);
	ceilingnum = 1;   
	LoadSky (sky - 1);
	// Check for lightnign icon
	lightning=false;
	int crud=(word)MAPSPOT(4,0,1);
	if (crud==377)
	    lightning=true;
    } else
	ceilingnum = MAPSPOT (1, 0, 0) - 197;

    floornum = MAPSPOT (0, 0, 0) - 179;

    char buf[10];

    sprintf (buf, "FLRCL%d", floornum);
    floornum = W_GetNumForName (buf);
    floortex = GetTexForLump (floornum,REPEAT_X|REPEAT_Y ,0)->tex.texnum[0];

    if (!sky) {
	sprintf (buf, "FLRCL%d", ceilingnum);
	ceilingnum = W_GetNumForName (buf);
	ceilingtex = GetTexForLump (ceilingnum,REPEAT_X|REPEAT_Y ,0)->tex.texnum[0];
    }
    printf("Sky init successful\n");
}

void GLCalcShroomHue (void)
{
    Uint32 now = SDL_GetTicks ();
    if (!shroomlast) 
		shroomlast = now;
    Uint32 itime = now - shroomlast;
    shroomlast = now;
    double dtime = (double)itime / 40.0;
    int i;
    shroomrec* cshr=shrooms;
	for (i=0;i<32;i++,cshr++) {
		cshr->hue += dtime;
		while (cshr->hue > 6.0)
			cshr->hue -= 6.0;
		int huesec = (int)(cshr->hue);

		double d = cshr->hue - huesec;
		switch (huesec) {
		case 0:
			cshr->r = 1.0;
			cshr->g = d;
			cshr->b = 0.0;
			break;
		case 1:
			cshr->r = 1.0 - d;
			cshr->g = 1.0;
			cshr->b = 0.0;
			break;
		case 2:
			cshr->r = 0.0;
			cshr->g = 1.0;
			cshr->b = d;
			break;
		case 3:
			cshr->r = 0.0;
			cshr->g = 1.0 - d;
			cshr->b = 1.0;
			break;
		case 4:
			cshr->r = d;
			cshr->g = 0.0;
			cshr->b = 1.0;
			break;
		case 5:
			cshr->r = 1.0;
			cshr->g = 0.0;
			cshr->b = 1.0 - d;
			break;
		}
    }
}

extern int bordercolor;		// I know, I should just include the header.

#define BORDERSIZE (1.0/100.0)
#define SETBC  glColor4f(red,green,blue,1.0)
#define SETBCA glColor4f(red,green,blue,0.0)

void GLDrawBorder (void)
{
    if (bordercolor == 0)
		return;
    int col = gampal[bordercolor];
    double red = REDCMP (col) / 255.0;
    double green = GREENCMP (col) / 255.0;
    double blue = BLUECMP (col) / 255.0;
    SetDrawMode(GLV_BORDER);
    glTexEnvf (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
    glMatrixMode (GL_PROJECTION);
    glLoadIdentity ();
    gluOrtho2D (0.0, 1.0, screenratio, 0.0);
    glMatrixMode (GL_MODELVIEW);
    glLoadIdentity ();

    glBegin (GL_QUAD_STRIP);
    SETBC;
    glVertex2f (0.0, 0.0);
    SETBCA;
    glVertex2f (BORDERSIZE, BORDERSIZE);
    SETBC;
    glVertex2f (1.0, 0.0);
    SETBCA;
    glVertex2f (1.0 - BORDERSIZE, BORDERSIZE);
    SETBC;
    glVertex2f (1.0, screenratio);
    SETBCA;
    glVertex2f (1.0 - BORDERSIZE, screenratio - BORDERSIZE);
    SETBC;
    glVertex2f (0.0, screenratio);
    SETBCA;
    glVertex2f (BORDERSIZE, screenratio - BORDERSIZE);
    SETBC;
    glVertex2f (0.0, 0.0);
    SETBCA;
    glVertex2f (BORDERSIZE, BORDERSIZE);
    glEnd ();


}
void GLSetFadeFactor (int red, int green, int blue, int alpha)
{
    double lastalpha = fadealpha;
    fadered = (double)red / 255.0;
    fadegreen = (double)green / 255.0;
    fadeblue = (double)blue / 255.0;
    fadealpha = (double)alpha / 255.0;
    //if (fabs(lastalpha-fadealpha)>0.3) {
    //printf("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n");
    //}
    //printf("%f %f %f %f\n",fadered,fadegreen,fadeblue,fadealpha);
}

int GLGetFadeAlpha ()
{
    return (int)(fadealpha * 255.0);
}

static __inline int lineinvis(byte* linstart) {
    int i;
    for (i=0;i<320;i++,linstart++) if (*linstart!=255) return 0;
    return 1;
}
static __inline int scanvis(int dir) {
    byte *linstart=screenbuffer+(100*320);
    int y,lsk;
    lsk=dir*320;
    for (y=100;y>=0&&y<200;y += dir, linstart += lsk) {
	if (!lineinvis(linstart)) return y;
    }
    return y;
}
static __inline int linezero(byte* linstart) {
    int i;
    for (i=0;i<320;i++,linstart++) if (*linstart!=0) return 0;
    return 1;
}
static __inline int scanzero(int start, int dir) {
    byte *linstart=screenbuffer+(start*320);
    int y,lsk;
    lsk=dir*320;
    for (y=start;y>=0&&y<200;y += dir, linstart += lsk) {
	if (!linezero(linstart)) return y;
    }
    return y;
}
static __inline int colzero(byte* linstart) {
    int i;
    for (i=0;i<200;i++,linstart+=320) if (*linstart!=0) return 0;
    return 1;
}
static __inline int scanxzero(int start, int dir) {
    byte *linstart=screenbuffer+start;
    int x;
    for (x=start;x>=0&&x<320;x += dir, linstart += dir) {
	if (!colzero(linstart)) return x;
    }
    return x;
}


void GLDraw2dObjects(int overlay) {
    if (!n2dobjects) return;
    SetDrawMode(GLV_2DOBJECTS);
    glTexEnvf (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
    int lcorrect=1;


    double bbsizeh=((0.75/screenratio)*1.0 - 1.0)/2.0;
    double bbsizev=((screenratio/0.75)*0.75 - 0.75)/2.0;
    double bbsize=bbsizev;
    
    double left, right, top, bot;
    
    if (bbsizeh>0) {
	left=-bbsizeh;
	right=1.0+bbsizeh;
	top=0;
	bot=0.75;
    } else {
	left=0;
	right=1.0;
	top=-bbsizev;
	bot=0.75+bbsizev;
    }
    
    
    glMatrixMode (GL_PROJECTION);
    glLoadIdentity ();
    gluOrtho2D (left, right, bot, top);
    glMatrixMode (GL_MODELVIEW);
    glLoadIdentity ();
    double ratiocorrectfact=screenratio/0.75;
    int i;
    gl2DObject* cur=twodobjects;
    for (i=0;i<n2dobjects;i++,cur++) {
	if ((overlay?1:0) ^ (cur->flags&GLSS_OVERLAY?1:0)) continue;
	//printf("GLDrawScreenShape ovr=%d lump=%s p=%d,%d rot=%f rp=%d,%d scl=%f\n",overlay,W_GetNameForNum(cur->lump),
	//       cur->x,cur->y,cur->rot,cur->rtx,cur->rty,cur->scale);
	if (cur->flags&GLSS_USELIGHT) {
	    GLSetLight(viewx/64.0, viewy/64.0, 1.0);
	} else {
	    glColor3f(1,1,1);
	}
	if (cur->flags&GLSS_CORRECTRATIO) {
	    if (!lcorrect) {
		glMatrixMode (GL_PROJECTION);
		glLoadIdentity ();
		gluOrtho2D (left, right, bot, top);
		lcorrect=1;
	    }
	} else {
	    if (lcorrect) {
		glMatrixMode (GL_PROJECTION);
		glLoadIdentity ();
		gluOrtho2D (0.0, 1.0, 0.75, 0.0);
		lcorrect=0;
	    }
	}
	
	glMatrixMode (GL_MODELVIEW);
	glLoadIdentity ();
	glTranslated(cur->x/320.0,cur->y*(0.75/200.0),0);
 	//glTranslated(cur->rtx/320.0,cur->rty*(0.75/200.0),0);
	glScaled(cur->scale,cur->scale,1);
	glRotated(cur->rot,0,0,1);
 	glTranslated(-cur->rtx/320.0,-cur->rty*(0.75/200.0),0);
	cur->draw(cur->data);

    }

}

void GLCacheLump(int lump) {
             
	if (lump != 183){       
	//WriteDebug("cachelist[i].lump in",cachelist[i].lump);
		GetTexForLump(lump,REPEAT_AUTO ,0);
	}
}

void GLClearScreenShapes() {
    int i;
    gl2DObject* cur=twodobjects;
    for (i=0;i<n2dobjects;i++,cur++) {
		gl_free(cur->data);
		//cur->free(cur->data);
    }
    n2dobjects=0;
}
static void GLDrawLumpObject(void* data) {
    int lump=*(int*)data;
    gl_lumpinfo_t* tex=GetTexForLump(lump,0 ,0);
    double ssx1=tex->tex.lofs/320.0;
    double ssy1=tex->tex.tofs*(0.75/200.0);
    double ssx2=ssx1+(tex->tex.w/320.0);
    double ssy2=ssy1+(tex->tex.h*(0.75/200.0));
    
    BindTex(tex->tex.texnum[0]);
    glBegin (GL_QUADS);
    
    glTexCoord2f(tex->tex.tcxl,tex->tex.tcyl);
    glVertex2d(ssx1,ssy1);
    
    glTexCoord2f(tex->tex.tcxh,tex->tex.tcyl);
    glVertex2d(ssx2,ssy1);
    
    glTexCoord2f(tex->tex.tcxh,tex->tex.tcyh);
    glVertex2d(ssx2,ssy2);
    
    glTexCoord2f(tex->tex.tcxl,tex->tex.tcyh);
    glVertex2d(ssx1,ssy2);
    glEnd();

}



int weaponlump;	
double g_wscale = 0.90;//global weaponscale adjusted to 0.9 in v1.78

void GLAddScreenShape(int lump, int x, int y, int flags) 
{
	double scale = 1;

    gl2DObject* cur=&twodobjects[n2dobjects];

	if (weaponlump == lump){
		scale = g_wscale;//used in DrawPlayerWeapon too
	}

    cur->data=gl_malloc(sizeof(int));
    *(int*)cur->data=lump;
    cur->x=x;
    cur->y=y;
    cur->flags=flags;
    cur->rot=0;
    cur->rtx=0;
    cur->rty=0;
    cur->scale=scale;
    cur->draw=GLDrawLumpObject;
    cur->free=free;
    n2dobjects++;
}


//bna added function 27-04-2008
void GLAddScreenShapeIntro(int lump, int x, int y, double rotate, double scale, double flags) 
{
	   gl2DObject* cur=&twodobjects[n2dobjects];

    cur->data=gl_malloc(sizeof(int));
    *(int*)cur->data=lump;
    cur->x=x;
    cur->y=y;
    cur->flags=flags;
    cur->rot=rotate;
    cur->rtx=0;
    cur->rty=0;
    cur->scale=scale;
    cur->draw=GLDrawLumpObject;
    cur->free=free;
    n2dobjects++;
}


void GLAddScreenShapeEx(int lump, int x, int y, int rtx, int rty, double rotate, double scale, int flags) {
    gl2DObject* cur=&twodobjects[n2dobjects];
    cur->data=gl_malloc(sizeof(int));
    *(int*)cur->data=lump;
    cur->x=x;
    cur->y=y;
    cur->flags=flags;
    cur->rot=rotate;
    cur->rtx=rtx;
    cur->rty=rty;
    cur->scale=scale;
    cur->draw=GLDrawLumpObject;
    cur->free=free;
    n2dobjects++;
}


struct glimage_s {
    GLuint tex;
    int w, h;
    double tcx,tcy;
};
typedef struct {
    glimage_t* img;
    int sw, sh;
} glimgobjpriv;

glimage_t* GLLoadImage(const char* name, int mipmaps) {
    return GLReloadImage(NULL,name,mipmaps);
    
}
glimage_t* GLReloadImage(glimage_t* ret,const char* name, int mipmaps) {
    SDL_Surface *tmp = IMG_Load (name);
    if (!tmp) {
	if (ret)
	    GLFreeImage(ret);
	return NULL;
    }
    if (!ret) {
	ret = (glimage_t*) gl_malloc(sizeof(glimage_t));
	glGenTextures (1, &ret->tex);
    }
    UploadSurfaceToTexture (ret->tex, tmp, 0, mipmaps, &ret->tcx, &ret->tcy);
    ret->w=tmp->w;
    ret->h=tmp->h;
    SDL_FreeSurface (tmp);
    return ret;
    
}
/*glimage_t* GLSaveScreenToImage() {
    glimage_t* ret = (glimage_t*) gl_malloc(sizeof(glimage_t));
    SDL_Surface *tmp = IMG_Load (name);
    ret->w=512;
    ret->h=384;

    glGenTextures (1, &ret->img);
    UploadSurfaceToTexture (ret->img, tmp, 0, 1);
    SDL_FreeSurface (tmp);
    return ret;
    
    }*/
void GLFreeImage(glimage_t* img) {
    glDeleteTextures(1,&img->tex);
    gl_free(img);
}

static void GLDrawImageObject(void* data) {
    glimgobjpriv* priv=(glimgobjpriv*)data;
    double ssx1=0.0;
    double ssy1=0.0;
    double ssx2=ssx1+(priv->sw/320.0);
    double ssy2=ssy1+(priv->sh*(0.75/200.0));
    
    BindTex(priv->img->tex);
    glBegin (GL_QUADS);
    
    glTexCoord2f(0,0);
    glVertex2d(ssx1,ssy1);
    
    glTexCoord2f(priv->img->tcx,0);
    glVertex2d(ssx2,ssy1);
    
    glTexCoord2f(priv->img->tcx,priv->img->tcy);
    glVertex2d(ssx2,ssy2);
    
    glTexCoord2f(0,priv->img->tcy);
    glVertex2d(ssx1,ssy2);
    glEnd();

}

void GLAddImage(glimage_t* img, int x, int y, int w, int h, int flags) {
    gl2DObject* cur=&twodobjects[n2dobjects];
    glimgobjpriv* priv=(glimgobjpriv*)gl_malloc(sizeof(glimgobjpriv));
    
    cur->data=priv;
    priv->img=img;
    priv->sw=w;
    priv->sh=h;
    cur->x=x;
    cur->y=y;
    cur->flags=flags;
    cur->rot=0;
    cur->rtx=0;
    cur->rty=0;
    cur->scale=1;
    cur->draw=GLDrawImageObject;
    cur->free=free;
    n2dobjects++;
}
void GLAddImageEx(glimage_t* img, int x, int y, int w, int h, int rtx, int rty, double rotate, double scale, int flags) {
    gl2DObject* cur=&twodobjects[n2dobjects];
    glimgobjpriv* priv=(glimgobjpriv*)gl_malloc(sizeof(glimgobjpriv));
    
    cur->data=priv;
    priv->img=img;
    priv->sw=w;
    priv->sh=h;
    cur->x=x;
    cur->y=y;
    cur->flags=flags;
    cur->rot=rotate;
    cur->rtx=rtx;
    cur->rty=rty;
    cur->scale=scale;
    cur->draw=GLDrawImageObject;
    cur->free=free;
    n2dobjects++;
}

void GLHandleMenu(int DrawScreen);
void updateSpot();
void GLDrawLights();



void GLRefresh (void)
{
    timer t;//SDL_GRAB_ON

	LONGLONG pD;
	if (g_pMediaSeeking != 0){
		g_pMediaSeeking->GetCurrentPosition(&pD);
		if (pD+5000000 >= lG){    
			LONGLONG llPos = 0;        
			g_pMediaSeeking->SetPositions(&llPos, AM_SEEKING_AbsolutePositioning,
										&llPos, AM_SEEKING_NoPositioning);
			
			// Start the graph 
			g_pMediaControl->Run();

		}


	}
    BeginTimer(&t);
    //printf("GLRefresh\n");
    if (DoingRotate) {
			glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
			glClearDepth(1.0f);
			glClear(GL_COLOR_BUFFER_BIT);

	//      printf("GLRefresh called while rotating\n");
	        return;
    }
    static int blah;
    //glClearColor(1.0,0.0,1.0,1.0);
    SetDrawMode(-1);
    glDepthMask(1);
    glClear (GL_DEPTH_BUFFER_BIT|(inmenu?GL_COLOR_BUFFER_BIT:0)|GL_STENCIL_BUFFER_BIT);
    int dodraw = 0;
    Uint8 *test = screenbuffer;
    int i;
    if (!inmenu && mapplanes[0])
	for (i = 0; i < (320 * 200); i++, test++) {
	    if (*test == 255) {
    		dodraw = 1;
    		break;
	    }
	}


    OverlayStretch=0;

#if (USE_GL_IN_MENU == 1)  
    if (((inmenu != 0)&&(DrawScreen))||((MenuBufStarted==1)&&(DrawScreen)))
		return(GLHandleMenu(DrawScreen));
#endif

	if (dodraw) {
    	OverlayStretch=1;
    	//printf("%d\n",nonbobpheight);
    	//glEnable (GL_TEXTURE_2D);
    	glTexEnvf (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
    	GLCalcShroomHue ();
    	GLSetupCamera (0, 1.0);
    	GLDrawSky (); 
    	GLSetupCamera (1, 1.0);
    	GLCalcLights ();

/**/ 
    	GLDrawWalls ();
    	GLDrawPushWalls ();


    	GLDrawStencilThings ();
    	GLDrawFloorCeil ();

    	GLDrawFlatThings ();
 #if (USERAINCODE != 1)   	
       	GLDraw2dObjects(0);
 #endif
		
    }  	

 GLSetupCamera (0, 1.0);

    /*if ((blah++)&1) */
    int vistop=scanvis(-1)+1;
    int visbot=scanvis(1)-1;

    int ztop=scanzero(0,1);
    int zbot=199-scanzero(199,-1);
    int zleft=scanxzero(0,1);
    int zright=319-scanxzero(319,-1);

    double bbsizeh=((0.75/screenratio)*320.0 - 320)/2.0;
    double bbsizev=((screenratio/0.75)*200.0 - 200)/2.0;
    if (bbsizeh < 0) {
    	ztop += bbsizev;
    	zbot += bbsizev;
    } else {
    	zleft += bbsizeh;
    	zright += bbsizeh;
    }
    int min=ztop;
    if (zbot<min) min=zbot;
    if (ztop<min) min=ztop;
    if (zleft<min) min=zleft;
    if (zright<min) min=zright;


    if (bbsizev<0) {
	   OverlayZoom=((min-160)/-160.0);
    } else {
	   OverlayZoom=((min-100)/-100.0);
    }
    //printf("%d %d %d %d %d %f\n",min,zleft, zright,ztop,zbot, OverlayZoom);

/*
	//bna added
	if (playstate != ex_died){
    	if ((!inautomap)&&(ingame)&&(!inmenu)&&(iG_aimCross)&&(!GamePaused)&&(!fizzlein)&&(!demoplayback))
    		CH_DrawCrosshair (screenbuffer);
    }*/

   	if ((dodraw)&&(iG_aimCross)) 
  		CH_DrawCrosshair (screenbuffer);
  		
	//MAKE GAD change color
	//GLRGADchangeCol (screenbuffer);


    void (*screenfunc)(int,int,int,int);
    
    if (UploadScreen) 
       screenfunc=UploadPartialOverlay;
    else 
       screenfunc=ShowPartialOverlay;
    //if (/*!dodraw ||*/ vistop>=visbot) {
	screenfunc (0, 0, 320, 200);//paints green life and bot/top bars
    //} else { 
	//if (vistop!=0) {
	//    screenfunc (0, 0, 320, vistop);
	//}
	//if (visbot!=199) {
	//    screenfunc (0, visbot+1, 320, 199-visbot);
	//}


	SetSkyPlayerPos();

#if (USERAINCODE == 1)
    if (useRain == 1){
        if (bIsRainInit == FALSE){
    	    //GLInitRain(&rain,NUMDROPS); 
    	    GLInitRain(&rain); 
            bIsRainInit = TRUE;            
        }
        //adjust rainpos depending of relative pos to player
    	SetRainPlayerPos(&rain);
    	if (dodraw) 
    	{
    		SetDrawMode(GLV_RAIN); 
    		//GLDrawRain(&rain,NUMDROPS);
    		GLDrawRain(&rain);
    	    GLDraw2dObjects(0);//redraw hand		
    	    if (SHOW_TOP_STATUS_BAR ()) 
    			screenfunc (0, 0, 320, 20);
    		if ((SHOW_BOTTOM_STATUS_BAR ()) || (SHOW_PLAYER_STATS()))
    			screenfunc (0, 180, 320, 20);
    //		screenfunc (4, 200-20, 80, 20);//redraw the healthbar
    //		screenfunc (320-80-10, 200-20, 80, 20);//redraw the ammobar
    
    	}
    }else{
   	    if (dodraw)     
            GLDraw2dObjects(0);//redraw hand         
    }
#endif
  

	GLDrawBorder ();
    //}
    GLDraw2dObjects(1);


    static int tst=0;
	if (fadealpha > 0.0) {
		SetDrawMode(GLV_FADE);

		glTexEnvf (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
		//printf ("%f %f %f fadealpha=%f\n",fadered,fadegreen,fadeblue,fadealpha);
		glMatrixMode (GL_PROJECTION);
		glLoadIdentity ();
		gluOrtho2D (0.0, 1.0, screenratio, 0.0);
		glMatrixMode (GL_MODELVIEW);
		glLoadIdentity ();
		//if (tst++&1) {
	#if 1
			glBegin (GL_QUADS);
			glColor4f (fadered, fadegreen, fadeblue, fadealpha);
			glVertex2f (0.0, 0.0);
			glVertex2f (1.0, 0.0);
			glVertex2f (1.0, screenratio);
			glVertex2f (0.0, screenratio);
			glEnd ();
	#endif
			//}
    }
    
	//bna added 148
	if (playstate != ex_stillplaying)
		bordercolor = 0;

	#define STATUSGLCONV 9 //9 perceent of screen
	// Quick routine to put text 'string' on the screen at position (x,y)
	if ((playstate == ex_stillplaying)&&(fizzlein == false)&&(inmenu == false)) {
		glDisable (GL_TEXTURE_2D);
		if (GlutErrorMsg[0] != 0){
			
			if (SHOW_TOP_STATUS_BAR ()) 
				putmsg(2,glscreenh -(((glscreenh*STATUSGLCONV)/100)+10),GlutErrorMsg,4, GlutErrorTxtColor, GlutErrorTxtAlpha);
			else
				putmsg(2,glscreenh-16,GlutErrorMsg,4, GlutErrorTxtColor, GlutErrorTxtAlpha);
			if (GetTickCount64() > GlutErrorMsgTckCnt){
				GlutErrorMsg[0] = 0;
				GlutErrorMsgTckCnt = 0;
			}
		}
		if (demoplayback == 1){
    		if ((SHOW_BOTTOM_STATUS_BAR ()) || (SHOW_PLAYER_STATS()))
				putmsg(3,(glscreenh*STATUSGLCONV)/100,DemoPlayername,4,3,0.3);
			else
				putmsg(3,4,DemoPlayername,4,3,0.3);

			if (SHOW_TOP_STATUS_BAR ()) //bna++146
				putmsg((glscreenw/2)-132,glscreenh-(((glscreenh*STATUSGLCONV)/100)+10),DemoRtlFile,4,3,0.5);
			else
				putmsg((glscreenw/2)-132,glscreenh-16,DemoRtlFile,4,3,0.5);
		}

	}


    if (DrawScreen)
		SDL_GL_SwapBuffers ();
    int micros=EndTimer(&t);
    double fps=1000000.0/micros;
    static int dbline=0;
//    DebugAt(&dbline,"GLRefresh [%d us, %f fps]",micros,fps);
    //else printf("Screen drawn without displaying\n");
}

void TimeRefresh(int rotate) {
    char buf[64];
    int saveang=viewangle;
    Uint32 begin=SDL_GetTicks();
    int i;
    for (i=0;i<60;i++) {
	if (rotate) {
	    viewangle=(int)((2048.0/60.0)*i);
	    ThreeDRefresh();
	} else {
	    GLRefresh();
	}
    }
    Uint32 end=SDL_GetTicks();
    double secs = (end-begin)/1000.0;
    double fps = 60.0/secs;
    sprintf(buf,"%.2f secs = %.4f fps",secs,fps);
    AddMessage (buf,MSG_GAME);
    viewangle=saveang;



}


#define FALLING_TIME (VBLCOUNTER*2.0)
#define LOOKDOWN_TIME (VBLCOUNTER/2.0)


void GLDoFalling ()
{
    int i;
    int ova = viewangle;
    int ola = lookangle;

    int sla = lookangle;
    dying=1;
    while (sla > 1024)
	sla -= 2048;
    CalcTics ();
    for (i = 0; i < LOOKDOWN_TIME; i += tics) {
	double step = (double)i / (double)LOOKDOWN_TIME;
	lookangle = (int)((-512 - sla) * step + sla);
	//printf("%d %d %f\n",lookangle,ola,step);
	GLSetupCamera (0, 1.0);
	GLDrawSky ();
	SDL_GL_SwapBuffers ();
	CalcTics ();
    }
    CalcTics ();
    for (i = 0; i < FALLING_TIME; i += tics) {
	viewangle += (tics * 64);
	double step = (double)i / (double)FALLING_TIME;
	GLSetupCamera (0, 1.0 / (step * 20.0 + 1.0));
	GLDrawSky ();
	SDL_GL_SwapBuffers ();
	CalcTics ();
    }
    lookangle = ola;
    viewangle = ova;
    dying=0;
}
void DrawScreenToBuffer (Uint32 * buf, int x, int y, int w, int h)
{
    int imsave=inmenu;
    inmenu=false;
    memset (buf, 0, w * h * 4);
    Uint32 *tmpbuf = (Uint32 *) gl_malloc (glscreenw * glscreenh * 4);
    glDrawBuffer (GL_BACK);
    DrawScreen=0;
    GLRefresh ();
    inmenu=imsave;
    DrawScreen=1;
    glReadBuffer (GL_BACK);
    glReadPixels (0, 0, glscreenw, glscreenh, GL_RGBA, GL_UNSIGNED_BYTE,
		  tmpbuf);
    int i;
    Uint32 *idpos = (buf + x + w * y);
    for (i = 0; i < (glscreenh); i++) {
		Uint32 *posa = idpos + (w * i);
		Uint32 *posb = tmpbuf + (glscreenw * (glscreenh - i - 1));
		memcpy (posa, posb, glscreenw * 4);
    }
    glDrawBuffer (GL_BACK);
    glReadBuffer (GL_BACK);

    gl_free (tmpbuf);
}

Uint32* glsavedscreen=NULL;

void GLSaveScreen(int fixratio) {
    double tempratio=screenratio;
    if (fixratio) screenratio=0.75;
    printf("saved screen, fixratio=%d ratio=%f\n",fixratio,screenratio);
    if (glsavedscreen==NULL) {
		glsavedscreen=(Uint32*)gl_malloc(glscreenw*glscreenh*4);
    }
    //glClear(GL_COLOR_BUFFER_BIT);
    DrawScreenToBuffer(glsavedscreen,0,0,glscreenw,glscreenh);
    screenratio=tempratio;
}
void GLDeleteSave() {
    if (glsavedscreen!=NULL) {
		gl_free(glsavedscreen);
		glsavedscreen = NULL;
    }
}

Uint32* ScaleImage(Uint32* in, int sw, int sh, int nw, int nh) {
    int cx,ex,cy,ey,totr,totb,totg,cnt,x2,y2,cc,xx,yy;
    double sfx=((double)sw/(double)nw);
    double sfy=((double)sh/(double)nh);
    Uint32* ret = (Uint32*)gl_malloc(nw*nh*4);
    for (yy=0;yy<nh;yy++) {
	cy=(int)(yy*sfy);
	ey=(int)((yy+1)*sfy);
	if (cy==ey)ey++;
	for (xx=0;xx<nw;xx++) {
	    cx=(int)(xx*sfx);
	    ex=(int)((xx+1)*sfx);
	    if (cx==ex)ex++;
	    totr=0;
	    totg=0;
	    totb=0;
	    cnt=0;
	    for (y2=cy;y2<ey;y2++) {
		for (x2=cx;x2<ex;x2++) {
		    cc=in[x2+sw*y2];
		    totr += (cc>>16)&255;
		    totg += (cc>>8)&255;
		    totb += (cc)&255;
		    cnt++;
		}
	    }
		    
	    ret[xx+nw*yy]=0xFF000000|((totr/cnt)<<16)|((totg/cnt)<<8)|(totb/cnt);
	}
    }
    return ret;
}





int GLWriteSaveGameScreen(const char* name) {

	SDL_RWops* rw;
	SDL_Surface* transparentimage = 0;
    Uint32* shrunk=ScaleImage(glsavedscreen,glscreenw,glscreenh,320,240);

	//bna++146 start
	//we add a  watermark
	/*
	int ptr=0;
	for (int i = 200; i < 200+12; i++){
		for (int j = 10; j < 10+93 ; j++){
			*(shrunk+(i*320)+j) += (glmask[ptr++]*0x00303000);
		}
	}*/
	//bna++146 end
    SDL_Surface* tmp=SDL_CreateRGBSurfaceFrom(shrunk,320,240,32,320*4,255<<RED_SHIFT,255<<GREEN_SHIFT,255<<BLUE_SHIFT,255<<ALPHA_SHIFT);
   

	// I use a GIF which has transparent properties    bna++ 1.78
	byte* ybuffer;//
	int size;

	if (viewsize <= 8)//if there is a top bar lower the winrott text mask a bit
		size = LoadResourceToFixedMem("GIF", IDR_GIF2, (void**)&ybuffer);
	else
		size = LoadResourceToFixedMem("GIF", IDR_GIF1, (void**)&ybuffer);//fullscreen

	if (size > 0) {
		rw = SDL_RWFromMem(ybuffer, size);
		transparentimage = IMG_Load_RW(rw, 1);
		if (transparentimage != NULL) {
			SDL_BlitSurface(transparentimage, NULL, tmp, NULL);
		}
	}
	SDL_SaveBMP(tmp,name);
    gl_free(shrunk);
    SDL_FreeSurface(tmp);
	SDL_FreeSurface(transparentimage);
	HLOCAL r = LocalFree(ybuffer);
    return 1;
}



//bna++146 start
int GLWriteOldgameSaveGameScreen(const char* name) {

    Uint32* shrunk=ScaleImage(glsavedscreen,glscreenw,glscreenh,160,100);
    SDL_Surface* tmp=SDL_CreateRGBSurfaceFrom(shrunk,160,100,32,160*4,255<<RED_SHIFT,255<<GREEN_SHIFT,255<<BLUE_SHIFT,255<<ALPHA_SHIFT);
    SDL_SaveBMP(tmp,name);
    gl_free(shrunk);
    SDL_FreeSurface(tmp);
    return 1;

}
//bna++146 end
     
//bna++146 start
int GLWriteSoftnedSaveGameScreen(const char* name) {

	Uint32* shrunk=ScaleImage(glsavedscreen,glscreenw,glscreenh,320,240);
                
	Uint32* t,cnt = 0;
//	unsigned char c;
	unsigned int w,h, width=320, height=240;

	if (cUseSavegameSoften == 1){
		t = shrunk;
 		for (h = 1; h < height-1; h++ ){
			for (w = 1; w < width-1; w++ ){
				Uint32 p1; 
				if ((*(t+(h*width)+w-1) != 0x00FF00FF)&&(*(t+(h*width)+w) != 0x00FF00FF)&&(*(t+(h*width)+w+1) != 0x00FF00FF)){
					if ((*(t+((h-1)*width)+w-1) != 0x00FF00FF)&&(*(t+((h-1)*width)+w) != 0x00FF00FF)&&(*(t+((h-1)*width)+w+1) != 0x00FF00FF)){
						if ((*(t+((h+1)*width)+w-1) != 0x00FF00FF)&&(*(t+((h+1)*width)+w) != 0x00FF00FF)&&(*(t+((h+1)*width)+w+1) != 0x00FF00FF)){
							p1 = CalcAverageCol32((t+(h*width)+w), width);
							*(t+(h*width)+w) = p1 + 0xFF000000;
						}
					}
				}
			}    
		}   
	}      
	//bna++146 start
	//we add a small watermark      
	int ptr=0;
	for (int i = 200; i < 200+12; i++){
		for (int j = 10; j < 10+24 ; j++){
			*(shrunk+(i*320)+j) += (glmask[ptr++]*0x00303000);
		}
	}
	//bna++146 end	
	SDL_Surface* tmp=SDL_CreateRGBSurfaceFrom(shrunk,320,240,32,320*4,255<<RED_SHIFT,255<<GREEN_SHIFT,255<<BLUE_SHIFT,255<<ALPHA_SHIFT);
    
	SDL_SaveBMP(tmp,name);
    gl_free(shrunk);
    SDL_FreeSurface(tmp);
    return 1;
}
//bna++146 end


#ifdef PNG_SAVE
char* gl_ss_ext="png";
int GLWriteSavedScreen(const char* name) {
    //screenratio=0.75;
    png_structp png_ptr;
    png_infop info_ptr;
    png_bytep * row_pointers;
    int i,j;
    
    png_ptr = png_create_write_struct(PNG_LIBPNG_VER_STRING, NULL,NULL, NULL);
    if (!png_ptr) return 0;
    info_ptr = png_create_info_struct(png_ptr);
    if (!info_ptr) {
	png_destroy_write_struct(&png_ptr,(png_infopp)NULL);
	return 0;
    }
    
    FILE * fp=fopen(name,"wb");
    if (!fp) {
	return 0;
    }
    int npix=glscreenw*glscreenh;
    unsigned char* tmpscr,*dpos;
    Uint32* spos=glsavedscreen;
    tmpscr=dpos=(unsigned char*)gl_malloc(npix*3);

    for (i=0;i<npix;i++) {
	int pix=*spos++;
	*dpos++=REDCMP(pix);
	*dpos++=GREENCMP(pix);
	*dpos++=BLUECMP(pix);
    }
    png_init_io(png_ptr, fp);
    png_set_compression_level(png_ptr,Z_BEST_SPEED);
    
    png_set_compression_mem_level(png_ptr, 8);
    png_set_compression_strategy(png_ptr,Z_DEFAULT_STRATEGY);
    png_set_compression_window_bits(png_ptr, 15);
    png_set_compression_method(png_ptr, 8);
    png_set_compression_buffer_size(png_ptr, 8192);
    
    png_set_IHDR(png_ptr, info_ptr, glscreenw, glscreenh,
		 8, PNG_COLOR_TYPE_RGB, PNG_INTERLACE_NONE,
		 PNG_COMPRESSION_TYPE_DEFAULT, PNG_FILTER_TYPE_DEFAULT);

    /*Allocate an array of scanline pointers*/
    row_pointers=(png_bytep*)gl_malloc(glscreenh*sizeof(png_bytep));
    int pitch=glscreenw*3;
    for (i=0;i<glscreenh;i++) {
	row_pointers[i]=((png_bytep)tmpscr+i*pitch);
    }
    /*tell the png library what to encode.*/
    png_set_rows(png_ptr, info_ptr, row_pointers);
    
    /*Write image to file*/
    png_write_png(png_ptr, info_ptr, 0, NULL);
    
    /*close file*/
    fclose(fp);
    
    /*Destroy PNG structs*/
    png_destroy_write_struct(&png_ptr, &info_ptr);
    
    /*clean up dynamically allocated RAM.*/
    gl_free(row_pointers);
    gl_free(tmpscr);
    return 1;
}
#else
char* gl_ss_ext="bmp";
int GLWriteSavedScreen(const char* name) {
    /*char tmp_name[MAX_PATH];
    strcpy(tmp_name,name);
    char* dot=strrchr(tmp_name,'.');
    char* slash=strrchr(tmp_name,'/');
    if (dot && dot>slash) strcpy(dot,".bmp");
    printf("name=%s\n",tmp_name);*/
    Uint32* spos=glsavedscreen;
    SDL_Surface* tmp=SDL_CreateRGBSurfaceFrom(glsavedscreen,glscreenw,glscreenh,32,glscreenw*4,255<<RED_SHIFT,255<<GREEN_SHIFT,255<<BLUE_SHIFT,255<<ALPHA_SHIFT);
    SDL_SaveBMP(tmp,name);
    SDL_FreeSurface(tmp);
    return 1;
}
#endif
void GLSetScreenVisible (int vis)
{
    DrawScreen = vis;
}
void GLSetUpload (int upl)
{
    UploadScreen=upl;
}

static double scrtrw,scrtrh;

static GLuint screentex;
/*static GLdouble subtexleft = 0;
static GLdouble subtexright = 0;
static GLdouble subtextop = 0;
static GLdouble subtexbot = 0;

static GLdouble csubtexleft = 0;
static GLdouble csubtexright = 0;
static GLdouble csubtextop = 0;
static GLdouble csubtexbot = 0;*/

static double rtcx, rtcy;


void GLStartRotate ()
{ 
    int rsw=powerof2(glscreenw);
    int rsh=powerof2(glscreenh);
    Uint32 *buf = (Uint32 *) gl_malloc (glscreenw * glscreenh * 4);
    DrawScreenToBuffer (buf, 0, 0, glscreenw, glscreenh);

    Uint32 *rtex = (Uint32*)gl_malloc (rsw * rsh * 4);

    copy2d (buf, glscreenw, glscreenh, rtex, rsw, rsh, 0, 0,
	    0, 0, glscreenw,glscreenh);

    glGenTextures(1,&screentex);

	globallump = 0;//bna++
    UploadTexture(screentex,rtex,rsw,rsh,0,0,0,20,rsw,rsh);

    rtcx= 0.5;
    rtcy= 0.5*screenratio;


    gl_free (buf);
    gl_free (rtex);
    checkGLStatus ();
    DoingRotate = 1;
    scrtrw=glscreenw/(double)rsw;
    scrtrh=glscreenh/(double)rsh;
}

void GLStopRotate ()
{
    glDeleteTextures (1, &screentex);
    DoingRotate = 0;
    DrawScreen = 1;
    SetDrawMode(-1);
}

#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif

void DrawTex (GLuint tex,
	      double x1, double y1,
	      double x2, double y2,
	      double x3, double y3,
	      double x4, double y4,
	      double tcleft, double tcright, double tctop, double tcbot)
{
    BindTex( tex);
    glBegin (GL_QUADS);
    glTexCoord2f (tcleft, tctop);
    glVertex2f (x1, y1);
    glTexCoord2f (tcright, tctop);
    glVertex2f (x2, y2);
    glTexCoord2f (tcright, tcbot);
    glVertex2f (x3, y3);
    glTexCoord2f (tcleft, tcbot);
    glVertex2f (x4, y4);
    glEnd ();
}

void GLRotateScreen (int cx, int cy, int angle, int scale)
{
    glDepthMask (1);
    glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);




    double rscale = 2048.0 / scale;
    double rangle = angle / 1024.0 * M_PI;
    double rcx = (cx / 320.0);
    double rcy = (cy / 200.0) * screenratio;

    double sina = sin (rangle);
    double cosa = cos (rangle);


    glDisable	(GL_POLYGON_SMOOTH);
    glDisable    (GL_ALPHA_TEST);
    glDisable    (GL_CULL_FACE);
    glDepthMask (0);

    glDisable (GL_FOG);
    glDisable (GL_BLEND);
    glEnable (GL_TEXTURE_2D);
    glDisable (GL_DEPTH_TEST);
    //glTexEnvf (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
    glMatrixMode (GL_PROJECTION);
    glLoadIdentity ();
    gluOrtho2D (0.0, 1.0, screenratio, 0.0);
    glMatrixMode (GL_MODELVIEW);
    glLoadIdentity ();
    glColor3f(1,1,1);

    double xtl = rcx + (cosa * -rtcx + sina * -rtcy) * rscale;
    double ytl = rcy + (-sina * -rtcx + cosa * -rtcy) * rscale;


    double xtr = rcx + (cosa * rtcx + sina * -rtcy) * rscale;
    double ytr = rcy + (-sina * rtcx + cosa * -rtcy) * rscale;

    double xbl = rcx + (cosa * -rtcx + sina * rtcy) * rscale;
    double ybl = rcy + (-sina * -rtcx + cosa * rtcy) * rscale;

    double xbr = rcx + (cosa * rtcx + sina * rtcy) * rscale;
    double ybr = rcy + (-sina * rtcx + cosa * rtcy) * rscale;

    BindTex(screentex);

    glBegin(GL_QUADS);
    glTexCoord2f(0,0);
    glVertex2f(xtl,ytl);

    glTexCoord2f(scrtrw,0);
    glVertex2f(xtr,ytr);

    glTexCoord2f(scrtrw,scrtrh);
    glVertex2f(xbr,ybr);

    glTexCoord2f(0,scrtrh);
    glVertex2f(xbl,ybl);
    glEnd();

    /*

    //glEnable(GL_POLYGON_SMOOTH);

#define etl subtexleft
#define etr subtexright
#define ett subtextop
#define etb subtexbot

#define ietl csubtexleft
#define ietr csubtexright
#define iett csubtextop
#define ietb csubtexbot

#define ctl csubtexleft
#define ctr csubtexright
#define ctt csubtextop
#define ctb csubtexbot

#define ictl subtexleft
#define ictr subtexright
#define ictt subtextop
#define ictb subtexbot

#define xc rcx
#define yc rcy

#define DOTEX(ix,c1,c2,c3,c4,vlr,vtb) DrawTex(screentex[ix],x##c1,y##c1,x##c2,y##c2,x##c3,y##c3,x##c4,y##c4,vlr##tl,i##vlr##tr,vtb##tt,i##vtb##tb)


    DOTEX (0, tl, t, c, l, e, e);
    DOTEX (1, t, tr, r, c, c, e);
    DOTEX (2, l, c, b, bl, e, c);
    DOTEX (3, c, r, br, b, c, c);*/

    //glTexEnvf (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
    SDL_GL_SwapBuffers ();
    //glDisable(GL_POLYGON_SMOOTH);
}




#endif /* USE_OPENGL */







extern char szDbgName[];



void WriteDebug (char *error, int i,...)
{
   char msgbuf[300];
	
    FILE *stream = fopen(szDbgName, "a+");
	if ((i>0)||(i<0)){
		sprintf(msgbuf,"%s %d\n",error,i);
	}else{
		sprintf(msgbuf,"%s \n",error);
	}
	fprintf(stream,msgbuf);
    fclose(stream);

}





//bna added function
//sometimes the proper lumps couldnt get loaded
//so we make this to make sure we dont exit game
//and we hope the right lumps will get loaded later.



Uint8 *GL_W_CacheLumpNum (int lump, int tag, converter_t converter, int numrec)
{
//	if (GFX_wallstart == 0) 
//	   PrepareGFX ();


    if (lump >= (int)numlumps){
        return 0;
    }else if (lump < 0)
        return 0;

    if (!lumpcache[lump]) {
    	// read the lump in bna++ 
		//if (bUseExternalGFX == TRUE)
    	//	Z_Malloc (W_LumpLength (lump)+1000, tag, &lumpcache[lump]);
		//else
    		Z_Malloc (W_LumpLength (lump), tag, &lumpcache[lump]);

/*
		//bna++  check first if we have a external pcx lump 
		if (bUseExternalGFX == TRUE){
			if (CheckExternalGFX (lumpcache[lump], lump, tag)== FALSE){
	    		W_ReadLump (lump, lumpcache[lump]);
			}
		}else{*/
			W_ReadLump (lump, lumpcache[lump]);
		//}
    	converter (lumpcache[lump], numrec);
    } else {
		//bna++  check first if we have a external pcx lump 
	//	if (bUseExternalGFX == TRUE)
	//		CheckExternalGFX (lumpcache[lump], lump, tag);

    	Z_ChangeTag (lumpcache[lump], tag);

    }
    return (Uint8*)lumpcache[lump];
}



int LoadModelTexture (const char *fname, int repeat, int mipmaps, int *w, int *h)
{
    char buf[255];
    GLuint ret;
	SDL_Surface *tmp;

    sprintf(buf,"%s\\%s",GLPath,fname);
    tmp = IMG_Load (buf);
	if (!tmp) {
		tmp = IMG_Load (fname);
		if (!tmp) {
			return -1;
		}
	}
    glGenTextures (1, &ret);
    UploadSurfaceToTexture (ret, tmp, repeat, mipmaps, NULL, NULL);
    SDL_FreeSurface (tmp);
    return ret;
}





//bna added
int LoadExtImgToTexture (const char *path_buffer, int repeat, int mipmaps, int *w, int *h)
{
    char pcx[255]="", png[255]="", bmp[255]="", tga[255]="";
    //char path_buffer[_MAX_PATH];
    char drive[_MAX_DRIVE];
    char dir[_MAX_DIR];
    char fname[_MAX_FNAME];
    char ext[_MAX_EXT];
    GLuint tex;
	SDL_Surface *surf = 0;
	BOOL bIsPNG = 0;

    _splitpath( path_buffer, drive, dir, fname, ext );

	lstrcpy(pcx,dir);
	lstrcat(pcx,fname);
	lstrcat(pcx,".pcx");
	
	lstrcpy(png,dir);
	lstrcat(png,fname);
	lstrcat(png,".png");

	lstrcpy(bmp,dir);
	lstrcat(bmp,fname);
	lstrcat(bmp,".bmp");

	lstrcpy(tga,dir);
	lstrcat(tga,fname);
	lstrcat(tga,".tga");
	//check first current directory for file
	//GetPNGname(buf,png);
	//GetBMPname(png,bmp);

	surf = IMG_Load (path_buffer);
	if (surf) {
		goto PicOK;
	}

	if ((access (pcx, 0) != 0)&&(access (png, 0) != 0)&&(access (bmp, 0) != 0)&&(access (tga, 0) != 0)) {
		sprintf(pcx,"%s\\%s.pcx",GLPath,fname);//take default gl folder
		sprintf(png,"%s\\%s.png",GLPath,fname);//take default gl folder
		sprintf(bmp,"%s\\%s.bmp",GLPath,fname);//take default gl folder
		sprintf(tga,"%s\\%s.tga",GLPath,fname);//take default gl folder
	}

    surf = IMG_Load (bmp);
	if (!surf) {
		surf = IMG_Load (png);
		if (!surf) {
			surf = IMG_Load (pcx); 
			if (surf == 0){
				surf = IMG_Load (tga); 
				if (surf == 0){
					sprintf(pcx,"Error in File or File not found in %s",fname);
					WriteDebug(pcx,0);
					return 0;
				}
			}
			goto PicOK;
		}
		bIsPNG = 1;
	}


//	if (surf->format->BitsPerPixel >= 8)
//		return -1;

PicOK:;

	*w = surf->w;
	*h = surf->h;

    glGenTextures (1, &tex);

	


    int nw=powerof2(surf->w);
    int nh=powerof2(surf->h);
    SDL_Surface *conv =	SDL_CreateRGBSurface (SDL_SWSURFACE, nw, nh, 32, 0x000000FF,
			      0x0000FF00, 0x00FF0000, 0xFF000000);
	
	SDL_BlitSurface (surf, NULL, conv, NULL);
	Uint32* pix = (Uint32*)conv->pixels;


	for (int i=0;i<(nw*nh);i+=1){
		if (bIsPNG == 1){
			Uint32 a;
			a = *(pix+i);
			if (a != 0)
				a = a | 0xFF000000;
			else{
				if ((globallump >= GFX_maskedBotLimit)&&(globallump <= GFX_maskedTopLimit)){
					if (globallump != GFX_maskedExclude)			
						a = a | 0x80000000;
				}
			}
			*(pix+i)=a;		
		}else{
			if ((globallump>=GFX_maskedstart)&&(globallump<=GFX_maskedstop)){
				char *shape = (char*)W_CacheLumpNum (globallump, PU_CACHE, Cvt_transpatch_t, 1);
				transpatch_t *tp = (transpatch_t *) shape;
				if (*(pix+i) == TRANSLEVELCOLOR32)//translevel color (black)
					*(pix+i) = (63 - tp->translevel) << (ALPHA_SHIFT+2);
			}
			if (*(pix+i) == TRANSPARENTCOLOR32)
				*(pix+i) = 0;
			}
	}

    int hasalph=checkalpha((Uint32*) surf->pixels, surf->w, surf->w, surf->h);

	int w1=nw, h1=nh;

	BindTex( tex);
    checkGLStatus ();

    glPixelStorei (GL_UNPACK_SKIP_PIXELS, 0);
    glPixelStorei (GL_UNPACK_SKIP_ROWS, 0);
    glPixelStorei (GL_UNPACK_ALIGNMENT, 1);
    checkGLStatus ();

    glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, nw?GL_REPEAT:GL_CLAMP_TO_EDGE);
    glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, nh?GL_REPEAT:GL_CLAMP_TO_EDGE);
    glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, partialfilter);
    glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, mipmaps?fullfilter:partialfilter);

    if (mipmaps && (fullfilter!=GL_NEAREST) && (fullfilter!=GL_LINEAR)) {
		SetAnisotropic();
		BuildMipmaps ((Uint32*)conv->pixels, w1, h1, hasalph,mipmaps);
    } else {
		glTexImage2D (GL_TEXTURE_2D,0, hasalph?GL_RGBA:GL_RGB, w1, h1, 0, GL_RGBA,
			   GL_UNSIGNED_BYTE, conv->pixels);
    }
    checkGLStatus ();

	globallump = 0;

    SDL_FreeSurface (conv);

    SDL_FreeSurface (surf);




    return tex;
}




 

/********************************************************************/
/*																	*/
/* Function name : HI_ReadBmp										*/
/* Description   : reads a bmp pic into mem							*/
/*																	*/
/********************************************************************/

Uint32 * HI_ReadBmp (LPCSTR file, int *iWidth, int *iHeight)
{
	HBITMAP hBmp;	
	BITMAP  bm;
	unsigned char  *src;
	int w,h,widthalign,c;
    Uint32 *pic,*tgt;
	Uint32 val;

	//Caller must supply enough memory to handle the bmp
	//To get w and h , call first with dest = 0;

	hBmp = (HBITMAP)LoadImage(NULL,file,IMAGE_BITMAP,0,0, LR_CREATEDIBSECTION | LR_LOADFROMFILE );
	if (hBmp == 0)
		return FALSE;

    // Get the size of the bitmap. 
    if (GetObject(hBmp, sizeof(bm), &bm) == 0)
		return FALSE;

	*iWidth = bm.bmWidth;
	*iHeight = bm.bmHeight; 

	pic = (Uint32 *) gl_malloc ((bm.bmWidth*bm.bmHeight)+565000);
	memset(pic,0,(bm.bmWidth*bm.bmHeight)+565000);
	// calculate width DWORD-alignment in scanline
	widthalign = 0;
	c = (bm.bmWidth / 4);
	if ((bm.bmWidth - (c * 4))>0)
		widthalign = (4-(bm.bmWidth - (c * 4))) ;

	// remove all the DWORD-aligned bytes
	// and flip picture
	src = (unsigned char*)bm.bmBits;
	tgt = pic;
/*
	for (h = 0; h< (bm.bmHeight*bm.bmWidth); h++ ){
		val = *src++;
		*tgt++ = val;
	}
	tgt = pic;
		memcpy(tgt ,src,bm.bmWidth*bm.bmHeight);
*/
	for (h = bm.bmHeight-1; h >= 0; h-- ){
		for (w = 0; w <= bm.bmWidth; w++ ){
			val = *(src+(h*bm.bmWidth)+(h*widthalign) + w);
			if (val != 1)
				*(tgt) = val;
			tgt++;
		}
		tgt += (81)-w;
		//memcpy(tgt ,(src+(h*bm.bmWidth)+(h*widthalign)),bm.bmWidth);
		//tgt += bm.bmWidth;
	}

	// remove all the DWORD-aligned bytes
	// and flip picture
/*	src = bm.bmBits;
	tgt = dest;
	for (h = bm.bmHeight-1; h >= 0; h-- ){
		memcpy(tgt ,(src+(h*bm.bmWidth)+(h*widthalign)),bm.bmWidth);
		tgt += bm.bmWidth;
	}*/



	// free objects
	DeleteObject(hBmp);
	return pic;
}




/********************************************************************/
/*																	*/
/* Function name : HI_ReadBmp										*/
/* Description   : reads a bmp pic into mem							*/
/*																	*/
/********************************************************************/
int HI_ReadBmpEx (LPSTR file, byte * dest, int *iWidth, int *iHeight)
{
	HBITMAP hBmp; 	
	BITMAP  bm;
	unsigned char *tgt, *src;
	int h,widthalign,c;

	//Caller must supply enough memory to handle the bmp
	//To get w and h , call first with dest = 0;
	//if (globallump == GFX_ap_world)
	//	hBmp = (HBITMAP)LoadImage (hInst, MAKEINTRESOURCE(187), IMAGE_BITMAP,0,0,LR_CREATEDIBSECTION);
	//else
		hBmp = (HBITMAP)LoadImage(NULL,file,IMAGE_BITMAP,0,0, LR_CREATEDIBSECTION | LR_LOADFROMFILE );
	  
	if (hBmp == 0)
		return FALSE;

    // Get the size of the bitmap. 
    if (GetObject(hBmp, sizeof(bm), &bm) == 0)
		return FALSE;

    if (bm.bmBits == 0)
		return FALSE;

 	*iWidth = bm.bmWidth;
	*iHeight = bm.bmHeight; 

 

	if (dest == 0){
		// free objects
		DeleteObject(hBmp);
		//if we only asks for w x h for pic, return then
		return TRUE;
	}


	// calculate width DWORD-alignment in scanline
	widthalign = 0;
	c = (bm.bmWidth / 4);
	if ((bm.bmWidth - (c * 4))>0)
		widthalign = (4-(bm.bmWidth - (c * 4))) ;

	// remove all the DWORD-aligned bytes
	// and flip picture
	src = (unsigned char*)bm.bmBits;
	tgt = dest;
	for (h = bm.bmHeight-1; h >= 0; h-- ){
		memcpy(tgt ,(src+(h*bm.bmWidth)+(h*widthalign)),bm.bmWidth);
		tgt += bm.bmWidth;
	} 
  
	// free objects
	DeleteObject(hBmp);

    if (bm.bmBitsPixel > 8)
		return 32;

	return TRUE;
}




void FindDiv8Size(int iWidth,int iHeight,int *Div8W,int *Div8H)
{

	int i = 4096;
 
	*Div8W = 128;//default val
	do{
		if (iWidth <= i){
			*Div8W = i;
			i /= 2;
		}else
			break;

	}while (i > 0);

	*Div8H = 128;//default val
	i = 4096;
	do{
		if (iHeight <= i){
			*Div8H = i;
			i /= 2;
		}else
			break;

	}while (i > 0);

}



LPSTR CheckForExtGFX(int globallump)
{

	if (globallump == GFX_ap_world)
		return GFX_PathMish;
	if (globallump == GFX_ap_titl)
		return GFX_PathMish;
	if (globallump == GFX_trilogo)
		return GFX_PathMish;

	if ((globallump>=GFX_wallstart)&&(globallump<=GFX_wallstop))
		return GFX_PathWalls;

	if ((globallump>=GFX_animstart)&&(globallump<=GFX_animstop))
		return GFX_Anim;

	if ((globallump>=GFX_floorstart)&&(globallump<=GFX_floorstop))
		return GFX_PathFloor_Ceil;

	if ((globallump>=GFX_shapestart)&&(globallump<=GFX_shapestop))
		return GFX_PathShape;

	if ((globallump>=GFX_gunsstart)&&(globallump<=GFX_gunsstop))
		return GFX_PathGuns;

	if ((globallump>=GFX_doorstart)&&(globallump<=GFX_doorstop))
		return GFX_PathDoors;

	if ((globallump>=GFX_sidestart)&&(globallump<=GFX_sidestop))
		return GFX_PathSides;

	if ((globallump>=GFX_elevatorstart)&&(globallump<=GFX_elevatorstop))
		return GFX_PathElevators;

	if ((globallump>=GFX_maskedstart)&&(globallump<=GFX_maskedstop))
		return GFX_PathMasked;

	if ((globallump>=GFX_exitstart)&&(globallump<=GFX_exitstop))
		return GFX_PathExits;

	if ((globallump>=GFX_himaskstart)&&(globallump<=GFX_himaskstop))
		return GFX_PathHMSKSTRT;

	if ((globallump>=GFX_abovemaskwallstart)&&(globallump<=GFX_abovemaskwallstop))
		return GFX_PathABVMSTRT;

	if ((globallump>=GFX_abovewallstart)&&(globallump<GFX_abovewallstop))
		return GFX_PathABVWSTRT;

	return 0;
}


void GetPNGname(char *filename, char*pngname)
{
	int h;
	lstrcpy(pngname,filename);
	h = lstrlen(pngname);
	if (h>4) {
		*(pngname+h-3) = 'P';		
		*(pngname+h-2) = 'N';		
		*(pngname+h-1) = 'G';
		return;
	}
	*pngname = 0;
}
void GetBMPname(char *filename, char*bmpname)
{
	int h;
	lstrcpy(bmpname,filename);
	h = lstrlen(bmpname);
	if (h>4) {
		*(bmpname+h-3) = 'B';		
		*(bmpname+h-2) = 'M';		
		*(bmpname+h-1) = 'P';
		return;
	}
	*bmpname = 0;
}
extern "C"{
void MenuGlTest();
}

void MenuGlTest()
{
	//screenbuffertexture = 1;

//GLClearScreenShapes();
//GLAddScreenShape(W_GetNumForName ("trilogo"),0,0,GLSS_CORRECTRATIO|GLSS_OVERLAY);
//	SDL_GL_SwapBuffers ();
UploadPartialOverlay(0, 0, 320, 200);
ShowPartialOverlay(0, 0, 320, 200);

//GLRefresh ();
	SDL_GL_SwapBuffers ();
}



#include <GL/glu.h>
#include "glut.h"
 
void *font = GLUT_BITMAP_TIMES_ROMAN_24; 

void *font0 = GLUT_BITMAP_TIMES_ROMAN_10; 
void *font1 = GLUT_BITMAP_TIMES_ROMAN_24; 
void *font2 = GLUT_BITMAP_HELVETICA_10; 
void *font3 = GLUT_BITMAP_HELVETICA_12; 
void *font4 = GLUT_BITMAP_HELVETICA_18; 
void *font5 = GLUT_BITMAP_8_BY_13; 
void *font6 = GLUT_BITMAP_9_BY_15; 


void putmsg(int x, int y, char *string, int size, int color, float alpha)
{
   int i;
   static GLfloat raster_pos[4];//bna++154

   //float alpha = 0.3;
   switch (size)
   {
		case 0:
			font = font0;
			break;
		case 1:
			font = font1;
			break;
		case 2:
			font = font2;
			break;
		case 3:
			font = font3;
			break;
		case 4:
			font = font4;
			break;
		case 5:
			font = font5;
			break;
		case 6:
			font = font6;
			break;
   }

   glMatrixMode(GL_PROJECTION);
   glPushMatrix();
   glLoadIdentity();
   glOrtho(0,glscreenw,0,glscreenh,-1.0,1.0);
   glDisable(GL_LIGHTING);
   glDisable(GL_DEPTH_TEST); 
   if (color == 0)
		glColor4f(1,0,0,alpha);
   if (color == 1)
		glColor4f(0,1,0,alpha);
   if (color == 2)
		glColor4f(0,0,1,alpha);
   if (color == 3)//yellow
		glColor4f(1,1,0,alpha);

  /* save old raster position */
  glGetFloatv(GL_CURRENT_RASTER_POSITION, raster_pos);//bna++154


   glRasterPos2f(x, y);
   for (i = 0; i < ((int) strlen(string)); i++) {
      glutBitmapCharacter(font, string[i]);
   }
  /* restore old raster position */
  glRasterPos4fv(raster_pos);//bna++154


   glPopMatrix();
 
}


void GL_ShakeScreen()
{

//ShakeVal = 10;
return;


//	Uint32 * buf;
	//int x,  y,  w,  h;

    Uint32 *tmpbuf = (Uint32 *) gl_malloc (glscreenw * glscreenh * 4);
    glDrawBuffer (GL_BACK);
    DrawScreen=0;
    GLRefresh ();
    DrawScreen=1;

    glReadBuffer (GL_BACK);
    glReadPixels (110, 110, glscreenw-110, glscreenh-110, GL_RGBA, GL_UNSIGNED_BYTE,tmpbuf);

	//	memset (tmpbuf,45, 1000);
   glRasterPos2f(0, 0);

	glDrawPixels(glscreenw, glscreenh, GL_RGBA, GL_UNSIGNED_BYTE,tmpbuf);
   glDrawBuffer (GL_BACK);
  //  glReadBuffer (GL_BACK);
    gl_free (tmpbuf);
 SDL_GL_SwapBuffers ();
    DrawScreen=1;

/*
    int rsw=powerof2(glscreenw);
    int rsh=powerof2(glscreenh);
    Uint32 *buf = (Uint32 *) gl_malloc (glscreenw * glscreenh * 4);
    DrawScreenToBuffer (buf, 0, 0, glscreenw, glscreenh);


    int imsave=inmenu;
    inmenu=false;
    memset (buf, 0, w * h * 4);
    Uint32 *tmpbuf = (Uint32 *) gl_malloc (glscreenw * glscreenh * 4);
    glDrawBuffer (GL_BACK);
    DrawScreen=0;
    GLRefresh ();
    inmenu=imsave;
    DrawScreen=1;
    glReadBuffer (GL_BACK);
    glReadPixels (0, 0, glscreenw, glscreenh, GL_RGBA, GL_UNSIGNED_BYTE,
		  tmpbuf);
    int i;
    Uint32 *idpos = (buf + x + w * y);
    for (i = 0; i < (glscreenh); i++) {
		Uint32 *posa = idpos + (w * i);
		Uint32 *posb = tmpbuf + (glscreenw * (glscreenh - i - 1));
		memcpy (posa, posb, glscreenw * 4);
    }
    glDrawBuffer (GL_BACK);
    glReadBuffer (GL_BACK);
    free (tmpbuf);

*/
}




#if (USE_GL_IN_MENU == 1)  

void GLHandleMenu(int DrawScreen)
{
   // if (((inmenu != 0)&&(DrawScreen))||((MenuBufStarted==1)&&(DrawScreen))){	
	 
	OverlayZoom=1;

	int overlay = 1;
    SetDrawMode(GLV_2DOBJECTS);
    glTexEnvf (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
    int lcorrect=1;
    double bbsizeh=((0.75/screenratio)*1.0 - 1.0)/2.0;
    double bbsizev=((screenratio/0.75)*0.75 - 0.75)/2.0;
    double bbsize=bbsizev;    
    double left, right, top, bot;
    
    if (bbsizeh>0) {
		left=-bbsizeh;
		right=1.0+bbsizeh;
		top=0;
		bot=0.75;
    } else {
		left=0;
		right=1.0;
		top=-bbsizev;
		bot=0.75+bbsizev;
    }    
    
    glMatrixMode (GL_PROJECTION);
    glLoadIdentity ();
    gluOrtho2D (left, right, bot, top);
    glMatrixMode (GL_MODELVIEW);
    glLoadIdentity ();
    double ratiocorrectfact=screenratio/0.75;
    int i;
    gl2DObject* cur=twodobjects;
	for (i=0;i<n2dobjects;i++,cur++) {
		glMatrixMode (GL_MODELVIEW);
		glLoadIdentity ();
		glTranslated(cur->x/320.0,cur->y*(0.75/200.0),0);
 		//glTranslated(cur->rtx/320.0,cur->rty*(0.75/200.0),0);
		glScaled(cur->scale,cur->scale,1);
		glRotated(cur->rot,0,0,1);
 		glTranslated(-cur->rtx/320.0,-cur->rty*(0.75/200.0),0);
		cur->draw(cur->data);
	}

    if (UploadScreen) 
		UploadPartialOverlay(0, 0, 320, 200);
	else
		ShowPartialOverlay(0, 0, 320, 200);


    if (DrawScreen)
		SDL_GL_SwapBuffers ();


}





#endif


//bna++146 added start
void *gl_malloc (size_t size)
{
	//return (void*) GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,size);
	return (void*) HEAP_getheapmem(size);
}

void *gl_remalloc (void *p, size_t size)
{
	//return (void*) GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,size);
	return (void*) HEAP_getheapmem(size);
}

void gl_free (void* p)
{
	//HGLOBAL hRet = GlobalFree(p);
	BOOL hRet = HEAP_freemem(p);
	//if (hRet == 0)
	//	ErrorDontQuit("gl_free error in ",(int)p);
}


extern short skywangle;//bna++
extern short skyplayerangle;

extern int   glscreenw;
extern int   glscreenh;



void SetSkyPlayerPos()
{

//	float f1,f2;
//	float dx, dy;
//	long rtx,rty;
	double d = 5.68888;;
	//look to the floor = -170      raintiltangle = 9.86 47.00 95.00 
	//look straight ahead = 0       raintiltangle = (10.08)   = 5.00
	//look up in the sky = 170      raintiltangle = -74.91

	//rainplayerangle goes from 0 to 2048
	//convert from 2048 to 360 degrees
	skyplayerangle = (short)(skyplayerangle/d);//d = 5.68888;

	if (skyplayerangle < 0) 
		skyplayerangle = 0;
	if (skyplayerangle > 360) 
		skyplayerangle = 360;

	skyyrot = (GLfloat)(skyplayerangle * -1);
	skytiltangle = (float)(skywangle/3)*-1;

	if (skytiltangle>90) skytiltangle=90.0;
	if (skytiltangle<-90) skytiltangle=-90.0;

}


#define NBOFALPHANAMES 20

double CheckForExtraAlpha(int lump)
{
	double extraalpha = 1;
	char bfd[64], cc;
	char* explname = W_GetNameForNum (lump);
	// 1 = g_bullet_alpha
	// 2 = g_explo_alpha
	// 3 = g_firej_alpha
	// 4 = g_organ_alpha
	// 5 = g_lifei_alpha

	//name  exitval  length
	char *ns[NBOFALPHANAMES][3] = {
		{ "BULLETHO","1","8"},     
		{ "KSPHERE", "2","7"}, 
		{ "GODFIRE", "2","7"},
		{ "CRFIRE",  "2","6"}, 
		{ "CREXP",   "2","5"}, 
		{ "GREXP",   "2","5"}, 
		{ "FWALL",   "2","5"}, 
		{ "EXP",     "2","3"}, 
		{ "PART",    "2","4"}, 
		{ "FJDOWN",  "3","6"}, 
		{ "FJUP",    "3","4"}, 
		{ "ORGAN",   "4","5"}, 
		{ "BLODS",   "4","5"}, 
		{ "GLIMB",   "4","5"}, 
		{ "GPINK",   "4","5"}, 
		{ "GARM",    "4","4"}, 
		{ "GHIP",    "4","4"}, 
		{ "GUTS",    "4","4"}, 
		{ "GLEG",    "4","4"}, 
		{ "LIFE",    "5","4"} 
	};

	if (explname == 0)
		return extraalpha;//return full alpha = 1

	memset(bfd,0,sizeof(bfd));
	memcpy(bfd,explname,8);
	bfd[8]=0; 

	for (cc = 0; cc < NBOFALPHANAMES; cc++){
		int lenx = atol(ns[cc][2]);
		if (CompareString(LOCALE_USER_DEFAULT, NORM_IGNORECASE,
				(LPCTSTR)bfd, lenx,
				(LPCTSTR)ns[cc][0],lenx) == CSTR_EQUAL)
			break;
	}

	if (cc >= NBOFALPHANAMES)
		return extraalpha;//no name found, return full alpha = 1

	//name found, select proper value
	switch (*ns[cc][1]) {
	    case 49://49 = "1"
			return g_bullet_alpha;
	    case 50:
			return g_explo_alpha;
	    case 51:
			return g_firej_alpha;
	    case 52:
			return g_organ_alpha;
	    case 53:
			return g_lifei_alpha;
	};

	return extraalpha;

}


//bna++148 added
int MakeTexHiResToTexture (void* pixels, int repeat, int mipmaps, int *w, int *h)
{
    GLuint tex;
	int win = *w,hin = *h;

 	Uint32* Strechedbuf = InterpolateStrechBuffer32((Uint32*)pixels,win,hin,win*4,hin*4);
	*w = win*4;
	*h = hin*4;

    glGenTextures (1, &tex);
    int hasalph=checkalpha((Uint32*) Strechedbuf, win*4, win*4, hin*4);
	int nw = win*4, nh = hin*4;
	int w1=nw, h1=nh;

	BindTex( tex);
    checkGLStatus ();

    glPixelStorei (GL_UNPACK_SKIP_PIXELS, 0);
    glPixelStorei (GL_UNPACK_SKIP_ROWS, 0);
    glPixelStorei (GL_UNPACK_ALIGNMENT, 1);
    checkGLStatus ();

    glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, nw?GL_REPEAT:GL_CLAMP_TO_EDGE);
    glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, nh?GL_REPEAT:GL_CLAMP_TO_EDGE);
    glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, partialfilter);
    glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, mipmaps?fullfilter:partialfilter);

    if (mipmaps && (fullfilter!=GL_NEAREST) && (fullfilter!=GL_LINEAR)) {
		SetAnisotropic();
		BuildMipmaps ((Uint32*)Strechedbuf, w1, h1, hasalph,mipmaps);
    } else {
		glTexImage2D (GL_TEXTURE_2D,0, hasalph?GL_RGBA:GL_RGB, w1, h1, 0, GL_RGBA,
			   GL_UNSIGNED_BYTE, Strechedbuf);
    }
    checkGLStatus ();

	globallump = 0;

    return tex;
}





void GLDrawCacheLEDS (int cx, int cy, int angle, int scale)
{


}


//bna ++ 154 function
void GL_FreeRailings()
{
	int i,j;

	for (i = 0; i < 128; i++){
		for (j = 0; j < 128; j++){
			if (railinginfo [i][j] != 0)
				Z_Free ((void*)railinginfo [i][j]);
			railinginfo [i][j] = 0;
		}
	}
}



DWORD GADTick = 0;
int GADcolchange = 5;
int GADcoldir = 1;

UINT *pData = 0; 

void GLRGADchangeCol (unsigned char *sbuf)
{
	int ad = 0;
	unsigned char *pw = (unsigned char*)sbuf;

	if (GetTickCount64() >= (GADTick + 1000)){
		if (GADcoldir == 1)
			GADcoldir = -1;
		else
			GADcoldir = 1;

		GADTick = GetTickCount64();
		if (GADcoldir == 1){ //cnt up
			GADcolchange += 5;
		}else{
			GADcolchange -= 5;
		}
		
	}

	for (ad =0; ad < 320*200; ad++){

*(pw++) = 4;
	}

/*
	for (ad = 0; ad < nw*nh;ad++){
			r1 = *(pw+0);
			g1 = *(pw+1);
			b1 = *(pw+2);
			if ((r1 == g1)&&(g1 == b1)){

			}else{
				*(pw+2) = b1 + GADcolchange;
				
			}
			pw += 4;
		}	*/		
					
//	}
		
}


