/*
Copyright (C) 1994-1995 Apogee Software, Ltd.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

/*
  A lot of the OpenGL code is from LAB3D-SDL by Jan Lönnberg.
  

 */
#define USE_OPENGL 1

#include <windows.h>

#include <stdarg.h>
#include <fcntl.h>
#include <errno.h>
#include <string.h>
#include <stdio.h>
#include <ctype.h>

#ifdef DOS
#include <malloc.h>
#include <dos.h>
#include <conio.h>
#include <io.h>
#endif

#include <stdlib.h>
#include <sys/stat.h>
#include "modexlib.h"
//MED
#include "memcheck.h"
#include "rt_util.h"
#include "rt_in.h"

#ifdef USE_OPENGL
#include "glfuncs.h"
#endif                   
     
     
// GLOBAL VARIABLES
extern boolean  bExtractGFX;
extern boolean  bUseExternalGFX;
extern boolean  bUseExtWallSFX;
extern int GFX_wallstart;
extern void PrepareGFX ();
extern BOOL CenterWindow(HWND hwndChild, HWND hwndParent,UINT Yoffset);

int linewidth;
int ylookup[MAXSCREENHEIGHT*6];
int page1start;
int page2start;
int page3start;
int screensize;
unsigned bufferofs;
unsigned displayofs;
boolean graphicsmode = false;

#ifdef DOS

/*
====================
=
= GraphicsMode
=
====================
*/
void GraphicsMode (void)
{
    union REGS regs;

    regs.w.ax = 0x13;
    //int386 (0x10, &regs, &regs);
    graphicsmode = true;
}

/*
====================
=
= SetTextMode
=
====================
*/
void SetTextMode (void)
{

    union REGS regs;

    regs.w.ax = 0x03;
    //int386 (0x10, &regs, &regs);
    graphicsmode = false;

}

/*
====================
=
= TurnOffTextCursor
=
====================
*/
void TurnOffTextCursor (void)
{

    union REGS regs;

    regs.w.ax = 0x0100;
    regs.w.cx = 0x2000;
    //int386 (0x10, &regs, &regs);

}

#if 0
/*
====================
=
= TurnOnTextCursor
=
====================
*/
void TurnOnTextCursor (void)
{

    union REGS regs;

    regs.w.ax = 0x03;
    //int386 (0x10, &regs, &regs);

}
#endif

/*
====================
=
= WaitVBL
=
====================
*/
void WaitVBL (void)
{
    unsigned char i;

    i = inp (0x03da);
    while ((i & 8) == 0)
	i = inp (0x03da);
    while ((i & 8) == 1)
	i = inp (0x03da);
}


/*
====================
=
= VL_SetLineWidth
=
= Line witdh is in WORDS, 40 words is normal width for vgaplanegr
=
====================
*/

void VL_SetLineWidth (unsigned width)
{
    int i, offset;

//
// set wide virtual screen
//
    outpw (CRTC_INDEX, CRTC_OFFSET + width * 256);

//
// set up lookup tables
//
    linewidth = width * 2;

    offset = 0;

    for (i = 0; i < MAXSCANLINES; i++) {
	ylookup[i] = offset;
	offset += linewidth;
    }
}

/*
=======================
=
= VL_SetVGAPlaneMode
=
=======================
*/

void VL_SetVGAPlaneMode (void)
{
    GraphicsMode ();
    VL_DePlaneVGA ();
    VL_SetLineWidth (48);
    screensize = 208 * SCREENBWIDE;
    page1start = 0xa0200;
    page2start = 0xa0200 + screensize;
    page3start = 0xa0200 + (2u * screensize);
    displayofs = page1start;
    bufferofs = page2start;
    XFlipPage ();
}

/*
=======================
=
= VL_CopyPlanarPage
=
=======================
*/
void VL_CopyPlanarPage (byte * src, byte * dest)
{
    int plane;

    for (plane = 0; plane < 4; plane++) {
	VGAREADMAP (plane);
	VGAWRITEMAP (plane);
	memcpy (dest, src, screensize);
    }
}

/*
=======================
=
= VL_CopyPlanarPageToMemory
=
=======================
*/
void VL_CopyPlanarPageToMemory (byte * src, byte * dest)
{
    byte *ptr;
    int plane, a, b;

    for (plane = 0; plane < 4; plane++) {
	ptr = dest + plane;
	VGAREADMAP (plane);
	for (a = 0; a < 200; a++)
	    for (b = 0; b < 80; b++, ptr += 4)
		*(ptr) = *(src + (a * linewidth) + b);
    }
}

/*
=======================
=
= VL_CopyBufferToAll
=
=======================
*/
void VL_CopyBufferToAll (unsigned buffer)
{
    int plane;

    for (plane = 0; plane < 4; plane++) {
	VGAREADMAP (plane);
	VGAWRITEMAP (plane);
	if (page1start != buffer)
	    memcpy ((byte *) page1start, (byte *) buffer, screensize);
	if (page2start != buffer)
	    memcpy ((byte *) page2start, (byte *) buffer, screensize);
	if (page3start != buffer)
	    memcpy ((byte *) page3start, (byte *) buffer, screensize);
    }
}

/*
=======================
=
= VL_CopyDisplayToHidden
=
=======================
*/
void VL_CopyDisplayToHidden (void)
{
    VL_CopyBufferToAll (displayofs);
}

/*
=================
=
= VL_ClearBuffer
=
= Fill the entire video buffer with a given color
=
=================
*/

void VL_ClearBuffer (unsigned buf, byte color)
{
    VGAMAPMASK (15);
    memset ((byte *) buf, color, screensize);
}

/*
=================
=
= VL_ClearVideo
=
= Fill the entire video buffer with a given color
=
=================
*/

void VL_ClearVideo (byte color)
{
    VGAMAPMASK (15);
    memset ((byte *) (0xa000 << 4), color, 0x10000);
}

/*
=================
=
= VL_DePlaneVGA
=
=================
*/

void VL_DePlaneVGA (void)
{

//
// change CPU addressing to non linear mode
//

//
// turn off chain 4 and odd/even
//
    outp (SC_INDEX, SC_MEMMODE);
    outp (SC_DATA, (inp (SC_DATA) & ~8) | 4);

    outp (SC_INDEX, SC_MAPMASK);	// leave this set throughout

//
// turn off odd/even and set write mode 0
//
    outp (GC_INDEX, GC_MODE);
    outp (GC_DATA, inp (GC_DATA) & ~0x13);

//
// turn off chain
//
    outp (GC_INDEX, GC_MISCELLANEOUS);
    outp (GC_DATA, inp (GC_DATA) & ~2);

//
// clear the entire buffer space, because int 10h only did 16 k / plane
//
    VL_ClearVideo (0);

//
// change CRTC scanning from doubleword to byte mode, allowing >64k scans
//
    outp (CRTC_INDEX, CRTC_UNDERLINE);
    outp (CRTC_DATA, inp (CRTC_DATA) & ~0x40);

    outp (CRTC_INDEX, CRTC_MODE);
    outp (CRTC_DATA, inp (CRTC_DATA) | 0x40);
}


/*
=================
=
= XFlipPage
=
=================
*/

void XFlipPage (void)
{
    displayofs = bufferofs;

//   _disable();

    outp (CRTC_INDEX, CRTC_STARTHIGH);
    outp (CRTC_DATA, ((displayofs & 0x0000ffff) >> 8));

//   _enable();

    bufferofs += screensize;
    if (bufferofs > page3start)
	bufferofs = page1start;
}

#else

#include "SDL.h"

/* rt_def.h isn't included, so I just put this here... */
#if !defined(ANSIESC)
#define STUB_FUNCTION fprintf(stderr,"STUB: %s at " __FILE__ ", line %d, thread %d\n",__FUNCTION__,__LINE__,getpid())
#else
#define STUB_FUNCTION
#endif

/*
====================
=
= GraphicsMode
=
====================
*/
static SDL_Surface *sdl_surface = NULL;
static SDL_Surface *sdl_backbuf = NULL;

extern void set_grab_mode();
extern iGLOBAL_SCREENWIDTH = 800;
extern boolean RunFullscreen;
extern HWND hMainWnd;

HWND GL_ViewPortWindow = 0;
#include "SDL.h"
#define GLWNDTEXT "Rise of the Triad, open GL version 1.78"


void GraphicsMode (void)
{
    Uint32 flags = 0;
    int w, h, d;
    int fullscreen;
    char *fsstr;
	char *gstr;
    int realr, realg, realb, realz, reald;

    if (SDL_InitSubSystem
			(SDL_INIT_VIDEO | SDL_INIT_AUDIO | SDL_INIT_NOPARACHUTE) < 0) {
		Error ("Could not initialize SDL\n");
    }

	
    flags |= SDL_FULLSCREEN;
    SDL_WM_GrabInput (SDL_GRAB_ON);

    fullscreen = 1;
    fsstr = getenv ("ROTTSDL_FS");
    if (fsstr) {
		fullscreen = atoi (fsstr);
    }

    gstr = getenv ("ROTTSDL_GEOM");
    if (!gstr || sscanf(gstr,"%dx%d",&glscreenw,&glscreenh)!=2) {
		glscreenw = 640;
		glscreenh = 480;
    }

//ROTTSDL_GEOM=1024 x 768
	if (iGLOBAL_SCREENWIDTH == 320) {
		glscreenw = 320;
		glscreenh = 200;
	}
	if (iGLOBAL_SCREENWIDTH == 640) {
		glscreenw = 640;
		glscreenh = 480;
	}
	if (iGLOBAL_SCREENWIDTH == 800) {
		glscreenw = 800;
		glscreenh = 600;
	}
	if (iGLOBAL_SCREENWIDTH == 1024) {
		glscreenw = 1024;
		glscreenh = 768;
	}
  	if (iGLOBAL_SCREENWIDTH == 1152) {
		glscreenw = 1152;
		glscreenh = 864;
	}
	if (iGLOBAL_SCREENWIDTH == 1280) {
		glscreenw = 1280;
		glscreenh = 1024;
	} 

	if (iGLOBAL_SCREENWIDTH == 1680) {
		glscreenw = 1680;
		glscreenh = 1050;
	}

	if (iGLOBAL_SCREENWIDTH == 1920) {   //<--ADAM***  CHECK??
		glscreenw = 1920;     //<--ADAM***  CHECK??
		glscreenh = 1080;     //<--ADAM***  CHECK??
	}



    flags |= SDL_OPENGL;

    if (fullscreen)
		flags |= SDL_FULLSCREEN;


	if (RunFullscreen == FALSE)
		flags ^= SDL_FULLSCREEN;

    SDL_GL_SetAttribute (SDL_GL_RED_SIZE, 8);
    SDL_GL_SetAttribute (SDL_GL_GREEN_SIZE, 8);
    SDL_GL_SetAttribute (SDL_GL_BLUE_SIZE, 8);
    SDL_GL_SetAttribute (SDL_GL_DEPTH_SIZE, 24);
    SDL_GL_SetAttribute (SDL_GL_DOUBLEBUFFER, 1);
    SDL_GL_SetAttribute (SDL_GL_STENCIL_SIZE, 1);
    SDL_GL_SetAttribute (SDL_GL_ACCUM_RED_SIZE, 0);
    SDL_GL_SetAttribute (SDL_GL_ACCUM_GREEN_SIZE, 0);
    SDL_GL_SetAttribute (SDL_GL_ACCUM_BLUE_SIZE, 0);
    SDL_GL_SetAttribute (SDL_GL_ACCUM_ALPHA_SIZE, 0);
    w = glscreenw;
    h = glscreenh;
    d = 32;


    SDL_WM_SetCaption (GLWNDTEXT, "ROTT");
    SDL_ShowCursor (0);


    sdl_surface = SDL_SetVideoMode (w, h, d, flags);

    set_grab_mode();

    if (sdl_surface == NULL) {
		
		Error ("Could not set video mode\n");
    }


    SDL_GL_GetAttribute (SDL_GL_RED_SIZE, &realr);
    SDL_GL_GetAttribute (SDL_GL_GREEN_SIZE, &realg);
    SDL_GL_GetAttribute (SDL_GL_BLUE_SIZE, &realb);
    SDL_GL_GetAttribute (SDL_GL_DEPTH_SIZE, &realz);
    SDL_GL_GetAttribute (SDL_GL_DOUBLEBUFFER, &reald);

    if (reald == 0) {
	
		Error ("Double buffer not available.\n");
    }

    if (realz < 24) {
	
		Error ("Warning: Depth buffer resolution too low\n");
    }

	if (GFX_wallstart == 0) 
	   PrepareGFX (); 

   

	//bna++148
	{
		HWND wh;
		char t[256];
		GL_ViewPortWindow = 0;

		wh = GetWindow( hMainWnd,  GW_HWNDFIRST  );
		for (w=0;w<1256;w++){
			GetWindowText(wh,t,sizeof(t));
			if (lstrcmpi(t,GLWNDTEXT)==0){
				GL_ViewPortWindow = wh;
				CenterWindow(GL_ViewPortWindow,GetDesktopWindow(),0);
				UpdateWindow(hMainWnd);
				break; 
			}
			wh = GetWindow( wh,  GW_HWNDNEXT  ); 
		}

	}  
	//bna++ 154
	SetFocus(GL_ViewPortWindow);// handle to gl window

	ShowWindow(GL_ViewPortWindow,SW_MINIMIZE);
	UpdateWindow(GL_ViewPortWindow);
	UpdateWindow(hMainWnd);
	GLInit();   
	ShowWindow(GL_ViewPortWindow,SW_SHOWNORMAL);
	UpdateWindow(GL_ViewPortWindow);	

}
   
/*
====================
=
= SetTextMode
=
====================
*/
void SetTextMode (void)
{
    if (SDL_WasInit (SDL_INIT_VIDEO) == SDL_INIT_VIDEO) {

		if (sdl_surface != NULL) {
			SDL_FreeSurface (sdl_surface);

			sdl_surface = NULL;
		}   
		//SDL_QuitSubSystem (SDL_INIT_VIDEO);
		SDL_VideoQuit();
		//SDL_Quit();

    }
}

/*
====================
=
= TurnOffTextCursor
=
====================
*/
void TurnOffTextCursor (void)
{
}

/*
====================
=
= WaitVBL
=
====================
*/
void WaitVBL (void)
{
#ifndef USE_OPENGL
    SDL_Delay (16667 / 1000);
#endif
}

/*
=======================
=
= VL_SetVGAPlaneMode
=
=======================
*/

void VL_SetVGAPlaneMode (void)
{
    int i, offset;

    GraphicsMode ();

//
// set up lookup tables
//
    linewidth = 320;

    offset = 0;

    for (i = 0; i < MAXSCANLINES; i++) {
	ylookup[i] = offset;
	offset += linewidth;
    }

    screensize = MAXSCREENHEIGHT * MAXSCREENWIDTH;




#ifdef USE_OPENGL
    page1start = (int)screenbuffer;
#else
    page1start = (int)sdl_surface->pixels;
#endif
    page2start = page1start;
    page3start = page2start;
    displayofs = page1start;
    bufferofs = page2start;
    XFlipPage ();

}

/*
=======================
=
= VL_CopyPlanarPage
=
=======================
*/
void VL_CopyPlanarPage (byte * src, byte * dest)
{
#ifdef DOS
    int plane;

    for (plane = 0; plane < 4; plane++) {
	VGAREADMAP (plane);
	VGAWRITEMAP (plane);
	memcpy (dest, src, screensize);
    }
#else
    memcpy (dest, src, screensize);
#endif
}

/*
=======================
=
= VL_CopyPlanarPageToMemory
=
=======================
*/
void VL_CopyPlanarPageToMemory (byte * src, byte * dest)
{
#ifdef DOS
    byte *ptr;
    int plane, a, b;

    for (plane = 0; plane < 4; plane++) {
	ptr = dest + plane;
	VGAREADMAP (plane);
	for (a = 0; a < 200; a++)
	    for (b = 0; b < 80; b++, ptr += 4)
		*(ptr) = *(src + (a * linewidth) + b);
    }
#else
    memcpy (dest, src, screensize);
#endif
}

/*
=======================
=
= VL_CopyBufferToAll
=
=======================
*/
void VL_CopyBufferToAll (unsigned buffer)
{
#ifdef DOS
    int plane;

    for (plane = 0; plane < 4; plane++) {
	VGAREADMAP (plane);
	VGAWRITEMAP (plane);
	if (page1start != buffer)
	    memcpy ((byte *) page1start, (byte *) buffer, screensize);
	if (page2start != buffer)
	    memcpy ((byte *) page2start, (byte *) buffer, screensize);
	if (page3start != buffer)
	    memcpy ((byte *) page3start, (byte *) buffer, screensize);
    }
#endif
}

/*
=======================
=
= VL_CopyDisplayToHidden
=
=======================
*/
void VL_CopyDisplayToHidden (void)
{
    VL_CopyBufferToAll (displayofs);
}

/*
=================
=
= VL_ClearBuffer
=
= Fill the entire video buffer with a given color
=
=================
*/

void VL_ClearBuffer (unsigned buf, byte color)
{
#ifdef DOS
    VGAMAPMASK (15);
    memset ((byte *) buf, color, screensize);
#else
    memset ((byte *) buf, color, screensize);
#endif
}

/*
=================
=
= VL_ClearVideo
=
= Fill the entire video buffer with a given color
=
=================
*/

void VL_ClearVideo (byte color)
{
//#ifdef DOS
  //  VGAMAPMASK (15);
    //memset ((byte *) (0xa000 << 4), color, 0x10000);
//#elif USE_OPENGL
    memset (screenbuffer, color, MAXSCREENWIDTH * MAXSCREENHEIGHT);
//#else
  //  memset (sdl_surface->pixels, color, MAXSCREENWIDTH * MAXSCREENHEIGHT);
//#endif
}



/*
=================
=
= VL_DePlaneVGA
=
=================
*/

void VL_DePlaneVGA (void)
{
}

extern int bordercolor;		// I know, I should just include the header.
/* C version of rt_vh_a.asm */

// This is used to save the border pixels
static unsigned char *pixbuf = NULL;



void DrawSimBorder (SDL_Surface * surf)
{
    unsigned char *pixels = (unsigned char *)surf->pixels;
    int ofs[4];
    unsigned char *pos[4];
    unsigned char *spos[4];
	int xx, yy, z;

    // Simulate a border flash
    if (bordercolor != 0) {
	if (!pixbuf) {
	    pixbuf = malloc (surf->w * surf->h);
	}
	printf ("drawing border\n");

	ofs[0] = 0;
	ofs[1] = surf->w;
	ofs[2] = surf->w * (surf->h - 1);
	ofs[3] = surf->w * (surf->h - 2);
	for (z = 0; z < 4; z++) {
	    pos[z] = pixels + ofs[z];
	    spos[z] = pixbuf + ofs[z];
	}
	for (xx = 0; xx < surf->w; xx++) {
	    for (z = 0; z < 4; z++) {
		*(spos[z]++) = *(pos[z]);
		*(pos[z]++) = bordercolor;
	    }
	}

	ofs[0] = surf->w * 2;
	ofs[1] = ofs[0] + 1;
	ofs[2] = ofs[0] + surf->w - 1;
	ofs[3] = ofs[0] + surf->w - 2;
	for (z = 0; z < 4; z++) {
	    pos[z] = pixels + ofs[z];
	    spos[z] = pixbuf + ofs[z];
	}
	for (yy = 2; yy < surf->h - 2; yy++) {
	    for (z = 0; z < 4; z++) {
		*(spos[z]) = *(pos[z]);
		*(pos[z]) = bordercolor;
		spos[z] += surf->w;
		pos[z] += surf->w;
	    }
	}
    }
}



void EraseSimBorder (SDL_Surface * surf)
{
    unsigned char *pixels = (unsigned char *)surf->pixels;
    int ofs[4];
    unsigned char *pos[4];
    unsigned char *spos[4];
	int xx, yy, z;

    if (bordercolor != 0) {
	printf ("erasing border\n");

	ofs[0] = 0;
	ofs[1] = surf->w;
	ofs[2] = surf->w * (surf->h - 1);
	ofs[3] = surf->w * (surf->h - 2);
	for (z = 0; z < 4; z++) {
	    pos[z] = pixels + ofs[z];
	    spos[z] = pixbuf + ofs[z];
	}
	for (xx = 0; xx < surf->w; xx++) {
	    for (z = 0; z < 4; z++) {
		*(pos[z]++) = *(spos[z]++);
	    }
	}
	ofs[0] = 0;
	ofs[1] = 1;
	ofs[2] = surf->w - 1;
	ofs[3] = surf->w - 2;
	for (z = 0; z < 4; z++) {
	    pos[z] = pixels + ofs[z];
	    spos[z] = pixbuf + ofs[z];
	}
	for (yy = 0; yy < surf->h; yy++) {
	    for (z = 0; z < 4; z++) {
		*(pos[z]) = *(spos[z]);
		spos[z] += surf->w;
		pos[z] += surf->w;
	    }
	}
    }
}


void VH_UpdateScreen (void)
{
    SDL_Surface *surf = SDL_GetVideoSurface ();
#ifdef USE_OPENGL
    GLRefresh ();
#else
    DrawSimBorder (surf);
    SDL_UpdateRect (surf, 0, 0, 0, 0);
    EraseSimBorder (surf);
#endif
}

/*
=================
=
= XFlipPage
=
=================
*/

void XFlipPage (void)
{
#ifdef USE_OPENGL
    GLRefresh ();

#else
    DrawSimBorder (sdl_surface);
    SDL_UpdateRect (sdl_surface, 0, 0, 0, 0);
    EraseSimBorder (sdl_surface);
#endif
}

#endif
