 
/******************************************************************************
 org_rotthelp.c 

 Copyright  2022 by Birger N. Andreasen 
 Please send any bugreports, comments and other issues to:
 E-Mail = bna@bbsyd.dk
 Homepage with other ROTT stuff = http://www.riseofthetriad.dk/

 ******************************************************************************/


#include <windowsx.h>
#include <windows.h>
#include <commctrl.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <io.h>
#include <stdio.h>

#include "resource.h"

extern HWND	hMainWnd;
extern HINSTANCE hInst;

LRESULT CALLBACK HelpboxProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);
extern long LoadResourceToFixedMem(LPSTR Type, int sndnb, void** bufferptr);
extern void LZ_Uncompress(unsigned char* in, unsigned char* out, unsigned int insize);


//----------------------------------------------------------------------
// Mesage handler for help box.
LRESULT CALLBACK HelpboxProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
	case WM_INITDIALOG:
	{
		byte* loadbuffer;
		//first we unpack the lz res
		int lz_size = LoadResourceToFixedMem("LZ", IDL_ORGHLP_LZ, &loadbuffer);
		byte* outbuffer = GlobalAlloc(GMEM_FIXED | GMEM_ZEROINIT, lz_size * 3);
		LZ_Uncompress(loadbuffer, outbuffer, lz_size);
		//get the correct old msdos font
		HFONT hFont = CreateFont(14, 10, 0, 0, 0, FALSE, 0, 0, OEM_CHARSET, OUT_RASTER_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, FIXED_PITCH, "System");
		SendMessage(GetDlgItem(hDlg, IDC_EDIT1), WM_SETFONT, (WPARAM)hFont, 0);
		SetDlgItemText(hDlg, IDC_EDIT1, (byte*)outbuffer);// !dialog handle and control ID
		HGLOBAL hr = GlobalFree(loadbuffer);
		hr = GlobalFree((HGLOBAL)outbuffer);
		}
		break;
	case WM_CTLCOLORSTATIC:
	{
		if ((HWND)lParam == GetDlgItem(hDlg, IDC_EDIT1))
		{	//fix the correct org color
			SetBkColor((HDC)wParam, RGB(0, 0, 0));
			SetTextColor((HDC)wParam, RGB(85, 255, 255));
			return (LRESULT)GetSysColorBrush(COLOR_WINDOW);
		}
		break;
	}
	break;
	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL)
		{
			EndDialog(hDlg, LOWORD(wParam));
			return TRUE;
		}
		break;
	}
	return FALSE;
}


















