

/******************************************************************************
 
 Rain.c

 Copyright  2006, Birger N. Andreasen 
 Please send any bugreports, comments and other issues to:
 E-Mail = bna@post10.tele.dk
 Homepage with other ROTT stuff = http://www.riseofthetriad.dk/
/******************************************************************************/
 


#include <windows.h>
#include <gl\gl.h>	
#include <GL/glu.h>
#include <math.h>
#include "rain.h"
#include "rt_def.h" // for defn. of types
#include "rt_scale.h" // for transparentlevel


void GLInitRain(RAIN *rain);
void GLDrawRain(RAIN *rain);
void SetRainPlayerPos(RAIN *rain);
void GLInitRain(RAIN *rain);

extern short modelwangle;

extern short rainwangle;//bna++
extern int   rainxmove;
extern int   rainymove;
extern long  plx,ply,plz,plang,plmomx,plmomy,plmomz;
extern short rainplayerangle;

extern int   glscreenw;
extern int   glscreenh;

GLfloat rainyrot;
GLfloat rainboxxpos;
GLfloat rainboxypos;
GLfloat rainboxzpos;
GLfloat raintiltangle;



/********************************************************************/
/*																	*/
/* Function name : GLInitRain										*/
/* Description   :													*/
/*																	*/
/********************************************************************/
void GLInitRain(RAIN *rain)
{
	int i;

	rainboxxpos = 0.0f;
	rainboxypos = -3.0f;
	rainboxzpos = -8.0f;
	raintiltangle = 5.0f;

    rain->tilex = 6;
    rain->tiley = 67;
	rain->x=20;// 20 = 5 tiles; x,y,z //dimensions of the rainbox
	rain->y=50*1;
	rain->z=20;
	rain->dtr = 0.3f;//color of raindrop top
	rain->dtg = 0.3f;
	rain->dtb = 0.4f;
	rain->dbr = 0.5f;//color of raindrop bottom
	rain->dbg = 0.5f;
	rain->dbb = 0.6f;
	rain->dropwidth=0.7f;//dropwidth: thickness of the drops
	rain->xg=0.0f;//xg,yg,zg: gravety forces (gravity,wind)
	rain->yg=-0.002f;
	rain->zg=0.0f;
	rain->fade=rain->yg*-10;
	rain->droplength=-rain->yg*500;//droplengths
	rain->drops = (DROP*)malloc(NUMDROPS * (sizeof(DROP)));
	for (i=0; i<NUMDROPS;i++){
		rain->drops[i].xb = (float)(((rand()%(rain->x*20))-rain->x*10.0f)/10.0f);
		rain->drops[i].yb = (float)1.0;
		rain->drops[i].zb = (float)(((rand()%(rain->z*20))-(rain->z)*10.0f)/10.0f);
		rain->drops[i].xt = rain->drops[i].xb;
		rain->drops[i].yt = 1.0;
		rain->drops[i].zt = rain->drops[i].zb;
		rain->drops[i].xv = 0.0f;
		rain->drops[i].yv = (rand()%1000)/-10000.0f;
		rain->drops[i].zv = 0.0f;
		rain->drops[i].alpha = 0.0f;
	}

}


/********************************************************************/
/*																	*/
/* Function name : GLDrawRain										*/
/* Description   :													*/
/*																	*/
/********************************************************************/
GLdouble screenprop1, screenprop2;
void GLDrawRain(RAIN *rain)
{
//	GLfloat ytranslate;
	GLdouble screenprop1, screenprop2;
	int i, tx, ty;

    //is rain visible?
    BOOL bShowRain = FALSE;
	for (tx = rain->tilex; tx < rain->tilex + 4;tx++){
		for (ty = rain->tiley; ty < rain->tiley + 4;ty++){
			if (spotvis[tx][ty]) {
				bShowRain=TRUE;
				break;
			}
		}
	}
	
	if (bShowRain == FALSE)
		return;

	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);
	glMatrixMode(GL_PROJECTION);					
	glLoadIdentity();									

	screenprop1 = ((GLdouble)glscreenh/(GLdouble)glscreenw)*100;
	screenprop2 = (GLdouble)glscreenw/(GLdouble)glscreenh;
	gluPerspective(screenprop1,screenprop2,0.1f,100.0f);

	glMatrixMode(GL_MODELVIEW);			
	glLoadIdentity();							
	
	glRotatef(raintiltangle,1.0,0.0,0.0);
	glRotatef(rainyrot,0.0f,1.0f,0.0f);
	glTranslatef(rainboxxpos, 0.0,rainboxzpos);
	
	for(i=0;i<NUMDROPS;i++)	{	
			glBegin(GL_LINES);
				//draw the rain drops
				glColor4f(rain->dtr,rain->dtg,rain->dtb,rain->drops[i].alpha-0.1f);
				glVertex3f(rain->drops[i].xt,rain->drops[i].yt,rain->drops[i].zt);
				glColor4f(rain->dbr,rain->dbg,rain->dbb,rain->drops[i].alpha);
				glVertex3f(rain->drops[i].xb,rain->drops[i].yb,rain->drops[i].zb);
			glEnd();	

			rain->drops[i].xb+=rain->drops[i].xv;
			rain->drops[i].xt+=rain->drops[i].xv-rain->drops[i].xv*0.01f;
			rain->drops[i].xv+=rain->xg;
			rain->drops[i].yb+=rain->drops[i].yv;
			rain->drops[i].yt+=rain->drops[i].yv;
			rain->drops[i].yv+=rain->yg;
			rain->drops[i].zb+=rain->drops[i].zv;
			rain->drops[i].zt+=rain->drops[i].zv-rain->drops[i].zv*0.01f;
			rain->drops[i].zv+=rain->zg;
			rain->drops[i].alpha+=rain->fade;
			if (rain->drops[i].yt<-30)	{	
				rain->drops[i].alpha=0.0f;
				rain->drops[i].xb=(float)(((rand()%(rain->x*20))-rain->x*10.0f)*0.1f);
				rain->drops[i].yb=(float)(rain->y);
				rain->drops[i].zb=(float)(((rand()%(rain->z*20))-(rain->z)*10.0f)*0.1f);
				rain->drops[i].xt=rain->drops[i].xb;
				rain->drops[i].yt=rain->drops[i].yb+rain->droplength;
				rain->drops[i].zt=rain->drops[i].zb;
				rain->drops[i].xv=0.0f;
				rain->drops[i].yv=(rand()%1000)*(-0.001f);
				rain->drops[i].zv=0.0f;
		}

	}
}


/********************************************************************/
/*																	*/
/* Function name : SetRainPlayerPos									*/
/* Description   :													*/
/*																	*/
/********************************************************************/
void SetRainPlayerPos(RAIN *rain)
{
//	int r;
	float f1,f2;
//    float angle, dx, dy, dz, yzangle, xydist, _2Ddiag;
	float dx, dy;
	long rtx,rty;
	double d = 5.68888;;

	//calc dist and dir to rain tile relative from player
	//rain posx = rainxtile * 0xFFFF 
	//rain posy = rainytile * 0xFFFF  rt_draw.h

	//playerx = plx;
	//playery = ply;

	//convert from tile to long x,y pos
	rtx = rain->tilex * 0xFFFF;
	rty = rain->tiley * 0xFFFF;
	//calc dx,dy from player to rain
    dx = (float)(rtx - plx);
    dy = (float)(ply - rty);

	f1 = (float)(dx/0xFFFF);	
	f2 = (float)(dy/0xFFFF);	

	rainboxxpos = f2*-5.0f;
	rainboxzpos = f1*-5.0f;

	//look to the floor = -170      raintiltangle = 9.86 47.00 95.00 
	//look straight ahead = 0       raintiltangle = (10.08)   = 5.00
	//look up in the sky = 170      raintiltangle = -74.91

	//rainplayerangle goes from 0 to 2048
	//convert from 2048 to 360 degrees
	rainplayerangle = (short)(rainplayerangle/d);//d = 5.68888;

	if (rainplayerangle < 0) 
		rainplayerangle = 0;
	if (rainplayerangle > 360) 
		rainplayerangle = 360;

	rainyrot = (GLfloat)(rainplayerangle * -1);
	raintiltangle = (float)(rainwangle/3)*-1;

	if (raintiltangle>90) raintiltangle=90.0;
	if (raintiltangle<-90) raintiltangle=-90.0;

}








