/*
Copyright (C) 1994-1995 Apogee Software, Ltd.
 
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#pragma warning( disable : 4761 )  // Disable warning messages
#include "DPwinrott.h"
//#include <windows.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <ctype.h>
#include <dos.h>
#include <process.h>
#include <stdarg.h>
#include <bios.h>
#include <ctype.h>
#include "rt_def.h"
#include "_rt_com.h"
#include "rt_com.h"
#include "rt_util.h"
#include "rt_in.h"
#include "rt_crc.h"
#include "rt_playr.h"
#include "isr.h"
#include "rt_msg.h" 
#include "rottnet.h"
#include "rt_main.h"
#include "rt_net.h"
#include "rt_draw.h"
#include "rt_ser.h"
//MED
#include "memcheck.h"

extern void DisEnableRottButtons(BOOL bDisEnable);


int  PlayerNB=1; // 0=server ;1=player on top; 2-11 player 2 - 11
int  FreePlayerNB = 2; // 0=player on top;
int  G_FrameRate=2;
int  G_Numplayers=2;
boolean ishost=true;
boolean bOldModemGame;
unsigned long G_DPIDAdress = 0;
BOOL bUseOldTCP_IPstyle = 0;
BOOL bOTserver = 0;

/*
typedef struct {
	byte dwDestination;							// message type ()
	byte dwSender;								// message type ()
	__int16 dwDatalen;
	char szMsg[2048+128];	// message string (variable length)
} ROTT_DATASTRING, *LPROTT_DATASTRING;
*/
extern ROTT_DATASTRING		G_RottData;

extern boolean iDeadbodyIsTarget;//bna++ 1.76


// GLOBAL VARIABLES

// Same as in real mode
rottcom_t   *	rottcom;
int badpacket;
int consoleplayer;
byte ROTTpacket[MAXCOMBUFFERSIZE];
int controlsynctime;

// LOCAL VARIABLES
static union REGS comregs;
static int    ComStarted=false;
static int    transittimes[MAXPLAYERS];

void SyncTime( int client );
void SetTransitTime( int client, int time );
int  ticcount();
extern int iG_portnb ;
//int  G_PlayerRandvalue;

int  StoragePacketDataLength;
int  StoragePacketNode=-1;

extern int DPRecv_data();
extern int DPSend_data();
extern int SetupDPConn();
extern void	WriteLBtext(LPSTR txt);
extern void    disableRottButtons();
extern void    enableRottButtons();
extern int InitClientTCP_IP_socket (LPSTR SrvName, int portnb );
extern int InitServerTCP_IP_socket (LPSTR SrvName, int portnb );

//volatile int ticcount;
int ticcount(void){	return GetTicCount();}
extern void EnableExtraOptions(byte level);
extern void DisableExtraOptions(byte level);

/*
===============
=
= InitROTTNET
=
===============
*/
#define DEFAULT_PORT 61000//5001
void InitROTTNET (void)
{
	int netarg,portnb;
//	long netaddress;
	char ConnToIP[256]="";

	if (ComStarted==true)
		return;
	ComStarted=true;

	netarg=CheckParm ("net");
	netarg++;


	rottcom = (rottcom_t *) malloc (sizeof(rottcom_t));
    memset(rottcom, 0, sizeof(rottcom_t));

    netarg = CheckParm("port");
    if (netarg && netarg < _argc-1) {
       	portnb = atoi(_argv[netarg+1]);
    } else {
       	portnb = DEFAULT_PORT;
    }

	netarg = CheckParm ("server");
	if (netarg > 0){//use the old tcp net code
		bUseOldTCP_IPstyle = TRUE;
		bOTserver = TRUE;
		rottcom->gametype = 0;//1;// 0 = modem  1 = network
		rottcom->ticstep = 1;
		rottcom->remotenode = 0;
		InitServerTCP_IP_socket ("", portnb );
        rottcom->consoleplayer = 0;
		rottcom->numplayers = 2;
		rottcom->client = 0;
		consoleplayer = 0;
		standalone=false;
       	rottcom->client = 0;
		PlayerNB = 1; // 0=server ;1=player on top; 2-11 player 2 - 11
		G_Numplayers = 2;
		ishost=true;
		modemgame=true;
		networkgame=false;
		player = 0;
		return;
	}
	netarg = CheckParm ("client");
	if (netarg > 0){//use the old tcp net code
		bUseOldTCP_IPstyle = TRUE;
		bOTserver = FALSE;
		rottcom->gametype = 0;//1;// 0 = modem  1 = network
		rottcom->ticstep = 1;
		rottcom->remotenode = 0;
		rottcom->numplayers = 2;
		InitClientTCP_IP_socket (_argv[netarg+1], portnb );
        rottcom->client = 1;
 		rottcom->consoleplayer = 1;
		consoleplayer = 1;
		standalone=false;
       	rottcom->client = 1;
		PlayerNB = 2; // 0=server ;1=player on top; 2-11 player 2 - 11
		G_Numplayers = 2;
		ishost=false;
		modemgame=true;
		networkgame=false;
		//player = 1;
		return;
	}
     
	//else use directplay
	DisEnableRottButtons(FALSE);
	SetupDPConn();//get DirectPlay data dialog
//	DisEnableRottButtons(TRUE);


	if ((G_FrameRate == 0)||(G_FrameRate > 4)){
		G_FrameRate = 2;
		/*
		// test for packet framerate
		// test cpu speed in 5 ms ; 330mhz = x = 14101
		// rottcom->ticstep get send with gamedescrption
		t1 = ticcount()+1;do {}while(ticcount()<t1);
		x = 0;t1 = ticcount()+5;do {x++;}while(ticcount()<t1);
		if (x < 16000) { // set framerate
			rottcom->ticstep = 4;
			WriteLBtext("8.75 FPS control update speed");
		}else if (x < 32000) {
			rottcom->ticstep = 3;
			WriteLBtext("11.7 FPS control update speed");
		}else if (x < 48000) {
			rottcom->ticstep = 2;
			WriteLBtext("17.5 FPS control update speed");
		}else {
			rottcom->ticstep = 1;
			WriteLBtext("35 FPS control update speed");
		}*/
	}

	rottcom->ticstep = G_FrameRate - 1;
	rottcom->numplayers	= G_Numplayers;
	numplayers = rottcom->numplayers;
	rottcom->gametype = 1;
	rottcom->remotenode = 0;

    if (ishost==true) {
		if (numplayers == 2) {//if numplayers = 2, use old modem socket (fast)
			rottcom->gametype = 0;//1;// 0 = modem  1 = network
		}
	
		//if (InitServerFTP_IP_socket ("",portnb ) != 1){return;}//bna++

       	if (CheckParm("standalone")) {
       		rottcom->consoleplayer = 0;
			consoleplayer =0;
			standalone=true;
       	} else {
			if (rottcom->gametype == 0){
       			rottcom->consoleplayer = 0;
				consoleplayer =0;
				standalone=false;
			}else{
       			rottcom->consoleplayer = 1;
				consoleplayer =1;
				standalone=false;
			}
       	}
       	
       	if (CheckParm("remoteridicule")) {
       		rottcom->remoteridicule = 1;
       	} else {
       		rottcom->remoteridicule = 0;
       	}
       	/*
       	netarg = CheckParm("players");
       	if (netarg && netarg < _argc-1) {
       		rottcom->numplayers = atoi(_argv[netarg+1]);
       	} else {
       		rottcom->numplayers = 2;
       	}
   		*/
       	rottcom->client = 0;
		PlayerNB = 1; // 0=server ;1=player on top; 2-11 player 2 - 11
	    //rottcom->remotenode = 0;
    } else {
       	rottcom->client = 1;
		PlayerNB = 2; // 0=server ;1=player on top; 2-11 player 2 - 11

		if (rottcom->gametype == 0){
			//modem type
       		rottcom->consoleplayer = 1;
			consoleplayer = 1;
		}else{
			//network type
       		rottcom->consoleplayer = 2;
			consoleplayer = 2;
		}
		netarg=CheckParm ("net");
		if (netarg) {
			netarg++;
			if (_argv[netarg] != 0){
				strcpy (ConnToIP,_argv[netarg]);
			}
		}
		//if (InitClientFTP_IP_socket (ConnToIP,portnb ) != 1){return;}//bna++
	}


	if (rottcom->gametype == 0){
		modemgame=true;
		networkgame=false;
	}else{
		modemgame=true;
		networkgame=true;
	}

   if (rottcom->ticstep != 1)
      remoteridicule = false;
   if (remoteridicule == true)
      {
      if (!quiet)
         WriteLBtext("ROTTNET: LIVE Remote Ridicule Enabled\n");
      }

   if (!quiet)
      {
//      sprintf(ConnToIP,"ROTTNET: Communicating on port %ld\n",iG_portnb);
//	  WriteLBtext(ConnToIP);
//      sprintf(ConnToIP,"ROTTNET: consoleplayer=%ld\n",rottcom->consoleplayer);
//	  WriteLBtext(ConnToIP);
      }


   //dont use iDeadbodyIsTarget in netgame or game goes out of sync bna++ 1.76
   DisableExtraOptions(0);

}

/*
================
=
= ReadPacket
=
================
*/

boolean ReadPacket (void)
{
   word   crc;
   word   sentcrc;

   badpacket = 0;
	rottcom->remotenode = -1;
   // Check to see if a packet is ready

   // int386(rottcom->intnum,&comregs,&comregs);
   if((rottcom->client == 0)||(IsServer==true)) {
	   	if ((StoragePacketNode >= 0)&&(networkgame==true)){//is there a packet for player 1
			//yes we have a localpacket (to server consoleplayer)
			G_RottData.dwDatalen  = StoragePacketDataLength; 
			StoragePacketNode = -1;
			G_RottData.dwSender = 1;
			goto UseLocalpacket;
		}else{
			if (DPRecv_data() == -1){return false;}
		}
   }else{
		if (DPRecv_data() == -1){return false;}
		//use client socket
		//0 is from server
		if (G_RottData.dwSender != 0){return false;}
   }

   if (networkgame==true){
	   // PlayerNB is client consoleplayer on this computer
	   if ((G_RottData.dwDestination != PlayerNB)||(G_RottData.dwDestination==G_RottData.dwSender)){
			rottcom->remotenode = -1;
			return false;
	   }
   }

   // is packet length inside bounds
   if ((G_RottData.dwDatalen <= 0 )||(G_RottData.dwDatalen > 2048)){
		rottcom->remotenode = -1;
		return false;
   }
UseLocalpacket:;

   // calculate crc on packet
   //crc=CalculateCRC (&rottcom->data[0], rottcom->datalength-sizeof(word));
   crc=CalculateCRC (&G_RottData.szMsg [0],G_RottData.dwDatalen-sizeof(word));

   // get crc inside packet
   //sentcrc=*((word *)(&rottcom->data[rottcom->datalength-sizeof(word)]));
   sentcrc=*((word *)(&G_RottData.szMsg [G_RottData.dwDatalen-sizeof(word)]));

   // are the crcs the same?
    if (crc!=sentcrc)
    {
        badpacket=1;
        SoftError("BADPKT at %ld\n",ticcount());
    }
    if (networkgame==false)
    {
        //rottcom->remotenode=server;
 	    G_RottData.dwSender = server;;
    }
    else
    {
	    if ((IsServer==true) && (G_RottData.dwSender >0)){
			G_RottData.dwSender--;
            //rottcom->remotenode--;
		}
    }
    memcpy(&ROTTpacket[0], &G_RottData.szMsg [0],G_RottData.dwDatalen);
	rottcom->remotenode = G_RottData.dwSender;

    
	return true;

}


/*
=============
=
= WritePacket
=
=============
*/
//extern unsigned long DPIDPlayerAdress[12][2];
void WritePacket (void * buffer, int len, int destination)
{
   word      crc;
//   int       rc;

   G_RottData.dwDestination = destination;

   if (len>(MAXCOMBUFFERSIZE-sizeof(word)))
   {
      Error("WritePacket: Overflowed buffer\n");
   }

   // copy local buffer into realmode buffer
//   memcpy((byte *)&(rottcom->data[0]),(byte *)buffer,len);
   memcpy((byte *)&(G_RottData.szMsg[0]),(byte *)buffer,len);



   // calculate CRC
   crc=CalculateCRC (buffer, len);

   // put CRC into realmode buffer packet
//   *((word *)&rottcom->data[len])=crc;
   *((word *)&G_RottData.szMsg[len])=crc;

   // set size of realmode packet including crc
   //rottcom->datalength=len+sizeof(word);
   G_RottData.dwDatalen = len+sizeof(word);

   if (*((byte *)buffer)==0)
       Error("Packet type = 0\n");

   if (networkgame==true)
      {
	   if (IsServer==true){
          //rottcom->remotenode++; // server fix-up
		  G_RottData.dwDestination++;
	   }
      }

   // Send It !
if (rottcom != 0){
   if((rottcom->client == 0)||(IsServer==true)) {
	   if ((G_RottData.dwDestination == 1)&&(networkgame==true)){ //here 1 or 2
		   //store localpacket to server consoleplayer
			StoragePacketNode = destination;//data is still in G_RottData for next read
			StoragePacketDataLength = G_RottData.dwDatalen;//rottcom->datalength;
	   }else{
		   G_RottData.dwSender      = 0;
		   DPSend_data();
	   }
   }else{
	    //send to server = 1 (server do rottcom->remotenode-- when receving = 0;)
		G_RottData.dwDestination = 1;
		G_RottData.dwSender      = PlayerNB;
		DPSend_data();
   }
}

}




/*
=============
=
= ValidSyncPacket
=
=============
*/
boolean ValidSyncPacket ( synctype * sync )
{
   if (ReadPacket() && (badpacket==0))
      {
      if (((syncpackettype *)&(ROTTpacket[0]))->type==COM_SYNC)
         {
         memcpy(&(sync->pkt),&(ROTTpacket[0]),sizeof(sync->pkt));
         return true;
         }
      }
   return false;
}

/*
=============
=
= SendSyncPacket
=
=============
*/
void SendSyncPacket ( synctype * sync, int dest)
{
   sync->pkt.type=COM_SYNC;
   sync->sendtime=ticcount();
   WritePacket( &(sync->pkt.type) , sizeof(syncpackettype) , dest );
}


/*
=============
=
= SlavePhaseHandler
=
=============
*/

boolean SlavePhaseHandler( synctype * sync )
{
   boolean done;

   done=false;

   switch (sync->pkt.phase)
      {
      case SYNC_PHASE1:
         break;
      case SYNC_PHASE2:
         ISR_SetTime(sync->pkt.clocktime);
         break;
      case SYNC_PHASE3:
         sync->pkt.clocktime=ticcount();
         break;
      case SYNC_PHASE4:
         ISR_SetTime(ticcount()-sync->pkt.delta);
         sync->pkt.clocktime=ticcount();
         break;
      case SYNC_PHASE5:
         ISR_SetTime(ticcount()-sync->pkt.delta);
         sync->sendtime=sync->pkt.clocktime;
         done=true;
         break;
      }
   return done;
}



/*
=============
=
= MasterPhaseHandler
=
=============
*/

boolean MasterPhaseHandler( synctype * sync )
{
   boolean done;

   done=false;

   switch (sync->pkt.phase)
      {
      case SYNC_PHASE1:
         sync->pkt.phase=SYNC_PHASE2;
         sync->pkt.clocktime=ticcount()+(sync->deltatime>>1);
         break;
      case SYNC_PHASE2:
         sync->pkt.phase=SYNC_PHASE3;
         break;
      case SYNC_PHASE3:
         sync->pkt.delta=sync->pkt.clocktime-ticcount()+(sync->deltatime>>1);
         sync->pkt.phase=SYNC_PHASE4;
         break;
      case SYNC_PHASE4:
         sync->pkt.phase=SYNC_PHASE5;
         sync->pkt.delta=sync->pkt.clocktime-ticcount()+(sync->deltatime>>1);
         sync->sendtime=ticcount()+SYNCTIME;
         sync->pkt.clocktime=sync->sendtime;
         done=true;
         break;
      }
   return done;
}


/*
=============
=
= SetTime
=
=============
*/

void SetTime ( void )
{
   int i;
   syncpackettype * syncpacket;
   boolean done=false;

   syncpacket=(syncpackettype *)SafeMalloc(sizeof(syncpackettype));


   // Sync clocks

   if (networkgame==true)
      {
      if (IsServer==true)
         {
         for (i=0;i<numplayers;i++)
            {
            if (PlayerInGame(i)==false)
               continue;
            if (standalone==true)
               SyncTime(i);
            else if (i!=consoleplayer)
               SyncTime(i);
            if (standalone==true)
               printf("SetTime: player#%ld\n",i);
            }
         }
      else
         {
         SyncTime(0);
         }
      }
   else // Modem 2-player game
      {
      if (consoleplayer==0)
         SyncTime(server);
      else
         SyncTime(server);
      }

   if ( ( (networkgame==true) && (IsServer==true) ) ||
        ( (networkgame==false) && (consoleplayer==0) )
      ) // Master/Server
      {
      int nump;
      int time;

      syncpacket->type=COM_START;
      syncpacket->clocktime=ticcount();
      controlsynctime=syncpacket->clocktime;
      if (networkgame==true)
         nump=numplayers;
      else
         nump=1;

      time = ticcount();

      for (i=0;i<nump;i++)
         {
         WritePacket( &(syncpacket->type) , sizeof(syncpackettype) , i );
         }

      while (ticcount()<time+(VBLCOUNTER/4)) ;

      for (i=0;i<nump;i++)
         {
         WritePacket( &(syncpacket->type) , sizeof(syncpackettype) , i );
         }

      if (standalone==true)
         printf("SetTime: Start packets sent\n");
      }
   else // Slave/Client
      {
      while (done==false)
         {
         AbortCheck("SetTime aborted as client");

         if (ReadPacket() && (badpacket==0))
            {
            memcpy(syncpacket,&(ROTTpacket[0]),sizeof(syncpackettype));
            if (syncpacket->type==COM_START)
               {
               controlsynctime=syncpacket->clocktime;
               done=true;
               }
            }
         }
      }
   if (standalone==false)
      {
      AddMessage("All players synched.",MSG_SYSTEM);
      ThreeDRefresh();
      }
   SafeFree(syncpacket);

//
// flush out any extras
//
   while (ticcount()<controlsynctime+VBLCOUNTER)
      {
      ReadPacket ();
      }
}

/*
=============
=
= InitialMasterSync
=
=============
*/
void InitialMasterSync ( synctype * sync, int client )
{
   boolean done=false;
   int i;

   if (networkgame==true)
      {
      for (i=0;i<numplayers;i++)
         {
         if (i<=client)
            continue;
         sync->pkt.type=COM_SYNC;
         sync->pkt.phase=SYNC_MEMO;
         sync->pkt.clocktime=client;
         SendSyncPacket(sync,i);
         }
      }

   // Initialize send time so as soon as we enter the loop, we send

   sync->sendtime=ticcount()-SYNCTIME;

   while (done==false)
      {
      sync->pkt.phase=SYNC_PHASE0;

      AbortCheck("Initial sync aborted as master");
	   if ((sync->sendtime+SYNCTIME) <= ticcount())
         SendSyncPacket(sync,client);
      if (ValidSyncPacket(sync)==true)
         {
         if (sync->pkt.phase==SYNC_PHASE0)
            {
            int time=ticcount();

            while (time+SYNCTIME>ticcount())
               {
               ReadPacket();
               }
            time=ticcount();
            while (time+SYNCTIME>ticcount()) {}
            done=true;
            }
         }
      }
}

/*
=============
=
= InitialSlaveSync
=
=============
*/
void InitialSlaveSync ( synctype * sync )
{
   boolean done=false;

   while (done==false)
      {
      AbortCheck("Initial sync aborted as slave");
      if (ValidSyncPacket(sync)==true)
         {
         if (sync->pkt.phase==SYNC_MEMO)
            {
            char str[50]="Server is synchronizing player ";
            char str2[10];

            strcat(str,itoa(sync->pkt.clocktime+1,str2,10));
            AddMessage(str,MSG_SYSTEM);
            ThreeDRefresh();
            }
         if (sync->pkt.phase==SYNC_PHASE0)
            {
            int time=ticcount();

            SendSyncPacket(sync,server);
            while (time+SYNCTIME>ticcount())
               {
               ReadPacket();
               }
            done=true;
            }
         }
      }
   AddMessage("Server is synchronizing your system",MSG_SYSTEM);
   ThreeDRefresh();
}


/*
=============
=
= SyncTime
=
=============
*/

void SyncTime( int client )
{
   int dtime[NUMSYNCPHASES];
   boolean done;
   int i;
   synctype * sync;

   sync=(synctype *)SafeMalloc(sizeof(synctype));

   if ( ((networkgame==true) && (IsServer==true)) ||
         ((networkgame==false) && (consoleplayer==0)) )
      {
      // Master

      InitialMasterSync ( sync, client );

      done=false;

      // Initial setup for Master
      // Initialize send time so as soon as we enter the loop, we send

      sync->pkt.phase=SYNC_PHASE1;
      sync->sendtime=ticcount()-SYNCTIME;

      while (done==false)
         {
         // Master

         AbortCheck("SyncTime aborted as master");

		   if ((sync->sendtime+SYNCTIME) <= ticcount())
            SendSyncPacket(sync,client);

         while (ValidSyncPacket(sync)==true)
            {

            // find average delta

            sync->deltatime=0;

            // calculate last delta

            dtime[sync->pkt.phase]=ticcount()-sync->sendtime;

            for (i=0;i<=sync->pkt.phase;i++)
               sync->deltatime+=dtime[i];
            if (i!=0)
               sync->deltatime/=i;
            else
               Error("SyncTime: this should not happen\n");

            done = MasterPhaseHandler( sync );

            SendSyncPacket(sync,client);

            }
         }
      }
   else
      {
      // Slave

      InitialSlaveSync ( sync );

      done=false;

      while (done==false)
         {
         // Slave

         AbortCheck("SyncTime aborted as slave");

         while (ValidSyncPacket(sync)==true)
            {
            done = SlavePhaseHandler( sync );

            if (done==false)
               SendSyncPacket(sync,server);

            }
         }
      }

   while (sync->sendtime > ticcount())
      {
      while (ReadPacket()) {}
      }
   while ((sync->sendtime+SYNCTIME) > ticcount())
      {
      }

   if ( ((networkgame==true) && (IsServer==true)) ||
         ((networkgame==false) && (consoleplayer==0)) )
      SetTransitTime( client, (sync->deltatime>>1));

   SafeFree(sync);
}

/*
=============
=
= SetTransitTime
=
=============
*/

void SetTransitTime( int client, int time )
{
   transittimes[client]=time;
}

/*
=============
=
= GetTransitTime
=
=============
*/

int GetTransitTime( int client )
{
   return transittimes[client];
}


/*
=============
=
= ComSetTime
=
=============
*/

void ComSetTime ( void )
{
   int i;
   syncpackettype * syncpacket;
   boolean done=false;

//   char buf[128];


   syncpacket=(syncpackettype *)SafeMalloc(sizeof(syncpackettype));


   // Sync clocks

   if (networkgame==true)
      {
      if (IsServer==true)
         {
         for (i=0;i<numplayers;i++)
            {
            if (PlayerInGame(i)==false)
               continue;
            if (standalone==true)
               SyncTime(i);
            else if (i!=consoleplayer)
               SyncTime(i);
            if (standalone==true)
               printf("ComSetTime: player#%ld\n",(long int)i);
            }
         }
      else
         {
         SyncTime(0);
         }
      }
   else // Modem 2-player game
      {
      if (consoleplayer==0)
         SyncTime(server);
      else
         SyncTime(server);
      }

   if ( ( (networkgame==true) && (IsServer==true) ) ||
        ( (networkgame==false) && (consoleplayer==0) )
      ) // Master/Server
      {
      int nump;
      int time;

      syncpacket->type=COM_START;
      syncpacket->clocktime=GetTicCount();
      controlsynctime=syncpacket->clocktime;
      if (networkgame==true)
         nump=numplayers;
      else
         nump=1;

      time = GetTicCount();

      for (i=0;i<nump;i++)
         {
         WritePacket( &(syncpacket->type) , sizeof(syncpackettype) , i );
         }

      while (GetTicCount()<time+(VBLCOUNTER/4)) ;

      for (i=0;i<nump;i++)
         {
         WritePacket( &(syncpacket->type) , sizeof(syncpackettype) , i );
         }

      if (standalone==true)
         printf("ComSetTime: Start packets sent\n");
      }
   else // Slave/Client
      {
      while (done==false)
         {
         AbortCheck("ComSetTime aborted as client");

         if (ReadPacket() && (badpacket==0))
            {
            memcpy(syncpacket,&(ROTTpacket[0]),sizeof(syncpackettype));
            if (syncpacket->type==COM_START)
               {
               controlsynctime=syncpacket->clocktime;
               done=true;
               }
            }
         }
      }
   if (standalone==false)
      {
      AddMessage("All players synched.",MSG_SYSTEM);
      ThreeDRefresh();
      }
   SafeFree(syncpacket);

//
// flush out any extras
//
   while (GetTicCount()<controlsynctime+VBLCOUNTER)
      {
      ReadPacket ();
      }

//is ok

}
