/*
Copyright (C) 1994-1995 Apogee Software, Ltd.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 
*/
#include "rt_def.h"
#include "rt_sound.h"
#include "_rt_soun.h"
#include "fx_man.h"
#include "music.h"
#include "z_zone.h"
#include "w_wad.h"
#include "rt_main.h"
#include "rt_ted.h"
#include "rt_menu.h"
#include "rt_playr.h"
#include "rt_util.h"
#include "rt_rand.h"
#include "watcom.h"
#include <stdio.h>
#include <stdlib.h>

#if PLATFORM_DOS
#include <mem.h>
#include <io.h>
#elif PLATFORM_UNIX
#include <unistd.h>
#endif

#include "rt_cfg.h"
#include "isr.h"
#include "develop.h"
#include "rt_net.h"

#include "rt_str.h"

#if (SHAREWARE==0)
#include "snd_reg.h"
#else
#include "snd_shar.h"
#endif
//MED
#include "memcheck.h"
#include "resource.h"

typedef struct tagWAVEFILE
  {
  DWORD           cbSize;                // Size of file
  LPWAVEFORMATEX  pwfxInfo;              // Wave Header
  LPBYTE          pbData;                // Wave Bits
  int length;
  char name[12];

  }
WAVEFILE, *LPWAVEFILE;

typedef struct tagWAVEFILEEXT
  {
  DWORD           cbSize;                // Size of file
  WAVEFORMATEX    pwfxInfo;              // Wave Header
  LPBYTE          pbData;                // Wave Bits
  int length;
  char name[12];

  }
WAVEFILEEXT, *LPWAVEFILEEXT;

extern char Thunderpath1[256];//
extern char Thunderpath2[256];//
extern char Thunderpath3[256];//
extern void MP3musicPlaySound(LPSTR name);

extern char Waterpath3[256];
extern int iUseWaterSnd;
extern long LoadResourceToFixedMem (LPSTR Type ,int sndnb, void **bufferptr);
extern boolean inautomap;

extern int  Midi_StoreSongPosition (void);
extern void Midi_RestoreSongPosition (int);
extern BOOL DS_StopAllSounds ();
extern BOOL DS_StopOneSound (int chan);
extern void	DS_PlayVocSound(char *ptr,int size,int pitchoffset,int angle,int distance,WAVEFILE  pWaveFile);
extern boolean FindValidPathFilename  (char *filename);
extern void	WriteLBtext(LPSTR txt);
int BotSndNb, TopSndNum;//used to SurroundEffect filter
extern void DS_LoadExternSounds();
extern void ErrorDontQuit (char *error, int i,...);
extern int W_GetSoundnameForNum ( int sndnum );
extern void DS_WriteVOCtofile (char *data, int sndnum, int size, char*name);
extern char* DS_ConvertVOCtoWAV(char *data, int sndnum, int size);
extern BOOL GetWaveInfo (  unsigned char   *lpChunkOfMemory,// Points to raw ram
					LPWAVEFORMATEX  *lplpWaveHeader, // Points to pointer to header
					LPBYTE          *lplpWaveSamples,// Points to pointer to samples
					LPDWORD          lpcbWaveSize);  // Points to size
extern void MP3musicPlay(LPSTR name);
extern byte* HEAP_getheapmem(int size);
extern BOOL  HEAP_freemem(LPVOID lpMem);
extern void UpdateScore(unsigned int num);
extern void UpdateLives(int num);
extern void DrawScore(boolean bufferofsonly);
extern int AddMessage(char* text, int flags);
extern void HealPlayer(int points, objtype* ob);

// Local Variables
char SFXPath[256];
extern HINSTANCE hInst;
byte *surround = 0;
extern int iUseSurroundEffect;
extern int DS_Surroundeffect;
extern boolean bUseExtWallSFX;
extern boolean bUseExtSFX;

extern boolean lightning;

static int soundstart;
static int soundtype;
int SD_Started = false;
static boolean PositionStored = false;
static int NumBadSounds = 0;
static int remotestart;
static boolean SoundsRemapped = false;

//keeps track of extracted sounds
extern long iExternSounds[500];//contains all handle to soundmemblocks
extern long iExternSoundsSize[500];//sizes of ditto

int musicnums[11] = {
    -1, UltraSound, SoundBlaster, SoundMan16, ProAudioSpectrum,
    Awe32, SoundScape, WaveBlaster, GenMidi, SoundCanvas, Adlib
};

int fxnums[11] = {
    -1, UltraSound, SoundBlaster, SoundMan16, ProAudioSpectrum,
    Awe32, SoundScape, Adlib, SoundSource, TandySoundSource, PC
};

void MU_SetupGUSInitFile (void);



int MUSIC_GetPosition (void)
{
    songposition pos;
#if (USEDIRECTMUSIC == 1)
    return (Midi_StoreSongPosition ());
#endif
    MUSIC_GetSongPosition (&pos);
    return pos.milliseconds;
}

void MUSIC_SetPosition (int time)
{
#if (USEDIRECTMUSIC == 1)
    Midi_RestoreSongPosition (time);
    return;
#endif
    MUSIC_SetSongTime ((unsigned long)time);
}


//***************************************************************************
//
// SoundNumber
//
//***************************************************************************

int SoundNumber (int x)
{
    if ((x >= SD_REMOTEM1SND) && (x <= SD_REMOTEM10SND))
		return remotestart + x - SD_REMOTEM1SND;
//      sounds[x].snds[soundtype]+remotestart;
    else
		return sounds[x].snds[soundtype] + soundstart;
}


//***************************************************************************
//
// SD_MakeCacheable - Make a sound that has just finished playing cacheable again
//
//***************************************************************************
void SD_MakeCacheable (unsigned long sndnum)
{
    if (sndnum == (unsigned long)-1) {
	return;
    }

    if (sndnum >= MAXSOUNDS) {
	SoftError ("Illegal sound value in SD_MakeCacheable value=%ld\n",
		   sndnum);
	return;
    }
    sounds[sndnum].count--;
    if (sounds[sndnum].count > 0)
	return;
    else
	W_CacheLumpNum (SoundNumber (sndnum), PU_CACHE, CvtFixme, 1);
}

#if 0
//***************************************************************************
//
// SD_PrintActive
//
//***************************************************************************
void SD_PrintActive (void)
{
    int i;

    myprintf ("Active Sounds\n");
    for (i = 0; i < MAXSOUNDS; i++) {
	if (sounds[i].count > 0) {
	    myprintf ("sound active #%ld\n", i);
	}
    }
}
#endif

//***************************************************************************
//
// SD_SetupFXCard - Initialize sound Tables and start up sound card
//
//***************************************************************************

int SD_SetupFXCard (int *numvoices, int *numbits, int *numchannels)
{
    fx_device device;
    int status;
    int card;

    if (SD_Started == true)
	SD_Shutdown ();

    if ((FXMode < 0) || (FXMode >= 11)) {
	return (0);
    }

    card = fxnums[FXMode];
    if (card == -1)		// Check if it is off
	return (0);
    if ((card == SoundBlaster) || (card == Awe32)) {
	extern fx_blaster_config SBSettings;

	status = FX_SetupSoundBlaster (SBSettings, numvoices,
				       numbits, numchannels);
    } else {
	status = FX_SetupCard (card, &device);
	if (status == FX_Ok) {
	    *numvoices = device.MaxVoices;
	    *numbits = device.MaxSampleBits;
	    *numchannels = device.MaxChannels;
	}
    }

    return (status);
}

//***************************************************************************
//
// SD_Startup - Initialize sound Tables and start up sound card
//
//***************************************************************************

extern LPBYTE hgtmpmem;
extern int iUseOrgThunder;

int SD_Startup (boolean bombonerror)
{
    int status;
    int card = 1;
    int voices;
    int channels;
    int bits;
    int i;
    extern boolean IS8250;

    if (SD_Started == true)
		SD_Shutdown ();

	GetCurrentDirectory(sizeof(SFXPath),SFXPath);
	lstrcat(SFXPath,"\\SFX\\");

	if (bUseExtSFX == TRUE){ 
		for (i = 0; i< 500;i++)
			iExternSounds[i] = -1;
		DS_LoadExternSounds();
	}

    if ((FXMode < 0) || (FXMode >= 11)) {
		return (0);
    }
	

	{
	unsigned char *loadbuffer = 0;
	//make sure our sound folder exists
	char soundpath[256];//
	//char Thunderpath1[256];//
	DWORD bwritten;



	strcpy(soundpath,ApogeePath);
	strcat(soundpath,"\\SFX");
	CreateDirectory(soundpath, NULL);






/*
	if (iUseWaterSnd != 0){
		//check if our watersnd is in folder?
		sprintf(Waterpath3,"%s\\%Water_2_11025.wav",soundpath);
		if (_access(Waterpath3,0)!=0){
			int size = LoadResourceToFixedMem ("WAVE", IDR_WAVE15,(void**) &loadbuffer);
			//Now we can open a file to save to ( again i'm using windows functions but it doesnt matter what file I/O functions you use of course) 
			HANDLE file = CreateFile ( Waterpath3 , GENERIC_WRITE, FILE_SHARE_READ,
			NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL );
			if ( file != NULL )
				WriteFile ( file, loadbuffer,size,&bwritten, NULL );
			CloseHandle ( file );
			loadbuffer = GlobalFree (hgtmpmem);//release mem;


		}

	}
*/

	if (iUseOrgThunder != 0){
		//check if our thunder  is in folder?
		

		sprintf(Thunderpath1,"%s\\Thunder_1_11025.wav",soundpath);
		if (_access(Thunderpath1,0)!=0){
			int size = LoadResourceToFixedMem ("WAVE", IDR_WAVE2,(void**) &loadbuffer);
			//Now we can open a file to save to ( again i'm using windows functions but it doesnt matter what file I/O functions you use of course) 
			HANDLE file = CreateFile ( Thunderpath1 , GENERIC_WRITE, FILE_SHARE_READ,
			NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL );
			if ( file != NULL )
				WriteFile ( file, loadbuffer,size,&bwritten, NULL );
			CloseHandle ( file );
			//loadbuffer = GlobalFree (hgtmpmem);//release mem;
			(BOOL)loadbuffer = HEAP_freemem (hgtmpmem);//release mem;
		}
		sprintf(Thunderpath2,"%s\\Thunder_2_11025.wav",soundpath);
		if (_access(Thunderpath2,0)!=0){
			int size = LoadResourceToFixedMem ("WAVE", IDR_WAVE3,(void**) &loadbuffer);
			//Now we can open a file to save to ( again i'm using windows functions but it doesnt matter what file I/O functions you use of course) 
			HANDLE file = CreateFile ( Thunderpath2 , GENERIC_WRITE, FILE_SHARE_READ,
			NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL );
			if ( file != NULL )
				WriteFile ( file, loadbuffer,size,&bwritten, NULL );
			//loadbuffer = GlobalFree (hgtmpmem);//release mem;
			(BOOL)loadbuffer = HEAP_freemem (hgtmpmem);//release mem;
			CloseHandle ( file );
		}
		sprintf(Thunderpath3,"%s\\Thunder_3_11025.wav",soundpath);
		if (_access(Thunderpath3,0)!=0){
			int size = LoadResourceToFixedMem ("WAVE", IDR_WAVE4,(void**) &loadbuffer);
			//Now we can open a file to save to ( again i'm using windows functions but it doesnt matter what file I/O functions you use of course) 
			HANDLE file = CreateFile ( Thunderpath3 , GENERIC_WRITE, FILE_SHARE_READ,
			NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL );
			if ( file != NULL )
				WriteFile ( file, loadbuffer,size,&bwritten, NULL );
			//loadbuffer = GlobalFree (hgtmpmem);//release mem;
			(BOOL)loadbuffer = HEAP_freemem (hgtmpmem);//release mem;
			CloseHandle ( file );
		}
	}


	}
remotestart=W_GetNumForName("remostrt")+1;
SD_Started=true;
    /*
#if (USEDIRECTSOUND == 1)    //bna added
 	if (FindValidPathFilename("REMOTE1.RTS")==false){
		WriteLBtext("Remote1.rts not found, using default sounds");
		//simply use avalible sounds
		remotestart=W_GetNumForName("digistrt")+1;
	}else{
		WriteLBtext("Loading Remote1.rts RR sounds");
		remotestart=W_GetNumForName("remostrt")+1;
	}
    SD_Started=true;  
  
#endif     
    */
    /* bna--154
    card = fxnums[FXMode];
	if (card == -1)		// Check if it is off
		return (0);

    switch (card) {
    case UltraSound:
    case SoundBlaster:
    case SoundMan16:
    case ProAudioSpectrum:
    case Awe32:
    case SoundSource:
    case TandySoundSource:
    case SoundScape:
	soundstart = W_GetNumForName ("digistrt") + 1;
	soundtype = fx_digital;
	break;
    case Adlib:
	soundstart = W_GetNumForName ("adstart") + 1;
	soundtype = fx_muse;
	break;
    case PC:
	soundstart = W_GetNumForName ("pcstart") + 1;
	soundtype = fx_muse;
	break;
    default:
	Error ("FX: Unsupported Card number %d", FXMode);
	break;
    }
	*/
	soundstart = W_GetNumForName ("digistrt") + 1;
	soundtype = fx_digital;

    if (soundtype == fx_digital) {
		if (SoundsRemapped == false) {
			for (i = 0; i < SD_LASTSOUND; i++) {
				int snd;	
//				byte * snddata;

				snd = sounds[i].snds[fx_digital];
				if (snd >= 0) {
					sounds[i].snds[fx_digital] = W_GetNumForName (W_GetNameForNum (snd + soundstart));

				}
			}
			SoundsRemapped = true;

//-----------------------------------------------------------------------------
			//bna added
			//if (bUseExtSFX == TRUE)
			{
				BOOL res;
				//make sure our sound folder exists
				char soundpath[256];//
				int sndnb = 0,t1,t2;
				//used to SurroundEffect filter
				t1 = W_GetNumForName("C_HITWAL");
				t2 =  W_GetNumForName("E_SPRING");
				strcpy(soundpath,ApogeePath);
				strcat(soundpath,"\\SFX");
				res = CreateDirectory(soundpath, NULL);
				if (res == 1)
					WriteLBtext("Extracting all sounds"); 
				else
					WriteLBtext("Converting sounds from VOC to WAV"); 


				for (i = 0; i < SD_LASTSOUND; i++) {
					int vocsize;	
					byte * snddata, *vocname;
					if (sounds[i].snds[fx_digital] >= 0) {
						char *wav;
						char tmpsndname[256] = "";
						//ErrorDontQuit("SND",i);
						//if (i==195)
						//	i=i;
						snddata = W_CacheLumpNum(sounds[i].snds[0],PU_STATIC, CvtNull, 1);
						vocsize = W_LumpLength(sounds[i].snds[0]);
						vocname = (byte*)W_GetSoundnameForNum(i);
						//if (res == 1)//if no directory write file
						//	DS_WriteVOCtofile (snddata,i ,vocsize,vocname);

						//create filename
						sprintf(tmpsndname,"%s\\SFX\\%d.%s.wav",ApogeePath,i,vocname);

						if (_access(tmpsndname,0)==-1)
							DS_WriteVOCtofile (snddata,i ,vocsize,vocname);

						wav = (char*)DS_ConvertVOCtoWAV(snddata,i ,vocsize);
						if (iExternSounds[i] <= 0){
							iExternSounds[i] = (long)wav;
							iExternSoundsSize[i] = vocsize+200;
						}

						//used to SurroundEffect filter
						if ((i >= 0)&&(i < 274)){
							if ((fx_digital >= 0)&&(fx_digital <= 2)){
								if (sounds[i].snds[fx_digital] == t1)
									BotSndNb = i;
								if (sounds[i].snds[fx_digital] == t2)
									TopSndNum = i;
							}
						}
					
					}


				}
			//}else{//just convert VOC to WAV and store them
			}

		}
	soundstart = 0;
    }
	WriteLBtext("End converting sounds from VOC to WAV"); 
    voices = NumVoices;
    channels = NumChannels;
    bits = NumBits;

    if (IS8250) {
	voices = max (voices, 4);
	channels = 1;
	bits = 8;
    }
#ifdef DOS
    status = FX_Init (card, voices, channels, bits, 11000);
#else
    status = FX_Init (card, voices, channels, bits, 11025);
#endif

    if (status != FX_Ok) {
	if (bombonerror) {
	    DeleteSoundFile ();
	    Error ("%s\n", FX_ErrorString (status));
	}

	return (status);
    }

    if (stereoreversed == true) {
	FX_SetReverseStereo (!FX_GetReverseStereo ());
    }

    FX_SetCallBack (SD_MakeCacheable);

    remotestart = W_GetNumForName ("remostrt") + 1;

    SD_Started = true;

    FX_SetVolume (FXvolume);



	WriteLBtext("Exit SD_Startup"); 
    return (0);
}

//***************************************************************************
//
// SD_SoundOkay - checks to see if the sound is okay
//
//***************************************************************************

boolean SD_SoundOkay (int sndnum)
{
    if (SD_Started == false)
	return false;

    if ((sndnum >= MAXSOUNDS)&&(sndnum != WATERSNDWATERWALL)&&(sndnum != WATERSNDHEALBASSIN))
		Error ("Illegal sound number, sound number = %d\n", sndnum);

    if (SoundOffset (sndnum) == -1)
	return false;

    if ((sounds[sndnum].flags & SD_PLAYONCE) &&
	(SD_SoundActive (sounds[sndnum].prevhandle))) {
	return false;
    }

    return true;
}

//***************************************************************************
//
// SD_PlayIt - Play a pre-setup sound
//
//***************************************************************************
//extern byte GetMemBlock (int size);


int THNB = 1,lastsndnum=0, currentsndnum = -1;
DWORD lastSndTck = 0;
extern int iUseOrgThunder;

char* WaterSndWavHpool = 0;
int   WaterSndWavHpoolSize = 0;
char* WaterSndWavWWall = 0;
int   WaterSndWavWWallSize = 0;


int iUseSimpleSound = 0;
extern UINT WS_PlayRottSound(int sndnum, char *SndInMem, int size, BOOL bLoop, int angle, int distance, int pitch);



//char *Riddnddata[10];
//int   Riddnddatasize[10];
int ankhcoin = 0;

int SD_PlayIt ( int sndnum, int angle, int distance, int pitch )
{
	int voice = 0;
	byte * snd;
	int vocsize;
	WAVEFILE  pWaveFile;
	//char ssd[255];
	//currentsndnum = sndnum; 

	//birger added v 1.76
	//it was easier just to interupt snd here for ankh coin
	if (sndnum == 102 && ankhcoingivpoint == 1) {//give point for collect spinning ankh coins if SD_GETBONUSSND is played
		gamestate.score += 100;
		UpdateScore(gamestate.score);
		DrawScore(1);
		//AddMessage("Collected a ankh coin! 50 Points yeah", 12);
		ankhcoin++;
		if (ankhcoin > 25) {
			ankhcoin = 0;
			AddMessage("Collected 25 Ankh coins give some health!", 12); 
			HealPlayer(99, player);//MSG_BONUS = 12
		}
	}
	//sprintf(ssd, "%d", sndnum);
	//WriteLBtext(ssd);


	//bna++146
	if (GetTickCount() <= lastSndTck + 100){
		if (sndnum == lastsndnum){
				return 0;
		}
	}


	if (iUseSimpleSound == 1){//our sound do not work, try simple snd
		snd = (char *) W_CacheLumpNum(SoundNumber(sndnum),PU_STATIC, CvtNull, 1);
		vocsize = W_LumpLength(SoundNumber(sndnum));
		WS_PlayRottSound( sndnum,(char *) snd, vocsize,0,angle,  distance,  pitch);	
		//WriteDebug("using siple snd",sndnum);	
		return 1;
	}



//WriteDebug("snd = ",sndnum);
//if (sndnum == 52)
//return 0;
	//bna++156
	/*
	if (BATTLEMODE){
		if ((sndnum >= SD_REMOTEM1SND) && (sndnum <= SD_REMOTEM10SND)){
			PlaySound(IDR_WAVE5+(sndnum - SD_REMOTEM1SND), hInst, SND_RESOURCE | SND_ASYNC); 
			return 1;
		}
	}*/

	lastSndTck = GetTickCount();
	lastsndnum = sndnum;
	//bna++146


	if (iUseOrgThunder != 0){
		if ((fog != 1) || (lightning == true)){
		if (sndnum == SD_LIGHTNINGSND){
		if ((!inautomap)&&(ingame)&&(!inmenu)&&(!GamePaused)&&(!fizzlein)&&(!demoplayback)){
			if (THNB == 1){
				sndPlaySound(Thunderpath1,SND_ASYNC|SND_NODEFAULT|SND_NOSTOP ); 
				THNB = 2;
			}else if (THNB == 2){
				sndPlaySound(Thunderpath2,SND_ASYNC|SND_NODEFAULT|SND_NOSTOP ); 
				THNB = 3;
			}else if (THNB == 3){
				sndPlaySound(Thunderpath3,SND_ASYNC|SND_NODEFAULT|SND_NOSTOP ); 
				THNB = 1;
			}
			//MP3musicPlaySound(Thunderpath1);
			return 1;
		}else{
			//stop all thundersounds in menu bna++156
			PlaySound (NULL, NULL, SND_PURGE);
		}
		}
		}
	}

//bna++ water sound added in version 156 after a idea of jb
#if (USEWATERCODE == 1)
	if (iUseWaterSnd != 0){
		if (sndnum == WATERSNDHEALBASSIN){
			if (WaterSndWavHpool == 0){
				//load our water snd
				WaterSndWavHpoolSize = LoadResourceToFixedMem ("WAVE", IDR_WAVE15,(void**) &WaterSndWavHpool);
				return 1;
			}		
			if (!GetWaveInfo(WaterSndWavHpool,&(pWaveFile.pwfxInfo),&(pWaveFile.pbData),	&(pWaveFile.cbSize))){
				return 0;  // not OK
			}
			DS_PlayVocSound(WaterSndWavHpool,WaterSndWavHpoolSize,pitch,angle, distance,pWaveFile);
			return 1;
		}
		if (sndnum == WATERSNDWATERWALL){
			if (WaterSndWavWWall == 0){
				//load our water snd
				WaterSndWavWWallSize = LoadResourceToFixedMem ("WAVE", IDR_WAVE16,(void**) &WaterSndWavWWall);
				return 1;
			}		
			if (!GetWaveInfo(WaterSndWavWWall,&(pWaveFile.pwfxInfo),&(pWaveFile.pbData),	&(pWaveFile.cbSize))){
				return 0;  // not OK
			}
			DS_PlayVocSound(WaterSndWavWWall,WaterSndWavWWallSize,pitch,angle, distance,pWaveFile);
			return 1;
		}
	}
#endif



	if (iExternSounds[sndnum] != -1){
		
		//in version 1.46 all sounds is converted to wave and stored
		//sound is loaded
		snd = (byte*)iExternSounds[sndnum];
		if (snd == 0)
			return 0;
		vocsize = iExternSoundsSize[sndnum];

		if (!GetWaveInfo(snd,&(pWaveFile.pwfxInfo), 
									&(pWaveFile.pbData), 
									&(pWaveFile.cbSize)))
		{
			return 0;  // not OK
		}

		if (iUseSurroundEffect == TRUE){ 
			if (pWaveFile.pwfxInfo->nChannels == 1){
				if ((sndnum >= BotSndNb)&&(sndnum <= TopSndNum)){
					DS_PlayVocSound(snd,vocsize,pitch+1025,angle-15, distance*3,pWaveFile);
					DS_PlayVocSound(snd,vocsize,pitch+1025,angle+30, distance*3,pWaveFile);
				}
			}
		}
		DS_PlayVocSound(snd,vocsize,pitch,angle, distance,pWaveFile);
		return 0;


	}else
		return 0;


/*
   	//we need to create some memory for our DS_Surroundeffect sound
   if (DS_Surroundeffect == 1){
	   if (surround == 0){
			surround = GetMemBlock (50000);
			memset(surround,0x80,50000);
	   }
   }
*/
//	
	//mp40 sound = 136
	  if (sndnum == 136){
	  }

#if (DEVELOPMENT == 1)
#if (SOUNDTEST == 1)75
   SoftError("SOUND =%d \n",sndnum);
#endif
#endif

   sounds[sndnum].count++;
	/*
   if (bUseExtWallSFX == true){
	   //bUseExtWallSFX also means use ext sounds
	   //can we use an external sound
   }STM();
*/

   if (bUseExtSFX == 0)
   {
		if (iExternSounds[sndnum] != -1){
//			char soundpath[256];
			char *vocname = (char *)W_GetSoundnameForNum(sndnum);
			WAVEFILE  pWaveFile1;  // Points to the struct to fill

			*(vocname+8)=0;
			//sound is loaded
			snd = (byte*)iExternSounds[sndnum];
			vocsize = iExternSoundsSize[sndnum];
			DS_PlayVocSound(snd,vocsize,pitch,angle, distance,pWaveFile1);
			return 0;
/*
			if (!GetWaveInfo(snd,&(pWaveFile.pwfxInfo), 
									&(pWaveFile.pbData), 
									&(pWaveFile.cbSize)))
			{
				return 0;  // OK
		         
			}

			sprintf(soundpath,"%s%d.%s.wav",SFXPath,sndnum,vocname);

		DS_PlayVocSound(snd,vocsize,100,100, 0);
				//if (vocsize > 49000){252.E_THUND2.wav
					
					PlaySound(
					soundpath,  
  NULL,     
  SND_FILENAME | SND_ASYNC     
);
				
				 //} 
return 0;*/
		}else{
				snd=W_CacheLumpNum(SoundNumber(sndnum),PU_STATIC, CvtNull, 1);
				vocsize = W_LumpLength(SoundNumber(sndnum));
				if (bUseExtSFX == true){
					//DS_WriteVOCtofile (snd,sndnum,vocsize,0);
				}
		}
	}else{
		snd=W_CacheLumpNum(SoundNumber(sndnum),PU_STATIC, CvtNull, 1);
		vocsize = W_LumpLength(SoundNumber(sndnum));
	}

	
   if ( *snd == 'C' )//is it a Create Voice File
      { //bna ++
		DS_PlayVocSound(snd,vocsize,pitch,angle, distance,pWaveFile);
	/*	if (DS_Surroundeffect == 1){
			if (vocsize > 49000)
				vocsize = 49000;//dont overflow the buffer
			memset(surround,0x80,50000);
			memcpy(surround+300,snd+0x3c,vocsize-0x3c);
			DS_PlayVocSound(surround,vocsize+200-0x3c,pitch,angle-15, distance+60,pWaveFile);//bna ++

			memset(surround,0x80,50000);
			memcpy(surround+600,snd+0x3c,vocsize-0x3c);
			DS_PlayVocSound(surround,vocsize+500-0x3c,pitch,angle+30, distance+60,pWaveFile);//bna ++
		}
			/*
      voice = FX_PlayVOC3D_ROTT( snd, W_LumpLength(SoundNumber(sndnum)),
         pitch, angle, distance,
         sounds[sndnum].priority, (unsigned long) sndnum );*/
      }
   else
      {	
		 DS_PlayVocSound(snd,W_LumpLength(SoundNumber(sndnum)),pitch,angle, distance,pWaveFile);//bna ++
		 /*voice = FX_PlayWAV3D_ROTT( snd, W_LumpLength(SoundNumber(sndnum)),
         pitch, angle, distance,
         sounds[sndnum].priority, (unsigned long) sndnum );*/
      }


   if ( voice < FX_Ok )
      {
#if (DEVELOPMENT == 1)
/*
      if (MV_ErrorCode == MV_InvalidVOCFile)
         {
         Error("SD_PlayIt: Invalid VOC File snd=%p sndnum=%ld lump=%ld\n",snd,sndnum,SoundNumber(sndnum));
         }
*/
      NumBadSounds++;
      //SoftError("SD_PlayIt: Error/Warning %s\n",FX_ErrorString( FX_Error ));
      SoftError("BadSoundNumber %ld time %ld\n",NumBadSounds,GetTicCount());
#endif
      SD_MakeCacheable( sndnum );

      return 0;
      }

   NumBadSounds=0;

   if (!(sounds[sndnum].flags & SD_WRITE))
      {
      sounds[sndnum].prevhandle=voice;
      sounds[sndnum].prevdistance=distance;
      }
   return voice;
}




//***************************************************************************
//
// SD_Play - Play a sample
//
//***************************************************************************

int SD_Play (int sndnum)
{
    int voice;
    int pitch;

    if (SD_SoundOkay (sndnum) == false)
	return -1;

    pitch = 0;

    if (!(sounds[sndnum].flags & SD_PITCHSHIFTOFF)) {
	pitch = PitchOffset ();
    }

    voice = SD_PlayIt (sndnum, 0, 0, pitch);

    return voice;

}

//***************************************************************************
//
// SD_Play3D - Play a positioned sample
//
//***************************************************************************

int SD_Play3D (int sndnum, int angle, int distance)
{
    int voice;
    int pitch;

    if (SD_SoundOkay (sndnum) == false)
	return -1;

    pitch = 0;
    if (!(sounds[sndnum].flags & SD_PITCHSHIFTOFF)) {
	pitch = PitchOffset ();
    }

    voice = SD_PlayIt (sndnum, angle, distance, pitch);

    return voice;

}

//***************************************************************************
//
// SD_PlayPositionedSound - Play a positioned sample
//
//***************************************************************************

int SD_PlayPositionedSound (int sndnum, int px1, int py1, int x, int y)
{
    int voice;
    int angle;
    int distance;
    int dx;
    int dy;
    int pitch;

    if (SD_SoundOkay (sndnum) == false)
	return -1;

    dx = (x - px1);
    dy = (py1 - y);

    distance = FindDistance (dx, dy) >> SD_DISTANCESHIFT;

    if (distance > 255)
	return -1;

    if (distance != 0) {
	angle = (atan2_appx (dx, dy) & (FINEANGLES - 1)) >> 6;
    } else {
	angle = 0;
    }

    pitch = 0;

    if (!(sounds[sndnum].flags & SD_PITCHSHIFTOFF)) {
		pitch = PitchOffset ();
    }

    voice = SD_PlayIt (sndnum, angle, distance, pitch);

    return voice;

}

//***************************************************************************
//
// SD_PlaySoundRTP - Play a positioned sample relative to the player
//
//***************************************************************************

int SD_PlaySoundRTP (int sndnum, int x, int y)
{
    int voice;
    int angle;
    int distance;
    int dx;
    int dy;
    int pitch;


    if (SD_SoundOkay (sndnum) == false)
		return -1;

	if (x > player->x)
		dx = (x - player->x);
	else
		dx = (player->x - x );

	if (y > player->y)
		dy = (y - player->y);
	else
		dy = (player->y - y );



	//abs added bna++162
    distance = FindDistance (dx, dy) >> SD_DISTANCESHIFT;

    if (distance > 255)
		return -1;
    if (distance < 0)
		distance = 0;

    if (distance != 0) {
		angle = ((player->angle - atan2_appx (dx, dy)) & (FINEANGLES - 1)) >> 6;
    } else {
		angle = 0;
    }

    pitch = 0;

    if (!(sounds[sndnum].flags & SD_PITCHSHIFTOFF)) {
		pitch = PitchOffset ();
    }

    voice = SD_PlayIt (sndnum, angle, distance, pitch);

    return voice;
}

//***************************************************************************
//
// SD_PlayPitchedSound - Play a pitched sample
//
//***************************************************************************

int SD_PlayPitchedSound (int sndnum, int volume, int pitch)
{
    int voice;
    int distance;

    if (SD_SoundOkay (sndnum) == false)
	return -1;

    distance = 255 - volume;

    voice = SD_PlayIt (sndnum, 0, distance, pitch);

    return voice;
}

//***************************************************************************
//
// SD_SetSoundPitch - sets the pitch of a sound
//
//***************************************************************************

int globalpitchtimeout = 0;//bna++ 162
int globalpitch = -1;//bna++ 162


void SD_SetSoundPitch (int sndnum, int pitch)
{
    int status;

    if (SD_Started == false)
	return;

	globalpitch = pitch;//bna++ 162
	globalpitchtimeout = 4;//bna++ 162
	return;

    if (!FX_SoundActive (sndnum))
	return;



    status = FX_SetPitch (sndnum, pitch);
    if (status != FX_Ok) {
#if (DEVELOPMENT == 1)
	SoftError ("SD_SetSoundPitch : %s\n", FX_ErrorString (status));
#endif
    }
}

//***************************************************************************
//
// SD_PanRTP Sound - pan a positioned sample relative to the player
//
//***************************************************************************

void SD_PanRTP (int handle, int x, int y)
{
    int angle;
    int distance;
    int dx;
    int dy;
    int status;

    if (SD_Started == false)
	return;

    if (!FX_SoundActive (handle))
	return;

    dx = (x - player->x);
    dy = (player->y - y);

    distance = FindDistance (dx, dy) >> SD_DISTANCESHIFT;

    if (distance > 255)
	return;

    if (distance != 0) {
	angle =
	    ((player->angle - atan2_appx (dx, dy)) & (FINEANGLES - 1)) >> 6;
    } else {
	angle = 0;
    }

    status = FX_Pan3D (handle, angle, distance);

    if (status != FX_Ok) {
#if (DEVELOPMENT == 1)
	SoftError ("SD_PanPositionedSound: %s\n", FX_ErrorString (status));
#endif
    }
}

//***************************************************************************
//
// SD_SetPan - set the pan of a sample
//
//***************************************************************************

void SD_SetPan (int handle, int vol, int left, int right)
{
    int status;

    if (SD_Started == false)
	return;

    if (!FX_SoundActive (handle))
	return;

    status = FX_SetPan (handle, vol, left, right);

    if (status != FX_Ok) {
#if (DEVELOPMENT == 1)
	SoftError ("SD_SetPan: %s\n", FX_ErrorString (status));
#endif
    }
}

//***************************************************************************
//
// SD_PanPositioned Sound - pan a positioned sample
//
//***************************************************************************

void SD_PanPositionedSound (int handle, int px1, int py1, int x, int y)
{
    int angle;
    int distance;
    int dx;
    int dy;
    int status;

    if (SD_Started == false)
	return;

    if (!FX_SoundActive (handle))
	return;

    dx = (x - px1);
    dy = (py1 - y);

    distance = FindDistance (dx, dy) >> SD_DISTANCESHIFT;

    if (distance > 255)
	return;

    if (distance != 0) {
	angle = (atan2_appx (dx, dy) & (FINEANGLES - 1)) >> 6;
    } else {
	angle = 0;
    }

    status = FX_Pan3D (handle, angle, distance);

    if (status != FX_Ok) {
#if (DEVELOPMENT == 1)
	SoftError ("SD_PanPositionedSound: %s\n", FX_ErrorString (status));
#endif
    }
}


//***************************************************************************
//
// SD_StopSound - Stop the current sound from playing
//
//***************************************************************************

void SD_StopSound (int handle)
{
    int status;

    if (SD_Started == false)
	return;

    status = FX_StopSound (handle);

    if (status != FX_Ok) {
#if (DEVELOPMENT == 1)
	SoftError ("SD_StopSound: %s\n", FX_ErrorString (status));
#endif
    }
}

//***************************************************************************
//
// SD_StopAllSounds - Stop All the sounds currently playing
//
//***************************************************************************

void SD_StopAllSounds (void)
{
    int status;

    if (SD_Started == false)
	return;
	


	
#if (USEDIRECTSOUND == 1)
   DS_StopAllSounds ();////bna++
   status = FX_Ok;//bna++
   return;//bna++
#endif	

    status = FX_StopAllSounds ();

    if (status != FX_Ok) {
#if (DEVELOPMENT == 1)
	SoftError ("SD_StopAllSounds: %s\n", FX_ErrorString (status));
#endif
    }
}

//***************************************************************************
//
// SD_SoundActive - See if a sound is active
//
//***************************************************************************

int SD_SoundActive (int handle)
{
    if (SD_Started == false) {
	return false;
    } else {
	return (FX_SoundActive (handle));
    }
}

//***************************************************************************
//
// SD_WaitSound - wait until a sound has finished
//
//***************************************************************************
void SD_WaitSound (int handle)
{
    int time;

    IN_ClearKeysDown ();

    while (FX_SoundActive (handle) != 0) {
	time = GetTicCount () + 1;
	while (time > GetTicCount ()) {
	}
	if ((LastScan) || IN_GetMouseButtons ())
	    break;
    }
}


//***************************************************************************
//
// SD_Shutdown - Shutdown the sound system
//
//***************************************************************************

void SD_Shutdown (void)
{
    if (SD_Started == false)
	return;

    FX_Shutdown ();
    SD_Started = false;
}


//***************************************************************************
//
// SD_PreCacheSound - PreCache sound
//
//***************************************************************************

void SD_PreCacheSound (int num)
{
    if (SD_SoundOkay (num) == false)
	return;

    PreCacheLump (SoundNumber (num), PU_CACHESOUNDS + sounds[num].priority);
}

//***************************************************************************
//
// SD_PreCacheSoundGroup - PreCache sound group
//
//***************************************************************************

void SD_PreCacheSoundGroup (int lo, int hi)
{
    int i;

    if (SD_Started == false)
	return;

    for (i = lo; i <= hi; i++)
	SD_PreCacheSound (i);
}


#if (SHAREWARE == 1)
#define MAXSONGS 18
static song_t rottsongs[MAXSONGS] = {
    {loop_no, song_apogee, "FANFARE2", "Apogee Fanfare"},
    {loop_yes, song_title, "RISE", "Rise"},
    {loop_yes, song_menu, "MMMENU", "MMMenu"},
    {loop_yes, song_christmas, "DEADLY", "Deadly Gentlemen"},
    {loop_yes, song_elevator, "GOINGUP", "Going up?"},
    {loop_yes, song_endlevel, "HOWDIDO", "How'd I do?"},
    {loop_yes, song_secretmenu, "FISHPOLK", "Fish Polka"},
    {loop_yes, song_gameover, "YOUSUCK", "You Suck"},
    {loop_yes, song_youwin, "WATZNEXT", "Watz Next?"},
    {loop_no, song_gason, "GAZZ!", "Gazz!"},
    {loop_yes, song_level, "FASTWAY", "Goin' Down The Fast Way"},
    {loop_yes, song_level, "MISTACHE", "Mist Ache"},
    {loop_yes, song_level, "OWW", "Oww!!!"},
    {loop_yes, song_level, "SMOKE", "Smoke And Mirrors"},
    {loop_yes, song_level, "SPRAY", "Spray"},
    {loop_yes, song_level, "RUNLIKE", "Run Like Smeg"},
    {loop_yes, song_level, "SMOOTH", "Havana Smooth"},
    {loop_yes, song_level, "CHANT", "Chant"},
};
#else
#define MAXSONGS 34
static song_t rottsongs[MAXSONGS] = {
    {loop_no, song_apogee, "FANFARE2", "Apogee Fanfare"},
    {loop_yes, song_title, "RISE", "Rise"},
    {loop_yes, song_menu, "MMMENU", "MMMenu"},
    {loop_yes, song_christmas, "DEADLY", "Deadly Gentlemen"},
    {loop_yes, song_elevator, "GOINGUP", "Going up?"},
    {loop_yes, song_secretmenu, "FISHPOLK", "Fish Polka"},
    {loop_yes, song_endlevel, "HOWDIDO", "How'd I do?"},
    {loop_yes, song_gameover, "YOUSUCK", "You Suck"},
    {loop_yes, song_cinematic2, "WATZNEXT", "Watz Next?"},
    {loop_no, song_gason, "GAZZ!", "Gazz!"},
    {loop_yes, song_level, "FASTWAY", "Goin' Down The Fast Way"},
    {loop_yes, song_level, "MISTACHE", "Mist Ache"},
    {loop_yes, song_level, "OWW", "Oww!!!"},
    {loop_yes, song_level, "SMOKE", "Smoke And Mirrors"},
    {loop_yes, song_level, "SPRAY", "Spray"},
    {loop_yes, song_level, "RUNLIKE", "Run Like Smeg"},
    {loop_yes, song_level, "SMOOTH", "Havana Smooth"},
    {loop_yes, song_level, "CHANT", "Chant"},
    {loop_yes, song_level, "MEDIEV1A", "Funeral of Queen Mary"},
    {loop_yes, song_level, "TASKFORC", "Task Force"},
    {loop_yes, song_level, "KISSOFF", "KISS Off"},
    {loop_yes, song_level, "RADAGIO", "Adagio For Strings"},
    {loop_yes, song_level, "SHARDS", "Shards"},
    {loop_yes, song_level, "STAIRS", "I Choose the Stairs"},
    {loop_yes, song_level, "SUCKTHIS", "Suck This"},
    {loop_yes, song_level, "EXCALIBR", "Excalibur"},
    {loop_yes, song_level, "CCCOOL", "CCCool"},
    {loop_yes, song_level, "WORK_DAY", "Work Day"},
    {loop_yes, song_level, "WHERIZIT", "Where Iz It?"},
    {loop_no, song_bossdie, "BOSSBLOW", "Boss Blow"},
    {loop_yes, song_bosssee, "HELLERO", "Hellero"},
    {loop_yes, song_cinematic1, "EVINRUDE", "Evin Rude"},
    {loop_yes, song_youwin, "VICTORY", "Victory!"},
    {loop_yes, song_dogend, "HERE_BOY", "Here Boy"}
};
#endif

static byte *currentsong;
static int MU_Started = false;
static int lastsongnumber = -1;
int storedposition = 0;

//****************************************************************************
//
// MU_JukeBoxMenu()
//
//****************************************************************************

void MU_PlayJukeBoxSong (int which)
{
    if ((MusicMode > 0) && (MU_Started == true)) {
	SetMenuHeader (rottsongs[which].songname);
	MU_PlaySong (which);
    }
}


//****************************************************************************
//
// MU_JukeBoxMenu()
//
//****************************************************************************

void MU_JukeBoxRedraw (void
    )
{
    if ((MusicMode > 0) && (MU_Started == true)) {
	SetMenuHeader (rottsongs[lastsongnumber].songname);
    }
}


//****************************************************************************
//
// MU_JukeBoxMenu()
//
//****************************************************************************

void MU_JukeBoxMenu (void
    )
{
    char *SongNames[MAXSONGS];
    int i;

    for (i = 0; i < MAXSONGS; i++) {
	SongNames[i] = rottsongs[i].songname;
    }

    HandleMultiPageCustomMenu (SongNames, MAXSONGS, lastsongnumber,
			       "Jukebox", MU_PlayJukeBoxSong,
			       MU_JukeBoxRedraw, false);

    if (rottsongs[lastsongnumber].loopflag == loop_no) {
	MU_StartSong (song_level);
    }
}

//***************************************************************************
//
// MusicStarted - see if the music is started
//
//***************************************************************************
boolean MusicStarted (void)
{
    return MU_Started;
}

//***************************************************************************
//
// MU_Startup - Initialize music stuff
//
//***************************************************************************

int MU_Startup (boolean bombonerror)
{
    int status;
    int card;
    
#if (USEDIRECTMUSIC == 1)
    MU_Started = true;
    return 1;
#endif
    if (MU_Started == true) {
		MU_StopSong ();
		MU_Shutdown ();
    }
    if ((MusicMode < 0) || (MusicMode >= 11)) {
		return (0);
    }
    card = musicnums[MusicMode];
    if (card == -1)		// Check if it is off
		return (0);

    if ((card == SoundBlaster) || (card == Awe32) || (card == WaveBlaster)) {
	if (SD_Started == false) {
	    extern fx_blaster_config SBSettings;
	    int numvoices;
	    int numbits;
	    int numchannels;

	    FX_SetupSoundBlaster (SBSettings, &numvoices,
				  &numbits, &numchannels);
	}
    }

    if (card == UltraSound) {
		MU_SetupGUSInitFile ();
    }

    status = MUSIC_Init (card, MidiAddress);

    if (status != MUSIC_Ok) {
	if (bombonerror) {
	    DeleteSoundFile ();
	    Error ("%s\n", MUSIC_ErrorString (status));
	} else
	    return (status);
    }

    currentsong = 0;

    MU_Started = true;

    MU_SetVolume (MUvolume);

    return (0);
}

//***************************************************************************
//
// MU_Shutdown - Shutdown the music system
//
//***************************************************************************

void MU_Shutdown (void)
{
    if (MU_Started == false)
	return;
    MUSIC_Shutdown ();
    MU_Started = false;
}

//***************************************************************************
//
// MU_SetupGUSInitFile - initialize GUS stuff
//
//***************************************************************************

void MU_SetupGUSInitFile (void)
{
    char filename[128];

    GetPathFromEnvironment (filename, ApogeePath, GUSMIDIINIFILE);
    if (access (filename, F_OK) != 0) {
	int lump;

	lump = W_GetNumForName ("gusmidi");

	SaveFile (filename, W_CacheLumpNum (lump, PU_CACHE, CvtNull, 1),
		  W_LumpLength (lump));
    }
}

//***************************************************************************
//
// MU_GetNumForType - returns number of song in rottsongs of specific type
//
//***************************************************************************
int MU_GetNumForType (int type)
{
    int i;

    for (i = 0; i < MAXSONGS; i++) {
	if (rottsongs[i].songtype == type)
	    return i;
    }
    Error ("MU_GetNumForType: could not find song type in list\n");
    return -1;
}


//***************************************************************************
//
// MU_PlaySong - Play a specific song number
//
//***************************************************************************
extern int iUseMp3Music;
char currentmusicname[256];

void MU_PlaySong (int num)
{
    int lump;
    int size;

    if (MU_Started == false)
	return;

    if (num < 0)
	return;

    if (num >= MAXSONGS)
	Error ("Song number out of range\n");

    MU_StopSong ();

    lastsongnumber = num;

    lump = W_GetNumForName (rottsongs[num].lumpname);
    size = W_LumpLength (lump);

	

    currentsong = W_CacheLumpNum (lump, PU_STATIC, CvtFixme, 1);
	if (iUseMp3Music == 1){
		lstrcpy(currentmusicname,rottsongs[num].lumpname);
		MP3musicPlay(rottsongs[num].lumpname);
		return;
	}
#ifdef PLATFORM_DOS
    if (rottsongs[num].loopflag == loop_yes)
	MUSIC_PlaySong (currentsong, size, MUSIC_LoopSong);
    else
	MUSIC_PlaySong (currentsong, size, MUSIC_PlayOnce);
#else
    if (rottsongs[num].loopflag == loop_yes)
	MUSIC_PlaySongROTT (currentsong, size, MUSIC_LoopSong);
    else
	MUSIC_PlaySongROTT (currentsong, size, MUSIC_PlayOnce);
#endif

    MU_SetVolume (MUvolume);
}

//***************************************************************************
//
// MU_StopSong - Play a specific song number
//
//***************************************************************************

void MU_StopSong (void)
{
    if (MU_Started == false)
	return;

	
    MUSIC_StopSong ();
    if (currentsong) {
	W_CacheLumpName (rottsongs[lastsongnumber].lumpname, PU_CACHE,
			 CvtFixme, 1);
	currentsong = 0;
    }
}

//***************************************************************************
//
// MU_GetSongNumber - get current song number
//
//***************************************************************************

int MU_GetSongNumber (void)
{
    return lastsongnumber;
}


//***************************************************************************
//
// MU_FadeToSong - Fade to a specific song in a certain time
//
//***************************************************************************

void MU_FadeToSong (int num, int time)
{
    int t;

    if (MU_Started == false)
	return;

    MU_FadeOut (time >> 1);

    while (MU_FadeActive ()) {
	t = GetTicCount ();
	while (GetTicCount () == t) {
	}
    }

    MU_FadeIn (num, time >> 1);
}

//***************************************************************************
//
// MU_FadeIn - Fade in
//
//***************************************************************************

void MU_FadeIn (int num, int time)
{
    if (MU_Started == false)
	return;

    MUSIC_SetVolume (0);
    MU_PlaySong (num);
    MUSIC_FadeVolume (MUvolume, time);
}

//***************************************************************************
//
// MU_FadeOut - Fade out
//
//***************************************************************************

void MU_FadeOut (int time)
{
    if (MU_Started == false)
	return;
    if (!MUSIC_SongPlaying ()) {
#if (DEVELOPMENT == 1)
	SoftError ("Called FadeOut with no song playing\n");
#endif
	return;
    }
    MUSIC_FadeVolume (0, time);
}


//***************************************************************************
//
// MU_StartSong - Start a context sensitive song
//
//***************************************************************************

void MU_StartSong (int songtype)
{
    int songnum;


    if (MU_Started == false)
	return;

    MU_StopSong ();

    songnum = MU_GetNumForType (songtype);
    switch (songtype) {
    case song_level:
	if (IsChristmas ()) {
	    songnum = MU_GetNumForType (song_christmas);
	} else {
	    songnum += GetSongForLevel ();
	}
	break;
    }
    MU_PlaySong (songnum);
}

//***************************************************************************
//
// MU_StoreSongPostition - Save off Song Position
//
//***************************************************************************

void MU_StoreSongPosition (void)
{
    if (MU_Started == false)
	return;
    PositionStored = true;
    storedposition = MUSIC_GetPosition ();
}

//***************************************************************************
//
// MU_RestoreSongPostition - Save off Song Position
//
//***************************************************************************

void MU_RestoreSongPosition (void)
{
    if (MU_Started == false)
	return;
    if (PositionStored == false)
	return;
    PositionStored = false;

    MUSIC_SetPosition (storedposition);
}

//***************************************************************************
//
// MU_GetStoredPostition - Get Stored song Position
//
//***************************************************************************

int MU_GetStoredPosition (void)
{
    if (PositionStored)
	return storedposition;
    else
	return -1;
}

//***************************************************************************
//
// MU_SetStoredPostition - Get Stored song Position
//
//***************************************************************************

void MU_SetStoredPosition (int position)
{
    if (MU_Started == false)
	return;
    if (position == -1)
	return;
    PositionStored = true;
    storedposition = position;
}



//***************************************************************************
//
// MU_GetSongPostition - Get Song Position
//
//***************************************************************************

int MU_GetSongPosition (void)
{
    if (MU_Started == false)
	return 0;
    return MUSIC_GetPosition ();
}

//***************************************************************************
//
// MU_SetSongPostition - Set Song Position
//
//***************************************************************************

void MU_SetSongPosition (int position)
{
    if (MU_Started == false)
	return;
    MUSIC_SetPosition (position);
}

//***************************************************************************
//
// MU_SaveMusic
//
//***************************************************************************

void MU_SaveMusic (byte ** buf, int *size)
{
    int unitsize;
    byte *ptr;
    int vsize;
    int i;

    //
    // Size
    //

    unitsize = 0;

    unitsize += sizeof (i);
    unitsize += sizeof (i);
    unitsize += sizeof (i);


    *size = unitsize;
    *buf = (byte *) SafeMalloc (*size);

    ptr = *buf;

    i = MU_GetSongNumber ();
    if (rottsongs[i].songtype == song_menu) {
	i = MU_GetNumForType (song_level);
	if (IsChristmas ()) {
	    i = MU_GetNumForType (song_christmas);
	} else {
	    i += GetSongForLevel ();
	}
	vsize = sizeof (i);
	memcpy (ptr, &i, vsize);
	ptr += vsize;

	i = MU_GetStoredPosition ();
	vsize = sizeof (i);
	memcpy (ptr, &i, vsize);
	ptr += vsize;

	i = -1;
	vsize = sizeof (i);
	memcpy (ptr, &i, vsize);
	ptr += vsize;
    } else {
	vsize = sizeof (i);
	memcpy (ptr, &i, vsize);
	ptr += vsize;

	i = MU_GetSongPosition ();
	vsize = sizeof (i);
	memcpy (ptr, &i, vsize);
	ptr += vsize;

	i = MU_GetStoredPosition ();
	vsize = sizeof (i);
	memcpy (ptr, &i, vsize);
	ptr += vsize;
    }
}


//***************************************************************************
//
// MU_LoadMusic
//
//***************************************************************************

void MU_LoadMusic (byte * buf, int size)
{
    int unitsize;
    byte *ptr;
    int i;
    int songnumber;
    boolean differentsong = false;
    int vsize;

    //
    // Size
    //

    unitsize = 0;

    unitsize += sizeof (i);
    unitsize += sizeof (i);
    unitsize += sizeof (i);

    if (size != unitsize)
	Error ("LoadMusic: Different number of parameters\n");

    ptr = buf;

    vsize = sizeof (songnumber);
    memcpy (&songnumber, ptr, vsize);
    ptr += vsize;
    if (MU_GetSongNumber () != songnumber) {
	MU_PlaySong (songnumber);
	differentsong = true;
    }

    vsize = sizeof (i);
    memcpy (&i, ptr, vsize);
    ptr += vsize;
    if (differentsong == true) {
	MU_SetSongPosition (i);
    }

    vsize = sizeof (i);
    memcpy (&i, ptr, vsize);
    ptr += vsize;
    MU_SetStoredPosition (i);

    // Check if game was saved with NOSOUND

    if (MU_GetSongNumber () != songnumber) {
	MU_StartSong (song_level);
    }
}



//bna added function
int SD_GetSoundNb (int sndnum);

int SD_GetSoundNb (int sndnum)
{
   int snd = sounds[ sndnum ].snds[ fx_digital ];
   return snd;
}








