#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <linux/soundcard.h>
#include <string.h>
#include <sys/ioctl.h>
#include <signal.h>

#include "simpleplaymidi.h"
#include <SDL.h>
#include <SDL_thread.h>



SEQ_DEFINEBUF (2048);
static int seqdev;



void seqbuf_dump ()
{
    //printf("dumping %d bytes to seq\n",_seqbufptr);
    if (_seqbufptr)
	while (write (seqdev, _seqbuf, _seqbufptr) == -1) {
	    fprintf (stderr, "write /dev/sequencer failed, reopening.\n");
	    close (seqdev);
	    seqdev = open ("/dev/sequencer", O_WRONLY, 0);

	}
    _seqbufptr = 0;
}
static int mymidi = 0;
static int doexit = 0;
void shutmidiup ()
{
    int i;
    for (i = 0; i < 16; i++) {
	SEQ_MIDIOUT (mymidi, 0xB0 + i);
	SEQ_MIDIOUT (mymidi, 0x79);
	SEQ_MIDIOUT (mymidi, 0x00);
	SEQ_MIDIOUT (mymidi, 0x78);
	SEQ_MIDIOUT (mymidi, 0x00);
    }
    SEQ_DUMPBUF ();
    //close(seqdev);
}
void rstrncpy (char *out, const char *in, int n)
{
    strncpy (out, in, n);
    out[n] = 0;
}

#define CHECK_CAP(ptr,capvar,needed,align) do {					\
    if ((needed)>(capvar)) {							\
	(capvar)=((needed)+((1<<align)-1))&(~((1<<align)-1));			\
	(ptr)=realloc((ptr),(capvar)*sizeof(*(ptr)));				\
    }										\
} while (0)
static int playing, paused;
static int enable=1;
static int init=0;
void PMID_Init ()
{
    if (init) {
	return;
	
    }
    init=1;
    if (getenv("SPM_DISABLE")) {
	enable=0;
	return;
    }
    printf("PMID_Init()\n");
    _seqbufptr = 0;
    seqdev = open ("/dev/sequencer", O_WRONLY, 0);

    if (seqdev < 0) {
	perror ("cannot open sequencer");
	exit (-1);
    }
    atexit (PMID_Halt);
    int nummidis;
    int i;
    int dbg = 0;
    playing = 0;
    ioctl (seqdev, SNDCTL_SEQ_NRMIDIS, &nummidis);
    ioctl (seqdev, SNDCTL_SEQ_RESET);
    /*if (mymidi >= nummidis || mymidi < 0) {
       fprintf(stderr,"midi device %d is invalid.\n",mymidi);
       close(seqdev);
       exit(-1);
       }
       signal(SIGINT,interrupt); */
}

enum {
    CTL_NONE=0,
    CTL_QUIT,
    CTL_PAUSE,
    CTL_RESUME
};

#define NCMDS 8
typedef struct {

    int cmds[NCMDS];
    int cmdhead, cmdtail;
    SDL_mutex *ctlmtx,*writemtx;
    int quitsem,finished;
    int loopcount, autofree;
    int refcount;
    midifile *mf;
} musicvars_t;

static void deleteref(musicvars_t* mv) {
    int trefc;
    SDL_mutexP(mv->ctlmtx);
    trefc=--mv->refcount;
    SDL_mutexV(mv->ctlmtx);
    if (trefc==0) {
	SDL_DestroyMutex(mv->ctlmtx);
	SDL_DestroyMutex(mv->writemtx);
	if (mv->autofree) jsm_freemidi(mv->mf);
	free(mv);
    }
}

static int pollcmd(musicvars_t* mv) {
    SDL_mutexP(mv->ctlmtx);
    int ret=CTL_NONE;
    if (mv->cmdhead != mv->cmdtail) {
	ret=mv->cmds[mv->cmdtail];
	mv->cmdtail++;
	if (mv->cmdtail>=NCMDS) mv->cmdtail=0;
    }
    SDL_mutexV(mv->ctlmtx);
    return ret;
}
static int waitcmd(musicvars_t* mv, int timeout) {
    int ret=CTL_NONE;
    int time=0;
    while ((ret=pollcmd(mv))==CTL_NONE) {
	usleep(1000);
	time += 1000;
	if (timeout && time>timeout) return CTL_NONE;
    }
    return ret;
}
static void pushcmd(musicvars_t* mv, int cmd) {
    SDL_mutexP(mv->ctlmtx);
    mv->cmds[mv->cmdhead]=cmd;
    mv->cmdhead++;
    if (mv->cmdhead>=NCMDS) mv->cmdhead=0;
    SDL_mutexV(mv->ctlmtx);
}

static int playmidithread (void *data)
{
    musicvars_t *mv = (musicvars_t *) data;
    midifile *mf = mv->mf;
    int j;
    int millis = 0;
    unsigned long long ctime, start;
    struct timeval time;
    ctime = 0;
    int k;
    int z;
    int done=0;
    for (z = 0; z < mv->loopcount; z++) {
	gettimeofday (&time, NULL);
	start = ((time.tv_sec * 1000) + (time.tv_usec / 1000)) + 50;
	//printf("Music: starting\n");
	_seqbufptr = 0;
	for (j = 0; j < mf->numevents; j++) {
	    jsmevent *evt = &mf->events[j];
	    //unsigned int tts = (evt->millistime-millis)*1000;
	    //printf("%d\n",evt->millistime);
	    //if (tts) {
	    if (done) break;
	    gettimeofday (&time, NULL);
	    ctime = (time.tv_sec * 1000) + (time.tv_usec / 1000);
	    millis = evt->millistime;
	    while (!doexit && ctime < millis + start) {
		usleep (1000);
		gettimeofday (&time, NULL);
		ctime = (time.tv_sec * 1000) + (time.tv_usec / 1000);
	    }
	    //printf(".");
	    //fflush(stdout);
	    int cmd;
	    while ((cmd=pollcmd(mv))!=CTL_NONE) {
	    anothercmd:
		switch (cmd) {
		case CTL_PAUSE:
		    shutmidiup ();
		    gettimeofday (&time, NULL);
		    ctime = (time.tv_sec * 1000) + (time.tv_usec / 1000);
		    unsigned long long diff = ctime - start;
		    while ((cmd=waitcmd(mv,0))!=CTL_RESUME && cmd!=CTL_QUIT) ;
		    
		    gettimeofday (&time, NULL);
		    ctime = (time.tv_sec * 1000) + (time.tv_usec / 1000);
		    start = ctime - diff;
		    goto anothercmd;
		case CTL_QUIT:
		    done=1;
		    break;
		}
	    }
	    SDL_mutexP (mv->writemtx);
	    if (mv->quitsem) { done=1; break; }
	    if ((evt->status & 0xF0) == 0xF0) {
		//if (evt->status==0xF0) SEQ_MIDIOUT(mymidi,evt->status);
		//for (k=0;k<evt->len;k++) {
		//SEQ_MIDIOUT(mymidi,evt->pdata[k]);
		//}
	    } else {
		//if ((evt->status&0xF0)==0x90 || (evt->status&0xF0)==0x80) {
		//printf("status=%02X %d %d (len=%d)\n",evt->status,evt->sdata[0],evt->sdata[1],evt->len);

		//}//
		//if (((evt->status&0xF0)==0x90) && millis < milstart) continue;
		
		SEQ_MIDIOUT (mymidi, evt->status);
		for (k = 0; k < evt->len; k++) {
		    SEQ_MIDIOUT (mymidi, evt->sdata[k]);
		}
	    }
	    SEQ_DUMPBUF ();
	    SDL_mutexV (mv->writemtx);
	}
	if (done) break;
    }
    mv->finished=1;
    deleteref(mv);
}

static musicvars_t *cmv;

void PMID_SetLoops (int loops)
{
    if (!enable) return;
    SDL_mutexV(cmv->ctlmtx);
    cmv->loopcount = loops;
    SDL_mutexP(cmv->ctlmtx);
}

int PMID_IsPlaying ()
{
    if (!enable) return 1;
    if (playing) {
	SDL_mutexP(cmv->ctlmtx);
	if (cmv->finished) {
	    playing=0;
	}
	SDL_mutexV(cmv->ctlmtx);
	if (!playing) deleteref(cmv);
    }
    
    return playing;
}

int PMID_IsPaused ()
{
    if (!enable) return 0;
    return paused;
}

void PMID_Pause ()
{
    if (!enable) return;
    if (!playing)
	return;
    if (paused)
	return;
    paused = 1;
    fprintf (stderr, "Music: pausing...");
    pushcmd(cmv,CTL_PAUSE);
    fprintf (stderr, "done.\n");
}

void PMID_Resume ()
{
    if (!enable) return;
    if (!playing)
	return;
    if (!paused)
	return;
    paused = 0;
    fprintf (stderr, "Music: resuming...");
    pushcmd(cmv,CTL_RESUME);
    fprintf (stderr, "done.\n");
}

void PMID_Halt ()
{
    if (!enable) return;
    if (!playing)
	return;
    fprintf (stderr, "Music: halting...");
    SDL_mutexP (cmv->writemtx);
    pushcmd(cmv,CTL_QUIT);
    cmv->quitsem=1;
    shutmidiup ();
    SDL_mutexV (cmv->writemtx);
    deleteref(cmv);
    fprintf (stderr, "done.\n");
    playing = 0;
}
void PMID_PlayMidiFileP (midifile * mf, int af, int loops)
{
    if (!enable) return;
    if (playing)
	PMID_Halt ();
    cmv = (musicvars_t *) malloc (sizeof (musicvars_t));
    char *mymidistr = getenv ("JSMIDINUM");
    if (mymidistr)
	mymidi = atoi (mymidistr);
    cmv->autofree = af;
    playing = 1;
    paused = 0;
    cmv->cmdhead=0;
    cmv->cmdtail=0;
    cmv->finished=0;
    cmv->quitsem=0;
    cmv->refcount=2;
    cmv->loopcount = loops;
    cmv->mf = mf;
    cmv->ctlmtx = SDL_CreateMutex ();
    cmv->writemtx = SDL_CreateMutex ();
    fprintf (stderr, "Music: playing\n");
    //close(seqdev);
    //seqdev=open("/dev/sequencer",O_WRONLY,0);
    //SEQ_DUMPBUF();
    //ioctl(seqdev,SNDCTL_SEQ_RESET);
    SDL_Thread *t = SDL_CreateThread (playmidithread, cmv);
}
void PMID_PlayMidiFile (const char *mfn, int loops)
{
    PMID_Init ();
    if (!enable) return;
    fprintf (stderr, "Music: loading midifile from file %s\n", mfn);
    midifile *mf = jsm_readmidi_file (mfn);
    PMID_PlayMidiFileP (mf, 1, loops);
}
void PMID_PlayMidiMem (const unsigned char *buf, int len, int loops)
{
    PMID_Init ();
    if (!enable) return;
    fprintf (stderr, "Music: loading midifile from mem\n");
    jsmio *io = jsm_io_read_mem (buf, len);
    midifile *mf = jsm_readmidi (io, 1);
    PMID_PlayMidiFileP (mf, 1, loops);
}
