

#ifdef unix

#include <unistd.h>
#include <errno.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <stdlib.h>
 
static FILE* ttyout;

#define TERM "xterm"
#define NLINES 25



int linesused[NLINES];
void openwatcher (char* path) {
    int filedes[2];
    pipe(filedes);
    char cmdbuf[128];
    sprintf(cmdbuf,"tty >&%d; while :; do :; done",filedes[1]);
    int pid=fork();
    if (!pid) {
	close(filedes[0]);
	printf("running cmd %s -T Watcher -e '%s'\n",path,cmdbuf);
	nice(10);
	execl(path,path,"-T","Watcher","-e",cmdbuf,NULL);
	fprintf(stderr,"OH SHIT! Still here. Error: %s\n",strerror(errno));
	FILE* f=fdopen(filedes[1],"w");
	fprintf(f,"/dev/null\n");
        exit(-1);
    }
    close(filedes[1]);
    char ttybuf[64];
    FILE* fil=fdopen(filedes[0],"r");
    fgets(ttybuf,64,fil);
    fclose(fil);
    int len=strlen(ttybuf);
    if (ttybuf[len-1]=='\n') ttybuf[len-1]=0;
    printf("xterm gave us pty '%s'\n",ttybuf);
    ttyout=fopen(ttybuf,"w");
}

FILE* rstdout;

void shutdownwatcher() {
    fprintf(ttyout,"\033[2J\033[1H");
    fflush(ttyout);
    
}

int watchermode=0;
void initwatcher() {
    char* watch=getenv("WATCHER_DEBUG");
    memset(linesused,0,sizeof(linesused));
    if (watch) {
	if (watch[0]=='|') {
	    printf("Using terminal for debug output\n");
	    openwatcher(watch+1);
	    watchermode=1;
	} else if (!strcmp(watch,"-")) {
	    printf("Hijacking stdout for debug output\n");
	    ttyout=stdout;
	    stdout=fopen("stdout.txt","w");
	    stderr=fopen("stderr.txt","w");
	    watchermode=2;
	    fprintf(ttyout,"\033[2J\033[1H");
	    fflush(ttyout);
	    atexit(shutdownwatcher);
	}
    } else watchermode=-1;
    
}

static int nlines=0;
void DebugAt(int* line, char* format, ...) {
    if (!nlines) {
		initwatcher();
		nlines=1;
    }
    if (watchermode==-1) return;
    if (*line==0) {
	*line=nlines++;
    }
    //if (watchermode==1) {
    fprintf(ttyout,"\033[%dH",*line);
    va_list ap;
    va_start(ap,format);
    vfprintf(ttyout,format,ap);
    va_end(ap);
    fprintf(ttyout,"\033[K");
    fflush(ttyout);
    /*} else {
      va_list ap;
      va_start(ap,format);
      vprintf(format,ap);
      va_end(ap);*/
    // }
}

#endif
