


/******************************************************************************
 				water.c 

 Copyright  2008, 2022 by Birger N. Andreasen
 Please send any bugreports, comments and other issues to:
 E-Mail = bna@bbsyd.dk
 Homepage with other ROTT stuff = http://www.riseofthetriad.dk/

 ******************************************************************************/




#include "rt_def.h"
#include "rt_sound.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <io.h>
#include <conio.h>
#include <dos.h>
#include <errno.h>
#include "SDL.h"
#include "glfuncs.h"
#include "states.h"
#include "watcom.h"
#include "rt_ted.h"
#include "_rt_ted.h"
#include "w_wad.h"
#include "z_zone.h"
#include "rt_util.h"
#include "lumpy.h"
#include "rt_vid.h"
#include "rt_actor.h"
#include "rt_stat.h"
#include "rt_menu.h"
#include "rt_draw.h"
#include "rt_com.h"
#include "rt_main.h"
#include "rt_door.h"
#include "rt_playr.h"
#include "rt_view.h"
#include "rt_str.h"
#include "isr.h"
#include "rt_floor.h"
#include "rt_game.h"
#include "rt_rand.h"
#include "rt_cfg.h"
#include "develop.h"
#include "modexlib.h"
#include "engine.h"
#include "rt_debug.h"
#include "rt_scale.h"
#include "rt_net.h"
#include "develop.h"
#include "memcheck.h"
//#include "spritedef.h"



//bna++ water sound added in version 156 after a idea of jb
#if (USEWATERCODE == 1)



extern BOOL inautomap;
extern int  iUseWaterSnd;
extern int  WorkingChannel;

int iWaterSndChanHealBas = -1;
int iWaterSndChanWatWall = -1;

#define WATERSNDHEARRANGE 5

int WTR_ProcessWater();
int WTR_FindNearestTile (int tile ,int range,int *stilex, int *stiley);

extern BOOL DS_OneSoundActive(int chan);
extern BOOL	DS_StopOneSound (int chan);
extern int	SetChanVoldistance (int chan, int distance);


int WTR_ProcessWater()
{
	 
    if ((!inautomap)&&(ingame)&&(!inmenu)&&(!GamePaused)&&(!fizzlein)&&(!demoplayback)){
	if ((iUseWaterSnd == 1)&&(!BATTLEMODE)){
	{		
		int f,b;
		//is there water in the surounding tiles
		//we look in a WATERSNDHEARRANGE x WATERSNDHEARRANGE square w player in center
		if ((PLAYER[0]->tiley > WATERSNDHEARRANGE)&&(PLAYER[0]->tiley < (127-WATERSNDHEARRANGE))){
			if ((PLAYER[0]->tilex > WATERSNDHEARRANGE)&&(PLAYER[0]->tilex < (127-WATERSNDHEARRANGE))){
				for (f = PLAYER[0]->tiley - WATERSNDHEARRANGE; f < PLAYER[0]->tiley + WATERSNDHEARRANGE;f++){
					for (b = PLAYER[0]->tilex - WATERSNDHEARRANGE; b < PLAYER[0]->tilex + WATERSNDHEARRANGE;b++){
				//		if ((MAPSPOT (b, f, 0) - AREATILE) == PLAYER[0]->areanumber) {
								int b1 = PLAYER[0]->tilex,f1 = PLAYER[0]->tiley;
								if(MAPSPOT (b, f, 0) == 230){	
									//find the nearest wall ANIMBW1 to player and adjust vol according to dist
									if (WTR_FindNearestTile (230 ,WATERSNDHEARRANGE,&b1, &f1)==1){
										b = b1;
										f = f1;
									}
									if ( DS_OneSoundActive (iWaterSndChanWatWall) == 0){
										//start water sound
										SD_PlayPositionedSound (WATERSNDWATERWALL,b,f, PLAYER[0]->tilex, PLAYER[0]->tiley);
										iWaterSndChanWatWall = WorkingChannel;
										SetChanVoldistance (iWaterSndChanWatWall, (FindDistance ((b - PLAYER[0]->tilex), (PLAYER[0]->tiley - f)))*50); 
									}else{
										//set vol depending on distance
										SetChanVoldistance (iWaterSndChanWatWall, (FindDistance ((b - PLAYER[0]->tilex), (PLAYER[0]->tiley - f)))*50); 
									}
									return 0;
								}else if (sprites[b][f] != 0){
									if (sprites[b][f]->itemnumber == stat_healingbasin){
										if ( DS_OneSoundActive (iWaterSndChanHealBas) == 0){
											//start water sound
											//SD_PlayIt(WATERSNDHEALBASSIN,0,-10000,0);
											SD_PlayPositionedSound (WATERSNDHEALBASSIN,b,f, PLAYER[0]->tilex, PLAYER[0]->tiley);
											iWaterSndChanHealBas = WorkingChannel;
											SetChanVoldistance (iWaterSndChanHealBas, (FindDistance ((b - PLAYER[0]->tilex), (PLAYER[0]->tiley - f)))*50); 
										}else{
											//DWORD p = GetChanCurrentPosition (iWaterSndChanHealBas);
											//set vol depending on distance
											SetChanVoldistance (iWaterSndChanHealBas, (FindDistance ((b - PLAYER[0]->tilex), (PLAYER[0]->tiley - f)))*50); 
										}
										return 0;
									}

								}
							}
						}
					}
				//}
			}

		}
	}
	 
	}


	if (DS_OneSoundActive (iWaterSndChanWatWall) == 1)
		DS_StopOneSound (iWaterSndChanWatWall);
	if (DS_OneSoundActive (iWaterSndChanHealBas) == 1)
		DS_StopOneSound (iWaterSndChanHealBas);
	return 0;
}




int WTR_FindNearestTile (int tile ,int range,int *stilex, int *stiley)
{
    int r,i, j, x, y;

    x = *stilex;
    y = *stiley;

	for (r = 1; r <= range; r++){
		for (j = y - r; j <= y + r; j++){
			for (i = x - r; i <= x + r; i++){
				if(MAPSPOT (i,j, 0) == tile){
					*stilex = i;
					*stiley = j;
					return 1;
				}
			}
		}
	}
	return 0;
}






#endif 

