
/******************************************************************************
winsound.cpp 

 Copyright  2008, 2022 by Birger N. Andreasen
 Please send any bugreports, comments and other issues to:
 E-Mail = bna@bbsyd.dk
 Homepage with other ROTT stuff = http://www.riseofthetriad.dk/

 ******************************************************************************/





//#include "stdafx.h"
#include <windows.h>
#include <mmsystem.h>
#include "winsound.h"
#include "rt_def.h"
#include "w_wad.h"
#include "z_zone.h"
#include "rt_util.h"
#include "develop.h"
 #include "rt_sound.h"

#include "resource.h"

extern HINSTANCE hInst;
extern HWND hWnd3Dwnd;
extern "C" {
	extern int FXvolume;
	extern boolean stereoreversed;
}
extern void ErrorDontQuit (LPCTSTR error, int i, ...);


UINT CurrentChannel = 0;
pWaveChannel_t pWaveChannels[MAXCHANNELS];

typedef struct 
{ 
	unsigned char Description[20];
	unsigned short DataBlockOffset;
	unsigned short Version;
	unsigned short IDCode;
} VocHeader;

typedef struct
{
   UCHAR       ucBitsPerSample;
   UCHAR       ucChannels;
   USHORT      usFileFormat;
   USHORT      usTimeConstant;
   long        lSamplesPerSeconds;
   long        lTotalLength;
} FILEINFO;

typedef struct 
  {
	BYTE		ChunkID[4];    //Contains the letters "RIFF" in ASCII form (0x52494646 big-endian form).
	DWORD		ChunkSize;     //36 + SubChunk2Size, or more precisely:
	BYTE		Format[4];     //Contains the letters "WAVE"
	BYTE		Subchunk1[4]; 
	DWORD		Subchunk1Size;
	WORD		AudioFormat;
	WORD		NumChannels;
	DWORD		SampleRate;
	DWORD		ByteRate;
	WORD		BlockAlign;
	WORD		BitsPerSample;
	BYTE		Subchunk2ID[4];//Contains the letters "fmt "
	DWORD		Subchunk2Size;
  }WAVEFILEHEADER;

char* DecodeVoc( char *data, int sndnum, int size, FILEINFO *psFileInfo);


extern "C" {
	UINT WS_PlayRottSound(int sndnum, char *SndInMem, int size, BOOL bLoop, int angle, int distance, int pitch);
}


UINT WS_PlayRottSound(int sndnum, char *SndInMem, int size, BOOL bLoop, int angle, int distance, int pitch)
{
//	if (sndnum == 252)
//		return 1;
//	if (sndnum <= 11)
//		return 1;

	 PWAVE pWave = NULL;
	//is our next soundchannel allready fixed else do so
	 if (pWaveChannels[CurrentChannel].pWave == 0){
		 //open a sound channel
		WAVE_FILE_HEADER *WaveFileHeader = (WAVE_FILE_HEADER*)(SndInMem+sizeof(RIFF_CHUNK)+12);
		pWave = (PWAVE)LocalAlloc(LMEM_ZEROINIT, sizeof(WAVELIB));
		pWaveChannels[CurrentChannel].pWave = pWave;

		pWave->WaveSample.WaveFormatEx.wFormatTag      = WAVE_FORMAT_PCM;//WaveFileHeader->wFormatTag;         
		pWave->WaveSample.WaveFormatEx.nChannels       = 1;//WaveFileHeader->wChannels;          
		pWave->WaveSample.WaveFormatEx.nSamplesPerSec  = 11025;//WaveFileHeader->dwSamplesPerSec;    
		pWave->WaveSample.WaveFormatEx.nAvgBytesPerSec = 11025;//WaveFileHeader->dwAvgBytesPerSec;   
		pWave->WaveSample.WaveFormatEx.nBlockAlign     = 1;//WaveFileHeader->wBlockAlign;  
		pWave->WaveSample.WaveFormatEx.wBitsPerSample  = 8;//WaveFileHeader->wBitsPerSample;
		pWave->WaveSample.WaveFormatEx.cbSize          = sizeof(WAVE_FILE_HEADER);

		if(waveOutOpen(&pWave->hWaveOut, WAVE_MAPPER, &pWave->WaveSample.WaveFormatEx, (ULONG)0, (ULONG)pWave, CALLBACK_NULL ) != MMSYSERR_NOERROR)
		//if(waveOutOpen(&pWave->hWaveOut, WAVE_MAPPER, &pWave->WaveSample.WaveFormatEx, (ULONG)Wave_WaveOutputCallback, (ULONG)pWave, CALLBACK_FUNCTION) != MMSYSERR_NOERROR)
		{
			pWave = NULL;
			return 0;
		}
	 }else{
		pWave = pWaveChannels[CurrentChannel].pWave;
	 }

	if (CurrentChannel++ >= MAXCHANNELS-1)
		CurrentChannel = 0;

	pWave->WaveSample.pSampleData = SndInMem+0x38;//(char *)(SndInMem+sizeof(RIFF_CHUNK)+12+8)+sizeof(WAVE_FILE_HEADER);
	pWave->WaveSample.Size = size-0x3C;

	

	//A value of 0xFFFF represents full volume, and a value of 0x0000 is silence. 
	DWORD Rvol = 0xFFFF;//Right volumen
	DWORD Lvol = 0xFFFF;//left volumen

	// find angle and set it
	if (angle < 15){
		Lvol = 0xFFFF - (angle*0x1111);	
	}else if (angle >= 15){
		Rvol = 0xFFFF - ((angle-15)*0x1111);	
	}

	// WithDraw mainvol 
	Lvol = (Lvol * FXvolume)/255;
	Rvol = (Rvol * FXvolume)/255;
	// Make sound weaker at distance
/*	DWORD DistReduce = 0;
	if ( distance > 0){
		DistReduce = distance*0x290;
	}		
	Lvol -= DistReduce;
	Rvol -= DistReduce;*/
	// Make sure vol is between limits
	if (Lvol > 0xFFFF)
		Lvol = 0xFFFF;
	if (Rvol > 0xFFFF)
		Rvol = 0xFFFF;

	DWORD dwVolume;
	if (stereoreversed == TRUE) {
		dwVolume  = MAKELONG(Rvol,Lvol);
	}else{
		dwVolume  = MAKELONG(Lvol,Rvol);
	}

	waveOutSetVolume(pWave->hWaveOut, dwVolume );
	waveOutSetPitch(pWave->hWaveOut, pitch);


	UINT Index = 0;
	UINT UsedData = 0;
	UINT BufSize = SAMPLESIZE;
	UINT SndSize = pWave->WaveSample.Size;

    for(Index = 0; Index < 8; Index++)
    {
		if (UsedData +  SAMPLESIZE > SndSize){
			memcpy(pWave->AudioBuffer[Index],pWave->WaveSample.pSampleData + UsedData,SndSize-UsedData);
			BufSize = SndSize-UsedData;
			UsedData = SndSize;
		} else {
			memcpy(pWave->AudioBuffer[Index],pWave->WaveSample.pSampleData + UsedData,SAMPLESIZE);
			UsedData += SAMPLESIZE;
		}
        pWave->WaveHeader[Index].dwBufferLength = BufSize;
        pWave->WaveHeader[Index].lpData         = pWave->AudioBuffer[Index]; 
        waveOutPrepareHeader(pWave->hWaveOut, &pWave->WaveHeader[Index], sizeof(WAVEHDR));
        waveOutWrite(pWave->hWaveOut, &pWave->WaveHeader[Index], sizeof(WAVEHDR));
		if (UsedData == SndSize)
			break;
    }

	return 0;
 }


BOOL WS_SoundActive(int sndnum)
{
	PWAVE pWave = pWaveChannels[CurrentChannel-1].pWave;
	MMTIME pmmt;
	UINT cbmmt = sizeof(MMTIME);

	if (pWave == 0)
		return FALSE;

	memset(&pmmt,0,sizeof(MMTIME));

	pmmt.wType = TIME_BYTES;

	waveOutGetPosition(pWave->hWaveOut, &pmmt, (UINT) cbmmt);

	if (pmmt.u.cb >= pWave->WaveSample.Size)
		return TRUE;
	else
		return FALSE;
}







char* WS_ConvertVOCtoWAV(char *data, int sndnum, int size)
{
	WAVEFILEHEADER *wfh;
	FILEINFO psFileInfo;
	char *pData, *wavdata, *vocdata;

	vocdata = DecodeVoc(data, sndnum, size,&psFileInfo);
	if (vocdata == 0)
		return 0;

	pData = (char *)GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,psFileInfo.lTotalLength+sizeof(WAVEFILEHEADER));
	//reset our sound mem
	memset(pData,0x80,psFileInfo.lTotalLength+sizeof(WAVEFILEHEADER));
	wfh = (WAVEFILEHEADER *)pData;
	lstrcpy((LPSTR)wfh->ChunkID,(LPSTR)"RIFF");    //Contains the letters "RIFF" in ASCII form (0x52494646 big-endian form).
	wfh->ChunkSize = psFileInfo.lTotalLength + 36;     //36 + SubChunk2Size, or more precisely:
	lstrcpy((LPSTR)wfh->Format,(LPSTR)"WAVE");     //Contains the letters "WAVE"
	lstrcpy((LPSTR)wfh->Subchunk1,(LPSTR)"fmt "); 
	wfh->Subchunk1Size = 16;
	wfh->AudioFormat = 1;
	wfh->NumChannels = psFileInfo.ucChannels;
	wfh->SampleRate = 11025;//psFileInfo.lSamplesPerSeconds;
	wfh->ByteRate = 11025;//psFileInfo.lSamplesPerSeconds;
	wfh->BlockAlign = 1;
	wfh->BitsPerSample = psFileInfo.ucBitsPerSample;
	lstrcpy((LPSTR)wfh->Subchunk2ID,(LPSTR)"data");//Contains the letters "fmt "
	wfh->Subchunk2Size = psFileInfo.lTotalLength;

	wavdata = pData + sizeof(WAVEFILEHEADER);
	memcpy(wavdata,(vocdata),psFileInfo.lTotalLength);

	GlobalFree(vocdata);
	return (char*)pData;

}





/********************************************************************/
/*																	*/
/* Function name : DecodeVoc			                            */
/* Description   :													*/
/*																	*/
/********************************************************************/

char* DecodeVoc( char *data, int sndnum, int size, FILEINFO *psFileInfo)
{

	char *pData = (char *)GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,size);
	char *pDataPos = pData;
	BYTE bType;
	signed long int lLen;
	unsigned char tmp[4];
	VocHeader *vh = (VocHeader *)data; 
	char *memdata = data + vh->DataBlockOffset;

	if(strncmp((char *)vh->Description,"Creative Voice File\x1A",10)!=0)
	{  
		return 0; //Not a Valid VOC File	
	}


 	//reset our sound mem
	memset(pData,0x80,size);

	if ((*memdata != 1)&&(*memdata != 8)&&(*memdata != 9)){
		if (*memdata == 6)
			memdata = data + 0x20;
		else{
			psFileInfo->usTimeConstant = 65444; 
			psFileInfo->usFileFormat = 0; 
			psFileInfo->ucBitsPerSample    = 8;
			psFileInfo->ucChannels         = 1;
			psFileInfo->lSamplesPerSeconds = 10869;
			psFileInfo->lTotalLength = size;
			memcpy(pDataPos,memdata,size);
			return pData;
		}
	}

	do
	{
		// Read the block type
		bType = *memdata++;

		lLen = 0;
		switch( bType )
		{
		case 1:
		{
			tmp[0] = *memdata++; 
			tmp[1] = *memdata++; 
			tmp[2] = *memdata++; 
			lLen = (tmp[2]*(256*256))+(tmp[1]*256)+tmp[0];

			lLen -= 2;// Remove Time Constant and File Format bytes
			psFileInfo->usTimeConstant = *memdata++; 
			psFileInfo->usFileFormat = *memdata++; 
			// For the moment, it's a plain 8-bit mono file
			psFileInfo->ucBitsPerSample    = 8;
			psFileInfo->ucChannels         = 1;
			psFileInfo->lSamplesPerSeconds = 1000000 /
			(256-(psFileInfo->usTimeConstant % 256));
			// Store this sample in memory
			memcpy(pDataPos,memdata,lLen);
			pDataPos += lLen;
			memdata += lLen;
			break;
		}

		case 8:
		{
			memdata+=3; 
			tmp[0] = *memdata++; 
			tmp[1] = *memdata++; 
			psFileInfo->usTimeConstant = (tmp[1]*256)+tmp[0];
			psFileInfo->usFileFormat = *memdata++; 
			psFileInfo->ucChannels = *memdata++; 
			bType = *memdata++;
			tmp[0] = *memdata++; 
			tmp[1] = *memdata++; 
			tmp[2] = *memdata++; 
			lLen = (tmp[2]*(256*256))+(tmp[1]*256)+tmp[0];
			lLen -= 2;     // Remove Time Constant and File Format bytes
			memdata+=2; 
			psFileInfo->ucBitsPerSample    = 8;
			psFileInfo->ucChannels++;
			psFileInfo->usTimeConstant >>= 8;
			psFileInfo->lSamplesPerSeconds = 1000000 /
			(256-(psFileInfo->usTimeConstant % 256));
			memcpy(pDataPos,memdata,lLen);
			pDataPos += lLen;
			memdata += lLen;
			break;
		}

		case 9:
		{
			tmp[0] = *memdata++; 
			tmp[1] = *memdata++; 
			tmp[2] = *memdata++; 
			lLen = (tmp[2]*(256*256))+(tmp[1]*256)+tmp[0];
			lLen -= 12;
			tmp[0] = *memdata++; 
			tmp[1] = *memdata++; 
			tmp[2] = *memdata++; 
			tmp[3] = *memdata++; 
			psFileInfo->lSamplesPerSeconds = (tmp[3]*(256*256*256))+(tmp[2]*(256*256))+(tmp[1]*256)+tmp[0];
			psFileInfo->ucBitsPerSample = *memdata++; 
			psFileInfo->ucChannels = *memdata++; 
			tmp[0] = *memdata++; 
			tmp[1] = *memdata++; 
			psFileInfo->usFileFormat = (tmp[1]*256)+tmp[0];
			memcpy(pDataPos,memdata,lLen);
			pDataPos += lLen;
			memdata += lLen;
			break;
		}
	};
	} while ( bType != 0 );

	psFileInfo->lTotalLength = pDataPos-pData;

	return pData;
}



void CALLBACK MidiOutputCallback(UINT uMsg, DWORD dwInstance, DWORD dwParam1, DWORD dwParam2);

// Plays a specified MIDI file by using MCI_OPEN and MCI_PLAY. Returns 
// as soon as playback begins. The window procedure function for the 
// specified window will be notified when playback is complete. 
// Returns 0L on success; otherwise, it returns an MCI error code.
UINT WS_PlayMidiSound( char *midisongname);
UINT WS_PlayMidiSound( char *midisongname)
{
    UINT wDeviceID;
    DWORD dwReturn;
    MCI_OPEN_PARMS mciOpenParms;
    MCI_PLAY_PARMS mciPlayParms;
//    MCI_STATUS_PARMS mciStatusParms;
//    MCI_SEQ_SET_PARMS mciSeqSetParms;


    // Open the device by specifying the device and filename.
    // MCI will attempt to choose the MIDI mapper as the output port.
    mciOpenParms.lpstrDeviceType = "sequencer";
    mciOpenParms.lpstrElementName = (LPCSTR)midisongname;



    if (dwReturn = mciSendCommand(mciGetDeviceID("Microsoft MIDI Mapper"), MCI_OPEN,
        MCI_OPEN_TYPE | MCI_OPEN_ELEMENT,
        (DWORD)(LPVOID) &mciOpenParms))
    {
        // Failed to open device. Don't close it; just return error.
        return (dwReturn);
    }

    // The device opened successfully; get the device ID.
    wDeviceID = MIDI_MAPPER;//mciOpenParms.wDeviceID;

    // Check if the output port is the MIDI mapper.
 /*   mciStatusParms.dwItem = MCI_SEQ_STATUS_PORT;
    if (dwReturn = mciSendCommand(wDeviceID, MCI_STATUS, 
        MCI_STATUS_ITEM, (DWORD)(LPVOID) &mciStatusParms))
    {
        mciSendCommand(wDeviceID, MCI_CLOSE, 0, NULL);
        return (dwReturn);
    }

    // The output port is not the MIDI mapper. 
    // Ask if the user wants to continue.
    if (LOWORD(mciStatusParms.dwReturn) != MIDI_MAPPER)
    {
        if (MessageBox(hWnd3Dwnd,
            "The MIDI mapper is not available. Continue?",
            "", MB_YESNO) == IDNO)
        {
            // User does not want to continue. Not an error;
            // just close the device and return.
            mciSendCommand(wDeviceID, MCI_CLOSE, 0, NULL);
            return (0L);
        }
    }
*/
    // Begin playback. The window procedure function for the parent 
    // window will be notified with an MM_MCINOTIFY message when 
    // playback is complete. At this time, the window procedure closes 
    // the device.
    mciPlayParms.dwCallback = (DWORD_PTR)MidiOutputCallback;//(DWORD) NULL;
    if (dwReturn = mciSendCommand(wDeviceID, MCI_PLAY, NULL, 
        (DWORD)(LPVOID) &mciPlayParms))
    {
        mciSendCommand(wDeviceID, MCI_CLOSE, 0, NULL);
        return (dwReturn);
    }
 
    return (0L);
}



void CALLBACK MidiOutputCallback(UINT uMsg, DWORD dwInstance, DWORD dwParam1, DWORD dwParam2)
{


    switch(uMsg)
    {
      case WOM_OPEN:
            //WaveLib_WaveOpen(hwo, pWaveLib);
            break;

       case WOM_DONE:
            //WaveLib_WaveDone(hwo, pWaveLib);
            break;

       case WOM_CLOSE:
            //WaveLib_WaveClose(hwo, pWaveLib);
            break;
    }
}