 
/******************************************************************************
 DirectDraw.c 

 Copyright  2004, Birger N. Andreasen 
 Please send any bugreports, comments and other issues to:
 E-Mail = bna@post10.tele.dk
 Homepage with other ROTT stuff = http://home14.inet.tele.dk/Bna-Info

 ******************************************************************************/

#include <windows.h>
#include "WinRott.h"
#include <stdio.h>
#include <stdlib.h>
#include "..\resource.h"  
#include "develop.h"
#include <windowsx.h>
#include "DPwinrott.h"
#include "..\DirectDraw\DirectDraw.h"
#include "..\DirectInput\DMInput.h"
#include <direct.h>
#include <ddraw.h>


#undef RELEASE
#define RELEASE(i) if (i != NULL) {i->lpVtbl->Release(i); i = NULL;}


// ----------- DEFINES --------------------------------------------------------
//#define DIRECTINPUT_VERSION 0x0800 


// ----------- PROTOTYPES -----------------------------------------------------
void DD_RenderScene(void);
void DD_InitGlobals(void);
BOOL DD_SetupDirectDraw(HWND);
BOOL DD_CheckSurfaces(void);
void DD_ShutdownDirectDraw(void);
extern void ErrorBox(LPSTR lpszErrorStr, HRESULT hr);


// ----------- GLOBALS --------------------------------------------------------
BOOL                 DDHard3D = 0;

LPDIRECTDRAW         lpDD;          // DirectDraw Interface
LPDIRECTDRAW2        lpDD2;         // DirectDraw Interface
LPDIRECTDRAWSURFACE  lpDDSPrimary;  // DirectDraw Surface
LPDIRECTDRAWSURFACE  lpDDSBack;     // DirectDraw Backbuffer Surface
LPDIRECTDRAWPALETTE  lpPalette = NULL; 
PALETTEENTRY         rPal[768];        

byte *DDscreen;

extern HWND		hMainWnd;
extern int		iGLOBAL_SCREENWIDTH;// bna default value 800
extern int		iGLOBAL_SCREENHEIGHT;//bna default value 600




//----------------------------------------------------------------------------------------
BOOL DD_SetupDirectDraw(HWND hwnd )
{
    HRESULT hresult;
    static DDSURFACEDESC ddsd;
    static DDSCAPS ddscaps;


    ShowCursor(FALSE);

	hresult = DirectDrawCreate( NULL, &lpDD, NULL );
    if (hresult != DD_OK)
		ErrorBox("DirectDrawCreate Error",hresult);

    hresult = lpDD->lpVtbl->SetCooperativeLevel(lpDD, hwnd, DDSCL_NORMAL);
    if (hresult != DD_OK)
		ErrorBox("GetCaps Error",hresult);

    hresult = lpDD->lpVtbl->QueryInterface(lpDD, &IID_IDirectDraw2, (LPVOID *)&lpDD2);
    if (hresult != DD_OK)
		ErrorBox("QueryInterface Error",hresult);

    hresult = lpDD2->lpVtbl->SetCooperativeLevel(lpDD2, hwnd,DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN | DDSCL_ALLOWMODEX);
    if (hresult != DD_OK)
		ErrorBox("SetCooperativeLevel Error",hresult);

	hresult = lpDD2->lpVtbl->SetDisplayMode(lpDD2, iGLOBAL_SCREENWIDTH,iGLOBAL_SCREENHEIGHT, 8 ,0,DDSDM_STANDARDVGAMODE);
  
	if (hresult != DD_OK)
		ErrorBox("SetDisplayMode Error",hresult);	

	memset(&ddsd, sizeof(DDSURFACEDESC), 0);
    ddsd.dwSize = sizeof(ddsd);
    ddsd.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
    ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE | DDSCAPS_FLIP | DDSCAPS_COMPLEX;
    ddsd.dwBackBufferCount = 1;
    hresult = lpDD2->lpVtbl->CreateSurface(lpDD2, &ddsd, &lpDDSPrimary, NULL);
    if (hresult != DD_OK)
		ErrorBox("CreateSurface Error",hresult);

    ddscaps.dwCaps = DDSCAPS_BACKBUFFER;
    hresult = lpDDSPrimary->lpVtbl->GetAttachedSurface(lpDDSPrimary, &ddscaps, &lpDDSBack);
    if (hresult != DD_OK)
		ErrorBox("GetAttachedSurface Error",hresult);

    lpDDSPrimary->lpVtbl->GetCaps(lpDDSPrimary, &ddscaps);

    ddsd.dwSize = sizeof(ddsd);
    lpDDSBack->lpVtbl->GetSurfaceDesc(lpDDSBack, &ddsd);

    return TRUE;
}

//----------------------------------------------------------------------------------------
void DD_InitGlobals(void)
{
    lpDD = NULL;
    lpDD2 = NULL;
    lpDDSPrimary = NULL;
    lpDDSBack = NULL;
}

//----------------------------------------------------------------------------------------
DD_SetPalette(int i, int r,int g, int b)
{
	HRESULT hresult;
	if (i != -1){
		rPal[i].peRed   = r ;
		rPal[i].peBlue  = g ;
		rPal[i].peGreen = b ;
		rPal[i].peFlags = 0;
	}else{
        // Create the palette
        hresult = lpDD2->lpVtbl->CreatePalette(lpDD2, DDPCAPS_8BIT | DDPCAPS_ALLOW256 | DDPCAPS_INITIALIZE, rPal, &lpPalette, NULL);
        if (hresult != DD_OK)
			ErrorBox("CreatePalette Error",hresult);
        // Set the back buffer's palette
        hresult = lpDDSBack->lpVtbl->SetPalette(lpDDSBack, lpPalette);
        if (hresult != DD_OK)
			ErrorBox("SetPalette - Back Buffer Error",hresult);
        // Set the primary surface's palette
        hresult = lpDDSPrimary->lpVtbl->SetPalette(lpDDSPrimary, lpPalette);
        if (hresult != DD_OK)
			ErrorBox("SetPalette - Primary Surface Error",hresult);
     
	}
}

//----------------------------------------------------------------------------------------
int DD_Get_R_Palette(int i){
	return rPal[i].peRed; 
}

//----------------------------------------------------------------------------------------
int DD_Get_B_Palette(int i){
	return rPal[i].peGreen; 
}

//----------------------------------------------------------------------------------------
int DD_Get_G_Palette(int i){
	return rPal[i].peBlue; 
}

//----------------------------------------------------------------------------------------
BOOL DD_CheckSurfaces()
{
	// Check the primary surface
    if (lpDDSPrimary){
        if (lpDDSPrimary->lpVtbl->IsLost(lpDDSPrimary))	{
            lpDDSPrimary->lpVtbl->Restore(lpDDSPrimary);
            return FALSE;
		}
	}

    return TRUE;
}


//----------------------------------------------------------------------------------------
void DD_RenderScene()
{
    DDSURFACEDESC ddsd;
    static int    i, j, x, y, dw, pd;
    HRESULT       hresult;
    DWORD        *Buff, *Scrn;



    if (DD_CheckSurfaces() == FALSE) return;

    Scrn = (byte *)DDscreen;
    ddsd.dwSize = sizeof(ddsd);

	lpDDSBack->lpVtbl->GetSurfaceDesc(lpDDSBack, &ddsd);

    hresult = lpDDSBack->lpVtbl->Lock(lpDDSBack, NULL, &ddsd, DDLOCK_SURFACEMEMORYPTR | DDLOCK_WAIT, NULL);
    if (hresult == DD_OK)
	{
        Buff = ddsd.lpSurface;
        dw = iGLOBAL_SCREENWIDTH / 4;
        pd = ddsd.lPitch / 4;
        for (j = 0; j < iGLOBAL_SCREENHEIGHT; j++)	{
            memcpy(&Buff[j * pd], &Scrn[j * dw], iGLOBAL_SCREENWIDTH);
		}
        lpDDSBack->lpVtbl->Unlock(lpDDSBack, NULL);
	}
	else{
		ErrorBox("Lock DD Surface Error",hresult);
	}

	while (lpDDSPrimary->lpVtbl->Flip(lpDDSPrimary, NULL, DDFLIP_WAIT) == DDERR_WASSTILLDRAWING);

}

//----------------------------------------------------------------------------------------
void DD_ShutdownDirectDraw(void)
{
    if(lpDD2 != NULL)
		lpDD2->lpVtbl->RestoreDisplayMode(lpDD2);

    if(lpDD2 != NULL)
        lpDD2->lpVtbl->SetCooperativeLevel(lpDD2, hMainWnd, DDSCL_NORMAL);

    RELEASE(lpDDSBack);
    lpDDSBack = 0;
    RELEASE(lpDDSPrimary);
    lpDDSPrimary = 0;
    RELEASE(lpPalette);
    lpPalette = 0;
    RELEASE(lpDD2);
    lpDD2 = 0;
//    RELEASE(lpDD);
//    lpDD = 0;

}





