
/******************************************************************************
 DirectMouseInput.cpp 

 Copyright  2004, Birger N. Andreasen 
 Please send any bugreports, comments and other issues to:
 E-Mail = bna@post10.tele.dk
 Homepage with other ROTT stuff = http://home14.inet.tele.dk/Bna-Info

 ******************************************************************************/

 #define DIRECTINPUT_VERSION 0x0500 
#include "DMInput.h"

#ifdef USESDLMOUSE 

#else
  

#include <dinput.h>


// ----------- PROTOTYPES -----------------------------------------------------
extern "C" {
extern  long GetSetVolumeMidi (long newvol, int SetGetFLAG); // 0 = get  1 = set
	int MX = 0;
	int MY = 0;
	extern HINSTANCE	hInst;           
	extern HWND			hMainWnd;     
    BOOL				InitMouseForGame(void);
	BOOL				ReacquireMouse(void);
	BOOL				InitMouseInput(void);
	int					DI_PollMouse(void);
	void				CleanupInput(void);
	BYTE				DI_PollKeyboard();
	void				DI_GetLastdiKeys ();
	boolean				DI_MenuBufStarted=false;
	extern void DD_ShutdownDirectDraw(void);
	//extern int DI_PollMouseButtons(boolean);
	extern void QueueLetterInput (void);
	extern void ReadDelay(long delay);
	extern volatile int KeyboardQueue[256];
	extern volatile boolean PausePressed;  //Game paused variable
	extern volatile boolean PanicPressed;  //Panic key variable
	extern volatile int Keyboard[128];
	extern boolean  buttonpoll[26];
	extern volatile int LastScan;

}

BOOL CALLBACK		DIEnumDevicesProc(LPCDIDEVICEINSTANCE lpddi,LPVOID pvRef);
extern void			ErrorBoxD(LPSTR lpszErrorStr, HRESULT hr);

#include "keyb.h"


// ----------- DEFINES --------------------------------------------------------
#define NUMTXBUTTONS    16
#define BUFFERCOUNT 256                     // elements in keyboard buffer
enum    {
		  bt_nobutton=-1,
		  bt_attack=0,
		  bt_strafe=1,
		  bt_run=2,
		  bt_use=3,
		  bt_lookup=4,
		  bt_lookdown=5,
		  bt_swapweapon=6,
		  bt_dropweapon=7,
		  bt_horizonup=8,
          bt_horizondown=9,
          bt_pistol=10,
          bt_dualpistol=11,
          bt_mp40=12,
          bt_missileweapon=13,
          bt_autorun=14,
		  bt_recordsound=15,
		  bt_strafeleft=16,
		  bt_straferight=17,
          bt_turnaround=18,
          bt_aimbutton=19,
          di_north=20,
          di_east=21,
          di_south=22,
          di_west=23,
          bt_map=24,
          bt_message=25,
          bt_directmsg=26,
          NUMBUTTONS
};


// ----------- GLOBALS --------------------------------------------------------
static LPDIRECTINPUT  lpdi;            
LPDIRECTINPUTDEVICE   lpdiMouse;   
LPDIRECTINPUTDEVICE   lpdiKeyboard;   

DIMOUSESTATE          diMouseState;
DIDEVICEOBJECTDATA    KbdBuffer[BUFFERCOUNT];
DIDEVICEOBJECTDATA    MouseBuffer[BUFFERCOUNT];

BOOL                  MouseAcquired; 
BOOL                  KeyboardAcquired;   
static GUID           MouseGUID;
static GUID           KeyboardGUID;
static BOOL           ClickHandled, RClickHandled;
static BOOL           MouseFound;
static BOOL           KeyboardFound;



//---------------------------------------------------------------------------------------
/* ********************************************************************
credits to 'bert' for writing the InitMouseForGame code, 
and 'nightfright' for specific testing on his computer for the mx510 mouse.
*/
BOOL InitMouseForGame(void)
{	
	if(MouseAcquired)	
	{		
		lpdiMouse->Unacquire();		
		MouseAcquired = FALSE;	
	}	
	if(lpdiMouse->SetCooperativeLevel(hMainWnd,DISCL_EXCLUSIVE | DISCL_FOREGROUND) != DI_OK)
	{		
		ErrorBoxD("Failed to set cooperative level.\n", 0);		
		return FALSE;	
	}	lpdiMouse->Acquire();	
	MouseAcquired = TRUE;
}
//********************************************************************



BOOL InitMouseInput(void)
{
  DIPROPDWORD dipdw;
	static GUID  DefaultGUID = GUID_SysMouse;
	static GUID  KeyboardGUID = GUID_SysKeyboard; 


 HRESULT     hres;
	// try to create DirectInput object
	if(DirectInputCreate(hInst, DIRECTINPUT_VERSION, &lpdi, NULL) != DI_OK) {
		ErrorBoxD("Failed to create DirectInput object.\n", 0);
		return FALSE;
    }
  
	// enumerate devices so we can get the Mouse GUID
	if (lpdi->EnumDevices(DIDEVTYPE_MOUSE,DIEnumDevicesProc,&MouseGUID,DIEDFL_ATTACHEDONLY) != DI_OK) {
	  	ErrorBoxD("Could not enumerate mouse devices.\n", 0);
		return FALSE;
    }

	// try to create mouse device
	if(lpdi->CreateDevice(MouseGUID, &lpdiMouse, NULL) !=DI_OK) {
	   if (lpdi->CreateDevice(DefaultGUID, &lpdiMouse, NULL) != DI_OK) {
	  		ErrorBoxD("Failed to create mouse device.\n", 0);
			return FALSE;
	   }
	}

	// set cooperative level
	if(lpdiMouse->SetCooperativeLevel(hMainWnd,DISCL_NONEXCLUSIVE| DISCL_BACKGROUND) != DI_OK){
	  	ErrorBoxD("Failed to set cooperative level.\n", 0);
	    return FALSE;
	}
  
	// Set data format. Must be done before mouse can be acquired.
	//   Note: c_dfDIMouse is an external DIDATAFORMAT structure supplied
	//   by DirectInput. Default values are:
	//          dwSize      24
	//          dwObjSize   16
	//          dwFlags      2    = DIDF_RELAXIS
	//          dwDataSize  16
	//          dwNumObjs    7    (3 axes and 4 buttons)

	if (lpdiMouse->SetDataFormat(&c_dfDIMouse) != DI_OK)  {
	  	ErrorBoxD("Failed to set mouse data format.\n", 0);
		return FALSE;
	}

	// This is how to change the mouse coordinates from relative to absolute. 
	/*
	  DIPROPDWORD dipdw;
	  HRESULT hres;
	  dipdw.diph.dwSize = sizeof(DIPROPDWORD);
	  dipdw.diph.dwHeaderSize = sizeof(DIPROPHEADER);
	  dipdw.diph.dwObj = 0;
	  dipdw.diph.dwHow = DIPH_DEVICE;
	  dipdw.dwData = DIPROPAXISMODE_ABS;
	  hres = lpdiMouse->SetProperty(DIPROP_AXISMODE, &dipdw.diph);
	  if (hres != DI_OK) 
		OutputDebugString("Failed to set mouse axis mode.\n");
	*/

	// try to acquire the mouse
	if (lpdiMouse->Acquire() != DI_OK) {
		ErrorBoxD("Failed to acquire the mouse.\n", 0);
		return FALSE;
	}
 

	MouseAcquired = TRUE;

  // try to create keyboard device
  if(lpdi->CreateDevice(KeyboardGUID, &lpdiKeyboard, NULL) !=DI_OK)
    {
    OutputDebugString("Failed to create keyboard device.\n");
    return FALSE;
    }

  // set kbd cooperative level DISCL_NOWINKEY |
  if (lpdiKeyboard->SetCooperativeLevel(hMainWnd,
         DISCL_NONEXCLUSIVE | DISCL_BACKGROUND) != DI_OK)
    {
    OutputDebugString("Failed to set keyboard cooperative level.\n");
    return FALSE;
    }

  // set kbd data format
  if (lpdiKeyboard->SetDataFormat(&c_dfDIKeyboard) != DI_OK)
    {
    OutputDebugString("Failed to set keyboard data format.\n");
    return FALSE;
    }

  // set kbd buffer size
  dipdw.diph.dwSize = sizeof(DIPROPDWORD);
  dipdw.diph.dwHeaderSize = sizeof(DIPROPHEADER);
  dipdw.diph.dwObj = 0;
  dipdw.diph.dwHow = DIPH_DEVICE;
  dipdw.dwData = BUFFERCOUNT; // * sizeof(DIDEVICEOBJECTDATA);
  hres = lpdiKeyboard->SetProperty(DIPROP_BUFFERSIZE, &dipdw.diph);
  if (hres != DI_OK) 
    {
    OutputDebugString("Failed to set keyboard buffer size.\n");
    return FALSE;
    }

  // try to acquire the keyboard
  if (lpdiKeyboard->Acquire() != DI_OK)
    {
    OutputDebugString("Failed to acquire the keyboard.\n");
    return FALSE;
    }

  KeyboardAcquired = TRUE;
/*
  //disable alt+tab keys
   RegisterHotKey(0, 0, MOD_ALT, VK_TAB);
   RegisterHotKey(0, 1, MOD_ALT, VK_RETURN);
   RegisterHotKey(0, 2, MOD_ALT, VK_ESCAPE);	
 //  RegisterHotKey(0, 3, MOD_WIN|MOD_ALT, VK_ESCAPE);
*/
   RegisterHotKey(hMainWnd, 0, MOD_ALT, VK_TAB);
   RegisterHotKey(hMainWnd, 1, MOD_ALT, VK_RETURN);
   RegisterHotKey(hMainWnd, 2, MOD_ALT, VK_ESCAPE);	

   //RegisterHotKey(hMainWnd, 3, MOD_WIN|MOD_ALT, VK_ESCAPE);

  return TRUE; 
  
}  


//---------------------------------------------------------------------------------------
void CleanupInput(void)
{
        if(MouseAcquired)    {
                lpdiMouse->Unacquire();
                MouseAcquired = FALSE;
        }
        if(lpdiMouse != NULL)
                lpdiMouse->Release();

        if(KeyboardAcquired)    {
                lpdiKeyboard->Unacquire();
                KeyboardAcquired = FALSE;
        }
        if(lpdiKeyboard != NULL)
                lpdiKeyboard->Release();

         if(lpdi!= NULL)
                lpdi->Release();       
}


//---------------------------------------------------------------------------------------
BOOL ReacquireMouse(void)
{

	// try to acquire the Mouse
	if(lpdiMouse != NULL) {
		lpdiMouse->Acquire();
	}else{
		// Mouse device has not been created.
		return FALSE;
	}

	// if we get here, we are acquired again
	MouseAcquired = TRUE;
	return TRUE;
}

//---------------------------------------------------------------------------------------
int DI_PollMouse()
{ 
	DIMOUSESTATE diMouseState;/*
   Button 1:	Left mouse button
   Button 2:	Middle mouse button
   Button 3:	Right mouse button
   Button 4:	Mouse wheel up	 (may also be a real button)
   Button 5:	Mouse wheel down (may also be a real button)*/
	if (!MouseAcquired) 
		return FALSE;
	if (lpdiMouse->GetDeviceState(sizeof(diMouseState), &diMouseState)== DI_OK) {
		MX = diMouseState.lX;
		MY = diMouseState.lY;
		if (diMouseState.lZ > 0){
			return 4;
			MY += 200;
			return 0; 
		}
		if (diMouseState.lZ < 0){
			return 5;
			MY -= 200;
			return 0; 
		}
		// left button 
		if (diMouseState.rgbButtons[0] & 0x80)	{
			//DD_ShutdownDirectDraw();
			return 1; 
		}
		// right button 
		if (diMouseState.rgbButtons[1] & 0x80){
			//DD_ShutdownDirectDraw();
			//exit(0);
			return 3;
		} 
		if (diMouseState.rgbButtons[2] & 0x80)	{
			//DD_ShutdownDirectDraw();
			return 2; 
		}

	} 

	return 0;
}



//extern int buttonscan[];
//extern     scancodes[1]          = sc_Space;
extern "C"{
	extern int      buttonscan[27];
}/*
= {sc_Control, sc_Alt, sc_RShift, sc_Space,
									sc_PgUp,sc_PgDn,sc_Enter,sc_Delete,
                                   sc_Home,sc_End,sc_1,sc_2,sc_3,sc_4,
                                   sc_CapsLock, sc_F12,
                                   sc_Comma,sc_Period,sc_BackSpace,sc_A,
                                   sc_UpArrow, sc_RightArrow,
                                   sc_DownArrow, sc_LeftArrow,
                                   sc_Tab, sc_T, sc_Z };
						 
extern char order[ 21 ] = {
   di_west, di_east, di_north, di_south, bt_run, bt_use, bt_attack,
   bt_strafe, bt_strafeleft, bt_straferight, bt_lookup, bt_lookdown,
   bt_aimbutton, bt_horizonup, bt_horizondown, bt_swapweapon, bt_dropweapon,
   bt_turnaround, bt_autorun, bt_message, bt_directmsg
   };
	*/	
BYTE diKeys[256];
int  b=0;
//---------------------------------------------------------------------------------------
BYTE DI_PollKeyboard()
{
	int i;
	
	LastScan = 0;

//GetSetVolumeMidi (1,1) ;
		if (lpdiKeyboard->GetDeviceState(256, &diKeys)== DI_OK){

		if ((diKeys[DIK_LSHIFT]&0x80)&&(diKeys[DIK_LCONTROL]&0x80)&&(diKeys[DIK_F12]&0x80)) {//Alt+ctrl+f12
			DD_ShutdownDirectDraw();
			exit(0);
		}


		//disable windows keys
		if (diKeys[DIK_LWIN ] & 0x80) {
			//disable left win key
			keybd_event(DIK_LWIN,0,KEYEVENTF_KEYUP,0);
			return 0;
		}
		if (diKeys[DIK_RWIN ] & 0x80) {
			//disable rwin key
			keybd_event(DIK_RWIN,0,KEYEVENTF_KEYUP,0);
			return 0;
		}
		/*
		//if (diKeys[DIK_TAB ] & 0x80) {
		if ((diKeys[DIK_LMENU ]&0x80)&&(diKeys[DIK_TAB ]&0x80)){
			DD_ShutdownDirectDraw();
			keybd_event(DIK_LMENU,0,KEYEVENTF_KEYUP,0);
			keybd_event(DIK_TAB,0,KEYEVENTF_KEYUP,0);
			return 0;
		}
*/

		//if (b>1){}
		if (diKeys[DIK_ESCAPE] & 0x80) {
			LastScan = sc_Escape;ReadDelay(2);
			//on fast computers the escape comes to speedy
			//so therefor this hack
			//if (DI_MenuBufStarted==TRUE){
			//	ReadDelay(2);
			//}
			//KeyboardQueue[0] = sc_Escape;
		//	b++;
         // 
		 // i=i;
		  //return 0;
		}


		if (diKeys[DIK_CAPITAL] & 0x80) {
			LastScan = sc_CapsLock;
			buttonpoll[ bt_autorun ] = TRUE;
			//ReadDelay(1000);
		}
		if (diKeys[DIK_F1] & 0x80) {
			LastScan = sc_F1;ReadDelay(100);
		}
		if (diKeys[DIK_F2] & 0x80) {
			LastScan = sc_F2;ReadDelay(100);
		}
		if (diKeys[DIK_F3] & 0x80) {
			LastScan = sc_F3;ReadDelay(100);
		}
		if (diKeys[DIK_F4] & 0x80) {
			LastScan = sc_F4;ReadDelay(100);
		}
		if (diKeys[DIK_F5] & 0x80) {
			LastScan = sc_F5;ReadDelay(100);
		}
		if (diKeys[DIK_F6] & 0x80) {
			LastScan = sc_F6;ReadDelay(100);
		}
		if (diKeys[DIK_F7] & 0x80) {
			LastScan = sc_F7;ReadDelay(100);
		}
		if (diKeys[DIK_F8] & 0x80) {
			LastScan = sc_F8;ReadDelay(100);
		}
		if (diKeys[DIK_F9] & 0x80) {
			LastScan = sc_F9;ReadDelay(100);
		}
		if (diKeys[DIK_F10] & 0x80) {
			LastScan = sc_F10;ReadDelay(100);
		}
		if (diKeys[DIK_F11] & 0x80) {
			LastScan = sc_F11;ReadDelay(100);
		}
		if (diKeys[DIK_F12] & 0x80) {
			LastScan = sc_F1;ReadDelay(100);
		}

		//Keystate[strippedkey]#define	sc_F1				0x3b
		if (diKeys[DIK_RETURN   ] & 0x80) {
			//buttonpoll[ di_north ] = TRUE
			LastScan = sc_Enter;
		//	b++;
        // 
		  //i=i;
		}

		//			DD_ShutdownDirectDraw();;
		//i = ikForward & 0x80;
		//i += 0x80;//
		//i = ikForward | 0x80;
		//only use arrows in menu
		if (DI_MenuBufStarted == TRUE){
			if (diKeys[DIK_UP]& 0x80){
				buttonpoll[ di_north ] = TRUE;
				//scancodes
				LastScan = sc_UpArrow;
				Keyboard[sc_UpArrow] = 1;
				diKeys[DIK_NUMPAD8]=128;
			}
			if (diKeys[DIK_DOWN]& 0x80){
				buttonpoll[ di_south ] = TRUE;
				LastScan = sc_DownArrow;
				Keyboard[sc_DownArrow] = 1;
				diKeys[DIK_NUMPAD2]=128;
			}
		}else{
			if ((diKeys[buttonscan[20]]& 0x80)||(diKeys[buttonscan[20]|0x80]& 0x80)) {//DIK_UP 45=X A=30   80-45=35  65-30=35
				buttonpoll[ di_north ] = TRUE;
				//scancodes
				LastScan = sc_UpArrow;
				Keyboard[sc_UpArrow] = 1;
				diKeys[DIK_NUMPAD8]=128;
			}
			if ((diKeys[buttonscan[22]]& 0x80)||(diKeys[buttonscan[22]|0x80]& 0x80)) {
				buttonpoll[ di_south ] = TRUE;
				LastScan = sc_DownArrow;
				Keyboard[sc_DownArrow] = 1;
				diKeys[DIK_NUMPAD2]=128;
			}
		}

		if ((diKeys[buttonscan[23]]& 0x80)||(diKeys[buttonscan[23]|0x80]& 0x80)) {//DIK_LEFT
			buttonpoll[ di_west ] = TRUE;
			diKeys[DIK_NUMPAD4]=128;
		}
		if ((diKeys[buttonscan[21]]& 0x80)||(diKeys[buttonscan[21]|0x80]& 0x80)) {//DIK_RIGHT
			buttonpoll[ di_east ] = TRUE;
			diKeys[DIK_NUMPAD6]=128;
		}
		if (diKeys[ DIK_RCONTROL] & 0x80) {//DIK_LCONTROL
			diKeys[ DIK_LCONTROL] = diKeys[ DIK_RCONTROL];
			diKeys[ DIK_RCONTROL] = 0;
			//buttonpoll[ bt_attack ] = TRUE;
		} 
		if ((diKeys[buttonscan[0]]& 0x80)||(diKeys[buttonscan[0]|0x80]& 0x80)) {//DIK_LCONTROL
			buttonpoll[ bt_attack ] = TRUE;
		}

		/*
char order[ 21 ] = {
   di_west, di_east, di_north, di_south, bt_run, bt_use, bt_attack,
   bt_strafe, bt_strafeleft, bt_straferight, bt_lookup, bt_lookdown,
   bt_aimbutton, bt_horizonup, bt_horizondown, bt_swapweapon, bt_dropweapon,
   bt_turnaround, bt_autorun, bt_message, bt_directmsg
   };*/
		if ((diKeys[buttonscan[3]]& 0x80)||(diKeys[buttonscan[3]|0x80]& 0x80)) {
		//if (diKeys[ikUse] & 0x80) {
			buttonpoll[ bt_use ] = TRUE;
			LastScan = sc_Space;
		}
		//if ((diKeys[buttonscan[2]]& 0x80)||(diKeys[buttonscan[2]|0x80]& 0x80)) {
		if (diKeys[DIK_LSHIFT ] & 0x80) {
			buttonpoll[ bt_run ] = TRUE;
		}	
		//if ((diKeys[buttonscan[2]]& 0x80)||(diKeys[buttonscan[2]|0x80]& 0x80)) {
		if (diKeys[DIK_RSHIFT ] & 0x80) {
			buttonpoll[ bt_run ] = TRUE;
		}
		if ((diKeys[buttonscan[24]]& 0x80)||(diKeys[buttonscan[24]|0x80]& 0x80)) {
		//if (diKeys[DIK_TAB ] & 0x80) {
			buttonpoll[ bt_map ] = TRUE;
		}		
		if ((diKeys[buttonscan[18]]& 0x80)||(diKeys[buttonscan[18]|0x80]& 0x80)) {
		//if (diKeys[DIK_BACK] & 0x80) {
			buttonpoll[ bt_turnaround ] = TRUE;
		}	
		if ((diKeys[buttonscan[4]]& 0x80)||(diKeys[buttonscan[4]|0x80]& 0x80)) {
		//if (diKeys[DIK_PRIOR ] & 0x80) {
			buttonpoll[ bt_lookup ] = TRUE;
		}
		if ((diKeys[buttonscan[5]]& 0x80)||(diKeys[buttonscan[5]|0x80]& 0x80)) {
		//if (diKeys[DIK_NEXT  ] & 0x80) {
			buttonpoll[ bt_lookdown ] = TRUE;
		}

		if ((diKeys[buttonscan[16]]& 0x80)||(diKeys[buttonscan[16]|0x80]& 0x80)) {
		//if (diKeys[DIK_COMMA] & 0x80) {
			buttonpoll[ bt_strafeleft ] = TRUE;
		}
		if ((diKeys[buttonscan[17]]& 0x80)||(diKeys[buttonscan[17]|0x80]& 0x80)) {
		//if (diKeys[DIK_PERIOD] & 0x80) {
			buttonpoll[ bt_straferight ] = TRUE;
		}


		if (((diKeys[DIK_LMENU]&0x80)||(diKeys[DIK_RMENU]&0x80))&&(diKeys[DIK_LEFT]&0x80)) {//Alt+left
			buttonpoll[ bt_strafeleft ] = TRUE;
			buttonpoll[ di_west ] = FALSE;
		}
		if (((diKeys[DIK_LMENU]&0x80)||(diKeys[DIK_RMENU]&0x80))&&(diKeys[DIK_RIGHT]&0x80)) {//Alt+right
			buttonpoll[ bt_straferight ] = TRUE;
			buttonpoll[ di_east ] = FALSE;
		}

		if ((diKeys[buttonscan[10]]& 0x80)||(diKeys[buttonscan[10]|0x80]& 0x80)) {
		//if (diKeys[DIK_1 ] & 0x80) {
			buttonpoll[ bt_pistol ] = TRUE;
		}		
		if ((diKeys[buttonscan[11]]& 0x80)||(diKeys[buttonscan[11]|0x80]& 0x80)) {
		//if (diKeys[DIK_2] & 0x80) {
			buttonpoll[ bt_dualpistol ] = TRUE;
		}	
		if ((diKeys[buttonscan[12]]& 0x80)||(diKeys[buttonscan[12]|0x80]& 0x80)) {
		//if (diKeys[DIK_3 ] & 0x80) {
			buttonpoll[ bt_mp40 ] = TRUE;
		}
		if ((diKeys[buttonscan[13]]& 0x80)||(diKeys[buttonscan[13]|0x80]& 0x80)) {
		//if (diKeys[DIK_4  ] & 0x80) {
			buttonpoll[ bt_missileweapon ] = TRUE;
		}


		if ((diKeys[buttonscan[8]]& 0x80)||(diKeys[buttonscan[8]|0x80]& 0x80)) {
		//if (diKeys[DIK_HOME ] & 0x80) {
			buttonpoll[ bt_horizonup ] = TRUE;
		}
		if ((diKeys[buttonscan[9]]& 0x80)||(diKeys[buttonscan[9]|0x80]& 0x80)) {
		//if (diKeys[DIK_END  ] & 0x80) {
			buttonpoll[ bt_horizondown ] = TRUE;
		}
		if ((diKeys[buttonscan[7]]& 0x80)||(diKeys[buttonscan[7]|0x80]& 0x80)) {
		//if (diKeys[DIK_DELETE] & 0x80) {
			buttonpoll[ bt_dropweapon ] = TRUE;
		}
		if ((diKeys[buttonscan[6]]& 0x80)||(diKeys[buttonscan[6]|0x80]& 0x80)) {
		//if (diKeys[DIK_NUMPADENTER] & 0x80) {
			buttonpoll[ bt_swapweapon ] = TRUE;
		}

		if (diKeys[DIK_PAUSE ] & 0x80) {
			PausePressed = true;
		}
		if (diKeys[DIK_SCROLL] & 0x80) {
			//PanicPressed = true;
		}


		for (i=0;i<255;i++){
			if (LastScan == 0){
				if (diKeys[i] & 0x80){
					LastScan = i;
				}
			}
			KeyboardQueue[i] = diKeys[i];
		}
		if (diKeys[DIK_A] & 0x80) {
			//PanicPressed = true;
		}
		//QueueLetterInput();
  }
  return LastScan;
} // PollKeyboard()

//---------------------------------------------------------------------------------------
 void DI_GetLastdiKeys ()
 {  int i;
	for (i=0;i<255;i++){
		KeyboardQueue[i] = diKeys[i];
	}
 }


//---------------------------------------------------------------------------------------
BOOL CALLBACK DIEnumDevicesProc(LPCDIDEVICEINSTANCE lpddi,LPVOID pvRef)
{
    if (GET_DIDEVICE_TYPE(lpddi->dwDevType) == DIDEVTYPE_MOUSE)
      {
      MouseGUID = lpddi->guidProduct;   
      MouseFound = TRUE;
      }
    if (GET_DIDEVICE_TYPE(lpddi->dwDevType) == DIDEVTYPE_KEYBOARD)
      {  
      KeyboardGUID = lpddi->guidProduct;   
      KeyboardFound = TRUE;
      }
    if (MouseFound)
      return DIENUM_STOP;
    else
      return DIENUM_CONTINUE;  
} 




#endif




