

/*

#include "3DSound.h"


DIRECTX_APP *DirectXApp;


extern "C" {

	BOOL Init3Dsound();

}



BOOL Init3Dsound()
{

	    // Initialize COM
    CoInitialize(NULL);
    DirectXApp = new DIRECTX_APP();
	// Initialize DirectDraw 
    if( SUCCEEDED( DirectXApp->InitApp( ) ) )
	{ }

	return TRUE;
}


// Just to nullify your Objects 
DIRECTX_APP::DIRECTX_APP()
{
	m_hWnd         = NULL;
    m_lpDD         = NULL;
    m_lpDDSPrimary = NULL;
    m_lpDDSBack    = NULL;
	m_lpFI_Surf    = NULL;
	m_MousePtr.Surf= NULL;
		
	m_pLoader      = NULL;
    m_pPerformance = NULL;
    m_pSegment     = NULL;
	m_pDSB         = NULL;
	m_p3DAudioPath = NULL;

	m_Running      = TRUE;  
}

HRESULT DIRECTX_APP::InitApp()
{


    HRESULT hr;  
	if( FAILED( hr = Init3DMusic() ) )
		return hr;

	return S_OK;
}



HRESULT DIRECTX_APP::Init3DMusic()
{

    // Create loader object 
    CoCreateInstance( CLSID_DirectMusicLoader, NULL, CLSCTX_INPROC, 
                      IID_IDirectMusicLoader8, (void**)&m_pLoader );

    // Create performance object
    CoCreateInstance( CLSID_DirectMusicPerformance, NULL, CLSCTX_INPROC, 
                      IID_IDirectMusicPerformance8, (void**)&m_pPerformance );

    // Initialize the performance with the standard audio path.This initializes both DirectMusic
	// and DirectSound and sets up the synthesizer. 
    m_pPerformance->InitAudio( NULL, NULL, NULL, 
                               DMUS_APATH_DYNAMIC_STEREO, 64,
                               DMUS_AUDIOF_ALL, NULL );

    if( FAILED( m_pLoader->LoadObjectFromFile( CLSID_DirectMusicSegment,
                                               IID_IDirectMusicSegment8,
											   L"c:\\WinRott_2.24_GL\\sfx\\252.E_THUND2.wav",
                                               (LPVOID*) &m_pSegment ) ) )
    {
        MessageBox( NULL, "BkGnd.Mid not found,  Program will now quit", 
                          "BkGnd Music", MB_OK );
		m_pPerformance->CloseDown();
        m_pLoader->Release(); 
        m_pPerformance->Release();
        return 0;
    }

	// Download the segment's instruments to the synthesizer 
    m_pSegment->Download( m_pPerformance );

    // Tell DirectMusic to repeat this segment forever 
    m_pSegment->SetRepeats( DMUS_SEG_REPEAT_INFINITE );
	
    // Create an 3D audiopath with a 3d buffer. We can then play all segments into this buffer 
	// and directly control its 3D parameters.     
    m_pPerformance->CreateStandardAudioPath( DMUS_APATH_DYNAMIC_3D, 
                                             64, TRUE, &m_p3DAudioPath );

    // Play segment on the 3D audiopath 
    m_pPerformance->PlaySegmentEx( m_pSegment, NULL, NULL, 0, 
                                   0, NULL, NULL, m_p3DAudioPath );

    // Get the IDirectSound3DBuffer8 from the 3D audiopath    
    m_p3DAudioPath->GetObjectInPath( DMUS_PCHANNEL_ALL, DMUS_PATH_BUFFER, 0, 
                                 GUID_NULL, 0, IID_IDirectSound3DBuffer, 
                                 (LPVOID*) &m_pDSB );

	  // Set the position of sound according to MouseCursor 
	m_pDSB->SetPosition( 0.0f,0.0f, 0.0f, DS3D_IMMEDIATE );
m_pDSB->SetConeOrientation( 1, 1, 1, DS3D_IMMEDIATE);
m_pDSB->SetConeAngles (DS3D_MINCONEANGLE, 100, DS3D_IMMEDIATE);
m_pDSB->SetConeOutsideVolume (-100, DS3D_IMMEDIATE);
m_pDSB->SetMode(DS3DMODE_NORMAL,DS3D_IMMEDIATE);

      //  DSEFFECTDESC dsed = { sizeof(DSEFFECTDESC) };
     //   dsed.guidDSFXClass
/*
LPCDS3DBUFFER dsed;
dsed->guidDSFXClass = GUID_DSFX_STANDARD_I3DL2REVERB;

m_pDSB->SetAllParameters(dsed
,DS3D_IMMEDIATE);

DSFX_STANDARD_CHORUS
DSFX_STANDARD_COMPRESSOR
DSFX_STANDARD_DISTORTION
DSFX_STANDARD_ECHO
DSFX_STANDARD_FLANGER
DSFX_STANDARD_GARGLE
DSFX_STANDARD_I3DL2REVERB
DSFX_STANDARD_PARAMEQ
DSFX_STANDARD_WAVES_REVERB

DSFX_STANDARD_ECHO
GUID_DSFX_STANDARD_I3DL2REVERB
*/
/*
	return S_OK;
}

VOID DIRECTX_APP::Destroy3DMusic()
{
	
	m_pPerformance->Stop( NULL, NULL, 0, 0 );
    m_pDSB->Release();
    m_p3DAudioPath->Release();
  
    m_pLoader->Release(); 
	m_pSegment->Release();
    
    // Close down DirectMusic after releasing the DirectSound buffers
    m_pPerformance->CloseDown();
    m_pPerformance->Release();

}


    


void DIRECTX_APP::DestroyDirectDraw()
{	
	SAFE_RELEASE(m_lpDDSBack);
	SAFE_RELEASE(m_lpDDSPrimary);
	SAFE_RELEASE(m_lpDD);
}	  

void DIRECTX_APP::DestroyApp()
{	
	SAFE_RELEASE(m_lpFI_Surf);
	DestroyDirectDraw();
}
*/


