


#include <ddraw.h>//For 2D Animations......
#include <dmusici.h>

/* Including the libraries programmatically */
#pragma comment(lib,"ddraw.lib") 
#pragma comment(lib,"dxguid.lib") 

//LRESULT WINAPI WndProc( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam );

#define SAFE_RELEASE(x)  { if(x) {x->Release(); x = NULL;} }

#define ATTEMPT(Check,Text,Caption)  { if(!Check) { MessageBox(NULL,Text,Caption,MB_OK); DestroyApp(); _exit(-1);} }

typedef struct SPRITE
{  
  LPDIRECTDRAWSURFACE7  Surf;
  int nFrames;
  int iCurFrame;
  int MaxFrameDelay;
  int CurFrameDelay;
  int Width, Height;
}SPRITE;

/* Global variables */
class DIRECTX_APP
{
public:
	HWND                    m_hWnd;
	LPDIRECTDRAW7           m_lpDD;
	LPDIRECTDRAWSURFACE7    m_lpDDSPrimary;
	LPDIRECTDRAWSURFACE7    m_lpDDSBack;
	LPDIRECTDRAWSURFACE7    m_lpFI_Surf, m_lpMousePtr_Surf;

	BOOL m_Running;
	
	/* Point Structure to store Cursor coordinates */
	POINT m_CursorPoint;  		
    SPRITE m_MousePtr;

	/* Sound Objects */
	IDirectMusicLoader8*      m_pLoader      ;
	IDirectMusicPerformance8* m_pPerformance ;
	IDirectMusicSegment8*     m_pSegment     ;	
	IDirectMusicAudioPath8*   m_p3DAudioPath ;
	IDirectSound3DBuffer8*    m_pDSB ;
	

	DIRECTX_APP();
	~DIRECTX_APP();

	HRESULT InitApp();
	HRESULT InitDirectDraw();
	HRESULT Init3DMusic();
	LPDIRECTDRAWSURFACE7 CreateBmpSurface(LPCTSTR file_name);
	VOID SetSprite(SPRITE * Sprite,LPDIRECTDRAWSURFACE7 lpSurf, int nFrames,int MaxFrameDelay,int Width, int Height );	
	VOID DrawSprite( SPRITE *Sprite,int PosX,int PosY );
	VOID DrawWorld();
	HRESULT ClearBackBuffer( DWORD dwColor );
	DWORD ConvertGDIColor( COLORREF dwGDIColor );		
	VOID Destroy3DMusic();
	VOID DestroyDirectDraw();
	VOID DestroyApp();
};




