 
/******************************************************************************
 DirectMusic.cpp 

 Copyright  2004,2005,2006  Birger N. Andreasen 
 Please send any bugreports, comments and other issues to:
 E-Mail = bna@post10.tele.dk
 Homepage with other ROTT stuff = http://www.riseofthetriad.dk/

 ******************************************************************************/
#include "develop.h"
#include "resource.h"
 
#if (USEDIRECTMUSIC == 1)

#define INITGUID

#include <windows.h>
#include <windowsx.h>
#include <string> 
//objbase.h for info.
#include <wtypes.h>
#include <objbase.h>
#include <unknwn.h>
//#include <comdef.h>
// required DirectMusic includes
#include <dmksctrl.h>
#include <dmusici.h>
#include <dmusicc.h>
#include <dmusicf.h>
#include <shlobj.h>
// ----------- DEFINES --------------------------------------------------------
#define MULTI_TO_WIDE( x,y )  MultiByteToWideChar( CP_ACP,MB_PRECOMPOSED, y,-1,x,_MAX_PATH);
#define boolean BOOL
#define bool BOOL

// ----------- PROTOTYPES -----------------------------------------------------
extern "C" {
	extern long LoadResourceToFixedMem (LPSTR Type ,int sndnb, void **bufferptr);

    extern int MP3SetVolume(long lVolume);
    extern int iUseMp3Music;
	extern int iUseDB50XGfix;
	bool InitDirectMusic (void);
	LRESULT CALLBACK SSoundDrvWndProc(HWND hWnd, UINT msg,WPARAM wParam, LPARAM lParam);
	LRESULT CALLBACK SMP3WndProc(HWND hWnd, UINT msg,WPARAM wParam, LPARAM lParam);    
	HINSTANCE	hInst;
    extern HWND hMainWnd;
	extern int	musfix;
	void ErrorBoxD(LPSTR lpszErrorStr, HRESULT hr);
	bool LoadMIDI (char *filename);
	void PlaySegment (void);
	void ShutdownDirectMusic (void);
	bool LoadMIDIfile (char *filename,unsigned char *song, int size);
	bool IsMidiPlaying (void);
	void StopMidiMusic (void);
	void StartMidiMusic (boolean Loop);
	int  Midi_StoreSongPosition (void);
	void Midi_RestoreSongPosition (int);
	bool SetMasterVol (long lvol);
	//BOOL EnumPorts();
	BOOL EnumPortsPrv(char *DriverName, DWORD Flags);
	HRESULT SendCurveMsg();
	//BOOL IsGMSupported() ;
	BOOL IsGMSupported(IDirectMusicPort* lpPort) ;
    int PlayROTTMidiFile(char *songname, boolean loop,unsigned char *song, int size);
	
//	extern DD_ShutdownDirectDraw(void);
	extern void ErrorDontQuit (char *error, int i,...);
	extern int MUvolume;
	extern void ExitWinRott();
	extern long GetSetVolumeMidi (long newvol, int SetGetFLAG); // 0 = get  1 = set
	extern int GetStrFromRegdb (LPSTR Keyval, LPSTR strval, LPSTR defaultval) ;
	extern BOOL SetStrInRegdb  (LPSTR Keyval, LPSTR strval, LPSTR defaultval)  ;
	extern BOOL InitDirectSound();
	extern char Mp3Path[256];


}
//extern void Play3Dstart();
//extern int Init3D();
extern void ErrorBoxD(LPSTR lpszErrorStr, HRESULT hr);
	BOOL SelectFolderName(HWND hDlg);

// ----------- GLOBALS --------------------------------------------------------
							
IDirectMusicPerformance *Prfm = NULL;	
IDirectMusicSegment		*Seg;		
IDirectMusicLoader		*Ldr;	

long MidiLength		= 0;
long glVol			= 0;
MUSIC_TIME pmtNow	= 0;

IDirectMusic* gpDirectMusic = NULL;
IDirectMusicPort* pPort		= NULL;
IDirectMusicPort* xPort		= NULL;

HWND sndLB;
char g_snddrivername[128];

extern float g_fReverbMix;
extern float g_fReverbTime;
extern float g_fHighFreqRTRatio;

// include the 2 classes for DirectX Audio and 3D Sounds
#include "..\DirectSound3D\CDXAudio.h"
#include "..\DirectSound3D\C3DSound.h"




//----------------------------------------------------------------------------------------
bool InitDirectMusic (void)
{
	HRESULT hr;
	char tmp[512];
	int i;
	IDirectMusicPort* pPort = NULL;
	DMUS_PORTPARAMS dmos;
	DMUS_PORTCAPS dmpc;
	GUID guidSynthGUID;

	hr = CoInitialize (NULL);

//Init3D();

	GetStrFromRegdb ((LPSTR)"g_fReverbMix",(LPSTR)&tmp,(LPSTR)"");
	if (tmp[0] != 0)
		g_fReverbMix = (float)atof(tmp);


	GetStrFromRegdb ((LPSTR)"g_fReverbTime",(LPSTR)&tmp,(LPSTR)"");
	if (tmp[0] != 0)
		g_fReverbTime = (float)atof(tmp);


	GetStrFromRegdb ((LPSTR)"g_fHighFreqRTRatio",(LPSTR)&tmp,(LPSTR)"");
	if (tmp[0] != 0)
		g_fHighFreqRTRatio = (float)atof(tmp);


	//get ealier selected driver , if any
	GetStrFromRegdb ("Sounddriver",g_snddrivername,"Microsoft Synthesizer");
	if (g_snddrivername[0] == 0)
		lstrcpy(g_snddrivername,"Microsoft Synthesizer");

	
	if (FAILED(CoCreateInstance(
			(REFCLSID)CLSID_DirectMusicPerformance, 
			NULL, 
			CLSCTX_INPROC, 
			(REFIID)IID_IDirectMusicPerformance, 
			(LPVOID *)&Prfm))) 
									 
	{
	  	//ErrorBoxD("Could not create CLSID_DirectMusicPerformance object.\n", 0);
		return false;
	}

/*
	hr = Prfm->Init (NULL,NULL,main_hwnd);
	if (hr != S_OK){
	  	//ErrorBoxD("Could not create Performance object.\n", 0);
		return false;
	}
*/
    if( !SUCCEEDED(Prfm->Init(&gpDirectMusic,NULL, hMainWnd))) {
        return false;
    }
 
	if (EnumPortsPrv(g_snddrivername,-1) == FALSE){
//	if (EnumPorts("Microsoft Synthesizer",3717) == FALSE){//try to find Microsoft Synthesizer port
		//get default port
		if ( !SUCCEEDED(gpDirectMusic->GetDefaultPort(&guidSynthGUID)))	{
			return false;;
		}
 		ZeroMemory(&dmos, sizeof(dmos));
		dmos.dwSize = sizeof(DMUS_PORTPARAMS);
		dmos.dwChannelGroups = 1;
		dmos.dwValidParams = DMUS_PORTPARAMS_CHANNELGROUPS;		 
		if( !SUCCEEDED(gpDirectMusic->CreatePort(guidSynthGUID,&dmos,&pPort,NULL)))	{
			return false;;
		}		 

	}

	if (pPort==NULL){
		if (xPort==NULL){
			pPort->Release();
			return false;
		}
		pPort = xPort;
	}
	//test port
	ZeroMemory(&dmpc, sizeof(dmpc));
	dmpc.dwSize = sizeof(DMUS_PORTCAPS);	
	if( !SUCCEEDED(pPort->GetCaps(&dmpc))){
		if (pPort) pPort->Release();
		return false;;
	}

	//write out the used port
	ErrorDontQuit("",0);
	ErrorDontQuit("Description for used port ",0);
	ErrorDontQuit("dmpc.dwClass=",dmpc.dwClass);
	ErrorDontQuit("dmpc.dwEffectFlags=",dmpc.dwEffectFlags);
	ErrorDontQuit("dmpc.dwFlags=",dmpc.dwFlags);
	ErrorDontQuit("dmpc.dwMaxAudioChannels=",dmpc.dwMaxAudioChannels);
	ErrorDontQuit("dmpc.dwMaxChannelGroups=",dmpc.dwMaxChannelGroups);
	ErrorDontQuit("dmpc.dwMaxVoices=",dmpc.dwMaxVoices);
	ErrorDontQuit("dmpc.dwMemorySize=",dmpc.dwMemorySize);
	ErrorDontQuit("dmpc.dwSize=",dmpc.dwSize);
	ErrorDontQuit("dmpc.dwType=",dmpc.dwType);
	for (i=0;i<128;i++){
		tmp[i]=(char)dmpc.wszDescription[i];
	}
	ErrorDontQuit(tmp,0);
	ErrorDontQuit("---------------------------------------------------",0);

	pPort->Activate(TRUE);
	Prfm->AddPort(pPort);
	//The next call maps PChannels 0-15 to the first group of MIDI channels on the port. 
	//Note that this step is necessary because the application did not pass NULL to AddPort.

	Prfm->AssignPChannelBlock(0, pPort, 1);
	//The original reference to the port can now be released. 
	//This call does not remove the port from the performance.

	//Prfm->SetPrepareTime(1);//dwMilliSeconds

	if (pPort) pPort->Release();

	xPort = pPort;

	return true;
}

//----------------------------------------------------------------------------------------
void ShutdownDirectMusic (void)
{

	if (NULL != Seg) {
		Seg->SetParam ((REFGUID)GUID_Unload,-1,0,0,(LPVOID *)Prfm);
		Seg->Release ();
		Seg = NULL;
	}

	if (NULL != Ldr)	{
		Ldr->Release ();
		Ldr = NULL;
	}

	if (NULL != Prfm)	{
		Prfm->CloseDown ();
		Prfm->Release ();
		Prfm = NULL;
	}
	//CoUninitialize ();
}

//----------------------------------------------------------------------------------------
bool LoadMIDIfile (char *filename,unsigned char *song, int size)
{
	DMUS_OBJECTDESC obj_desc;
	HRESULT hr;		
//	char directory[_MAX_PATH];	
//	WCHAR w_directory[_MAX_PATH];
//	WCHAR w_filename[_MAX_PATH];

	if (NULL != Seg) {
		Seg->SetParam ((REFGUID)GUID_Unload,-1,0,0,(LPVOID *)Prfm);
		Seg->Release ();
		Seg = NULL; 
	}
	if (NULL != Ldr)	{
		Ldr->Release ();
		Ldr = NULL;
	}


	if (FAILED(CoCreateInstance ((REFCLSID)CLSID_DirectMusicLoader,
								  NULL,
								  CLSCTX_INPROC,
								  (REFIID)IID_IDirectMusicLoader,
								  (LPVOID *)&Ldr)))
	{
	  	ErrorBoxD("Could not create CLSID_DirectMusicLoader.(music error)\n", 0);
		return false;
	}
/*
	if (0 == GetCurrentDirectory (_MAX_PATH,directory))	{
	  	ErrorBoxD("Could not get GetCurrentDirectory.(music error)\n", 0);
		return false;
	}

	MULTI_TO_WIDE(w_directory,directory);
	hr = Ldr->SetSearchDirectory ((REFGUID)GUID_DirectMusicAllTypes, w_directory, FALSE);
	if (hr != S_OK){
        //DD_ShutdownDirectDraw();
	  	ErrorBoxD("Could not SetSearchDirectory.(music error)\n", 0);
		return false;
	}
*/



	ZeroMemory (&obj_desc, sizeof (obj_desc));
	obj_desc.dwSize = sizeof (obj_desc);
//	MULTI_TO_WIDE(w_filename,filename);
	obj_desc.guidClass = CLSID_DirectMusicSegment;
/*	wcscpy (obj_desc.wszFileName,w_filename);
	obj_desc.dwValidData = DMUS_OBJ_CLASS | DMUS_OBJ_FILENAME;

	hr = Ldr->GetObject (&obj_desc,
							(REFIID)IID_IDirectMusicSegment,
							(LPVOID *) &Seg);

    ObjDesc.dwSize = sizeof(DMUS_OBJECTDESC);
    ObjDesc.guidClass = CLSID_DirectMusicSegment;
    ObjDesc.dwValidData = DMUS_OBJ_CLASS | DMUS_OBJ_MEMORY; */
	obj_desc.dwValidData = DMUS_OBJ_CLASS | DMUS_OBJ_MEMORY;
    obj_desc.pbMemData = (BYTE *) song;
    obj_desc.llMemLength = size;
 
    hr = Ldr->GetObject(
            &obj_desc, IID_IDirectMusicSegment2, 
            (void**) &Seg );


	if (hr != S_OK){
	  	ErrorBoxD("Could not Ldr->GetObject.(music error)\n", 0);
		return false;
	}

	hr = Seg->SetParam ((REFGUID)GUID_StandardMIDIFile,-1,0,0,(LPVOID)Prfm);
	if (hr != S_OK){
	  	ErrorBoxD("Could not Seg->SetParam.(music error)\n", 0);
		return false;
	}

	hr = Seg->SetParam ((REFGUID)GUID_Download,-1,0,0,(LPVOID)Prfm);
	if (hr != S_OK){
	  	ErrorBoxD("Could not GUID_Download.(music error)\n", 0);
		return false;
	}

	hr = Seg->GetLength (&MidiLength);
	if (hr != S_OK){
	  	ErrorBoxD("Could not GetLength.(music error)\n", 0);
		return false;
	}





	return true;
}


extern "C"{
	extern void  SetTextMode ( void );
	extern BOOL  SetMasterVolSimple(long volume); 
	extern int iUseSimpleSound;
}


//----------------------------------------------------------------------------------------
void StartMidiMusic (boolean Loop)
{
	HRESULT hr;//SetTextMode();
	if (Seg == NULL){return;}

	if (Loop == TRUE){
		hr= Seg->SetRepeats(100000);//if this loops 100000 times, go to bed
		if (hr != S_OK){
	  		ErrorBoxD("Could not SetRepeats.(music error)\n", 0);
		}
	}else{
		hr= Seg->SetRepeats(0);
		if (hr != S_OK){
	  		ErrorBoxD("Could not SetRepeats.(music error)\n", 0);
		}
	}



	hr = Prfm->PlaySegment (Seg,0,0,NULL);
	if (hr != S_OK){
	  	ErrorBoxD("Could not PlaySegment.(music error)\n", 0);
	}
}

//----------------------------------------------------------------------------------------
void StopMidiMusic (void)
{
	HRESULT hr;
	if (Prfm == NULL){return;}
	if (Seg == NULL){
        return ;
    }
	hr = Prfm->Stop (0,NULL,0,0); 
	if (hr != S_OK){
	  	ErrorBoxD("Could not Prfm->Stop.(music error)\n", 0);
	}
		
	//Seg->SetParam ((REFGUID)GUID_Unload,-1,0,0,(LPVOID *)Prfm);

}

/*
//----------------------------------------------------------------------------------------
HRESULT LoadMidi(HMODULE hMod, WORD ResourceID)
{
    HRESULT              hr;
    DMUS_OBJECTDESC      ObjDesc;
    IDirectMusicSegment* pSegment = NULL; 
 
    HRSRC hFound = FindResource(hMod, 
            MAKEINTRESOURCE(ResourceID), RT_RCDATA);
    HGLOBAL hRes = LoadResource(hMod, hFound);
 
    ObjDesc.dwSize = sizeof(DMUS_OBJECTDESC);
    ObjDesc.guidClass = CLSID_DirectMusicSegment;
    ObjDesc.dwValidData = DMUS_OBJ_CLASS | DMUS_OBJ_MEMORY;
    ObjDesc.pbMemData = (BYTE *) LockResource(hRes);
    ObjDesc.llMemLength = SizeofResource(hMod, hFound);
 
    hr = m_pDXPerformance->m_pLoader->GetObject(
            &ObjDesc, IID_IDirectMusicSegment2, 
            (void**) &m_pSegment );
 
    return hr;
}
*/

//----------------------------------------------------------------------------------------
bool IsMidiPlaying (void)
{
	HRESULT hr;
	if (Prfm == NULL){return FALSE;}
	if (Seg == NULL){
        return FALSE;
    }
	hr = Prfm->IsPlaying (Seg,NULL);
	if (hr == S_OK)
		return TRUE;
	return FALSE;
}
//----------------------------------------------------------------------------------------
bool SetMasterVol (long lvol) //0 -> 254
{
	HRESULT hr;
	DMUS_WAVES_REVERB_PARAMS Params;
	IKsControl *pControl;


	if (iUseSimpleSound == 1){//our sound do not work, try simple snd
		SetMasterVolSimple (lvol);
		return 1;
	}




	if (iUseMp3Music == 1){
		MP3SetVolume(lvol);
		return 1;
	}


	if ((Prfm == NULL)||(xPort == NULL)){return FALSE;}
/*	if (Seg == NULL){
        return FALSE;
    }*/
//GetSetVolumeMidi(1,1);return 0;
	Params.fInGain          = (float)(((31-(lvol/8))*-1)/1.4);;
	Params.fReverbMix       = g_fReverbMix;//-10;
	Params.fReverbTime      = g_fReverbTime;//1000;
	Params.fHighFreqRTRatio = (float)g_fHighFreqRTRatio;//0.001;



	// Query for IKsControl interface
	hr = xPort->QueryInterface(IID_IKsControl,(void**)&pControl);
	if (SUCCEEDED(hr)) {
		KSPROPERTY ksp;
		ULONG cb;
		 
		ZeroMemory(&ksp, sizeof(ksp));
		ksp.Set   = GUID_DMUS_PROP_WavesReverb;
		ksp.Id    = 0;
		ksp.Flags = KSPROPERTY_TYPE_SET;
		 
		pControl->KsProperty(&ksp, sizeof(ksp),
			(LPVOID)&Params, sizeof(Params), &cb);
		pControl->Release();
	}

	return TRUE;
}
//----------------------------------------------------------------------------------------
int Midi_StoreSongPosition (void)
{
	HRESULT hr;
	if (Prfm == NULL){return 0;}
	if (Seg == NULL){
        return 0;
    }
	hr = Prfm->GetTime(NULL, &pmtNow);
	if (hr != S_OK)
		pmtNow = 0;
//ErrorDontQuit("storedpos=",pmtNow);
//	Seg->Clone (0,0,&tmpsegment);
	return pmtNow;
}

//----------------------------------------------------------------------------------------
int LastSongPos=0;
void Midi_RestoreSongPosition (int storedpos)
{
	HRESULT hr;
//__int64 i64StartTime = 1500;
//pmtNow= 31325;
//
//ErrorDontQuit("storedpos=",storedpos);


	if (Prfm == NULL){
        return;
    }
	if (Seg == NULL){
        return;
    }

	StopMidiMusic ();
    LastSongPos=0;
//	Seg->GetParam Release ();
//	Seg = NULL;
//	LoadMIDIfile("rottsong.mid");
//	tmpsegment->Clone(0,0,&Seg);
	hr = Seg->SetRepeats(100000);

	LastSongPos += storedpos;
	if (LastSongPos > MidiLength){
        LastSongPos=0;
    }
	hr = Seg->SetStartPoint(LastSongPos);


	hr = Prfm->PlaySegment(Seg,0,0,NULL);
	if (FAILED(hr))	{
	  	ErrorBoxD("Could not PlaySegment.(music error)\n", 0);
	}

	pmtNow = 0;
}



int PlayROTTMidiFile(char *songname, boolean loop,unsigned char *song, int size)
{ 

	if (iUseDB50XGfix == 1){
		byte *midiloadbuffer2 = 0;
		StopMidiMusic ();
		int midisize = LoadResourceToFixedMem ("MID", IDR_MID1,(void**) &midiloadbuffer2);
		LoadMIDIfile("tmpsong.mid",midiloadbuffer2,  midisize);
		StartMidiMusic (0);
	}



	//Play3Dstart();
	//return TRUE;
	// get DirectMusic up and running
	//InitDirectMusic ();
	StopMidiMusic ();
	// load our demo MIDI
	LoadMIDIfile("tmpsong.mid",song,  size);
	//LoadMidiInMem(song,size);
	// now play it
	StartMidiMusic (loop);
       SendCurveMsg();
	return TRUE;

}
/*
HRESULT LoadMidiInMem(unsigned char *song, int size)
{
    HRESULT              hr;
    DMUS_OBJECTDESC      ObjDesc;
    IDirectMusicSegment* pSegment = NULL; 
 /*
    HRSRC hFound = FindResource(hMod, 
            MAKEINTRESOURCE(ResourceID), RT_RCDATA);
    HGLOBAL hRes = LoadResource(hMod, hFound);
 *//*
    ObjDesc.dwSize = sizeof(DMUS_OBJECTDESC);
    ObjDesc.guidClass = CLSID_DirectMusicSegment;
    ObjDesc.dwValidData = DMUS_OBJ_CLASS | DMUS_OBJ_MEMORY;
    ObjDesc.pbMemData = (BYTE *) song;
    ObjDesc.llMemLength = size;
 
    hr = Ldr->GetObject(
            &ObjDesc, IID_IDirectMusicSegment2, 
            (void**) &Seg );

    return hr;
}
*/




//HRESULT SendCurveMsg(IDirectMusicPerformance8* pPerf)
HRESULT SendCurveMsg()
{
  DMUS_CURVE_PMSG *pCurveMsg;
  HRESULT hr;
//DWORD dwPChannel;
//IDirectMusicPort** ppPort;
//DWORD* pdwGroup;  
//DWORD* pdwMChannel;
return 0;
//hr = Prfm->PChannelInfo(dwPChannel,ppPort,pdwGroup,pdwMChannel);
//IsGMSupported();return 0;

  if (NULL == Prfm) return E_INVALIDARG;



  hr = Prfm->AllocPMsg(sizeof(DMUS_CURVE_PMSG), 
      (DMUS_PMSG**) &pCurveMsg);
  if (SUCCEEDED(hr))
  {
	



    ZeroMemory(pCurveMsg, sizeof(DMUS_CURVE_PMSG));
    pCurveMsg->dwSize = sizeof(DMUS_CURVE_PMSG);
 /*
    MUSIC_TIME mtDuration;
    MUSIC_TIME mtOriginalStart;
    MUSIC_TIME mtResetDuration;
    short      nStartValue;
    short      nEndValue;
    short      nResetValue;
    WORD       wMeasure;
    short      nOffset;
    BYTE       bBeat;
    BYTE       bGrid;
    BYTE       bType;
    BYTE       bCurveShape;
    BYTE       bCCData;
    BYTE       bFlags;

 */
    pCurveMsg->nOffset=0;
    pCurveMsg->bBeat=0;
    pCurveMsg->bGrid=0;

	pCurveMsg->wMeasure= 0;
    pCurveMsg->rtTime = 0;
    pCurveMsg->dwFlags =  DMUS_PMSGF_REFTIME//DMUS_PMSGF_DX8 |
                        | DMUS_PMSGF_LOCKTOREFTIME;
    pCurveMsg->dwPChannel =-1;// ( DWORD )xPort;//-1;
    pCurveMsg->dwType = DMUS_PMSGT_CURVE;
    pCurveMsg->dwGroupID = 0xFFFFFFF;
    pCurveMsg->mtDuration =10;
	pCurveMsg->mtResetDuration = 0;
    pCurveMsg->nStartValue = 50;
    pCurveMsg->nEndValue = 50;
    pCurveMsg->nResetValue = 50;
    pCurveMsg->bCurveShape = DMUS_CURVES_LINEAR ;
    pCurveMsg->bCCData = 7;// MIDI channel volume controller

    pCurveMsg->bFlags = DMUS_CURVE_RESET | DMUS_CURVE_START_FROM_CURRENT;
    pCurveMsg->bType = DMUS_CURVET_CCCURVE  ;

//	pCurveMsg->mtOriginalStart = 10;
    hr = Prfm->SendPMsg((DMUS_PMSG*) pCurveMsg);
  }
  return hr; 
}


#include <dmusicc.h>

BOOL IsGMSupported(IDirectMusicPort* lpPort) 
{ /*
    HRESULT     hr; 
    IKsControl  *pControl; 
    KSPROPERTY  ksp; 
    DWORD       dwFlags ; 
    ULONG       cb; 
    BOOL        fIsSupported;
   DMUS_PMSG* pTempo;
 DWORD dwPChannel;
//;
DWORD* pdwGroup=0;  
DWORD* pdwMChannel;
*/
 DMUS_WAVES_REVERB_PARAMS Params;
Params.fInGain      = 0;
Params.fReverbMix      = -10;
Params.fReverbTime      = 1000;
Params.fHighFreqRTRatio   = (float)0.001;
//return 0;

 
IKsControl *pControl;
// Query for IKsControl interface
HRESULT hr = lpPort->QueryInterface(IID_IKsControl,
   (void**)&pControl);
if (SUCCEEDED(hr)) 
{
   KSPROPERTY ksp;
   ULONG cb;
 
   ZeroMemory(&ksp, sizeof(ksp));
   ksp.Set   = GUID_DMUS_PROP_WavesReverb;
   ksp.Id    = 0;
   ksp.Flags = KSPROPERTY_TYPE_SET;
 
   pControl->KsProperty(&ksp, sizeof(ksp),
      (LPVOID)&Params, sizeof(Params), &cb);
   pControl->Release();

}



 /*
if( SUCCEEDED(Prfm->AllocPMsg(
        sizeof(DMUS_PMSG), (DMUS_PMSG**)&pTempo)))
{
    // Queue the tempo event.
    ZeroMemory(pTempo, sizeof(DMUS_PMSG));
    pTempo->dwSize = sizeof(DMUS_PMSG);
//    pTempo->dblTempo = 100;
//	pTempo->dwFlags = DMUS_PMSG_PART;
	//pTempo->dwPChannel = DMUS_PCHANNEL_BROADCAST_PERFORMANCE;
    pTempo->dwFlags = DMUS_PMSGF_REFTIME;
   pTempo->dwType = DMUS_PMSGT_MIDI ;
    Prfm->SendPMsg((DMUS_PMSG*)pTempo);
}


//hr = Prfm->PChannelInfo(11,&pPort,NULL,NULL);
//(LPVOID *)&Prfm)
    // Query for an IKsControl interface.


hr = lpPort->QueryInterface(IID_IKsControl, (void**)&pControl); 
    if (FAILED(hr)) 
    { 
        // Port does not support properties; assume no GM support.
        return FALSE; 
    }
    // Ask about GM. 
    ksp.Set   = GUID_DMUS_PROP_Volume; 
    ksp.Id    = DMUS_VOLUME_MIN; 
//	ksp.Alignment = DMUS_VOLUME_MIN; 
    ksp.Flags = KSPROPERTY_TYPE_SET ;
    hr = pControl->KsProperty(&ksp, sizeof(ksp),(LPVOID)&GUID_DMUS_PROP_Volume, sizeof(GUID_DMUS_PROP_Volume), &cb);

    pControl->Release();
    return fIsSupported;

*/
return 0;
}


BOOL EnumPortsPrv(char *DriverName, DWORD Flags)
{
	IDirectMusicPort* pPort = NULL;
	DMUS_PORTPARAMS dmos;
	DMUS_PORTCAPS dmpc;
	GUID guidSynthGUID;
	HRESULT hr = S_OK;
	char tmp[512];
	int i;
    for (DWORD index = 0; index<100; index++)//check max 100 ports
    {
        ZeroMemory(&dmpc, sizeof(dmpc));
        dmpc.dwSize = sizeof(DMUS_PORTCAPS);

         hr = gpDirectMusic->EnumPort(index, &dmpc);
        if(hr == S_OK)
        {
		    if ( (dmpc.dwClass == DMUS_PC_OUTPUTCLASS) && 
                 (dmpc.dwFlags & DMUS_PC_SOFTWARESYNTH|DMUS_PC_EXTERNAL|DMUS_PC_DLS|DMUS_PC_DIRECTSOUND ) )
            {
                CopyMemory(&guidSynthGUID, &dmpc.guidPort,
                        sizeof(GUID));
 
                ZeroMemory(&dmos, sizeof(dmos));
                dmos.dwSize = sizeof(DMUS_PORTPARAMS);
                dmos.dwChannelGroups = 1;
                dmos.dwValidParams = DMUS_PORTPARAMS_CHANNELGROUPS;
 
                hr = gpDirectMusic->CreatePort(guidSynthGUID, 
                        &dmos, &pPort, NULL);
				ZeroMemory(&dmpc, sizeof(dmpc));

				dmpc.dwSize = sizeof(DMUS_PORTCAPS);
				 
				hr=pPort->GetCaps(&dmpc);

				if (dmpc.dwFlags == Flags){//3717 = Microsoft Synthesizer
					xPort = pPort;
					return TRUE;
				}
				for (i=0;i<128;i++){
					tmp[i]=(char)dmpc.wszDescription[i];
				}

				if (lstrcmpi(DriverName,tmp)==0){
					xPort = pPort;
					return TRUE;
				}
	

				//not usefull port found, release it and try next port
				pPort->Release();

			}
			
        }
    }
	pPort = NULL;
	return FALSE;
}







COLORREF crBACKG; 
HBRUSH   BACKG;  


LRESULT CALLBACK SSoundDrvWndProc(HWND hWnd, UINT msg,WPARAM wParam, LPARAM lParam)
{

    switch(msg) {
		case WM_INITDIALOG:
			{
			IDirectMusicPort* pPort = NULL;
			DMUS_PORTPARAMS dmos;
			DMUS_PORTCAPS dmpc;
			GUID guidSynthGUID;
			HRESULT hr = S_OK;
			char tmp[148];
			int i,nb;
			HBITMAP hButtonPic;
			HGDIOBJ font; 
			//161 = IDB_BITMAP7

			InitDirectSound();
			InitDirectMusic();

			hButtonPic = LoadBitmap(hInst, MAKEINTRESOURCE(161));
			SendMessage((HWND)GetDlgItem(hWnd,1004),BM_SETIMAGE,(WPARAM) IMAGE_BITMAP,(LPARAM) hButtonPic);

			crBACKG = RGB(23,23,23);
			BACKG   = CreateSolidBrush(crBACKG);

			font = GetStockObject(ANSI_FIXED_FONT);
			SendMessage((HWND)GetDlgItem(hWnd,IDCANCEL),WM_SETFONT, (UINT)font, 0L);
			SendMessage((HWND)GetDlgItem(hWnd,IDOK),WM_SETFONT, (UINT)font, 0L);
			SendMessage((HWND)GetDlgItem(hWnd,1003),WM_SETFONT, (UINT)font, 0L);

			ShutdownDirectMusic ();
			sndLB = GetDlgItem(hWnd,1002);//IDC_LIST1=1002

			//get ealier selected driver
			GetStrFromRegdb ("Sounddriver",g_snddrivername,"Microsoft Synthesizer");
			if (g_snddrivername[0] == 0)
				lstrcpy(g_snddrivername,"Microsoft Synthesizer");

			GetStrFromRegdb ("SoundFix",tmp,"0");
			musfix = atol(tmp);
			if (musfix == 1)
				SendDlgItemMessage(hWnd,1004,BM_SETCHECK,1,0);
			else
				SendDlgItemMessage(hWnd,1004,BM_SETCHECK,0,0);

			for (DWORD index = 0; index<100; index++)//check max 100 ports
			{
				ZeroMemory(&dmpc, sizeof(dmpc));
				dmpc.dwSize = sizeof(DMUS_PORTCAPS);
				hr = gpDirectMusic->EnumPort(index, &dmpc);
				if(hr == S_OK)
				{
					if ( (dmpc.dwClass == DMUS_PC_OUTPUTCLASS) && 
						(dmpc.dwFlags & DMUS_PC_SOFTWARESYNTH|DMUS_PC_EXTERNAL|DMUS_PC_DLS|DMUS_PC_DIRECTSOUND ) )
					{
						CopyMemory(&guidSynthGUID, &dmpc.guidPort,
								sizeof(GUID));
		 
						ZeroMemory(&dmos, sizeof(dmos));
						dmos.dwSize = sizeof(DMUS_PORTPARAMS);
						dmos.dwChannelGroups = 1; 
						dmos.dwValidParams = DMUS_PORTPARAMS_CHANNELGROUPS;
		 
						hr = gpDirectMusic->CreatePort(guidSynthGUID, 
								&dmos, &pPort, NULL);
						ZeroMemory(&dmpc, sizeof(dmpc));

						dmpc.dwSize = sizeof(DMUS_PORTCAPS);
						 
						hr=pPort->GetCaps(&dmpc);
						for (i=0;i<128;i++){
							tmp[i]=(char)dmpc.wszDescription[i];
						}
						SendMessage(sndLB,LB_ADDSTRING , 0,(LPARAM)tmp);
						//release it and find next port
						pPort->Release();
					}

				}
			}

			nb = SendMessage(sndLB,LB_GETCOUNT,(WPARAM)0,(LPARAM) 0);
			for (i=0;i<=nb;i++){
				SendMessage(sndLB, LB_GETTEXT,i,(LONG)(LPSTR)tmp);
				if (lstrcmpi(g_snddrivername,tmp)==0){
					SendMessage(sndLB,LB_SETCURSEL,(WPARAM)i, (LPARAM) 0);
					SetWindowText(GetDlgItem(hWnd,1005),g_snddrivername);//IDC_EDIT_SNDDRV

					break;
				}
			}
			pPort = NULL;
			break;
			}
/*
		case WM_CTLCOLORSTATIC:
			{
            // Set foreground and background colors only if this
            // is not an edit control.
           if  ((HWND)lParam == GetDlgItem(hWnd,1004)) {
				RECT rc;
				GetClientRect((HWND)lParam,&rc);
				rc.right = 16;
			   	FillRect((HDC)wParam, &rc,  (HBRUSH) (BACKG));
				SetBkMode((HDC)wParam, TRANSPARENT);
				UnrealizeObject(BACKG);
				return (DWORD)BACKG;
			}
			}
			break;
			*/
		case WM_COMMAND:
			switch (LOWORD(wParam)) 
			{ 
				case 1002://idc_list1
					{
					char tmp[148];
					int x = SendMessage(GetDlgItem(hWnd, 1002),LB_GETCURSEL,0,(LPARAM)0);
					SendMessage(sndLB, LB_GETTEXT,x,(LONG)(LPSTR)tmp);
					SetWindowText(GetDlgItem(hWnd,1005),tmp);//IDC_EDIT_SNDDRV	
					break;
					}
					break;
				case 1004://IDC_CHECK1
					{
					if(IsDlgButtonChecked(hWnd,1004) == BST_CHECKED){
						SetStrInRegdb ("SoundFix","1","0");
						musfix = 1;
					}else{
						SetStrInRegdb ("SoundFix","0","0");
						musfix = 0;
					}
				break;
					}
					break;
				case IDOK:
				case IDCANCEL:
					InitDirectMusic ();
					EndDialog(hWnd, TRUE);          // Exit the dialog
					break;
				case 1003://IDC_SELECT
					{
						char tmp[148];
						int ix;
						ix = SendMessage(sndLB,LB_GETCURSEL,(WPARAM)0, (LPARAM) 0);    
						SendMessage(sndLB, LB_GETTEXT,ix,(LONG)(LPSTR)tmp);
						if (tmp[0] != 0){
							SetStrInRegdb ("Sounddriver",tmp,"");
							lstrcpy(g_snddrivername,tmp);
						}
						InitDirectMusic ();
						EndDialog(hWnd, TRUE);          // Exit the dialog
						break;
					}
					break;
			}
			break;
    }
    return FALSE;
}



void ErrorBoxD(LPSTR lpszErrorStr, HRESULT hr)
{
//	char	szStr[512];
/*
	wsprintf(szStr, lpszErrorStr, hr);

	SetTextMode ();
	MessageBox(NULL, szStr, "Error", MB_OK);
	ExitWinRott();
	exit(0);
	*/
}


/*
LRESULT CALLBACK SMP3WndProc(HWND hWnd, UINT msg,WPARAM wParam, LPARAM lParam)
{

    switch(msg) {
		case WM_INITDIALOG:
			{
			IDirectMusicPort* pPort = NULL;
//			DMUS_PORTPARAMS dmos;
//			DMUS_PORTCAPS dmpc;
			HRESULT hr = S_OK;
//			char tmp[148];
//			int i,nb;
			HBITMAP hButtonPic;
			HGDIOBJ font; 
			//161 = IDB_BITMAP7

			GetStrFromRegdb ((LPSTR)"Mp3Path",(LPSTR)&Mp3Path,(LPSTR)"");
			SetWindowText(GetDlgItem(hWnd,1008),Mp3Path);

			hButtonPic = LoadBitmap(hInst, MAKEINTRESOURCE(161));
			SendMessage((HWND)GetDlgItem(hWnd,1004),BM_SETIMAGE,(WPARAM) IMAGE_BITMAP,(LPARAM) hButtonPic);

			crBACKG = RGB(236,233,216);
			BACKG   = CreateSolidBrush(crBACKG);

			font = GetStockObject(ANSI_FIXED_FONT);
			SendMessage((HWND)GetDlgItem(hWnd,IDCANCEL),WM_SETFONT, (UINT)font, 0L);
			SendMessage((HWND)GetDlgItem(hWnd,IDOK),WM_SETFONT, (UINT)font, 0L);
			SendMessage((HWND)GetDlgItem(hWnd,1003),WM_SETFONT, (UINT)font, 0L);
			break;
			}

		case WM_CTLCOLORSTATIC:
			{

				RECT rc;
				GetClientRect((HWND)lParam,&rc);
				rc.right = 16;
			   	FillRect((HDC)wParam, &rc,  (HBRUSH) (BACKG));
				SetBkMode((HDC)wParam, TRANSPARENT);
				SetTextColor(
					(HDC) wParam,           // handle to DC
					(COLORREF)CreateSolidBrush(RGB(255,255,255))   // text color
					);
				UnrealizeObject(BACKG);
				return (DWORD)BACKG;
			//}
			}
			break;
			
		case WM_COMMAND:
			switch (LOWORD(wParam)) 
			{ 
				case IDOK:
				case IDCANCEL:
					EndDialog(hWnd, TRUE);          // Exit the dialog
					break;
				case 1003://IDC_SELECT
					{
						GetWindowText(GetDlgItem(hWnd,1008),Mp3Path,255);
						SetStrInRegdb ((LPSTR)"Mp3Path",(LPSTR)Mp3Path,(LPSTR)"");
						EndDialog(hWnd, TRUE);          // Exit the dialog
						break;
					}
					break;
				case 1007:
					SelectFolderName(hWnd);
					break;


					
			}
			break;
    }
    return FALSE;
}


/*

BOOL SelectFolderName(HWND hDlg)
{
	BROWSEINFO		bi;         
    LPITEMIDLIST	pidl; 
	char			gPATH[256]="";

	OleInitialize(NULL);

	ZeroMemory(&bi,sizeof(bi));  
	bi.hwndOwner = hDlg;
//    bi.pszDisplayName = s; 
	bi.lpszTitle = "Select folderpath to Mp3 files";  
	bi.pidlRoot = 0;
    bi.ulFlags = BIF_EDITBOX | BIF_RETURNONLYFSDIRS ;//BIF_STATUSTEXT;
    pidl = SHBrowseForFolder(&bi);            
	if (pidl) {
       if (SHGetPathFromIDList(pidl,gPATH)) {
			lstrcat (gPATH,"\\");
			SetWindowText(GetDlgItem(hDlg,1008),gPATH);
            return 1;
	   }
    }   
	

    return 0;



}
*/





#endif