
/******************************************************************************
 				DirectSound.c 
 Copyright  2004,2005,2006,2009  Birger N. Andreasen 
 Please send any bugreports, comments and other issues to:
 E-Mail = bna@post10.tele.dk
 Homepage with other ROTT stuff = http://www.riseofthetriad.dk/
/******************************************************************************/

#include "develop.h"
#pragma warning (disable : 4996)//disable The POSIX name for this item is deprecated
 
#if (USEDIRECTSOUND == 1)

#define DIRECTINPUT_VERSION 0x0800

#include <windows.h>
#include "WinRott.h"
#include <stdio.h>
#include <io.h>
#include "dxerr.h"
#include <dsound.h> 
//#include "dxerr.c"
#include <stdlib.h>
#include "rt_sound.h"

//#define boolean BOOL
char pDataVoc[0xFFFF];

extern byte* HEAP_getheapmem(int size);
extern BOOL  HEAP_freemem(LPVOID lpMem);
extern HANDLE g_hheap;

#undef RELEASE
#define RELEASE(i) if (i != NULL) {i->lpVtbl->Release(i); i = NULL;}

typedef struct 
{ 
	unsigned char Description[20];
	unsigned short DataBlockOffset;
	unsigned short Version;
	unsigned short IDCode;
} VocHeader;

typedef struct
{
   UCHAR       ucBitsPerSample;
   UCHAR       ucChannels;
   USHORT      usFileFormat;
   USHORT      usTimeConstant;
   long        lSamplesPerSeconds;
   long        lTotalLength;
} FILEINFO;


typedef struct tagWAVEFILE
  {
  DWORD           cbSize;                // Size of file
  LPWAVEFORMATEX  pwfxInfo;              // Wave Header
  LPBYTE          pbData;                // Wave Bits
  int length;
  char name[12];

  }
WAVEFILE, *LPWAVEFILE;

typedef struct tagWAVEFILEEXT
  {
  DWORD           cbSize;                // Size of file
  WAVEFORMATEX    pwfxInfo;              // Wave Header
  LPBYTE          pbData;                // Wave Bits
  int			  length;
  char            name[12];

  }
WAVEFILEEXT, *LPWAVEFILEEXT;



/*
Offset  Size  Name             Description
--------------------------------------------------------------------------------
The canonical WAVE format starts with the RIFF header:

0         4   ChunkID          Contains the letters "RIFF" in ASCII form
                               (0x52494646 big-endian form).
4         4   ChunkSize        36 + SubChunk2Size, or more precisely:
                               4 + (8 + SubChunk1Size) + (8 + SubChunk2Size)
                               This is the size of the rest of the chunk 
                               following this number.  This is the size of the 
                               entire file in bytes minus 8 bytes for the
                               two fields not included in this count:
                               ChunkID and ChunkSize.
8         4   Format           Contains the letters "WAVE"
                               (0x57415645 big-endian form).

The "WAVE" format consists of two subchunks: "fmt " and "data":
The "fmt " subchunk describes the sound data's format:

12        4   Subchunk1ID      Contains the letters "fmt "
                               (0x666d7420 big-endian form).
16        4   Subchunk1Size    16 for PCM.  This is the size of the
                               rest of the Subchunk which follows this number.
20        2   AudioFormat      PCM = 1 (i.e. Linear quantization)
                               Values other than 1 indicate some 
                               form of compression.
22        2   NumChannels      Mono = 1, Stereo = 2, etc.
24        4   SampleRate       8000, 44100, etc.
28        4   ByteRate         == SampleRate * NumChannels * BitsPerSample/8
32        2   BlockAlign       == NumChannels * BitsPerSample/8
                               The number of bytes for one sample including
                               all channels. I wonder what happens when
                               this number isn't an integer?
34        2   BitsPerSample    8 bits = 8, 16 bits = 16, etc.
          2   ExtraParamSize   if PCM, then doesn't exist
          X   ExtraParams      space for extra parameters

The "data" subchunk contains the size of the data and the actual sound:

36        4   Subchunk2ID      Contains the letters "data"
                               (0x64617461 big-endian form).
40        4   Subchunk2Size    == NumSamples * NumChannels * BitsPerSample/8
                               This is the number of bytes in the data.
                               You can also think of this as the size
                               of the read of the subchunk following this 
                               number.
44        *   Data             The actual sound data.
*/
typedef struct 
  {
	BYTE		ChunkID[4];    //Contains the letters "RIFF" in ASCII form (0x52494646 big-endian form).
	DWORD		ChunkSize;     //36 + SubChunk2Size, or more precisely:
	BYTE		Format[4];     //Contains the letters "WAVE"
	BYTE		Subchunk1[4]; 
	DWORD		Subchunk1Size;
	WORD		AudioFormat;
	WORD		NumChannels;
	DWORD		SampleRate;
	DWORD		ByteRate;
	WORD		BlockAlign;
	WORD		BitsPerSample;
	BYTE		Subchunk2ID[4];//Contains the letters "fmt "
	DWORD		Subchunk2Size;
  }WAVEFILEHEADER;



char* DS_ConvertVOCtoWAV(char *data, int sndnum, int size);

// ----------- DEFINES --------------------------------------------------------
#define DSBCAPS_CTRLDEFAULT 224
#define NUM_DSBUFFERS		256*2
#define NUM_DSBUF			250


// ----------- PROTOTYPES -----------------------------------------------------
BOOL	InitDirectSound();
char*   DecodeVoc( char *data, int sndnum, int size, FILEINFO *psFileInfo );
BOOL	MakeSoundBuffer(int Channel, int length, unsigned char *data);
void	ShutdownDirectSound(void);
BOOL	RestartDirectSound(void);
void	DS_PlayVocSound(char *ptr,int size,int pitchoffset,int angle,int distance,WAVEFILE  pWaveFile);
BOOL	DS_SoundActive ();
BOOL	CopyToSoundBuffer(int chan, int length, unsigned char *data);
void    DS_WriteVOCtofile (char *data, int sndnum, int size, char*name);
void	WriteAllSounds();
BOOL	DS_StopOneSound (int chan);
int		SetChanVoldistance (int chan, int distance);
DWORD	GetChanCurrentPosition (int chan);

BOOL GetWaveInfo (  unsigned char   *lpChunkOfMemory,// Points to raw ram
					LPWAVEFORMATEX  *lplpWaveHeader, // Points to pointer to header
					LPBYTE          *lplpWaveSamples,// Points to pointer to samples
					LPDWORD          lpcbWaveSize);  // Points to size
void DS_WriteVOCtofile (char *data, int sndnum, int size, char*name);

extern void ErrorBox(LPSTR lpszErrorStr, HRESULT hr);

// ----------- GLOBALS --------------------------------------------------------
LPDIRECTSOUND			lpDS;
LPDIRECTSOUNDBUFFER		lpB;
LPDIRECTSOUNDBUFFER		lpDSBP;
LPDIRECTSOUNDBUFFER		lpDSB[NUM_DSBUFFERS];

WAVEFORMATEX			wfex;
DSBUFFERDESC			dsbDSC;



int CurrentChannel = 0;
int WorkingChannel = 0;

// ----------- EXTERN GLOBALS -------------------------------------------------
extern HWND hMainWnd;
extern int FXvolume;
extern boolean stereoreversed;
extern char ApogeePath[256];
extern long LoadResourceToFixedMem (LPSTR Type ,int sndnb, void **bufferptr);
extern int W_GetSoundnameForNum ( int sndnum );
extern int SafeOpenWrite (char *_filename);
extern void SafeWrite (int handle, void *buffer, long count);
extern int close (int handle);
extern int access(const char *, int);

//keeps track of extracted sounds
long iExternSounds[500];//contains all handle to soundmemblocks
long iExternSoundsSize[500];//sizes of ditto


WAVEFILEEXT BufSizes[NUM_DSBUFFERS];


/********************************************************************/
/*																	*/
/* Function name : InitDirectSound			 		                */
/* Description   :													*/
/*																	*/
/********************************************************************/
BOOL InitDirectSound()
{
    HRESULT        hr = 0;
    int            i;

	// Create an instance of DirectSound
    hr = DirectSoundCreate(NULL, &lpDS, NULL);
    if (hr != DS_OK){
		for (i = 0; i < NUM_DSBUFFERS; i++)
			lpDSB[i] = 0;		   
		//ErrorBox("DirectSoundCreate Error",hr);
		return FALSE;
	}

    // Set cooperative level 
    hr = lpDS->lpVtbl->SetCooperativeLevel(lpDS, hMainWnd, DSSCL_EXCLUSIVE);
	if (hr != DS_OK){
		//ErrorBox("SetCooperativeLevel(lpDS) Error",hr);
		return FALSE;
	}

    // Set the DSBUFFERDESC structure.
    memset(&dsbDSC, 0, sizeof(DSBUFFERDESC));  
    dsbDSC.dwSize              = sizeof(DSBUFFERDESC);
    dsbDSC.dwFlags             = DSBCAPS_PRIMARYBUFFER;
    dsbDSC.dwBufferBytes       = 0;
    dsbDSC.lpwfxFormat         = NULL;

	// Create the buffer
    hr = lpDS->lpVtbl->CreateSoundBuffer(lpDS, &dsbDSC, &lpDSBP, NULL);
    if (hr != DS_OK)  {
		//ErrorBox("CreateSoundBuffer Error",hr);
		return FALSE;
    }

    // Set the wave format structure.
    memset( &wfex, 0, sizeof(WAVEFORMATEX) );
    wfex.wFormatTag         = WAVE_FORMAT_PCM;      
    wfex.nChannels          = 2;
    wfex.nSamplesPerSec     = 11025;
    wfex.nAvgBytesPerSec    = 22050;
    wfex.nBlockAlign        = 2; 
    wfex.wBitsPerSample     = (WORD)8;
    wfex.cbSize             = 0;

	// Set format
    hr = lpDSBP->lpVtbl->SetFormat(lpDSBP, &wfex);
    if (hr != DS_OK){
		//ErrorBox("SetFormat Error",hr);
		return FALSE;
    }

    // Set cooperative level 
    hr = lpDS->lpVtbl->SetCooperativeLevel(lpDS, hMainWnd, DSSCL_NORMAL);
	if (hr != DS_OK){
		//ErrorBox("SetCooperativeLevel(lpDS) Error",hr);
		return FALSE;
	}

	for (i = 0; i < NUM_DSBUFFERS;i++){
		BufSizes[i].cbSize = sizeof(WAVEFILEEXT);
		BufSizes[i].pbData = 0;
		BufSizes[i].pwfxInfo.cbSize = sizeof(LPWAVEFILEEXT);
		BufSizes[i].pwfxInfo.nAvgBytesPerSec = 0;
		BufSizes[i].pwfxInfo.nBlockAlign = 0;
		BufSizes[i].pwfxInfo.nChannels = 0;
		BufSizes[i].pwfxInfo.nSamplesPerSec = 0;
		BufSizes[i].pwfxInfo.wBitsPerSample = 0;
		BufSizes[i].pwfxInfo.wFormatTag = 0;
		BufSizes[i].length = 0;
		BufSizes[i].name[0] = 0;
	}

    return(TRUE);
}


/********************************************************************/
/*																	*/
/* Function name : MakeSoundBuffer			 		                */
/* Description   :													*/
/*																	*/
/********************************************************************/
BOOL MakeSoundBuffer(int chan, int length, unsigned char *data)
   {
    HRESULT        hr = 0;
    DSBUFFERDESC   dsbDSC;
    PCMWAVEFORMAT  PCMwf;
    DWORD          size1, size2;
    void           *buffer, *buff2;
	WAVEFILE       pWaveFile;

    if (chan > NUM_DSBUFFERS){
		ErrorBox("MakeSoundBuffer(chan > NUM_DSBUFFERS) Error",hr);
		return FALSE;
    }

	if (!GetWaveInfo(data,&(pWaveFile.pwfxInfo), 
			&(pWaveFile.pbData), 
			&(pWaveFile.cbSize)))
	{
		return 0;  // error

	}

    // Set the wave format structure
    memset( &PCMwf, 0, sizeof(PCMWAVEFORMAT) );
    PCMwf.wf.wFormatTag         = pWaveFile.pwfxInfo->wFormatTag;//WAVE_FORMAT_PCM;      
    PCMwf.wf.nChannels          = pWaveFile.pwfxInfo->nChannels ;//1;
    PCMwf.wf.nSamplesPerSec     = pWaveFile.pwfxInfo->nSamplesPerSec;//11025;
    PCMwf.wf.nBlockAlign        = pWaveFile.pwfxInfo->nBlockAlign;//1; 
    PCMwf.wf.nAvgBytesPerSec    = pWaveFile.pwfxInfo->nAvgBytesPerSec;//11025;
    PCMwf.wBitsPerSample        = pWaveFile.pwfxInfo->wBitsPerSample;//(WORD)8;


    // Set the DSBUFFERDESC structure |DSBCAPS_STATIC
    memset(&dsbDSC, 0, sizeof(DSBUFFERDESC));  
    dsbDSC.dwSize              = sizeof(DSBUFFERDESC);
    dsbDSC.dwFlags             = DSBCAPS_CTRLFREQUENCY | DSBCAPS_CTRLDEFAULT;
    dsbDSC.dwBufferBytes       = length;
    dsbDSC.lpwfxFormat         = (LPWAVEFORMATEX)&PCMwf;

	// Create Buffer
    if ((hr = lpDS->lpVtbl->CreateSoundBuffer(lpDS, &dsbDSC, &lpDSB[chan], NULL)) != DS_OK){
		if (RestartDirectSound()==FALSE){
			ErrorBox("CreateSoundBuffer Error",hr);
			return FALSE;
		}else{
			return FALSE;
		}
    }

	// Lock buffer
	data = pWaveFile.pbData;
    hr = lpDSB[chan]->lpVtbl->Lock(lpDSB[chan],0,length,&buffer,&size1,&buff2,&size2,DSBLOCK_ENTIREBUFFER );
    if (hr == DS_OK) {
        memcpy(buffer, data, pWaveFile.cbSize);
        hr = lpDSB[chan]->lpVtbl->Unlock(lpDSB[chan],buffer,length,buff2,size2);
        if (hr != DS_OK){
			if (RestartDirectSound()==FALSE){
				ErrorBox("Unlock Error",hr);
				return FALSE;
			}else{
				return FALSE;
			}
		}
    }else{
		if (RestartDirectSound()==FALSE){
			ErrorBox("Lock Error",hr);
			return FALSE;
		}else{
			return FALSE;
		}
    }

	return TRUE;
}


/********************************************************************/
/*																	*/
/* Function name : ShutdownDirectSound		 		                */
/* Description   :													*/
/*																	*/
/********************************************************************/
void ShutdownDirectSound(void)
{
    int		buf;

	//stop and destroy all buffers
    for(buf = 0; buf < NUM_DSBUFFERS; buf++)	{
        if(lpDSB[buf] != 0){
			lpDSB[buf]->lpVtbl->Stop(lpDSB[buf]);
            RELEASE(lpDSB[buf]);
		}
	}
    if(lpDSBP != NULL) RELEASE(lpDSBP);
    if(lpDS != NULL) RELEASE(lpDS);
}


/********************************************************************/
/*																	*/
/* Function name : RestartDirectSound		 		                */
/* Description   :													*/
/*																	*/
/********************************************************************/
BOOL RestartDirectSound(void)
{
	ShutdownDirectSound();
	return(InitDirectSound());
}

static int tic1=0;
static int oldtic2=0;
static int oldsize=0;
extern int BotSndNb, TopSndNum;//used to SurroundEffect filter

/********************************************************************/
/*																	*/
/* Function name : DS_PlayVocSound 		 		                    */
/* Description   :													*/
/*																	*/
/********************************************************************/

extern int currentsndnum;//bna++ 162
extern int globalpitch;//bna++ 162
extern int globalpitchtimeout;//bna++ 162

void DS_PlayVocSound(char *ptr,int size,int pitchoffset,int angle,int distance, WAVEFILE pWaveFile)
{
	HRESULT			hr = 0;
	LONG			lPan, lVol, lMainVol;
	int				chan,length;
	unsigned char	*data;
	DWORD lpdwStatus = 0;  
//	WAVEFILE       pWaveFile;

	//ErrorDontQuit("size",size);
	//ErrorDontQuit("tick",GetTickCount());


	if (13722==size){//god ball sound explosion
		tic1=GetTickCount();//dont allow more than 10 per sec
		if ((tic1>=oldtic2+100)&&(oldsize==size)){
			return;
		}
		oldsize=size;
		oldtic2=GetTickCount();
	}
	if (7165==size){//robot sound 
		tic1=GetTickCount();//dont allow more than 10 per sec
		if ((tic1<=oldtic2+100)&&(oldsize==size)){
			return;
		}
		oldsize=size;
		oldtic2=GetTickCount();
	}

//	if (ptr[0]=='C'){
//		data = ptr+0x38;    //adjust for VOC file (Creative Voice File)
//		length = size-0x3C; //adjust for VOC file
//	}else{
		data = ptr;    //adjust for wav file
		length = size; //adjust for wav file
//	}
	// volume should be calculated in Db but
	// I couldnt get to work properly

	//find the overall volume
	lMainVol = ((255-FXvolume)*9);  
/*
	//check if any previus channelsize match
	if (!GetWaveInfo(data,&(pWaveFile.pwfxInfo), 
			&(pWaveFile.pbData), 
			&(pWaveFile.cbSize)))
	{
		return 0;  // error

	}
*/

	for (chan = 0; chan < NUM_DSBUFFERS;chan++){
		if ((pWaveFile.pwfxInfo->nChannels == BufSizes[chan].pwfxInfo.nChannels) &&
			(pWaveFile.pwfxInfo->nSamplesPerSec == BufSizes[chan].pwfxInfo.nSamplesPerSec) &&
			(length == BufSizes[chan].length) &&
			(pWaveFile.pwfxInfo->wBitsPerSample == BufSizes[chan].pwfxInfo.wBitsPerSample))
		
		{
		//if (length == BufSizes[chan]) {
			//yes right size, is it unused
			lpDSB[chan]->lpVtbl->GetStatus(lpDSB[chan],&lpdwStatus);
			if (lpdwStatus != DSBSTATUS_PLAYING){	
				//memcpy(tmpbuf, data, length);
				//CopyToSoundBuffer(chan, pWaveFile.cbSize, pWaveFile.pbData);
				break;
			}
		}
	}


	if (chan >= NUM_DSBUFFERS){//make a new one
		//find a free, never used channelsize in BufSizes
		for (chan = 0; chan < NUM_DSBUFFERS;chan++){
			if (0 == BufSizes[chan].pwfxInfo.nChannels) {
				//ok use this
				BufSizes[chan].pwfxInfo.cbSize = pWaveFile.pwfxInfo->cbSize;
				BufSizes[chan].pwfxInfo.nAvgBytesPerSec = pWaveFile.pwfxInfo->nAvgBytesPerSec;
				BufSizes[chan].pwfxInfo.nBlockAlign = pWaveFile.pwfxInfo->nBlockAlign;
				BufSizes[chan].pwfxInfo.nChannels = pWaveFile.pwfxInfo->nChannels;
				BufSizes[chan].pwfxInfo.nSamplesPerSec = pWaveFile.pwfxInfo->nSamplesPerSec;
				BufSizes[chan].pwfxInfo.wBitsPerSample = pWaveFile.pwfxInfo->wBitsPerSample;
				BufSizes[chan].pwfxInfo.wFormatTag = pWaveFile.pwfxInfo->wFormatTag;
				BufSizes[chan].length = length;
				//BufSizes[chan] = length;
				MakeSoundBuffer(chan, length, data);
				//ErrorDontQuit("chan=",chan);
				break;
			}
		}
		if ( chan >= NUM_DSBUFFERS){
			//we have used up all the channels 0 - 511
			RestartDirectSound();
			return;//we couldnt find a free buf chan, dont play that sound
		}
	}

	lpDSB[chan]->lpVtbl->SetCurrentPosition( lpDSB[chan], 0 );
	// Set the Pitchoffset
	//lpDSB[chan]->lpVtbl->SetFrequency(lpDSB[chan],11025+(pitchoffset));

	//SetFrequency DSBFREQUENCY_MAX 'Maximum frequency
	//SetFrequency DSBFREQUENCY_MIN 'Minimum frequency
	//SetFrequency DSBFREQUENCY_ORIGINAL 
	//org rott pitch goes from -60 to 1088
	if (pitchoffset != 0){
		//lpDSB[chan]->lpVtbl->GetFrequency(lpDSB[chan],&lOrgFreq);
		//lpDSB[chan]->lpVtbl->SetFrequency(lpDSB[chan],lOrgFreq+11025+pitchoffset);
		lpDSB[chan]->lpVtbl->SetFrequency(lpDSB[chan],11025+(pitchoffset));
	}
	if (globalpitch != -1){ //bna++162 start
		lpDSB[chan]->lpVtbl->SetFrequency(lpDSB[chan],11025+(2000+globalpitch*8));
		globalpitchtimeout--;
		if (globalpitchtimeout <= 0) 
			globalpitch = -1;
	}//bna++162 end

	// Make sound weaker at distance
	lVol = -distance*5;

	// WithDraw mainvol 
	lVol -= lMainVol;


	// Make sure vol is between limits
	if (lVol <= DSBVOLUME_MIN){lVol=DSBVOLUME_MIN;}
	if (lVol >= DSBVOLUME_MAX){lVol=DSBVOLUME_MAX;}
	lpDSB[chan]->lpVtbl->SetVolume(lpDSB[chan],lVol);

	// find Pan angle and set it
	lPan = angle*500;

	if (angle < 15){
		lPan = angle*-700;//-10000;	
	}else if (angle > 15){
		lPan = (angle-15)*700;//10000;	
	}else{
		lPan = 0;  
	}

	lPan *= -1;
	if (stereoreversed == TRUE) {
		lPan *= -1;
	}

	// angle/2 = middle   0 = -10000   16 = 0  32 = 10000
	lpDSB[chan]->lpVtbl->SetPan(lpDSB[chan],lPan);  //-10000,0,10000

	// Play the sound
	lpDSB[chan]->lpVtbl->Play( lpDSB[chan], 0, 0, 0 );

	WorkingChannel = chan;

	return;

}

/*
The frequency value is expressed in samples per seconds 
and represents the playback speed of the buffer. 
A larger number plays the sound faster and raises 
the pitch while a smaller number slows the speed down 
and lowers the pitch. To reset the sound to its original 
frequency, simply set the frequency value to 0. 
The minimum value for frequency is 100 and the maximum value is 200,000.
*/

/********************************************************************/
/*																	*/
/* Function name : DS_SoundActive 		 		                    */
/* Description   :													*/
/*																	*/
/********************************************************************/
BOOL DS_SoundActive ()
{
	DWORD	lpdwStatus = 0;  
	int		chan = 0;

	//check if any channels are playing
	for (chan = 0; chan < NUM_DSBUFFERS;chan++){
		if (lpDSB[chan] != 0){
			lpDSB[chan]->lpVtbl->GetStatus(lpDSB[chan],&lpdwStatus);
			if (lpdwStatus == DSBSTATUS_PLAYING){
				return TRUE;
			}
		}
	}

	return FALSE;
}

/********************************************************************/
/*																	*/
/* Function name : DS_OneSoundActive	 		                    */
/* Description   :													*/
/*																	*/
/********************************************************************/
BOOL DS_OneSoundActive (int chan)
{
	DWORD	lpdwStatus = 0;  

	if (chan < 0){return FALSE;}
	if (lpDSB[chan] == 0){return FALSE;}

	lpDSB[chan]->lpVtbl->GetStatus(lpDSB[chan],&lpdwStatus);
	if (lpdwStatus == DSBSTATUS_PLAYING){
		return TRUE;
	}

	return FALSE;
}

/********************************************************************/
/*																	*/
/* Function name : DS_StopAllSounds	 		                        */
/* Description   :													*/
/*																	*/
/********************************************************************/
BOOL DS_StopAllSounds ()
{
	DWORD	lpdwStatus = 0; 
	int		chan = 0;

	for (chan = 0; chan < NUM_DSBUFFERS;chan++){
		if (lpDSB[chan] != 0){
			lpDSB[chan]->lpVtbl->GetStatus(lpDSB[chan],&lpdwStatus);
			if (lpdwStatus == DSBSTATUS_PLAYING){
				lpDSB[chan]->lpVtbl->Stop(lpDSB[chan]);
			}
		}
	}
	return TRUE;
}



BOOL DS_StopOneSound (int chan)
{
	DWORD	lpdwStatus = 0; 
	lpDSB[chan]->lpVtbl->Stop(lpDSB[chan]);
		return 1;
/*
	if (lpDSB[chan] != 0){
		lpDSB[chan]->lpVtbl->GetStatus((DWORD)chan,&lpdwStatus);
		if (lpdwStatus == DSBSTATUS_PLAYING){
			//SetChanVoldistance (chan,  -10000);
			//lpDSB[chan]->lpVtbl->Stop(lpDSB[chan]);
			lpDSB[chan]->lpVtbl->Stop((DWORD)chan);
		}
	}
	return TRUE;*/
}

/********************************************************************/
/*																	*/
/* Function name : DS_SetPan	 		                            */
/* Description   :													*/
/*																	*/
/********************************************************************/
BOOL DS_SetPan ( int handle, int vol, int left, int right )
{
	int chan = 0;
	lpDSB[WorkingChannel]->lpVtbl->SetPan(lpDSB[WorkingChannel],left-right);
	return TRUE;
}

/********************************************************************/
/*																	*/
/* Function name : CopyToSoundBuffer	                            */
/* Description   :													*/
/*																	*/
/********************************************************************/
BOOL CopyToSoundBuffer(int chan, int length, unsigned char *data)
{
    HRESULT        hr = 0;
    DWORD          size1, size2;
    void           *buffer, *buff2;


    if (chan > NUM_DSBUFFERS){
		ErrorBox("CopyToSoundBuffer(chan > NUM_DSBUFFERS) Error",hr);
		return FALSE;
    }

	// Lock buffer
    hr = lpDSB[chan]->lpVtbl->Lock(lpDSB[chan],0,length,&buffer,&size1,&buff2,&size2,DSBLOCK_ENTIREBUFFER );
    if (hr == DS_OK) {
        memcpy(buffer, data, length);
        hr = lpDSB[chan]->lpVtbl->Unlock(lpDSB[chan],buffer,length,buff2,size2);
        if (hr != DS_OK){
			if (RestartDirectSound()==FALSE){
				ErrorBox("Unlock Error",hr);
				return FALSE;
			}else{
				return FALSE;
			}
		}
    }else{
		if (RestartDirectSound()==FALSE){
			ErrorBox("Lock Error",hr);
			return FALSE;
		}else{
			return FALSE;
		}
    }

	return TRUE;
}


//----------------------------------------------------------------------------------------
/*
BOOL PlayResource(LPSTR lpName) 
{
	BOOL bRtn;     
	LPSTR lpRes; 
    HANDLE hResInfo,hRes;      // Find the WAVE resource.  
    
	hResInfo = FindResource(hInst, lpName, "WAVE");     
	if (hResInfo == NULL) 
        return FALSE;      // Load the WAVE resource.  
    hRes = LoadResource(hInst, hResInfo);     
	if (hRes == NULL) 
        return FALSE;      // Lock the WAVE resource and play it.  
    lpRes = LockResource(hRes);   

	if (lpRes != NULL) { 
        bRtn = sndPlaySound(lpRes, SND_MEMORY | SND_ASYNC | SND_NODEFAULT);         
		UnlockResource(hRes);     
	}     
	else 
        bRtn = 0;      // Free the WAVE resource and return success or failure. 
     FreeResource(hRes);     
	 return bRtn; 
} 
//----------------------------------------------------------------------------------------
/*
BOOL PlayMemSound(char *memptr) 
{  
	int i;
	BOOL bRtn;     
	LPSTR lpRes,lpMem; 
    HANDLE hResInfo,hRes;      // Find the WAVE resource.  
    
	hResInfo = FindResource(hInst, "soundName", "WAVE");     
	if (hResInfo == NULL) 
        return FALSE;      // Load the WAVE resource.  
    hRes = LoadResource(hInst, hResInfo);     
	if (hRes == NULL) 
        return FALSE;      // Lock the WAVE resource and play it.  
    lpRes = LockResource(hRes);  
	
	lpMem = lpRes + 0x2C;
	//copy ptr data tp lpRes
	for (i=0;i<3600;i++){
		*lpMem++ = *memptr++;
	}

	if (lpRes != NULL) { 
        bRtn = sndPlaySound(lpRes, SND_MEMORY | SND_ASYNC | SND_NODEFAULT);         
		UnlockResource(hRes);     }     
	else 
        bRtn = 0;      // Free the WAVE resource and return success or failure. 
     FreeResource(hRes);     
	 return bRtn; 
}sprite = SafeMalloc ( sizeof (spriteevent) );
*/


extern HINSTANCE hInst;
/********************************************************************/
/*																	*/
/* Function name : DS_WriteVOCtofile	                            */
/* Description   :													*/
/*																	*/
/********************************************************************/
void DS_WriteVOCtofile (char *data, int sndnum, int size, char*name)
{
	char *bufferptr;
    int   handle;
	char tmp[256];


	//make sure our sound folder exists
	char soundpath[256];//

	strcpy(soundpath,ApogeePath);
	strcat(soundpath,"\\SFX");
	CreateDirectory(soundpath, NULL);

	//get the soundname
	if ( name == 0){
		strncpy(&tmp[0],(char*)W_GetSoundnameForNum(sndnum),8);
		tmp[8]=0;
	}else{
		lstrcpy(tmp,name);
		tmp[8]=0;
	}

	//create filename
	sprintf(soundpath,"%s\\SFX\\%d.%s.wav",ApogeePath,sndnum,tmp);
	
	bufferptr = DS_ConvertVOCtoWAV(data, sndnum, size);
	if (bufferptr == 0)
		return;

	if ( g_hheap == 0)
		return;

	//size = HeapSize(g_hheap,HEAP_NO_SERIALIZE,bufferptr );


size =  LocalSize(
  bufferptr   // handle to local memory object
);

	//size = GlobalSize(bufferptr);
	if (size <= 0)
		return;
	 
	if (access(soundpath,0)!=0)   {
		//dont overwrite
		handle = SafeOpenWrite (soundpath);
		SafeWrite(handle,bufferptr,size);
		close (handle);
		//_commit(  handle );
	}
	//GlobalFree (bufferptr);//release mem;
	if ( g_hheap != 0){
		LocalFree(bufferptr);
		//BOOL r = HeapFree(g_hheap,HEAP_NO_SERIALIZE, bufferptr );
	}
}

	



char* DS_ConvertVOCtoWAV(char *data, int sndnum, int size)
{
	WAVEFILEHEADER *wfh;
	FILEINFO psFileInfo;
	char *pData, *wavdata, *vocdata;

	memset(&psFileInfo,0x00,sizeof(FILEINFO));

	vocdata = DecodeVoc(data, sndnum, size,&psFileInfo);
	if (vocdata == 0)
		return 0;

	if ((sndnum < 0)||(sndnum >= SD_LASTSOUND))
		return 0;


	if ((size < 0)||(size >= 0xFFFF))
		return 0;
//ErrorDontQuit("DS_ConvertVOCtoWAV GlobalAlloc",psFileInfo.lTotalLength+sizeof(WAVEFILEHEADER)+100); 


	pData = HEAP_getheapmem(psFileInfo.lTotalLength+sizeof(WAVEFILEHEADER)+100	);
//	pData = GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,psFileInfo.lTotalLength+sizeof(WAVEFILEHEADER)+100);
	if (pData == 0)
		return 0;


	//reset our sound mem
	memset(pData,0x80,psFileInfo.lTotalLength+sizeof(WAVEFILEHEADER));
	wfh = (WAVEFILEHEADER *)pData;
	lstrcpy(wfh->ChunkID,"RIFF");    //Contains the letters "RIFF" in ASCII form (0x52494646 big-endian form).
	wfh->ChunkSize = psFileInfo.lTotalLength + 36;     //36 + SubChunk2Size, or more precisely:
	lstrcpy(wfh->Format,"WAVE");     //Contains the letters "WAVE"
	lstrcpy(wfh->Subchunk1,"fmt "); 
	wfh->Subchunk1Size = 16;
	wfh->AudioFormat = 1;
	wfh->NumChannels = 1;//psFileInfo.ucChannels;
	wfh->SampleRate = 11025;//psFileInfo.lSamplesPerSeconds;
	wfh->ByteRate = 11025;//psFileInfo.lSamplesPerSeconds;
	wfh->BlockAlign = 1;
	wfh->BitsPerSample = 8;//psFileInfo.ucBitsPerSample;
	lstrcpy(wfh->Subchunk2ID,"data");//Contains the letters "fmt "
	wfh->Subchunk2Size = psFileInfo.lTotalLength;

	wavdata = pData + sizeof(WAVEFILEHEADER);
	//memcpy(wavdata,(vocdata+4),psFileInfo.lTotalLength-4);

	if (((psFileInfo.lTotalLength-4) > 0)&&((psFileInfo.lTotalLength-4)<0x1FFFF))
		memcpy(wavdata,(vocdata+4),psFileInfo.lTotalLength-4);
	else 
		return 0;

	//GlobalFree(vocdata);
	return (char*)pData;

}





/********************************************************************/
/*																	*/
/* Function name : DecodeVoc			                            */
/* Description   :													*/
/*																	*/
/********************************************************************/
char* DecodeVoc( char *data, int sndnum, int size, FILEINFO *psFileInfo)
{

	//char *pData = GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,size);
	char *pDataPos;// = pData;
	BYTE bType;
	signed long int lLen;
	unsigned char tmp[4];
	VocHeader *vh = (VocHeader *)data; 
	char *memdata = data + vh->DataBlockOffset;

	//if (pDataVoc == 0)
	//	pDataVoc = HEAP_getheapmem(0xFFFF);

		//pDataVoc = GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,0xFFFF);

	pDataPos = pDataVoc;

	if(strncmp((char *)vh->Description,"Creative Voice File\x1A",10)!=0)
	{  
		return 0; //Not a Valid VOC File	
	}

 	//reset our sound mem
	memset(pDataVoc,0x80,0xFFFF-1);

	if ((*memdata != 1)&&(*memdata != 8)&&(*memdata != 9)){
		if (*memdata == 6)
			memdata = data + 0x20;
		else{
			psFileInfo->usTimeConstant = 65444; 
			psFileInfo->usFileFormat = 0; 
			psFileInfo->ucBitsPerSample    = 8;
			psFileInfo->ucChannels         = 1;
			psFileInfo->lSamplesPerSeconds = 10869;
			psFileInfo->lTotalLength = size;
			memcpy(pDataPos,memdata,size);
			return pDataVoc;
		}
	}

	do
	{
		// Read the block type
		bType = *memdata++;

		lLen = 0;
		switch( bType )
		{
		case 1:
		{
			tmp[0] = *memdata++; 
			tmp[1] = *memdata++; 
			tmp[2] = *memdata++; 
			lLen = (tmp[2]*(256*256))+(tmp[1]*256)+tmp[0];

			lLen -= 2;// Remove Time Constant and File Format bytes
			psFileInfo->usTimeConstant = *memdata++; 
			psFileInfo->usFileFormat = *memdata++; 
			// For the moment, it's a plain 8-bit mono file
			psFileInfo->ucBitsPerSample    = 8;
			psFileInfo->ucChannels         = 1;
			psFileInfo->lSamplesPerSeconds = 1000000 /
			(256-(psFileInfo->usTimeConstant % 256));
			// Store this sample in memory
			memcpy(pDataPos,memdata,lLen);
			pDataPos += lLen;
			memdata += lLen;
			break;
		}

		case 8:
		{
			memdata+=3; 
			tmp[0] = *memdata++; 
			tmp[1] = *memdata++; 
			psFileInfo->usTimeConstant = (tmp[1]*256)+tmp[0];
			psFileInfo->usFileFormat = *memdata++; 
			psFileInfo->ucChannels = *memdata++; 
			bType = *memdata++;
			tmp[0] = *memdata++; 
			tmp[1] = *memdata++; 
			tmp[2] = *memdata++; 
			lLen = (tmp[2]*(256*256))+(tmp[1]*256)+tmp[0];
			lLen -= 2;     // Remove Time Constant and File Format bytes
			memdata+=2; 
			psFileInfo->ucBitsPerSample    = 8;
			psFileInfo->ucChannels++;
			psFileInfo->usTimeConstant >>= 8;
			psFileInfo->lSamplesPerSeconds = 1000000 /
			(256-(psFileInfo->usTimeConstant % 256));
			memcpy(pDataPos,memdata,lLen);
			pDataPos += lLen;
			memdata += lLen;
			break;
		}

		case 9:
		{
			tmp[0] = *memdata++; 
			tmp[1] = *memdata++; 
			tmp[2] = *memdata++; 
			lLen = (tmp[2]*(256*256))+(tmp[1]*256)+tmp[0];
			lLen -= 12;
			tmp[0] = *memdata++; 
			tmp[1] = *memdata++; 
			tmp[2] = *memdata++; 
			tmp[3] = *memdata++; 
			psFileInfo->lSamplesPerSeconds = (tmp[3]*(256*256*256))+(tmp[2]*(256*256))+(tmp[1]*256)+tmp[0];
			psFileInfo->ucBitsPerSample = *memdata++; 
			psFileInfo->ucChannels = *memdata++; 
			tmp[0] = *memdata++; 
			tmp[1] = *memdata++; 
			psFileInfo->usFileFormat = (tmp[1]*256)+tmp[0];
			memcpy(pDataPos,memdata,lLen);
			pDataPos += lLen;
			memdata += lLen;
			break;
		}
	};
	} while ( bType != 0 );

	psFileInfo->lTotalLength = pDataPos-pDataVoc;

	if (psFileInfo->lTotalLength <= 0)
		return 0;


	return pDataVoc;
} 


/********************************************************************/
/*																	*/
/* Function name : DS_LoadExternSounds	                            */
/* Description   :													*/
/*																	*/
/********************************************************************/
void DS_LoadExternSounds()
{
	char soundpath[256];//
	char soundpathfilename[256];//
	char *tmp;
	int sndnum;
	DWORD dwBytesread;
	HANDLE hFile;
	WIN32_FIND_DATA FindData;
	HANDLE ffh;
	BOOL  retVal = TRUE;



	strcpy(soundpath,ApogeePath);
	strcat(soundpath,"\\SFX\\*.wav");

	ffh = FindFirstFile(soundpath, &FindData);
	if (ffh != INVALID_HANDLE_VALUE) {
		do {
			sndnum = atol (FindData.cFileName);
//			if (sndnum == 252)
//retVal = TRUE;
			sprintf(soundpathfilename,"%s\\SFX\\%s",ApogeePath,FindData.cFileName);
			hFile = CreateFile( soundpathfilename,GENERIC_READ ,FILE_SHARE_READ,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
			iExternSoundsSize[sndnum] = GetFileSize( hFile,NULL);

			//tmp =  GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,iExternSoundsSize[sndnum]);
			tmp = HEAP_getheapmem(iExternSoundsSize[sndnum]);
			
			memset(tmp,0x80,iExternSoundsSize[sndnum]);
			iExternSounds[sndnum] = (long)tmp;
			ReadFile(hFile,(BYTE*)tmp, iExternSoundsSize[sndnum]-200, &dwBytesread, NULL) ; 
			//*tmp = 'C';//pretend its a Creative Voice file
			CloseHandle (hFile);

		} while (FindNextFile(ffh, &FindData));
		FindClose(ffh);
	}

}



/*
HRESULT SetEcho(LPDIRECTSOUNDBUFFER8 pDSBuffer)
{
  HRESULT hr;
  DWORD dwResults[1];  // One element for each effect.
 
  // Describe the effect.
  DSEFFECTDESC dsEffect;
  memset(&dsEffect, 0, sizeof(DSEFFECTDESC));
  dsEffect.dwSize = sizeof(DSEFFECTDESC);
  dsEffect.dwFlags = 0;
  dsEffect.guidDSFXClass = GUID_DSFX_STANDARD_ECHO;
 
  // Set the effect
  if (SUCCEEDED(hr = pDSBuffer->SetFX(1, &dsEffect, dwResults)))
  {
    switch (dwResults[0])
    {
      case DSFXR_LOCHARDWARE:
        OutputDebugString("Effect was placed in hardware.");
        break;
      case DSFXR_LOCSOFTWARE:
        OutputDebugString("Effect was placed in software.");
        break;
      case DSFXR_UNALLOCATED:
        OutputDebugString("Effect is not yet allocated to hardware or software.");
        break;
    }
  }
  return hr;
}

*/


BOOL GetWaveInfo (  unsigned char   *lpChunkOfMemory,// Points to raw ram
					LPWAVEFORMATEX  *lplpWaveHeader, // Points to pointer to header
					LPBYTE          *lplpWaveSamples,// Points to pointer to samples
					LPDWORD          lpcbWaveSize)   // Points to size
{
    LPDWORD pdw;
    LPDWORD pdwEnd;
    DWORD   dwRiff;
    DWORD   dwType;
    DWORD   dwLength;

    // Set defaults to NULL or zero
    if (lplpWaveHeader)
        *lplpWaveHeader = NULL;

    if (lplpWaveSamples)
        *lplpWaveSamples = NULL;

    if (lpcbWaveSize)
        *lpcbWaveSize = 0;

    // Set up DWORD pointers to the start of the chunk
    // of memory.
    pdw = (DWORD *)lpChunkOfMemory;

    // Get the type and length of the chunk of memory
    dwRiff = *pdw++;
    dwLength = *pdw++;
    dwType = *pdw++;

    // Using the mmioFOURCC macro (part of Windows SDK), ensure
    // that this is a RIFF WAVE chunk of memory
    if (dwRiff != mmioFOURCC('R', 'I', 'F', 'F'))
      return FALSE;      // not even RIFF

    if (dwType != mmioFOURCC('W', 'A', 'V', 'E'))
      return FALSE;      // not a WAV

    // Find the pointer to the end of the chunk of memory
    pdwEnd = (DWORD *)((BYTE *)pdw + dwLength-4);

    // Run through the bytes looking for the tags
    while (pdw < pdwEnd)
      {
      dwType   = *pdw++;
      dwLength = *pdw++;

      switch (dwType)
        {
        // Found the format part
        case mmioFOURCC('f', 'm', 't', ' '):

          if (lplpWaveHeader && !*lplpWaveHeader)
            {
            if (dwLength < sizeof(WAVEFORMAT))
              return FALSE; // something's wrong! Not a WAV

            // Set the lplpWaveHeader to point to this part of
            // the memory chunk
            *lplpWaveHeader = (LPWAVEFORMATEX)pdw;

            // Check to see if the other two items have been
            // filled out yet (the bits and the size of the
            // bits). If so, then this chunk of memory has
            // been parsed out and we can exit
            if ((!lplpWaveSamples || *lplpWaveSamples) &&
                (!lpcbWaveSize || *lpcbWaveSize))
              {
              return TRUE;
              }
            }
          break;

        // Found the samples
        case mmioFOURCC('d', 'a', 't', 'a'):

          if ((lplpWaveSamples && !*lplpWaveSamples) ||
              (lpcbWaveSize && !*lpcbWaveSize))
            {
            // Point the samples pointer to this part of the
            // chunk of memory.
            if (lplpWaveSamples) *lplpWaveSamples = (LPBYTE)pdw;

            // Set the size of the wave
            if (lpcbWaveSize)    *lpcbWaveSize = dwLength;

            // Make sure we have our header pointer set up.
            // If we do, we can exit
            if (!lplpWaveHeader || *lplpWaveHeader)
              return TRUE;
            }
          break;

        } // End case

      // Move the pointer through the chunk of memory
      pdw = (DWORD *)((BYTE *)pdw + ((dwLength+1)&~1));
      }

  // Failed! If we made it here, we did not get all the pieces
  // of the wave
  return FALSE;
} // wave_ParseWaveMemory

 

int SetChanVoldistance (int chan, int distance)
{

	LONG lVol, lMainVol;

	if (chan < 0)
		return 0;
	if (lpDSB[chan] == 0)
		return 0;
	//find the overall volume
	lMainVol = ((255-FXvolume)*9);  
	
	// Make sound weaker at distance
	lVol = -distance * 5;
		
	// WithDraw mainvol 
	lVol -= lMainVol;
		
	// Make sure vol is between limits
	if (lVol <= DSBVOLUME_MIN){lVol=DSBVOLUME_MIN;}
	if (lVol >= DSBVOLUME_MAX){lVol=DSBVOLUME_MAX;}

	lpDSB[chan]->lpVtbl->SetVolume(lpDSB[chan],lVol);
		
	return 1;
	  
}

DWORD GetChanCurrentPosition (int chan)
{
	DWORD dwWriteCursor, dwPlayCursor;
	// Get current play position
	lpDSB[chan]->lpVtbl->GetCurrentPosition (lpDSB[chan],&dwPlayCursor, &dwWriteCursor);

	return dwPlayCursor;
}




#endif




