/*============================================================================
  Class:         CDXAudio (body)

  Please see accompanying definition of class.
   
  Written by:    Toby Murray, April 2002
  Last Modified: Toby Murray, 2nd April 2002
============================================================================*/
#include "stdafx.h"
#define INITGUID
#include "CDXAudio.h"
#include <cguid.h>

// constructor
CDXAudio::CDXAudio(){
   m_pPerformance = NULL;
   m_pLoader = NULL;
}

// destructor
CDXAudio::~CDXAudio(){
   Kill();
}

HRESULT CDXAudio::Setup(){
   HRESULT hr;
   // Initialize COM
   if (FAILED(hr = CoInitialize(NULL)))
      return hr;
    
   // Create loader object
   if (FAILED(hr = CoCreateInstance( CLSID_DirectMusicLoader, NULL, CLSCTX_INPROC, 
                                     IID_IDirectMusicLoader8, (void**)&m_pLoader )))
      return hr;

   // Create performance object
   if (FAILED(hr = CoCreateInstance( CLSID_DirectMusicPerformance, NULL, CLSCTX_INPROC, 
                                     IID_IDirectMusicPerformance8, (void**)&m_pPerformance )))
      return hr;

   // This initializes both DirectMusic and DirectSound and 
   // sets up the synthesizer. DMUS_APATH_SHARED_STEREOPLUSREVERB DMUS_APATH_DYNAMIC_STEREO
   if (FAILED(hr = m_pPerformance->InitAudio( NULL, NULL, NULL, 
                                              6, 64,
                                              DMUS_AUDIOF_ALL, NULL )))
      return hr;

   return S_OK;
}

// release everything
void CDXAudio::Kill(){
   // Stop the music
   if (m_pPerformance)
      m_pPerformance->Stop( NULL, NULL, 0, 0 );

   if (m_pLoader)
      m_pLoader->Release(); 
   m_pLoader = NULL;   
   
   if (m_pPerformance)
      m_pPerformance->CloseDown();

   if (m_pPerformance)
      m_pPerformance->Release();
   m_pPerformance = NULL;

   // Close down COM
   CoUninitialize();

}
