// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?[esp]
//

  #include "colors.inc"
  #include "skies.inc"
  #include "shapes.inc"    
  #include "finish.inc"
  #include "glass.inc"
  #include "metals.inc"
  #include "stones.inc"
  #include "woods.inc"
  #include "textures.inc"
  #include "lens.inc"
  #include "hands.inc"
  #include "vmath.inc"  
  #include "consts.inc"  

global_settings
{
  assumed_gamma 1.0
}


#declare usekubecam =true;
#declare myclock = clock;

#macro debugf (fl,a,b)
#debug concat(str (fl,a,b),"\n")
#end

#macro debugfn (fl,a,b)
#debug str (fl,a,b)
#end

#macro debugv (vc,a,b)
#debug concat("<",str (vc.x,a,b),",",str (vc.y,a,b),",",str (vc.z,a,b),">","\n")
#end

#declare k6=floor(clock*6+0.5);
#if (usekubecam) 
    #include "kubecam.inc"
    kubecam(<0,2,0>,k6)
    debugf(k6,5,60)
    #declare myclock=0.2;
#end

//sky_sphere { S_Cloud2 }
global_settings {
	ambient_light 0.1
}
sphere {0,10000 pigment {image_map { png "stars.png" map_type 1}} finish {ambient 10.0}  hollow}

#declare moonpos=vaxis_rotate(<50,0,16>,z,32);
//camera { location <0,0,0> look_at moonpos }
light_source 
{
  moonpos
  color rgb .2
}                                     

sphere { 
  <0,0,0>,1
	texture{
  pigment { 
	gradient x
	color_map {
	  [0.0 color Gray25]
	  [0.1 color White]
	  [0.9 color White]
	  [1.0 color Gray25]
	}
    turbulence .7
    omega 0.8
    lambda 1.8
    octaves 4 
   }

   finish {ambient 10.0}
}
  no_shadow
	scale 5
	translate moonpos
}

/*light_source 
{
  vaxis_rotate(<500,0,-50>,z,135)
  color rgb .2
}                                     
light_source 
{
  vaxis_rotate(<500,0,50>,z,45)
  color rgb 0.4
  shadowless
}                                     
light_source 
{
  vaxis_rotate(<500,0,-50>,z,45)
  color rgb 0.4
  shadowless
}                                     
light_source 
{
  vaxis_rotate(<500,0,50>,z,135)
  color rgb 0.4
  shadowless
}                                     
light_source 
{
  vaxis_rotate(<500,0,-50>,z,135)
  color rgb 0.4
  shadowless
}*/

#declare nograss=1;
#include "mountains.inc"

