// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?[esp]
//

  #include "colors.inc"
  #include "skies.inc"
  #include "shapes.inc"    
  #include "finish.inc"
  #include "glass.inc"
  #include "metals.inc"
  #include "stones.inc"
  #include "woods.inc"
  #include "textures.inc"
  #include "lens.inc"
  #include "hands.inc"
  #include "vmath.inc"  
  #include "consts.inc"  

global_settings
{
  assumed_gamma 1.0
}


#declare usekubecam = true;
#declare myclock = clock;

#macro debugf (fl,a,b)
#debug concat(str (fl,a,b),"\n")
#end

#macro debugfn (fl,a,b)
#debug str (fl,a,b)
#end

#macro debugv (vc,a,b)
#debug concat("<",str (vc.x,a,b),",",str (vc.y,a,b),",",str (vc.z,a,b),">","\n")
#end

#declare k6=floor(clock*6+0.5);
#if (usekubecam) 
    #include "kubecam.inc"
    kubecam(<0,2,0>,k6)
    debugf(k6,5,60)
    #declare myclock=0.2;
#end

#declare my_cloud3 =
pigment {
    bozo
    color_map {
        [0.0, 0.1   color red 0.85 green 0.85 blue 0.85
                    color red 0.55 green 0.60 blue 0.65]
        [0.1, 0.5   color red 0.55 green 0.60 blue 0.65
                    color rgb <0.184, 0.184, 0.209>*0.5 ]
        [0.5, 1.001 color rgb <0.184, 0.184, 0.209>*0.5
                    color rgb <0.1, 0.1, 0.1>*0.5]
    }
    turbulence 0.65
    octaves 6
    omega 0.707
    lambda 2
    scale <6, 4, 6>
}


sky_sphere {
    pigment {
        gradient y
        pigment_map {
            [0.01 rgb <0.847, 0.3, 0.1> ] // horizon
            [0.25 P_Cloud2 scale 0.25 rotate z*5]
            [0.60 my_cloud3 scale <0.25, 0.15, 0.25> rotate z*20]
        }
    }
}
//sky_sphere { S_Cloud1 }

sphere { <0,0,0>, 100000 hollow pigment { color rgbt <0,0,0,0.4> } }

 plane { -y, -50
        texture {
		
            T_Cloud3
	    finish {ambient 0.1}
            scale 60
	
        }
    }
    plane { y, -10
        texture {
            T_Cloud2
	    finish {ambient 0.2}
            scale <90,1,600>
            translate x*300
            rotate -30*y
        }
    }


#declare lightpos=<0,20,80>;

light_source 
{
  lightpos
  color rgb 0.5 //<1,0.4,0.3>
}                                     
light_source 
{
  <0,200,0>
  color rgb 0.1
	shadowless
}                                     
//#include "mfog.inc"

#declare nograss=1;
#include "mountains.inc"



