 /******************************************************************************
 
 ModelAssimp.h

 Copyright  2012, Birger N. Andreasen 
 Please send any bugreports, comments and other issues to:
 E-Mail = bna@post10.tele.dk
 Homepage with other ROTT stuff = http://www.riseofthetriad.dk/
 
/******************************************************************************/

 




// assimp include files. These three are usually needed.
#include "assimp.hpp"	//OO version Header!
#include "aiPostProcess.h"
#include "aiScene.h"

#define MAXNUMTEX 100


class AssimpModel 
{
	public:

		AssimpModel();
		~AssimpModel();

		bool Import3DFromFile(char *Modelname, char *Modelpath);
		int  LoadGLTextures(const aiScene* scene);
		void Color4f(const struct aiColor4D *color);
		void set_float4(float f[4], float a, float b, float c, float d);
		void color4_to_float4(const struct aiColor4D *c, float f[4]);
		void apply_material(const struct aiMaterial *mtl);
		void recursive_render (const struct aiScene *sc, const struct aiNode* nd, float scale);
		void drawAiScene(const aiScene* scene);
		void FreeScenes();

		// the global Assimp scene object
		const struct aiScene* scene;
		char Modelname[256];

		int Objnb;

	private:



		// images / texture
		std::map<std::string, GLuint*> textureIdMap;	// map image filenames to textureIds
		GLuint		textureIds[MAXNUMTEX];							// pointer to texture Array

		// Create an instance of the Importer class
		Assimp::Importer importer;
/*
		GLfloat LightAmbient[]= { 0.5f, 0.5f, 0.5f, 1.0f };
		GLfloat LightDiffuse[]= { 1.0f, 1.0f, 1.0f, 1.0f };
		GLfloat LightPosition[]= { 0.0f, 0.0f, 15.0f, 1.0f };
*/
};

