#ifndef _DIRENT_H
#define _DIRENT_H       1

#include "cdefs.h"
#include <sys/types.h>
#include <limits.h>



struct dirent {
  long		d_ino;
  off_t		d_off;
  unsigned short	d_reclen;
  char		d_name[256]; /* We must not include limits.h! */
};

//#ifndef __STRICT_ANSI__
struct dirent64 {
  unsigned _int64	d_ino;//uint64_t
  _int64	d_off;//int64_t
  unsigned short	d_reclen;
  unsigned char	d_type;
  char		d_name[256];
};
//#endif

#define d_fileno	d_ino	/* Backwards compatibility.  */

#undef  _DIRENT_HAVE_D_NAMLEN
#define _DIRENT_HAVE_D_RECLEN
#define _DIRENT_HAVE_D_OFF

typedef struct __dirstream DIR;

DIR *opendir (const char *__name) ;
int closedir (DIR *__dirp) ;
struct dirent *readdir (DIR *__dirp) ;
struct dirent64 *readdir64 (DIR *__dirp) ;
void rewinddir (DIR *__dirp) ;
void seekdir (DIR *__dirp, long int __pos) ;
long int telldir (DIR *__dirp) ;

int scandir(const char *dir, struct dirent ***namelist,
      int (*selection)(const struct dirent *),
      int (*compar)(const struct dirent **, const struct dirent **)) ;
int scandir64(const char *dir, struct dirent64 ***namelist,
      int (*selection)(const struct dirent64 *),
      int (*compar)(const struct dirent64 **, const struct dirent64 **)) ;

int alphasort(const struct dirent **a, const struct dirent **b) ;
int alphasort64(const struct dirent64 **a, const struct dirent64 **b);

#define MAXNAMLEN NAME_MAX

#ifdef _BSD_SOURCE
extern int dirfd(DIR *dirp) 
#endif

#if defined _FILE_OFFSET_BITS && _FILE_OFFSET_BITS == 64
#define dirent dirent64
#define readdir readdir64
#define scandir scandir64
#define alphasort alphasort64
#endif



#endif

