

#ifndef libjsmidi_h
#define libjsmidi_h

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef unsigned long ui32;
typedef signed long si32;
typedef unsigned short ui16;
typedef signed short si16;
typedef unsigned char ui8;
typedef signed char si8;

typedef int (*jsmreadfunc)(void* fil, void* buf, size_t amt);
typedef int (*jsmwritefunc)(void* fil, void* buf, size_t amt);
typedef int (*jsmseekfunc)(void* fil, long offset, int whence);
typedef void (*jsmclosefunc)(void* fil);

typedef struct {
    jsmreadfunc read;
    jsmwritefunc write;
    jsmseekfunc seek;
    jsmclosefunc close;
    void* fil;
} jsmio;

typedef struct {
    ui32 miditime;
    ui32 millistime;
    si16 track;
    ui8 status;
    ui8 metanum;
    ui16 len;
    union {
	ui8 sdata[3]; // for short messages
	ui8* pdata; // for sysex, meta
    };
} jsmevent;

typedef struct {
    int divis;
    int numtracks;
    ui32 evtcap;
    ui32 numevents;
    jsmevent* events;
} midifile;

#ifdef __cplusplus
extern "C" {
#endif
#if 0
} // to fool Emacs
#endif

extern jsmio* jsm_io_from_file(char* fname, char* mode);

extern midifile* jsm_readmidi(jsmio* io, int autoclose);
#define jsm_readmidi_file(fname) jsm_readmidi(jsm_io_from_file(fname,"rb"),1)
#define jsm_readmidi_io(io) jsm_readmidi(io,0)

extern void jsm_writemidi(jsmio* io, int autoclose, midifile* midi);
#define jsm_writemidi_file(fname,midi) jsm_writemidi(jsm_io_from_file(fname,"wb"),1,midi)
#define jsm_writemidi_io(io,midi) jsm_writemidi(io,0,midi)


extern int jsm_get_channel(jsmevent* evt);
extern void jsm_freemidi(midifile* mf);
extern jsmio* jsm_io_read_mem(ui8* buf, int length);
extern jsmio* jsm_io_write_mem(ui8** buf, ui32* length, int icapacity);

extern midifile* jsm_newmidi(int numtracks, int divis, int initcap);
extern void jsm_addevent(midifile* mf, jsmevent* evt);
extern void jsm_setcapacity(midifile* mf, int newcap);
extern void jsm_sortevents(midifile* mf);

extern void jsm_makenoteon(jsmevent* evt, ui32 time, int track, int channel, int note, int vol);
extern void jsm_makenoteoff(jsmevent* evt, ui32 time, int track, int channel, int note);
extern void jsm_makepitchbend(jsmevent* evt, ui32 time, int track, int channel, int bend);
extern void jsm_makeprogramchange(jsmevent* evt, ui32 time, int track, int channel, int inst);
extern void jsm_makecontrolchange(jsmevent* evt, ui32 time, int track, int channel, int num, int val);
extern void jsm_makemeta(jsmevent* evt, ui32 time, int track, int num, const void* buf, int len);
extern void jsm_makemetanum(jsmevent* evt, ui32 time, int track, int num, int val, int len);
extern void jsm_makemetastr(jsmevent* evt, ui32 time, int track, int num, const char* buf);



#ifdef __cplusplus
}
#endif

#endif /* ndef libjsmidi_h */
