
#ifdef PLATFORM_UNIX
#define TIME(code) 								\
    {										\
	timer t;								\
	BeginTimer(&t);								\
	code;									\
	int micros=EndTimer(&t);						\
	double fps=1000000.0/micros;						\
	static int line=0;							\
	DebugAt(&line,#code ": [ %d us, %f fps ]",micros,fps);			\
    }

#define BEGIN(var)				\
	timer var;				\
	BeginTimer(&var);

#define REPORT(var,text, ...)								\
	{										\
	int micros=EndTimer(&var);							\
	double fps=1000000.0/micros;							\
	static int var##_line=0;							\
	DebugAt(&var##_line,text ": [ %d us, %f fps ]", ##__VA_ARGS__ ,micros,fps);	\
	} 

void DebugAt(int* line, char* format, ...);
#else
#define TIME(code) code
#define NTIME(code) code
#define BEGIN(var)	      
#define REPORT(var,text)
#define DebugAt(line, format);

//typedef int timer;

#endif

#define NTIME(code) code
#define NREPORT(var,text)
