

#pragma once

#define SAMPLESIZE 16000 
#define NBOFSNDBUFFERS 16
#define MAXCHANNELS 20

typedef struct {

    WORD  wFormatTag;         // Format category
    WORD  wChannels;          // Number of channels
    DWORD dwSamplesPerSec;    // Sampling rate
    DWORD dwAvgBytesPerSec;   // For buffer estimation
    WORD  wBlockAlign;        // Data block size
    WORD  wBitsPerSample;    

} WAVE_FILE_HEADER, *PWAVE_FILE_HEADER;

typedef struct {
    
    UCHAR IdentifierString[4];
    DWORD dwLength;

} RIFF_CHUNK, *PRIFF_CHUNK;


typedef struct WaveSample {

     UINT Index;
     UINT Size;
     WAVEFORMATEX WaveFormatEx;
     char *pSampleData;

} WAVESAMPLE, *PWAVESAMPLE;
 

typedef struct {
     
     HWAVEOUT hWaveOut;
     WAVESAMPLE WaveSample;
     WAVEHDR WaveHeader[NBOFSNDBUFFERS];
     char AudioBuffer[NBOFSNDBUFFERS][SAMPLESIZE];
     BOOL bPaused;

} WAVELIB, *PWAVE;

typedef struct
{
	PWAVE pWave;

}pWaveChannel_t;



//UINT WS_PlayRottSound(int sndnum, char *SndInMem, int size, BOOL bLoop, int angle, int distance, int pitch);
//char* WS_ConvertVOCtoWAV(char *data, int size);
char* WS_ConvertVOCtoWAV(char *data, int sndnum, int size);
BOOL WS_SoundActive(int sndnum);


